/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import javax.transaction.Transactional;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import jeeves.xlink.Processor;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.domain.MetadataDataInfo_;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.MetadataFileUpload_;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.User;
import org.fao.geonet.events.history.RecordDeletedEvent;
import org.fao.geonet.events.md.MetadataPreRemove;
import org.fao.geonet.exceptions.UnAuthorizedException;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.HarvestInfoProvider;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.search.index.BatchOpsMetadataReindexer;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.repository.MetadataRatingByIpRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.PathSpec;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.UserSavedSelectionRepository;
import org.fao.geonet.repository.specification.MetadataFileUploadSpecs;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.TransactionStatus;

public class BaseMetadataManager
implements IMetadataManager {
    private static final Logger LOGGER_DATA_MANAGER = LoggerFactory.getLogger((String)"geonetwork.datamanager");
    @Autowired
    protected IMetadataUtils metadataUtils;
    @Autowired
    private IMetadataIndexer metadataIndexer;
    @Autowired
    private IMetadataValidator metadataValidator;
    @Autowired
    private IMetadataOperations metadataOperations;
    @Autowired
    private IMetadataSchemaUtils metadataSchemaUtils;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private MetadataStatusRepository metadataStatusRepository;
    @Autowired
    private MetadataValidationRepository metadataValidationRepository;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private EsSearchManager searchManager;
    private EditLib editLib;
    @Autowired
    private MetadataRatingByIpRepository metadataRatingByIpRepository;
    @Autowired
    private MetadataFileUploadRepository metadataFileUploadRepository;
    @Autowired(required=false)
    private XmlSerializer xmlSerializer;
    @Autowired
    @Lazy
    private SettingManager settingManager;
    @Autowired
    private MetadataCategoryRepository metadataCategoryRepository;
    @Autowired(required=false)
    private HarvestInfoProvider harvestInfoProvider;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private ThesaurusManager thesaurusManager;
    @Autowired
    protected AccessManager accessManager;
    @Autowired
    private UserSavedSelectionRepository userSavedSelectionRepository;
    private static final int METADATA_BATCH_PAGE_SIZE = 50000;
    @Autowired
    private ApplicationContext _applicationContext;
    @PersistenceContext
    private EntityManager _entityManager;

    @Override
    public EditLib getEditLib() {
        return this.editLib;
    }

    @PostConstruct
    public void init() {
        this.editLib = new EditLib(this.schemaManager);
        this.metadataValidator.setMetadataManager(this);
        this.metadataUtils.setMetadataManager(this);
        this.metadataIndexer.setMetadataManager(this);
    }

    @Override
    public void init(ServiceContext context, Boolean force) throws Exception {
        try {
            this.harvestInfoProvider = context.getBean(HarvestInfoProvider.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.searchManager.init(false, Optional.empty());
    }

    public void synchronizeDbWithIndex(ServiceContext context, Boolean force, Boolean asynchronous) throws Exception {
        Map<String, String> docs = this.searchManager.getDocsChangeDate();
        ArrayList<String> toIndex = new ArrayList<String>();
        LOGGER_DATA_MANAGER.debug("INDEX CONTENT:");
        Sort sortByMetadataChangeDate = SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{Metadata_.dataInfo, MetadataDataInfo_.changeDate});
        int currentPage = 0;
        Page results = this.metadataUtils.findAllIdsAndChangeDates((Pageable)PageRequest.of((int)currentPage, (int)50000, (Sort)sortByMetadataChangeDate));
        while (results.getNumberOfElements() > 0) {
            for (Pair result : results) {
                String id = String.valueOf(result.one());
                LOGGER_DATA_MANAGER.debug("- record ({})", (Object)id);
                String idxLastChange = docs.get(id);
                if (idxLastChange == null) {
                    LOGGER_DATA_MANAGER.debug("-  will be indexed");
                    toIndex.add(id);
                    continue;
                }
                docs.remove(id);
                String lastChange = ((ISODate)result.two()).toString();
                LOGGER_DATA_MANAGER.debug("- lastChange: {}", (Object)lastChange);
                LOGGER_DATA_MANAGER.debug("- idxLastChange: {}", (Object)idxLastChange);
                if (!force.booleanValue() && idxLastChange.equalsIgnoreCase(lastChange)) continue;
                LOGGER_DATA_MANAGER.debug("-  will be indexed");
                toIndex.add(id);
            }
            results = this.metadataRepository.findIdsAndChangeDates((Pageable)PageRequest.of((int)(++currentPage), (int)50000, (Sort)sortByMetadataChangeDate));
        }
        if (toIndex.size() > 0) {
            if (asynchronous.booleanValue()) {
                Set<Integer> integerList = toIndex.stream().map(Integer::parseInt).collect(Collectors.toSet());
                new BatchOpsMetadataReindexer(context.getBean(DataManager.class), integerList).process(this.settingManager.getSiteId(), false);
            } else {
                this.metadataIndexer.batchIndexInThreadPool(context, toIndex);
            }
        }
        if (docs.size() > 0) {
            LOGGER_DATA_MANAGER.debug("INDEX HAS RECORDS THAT ARE NOT IN DB:");
        }
        for (String id : docs.keySet()) {
            this.getSearchManager().delete(String.format("+id:%s", id));
            LOGGER_DATA_MANAGER.debug("- removed record ({}) from index", (Object)id);
        }
    }

    protected EsSearchManager getSearchManager() {
        return this.searchManager;
    }

    @Override
    @Deprecated
    public void flush() {
        TransactionManager.runInTransaction("DataManager flush()", this.getApplicationContext(), TransactionManager.TransactionRequirement.CREATE_ONLY_WHEN_NEEDED, TransactionManager.CommitBehavior.ALWAYS_COMMIT, false, new TransactionTask<Object>(){

            @Override
            public Object doInTransaction(TransactionStatus transaction) throws Throwable {
                BaseMetadataManager.this._entityManager.flush();
                return null;
            }
        });
    }

    private ApplicationContext getApplicationContext() {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        return applicationContext == null ? this._applicationContext : applicationContext;
    }

    protected void deleteMetadataFromDB(ServiceContext context, String id) throws Exception {
        AbstractMetadata metadata = this.metadataUtils.findOne(Integer.valueOf(id));
        if (!this.settingManager.getValueAsBool("system/xlinkResolver/referencedDeletionAllowed") && metadata.getDataInfo().getType() == MetadataType.SUB_TEMPLATE && this.hasReferencingMetadata(context, metadata)) {
            throw new UnAuthorizedException("This template is referenced.", (Object)metadata);
        }
        this.metadataOperations.deleteMetadataOper(context, id, false);
        int intId = Integer.parseInt(id);
        this.metadataRatingByIpRepository.deleteAllById_MetadataId(intId);
        this.metadataValidationRepository.deleteAllById_MetadataId(Integer.valueOf(intId));
        this.userSavedSelectionRepository.deleteAllByUuid(this.metadataUtils.getMetadataUuid(id));
        PathSpec<MetadataFileUpload, String> deletedDatePathSpec = new PathSpec<MetadataFileUpload, String>(){

            public javax.persistence.criteria.Path<String> getPath(Root<MetadataFileUpload> root) {
                return root.get(MetadataFileUpload_.deletedDate);
            }
        };
        this.metadataFileUploadRepository.createBatchUpdateQuery((PathSpec)deletedDatePathSpec, (Object)new ISODate().toString(), MetadataFileUploadSpecs.isNotDeletedForMetadata((int)intId));
        this.getXmlSerializer().delete(id, context);
    }

    private XmlSerializer getXmlSerializer() {
        return this.xmlSerializer;
    }

    @Override
    public void deleteMetadata(ServiceContext context, String metadataId) throws Exception {
        AbstractMetadata findOne = this.metadataUtils.findOne(metadataId);
        if (findOne != null) {
            boolean isMetadata = findOne.getDataInfo().getType() == MetadataType.METADATA;
            this.deleteMetadataFromDB(context, metadataId);
        }
        this.getSearchManager().delete(String.format("+id:%s", metadataId));
    }

    @Override
    public void purgeMetadata(ServiceContext context, String metadataId, boolean withBackup) throws Exception {
        AbstractMetadata metadata = this.metadataUtils.findOne(metadataId);
        Store store = context.getBean("resourceStore", Store.class);
        MetadataPreRemove preRemoveEvent = new MetadataPreRemove(metadata);
        ApplicationContextHolder.get().publishEvent((ApplicationEvent)preRemoveEvent);
        if (metadata.getDataInfo().getType() != MetadataType.SUB_TEMPLATE && metadata.getDataInfo().getType() != MetadataType.TEMPLATE_OF_SUB_TEMPLATE && withBackup) {
            MEFLib.backupRecord(metadata, context);
        }
        boolean approved = true;
        if (metadata instanceof MetadataDraft) {
            approved = false;
        }
        store.delResources(context, metadata.getUuid(), approved);
        RecordDeletedEvent recordDeletedEvent = new RecordDeletedEvent(Integer.valueOf(metadata.getId()), metadata.getUuid(), new LinkedHashMap(), Integer.valueOf(context.getUserSession().getUserIdAsInt()), metadata.getData());
        this.deleteMetadata(context, metadataId);
        recordDeletedEvent.publish((ApplicationContext)ApplicationContextHolder.get());
    }

    @Override
    public void deleteMetadataGroup(ServiceContext context, String metadataId) throws Exception {
        this.deleteMetadataFromDB(context, metadataId);
        this.getSearchManager().delete(String.format("+id:%s", metadataId));
    }

    @Override
    public String createMetadata(ServiceContext context, String templateId, String groupOwner, String source, int owner, String parentUuid, String isTemplate, boolean fullRightsForGroup) throws Exception {
        return this.createMetadata(context, templateId, groupOwner, source, owner, parentUuid, isTemplate, fullRightsForGroup, UUID.randomUUID().toString());
    }

    @Override
    public String createMetadata(ServiceContext context, String templateId, String groupOwner, String source, int owner, String parentUuid, String isTemplate, boolean fullRightsForGroup, String uuid) throws Exception {
        AbstractMetadata templateMetadata = this.metadataUtils.findOne(templateId);
        if (templateMetadata == null) {
            throw new IllegalArgumentException("Template id not found : " + templateId);
        }
        String schema = templateMetadata.getDataInfo().getSchemaId();
        String data = templateMetadata.getData();
        data = this.updateMetadataUuidReferences(data, templateMetadata.getUuid(), uuid);
        Element xml = Xml.loadString((String)data, (boolean)false);
        boolean isMetadata = templateMetadata.getDataInfo().getType() == MetadataType.METADATA;
        MetadataType type = MetadataType.lookup((String)isTemplate);
        this.setMetadataTitle(schema, xml, context.getLanguage(), !isMetadata);
        if (isMetadata) {
            xml = this.updateFixedInfo(schema, (com.google.common.base.Optional<Integer>)com.google.common.base.Optional.absent(), uuid, xml, parentUuid, UpdateDatestamp.NO, context);
            xml = this.duplicateMetadata(schema, xml, context);
        } else if (type == MetadataType.SUB_TEMPLATE || type == MetadataType.TEMPLATE_OF_SUB_TEMPLATE) {
            xml.setAttribute("uuid", uuid);
        }
        Metadata newMetadata = new Metadata();
        newMetadata.setUuid(uuid);
        newMetadata.getDataInfo().setChangeDate(new ISODate()).setCreateDate(new ISODate()).setSchemaId(schema).setRoot(templateMetadata.getDataInfo().getRoot()).setType(type).setRoot(xml.getQualifiedName());
        newMetadata.getSourceInfo().setGroupOwner(Integer.valueOf(groupOwner)).setOwner(Integer.valueOf(owner)).setSourceId(source);
        Optional group = this.groupRepository.findById((Object)Integer.valueOf(groupOwner));
        if (group.isPresent() && ((Group)group.get()).getDefaultCategory() != null) {
            newMetadata.getMetadataCategories().add(((Group)group.get()).getDefaultCategory());
        }
        Collection filteredCategories = Collections2.filter((Collection)templateMetadata.getCategories(), (Predicate)new Predicate<MetadataCategory>(){

            public boolean apply(@Nullable MetadataCategory input) {
                return input != null;
            }
        });
        newMetadata.getMetadataCategories().addAll(filteredCategories);
        int finalId = this.insertMetadata(context, (AbstractMetadata)newMetadata, xml, IndexingMode.full, true, UpdateDatestamp.YES, fullRightsForGroup, true).getId();
        return String.valueOf(finalId);
    }

    private String updateMetadataUuidReferences(String data, String oldUuid, String newUuid) {
        return data.replace(oldUuid, newUuid);
    }

    private void setMetadataTitle(String schema, Element xml, String language, boolean fromTemplate) {
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(language));
        SchemaPlugin schemaPlugin = SchemaManager.getSchemaPlugin(schema);
        List xpathTitle = schemaPlugin.getXpathTitle();
        if (xpathTitle != null) {
            xpathTitle.forEach(path -> {
                List titleNodes = null;
                try {
                    titleNodes = Xml.selectNodes((Element)xml, (String)path, new ArrayList(schemaPlugin.getNamespaces()));
                    for (Object o : titleNodes) {
                        if (!(o instanceof Element)) continue;
                        Element title = (Element)o;
                        title.setText(String.format(messages.getString("metadata.title.createdFrom" + (fromTemplate ? "Template" : "Record")), title.getTextTrim(), ZonedDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME)));
                    }
                }
                catch (JDOMException e) {
                    LOGGER_DATA_MANAGER.debug("Check xpath '{}' for schema plugin '{}'. Error is '{}'.", new Object[]{path, schema, e.getMessage()});
                }
            });
        }
    }

    @Override
    public String insertMetadata(ServiceContext context, String schema, Element metadataXml, String uuid, int owner, String groupOwner, String source, String metadataType, String docType, String category, String createDate, String changeDate, boolean ufo, IndexingMode indexingMode) throws Exception {
        Optional group;
        if (source == null) {
            source = this.settingManager.getSiteId();
        }
        if (StringUtils.isBlank((String)metadataType)) {
            metadataType = MetadataType.METADATA.codeString;
        }
        Metadata newMetadata = new Metadata();
        newMetadata.setUuid(uuid);
        ISODate isoChangeDate = changeDate != null ? new ISODate(changeDate) : new ISODate();
        ISODate isoCreateDate = createDate != null ? new ISODate(createDate) : new ISODate();
        newMetadata.getDataInfo().setChangeDate(isoChangeDate).setCreateDate(isoCreateDate).setSchemaId(schema).setDoctype(docType).setRoot(metadataXml.getQualifiedName()).setType(MetadataType.lookup((String)metadataType));
        newMetadata.getSourceInfo().setOwner(Integer.valueOf(owner)).setSourceId(source);
        if (StringUtils.isNotEmpty((String)groupOwner)) {
            newMetadata.getSourceInfo().setGroupOwner(Integer.valueOf(groupOwner));
        }
        if (StringUtils.isNotEmpty((String)category)) {
            MetadataCategory metadataCategory = this.metadataCategoryRepository.findOneByName(category);
            if (metadataCategory == null) {
                throw new IllegalArgumentException("No category found with name: " + category);
            }
            newMetadata.getMetadataCategories().add(metadataCategory);
        } else if (StringUtils.isNotEmpty((String)groupOwner) && (group = this.groupRepository.findById((Object)Integer.valueOf(groupOwner))).isPresent() && ((Group)group.get()).getDefaultCategory() != null) {
            newMetadata.getMetadataCategories().add(((Group)group.get()).getDefaultCategory());
        }
        boolean fullRightsForGroup = false;
        int finalId = this.insertMetadata(context, (AbstractMetadata)newMetadata, metadataXml, indexingMode, ufo, UpdateDatestamp.NO, fullRightsForGroup, true).getId();
        return String.valueOf(finalId);
    }

    @Override
    public AbstractMetadata insertMetadata(ServiceContext context, AbstractMetadata newMetadata, Element metadataXml, IndexingMode indexingMode, boolean updateFixedInfo, UpdateDatestamp updateDatestamp, boolean fullRightsForGroup, boolean forceRefreshReaders) throws Exception {
        String schema = newMetadata.getDataInfo().getSchemaId();
        String mdImportSetting = this.settingManager.getValue("metadata/import/restrict");
        if (mdImportSetting != null) {
            mdImportSetting = mdImportSetting.replace(" ", "");
        }
        if (!(StringUtils.isBlank((String)mdImportSetting) || newMetadata.getHarvestInfo().isHarvested() || Arrays.asList(mdImportSetting.split(",")).contains(schema))) {
            throw new IllegalArgumentException("The system setting 'metadata/import/restrict' doesn't allow to import " + schema + " metadata records (they can still be harvested). Apply an import stylesheet to convert file to one of the allowed schemas: " + mdImportSetting);
        }
        this.setNamespacePrefixUsingSchemas(schema, metadataXml);
        if (updateFixedInfo && newMetadata.getDataInfo().getType() == MetadataType.METADATA) {
            String parentUuid = null;
            metadataXml = this.updateFixedInfo(schema, (com.google.common.base.Optional<Integer>)com.google.common.base.Optional.absent(), newMetadata.getUuid(), metadataXml, parentUuid, updateDatestamp, context);
        }
        AbstractMetadata savedMetadata = this.getXmlSerializer().insert(newMetadata, metadataXml, context);
        String stringId = String.valueOf(savedMetadata.getId());
        String groupId = null;
        Integer groupIdI = newMetadata.getSourceInfo().getGroupOwner();
        if (groupIdI != null) {
            groupId = String.valueOf(groupIdI);
        }
        this.metadataOperations.copyDefaultPrivForGroup(context, stringId, groupId, fullRightsForGroup);
        if (indexingMode != IndexingMode.none) {
            this.metadataIndexer.indexMetadata(stringId, forceRefreshReaders, indexingMode);
        }
        return savedMetadata;
    }

    @Override
    public Element getMetadata(ServiceContext srvContext, String id, boolean forEditing, boolean applyOperationsFilters, boolean withEditorValidationErrors, boolean keepXlinkAttributes) throws Exception {
        boolean doXLinks = this.getXmlSerializer().resolveXLinks();
        Element metadataXml = this.getXmlSerializer().selectNoXLinkResolver(id, false, applyOperationsFilters);
        if (metadataXml == null) {
            return null;
        }
        String version = null;
        if (forEditing) {
            if (doXLinks) {
                Processor.processXLink(metadataXml, srvContext);
            }
            String schema = this.metadataSchemaUtils.getMetadataSchema(id);
            metadataXml = this.inflateMetadata(metadataXml, schema, srvContext.getLanguage());
            if (withEditorValidationErrors) {
                Pair<Element, String> versionAndReport = this.metadataValidator.doValidate(srvContext.getUserSession(), schema, id, metadataXml, srvContext.getLanguage(), forEditing);
                version = (String)versionAndReport.two();
                metadataXml.addContent((Content)versionAndReport.one());
            } else {
                this.editLib.expandElements(schema, metadataXml);
                version = this.editLib.getVersionForEditing(schema, id, metadataXml);
            }
        } else if (doXLinks) {
            if (keepXlinkAttributes) {
                Processor.processXLink(metadataXml, srvContext);
            } else {
                Processor.detachXLink(metadataXml, srvContext);
            }
        }
        metadataXml.addNamespaceDeclaration(Edit.NAMESPACE);
        Element info = this.buildInfoElem(srvContext, id, version);
        metadataXml.addContent((Content)info);
        metadataXml.detach();
        return metadataXml;
    }

    @Override
    public Element getMetadata(String id) throws Exception {
        Element md = this.getXmlSerializer().selectNoXLinkResolver(id, false, true);
        if (md == null) {
            return null;
        }
        md.detach();
        return md;
    }

    @Override
    public synchronized void updateMetadataOwner(int id, final String owner, final String groupOwner) throws Exception {
        this.metadataRepository.update((Serializable)Integer.valueOf(id), (Updater)new Updater<Metadata>(){

            public void apply(@Nonnull Metadata entity) {
                entity.getSourceInfo().setGroupOwner(Integer.valueOf(groupOwner));
                entity.getSourceInfo().setOwner(Integer.valueOf(owner));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AbstractMetadata updateMetadata(ServiceContext context, String metadataId, Element md, boolean validate, boolean ufo, String lang, String changeDate, boolean updateDateStamp, IndexingMode indexingMode) throws Exception {
        block10: {
            block11: {
                Log.trace((String)"geonetwork.datamanager", (Object)("Update record with id " + metadataId));
                Element metadataXml = md;
                UserSession session = context.getUserSession();
                if (session != null) {
                    session.removeProperty("validation.report" + metadataId);
                }
                String schema = this.metadataSchemaUtils.getMetadataSchema(metadataId);
                AbstractMetadata metadata = this.metadataUtils.findOne(metadataId);
                if (updateDateStamp) {
                    if (StringUtils.isEmpty((String)changeDate)) {
                        changeDate = new ISODate().toString();
                        metadata.getDataInfo().setChangeDate(new ISODate());
                    } else {
                        metadata.getDataInfo().setChangeDate(new ISODate(changeDate));
                    }
                }
                String uuidBeforeUfo = null;
                if (ufo) {
                    String parentUuid = null;
                    Integer intId = Integer.valueOf(metadataId);
                    uuidBeforeUfo = this.findUuid(metadataXml, schema, metadata);
                    metadataXml = this.updateFixedInfo(schema, (com.google.common.base.Optional<Integer>)com.google.common.base.Optional.of((Object)intId), uuidBeforeUfo, metadataXml, parentUuid, updateDateStamp ? UpdateDatestamp.YES : UpdateDatestamp.NO, context);
                }
                this.setNamespacePrefixUsingSchemas(schema, metadataXml);
                String uuid = this.findUuid(metadataXml, schema, metadata);
                this.metadataUtils.checkMetadataWithSameUuidExist(uuid, metadata.getId());
                this.getXmlSerializer().update(metadataId, metadataXml, changeDate, updateDateStamp, uuid, context);
                try {
                    if (session != null && validate) {
                        this.metadataValidator.doValidate(session, schema, metadataId, metadataXml, lang, false);
                    }
                    if (indexingMode == IndexingMode.none) break block10;
                    if (uuidBeforeUfo == null || uuidBeforeUfo.equals(uuid)) break block11;
                }
                catch (Throwable throwable) {
                    if (indexingMode != IndexingMode.none) {
                        if (uuidBeforeUfo != null && !uuidBeforeUfo.equals(uuid)) {
                            this.getSearchManager().delete(String.format("+uuid:\"%s\"", uuidBeforeUfo));
                        }
                        this.metadataIndexer.indexMetadata(metadataId, true, indexingMode);
                    }
                    throw throwable;
                }
                this.getSearchManager().delete(String.format("+uuid:\"%s\"", uuidBeforeUfo));
            }
            this.metadataIndexer.indexMetadata(metadataId, true, indexingMode);
        }
        Log.trace((String)"geonetwork.datamanager", (Object)("Finishing update of record with id " + metadataId));
        return this.metadataUtils.findOne(metadataId);
    }

    private String findUuid(Element metadataXml, String schema, AbstractMetadata metadata) throws Exception {
        String uuid = null;
        if (this.schemaManager.getSchema(schema).isReadwriteUUID() && metadata.getDataInfo().getType() != MetadataType.SUB_TEMPLATE && metadata.getDataInfo().getType() != MetadataType.TEMPLATE_OF_SUB_TEMPLATE) {
            uuid = this.metadataUtils.extractUUID(schema, metadataXml);
        }
        return uuid;
    }

    private Element buildInfoElem(ServiceContext context, String id, String version) throws Exception {
        Object group;
        AbstractMetadata metadata = this.metadataUtils.findOne(id);
        MetadataDataInfo dataInfo = metadata.getDataInfo();
        String schema = dataInfo.getSchemaId();
        String createDate = dataInfo.getCreateDate().getDateAndTime();
        String changeDate = dataInfo.getChangeDate().getDateAndTime();
        String source = metadata.getSourceInfo().getSourceId();
        String isTemplate = dataInfo.getType().codeString;
        String title = dataInfo.getTitle();
        String uuid = metadata.getUuid();
        String isHarvested = "" + Constants.toYN_EnabledChar((boolean)metadata.getHarvestInfo().isHarvested());
        String harvestUuid = metadata.getHarvestInfo().getUuid();
        String popularity = "" + dataInfo.getPopularity();
        String rating = "" + dataInfo.getRating();
        String owner = "" + metadata.getSourceInfo().getOwner();
        Integer groupOwner = metadata.getSourceInfo().getGroupOwner();
        String displayOrder = "" + dataInfo.getDisplayOrder();
        Element info = new Element("info", Edit.NAMESPACE);
        BaseMetadataManager.addElement(info, "id", id);
        BaseMetadataManager.addElement(info, "schema", schema);
        BaseMetadataManager.addElement(info, "createDate", createDate);
        BaseMetadataManager.addElement(info, "changeDate", changeDate);
        BaseMetadataManager.addElement(info, "isTemplate", isTemplate);
        BaseMetadataManager.addElement(info, "title", title);
        BaseMetadataManager.addElement(info, "source", source);
        BaseMetadataManager.addElement(info, "uuid", uuid);
        BaseMetadataManager.addElement(info, "isHarvested", isHarvested);
        BaseMetadataManager.addElement(info, "popularity", popularity);
        BaseMetadataManager.addElement(info, "rating", rating);
        BaseMetadataManager.addElement(info, "displayOrder", displayOrder);
        if (metadata.getHarvestInfo().isHarvested() && this.harvestInfoProvider != null) {
            info.addContent((Content)this.harvestInfoProvider.getHarvestInfo(harvestUuid, id, uuid));
        }
        if (version != null) {
            BaseMetadataManager.addElement(info, "version", version);
        }
        HashMap map = Maps.newHashMap();
        map.put(id, info);
        this.buildPrivilegesMetadataInfo(context, map);
        Optional user = this.userRepository.findById((Object)Integer.parseInt(owner));
        if (user.isPresent()) {
            BaseMetadataManager.addElement(info, "ownerId", ((User)user.get()).getId());
            String ownerName = ((User)user.get()).getName();
            BaseMetadataManager.addElement(info, "ownername", ownerName);
        }
        if (groupOwner != null && ((Optional)(group = this.groupRepository.findById((Object)groupOwner))).isPresent()) {
            String groupOwnerName = ((Group)((Optional)group).get()).getName();
            BaseMetadataManager.addElement(info, "groupOwnerName", groupOwnerName);
        }
        for (MetadataCategory category : metadata.getCategories()) {
            BaseMetadataManager.addElement(info, "category", category.getName());
        }
        List validationInfo = this.metadataValidationRepository.findAllById_MetadataId(Integer.parseInt(id));
        if (validationInfo == null || validationInfo.size() == 0) {
            BaseMetadataManager.addElement(info, "valid", "-1");
        } else {
            String isValid = "1";
            for (Object elem : validationInfo) {
                MetadataValidation vi = (MetadataValidation)elem;
                String type = vi.getId().getValidationType();
                if (!vi.isValid()) {
                    isValid = "0";
                }
                String ratio = "xsd".equals(type) ? "" : vi.getNumFailures() + "/" + vi.getNumTests();
                info.addContent((Content)new Element("valid_details").addContent((Content)new Element("type").setText(type)).addContent((Content)new Element("status").setText(vi.isValid() ? "1" : "0").addContent((Content)new Element("ratio").setText(ratio))));
            }
            BaseMetadataManager.addElement(info, "valid", isValid);
        }
        SettingInfo si = new SettingInfo();
        BaseMetadataManager.addElement(info, "baseUrl", si.getSiteUrl() + context.getBaseUrl());
        BaseMetadataManager.addElement(info, "locService", "/srv/en");
        return info;
    }

    @Override
    public Element updateFixedInfo(String schema, com.google.common.base.Optional<Integer> metadataId, String uuid, Element md, String parentUuid, UpdateDatestamp updateDatestamp, ServiceContext context) throws Exception {
        boolean autoFixing = this.settingManager.getValueAsBool("system/autofixing/enable", true);
        if (autoFixing) {
            LOGGER_DATA_MANAGER.debug("Autofixing is enabled, trying update-fixed-info (updateDatestamp: {})", (Object)updateDatestamp.name());
            AbstractMetadata metadata = null;
            if (metadataId.isPresent()) {
                metadata = this.metadataUtils.findOne((Integer)metadataId.get());
            }
            String currentUuid = metadata != null ? metadata.getUuid() : null;
            String id = metadata != null ? metadata.getId() + "" : null;
            uuid = uuid == null ? currentUuid : uuid;
            Element env = new Element("env");
            env.addContent((Content)new Element("id").setText(id));
            env.addContent((Content)new Element("uuid").setText(uuid));
            env.addContent((Content)this.thesaurusManager.buildResultfromThTable(context));
            Element schemaLoc = new Element("schemaLocation");
            schemaLoc.setAttribute(this.schemaManager.getSchemaLocation(schema, context));
            env.addContent((Content)schemaLoc);
            env.addContent((Content)new Element("newRecord").setText(String.valueOf(metadata == null)));
            if (updateDatestamp == UpdateDatestamp.YES) {
                String changeDate = new ISODate().toString();
                String createDate = "";
                if (metadata != null) {
                    changeDate = metadata.getDataInfo().getChangeDate().getDateAndTime();
                    createDate = metadata.getDataInfo().getCreateDate().getDateAndTime();
                } else {
                    createDate = new ISODate().toString();
                }
                env.addContent((Content)new Element("changeDate").setText(changeDate));
                env.addContent((Content)new Element("createDate").setText(createDate));
            }
            if (parentUuid != null) {
                env.addContent((Content)new Element("parentUuid").setText(parentUuid));
            }
            if (metadataId.isPresent()) {
                Path resourceDir = Lib.resource.getDir("private", (Integer)metadataId.get());
                env.addContent((Content)new Element("datadir").setText(resourceDir.toString()));
            }
            Element elUser = new Element("user");
            UserSession usrSess = context.getUserSession();
            if (usrSess.isAuthenticated()) {
                String myUserId = usrSess.getUserId();
                User user = ((UserRepository)this.getApplicationContext().getBean(UserRepository.class)).findOne(myUserId);
                if (user != null) {
                    Element elUserDetails = new Element("details");
                    elUserDetails.addContent((Content)new Element("surname").setText(user.getSurname()));
                    elUserDetails.addContent((Content)new Element("firstname").setText(user.getName()));
                    elUserDetails.addContent((Content)new Element("organisation").setText(user.getOrganisation()));
                    elUserDetails.addContent((Content)new Element("username").setText(user.getUsername()));
                    elUser.addContent((Content)elUserDetails);
                    env.addContent((Content)elUser);
                }
            }
            Element result = new Element("root");
            md.removeNamespaceDeclaration(Geonet.Namespaces.GEONET);
            result.addContent((Content)md);
            env.addContent((Content)new Element("siteURL").setText(this.settingManager.getSiteURL(context)));
            env.addContent((Content)new Element("nodeURL").setText(this.settingManager.getNodeURL()));
            env.addContent((Content)new Element("node").setText(context.getNodeId()));
            List config = this.settingManager.getAllAsXML(true).cloneContent();
            for (Object c : config) {
                Element settings = (Element)c;
                env.addContent((Content)settings);
            }
            result.addContent((Content)env);
            Path styleSheet = this.metadataSchemaUtils.getSchemaDir(schema).resolve(metadata != null && (metadata.getDataInfo().getType() == MetadataType.SUB_TEMPLATE || metadata.getDataInfo().getType() == MetadataType.TEMPLATE_OF_SUB_TEMPLATE) ? "update-fixed-info-subtemplate.xsl" : "update-fixed-info.xsl");
            result = Xml.transform((Element)result, (Path)styleSheet);
            return result;
        }
        LOGGER_DATA_MANAGER.debug("Autofixing is disabled, not applying update-fixed-info");
        return md;
    }

    @Override
    public Set<String> updateChildren(ServiceContext srvContext, String parentUuid, String[] children, Map<String, Object> params) throws Exception {
        String parentId = (String)params.get("id");
        String parentSchema = (String)params.get("schema");
        boolean forEditing = false;
        boolean withValidationErrors = false;
        boolean keepXlinkAttributes = false;
        Element parent = this.getMetadata(srvContext, parentId, forEditing, false, withValidationErrors, keepXlinkAttributes);
        Element env = new Element("update");
        env.addContent((Content)new Element("parentUuid").setText(parentUuid));
        env.addContent((Content)new Element("siteURL").setText(this.settingManager.getSiteURL(srvContext)));
        env.addContent((Content)new Element("parent").addContent((Content)parent));
        HashSet<String> untreatedChildSet = new HashSet<String>();
        for (String childId : children) {
            if (!this.accessManager.canEdit(srvContext, childId)) {
                untreatedChildSet.add(childId);
                LOGGER_DATA_MANAGER.debug("Could not update child ({}) because of privileges.", (Object)childId);
                continue;
            }
            Element child = this.getMetadata(srvContext, childId, forEditing, false, withValidationErrors, keepXlinkAttributes);
            String childSchema = child.getChild("info", Edit.NAMESPACE).getChildText("schema");
            if (!childSchema.equals(parentSchema)) {
                untreatedChildSet.add(childId);
                LOGGER_DATA_MANAGER.debug("Could not update child ({}) because schema ({}) is different from the parent one ({}).", new Object[]{childId, childSchema, parentSchema});
                continue;
            }
            LOGGER_DATA_MANAGER.debug("Updating child ({}) ...", (Object)childId);
            Element rootEl = new Element("root");
            Element childEl = new Element("child").addContent(child.detach());
            rootEl.addContent((Content)childEl);
            rootEl.addContent(env.detach());
            Path styleSheet = this.metadataSchemaUtils.getSchemaDir(parentSchema).resolve("update-child-from-parent-info.xsl");
            Element childForUpdate = Xml.transform((Element)rootEl, (Path)styleSheet, params);
            this.getXmlSerializer().update(childId, childForUpdate, new ISODate().toString(), true, null, srvContext);
            rootEl = null;
        }
        return untreatedChildSet;
    }

    @Override
    public void buildPrivilegesMetadataInfo(ServiceContext context, Map<String, Element> mdIdToInfoMap) throws Exception {
        Collection metadataIds = Collections2.transform(mdIdToInfoMap.keySet(), (Function)new Function<String, Integer>(){

            @Nullable
            public Integer apply(String input) {
                return Integer.valueOf(input);
            }
        });
        Specification operationAllowedSpec = OperationAllowedSpecs.hasMetadataIdIn((Collection)metadataIds);
        Set<Integer> allUserGroups = this.accessManager.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
        SetMultimap<Integer, ReservedOperation> operationsPerMetadata = this.loadOperationsAllowed(context, (Specification<OperationAllowed>)Specification.where((Specification)operationAllowedSpec).and(OperationAllowedSpecs.hasGroupIdIn(allUserGroups)));
        Set visibleToAll = this.loadOperationsAllowed(context, (Specification<OperationAllowed>)Specification.where((Specification)operationAllowedSpec).and(OperationAllowedSpecs.isPublic((ReservedOperation)ReservedOperation.view))).keySet();
        Set downloadableByGuest = this.loadOperationsAllowed(context, (Specification<OperationAllowed>)Specification.where((Specification)operationAllowedSpec).and(OperationAllowedSpecs.hasGroupId((int)ReservedGroup.guest.getId())).and(OperationAllowedSpecs.hasOperation((ReservedOperation)ReservedOperation.download))).keySet();
        Map<Integer, MetadataSourceInfo> allSourceInfo = this.findAllSourceInfo((Specification<? extends AbstractMetadata>)MetadataSpecs.hasMetadataIdIn((Collection)metadataIds));
        for (Map.Entry<String, Element> entry : mdIdToInfoMap.entrySet()) {
            boolean isOwner;
            Element infoEl = entry.getValue();
            Integer mdId = Integer.valueOf(entry.getKey());
            MetadataSourceInfo sourceInfo = allSourceInfo.get(mdId);
            HashSet operations = operationsPerMetadata.get((Object)mdId);
            if (operations == null) {
                operations = Collections.emptySet();
            }
            if (isOwner = this.accessManager.isOwner(context, sourceInfo)) {
                operations = Sets.newHashSet(Arrays.asList(ReservedOperation.values()));
            }
            if (isOwner || operations.contains(ReservedOperation.editing)) {
                BaseMetadataManager.addElement(infoEl, "edit", "true");
            }
            if (isOwner) {
                BaseMetadataManager.addElement(infoEl, "owner", "true");
            }
            BaseMetadataManager.addElement(infoEl, "isPublishedToAll", visibleToAll.contains(mdId));
            BaseMetadataManager.addElement(infoEl, ReservedOperation.view.name(), operations.contains(ReservedOperation.view));
            BaseMetadataManager.addElement(infoEl, ReservedOperation.notify.name(), operations.contains(ReservedOperation.notify));
            BaseMetadataManager.addElement(infoEl, ReservedOperation.download.name(), operations.contains(ReservedOperation.download));
            BaseMetadataManager.addElement(infoEl, ReservedOperation.dynamic.name(), operations.contains(ReservedOperation.dynamic));
            BaseMetadataManager.addElement(infoEl, ReservedOperation.featured.name(), operations.contains(ReservedOperation.featured));
            if (operations.contains(ReservedOperation.download)) continue;
            BaseMetadataManager.addElement(infoEl, "guestdownload", downloadableByGuest.contains(mdId));
        }
    }

    protected SetMultimap<Integer, ReservedOperation> loadOperationsAllowed(ServiceContext context, Specification<OperationAllowed> operationAllowedSpec) {
        OperationAllowedRepository operationAllowedRepo = context.getBean(OperationAllowedRepository.class);
        List operationsAllowed = operationAllowedRepo.findAll(operationAllowedSpec);
        HashMultimap operationsPerMetadata = HashMultimap.create();
        for (OperationAllowed allowed : operationsAllowed) {
            OperationAllowedId id = allowed.getId();
            operationsPerMetadata.put((Object)id.getMetadataId(), (Object)ReservedOperation.lookup((int)id.getOperationId()));
        }
        return operationsPerMetadata;
    }

    private void setNamespacePrefixUsingSchemas(String schema, Element md) throws Exception {
        Namespace ns = md.getNamespace();
        if (ns == Namespace.NO_NAMESPACE) {
            return;
        }
        MetadataSchema mds = this.schemaManager.getSchema(schema);
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        nsList.add(ns);
        List additionalNamespaces = md.getAdditionalNamespaces();
        nsList.addAll(additionalNamespaces);
        for (Object e : nsList) {
            Namespace aNs = (Namespace)e;
            if (!aNs.getPrefix().equals("")) continue;
            String prefix = mds.getPrefix(aNs.getURI());
            if (prefix == null) {
                LOGGER_DATA_MANAGER.warn("Metadata record contains a default namespace {} (with no prefix) which does not match any {} schema's namespaces.", (Object)aNs.getURI(), (Object)schema);
            }
            ns = Namespace.getNamespace((String)prefix, (String)aNs.getURI());
            this.metadataValidator.setNamespacePrefix(md, ns);
            if (md.getNamespace().equals((Object)ns)) continue;
            md.removeNamespaceDeclaration(aNs);
            md.addNamespaceDeclaration(ns);
        }
    }

    private Element duplicateMetadata(String schema, Element md, ServiceContext srvContext) throws Exception {
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir(schema).resolve("duplicate-metadata.xsl");
        if (Files.exists(styleSheet, new LinkOption[0])) {
            Element env = new Element("env");
            env.addContent((Content)new Element("lang").setText(srvContext.getLanguage()));
            Element result = new Element("root");
            result.addContent((Content)md);
            result.addContent((Content)env);
            result = Xml.transform((Element)result, (Path)styleSheet);
            return result;
        }
        return md;
    }

    protected static void addElement(Element root, String name, Object value) {
        root.addContent((Content)new Element(name).setText(value == null ? "" : value.toString()));
    }

    @Override
    public AbstractMetadata save(AbstractMetadata info) {
        if (info instanceof Metadata) {
            return (AbstractMetadata)this.metadataRepository.save((Object)((Metadata)info));
        }
        throw new ClassCastException("Unknown AbstractMetadata subtype: " + info.getClass().getName());
    }

    @Override
    public AbstractMetadata update(int id, @Nonnull Updater<? extends AbstractMetadata> updater) {
        try {
            return (AbstractMetadata)this.metadataRepository.update((Serializable)Integer.valueOf(id), updater);
        }
        catch (ClassCastException t) {
            throw new ClassCastException("Unknown AbstractMetadata subtype: " + updater.getClass().getName());
        }
    }

    @Override
    public void deleteAll(Specification<? extends AbstractMetadata> specs) {
        try {
            this.metadataRepository.deleteAll(specs);
        }
        catch (ClassCastException t) {
            throw new ClassCastException("Unknown AbstractMetadata subtype: " + specs.getClass().getName());
        }
    }

    @Override
    @Transactional
    public void delete(Integer id) {
        Log.trace((String)"geonetwork.datamanager", (Object)("Deleting record with id " + id));
        if (this.metadataRepository.existsById((Object)id)) {
            this.metadataRepository.deleteById((Object)id);
        }
    }

    @Override
    public void createBatchUpdateQuery(PathSpec<? extends AbstractMetadata, String> servicesPath, String newUuid, Specification<? extends AbstractMetadata> harvested) {
        try {
            this.metadataRepository.createBatchUpdateQuery(servicesPath, (Object)newUuid, harvested);
        }
        catch (ClassCastException t) {
            throw new ClassCastException("Unknown AbstractMetadata subtype: " + servicesPath.getClass().getName());
        }
    }

    @Override
    public Map<Integer, MetadataSourceInfo> findAllSourceInfo(Specification<? extends AbstractMetadata> specs) {
        try {
            return this.metadataRepository.findSourceInfo(specs);
        }
        catch (ClassCastException t) {
            throw new ClassCastException("Unknown AbstractMetadata subtype: " + specs.getClass().getName());
        }
    }

    @Override
    public boolean isValid(Integer id) {
        List validationInfo = this.metadataValidationRepository.findAllById_MetadataId(id.intValue());
        if (validationInfo == null || validationInfo.size() == 0) {
            return false;
        }
        for (Object elem : validationInfo) {
            MetadataValidation vi = (MetadataValidation)elem;
            if (vi.isValid() || !vi.isRequired().booleanValue()) continue;
            return false;
        }
        return true;
    }

    boolean hasReferencingMetadata(ServiceContext context, AbstractMetadata metadata) throws Exception {
        StringBuilder query = new StringBuilder(String.format("xlink:*%s*", metadata.getUuid()));
        return this.searchManager.query((String)query.toString(), null, (int)0, (int)0).getHits().getTotalHits().value > 0L;
    }

    @Override
    public Element inflateMetadata(Element metadataXml, String schema, String lang) throws Exception {
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir(schema).resolve("inflate-metadata.xsl");
        if (!Files.exists(styleSheet, new LinkOption[0])) {
            return metadataXml;
        }
        Element env = new Element("env");
        env.addContent((Content)new Element("lang").setText(lang));
        Element result = new Element("root");
        result.addContent((Content)metadataXml);
        result.addContent((Content)env);
        return Xml.transform((Element)result, (Path)styleSheet);
    }
}

