/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.web.bind.support.DefaultDataBinderFactory;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;

public class SpringLocalServiceInvoker {
    public final RequestMappingHandlerMapping requestMappingHandlerMapping;
    public final RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private HandlerMethodArgumentResolverComposite argumentResolvers;
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers;
    private DefaultDataBinderFactory webDataBinderFactory;

    public SpringLocalServiceInvoker(RequestMappingHandlerMapping requestMappingHandlerMapping, RequestMappingHandlerAdapter requestMappingHandlerAdapter) {
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
    }

    public void init() {
        this.argumentResolvers = new HandlerMethodArgumentResolverComposite().addResolvers(this.requestMappingHandlerAdapter.getArgumentResolvers());
        this.returnValueHandlers = new HandlerMethodReturnValueHandlerComposite().addHandlers(this.requestMappingHandlerAdapter.getReturnValueHandlers());
        this.webDataBinderFactory = new DefaultDataBinderFactory(this.requestMappingHandlerAdapter.getWebBindingInitializer());
    }

    public Object invoke(String uri) throws Exception {
        MockHttpServletRequest request = this.prepareMockRequestFromUri(uri);
        MockHttpServletResponse response = new MockHttpServletResponse();
        return this.invoke((HttpServletRequest)request, (HttpServletResponse)response);
    }

    public Object invoke(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String checkForward;
        HandlerExecutionChain handlerExecutionChain = this.requestMappingHandlerMapping.getHandler(request);
        HandlerMethod handlerMethod = (HandlerMethod)handlerExecutionChain.getHandler();
        ServletInvocableHandlerMethod servletInvocableHandlerMethod = new ServletInvocableHandlerMethod(handlerMethod);
        servletInvocableHandlerMethod.setHandlerMethodArgumentResolvers(this.argumentResolvers);
        servletInvocableHandlerMethod.setHandlerMethodReturnValueHandlers(this.returnValueHandlers);
        servletInvocableHandlerMethod.setDataBinderFactory((WebDataBinderFactory)this.webDataBinderFactory);
        Object o = servletInvocableHandlerMethod.invokeForRequest((NativeWebRequest)new ServletWebRequest(request, response), null, new Object[0]);
        if (o instanceof String && (checkForward = (String)o).startsWith("forward:")) {
            String fwdUrl = StringUtils.substringAfter((String)checkForward, (String)"forward:");
            String lastComponent = StringUtils.substringAfterLast((String)request.getRequestURI(), (String)"/");
            if (lastComponent.length() > 0 && StringUtils.startsWith((String)fwdUrl, (String)lastComponent)) {
                return this.invoke(request.getRequestURI() + StringUtils.substringAfter((String)fwdUrl, (String)lastComponent));
            }
            return this.invoke(fwdUrl);
        }
        return o;
    }

    private MockHttpServletRequest prepareMockRequestFromUri(String uri) {
        String requestURI = uri.replace("local:/", "").split("\\?")[0];
        MockHttpServletRequest request = new MockHttpServletRequest("GET", requestURI);
        request.setSession((HttpSession)new MockHttpSession());
        String[] splits = uri.split("\\?");
        if (splits.length > 1) {
            String params = splits[1];
            for (String param : params.split("&")) {
                String[] parts = param.split("=");
                String name = parts[0];
                request.addParameter(name, parts.length == 2 ? parts[1] : "");
            }
        }
        return request;
    }
}

