/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.arcgis;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.fao.geonet.arcgis.ArcSDEConnection;
import org.fao.geonet.arcgis.ArcSDEConnectionException;
import org.fao.geonet.arcgis.ArcSDEVersionFactory;
import org.fao.geonet.utils.Log;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public abstract class ArcSDEJdbcConnection
implements ArcSDEConnection {
    private BasicDataSource dataSource;
    protected Connection jdbcConnection;
    private NamedParameterJdbcTemplate jdbcTemplate;

    public ArcSDEJdbcConnection(String driverName, String connectionString, String username, String password) {
        try {
            Log.debug((String)"geonetwork.harvester.arcsde", (Object)"Getting ArcSDE connection (via JDBC)");
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName(driverName);
            dataSource.setUrl(connectionString);
            dataSource.setUsername(username);
            dataSource.setPassword(password);
            dataSource.getConnection().close();
            this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)dataSource);
        }
        catch (SQLException x) {
            Log.error((String)"geonetwork.harvester.arcsde", (String)"Error getting ArcSDE connection (via JDBC)", (Throwable)x);
            throw new ExceptionInInitializerError(new ArcSDEConnectionException("Exception in ArcSDEConnection using JDBC: can not connect to the database", x));
        }
    }

    @Override
    public void close() throws ArcSDEConnectionException {
        try {
            this.dataSource.close();
        }
        catch (SQLException ex) {
            Log.error((String)"geonetwork.harvester.arcsde", (String)"Error closing the ArcSDE connection (via JDBC)", (Throwable)ex);
            throw new ArcSDEConnectionException("Exception closing JDBC connection", ex);
        }
    }

    public void finalize() throws Throwable {
        try {
            if (this.dataSource != null) {
                this.dataSource.close();
            }
        }
        catch (SQLException ex) {
            Log.error((String)"geonetwork.harvester.arcsde", (String)"Error closing the ArcSDE connection (via JDBC) in finalize method", (Throwable)ex);
            throw new ArcSDEConnectionException("Exception finalizing class ArcSDEConnection", ex);
        }
        finally {
            super.finalize();
        }
    }

    protected NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public Map<String, String> retrieveMetadata(final AtomicBoolean cancelMonitor, String arcSDEVersion) throws Exception {
        final HashMap<String, String> results = new HashMap<String, String>();
        ArcSDEVersionFactory arcSDEVersionFactory = new ArcSDEVersionFactory();
        String metadataTable = arcSDEVersionFactory.getTableName(arcSDEVersion);
        final String columnName = arcSDEVersionFactory.getMetadataColumnName(arcSDEVersion);
        String sqlQuery = "SELECT " + columnName + ", UUID FROM " + metadataTable;
        this.getJdbcTemplate().query(sqlQuery, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                if (cancelMonitor.get()) {
                    Log.warning((String)"geonetwork.harvester.arcsde", (Object)"Cancelling metadata retrieve using ArcSDE connection (via JDBC)");
                    rs.getStatement().cancel();
                    results.clear();
                }
                String document = "";
                int colId = rs.findColumn(columnName);
                int colIdUuid = rs.findColumn("UUID");
                if (rs.getObject(colId) != null) {
                    if (rs.getMetaData().getColumnType(colId) == 2004) {
                        Blob blob = rs.getBlob(columnName);
                        byte[] bdata = blob.getBytes(1L, (int)blob.length());
                        document = new String(bdata);
                    } else if (rs.getMetaData().getColumnType(colId) == -4) {
                        byte[] byteData = rs.getBytes(colId);
                        document = new String(byteData);
                    } else if (rs.getMetaData().getColumnType(colId) == -16 || rs.getMetaData().getColumnType(colId) == -1 || rs.getMetaData().getColumnType(colId) == 12 || rs.getMetaData().getColumnType(colId) == 2009) {
                        document = rs.getString(colId);
                    } else {
                        throw new SQLException("Trying to harvest from a column with an invalid datatype: " + rs.getMetaData().getColumnTypeName(colId));
                    }
                    String uuid = rs.getString(colIdUuid);
                    results.put(uuid, document);
                }
            }
        });
        Log.info((String)"geonetwork.harvester.arcsde", (Object)("Finished retrieving metadata, found: #" + results.size() + " metadata records"));
        return results;
    }
}

