/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.metadata.draft;

import java.util.Arrays;
import java.util.List;
import javax.transaction.Transactional;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.events.md.MetadataDraftRemove;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class DraftRemoved {
    @Autowired
    private IMetadataUtils metadataUtils;
    @Autowired
    private IMetadataIndexer metadataIndexer;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION, fallbackExecution=true)
    public void doAfterCommit(MetadataDraftRemove event) {
        Log.trace((String)"geonetwork.datamanager", (Object)("Reindexing non drafted versions of uuid " + event.getMd().getUuid()));
        try {
            for (AbstractMetadata abstractMetadata : this.getRecords(event)) {
                if (abstractMetadata instanceof MetadataDraft) continue;
                Log.trace((String)"geonetwork.datamanager", (Object)("Reindexing " + abstractMetadata.getId()));
                try {
                    this.metadataIndexer.indexMetadata(Arrays.asList(String.valueOf(abstractMetadata.getId())));
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.datamanager", (Object)e, (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            Log.error((String)"geonetwork.datamanager", (String)("Couldn't reindex the non drafted versions of " + event.getMd()), (Throwable)e);
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    private List<? extends AbstractMetadata> getRecords(MetadataDraftRemove event) {
        return this.metadataUtils.findAllByUuid(event.getMd().getUuid());
    }
}

