/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.config;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.config.ConfigExtractor;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.ProcessingParameters;

public class Configuration {
    public static final String PATH_QUERY_PARAM = "p";
    private Map<ConfigKey, String> globalConfig = new HashMap<ConfigKey, String>();

    public Configuration(Object ... keyAndValues) {
        for (int i = 0; i < keyAndValues.length; i += 2) {
            this.globalConfig.put((ConfigKey)((Object)keyAndValues[i]), (String)keyAndValues[i + 1]);
        }
    }

    public void updateGlobalConfiguration(ConfigExtractor pExtractor) {
        Enumeration e = pExtractor.getNames();
        while (e.hasMoreElements()) {
            String keyS = (String)e.nextElement();
            ConfigKey key = ConfigKey.getGlobalConfigKey(keyS);
            if (key == null) continue;
            this.globalConfig.put(key, pExtractor.getParameter(keyS));
        }
    }

    public void updateGlobalConfiguration(Map<String, String> pConfig) {
        for (ConfigKey c : ConfigKey.values()) {
            String value;
            if (!c.isGlobalConfig() || (value = pConfig.get(c.getKeyValue())) == null) continue;
            this.globalConfig.put(c, value);
        }
    }

    public String get(ConfigKey pKey) {
        String value = this.globalConfig.get((Object)pKey);
        if (value == null) {
            value = pKey.getDefaultValue();
        }
        return value;
    }

    public int getAsInt(ConfigKey pKey) {
        int ret;
        try {
            ret = Integer.parseInt(this.get(pKey));
        }
        catch (NumberFormatException exp) {
            ret = Integer.parseInt(pKey.getDefaultValue());
        }
        return ret;
    }

    public ProcessingParameters getProcessingParameters(Map<String, String> pParams) {
        Map<ConfigKey, String> procParams = ProcessingParameters.convertToConfigMap(pParams);
        for (Map.Entry<ConfigKey, String> entry : this.globalConfig.entrySet()) {
            ConfigKey key = entry.getKey();
            if (!key.isRequestConfig() || procParams.containsKey((Object)key)) continue;
            procParams.put(key, entry.getValue());
        }
        return new ProcessingParameters(procParams, pParams.get(PATH_QUERY_PARAM));
    }

    public boolean getAsBoolean(ConfigKey pKey) {
        return Boolean.valueOf(this.get(pKey));
    }

    public int size() {
        return this.globalConfig.size();
    }

    public boolean containsKey(ConfigKey pKey) {
        return this.globalConfig.containsKey((Object)pKey);
    }
}

