/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Resolver;

public final class ResolverWrapper {
    private static Map<String, Resolver> resolverMap = new HashMap<String, Resolver>();
    private static final String DEFAULT = "DEFAULT";

    public static synchronized void createResolverForSchema(String schemaName, Path oasisDirFile) {
        if (!resolverMap.containsKey(schemaName)) {
            resolverMap.put(schemaName, new Resolver(oasisDirFile));
        }
    }

    public static Resolver getInstance(String schemaName) {
        if (schemaName == null) {
            return ResolverWrapper.getInstance();
        }
        if (!resolverMap.containsKey(schemaName)) {
            Log.error("jeeves", "Oasis catalog files not available for " + schemaName);
            return ResolverWrapper.getInstance();
        }
        return resolverMap.get(schemaName);
    }

    public static Collection<Resolver> getResolvers() {
        return resolverMap.values();
    }

    public static synchronized Resolver getInstance() {
        if (!resolverMap.containsKey(DEFAULT)) {
            resolverMap.put(DEFAULT, new Resolver());
        }
        return resolverMap.get(DEFAULT);
    }
}

