/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.io.IOException;
import java.util.Set;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.DuplicatesFilter;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.SetOperator;

public class Minus
extends SetOperator {
    public Minus(Query leftArg, Query rightArg, boolean all) {
        super(leftArg, rightArg, all);
    }

    public void evaluate(RdfSource rdfSource, QueryAnswerListener listener) throws SailQueryException {
        SetOperator.QueryAnswerCollector qac = new SetOperator.QueryAnswerCollector();
        this._rightArg.evaluate(rdfSource, qac);
        if (!this._all) {
            listener = new DuplicatesFilter(listener);
        }
        listener = new MinusFilter(qac.getQueryAnswers(), listener);
        this._leftArg.evaluate(rdfSource, listener);
    }

    public String toString() {
        return "(" + this._leftArg.toString() + " MINUS " + (this._all ? "ALL " : "") + this._rightArg.toString() + ")";
    }

    private static class MinusFilter
    implements QueryAnswerListener {
        private Set _excludeSet;
        private QueryAnswerListener _listener;

        public MinusFilter(Set excludeSet, QueryAnswerListener l) {
            this._excludeSet = excludeSet;
            this._listener = l;
        }

        public boolean queryAnswer(QueryAnswer qa) throws IOException {
            if (!this._excludeSet.contains(qa)) {
                return this._listener.queryAnswer(qa);
            }
            return true;
        }

        public void clear() {
            this._listener.clear();
        }
    }
}

