/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.AbstractFloatCollection;
import bak.pcj.Adapter;
import bak.pcj.FloatIterator;
import bak.pcj.adapter.IteratorToFloatIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.Collection;

public class CollectionToFloatCollectionAdapter
extends AbstractFloatCollection {
    protected Collection collection;

    public CollectionToFloatCollectionAdapter(Collection collection) {
        this(collection, false);
    }

    public CollectionToFloatCollectionAdapter(Collection collection, boolean validate) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(float v) {
        return this.collection.add(new Float(v));
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(float v) {
        return this.collection.contains(new Float(v));
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public FloatIterator iterator() {
        return new IteratorToFloatIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(float v) {
        return this.collection.remove(new Float(v));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean validate() {
        return Adapter.isFloatAdaptable(this.collection);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("collection");
        }
    }
}

