/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.response;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.geotools.data.ows.Response;
import org.geotools.http.HTTPResponse;
import org.geotools.image.io.ImageIOExt;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wmts.model.WMTSServiceType;

public class GetTileResponse
extends Response {
    private WMTSServiceType type;
    private URL requestURL;
    private final BufferedImage tileImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetTileResponse(HTTPResponse httpResponse, WMTSServiceType wmtsServiceType) throws ServiceException, IOException {
        super(httpResponse);
        this.setType(wmtsServiceType);
        String format = httpResponse.getContentType();
        if (format.startsWith("image")) {
            try {
                this.tileImage = ImageIOExt.readBufferedImage((Object)httpResponse.getResponseStream());
            }
            finally {
                httpResponse.dispose();
            }
        } else {
            this.tileImage = null;
        }
    }

    public WMTSServiceType getType() {
        return this.type;
    }

    public void setType(WMTSServiceType type) {
        this.type = type;
    }

    public URL getRequestURL() {
        return this.requestURL;
    }

    public void setRequestURL(URL requestURL) {
        this.requestURL = requestURL;
    }

    public BufferedImage getTileImage() {
        return this.tileImage;
    }
}

