/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.client;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.http.HTTPResponse;
import org.geotools.image.io.ImageIOExt;
import org.geotools.ows.wmts.client.WMTSTileFactory;
import org.geotools.ows.wmts.client.WMTSTileIdentifier;
import org.geotools.ows.wmts.client.WMTSTileService;
import org.geotools.tile.Tile;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.geotools.util.logging.Logging;

class WMTSTile
extends Tile {
    protected static final Logger LOGGER = Logging.getLogger(WMTSTile.class);
    public static final String WMTS_TILE_CACHE_SIZE_PROPERTY_NAME = "wmts.tile.cache.size";
    private static final ObjectCache<String, BufferedImage> tileImages;
    private URL url = null;

    public WMTSTile(int x, int y, ZoomLevel zoomLevel, TileService service) {
        this(new WMTSTileIdentifier(x, y, zoomLevel, service.getName()), service);
    }

    public WMTSTile(TileIdentifier tileIdentifier, TileService service) {
        this((WMTSTileIdentifier)tileIdentifier, service);
    }

    public WMTSTile(WMTSTileIdentifier tileIdentifier, TileService service) {
        super((TileIdentifier)tileIdentifier, WMTSTileFactory.getExtentFromTileName(tileIdentifier, service), ((WMTSTileService)service).getTileMatrix(tileIdentifier.getZoomLevel().getZoomLevel()).getTileWidth(), service);
    }

    private WMTSTileService getService() {
        return (WMTSTileService)this.service;
    }

    public URL getUrl() {
        if (this.url == null) {
            this.url = this.getService().createURL(this);
        }
        return this.url;
    }

    @Deprecated
    public BufferedImage loadImageTileImage(Tile tile) throws IOException {
        URL url = this.getUrl();
        LOGGER.log(Level.FINE, "Loading tile " + this.getId() + ": " + url);
        String tileKey = url.toString();
        if (tileImages.peek((Object)tileKey) != null && tileImages.get((Object)tileKey) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Tile image already loaded for tile " + this.getId());
            }
            return (BufferedImage)tileImages.get((Object)tileKey);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Tile image not yet loaded for tile " + this.getId());
        }
        BufferedImage bi = this.doLoadImageTileImage(tile);
        tileImages.put((Object)tileKey, (Object)bi);
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public BufferedImage doLoadImageTileImage(Tile tile) throws IOException {
        WMTSTileService service = this.getService();
        Map headers = (Map)service.getExtrainfo().get("HEADERS");
        HTTPResponse http = service.getHttpClient().get(this.getUrl(), headers);
        try {
            BufferedImage bufferedImage = ImageIOExt.readBufferedImage((Object)http.getResponseStream());
            return bufferedImage;
        }
        finally {
            http.dispose();
        }
    }

    static {
        int cacheSize = 150;
        String size = System.getProperty(WMTS_TILE_CACHE_SIZE_PROPERTY_NAME);
        if (size != null) {
            try {
                cacheSize = Integer.parseUnsignedInt(size);
            }
            catch (NumberFormatException ex) {
                LOGGER.info("Bad wmts.tile.cache.size property '" + size + "'");
            }
        }
        tileImages = ObjectCaches.create((String)"soft", (int)cacheSize);
    }
}

