/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SuccessionType implements Enumerator
{
    SUBSTITUTION(0, "substitution", "substitution"),
    DIVISION(1, "division", "division"),
    FUSION(2, "fusion", "fusion"),
    INITIATION(3, "initiation", "initiation");

    public static final int SUBSTITUTION_VALUE = 0;
    public static final int DIVISION_VALUE = 1;
    public static final int FUSION_VALUE = 2;
    public static final int INITIATION_VALUE = 3;
    private static final SuccessionType[] VALUES_ARRAY;
    public static final List<SuccessionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SuccessionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SuccessionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SuccessionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SuccessionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SuccessionType get(int value) {
        switch (value) {
            case 0: {
                return SUBSTITUTION;
            }
            case 1: {
                return DIVISION;
            }
            case 2: {
                return FUSION;
            }
            case 3: {
                return INITIATION;
            }
        }
        return null;
    }

    private SuccessionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SuccessionType[]{SUBSTITUTION, DIVISION, FUSION, INITIATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

