/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.geom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geojson.geom.GeometryHandlerBase;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class MultiPolygonHandler
extends GeometryHandlerBase<MultiPolygon> {
    List<Coordinate> coordinates;
    List<Coordinate[]> rings;
    List<List<Coordinate[]>> polys;

    public MultiPolygonHandler(GeometryFactory factory) {
        super(factory);
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if ("coordinates".equals(key)) {
            this.polys = new ArrayList<List<Coordinate[]>>();
        }
        return true;
    }

    @Override
    public boolean startArray() throws ParseException, IOException {
        if (this.rings == null) {
            this.rings = new ArrayList<Coordinate[]>();
        } else if (this.coordinates == null) {
            this.coordinates = new ArrayList<Coordinate>();
        } else if (this.ordinates == null) {
            this.ordinates = new ArrayList();
        }
        return true;
    }

    @Override
    public boolean endArray() throws ParseException, IOException {
        if (this.ordinates != null) {
            this.coordinates.add(this.coordinate(this.ordinates));
            this.ordinates = null;
        } else if (this.coordinates != null) {
            this.rings.add(this.coordinates(this.coordinates));
            this.coordinates = null;
        } else if (this.rings != null) {
            this.polys.add(this.rings);
            this.rings = null;
        }
        return true;
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        if (this.polys != null) {
            Polygon[] polygons = new Polygon[this.polys.size()];
            for (int i = 0; i < this.polys.size(); ++i) {
                List<Coordinate[]> rings = this.polys.get(i);
                if (rings.isEmpty()) continue;
                LinearRing outer = this.factory.createLinearRing(rings.get(0));
                LinearRing[] inner = rings.size() > 1 ? new LinearRing[rings.size() - 1] : null;
                for (int j = 1; j < rings.size(); ++j) {
                    inner[j - 1] = this.factory.createLinearRing(rings.get(j));
                }
                polygons[i] = this.factory.createPolygon(outer, inner);
            }
            this.value = this.factory.createMultiPolygon(polygons);
            this.polys = null;
        }
        return true;
    }
}

