/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import ucar.ma2.Array;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.image.ImageArrayAdapter;

public class ImageDatasetFactory {
    private StringBuffer log;
    private File currentFile;
    private File currentDir = null;
    private List<File> currentDirFileList;
    private int currentDirFileNo = 0;
    private GridDatatype grid = null;
    private int time = 0;
    private int ntimes = 1;

    public String getErrorMessages() {
        return this.log == null ? "" : this.log.toString();
    }

    public BufferedImage openDataset(GridDatatype grid) throws IOException {
        this.grid = grid;
        this.time = 0;
        GridCoordSystem gcsys = grid.getCoordinateSystem();
        if (gcsys.getTimeAxis() != null) {
            this.ntimes = (int)gcsys.getTimeAxis().getSize();
        }
        Array data = grid.readDataSlice(this.time, 0, -1, -1);
        return ImageArrayAdapter.makeGrayscaleImage(data);
    }

    public BufferedImage open(String location) throws IOException {
        this.log = new StringBuffer();
        if (location.startsWith("http:")) {
            try {
                URL url = new URL(location);
                this.currentFile = null;
                return ImageIO.read(url);
            }
            catch (MalformedURLException e) {
                this.log.append(e.getMessage());
                return null;
            }
            catch (IOException e) {
                this.log.append(e.getMessage());
                return null;
            }
        }
        if (location.startsWith("file:)")) {
            location = location.substring(5);
        }
        try {
            File f = new File(location);
            if (!f.exists()) {
                return null;
            }
            this.currentFile = f;
            this.currentDir = null;
            return ImageIO.read(f);
        }
        catch (MalformedURLException e) {
            this.log.append(e.getMessage());
            return null;
        }
        catch (IOException e) {
            this.log.append(e.getMessage());
            return null;
        }
    }

    public BufferedImage getNextImage(boolean forward) {
        if (this.grid != null) {
            if (forward) {
                ++this.time;
                if (this.time >= this.ntimes) {
                    this.time = 0;
                }
            } else {
                --this.time;
                if (this.time < 0) {
                    this.time = this.ntimes - 1;
                }
            }
            try {
                Array data = this.grid.readDataSlice(this.time, 0, -1, -1);
                return ImageArrayAdapter.makeGrayscaleImage(data);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.currentFile == null) {
            return null;
        }
        if (this.currentDir == null) {
            this.currentDirFileNo = 0;
            this.currentDir = this.currentFile.getParentFile();
            this.currentDirFileList = new ArrayList<File>();
            this.addToList(this.currentDir, this.currentDirFileList);
            for (int i = 0; i < this.currentDirFileList.size(); ++i) {
                File file = this.currentDirFileList.get(i);
                if (!file.equals(this.currentFile)) continue;
                this.currentDirFileNo = i;
            }
        }
        if (forward) {
            ++this.currentDirFileNo;
            if (this.currentDirFileNo >= this.currentDirFileList.size()) {
                this.currentDirFileNo = 0;
            }
        } else {
            --this.currentDirFileNo;
            if (this.currentDirFileNo < 0) {
                this.currentDirFileNo = this.currentDirFileList.size() - 1;
            }
        }
        File nextFile = this.currentDirFileList.get(this.currentDirFileNo);
        try {
            System.out.println("Open image " + nextFile);
            return ImageIO.read(nextFile);
        }
        catch (IOException e) {
            System.out.println("Failed to open image " + nextFile);
            return this.getNextImage(forward);
        }
    }

    private void addToList(File dir, List<File> list) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.addToList(file, list);
                continue;
            }
            if (!file.getName().endsWith(".jpg") && !file.getName().endsWith(".JPG")) continue;
            list.add(file);
        }
    }
}

