/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.XmlEmbeddable;
import org.fao.geonet.utils.DateUtil;
import org.jdom.Element;

@Embeddable
@XmlRootElement
public class ISODate
implements Cloneable,
Comparable<ISODate>,
Serializable,
XmlEmbeddable {
    @XmlTransient
    public static final DateTimeFormatter YEAR_MONTH_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM");
    @XmlTransient
    public static final DateTimeFormatter YEAR_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy");
    @XmlTransient
    public static final DateTimeFormatter YEAR_MONTH_DAYS_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @XmlTransient
    private boolean _shortDate;
    @XmlTransient
    private boolean _shortDateYear;
    @XmlTransient
    private boolean _shortDateYearMonth;
    @XmlTransient
    private ZonedDateTime internalDateTime;

    public ISODate() {
        this.internalDateTime = ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC);
    }

    public ISODate(long timeInEpochMillis, boolean shortDate) {
        this._shortDate = shortDate;
        Instant instantParam = Instant.ofEpochMilli(timeInEpochMillis);
        this.internalDateTime = instantParam.atZone(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS);
    }

    public ISODate(long timeInEpochMillis) {
        Instant instantParam = Instant.ofEpochMilli(timeInEpochMillis);
        this.internalDateTime = ZonedDateTime.ofInstant(instantParam, ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
        this._shortDate = false;
    }

    public ISODate(@Nonnull String isoDateString) {
        this.setDateAndTime(isoDateString);
    }

    public ISODate clone() {
        try {
            ISODate clone = (ISODate)super.clone();
            clone.internalDateTime = this.internalDateTime;
            clone._shortDate = this._shortDate;
            clone._shortDateYear = this._shortDateYear;
            clone._shortDateYearMonth = this._shortDateYearMonth;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public long timeDifferenceInSeconds(ISODate date) {
        return ChronoUnit.SECONDS.between(date.internalDateTime, this.internalDateTime);
    }

    @Transient
    public String getDateAsString() {
        if (this._shortDateYearMonth) {
            return this.internalDateTime.format(YEAR_MONTH_DATE_FORMATTER);
        }
        if (this._shortDateYear) {
            return this.internalDateTime.format(YEAR_DATE_FORMATTER);
        }
        return this.internalDateTime.format(YEAR_MONTH_DAYS_DATE_FORMATTER);
    }

    public String toString() {
        return this.getDateAndTime();
    }

    public Date toDate() {
        return Date.from(this.internalDateTime.toInstant());
    }

    @Transient
    public long getTimeInSeconds() {
        return this.internalDateTime.toEpochSecond();
    }

    @XmlValue
    @Transient
    @JsonSerialize
    @JsonProperty
    public String getDateAndTime() {
        if (this._shortDate || this._shortDateYearMonth || this._shortDateYear) {
            return this.getDateAsString();
        }
        return this.internalDateTime.withZoneSameInstant(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public void setDateAndTime(String isoDate) {
        String timeAndDate = isoDate;
        if (timeAndDate == null) {
            throw new IllegalArgumentException("Date string is null");
        }
        if (timeAndDate.indexOf(84) >= 0 && StringUtils.contains((String)timeAndDate, (char)':')) {
            if ((timeAndDate = DateUtil.convertToISOZuluDateTime((String)timeAndDate)) == null) {
                throw new IllegalArgumentException("Not parsable date: " + isoDate);
            }
            this.internalDateTime = ZonedDateTime.parse(timeAndDate, DateUtil.ISO_OFFSET_DATE_TIME_NANOSECONDS);
            return;
        }
        if (StringUtils.contains((String)timeAndDate, (char)':')) {
            try {
                this.internalDateTime = DateUtil.parseTime((String)StringUtils.remove((String)StringUtils.remove((String)timeAndDate, (char)'t'), (char)'T'));
                this._shortDate = false;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid ISO time: " + isoDate, e);
            }
        } else {
            this.parseDate(StringUtils.remove((String)StringUtils.remove((String)timeAndDate, (char)'t'), (char)'T'));
        }
    }

    @JsonProperty(value="dateAndTimeUtc")
    @XmlTransient
    public String getDateAndTimeUtc() {
        return this.internalDateTime.withZoneSameInstant(ZoneOffset.UTC).format(DateUtil.ISO_OFFSET_DATE_TIME_NANOSECONDS);
    }

    public void setDateAndTimeUtc(String isoDate) {
        this.setDateAndTime(isoDate);
    }

    @Transient
    public boolean isDateOnly() {
        return this._shortDate;
    }

    @Transient
    public boolean isDateYearOnly() {
        return this._shortDateYear;
    }

    @Transient
    public boolean isDateYearMonthOnly() {
        return this._shortDateYearMonth;
    }

    @Transient
    public int getYears() {
        return this.internalDateTime.getYear();
    }

    @Transient
    public int getDays() {
        return this.internalDateTime.getDayOfMonth();
    }

    @Transient
    public int getMonths() {
        return this.internalDateTime.getMonthValue();
    }

    @Transient
    public int getHours() {
        return this.internalDateTime.getHour();
    }

    @Transient
    public int getMinutes() {
        return this.internalDateTime.getMinute();
    }

    @Transient
    public int getSeconds() {
        return this.internalDateTime.getSecond();
    }

    @Transient
    public ZonedDateTime getInternalDateTime() {
        return this.internalDateTime;
    }

    public int hashCode() {
        return this.getTimeAsString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ISODate other = (ISODate)obj;
        return other.internalDateTime.isEqual(this.internalDateTime);
    }

    private void parseDate(@Nonnull String isoDate) {
        try {
            int partNumber;
            int startPos = 0;
            int year = -1;
            int month = -1;
            int day = -1;
            ZoneId offset = ZoneId.systemDefault();
            isoDate = isoDate.replace('/', '-');
            for (partNumber = 0; startPos < isoDate.length() && partNumber < 3; ++partNumber) {
                int nextPos = isoDate.indexOf(45, startPos);
                if (nextPos == -1) {
                    nextPos = isoDate.length();
                }
                String subString = isoDate.substring(startPos, nextPos);
                switch (partNumber) {
                    case 0: {
                        int parsedInt = Integer.parseInt(subString);
                        if (nextPos - startPos < 4) {
                            int thisYear = ZonedDateTime.now(ZoneOffset.UTC).getYear();
                            int century = thisYear / 100;
                            int yearInCentury = thisYear % 100;
                            year = century * 100 + parsedInt;
                            if (parsedInt <= yearInCentury) break;
                            year -= 100;
                            break;
                        }
                        year = parsedInt;
                        break;
                    }
                    case 1: {
                        month = Integer.parseInt(subString);
                        break;
                    }
                    case 2: {
                        if (subString.toLowerCase().endsWith("z")) {
                            offset = ZoneOffset.UTC;
                            day = Integer.parseInt(subString.substring(0, subString.length() - 1));
                            break;
                        }
                        day = Integer.parseInt(subString);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Should not reach partNumber " + partNumber);
                    }
                }
                startPos = nextPos + 1;
            }
            if (partNumber == 0 || partNumber > 3) {
                throw new IllegalArgumentException("Invalid ISO date: " + isoDate);
            }
            this._shortDate = partNumber == 3;
            this._shortDateYearMonth = partNumber == 2;
            boolean bl = this._shortDateYear = partNumber == 1;
            if (!this._shortDate && !this._shortDateYearMonth) {
                month = 12;
            }
            if (!this._shortDate) {
                day = YearMonth.of(year, month).atEndOfMonth().getDayOfMonth();
            }
            this._shortDate = true;
            this.internalDateTime = ZonedDateTime.of(year, month, day, 0, 0, 0, 0, offset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid ISO date: " + isoDate, e);
        }
    }

    @Transient
    public String getTimeAsString() {
        return this.pad(this.getHours()) + ":" + this.pad(this.getMinutes()) + ":" + this.pad(this.getSeconds());
    }

    private String pad(int value) {
        if (value > 9) {
            return Integer.toString(value);
        }
        return "0" + value;
    }

    @Override
    public int compareTo(ISODate other) {
        return this.internalDateTime.compareTo(other.internalDateTime);
    }

    @Override
    public void addToXml(Element element) {
        if (this.isDateOnly()) {
            element.addContent(this.getDateAsString());
        } else {
            element.addContent(this.getDateAndTime());
        }
    }
}

