/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.CharMatcher;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JsFileParser
extends JsFileLineParser {
    private static Logger logger = Logger.getLogger(JsFileParser.class.getName());
    private static final Pattern GOOG_PROVIDE_REQUIRE_PATTERN = Pattern.compile("(?:^|;)\\s*(?:(?:var|let|const)\\s+[a-zA-Z_$][a-zA-Z0-9$_]*\\s*=\\s*)?goog\\.(provide|module|require|addDependency)\\s*\\((.*?)\\)");
    private static final String BASE_JS_START = "var COMPILED = false;";
    private Matcher googMatcher = GOOG_PROVIDE_REQUIRE_PATTERN.matcher("");
    private List<String> provides;
    private List<String> requires;
    private boolean fileHasProvidesOrRequires;
    private boolean fileIsModule;
    private boolean includeGoogBase = false;

    public JsFileParser(ErrorManager errorManager) {
        super(errorManager);
    }

    public JsFileParser setIncludeGoogBase(boolean include) {
        this.includeGoogBase = include;
        return this;
    }

    public DependencyInfo parseFile(String filePath, String closureRelativePath, String fileContents) {
        return this.parseReader(filePath, closureRelativePath, new StringReader(fileContents));
    }

    private DependencyInfo parseReader(String filePath, String closureRelativePath, Reader fileContents) {
        this.provides = new ArrayList<String>();
        this.requires = new ArrayList<String>();
        this.fileHasProvidesOrRequires = false;
        this.fileIsModule = false;
        logger.fine("Parsing Source: " + filePath);
        this.doParse(filePath, fileContents);
        SimpleDependencyInfo dependencyInfo = new SimpleDependencyInfo(closureRelativePath, filePath, this.provides, this.requires, this.fileIsModule);
        logger.fine("DepInfo: " + dependencyInfo);
        return dependencyInfo;
    }

    @Override
    protected boolean parseLine(String line) throws JsFileLineParser.ParseException {
        boolean lineHasProvidesOrRequires = false;
        if (line.contains("provide") || line.contains("require") || line.contains("module") || line.contains("addDependency")) {
            this.googMatcher.reset(line);
            while (this.googMatcher.find()) {
                boolean isRequire;
                char firstChar;
                lineHasProvidesOrRequires = true;
                if (this.includeGoogBase && !this.fileHasProvidesOrRequires) {
                    this.fileHasProvidesOrRequires = true;
                    this.requires.add("goog");
                }
                boolean isProvide = (firstChar = this.googMatcher.group(1).charAt(0)) == 'p' || firstChar == 'm';
                boolean isModule = firstChar == 'm';
                boolean bl = isRequire = firstChar == 'r';
                if (isModule) {
                    this.fileIsModule = true;
                }
                if (!isProvide && !isRequire) continue;
                String arg = this.parseJsString(this.googMatcher.group(2));
                if (isRequire) {
                    if ("goog".equals(arg)) continue;
                    this.requires.add(arg);
                    continue;
                }
                this.provides.add(arg);
            }
        } else if (this.includeGoogBase && line.startsWith(BASE_JS_START) && this.provides.isEmpty() && this.requires.isEmpty()) {
            this.provides.add("goog");
            return false;
        }
        return !this.shortcutMode || lineHasProvidesOrRequires || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)line);
    }
}

