/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.rhino.Node;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class LiveVariablesAnalysis
extends DataFlowAnalysis<Node, LiveVariableLattice> {
    static final int MAX_VARIABLES_TO_ANALYZE = 100;
    public static final String ARGUMENT_ARRAY_ALIAS = "arguments";
    private final Scope jsScope;
    private final Set<Var> escaped;

    LiveVariablesAnalysis(ControlFlowGraph<Node> cfg, Scope jsScope, AbstractCompiler compiler) {
        super(cfg, new LiveVariableJoinOp());
        this.jsScope = jsScope;
        this.escaped = new HashSet<Var>();
        LiveVariablesAnalysis.computeEscaped(jsScope, this.escaped, compiler);
    }

    public Set<? extends Var> getEscapedLocals() {
        return this.escaped;
    }

    public int getVarIndex(String var) {
        return this.jsScope.getVar((String)var).index;
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    LiveVariableLattice createEntryLattice() {
        return new LiveVariableLattice(this.jsScope.getVarCount());
    }

    @Override
    LiveVariableLattice createInitialEstimateLattice() {
        return new LiveVariableLattice(this.jsScope.getVarCount());
    }

    @Override
    LiveVariableLattice flowThrough(Node node, LiveVariableLattice input) {
        BitSet gen = new BitSet(input.liveSet.size());
        BitSet kill = new BitSet(input.liveSet.size());
        boolean conditional = false;
        List edgeList = this.getCfg().getOutEdges(node);
        for (DiGraph.DiGraphEdge edge : edgeList) {
            if (!ControlFlowGraph.Branch.ON_EX.equals(edge.getValue())) continue;
            conditional = true;
        }
        this.computeGenKill(node, gen, kill, conditional);
        LiveVariableLattice result = new LiveVariableLattice(input);
        result.liveSet.andNot(kill);
        result.liveSet.or(gen);
        return result;
    }

    private void computeGenKill(Node n, BitSet gen, BitSet kill, boolean conditional) {
        switch (n.getType()) {
            case 105: 
            case 125: 
            case 132: {
                return;
            }
            case 108: 
            case 113: 
            case 114: {
                this.computeGenKill(NodeUtil.getConditionExpression(n), gen, kill, conditional);
                return;
            }
            case 115: {
                if (!NodeUtil.isForIn(n)) {
                    this.computeGenKill(NodeUtil.getConditionExpression(n), gen, kill, conditional);
                } else {
                    Node lhs = n.getFirstChild();
                    if (lhs.isVar()) {
                        lhs = lhs.getLastChild();
                    }
                    if (lhs.isName()) {
                        this.addToSetIfLocal(lhs, kill);
                        this.addToSetIfLocal(lhs, gen);
                    } else {
                        this.computeGenKill(lhs, gen, kill, conditional);
                    }
                }
                return;
            }
            case 118: {
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (!c.hasChildren()) continue;
                    this.computeGenKill(c.getFirstChild(), gen, kill, conditional);
                    if (conditional) continue;
                    this.addToSetIfLocal(c, kill);
                }
                return;
            }
            case 100: 
            case 101: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                this.computeGenKill(n.getLastChild(), gen, kill, true);
                return;
            }
            case 98: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                this.computeGenKill(n.getFirstChild().getNext(), gen, kill, true);
                this.computeGenKill(n.getLastChild(), gen, kill, true);
                return;
            }
            case 38: {
                if (this.isArgumentsName(n)) {
                    this.markAllParametersEscaped();
                } else {
                    this.addToSetIfLocal(n, gen);
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName()) {
            Node lhs = n.getFirstChild();
            if (!conditional) {
                this.addToSetIfLocal(lhs, kill);
            }
            if (!n.isAssign()) {
                this.addToSetIfLocal(lhs, gen);
            }
            this.computeGenKill(lhs.getNext(), gen, kill, conditional);
        } else {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                this.computeGenKill(c, gen, kill, conditional);
            }
        }
    }

    private void addToSetIfLocal(Node node, BitSet set) {
        Preconditions.checkState((boolean)node.isName());
        String name = node.getString();
        if (!this.jsScope.isDeclared(name, false)) {
            return;
        }
        Var var = this.jsScope.getVar(name);
        if (!this.escaped.contains(var)) {
            set.set(var.index);
        }
    }

    void markAllParametersEscaped() {
        Node lp = this.jsScope.getRootNode().getFirstChild().getNext();
        for (Node arg = lp.getFirstChild(); arg != null; arg = arg.getNext()) {
            this.escaped.add(this.jsScope.getVar(arg.getString()));
        }
    }

    private boolean isArgumentsName(Node n) {
        return n.isName() && n.getString().equals(ARGUMENT_ARRAY_ALIAS) && !this.jsScope.isDeclared(ARGUMENT_ARRAY_ALIAS, false);
    }

    static class LiveVariableLattice
    implements LatticeElement {
        private final BitSet liveSet;

        private LiveVariableLattice(int numVars) {
            this.liveSet = new BitSet(numVars);
        }

        private LiveVariableLattice(LiveVariableLattice other) {
            Preconditions.checkNotNull((Object)other);
            this.liveSet = (BitSet)other.liveSet.clone();
        }

        public boolean equals(Object other) {
            Preconditions.checkNotNull((Object)other);
            return other instanceof LiveVariableLattice && this.liveSet.equals(((LiveVariableLattice)other).liveSet);
        }

        public boolean isLive(Var v) {
            Preconditions.checkNotNull((Object)v);
            return this.liveSet.get(v.index);
        }

        public boolean isLive(int index) {
            return this.liveSet.get(index);
        }

        public String toString() {
            return this.liveSet.toString();
        }

        public int hashCode() {
            return this.liveSet.hashCode();
        }
    }

    private static class LiveVariableJoinOp
    implements JoinOp<LiveVariableLattice> {
        private LiveVariableJoinOp() {
        }

        public LiveVariableLattice apply(List<LiveVariableLattice> in) {
            LiveVariableLattice result = new LiveVariableLattice(in.get(0));
            for (int i = 1; i < in.size(); ++i) {
                result.liveSet.or(in.get(i).liveSet);
            }
            return result;
        }
    }
}

