/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common.requests;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.AbstractHttpRequest;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class CatalogRequest {
    private static final List<String> excludedParameters = Arrays.asList("", "request", "version", "service");
    private final XmlRequest client;
    protected String outputSchema;
    protected String serverVersion = "2.0.2";

    public CatalogRequest(ServiceContext context) {
        this(context, null);
    }

    public CatalogRequest(ServiceContext context, String host) {
        this(context, host, -1);
    }

    public CatalogRequest(ServiceContext context, String host, int port) {
        this(context, host, port, "http");
    }

    public CatalogRequest(ServiceContext context, String host, int port, String protocol) {
        this.client = ((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(host, port, protocol);
        this.setMethod(AbstractHttpRequest.Method.POST);
        Lib.net.setupProxy(context, this.client);
    }

    public String getHost() {
        return this.client.getHost();
    }

    public int getPort() {
        return this.client.getPort();
    }

    public String getProtocol() {
        return this.client.getProtocol();
    }

    public String getAddress() {
        return this.client.getAddress();
    }

    public AbstractHttpRequest.Method getMethod() {
        return this.client.getMethod();
    }

    public void setMethod(AbstractHttpRequest.Method m) {
        this.client.setMethod(m);
    }

    public String getSentData() {
        return this.client.getSentData();
    }

    public String getOutputSchema() {
        return this.outputSchema;
    }

    public void setOutputSchema(String outputSchema) {
        this.outputSchema = outputSchema;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public void setUrl(ServiceContext context, URL url) {
        this.client.setUrl(url);
        this.client.setQuery(null);
        this.client.clearParams();
        String query = url.getQuery();
        if (StringUtils.isNotEmpty((String)query)) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] kvp = param.split("=");
                if (excludedParameters.contains(kvp[0].toLowerCase())) continue;
                this.client.addParam(kvp[0], (Object)kvp[1]);
            }
        }
        Lib.net.setupProxy(context, this.client);
    }

    public Element execute() throws Exception {
        if (this.getMethod() == AbstractHttpRequest.Method.GET) {
            this.client.clearParams();
            this.setupGetParams();
        } else {
            Element postParams = this.getPostParams();
            this.client.setRequest(postParams);
        }
        Element response = this.client.execute();
        CatalogException.unmarshal(response);
        return response;
    }

    public void setCredentials(String username, String password) {
        this.client.setCredentials(username, password);
        this.client.setPreemptiveBasicAuth(true);
    }

    public void setApiKey(String apiKeyHeader, String apiKey) {
        this.client.setApiKeyHeader(apiKeyHeader);
        this.client.setApiKey(apiKey);
    }

    protected abstract String getRequestName();

    protected abstract void setupGetParams();

    protected abstract Element getPostParams();

    protected void fill(String param, Iterable<?> iter) {
        this.fill(param, iter, "");
    }

    protected void fill(String param, Iterable<?> iter, String prefix) {
        Iterator<?> i = iter.iterator();
        if (!i.hasNext()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            sb.append(prefix);
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        this.addParam(param, sb.toString());
    }

    protected void fill(Element root, String parentName, String childName, Iterable<?> iter, Namespace ns) {
        Iterator<?> i = iter.iterator();
        if (!i.hasNext()) {
            return;
        }
        Element parent = new Element(parentName, ns);
        while (i.hasNext()) {
            Element el = new Element(childName, ns);
            el.setText(i.next().toString());
            parent.addContent((Content)el);
        }
        root.addContent((Content)parent);
    }

    protected void fill(Element root, String childName, Iterable<?> iter) {
        Iterator<?> i = iter.iterator();
        if (!i.hasNext()) {
            return;
        }
        while (i.hasNext()) {
            Element el = new Element(childName, root.getNamespace());
            el.setText(i.next().toString());
            root.addContent((Content)el);
        }
    }

    protected void setAttrib(Element el, String name, Object value) {
        this.setAttrib(el, name, value, "");
    }

    protected void setAttrib(Element el, String name, Object value, String prefix) {
        if (value != null) {
            el.setAttribute(name, prefix + value.toString());
        }
    }

    protected void setAttrib(Element el, String name, Iterable<?> iter, String prefix) {
        Iterator<?> i = iter.iterator();
        if (!i.hasNext()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            sb.append(prefix);
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append(" ");
        }
        el.setAttribute(name, sb.toString());
    }

    protected void setAttribSpaceSeparated(Element el, String name, Iterable<?> iter, String prefix) {
        Iterator<?> i = iter.iterator();
        if (!i.hasNext()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            Object value = i.next();
            sb.append(prefix);
            sb.append(value.toString());
            if (!i.hasNext()) continue;
            sb.append(" ");
        }
        el.setAttribute(name, sb.toString());
    }

    protected void addParam(Element root, String name, Object value) {
        if (value != null) {
            root.addContent((Content)new Element(name, Csw.NAMESPACE_CSW).setText(value.toString()));
        }
    }

    protected void addParam(String name, Object value) {
        this.addParam(name, value, "");
    }

    protected void addParam(String name, Object value, String prefix) {
        if (value != null) {
            this.client.addParam(name, (Object)(prefix + value.toString()));
        }
    }
}

