/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.fao.geonet.api.records.formatters.groovy.util.Link;
import org.fao.geonet.api.records.formatters.groovy.util.LinkType;
import org.jdom.JDOMException;

public class LinkBlock {
    public static String CSS_CLASS_PREFIX = "summary-links-";
    public final Multimap<LinkType, Link> linkMap = LinkedHashMultimap.create();
    public final String name;
    public final String iconClasses;
    private String html;

    public LinkBlock(String name, String iconClasses) {
        this.name = name;
        this.iconClasses = iconClasses;
    }

    public String getName() throws JDOMException, IOException {
        return this.name;
    }

    public String getIconClasses() {
        return this.iconClasses;
    }

    public void put(LinkType type, Link link) {
        Collection links = this.linkMap.get((Object)type);
        Link other = null;
        for (Link l : links) {
            if (!l.getHref().equalsIgnoreCase(link.getHref())) continue;
            other = l;
            break;
        }
        if (other != null) {
            if (other.getText().trim().isEmpty()) {
                this.linkMap.remove((Object)type, (Object)other);
            } else {
                return;
            }
        }
        this.linkMap.put((Object)type, (Object)link);
    }

    public Collection<LinkBlockEntry> getLinks() {
        return Collections2.transform(this.linkMap.asMap().entrySet(), (Function)new Function<Map.Entry<LinkType, Collection<Link>>, LinkBlockEntry>(){

            @Nullable
            public LinkBlockEntry apply(Map.Entry<LinkType, Collection<Link>> input) {
                return new LinkBlockEntry(input.getKey(), input.getValue());
            }
        });
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public static final class LinkBlockEntry {
        private final LinkType type;
        private final Collection<Link> links;

        public LinkBlockEntry(LinkType type, Collection<Link> links) {
            this.type = type;
            this.links = links;
        }

        public LinkType getType() {
            return this.type;
        }

        public Collection<Link> getLinks() {
            return this.links;
        }
    }
}

