/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.records.extent.BaseMapRenderingEngine;
import org.fao.geonet.api.records.extent.GetMapBaseMapRenderer;
import org.fao.geonet.api.records.extent.WMTSBaseMapRenderer;
import org.fao.geonet.utils.Log;
import org.locationtech.jts.geom.Envelope;

public class BaseMapRenderer {
    BaseMapRenderingEngine[] baseMapRenderingEngines = new BaseMapRenderingEngine[]{new GetMapBaseMapRenderer(), new WMTSBaseMapRenderer()};
    String configuration;
    Envelope bbox;
    String srs;
    Dimension imageDimensions;
    ServiceContext context;

    public BaseMapRenderer(String configuration) {
        this.configuration = configuration;
    }

    public BaseMapRenderer bbox(Envelope bbox) {
        this.bbox = bbox;
        return this;
    }

    public BaseMapRenderer imageDimensions(Dimension imageDimensions) {
        this.imageDimensions = imageDimensions;
        return this;
    }

    public BaseMapRenderer srs(String srs) {
        this.srs = srs;
        return this;
    }

    public BaseMapRenderer context(ServiceContext context) {
        this.context = context;
        return this;
    }

    public BufferedImage render() throws Exception {
        try {
            for (BaseMapRenderingEngine engine : this.baseMapRenderingEngines) {
                if (!engine.canHandle(this.configuration)) continue;
                engine.configure(this.configuration, this.bbox, this.srs, this.imageDimensions, this.context);
                return engine.render();
            }
            throw new Exception("didn't understand configuration (BaseMapRenderer) - " + this.configuration);
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.spatial", (Object)("error occurred during BaseMapRender - " + e + " (IGNORED)"));
            return new BufferedImage(this.imageDimensions.width, this.imageDimensions.height, 2);
        }
    }
}

