/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.services.ReadWriteController;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="recordVersionning")
@ReadWriteController
public class MetadataVersionningApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    AccessManager accessMan;
    @Autowired
    IMetadataUtils metadataRepository;

    @Operation(summary="(Experimental) Enable version control", description="")
    @RequestMapping(value={"/{metadataUuid}/versions"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public ResponseEntity enableVersionControl(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        this.dataManager.versionMetadata(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()), metadata.getXmlData(false));
        return new ResponseEntity(HttpStatus.CREATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="(Experimental) Enable version control for one or more records", description="")
    @RequestMapping(value={"/versions"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public MetadataProcessingReport enableVersionControlForRecords(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, HttpServletRequest request, @Parameter(hidden=true) HttpSession session) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            for (String uuid : records) {
                if (!this.metadataRepository.existsMetadataUuid(uuid)) {
                    report.incrementNullRecords();
                    continue;
                }
                for (AbstractMetadata metadata : this.metadataRepository.findAllByUuid(uuid)) {
                    if (!this.accessMan.canEdit(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
                        report.addNotEditableMetadataId(metadata.getId());
                        continue;
                    }
                    this.dataManager.versionMetadata(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()), metadata.getXmlData(false));
                    report.incrementProcessedRecords();
                }
            }
        }
        return report;
    }
}

