/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordImportedEvent;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="samplesAndTemplates")
@ReadWriteController
public class MetadataSampleApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    SchemaManager schemaManager;

    @Operation(summary="Add samples", description="Add sample records for one or more schemas. Samples are defined for each standard in the samples folder as MEF files.")
    @RequestMapping(value={"/samples"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Return a report of what has been done."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport addSamples(@Parameter(description="Schema identifiers", required=true, example="iso19139") @RequestParam(required=false) String[] schema, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        Element params = new Element("params");
        params.addContent((Content)new Element("file_type").setText("mef"));
        params.addContent((Content)new Element("uuidAction").setText(MEFLib.UuidAction.NOTHING.toString()));
        for (String schemaName : schema) {
            ArrayList sampleDataFilesList;
            Log.info((String)"geonetwork.datamanager", (Object)("Loading sample data for schema " + schemaName));
            Path schemaDir = this.schemaManager.getSchemaSampleDataDir(schemaName);
            if (schemaDir == null) {
                report.addInfos(String.format("No samples available for schema '%s'.", schemaName));
                continue;
            }
            if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                Log.debug((String)"geonetwork.datamanager", (Object)("Searching for mefs in: " + schemaDir));
            }
            DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(schemaDir, "*.mef");
            Object object = null;
            try {
                sampleDataFilesList = Lists.newArrayList(newDirectoryStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (newDirectoryStream != null) {
                    if (object != null) {
                        try {
                            newDirectoryStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        newDirectoryStream.close();
                    }
                }
            }
            int schemaCount = 0;
            for (Path file : sampleDataFilesList) {
                try {
                    List importedMdIds;
                    if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                        Log.debug((String)"geonetwork.datamanager", (Object)String.format("Loading %s sample file %s ...", schemaName, file));
                    }
                    if ((importedMdIds = MEFLib.doImport((Element)params, (ServiceContext)context, (Path)file, null)) != null && importedMdIds.size() > 0) {
                        schemaCount += importedMdIds.size();
                        for (String mdId : importedMdIds) {
                            AbstractMetadata metadata = ApiUtils.getRecord(mdId);
                            new RecordImportedEvent(Integer.valueOf(Integer.parseInt(mdId)), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)userSession.getPrincipal(), (String)"user"), metadata.getData()).publish((ApplicationContext)applicationContext);
                        }
                    }
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.datamanager", (String)String.format("Error loading %s sample file %s. Error is %s.", schemaName, file, e.getMessage()), (Throwable)e);
                    report.addError(new Exception(String.format("Error loading '%s' sample file '%s'. Error is %s.", schemaName, file, e.getMessage())));
                }
                this.dataManager.flush();
            }
            report.addInfos(String.format("%d record(s) added for schema '%s'.", schemaCount, schemaName));
        }
        report.close();
        return report;
    }

    @Operation(summary="Add templates", description="Add template records for one or more schemas. Templates are defined for each standard in the template folder as XML files. Template may also contains subtemplates.")
    @RequestMapping(value={"/templates"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Return a report of what has been done."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport addTemplates(@Parameter(description="Schema identifiers", required=true, example="iso19139") @RequestParam(required=false) String[] schema, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        String siteId = this.settingManager.getSiteId();
        int owner = ApiUtils.getUserSession(session).getUserIdAsInt();
        Log.info((String)"geonetwork.datamanager", (Object)String.format("Loading templates for schemas '%s'.", schema));
        for (String schemaName : schema) {
            Path templatesDir = this.schemaManager.getSchemaTemplatesDir(schemaName);
            if (templatesDir == null) {
                report.addInfos(String.format("No templates available for schema '%s'.", schemaName));
                continue;
            }
            String subTemplatePrefix = "sub-";
            String templateOfSubTemplatePrefix = "sub-tpl-";
            int prefixLength = "sub-".length();
            int schemaCount = 0;
            try (DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(templatesDir, "*.xml");){
                for (Path temp : newDirectoryStream) {
                    String status = "failed";
                    String templateName = temp.getFileName().toString();
                    Element template = new Element("template");
                    template.setAttribute("name", templateName);
                    if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                        Log.debug((String)"geonetwork.datamanager", (Object)String.format(" - Adding %s template file %s ...", schemaName, templateName));
                    }
                    try {
                        String tryUuid;
                        Element xml = Xml.loadFile((Path)temp);
                        String uuid = UUID.randomUUID().toString();
                        String isTemplate = "y";
                        Object title = null;
                        if (templateName.startsWith("sub-")) {
                            String string = isTemplate = templateName.startsWith("sub-tpl-") ? "t" : "s";
                        }
                        if (isTemplate.equals("s") && !StringUtils.isEmpty((String)(tryUuid = xml.getAttributeValue("uuid")))) {
                            uuid = tryUuid;
                        }
                        if (this.dataManager.existsMetadataUuid(uuid)) {
                            String upid = this.dataManager.getMetadataId(uuid);
                            AbstractMetadata metadata = this.dataManager.updateMetadata(context, upid, xml, false, true, context.getLanguage(), null, true, IndexingMode.none);
                            report.addMetadataInfos(metadata, String.format("Template for schema '%s' with UUID '%s' updated.", schemaName, uuid));
                        } else {
                            Metadata metadata = new Metadata();
                            metadata.setUuid(uuid);
                            metadata.getDataInfo().setSchemaId(schemaName).setRoot(xml.getQualifiedName()).setType(MetadataType.lookup((String)isTemplate));
                            metadata.getSourceInfo().setSourceId(siteId).setOwner(Integer.valueOf(owner)).setGroupOwner(Integer.valueOf(1));
                            if (MetadataType.lookup((String)isTemplate) == MetadataType.TEMPLATE) {
                                xml = this.dataManager.setUUID(schemaName, uuid, xml);
                            }
                            this.dataManager.insertMetadata(context, (AbstractMetadata)metadata, xml, IndexingMode.full, true, UpdateDatestamp.NO, false, true);
                            report.addMetadataInfos((AbstractMetadata)metadata, String.format("Template for schema '%s' with UUID '%s' added.", schemaName, metadata.getUuid()));
                        }
                        ++schemaCount;
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.datamanager", (String)String.format("Error loading %s template file %s. Error is %s.", schemaName, temp, e.getMessage()), (Throwable)e);
                        report.addError(new Exception(String.format("Error loading '%s' template file '%s'. Error is %s.", schemaName, temp, e.getMessage())));
                    }
                }
            }
            report.addInfos(String.format("%d record(s) added for schema '%s'.", schemaCount, schemaName));
        }
        report.close();
        return report;
    }
}

