/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.categories;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.tools.i18n.TranslationPackBuilder;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/tags"})
@Tag(name="tags", description="Tags operations")
@Controller(value="tags")
public class TagsApi {
    @Autowired
    private MetadataCategoryRepository categoryRepository;
    @Autowired
    private LanguageRepository langRepository;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private TranslationPackBuilder translationPackBuilder;

    @Operation(summary="Get tags", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of tags.")})
    @ResponseBody
    public List<MetadataCategory> getTags() throws Exception {
        return this.categoryRepository.findAll();
    }

    @Operation(summary="Create a tag", description="If labels are not defined, a default label is created with the category name for all languages.")
    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Tag created. Return the new tag identifier."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public ResponseEntity<Integer> putTag(@Parameter(name="category") @RequestBody MetadataCategory category) throws Exception {
        Optional existingCategory = this.categoryRepository.findById((Object)category.getId());
        if (existingCategory.isPresent()) {
            throw new IllegalArgumentException(String.format("A tag with id '%d' already exist", category.getId()));
        }
        MetadataCategory existingName = this.categoryRepository.findOneByName(category.getName());
        if (existingName != null) {
            throw new IllegalArgumentException(String.format("A category with name '%s' already exist.", category.getName()));
        }
        List allLanguages = this.langRepository.findAll();
        Map labelTranslations = category.getLabelTranslations();
        for (Language l : allLanguages) {
            String label = (String)labelTranslations.get(l.getId());
            category.getLabelTranslations().put(l.getId(), label == null ? category.getName() : label);
        }
        this.categoryRepository.save((Object)category);
        this.translationPackBuilder.clearCache();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(summary="Get a tag", description="")
    @RequestMapping(value={"/{tagIdentifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Tag details.")})
    @ResponseBody
    public MetadataCategory getTag(@Parameter(description="Tag identifier", required=true) @PathVariable Integer tagIdentifier) throws Exception {
        Optional category = this.categoryRepository.findById((Object)tagIdentifier);
        if (!category.isPresent()) {
            throw new ResourceNotFoundException("Category not found");
        }
        return (MetadataCategory)category.get();
    }

    @Operation(summary="Update a tag", description="")
    @RequestMapping(value={"/{tagIdentifier}"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Tag updated."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public ResponseEntity updateTag(@Parameter(description="Tag identifier", required=true) @PathVariable int tagIdentifier, @Parameter(name="category") @RequestBody MetadataCategory category) throws Exception {
        Optional existingCategory = this.categoryRepository.findById((Object)tagIdentifier);
        if (existingCategory.isPresent()) {
            boolean clearTranslationPackCache = !((MetadataCategory)existingCategory.get()).getLabelTranslations().equals(category.getLabelTranslations());
            this.updateCategory(tagIdentifier, category);
            if (clearTranslationPackCache) {
                this.translationPackBuilder.clearCache();
            }
        } else {
            throw new ResourceNotFoundException(String.format("Category with id '%d' does not exist.", tagIdentifier));
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private void updateCategory(int categoryIdentifier, MetadataCategory category) {
        this.categoryRepository.update((Serializable)Integer.valueOf(categoryIdentifier), entity -> {
            entity.setName(category.getName());
            Map labelTranslations = category.getLabelTranslations();
            if (labelTranslations != null) {
                entity.getLabelTranslations().clear();
                entity.getLabelTranslations().putAll(labelTranslations);
            }
        });
    }

    @Operation(summary="Remove a tag", description="")
    @RequestMapping(value={"/{tagIdentifier}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Tag removed."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public ResponseEntity deleteTag(@Parameter(description="Tag identifier", required=true) @PathVariable Integer tagIdentifier) throws Exception {
        Optional category = this.categoryRepository.findById((Object)tagIdentifier);
        if (category.isPresent()) {
            long recordsCount = this.metadataRepository.count(MetadataSpecs.hasCategory((MetadataCategory)((MetadataCategory)category.get())));
            if (recordsCount > 0L) {
                throw new IllegalArgumentException(String.format("Tag '%s' is assigned to %d records. Update records first in order to remove that tag.", ((MetadataCategory)category.get()).getName(), recordsCount));
            }
        } else {
            throw new ResourceNotFoundException(String.format("Category with id '%d' does not exist.", tagIdentifier));
        }
        this.categoryRepository.deleteById((Object)tagIdentifier);
        this.translationPackBuilder.clearCache();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

