/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.translations;

import java.util.List;
import java.util.Optional;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.translations.ITranslationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TranslationFactory {
    private SettingManager settingManager;
    private List<ITranslationService> translationServiceList;

    @Autowired
    public TranslationFactory(SettingManager settingManager, List<ITranslationService> translationServiceList) {
        this.settingManager = settingManager;
        this.translationServiceList = translationServiceList;
    }

    public Optional<ITranslationService> getTranslationService() {
        String translationProvider = this.settingManager.getValue("system/translation/provider");
        if (StringUtils.hasLength((String)translationProvider)) {
            return this.translationServiceList.stream().filter(t -> t.name().equals(translationProvider)).findFirst();
        }
        return Optional.ofNullable(null);
    }
}

