/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.Internal;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;

public class TemplateBasedQueryFactory {
    protected static Log log = LogFactory.getLog(TemplateBasedQueryFactory.class);
    private static final String START_VALUE = "query.";

    public static InternalModelRootNode visit(InternalModelRootNode qn, Map values) {
        HashMap query_index = new HashMap();
        TemplateBasedQueryFactory.buildIndex(qn, query_index);
        for (String key : new TreeSet(values.keySet())) {
            if (!key.startsWith(START_VALUE)) continue;
            try {
                String[] key_parts = key.split("\\.");
                Object selected_node = query_index.get(key_parts[1]);
                if (selected_node != null && values.get(key) != null) {
                    Object src_object = values.get(key);
                    String source_value = null;
                    if (src_object instanceof String[]) {
                        String[] src_array = (String[])src_object;
                        source_value = src_array[0];
                    } else {
                        source_value = src_object.toString();
                    }
                    Vector<String> values_list = new Vector<String>();
                    log.debug((Object)("Checking " + key + "=\"" + source_value + "\" - " + source_value.getClass().getName()));
                    if (selected_node instanceof AttrPlusTermNode && ((AttrPlusTermNode)selected_node).getDefaultMultiTermOperator() == 2) {
                        if (source_value != null && source_value.length() > 0) {
                            values_list.add(source_value.replaceAll("\"", "\\\\\""));
                        }
                    } else {
                        StreamTokenizer st = new StreamTokenizer(new StringReader(source_value));
                        st.wordChars(37, 37);
                        st.wordChars(42, 42);
                        st.wordChars(40, 40);
                        st.wordChars(41, 41);
                        st.wordChars(62, 62);
                        st.wordChars(60, 60);
                        st.wordChars(126, 126);
                        st.quoteChar(34);
                        block9: while (st.nextToken() != -1) {
                            switch (st.ttype) {
                                case -3: {
                                    values_list.add(st.sval);
                                    continue block9;
                                }
                                case -2: {
                                    values_list.add("" + st.nval);
                                    continue block9;
                                }
                            }
                            values_list.add(st.sval);
                        }
                    }
                    try {
                        if (values_list.size() == 0) {
                            log.debug((Object)("No value for " + key_parts[1] + "." + key_parts[2]));
                            continue;
                        }
                        if (values_list.size() == 1) {
                            log.debug((Object)("Set single " + key_parts[1] + "." + key_parts[2] + "=" + values_list.get(0)));
                            BeanUtils.setProperty(selected_node, (String)key_parts[2], values_list.get(0));
                            continue;
                        }
                        log.debug((Object)("Set list " + key_parts[1] + "." + key_parts[2] + "=" + values_list));
                        BeanUtils.setProperty(selected_node, (String)key_parts[2], values_list);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                log.debug((Object)("Unable to locate query node for " + key));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        InternalModelRootNode imrn = qn;
        return new InternalModelRootNode(TemplateBasedQueryFactory.visit(imrn.getChild()));
    }

    private static QueryNode visit(QueryNode qn) {
        if (qn instanceof InternalModelNamespaceNode) {
            InternalModelNamespaceNode imns = (InternalModelNamespaceNode)qn;
            return new InternalModelNamespaceNode(imns.getAttrset(), TemplateBasedQueryFactory.visit(imns.getChild()));
        }
        if (qn instanceof ComplexNode) {
            ComplexNode cn = (ComplexNode)qn;
            QueryNode lhs = null;
            QueryNode rhs = null;
            lhs = TemplateBasedQueryFactory.visit(cn.getLHS());
            rhs = TemplateBasedQueryFactory.visit(cn.getRHS());
            if (lhs != null && rhs != null) {
                return new ComplexNode(lhs, rhs, cn.getOp());
            }
            if (lhs != null) {
                return lhs;
            }
            return rhs;
        }
        if (qn instanceof AttrPlusTermNode) {
            AttrPlusTermNode aptn = (AttrPlusTermNode)qn;
            AttrPlusTermNode result = null;
            if (aptn.countChildrenWithTerms() > 0) {
                result = (AttrPlusTermNode)aptn.clone();
            }
            return result;
        }
        return null;
    }

    private static void buildIndex(QueryNode qn, Map query_index) {
        if (qn.getNodeName() != null && !qn.getNodeName().equals("")) {
            query_index.put(qn.getNodeName(), qn);
        }
        if (qn instanceof InternalModelRootNode) {
            InternalModelRootNode imrn = (InternalModelRootNode)qn;
            TemplateBasedQueryFactory.buildIndex(imrn.getChild(), query_index);
        } else if (qn instanceof InternalModelNamespaceNode) {
            InternalModelNamespaceNode imns = (InternalModelNamespaceNode)qn;
            TemplateBasedQueryFactory.buildIndex(imns.getChild(), query_index);
        } else if (qn instanceof ComplexNode) {
            ComplexNode cn = (ComplexNode)qn;
            if (cn.getLHS() != null) {
                TemplateBasedQueryFactory.buildIndex(cn.getLHS(), query_index);
            } else {
                System.err.println("node with id " + qn.getNodeName() + "has null LHS");
            }
            if (cn.getRHS() != null) {
                TemplateBasedQueryFactory.buildIndex(cn.getRHS(), query_index);
            } else {
                System.err.println("node with id " + qn.getNodeName() + "has null RHS");
            }
        } else if (qn instanceof AttrPlusTermNode) {
            // empty if block
        }
    }
}

