/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.UserSecurityNotification;
import org.jdom.Element;

@Embeddable
public class UserSecurity
extends GeonetEntity
implements Serializable {
    private char[] _password;
    private Set<UserSecurityNotification> _securityNotifications = new HashSet<UserSecurityNotification>();
    private String _authType;
    private String _nodeId;

    @Column(nullable=false, length=120)
    @Nonnull
    public char[] getPassword() {
        return this._password == null ? new char[]{} : (char[])this._password.clone();
    }

    @Nonnull
    @JsonIgnore
    public UserSecurity setPassword(@Nonnull char[] password) {
        this._password = password == null ? new char[]{} : (char[])password.clone();
        return this;
    }

    public UserSecurity setPassword(String password) {
        this.setPassword(password.toCharArray());
        return this;
    }

    @Column(name="security", length=128)
    protected String getSecurityNotificationsString() {
        StringBuilder builder = new StringBuilder();
        for (UserSecurityNotification not : this._securityNotifications) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(not.toString());
        }
        return builder.toString();
    }

    protected UserSecurity setSecurityNotificationsString(String securityNotifications) {
        this._securityNotifications.clear();
        if (securityNotifications != null) {
            String[] parts;
            for (String string : parts = securityNotifications.split(",")) {
                if (string.trim().isEmpty()) continue;
                this._securityNotifications.add(UserSecurityNotification.find(string));
            }
        }
        return this;
    }

    @Transient
    public Set<UserSecurityNotification> getSecurityNotifications() {
        return this._securityNotifications;
    }

    @Column(name="authtype", length=32)
    public String getAuthType() {
        return this._authType;
    }

    public UserSecurity setAuthType(String authType) {
        this._authType = authType;
        return this;
    }

    public void mergeSecurity(UserSecurity otherSecurity, boolean mergeNullData) {
        if (mergeNullData || otherSecurity.getPassword() != null) {
            this.setPassword(otherSecurity.getPassword());
        }
        if (mergeNullData || otherSecurity.getSecurityNotifications() != null) {
            this.setSecurityNotificationsString(otherSecurity.getSecurityNotificationsString());
        }
        if (mergeNullData || otherSecurity.getAuthType() != null) {
            this.setAuthType(otherSecurity.getAuthType());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSecurity that = (UserSecurity)o;
        if (this._authType != null ? !this._authType.equals(that._authType) : that._authType != null) {
            return false;
        }
        if (this._nodeId != null ? !this._nodeId.equals(that._nodeId) : that._nodeId != null) {
            return false;
        }
        if (!Arrays.equals(this._password, that._password)) {
            return false;
        }
        return this._securityNotifications.equals(that._securityNotifications);
    }

    public int hashCode() {
        int result = this._password != null ? Arrays.hashCode(this._password) : 0;
        result = 31 * result + this._securityNotifications.hashCode();
        result = 31 * result + (this._authType != null ? this._authType.hashCode() : 0);
        result = 31 * result + (this._nodeId != null ? this._nodeId.hashCode() : 0);
        return result;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public void setNodeId(String associatedNode) {
        this._nodeId = associatedNode;
    }

    @Override
    protected Element asXml(IdentityHashMap<Object, Void> alreadyEncoded) {
        Element element = super.asXml(alreadyEncoded);
        element.removeChild("password");
        return element;
    }
}

