/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import javax.annotation.Nonnull;

public enum MetadataType {
    METADATA('n'),
    TEMPLATE('y'),
    SUB_TEMPLATE('s'),
    TEMPLATE_OF_SUB_TEMPLATE('t');

    public final char code;
    public final String codeString;

    private MetadataType(char code) {
        this.code = code;
        this.codeString = String.valueOf(code);
    }

    @Nonnull
    public static MetadataType lookup(char code) {
        for (MetadataType type : MetadataType.values()) {
            if (type.code != code) continue;
            return type;
        }
        throw new IllegalArgumentException("Not a known MetadataType code: " + code);
    }

    @Nonnull
    public static MetadataType lookup(@Nonnull String code) {
        String trimmedCode = code.trim();
        if (trimmedCode.length() == 1) {
            return MetadataType.lookup(trimmedCode.charAt(0));
        }
        for (MetadataType type : MetadataType.values()) {
            if (!type.toString().equalsIgnoreCase(trimmedCode.toLowerCase())) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("'%s' is not a known metadata type code. Values are: %s", new Object[]{trimmedCode, MetadataType.values()}));
    }
}

