/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v1_x;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import net.opengis.ows10.KeywordsType;
import net.opengis.ows10.OnlineResourceType;
import net.opengis.ows10.ServiceIdentificationType;
import net.opengis.ows10.ServiceProviderType;
import net.opengis.wfs.WFSCapabilitiesType;
import org.eclipse.emf.common.util.EList;
import org.geotools.data.wfs.WFSServiceInfo;

public final class CapabilitiesServiceInfo
implements WFSServiceInfo {
    private final WFSCapabilitiesType capabilities;
    private final URI schemaUri;
    private final URI getCapsUrl;

    public CapabilitiesServiceInfo(String schemaUri, URL getCapsUrl, WFSCapabilitiesType capabilities) {
        try {
            this.getCapsUrl = getCapsUrl.toURI();
            this.schemaUri = new URI(schemaUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.capabilities = capabilities;
    }

    public String getDescription() {
        ServiceIdentificationType serviceIdentification = this.capabilities.getServiceIdentification();
        return serviceIdentification == null ? null : serviceIdentification.getAbstract();
    }

    public Icon getIcon() {
        return null;
    }

    public Set<String> getKeywords() {
        EList keywords;
        HashSet<String> kws = new HashSet<String>();
        ServiceIdentificationType serviceIdentification = this.capabilities.getServiceIdentification();
        if (serviceIdentification != null && (keywords = serviceIdentification.getKeywords()) != null) {
            for (KeywordsType k : keywords) {
                kws.addAll((Collection<String>)k.getKeyword());
            }
            kws.remove(null);
        }
        return kws;
    }

    public URI getPublisher() {
        ServiceProviderType serviceProvider = this.capabilities.getServiceProvider();
        if (null == serviceProvider) {
            return null;
        }
        OnlineResourceType providerSite = serviceProvider.getProviderSite();
        if (null == providerSite) {
            return null;
        }
        String href = providerSite.getHref();
        try {
            return href == null ? null : new URI(href);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public URI getSchema() {
        return this.schemaUri;
    }

    public URI getSource() {
        return this.getCapsUrl;
    }

    public String getTitle() {
        ServiceIdentificationType serviceIdentification = this.capabilities.getServiceIdentification();
        return serviceIdentification == null ? null : serviceIdentification.getTitle();
    }

    @Override
    public String getVersion() {
        return this.capabilities.getVersion();
    }
}

