/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InvertAxisFilterVisitor
extends DuplicatingFilterVisitor {
    private GeometryFactory geometryFactory;

    public InvertAxisFilterVisitor(FilterFactory2 factory, GeometryFactory geometryFactory) {
        super(factory);
        this.geometryFactory = geometryFactory;
    }

    public Object visit(BBOX filter, Object extraData) {
        if (filter.getExpression2() instanceof Literal) {
            Literal bboxLiteral = (Literal)filter.getExpression2();
            if (bboxLiteral.getValue() instanceof BoundingBox) {
                BoundingBox bounds = (BoundingBox)bboxLiteral.getValue();
                return this.ff.bbox(filter.getExpression1(), (BoundingBox)new ReferencedEnvelope(bounds.getMinY(), bounds.getMaxY(), bounds.getMinX(), bounds.getMaxX(), bounds.getCoordinateReferenceSystem()));
            }
            if (bboxLiteral.getValue() instanceof Geometry) {
                Geometry geom = (Geometry)bboxLiteral.getValue();
                Envelope geomEnvelope = geom.getEnvelopeInternal();
                CoordinateReferenceSystem crs = null;
                if (geom.getUserData() instanceof CoordinateReferenceSystem) {
                    crs = (CoordinateReferenceSystem)geom.getUserData();
                }
                return this.ff.bbox(filter.getExpression1(), (BoundingBox)new ReferencedEnvelope(geomEnvelope.getMinY(), geomEnvelope.getMaxY(), geomEnvelope.getMinX(), geomEnvelope.getMaxX(), crs));
            }
        }
        return filter;
    }

    public Object visit(Literal expression, Object extraData) {
        if (!(expression.getValue() instanceof Geometry)) {
            return super.visit(expression, extraData);
        }
        Geometry geom = (Geometry)expression.getValue();
        return this.ff.literal((Object)this.invertGeometryCoordinates(geom));
    }

    private Geometry invertGeometryCoordinates(Geometry geom) {
        if (geom instanceof Point) {
            Point point = (Point)geom;
            Coordinate inverted = this.invertCoordinate(point.getCoordinate());
            return this.geometryFactory.createPoint(inverted);
        }
        if (geom instanceof LineString) {
            Coordinate[] inverted = this.invertCoordinates(geom.getCoordinates());
            return this.geometryFactory.createLineString(inverted);
        }
        if (geom instanceof Polygon) {
            Polygon polygon = (Polygon)geom;
            Coordinate[] shellCoordinates = polygon.getExteriorRing().getCoordinates();
            LinearRing invertedShell = this.geometryFactory.createLinearRing(this.invertCoordinates(shellCoordinates));
            LinearRing[] invertedHoles = new LinearRing[polygon.getNumInteriorRing()];
            for (int count = 0; count < polygon.getNumInteriorRing(); ++count) {
                Coordinate[] holeCoordinates = polygon.getInteriorRingN(count).getCoordinates();
                invertedHoles[count] = this.geometryFactory.createLinearRing(this.invertCoordinates(holeCoordinates));
            }
            return this.geometryFactory.createPolygon(invertedShell, invertedHoles);
        }
        if (geom instanceof MultiPoint) {
            return this.geometryFactory.createMultiPoint((CoordinateSequence)new CoordinateArraySequence(this.invertCoordinates(geom.getCoordinates())));
        }
        if (geom instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geom;
            LineString[] inverted = new LineString[multiLineString.getNumGeometries()];
            for (int count = 0; count < multiLineString.getNumGeometries(); ++count) {
                inverted[count] = (LineString)this.invertGeometryCoordinates(multiLineString.getGeometryN(count));
            }
            return this.geometryFactory.createMultiLineString(inverted);
        }
        if (geom instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geom;
            Polygon[] inverted = new Polygon[multiPolygon.getNumGeometries()];
            for (int count = 0; count < multiPolygon.getNumGeometries(); ++count) {
                inverted[count] = (Polygon)this.invertGeometryCoordinates(multiPolygon.getGeometryN(count));
            }
            return this.geometryFactory.createMultiPolygon(inverted);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geom;
            Geometry[] inverted = new Geometry[collection.getNumGeometries()];
            for (int count = 0; count < collection.getNumGeometries(); ++count) {
                inverted[count] = this.invertGeometryCoordinates(collection.getGeometryN(count));
            }
            return this.geometryFactory.createGeometryCollection(inverted);
        }
        throw new IllegalArgumentException("Unknown geometry type: " + geom.getGeometryType());
    }

    private Coordinate[] invertCoordinates(Coordinate[] coordinates) {
        Coordinate[] result = new Coordinate[coordinates.length];
        for (int count = 0; count < coordinates.length; ++count) {
            result[count] = this.invertCoordinate(coordinates[count]);
        }
        return result;
    }

    private Coordinate invertCoordinate(Coordinate coordinate) {
        return new Coordinate(coordinate.y, coordinate.x, coordinate.getZ());
    }
}

