/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.comp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.comp.ModuleInfo;
import org.jzkit.a2j.codec.comp.TaggedMember;
import org.jzkit.a2j.codec.comp.TypeInfo;

public class SequenceTypeInfo
extends TypeInfo {
    private static Logger log = Logger.getLogger(SequenceTypeInfo.class.getName());

    public SequenceTypeInfo(String type_reference, boolean builtin_type, int tag_class, int tag_number, boolean is_implicit, String basetype, String internal_type, ModuleInfo mi) {
        super(type_reference, builtin_type, tag_class, tag_number, is_implicit, basetype, internal_type, mi);
        this.internal_type = this.type_class_name;
    }

    public SequenceTypeInfo(String type_reference, boolean builtin_type, String basetype, String internal_type, ModuleInfo mi) {
        super(type_reference, builtin_type, basetype, internal_type, mi);
        this.internal_type = this.type_class_name;
    }

    public void writeTypeSpecificStaticInitialisationCode(StringWriter func, StringWriter declarations) {
        Vector<String> added_so_far = new Vector<String>();
        for (TypeInfo codec_to_add : this.codecs_used_by_this_codec) {
            String cname = codec_to_add.getCodecClassName();
            if (added_so_far.contains(cname)) continue;
            added_so_far.add(cname);
            declarations.write("  private " + codec_to_add.getCodecClassName() + " i_" + codec_to_add.getCodecClassName().toLowerCase() + " = " + codec_to_add.getCodecClassName() + ".getCodec();\n");
        }
        declarations.write("\n");
    }

    public void createTypeClassFile() {
        log.fine("SequenceTypeInfo::createTypeClassFile()");
        String type_file_name = this.parent.getModulePackageDir() + File.separatorChar + this.type_reference.replace('-', '_') + "_type.java";
        File type_source_file = new File(type_file_name);
        FileWriter type_writer = null;
        try {
            if (type_source_file.exists()) {
                log.fine(type_file_name + " type already exists");
            } else {
                log.fine("            create type source file : " + type_file_name);
                type_source_file.createNewFile();
            }
            type_writer = new FileWriter(type_source_file);
            log.fine("Package is " + this.parent.getModulePackageName() + "." + this.type_reference.replace('-', '_'));
            StringWriter declarations_stream = new StringWriter();
            StringWriter imports_stream = new StringWriter();
            StringWriter constructor_sig_stream = new StringWriter();
            StringWriter constructor_body_stream = new StringWriter();
            this.parent.addImportStatementsToClass(imports_stream, false, true);
            type_writer.write("package " + this.parent.getModulePackageName() + ";\n\n");
            type_writer.write("import java.math.BigInteger;\n");
            type_writer.write("import java.util.ArrayList;\n");
            type_writer.write("import java.io.Serializable;\n");
            type_writer.write("import org.jzkit.a2j.codec.runtime.*;\n");
            type_writer.write("import org.jzkit.a2j.gen.AsnUseful.*;\n\n");
            type_writer.write(imports_stream.toString());
            type_writer.write("/** \n *  A Java holder for the ASN type : " + this.type_class_name + " \n");
            type_writer.write(" *  @author Auto generated by A2J: An ASN to Java Precompiler - http://developer.k-int.com/projects/a2j\n");
            type_writer.write(" */ \n");
            type_writer.write("public class " + this.type_class_name + " implements Serializable \n{\n");
            constructor_sig_stream.write("\n\n    public " + this.type_class_name + "(");
            constructor_body_stream.write("    {");
            boolean first = true;
            Enumeration e = this.cons_members.elements();
            while (e.hasMoreElements()) {
                TaggedMember t = (TaggedMember)e.nextElement();
                log.fine("Looking up type information for " + t.getTypeReference());
                TypeInfo ti = this.parent.lookup(null, t.getTypeReference(), true);
                if (null != ti) {
                    log.fine("Got type reference for " + t.getMemberName());
                    type_writer.write("    /** ");
                    if (t.isOptional()) {
                        type_writer.write("Optional member ");
                    } else {
                        type_writer.write("Mandatory member ");
                    }
                    type_writer.write("*/\n");
                    type_writer.write("    public " + ti.getInternalType() + " " + t.getMemberName() + " = ");
                    Object default_value = t.getDefaultValue();
                    if (default_value == null) {
                        type_writer.write("null;\n");
                    } else if (default_value instanceof Boolean) {
                        if (((Boolean)default_value).booleanValue()) {
                            type_writer.write("Boolean.TRUE;\n");
                        } else {
                            type_writer.write("Boolean.FALSE;\n");
                        }
                    } else if (default_value instanceof String) {
                        type_writer.write(" new " + ti.getInternalType() + "(\"" + default_value + "\");\n");
                    } else {
                        type_writer.write("null;\n");
                    }
                    if (first) {
                        first = false;
                    } else {
                        constructor_sig_stream.write(",\n      ");
                    }
                    constructor_sig_stream.write(ti.getInternalType() + " " + t.getMemberName());
                    constructor_body_stream.write("\n        this." + t.getMemberName() + "=" + t.getMemberName() + ";");
                    continue;
                }
                log.log(Level.WARNING, "Unable to locate type information for " + t.getTypeReference());
            }
            constructor_sig_stream.write(")\n");
            constructor_body_stream.write("\n    }");
            type_writer.write(declarations_stream.toString());
            type_writer.write(constructor_sig_stream.toString());
            type_writer.write(constructor_body_stream.toString());
            type_writer.write("\n\n    public " + this.type_class_name + "() {}\n\n");
            type_writer.write("\n}\n");
            type_writer.flush();
            type_writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(0);
        }
    }

    public void writeSerializeMethod(StringWriter func, StringWriter declarations) {
        func.write("/** Convert this java type to or from a string of octets using the supplied \n");
        func.write(" *  serialisation manager\n");
        func.write(" *  @author A2J Auto Generated Java Class\n");
        func.write(" *  @param sm The Serialisation Manager \n");
        func.write(" *  @param type_instance If we are encoding, the type to encode.\n");
        func.write(" *  @param is_optional Flag indicating if this type is optional\n");
        func.write(" *  @param type_name The type name for diagnostic information\n");
        func.write(" *  @return A decoded java type or the type that was passed in for encoding\n");
        func.write(" */  \n");
        func.write("  public Object serialize(SerializationManager sm,\n");
        func.write("                          Object type_instance,\n");
        func.write("                          boolean is_optional,\n");
        func.write("                          String type_name) throws java.io.IOException\n");
        func.write("  {\n");
        func.write("    " + this.type_class_name + " retval = (" + this.type_class_name + ")type_instance;\n\n");
        if (this.tag_class == -1) {
            func.write("    if ( sm.sequenceBegin() )\n    {\n");
        } else if (this.is_implicit) {
            func.write("    sm.implicit_settag(" + this.tag_class + ", " + this.tag_number + ");\n");
            func.write("    if ( sm.sequenceBegin() )\n    {\n");
        } else {
            func.write("    if ( sm.constructedBegin(" + this.tag_class + ", " + this.tag_number + ") )\n    {\n");
            func.write("      sm.sequenceBegin();\n");
        }
        func.write("\n      if ( sm.getDirection() == SerializationManager.DIRECTION_DECODE )\n      {\n");
        func.write("          retval = new " + this.type_class_name + "();\n");
        func.write("      }\n\n");
        Enumeration e = this.cons_members.elements();
        while (e.hasMoreElements()) {
            TaggedMember t = (TaggedMember)e.nextElement();
            TypeInfo ti = this.parent.lookup(null, t.getTypeReference(), true);
            if (null == ti) continue;
            String codec_to_use = "i_" + ti.getCodecClassName().toLowerCase();
            if (t.getTagClass() == -1) {
                func.write("      retval." + t.getMemberName() + " = (" + ti.getInternalType() + ")" + codec_to_use + ".serialize(sm, retval." + t.getMemberName() + "," + t.isOptional() + ", \"" + t.getMemberName() + "\");\n");
                continue;
            }
            if (t.isImplicit()) {
                func.write("      retval." + t.getMemberName() + " = (" + ti.getInternalType() + ")sm.implicit_tag(" + codec_to_use + ", retval." + t.getMemberName() + ", " + t.getTagClass() + ", " + t.getTagNumber() + ", " + t.isOptional() + ", \"" + t.getMemberName() + "\");\n");
                continue;
            }
            func.write("      retval." + t.getMemberName() + " = (" + ti.getInternalType() + ")sm.explicit_tag(" + codec_to_use + ", retval." + t.getMemberName() + ", " + t.getTagClass() + ", " + t.getTagNumber() + ", " + t.isOptional() + ", \"" + t.getMemberName() + "\");\n");
        }
        if (this.tag_class == -1) {
            func.write("      sm.sequenceEnd();\n    }\n\n");
        } else if (this.is_implicit) {
            func.write("      sm.sequenceEnd();\n    }\n\n");
        } else {
            func.write("      sm.sequenceEnd();\n");
            func.write("      sm.constructedEnd();\n    }\n\n");
        }
        func.write("    return retval;\n");
        func.write("  }\n");
    }
}

