/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.harvesting;

import java.nio.file.Path;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.HarvestHistory_;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.repository.HarvestHistoryRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.specification.HarvestHistorySpecs;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class History
implements Service {
    public void init(Path appPath, ServiceConfig config) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        long totalRecords;
        Element result;
        int page = Util.getParam((Element)params, (String)"page", (int)0);
        int pageSize = Util.getParam((Element)params, (String)"size", (int)Integer.MAX_VALUE);
        String uuid = params.getChildText("uuid");
        String sort = params.getChildText("sort");
        String sortCriteria = "date";
        if (sort != null && sort.equals("type")) {
            sortCriteria = "type";
        }
        HarvestHistoryRepository historyRepository = (HarvestHistoryRepository)context.getBean(HarvestHistoryRepository.class);
        Sort.Order harvestDateOrder = Sort.Order.desc((String)SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{HarvestHistory_.harvestDate}));
        Sort.Order harvesterUuidOrder = Sort.Order.by((String)SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{HarvestHistory_.harvesterUuid}));
        Sort.Order harvesterTypeSort = Sort.Order.by((String)SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{HarvestHistory_.harvesterType}));
        Sort springSort = sortCriteria.equals("date") ? Sort.by((Sort.Order[])new Sort.Order[]{harvestDateOrder, harvesterUuidOrder}) : Sort.by((Sort.Order[])new Sort.Order[]{harvesterTypeSort, harvestDateOrder, harvesterUuidOrder});
        PageRequest pageRequest = PageRequest.of((int)page, (int)pageSize, (Sort)springSort);
        if (uuid == null || uuid.equals("")) {
            result = historyRepository.findAllAsXml((Pageable)pageRequest);
            totalRecords = historyRepository.count();
        } else {
            Specification specification = HarvestHistorySpecs.hasHarvesterUuid((String)uuid);
            result = historyRepository.findAllAsXml(specification, (Pageable)pageRequest);
            totalRecords = historyRepository.count(specification);
        }
        String id = params.getChildText("id");
        Element harvesterInfo = ((HarvestManager)context.getBean(HarvestManager.class)).get(id, context, null);
        Element response = new Element("response");
        if (harvesterInfo != null) {
            Element sortEl = new Element("sort");
            sortEl.addContent(sortCriteria);
            response.addContent((Content)sortEl);
            response.addContent((Content)new Element("page").setText("" + page));
            response.addContent((Content)new Element("size").setText("" + pageSize));
            response.addContent((Content)new Element("total").setText("" + totalRecords));
            response.addContent((Content)new Element("pages").setText("" + totalRecords / (long)pageSize));
            response.addContent(result.detach());
            response.addContent(harvesterInfo.detach());
        }
        return response;
    }
}

