/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.simpleurl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.fao.geonet.Constants;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RDFUtils {
    public static final String RESOURCE_FOLDER = "harvester-resources/simpleUrl/";
    public static final String LOGGER_NAME = "geonetwork.harvester.simpleurl";

    public static HashMap<String, Element> getAllUuids(String feedUrl) throws Exception {
        Model model = ModelFactory.createMemModelMaker().createDefaultModel();
        RDFDataMgr.read((Model)model, (String)feedUrl);
        Element rdfModel = Xml.loadStream((InputStream)IOUtils.toInputStream((String)RDFUtils.toRdfString(model), (String)StandardCharsets.UTF_8.displayName()));
        return RDFUtils.getAllUuids(rdfModel);
    }

    public static HashMap<String, Element> getAllUuids(Element feed) throws Exception {
        Element rdfDocument = RDFUtils.checkForMissingRdfAbout(feed);
        Model model = ModelFactory.createMemModelMaker().createDefaultModel();
        RDFDataMgr.read((Model)model, (InputStream)IOUtils.toInputStream((String)Xml.getString((Element)rdfDocument), (Charset)StandardCharsets.UTF_8), (Lang)Lang.RDFXML);
        model = RDFUtils.checkAndCreateMissingCatalogRecords(model);
        Query queryRecordIds = QueryFactory.create((String)RDFUtils.getQueryString("extract-records-ids.rq"));
        QueryExecution qe = QueryExecutionFactory.create((Query)queryRecordIds, (Model)model);
        ResultSet resultIds = qe.execSelect();
        HashMap<String, Element> records = new HashMap<String, Element>();
        while (resultIds.hasNext()) {
            Pair<String, Element> recordInfo = RDFUtils.getRecordInfo(resultIds.nextSolution(), model);
            if (recordInfo == null) continue;
            records.put((String)recordInfo.one(), (Element)recordInfo.two());
        }
        qe.close();
        model.close();
        return records;
    }

    private static Element checkForMissingRdfAbout(Element rdfModel) throws Exception {
        List ns = rdfModel.getAdditionalNamespaces();
        List nodeWithNoRdfAbout = Xml.selectNodes((Element)rdfModel, (String)".//*[local-name() = 'Dataset' or local-name() = 'DataService'][not(@rdf:about)]", (List)ns);
        nodeWithNoRdfAbout.forEach(n -> {
            try {
                Object httpIdentifier = Xml.selectSingle((Element)n, (String)"dct:identifier[matches(., '^http(s)://.*$')]/text()", (List)ns);
                if (httpIdentifier != null) {
                    n.setAttribute("rdf:about", (String)httpIdentifier);
                }
            }
            catch (JDOMException jDOMException) {
                // empty catch block
            }
        });
        return rdfModel;
    }

    private static Model checkAndCreateMissingCatalogRecords(Model model) throws IOException, URISyntaxException {
        Query queryExtractNoRec = QueryFactory.create((String)RDFUtils.getQueryString("extract-resources-no-records.rq"));
        QueryExecution qe = QueryExecutionFactory.create((Query)queryExtractNoRec, (Model)model);
        Model newModel = model;
        ResultSet resultIds = qe.execSelect();
        while (resultIds.hasNext()) {
            QuerySolution solution = resultIds.nextSolution();
            newModel = RDFUtils.createCatalogRecord(newModel, solution.get("resourceId").toString(), solution.get("catalogId").toString());
        }
        return newModel;
    }

    private static InputStream getResourceAsStream(String resourcePath) {
        return RDFUtils.class.getClassLoader().getResourceAsStream(resourcePath);
    }

    private static String toRdfString(Model model) {
        StringWriter out = new StringWriter();
        RDFDataMgr.write((StringWriter)out, (Model)model, (Lang)Lang.RDFXML);
        return out.toString();
    }

    private static String getQueryString(String queryFile) throws IOException, URISyntaxException {
        return IOUtils.toString((InputStream)RDFUtils.getResourceAsStream("harvester-resources/simpleUrl/sparql/" + queryFile), (Charset)Constants.CHARSET);
    }

    private static Model createCatalogRecord(Model model, String resourceId, String catalogId) throws IOException, URISyntaxException {
        String recordUUID = resourceId;
        Date now = new Date();
        String localQuery = RDFUtils.getQueryString("add-CatalogRecord.rq").replace("%recordID%", recordUUID + "-record").replace("%recordUUID%", recordUUID).replace("%resourceId%", resourceId).replace("%modifiedDate%", new ISODate(now.getTime(), false).toString()).replace("%catalogId%", catalogId);
        Query queryFixBlankNodes = QueryFactory.create((String)localQuery);
        QueryExecution qe = QueryExecutionFactory.create((Query)queryFixBlankNodes, (Model)model);
        Model newModel = qe.execConstruct();
        qe.close();
        return newModel;
    }

    private static Pair<String, Element> getRecordInfo(QuerySolution solution, Model model) {
        try {
            String recordId = solution.get("recordId").toString();
            String resourceId = solution.get("resourceId").toString();
            String baseRecordUUID = solution.get("baseRecordUUID").toString();
            String localQueryBuildRecord = RDFUtils.getQueryString("build-record.rq").replace("%recordId%", recordId).replace("%resourceId%", resourceId);
            Query queryRecord = QueryFactory.create((String)localQueryBuildRecord);
            QueryExecution qe = QueryExecutionFactory.create((Query)queryRecord, (Model)model);
            ResultSet results = qe.execSelect();
            if (results.hasNext()) {
                ByteArrayOutputStream outxml = new ByteArrayOutputStream();
                ResultSetFormatter.outputAsXML((OutputStream)outxml, (ResultSet)results);
                Element sparqlResults = Xml.loadStream((InputStream)new ByteArrayInputStream(outxml.toByteArray()));
                qe.close();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("recordUUID", baseRecordUUID);
                return Pair.read((Object)baseRecordUUID, (Object)sparqlResults);
            }
            qe.close();
        }
        catch (IOException | URISyntaxException | JDOMException e) {
            Log.error((String)LOGGER_NAME, (Object)String.format("Error extracting record info using SPARQL. Error is: %s", e.getMessage()));
        }
        return null;
    }
}

