/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.comparators.MinDocIterator;

public class DocComparator
extends FieldComparator<Integer> {
    private final int[] docIDs;
    private final boolean enableSkipping;
    private int bottom;
    private int topValue;
    private boolean topValueSet;
    private boolean bottomValueSet;
    private boolean hitsThresholdReached;

    public DocComparator(int numHits, boolean reverse, int sortPost) {
        this.docIDs = new int[numHits];
        this.enableSkipping = !reverse && sortPost == 0;
    }

    @Override
    public int compare(int slot1, int slot2) {
        return this.docIDs[slot1] - this.docIDs[slot2];
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) {
        return new DocLeafComparator(context);
    }

    @Override
    public void setTopValue(Integer value) {
        this.topValue = value;
        this.topValueSet = true;
    }

    @Override
    public Integer value(int slot) {
        return this.docIDs[slot];
    }

    private class DocLeafComparator
    implements LeafFieldComparator {
        private final int docBase;
        private final int minDoc;
        private final int maxDoc;
        private DocIdSetIterator competitiveIterator;

        public DocLeafComparator(LeafReaderContext context) {
            this.docBase = context.docBase;
            if (DocComparator.this.enableSkipping) {
                this.minDoc = DocComparator.this.topValue;
                this.maxDoc = context.reader().maxDoc();
                this.competitiveIterator = DocIdSetIterator.all(this.maxDoc);
            } else {
                this.minDoc = -1;
                this.maxDoc = -1;
                this.competitiveIterator = null;
            }
        }

        @Override
        public void setBottom(int slot) {
            DocComparator.this.bottom = DocComparator.this.docIDs[slot];
            DocComparator.this.bottomValueSet = true;
            this.updateIterator();
        }

        @Override
        public int compareBottom(int doc) {
            return DocComparator.this.bottom - (this.docBase + doc);
        }

        @Override
        public int compareTop(int doc) {
            int docValue = this.docBase + doc;
            return Integer.compare(DocComparator.this.topValue, docValue);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            ((DocComparator)DocComparator.this).docIDs[slot] = this.docBase + doc;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.updateIterator();
        }

        @Override
        public DocIdSetIterator competitiveIterator() {
            if (!DocComparator.this.enableSkipping) {
                return null;
            }
            return new DocIdSetIterator(){
                private int docID;
                {
                    this.docID = DocLeafComparator.this.competitiveIterator.docID();
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.docID + 1);
                }

                @Override
                public int docID() {
                    return this.docID;
                }

                @Override
                public long cost() {
                    return DocLeafComparator.this.competitiveIterator.cost();
                }

                @Override
                public int advance(int target) throws IOException {
                    this.docID = DocLeafComparator.this.competitiveIterator.advance(target);
                    return this.docID;
                }
            };
        }

        @Override
        public void setHitsThresholdReached() {
            DocComparator.this.hitsThresholdReached = true;
            this.updateIterator();
        }

        private void updateIterator() {
            if (!DocComparator.this.enableSkipping || !DocComparator.this.hitsThresholdReached) {
                return;
            }
            if (DocComparator.this.bottomValueSet) {
                this.competitiveIterator = DocIdSetIterator.empty();
            } else if (DocComparator.this.topValueSet) {
                if (this.docBase + this.maxDoc <= this.minDoc) {
                    this.competitiveIterator = DocIdSetIterator.empty();
                } else {
                    int segmentMinDoc = Math.max(this.competitiveIterator.docID(), this.minDoc - this.docBase);
                    this.competitiveIterator = new MinDocIterator(segmentMinDoc, this.maxDoc);
                }
            }
        }
    }
}

