/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import org.globus.ftp.FeatureList;
import org.globus.ftp.HostPort;
import org.globus.ftp.exception.ClientException;

public class Session {
    public static final int TYPE_IMAGE = 1;
    public static final int TYPE_ASCII = 2;
    public static final int TYPE_LOCAL = 3;
    public static final int TYPE_EBCDIC = 4;
    public static final int MODE_STREAM = 1;
    public static final int MODE_BLOCK = 2;
    public static final int SERVER_PASSIVE = 1;
    public static final int SERVER_ACTIVE = 2;
    public static final int SERVER_DEFAULT = -1;
    public int transferMode = 1;
    public int transferType = 2;
    public int serverMode = -1;
    public int protectionBufferSize = -1;
    public boolean authorized = false;
    public FeatureList featureList = null;
    public HostPort serverAddress = null;
    public static final int DEFAULT_MAX_WAIT = 6000;
    public static final int DEFAULT_WAIT_DELAY = 200;
    public int maxWait = 6000;
    public int waitDelay = 200;

    public void matches(Session other) throws ClientException {
        this.compareTransferParams(other);
        this.compareServerMode(other);
    }

    protected void compareTransferParams(Session other) throws ClientException {
        if (!this.authorized || !other.authorized) {
            throw new ClientException(1, "Need to perform authorization first");
        }
        if (this.protectionBufferSize != other.protectionBufferSize) {
            throw new ClientException(2);
        }
        if (this.transferType != other.transferType) {
            throw new ClientException(4);
        }
        if (this.transferMode != other.transferMode) {
            throw new ClientException(3);
        }
    }

    protected void compareServerMode(Session other) throws ClientException {
        if (this.serverMode != -1 || other.serverMode != -1) {
            if (this.serverMode == -1 || other.serverMode == -1) {
                throw new ClientException(5, "Only one server has been defined as active or passive");
            }
            if (other.serverMode == this.serverMode) {
                String modeStr = this.serverMode == 1 ? "passive" : "active";
                throw new ClientException(5, "Both servers are " + modeStr);
            }
        }
    }
}

