/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.LongCollection;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.map.DoubleKeyLongMap;
import bak.pcj.map.DoubleKeyLongMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleKeyLongMap
implements DoubleKeyLongMap {
    protected AbstractDoubleKeyLongMap() {
    }

    public void clear() {
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public long remove(double key) {
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            long value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultLong();
    }

    public void putAll(DoubleKeyLongMap map) {
        DoubleKeyLongMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(double key) {
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public long get(double key) {
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultLong();
    }

    public boolean containsValue(long value) {
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleKeyLongMap)) {
            return false;
        }
        DoubleKeyLongMap map = (DoubleKeyLongMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            double k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultDoubleHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultLongHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public long tget(double key) {
        long value = this.get(key);
        if (value == MapDefaults.defaultLong() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        DoubleKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract LongCollection values();

    public abstract long put(double var1, long var3);

    public abstract long lget();

    public abstract DoubleSet keySet();

    public abstract DoubleKeyLongMapIterator entries();
}

