/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.DoubleCollectionToCollectionAdapter;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyDoubleMap;
import bak.pcj.map.ObjectKeyDoubleMapIterator;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjectKeyDoubleMapToMapAdapter
implements Map {
    protected ObjectKeyDoubleMap map;

    public ObjectKeyDoubleMapToMapAdapter(ObjectKeyDoubleMap map) throws NullPointerException {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.map.containsValue((Double)value);
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.map.size()) {
            return false;
        }
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getValue() == null) {
                return false;
            }
            if (this.get(e.getKey()).equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        double v = this.map.get(key);
        if (v == MapDefaults.defaultDouble() && !this.map.containsKey(key)) {
            return null;
        }
        return new Double(v);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object value) throws NullPointerException, ClassCastException {
        Object result = this.get(key);
        this.map.put(key, (Double)value);
        return result;
    }

    public void putAll(Map map) throws NullPointerException, ClassCastException {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        Object result = this.get(key);
        this.map.remove(key);
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return new DoubleCollectionToCollectionAdapter(this.map.values());
    }

    class Entry
    implements Map.Entry {
        Object key;
        Double value;

        Entry(Object key, double value) {
            this.key = key;
            this.value = new Double(value);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return ObjectKeyDoubleMapToMapAdapter.this.put(this.key, value);
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ DefaultDoubleHashFunction.INSTANCE.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && this.value.equals(e.getValue());
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                ObjectKeyDoubleMapIterator i;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    this.i = EntrySet.access$000((EntrySet)this.this$1).map.entries();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    this.i.next();
                    return EntrySet.access$000(this.this$1).new Entry(this.i.getKey(), this.i.getValue());
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }

        public boolean add(Object obj) {
            Map.Entry e = (Map.Entry)obj;
            if (this.contains(e)) {
                return false;
            }
            ObjectKeyDoubleMapToMapAdapter.this.put(e.getKey(), e.getValue());
            return true;
        }

        public int size() {
            return ObjectKeyDoubleMapToMapAdapter.this.map.size();
        }

        static /* synthetic */ ObjectKeyDoubleMapToMapAdapter access$000(EntrySet x0) {
            return x0.ObjectKeyDoubleMapToMapAdapter.this;
        }
    }
}

