/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.rep.txn.MasterTxn;

public class InsufficientAcksException
extends OperationFailureException {
    private final MasterTxn txn;
    private final int acksPending;
    private final int ackTimeOutMs;
    private String wrapMessage = null;
    private final String feederState;

    public InsufficientAcksException(MasterTxn txn, int acksPending, int ackTimeoutMs, String feederState) {
        super(txn, true, "", null);
        assert (acksPending <= txn.getRequiredAckCount());
        this.txn = txn;
        this.acksPending = acksPending;
        this.ackTimeOutMs = ackTimeoutMs;
        this.feederState = feederState;
    }

    public String getMessage() {
        return this.wrapMessage != null ? this.wrapMessage : "Transaction: " + this.txn.getId() + "  VLSN: " + this.txn.getCommitVLSN() + ", initiated at: " + String.format("%1tT. ", this.txn.getStartMs()) + " Insufficient acks for policy:" + (Object)((Object)this.txn.getCommitDurability().getReplicaAck()) + ". " + "Need replica acks: " + this.txn.getRequiredAckCount() + ". " + "Missing replica acks: " + this.acksPending + ". " + "Timeout: " + this.ackTimeOutMs + "ms. " + "FeederState=" + this.feederState;
    }

    private InsufficientAcksException(String message, InsufficientAcksException cause) {
        super(message, cause);
        this.wrapMessage = message;
        this.txn = cause.txn;
        this.acksPending = cause.acksPending;
        this.ackTimeOutMs = cause.ackTimeOutMs;
        this.feederState = cause.feederState;
    }

    public OperationFailureException wrapSelf(String msg) {
        return new InsufficientAcksException(msg, this);
    }

    public int acksPending() {
        return this.acksPending;
    }

    public int acksRequired() {
        return this.txn.getRequiredAckCount();
    }

    public int ackTimeout() {
        return this.ackTimeOutMs;
    }
}

