/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openrdf.sesame.config.RepositoryInfo;
import org.openrdf.sesame.repository.RepositoryList;
import org.openrdf.util.xml.XmlWriter;

public class RepositoryListWriter {
    public void write(RepositoryList repList, OutputStream outputStream) throws IOException {
        List readableReps = repList.getReadableRepositories();
        List writeableReps = repList.getWritableRepositories();
        HashSet allRepositories = new HashSet(readableReps);
        allRepositories.addAll(writeableReps);
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.setPrettyPrint(true);
        xmlWriter.startDocument();
        xmlWriter.startTag("repositorylist");
        Iterator iter = allRepositories.iterator();
        while (iter.hasNext()) {
            RepositoryInfo repInfo = (RepositoryInfo)iter.next();
            xmlWriter.setAttribute("id", repInfo.getRepositoryId());
            xmlWriter.setAttribute("readable", readableReps.contains(repInfo));
            xmlWriter.setAttribute("writeable", writeableReps.contains(repInfo));
            xmlWriter.startTag("repository");
            if (repInfo.getTitle() != null) {
                xmlWriter.textElement("title", repInfo.getTitle());
            }
            xmlWriter.endTag("repository");
        }
        xmlWriter.endTag("repositorylist");
        xmlWriter.endDocument();
    }
}

