/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.FeatureNotEnabledException;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.inspireatom.InspireAtomService;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.search.EsFilterBuilder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/atom"})
@Tag(name="atom", description="ATOM")
@RestController
public class AtomSearch {
    @Autowired
    InspireAtomService service;
    @Autowired
    SettingManager sm;
    @Autowired
    DataManager dm;
    @Autowired
    EsSearchManager searchMan;
    @Autowired
    InspireAtomFeedRepository inspireAtomFeedRepository;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    IsoLanguagesMapper isoLanguagesMapper;

    @Operation(summary="Get ATOM feeds", description="")
    @GetMapping(value={"/feeds"}, produces={"application/xml", "text/html"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Get a list of feeds."), @ApiResponse(responseCode="204", description="Not authenticated.")})
    @ResponseStatus(value=HttpStatus.OK)
    public Object feeds(@Parameter(description="fileIdentifier", required=false) @RequestParam(defaultValue="") String fileIdentifier, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String acceptHeader = StringUtils.isBlank((CharSequence)request.getHeader("Accept")) ? "application/xml" : request.getHeader("Accept");
        List<String> accept = Arrays.asList(acceptHeader.split(","));
        if (accept.contains("text/html")) {
            return this.feedsAsHtml(fileIdentifier, request);
        }
        return this.feedsAsXml(fileIdentifier, request);
    }

    private Element feedsAsXml(String fileIdentifier, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext((HttpServletRequest)request);
        boolean inspireEnable = this.sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"Inspire is disabled");
            throw new FeatureNotEnabledException("Inspire is disabled");
        }
        String datasetIdentifiersFilter = "";
        if (StringUtils.isNotEmpty((CharSequence)fileIdentifier)) {
            String id = this.dm.getMetadataId(fileIdentifier);
            if (id == null) {
                throw new MetadataNotFoundEx("Metadata not found.");
            }
            Element md = this.dm.getMetadata(id);
            String schema = this.dm.getMetadataSchema(id);
            Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
            List<String> datasetIdentifiers = InspireAtomUtil.extractRelatedDatasetsIdentifiers(schema, md, this.dm);
            String datasets = datasetIdentifiers.stream().map(StringEscapeUtils::escapeJson).collect(Collectors.joining("\",\"", "\"", "\""));
            datasetIdentifiersFilter = String.format(", {\"terms\": {\n      \"resourceIdentifier.code\": [%s]\n    }}", datasets);
        }
        String privilegesFilter = EsFilterBuilder.buildPermissionsFilter((ServiceContext)context);
        String jsonQuery = "{    \"bool\": {      \"must\": [        {          \"exists\": {            \"field\": \"atomfeed\"          }        }      ],      \"filter\": [{          \"query_string\": {            \"query\": \"%s\"        }      }%s]    }}";
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode esJsonQuery = objectMapper.readTree(String.format(jsonQuery, privilegesFilter, datasetIdentifiersFilter));
        SearchResponse result = this.searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_CORE, 0, 1000);
        Element feeds = new Element("feeds");
        for (SearchHit hit : result.getHits().getHits()) {
            String id = hit.getSourceAsMap().get("id").toString();
            InspireAtomFeed feed = this.service.findByMetadataId(Integer.parseInt(id));
            if (feed != null) {
                Element feedEl = Xml.loadString((String)feed.getAtom(), (boolean)false);
                feeds.addContent((Content)feedEl.clone());
                continue;
            }
            Log.debug((String)"geonetwork.atom", (Object)String.format("No feed available for %s", hit.getId()));
        }
        return feeds;
    }

    private String feedsAsHtml(String fileIdentifier, HttpServletRequest request) throws Exception {
        Element feeds = this.feedsAsXml(fileIdentifier, request);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        String language = IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language());
        language = XslUtil.twoCharLangCode((String)language, (String)"eng").toLowerCase();
        return new XsltResponseWriter(null, "atom-feeds").withXml(feeds).withJson(String.format("catalog/locales/%s-v4.json", language)).withXsl("xslt/services/inspire-atom/search-results.xsl").asHtml();
    }
}

