/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.translationproviders;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import org.fao.geonet.translations.ITranslationService;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/translationproviders"})
@Tag(name="translationproviders", description="Translation providers")
@RestController(value="translationproviders")
public class TranslationProvidersApi {
    private List<ITranslationService> translationServiceList;

    public TranslationProvidersApi(List<ITranslationService> translationServiceList) {
        this.translationServiceList = translationServiceList;
    }

    @Operation(summary="Retrieve the list of translation provider.", description="")
    @GetMapping(produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of translation provider names.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    public List<String> getTranslationProviderNames() {
        return this.translationServiceList.stream().map(t -> t.name()).collect(Collectors.toList());
    }
}

