/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.GenericParameterService;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyInfo;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.RequestPart;

public class RequestBodyService {
    private final GenericParameterService parameterBuilder;
    private final PropertyResolverUtils propertyResolverUtils;

    public RequestBodyService(GenericParameterService parameterBuilder, PropertyResolverUtils propertyResolverUtils) {
        this.parameterBuilder = parameterBuilder;
        this.propertyResolverUtils = propertyResolverUtils;
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, RequestBody requestBodyOp, MethodAttributes methodAttributes, Components components, JsonView jsonViewAnnotation, Locale locale) {
        String[] classConsumes = methodAttributes.getClassConsumes();
        String[] methodConsumes = methodAttributes.getMethodConsumes();
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(this.propertyResolverUtils.resolve(requestBody.description(), locale));
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((boolean)this.parameterBuilder.isOpenapi31(), (Extension[])requestBody.extensions());
            extensions.forEach((arg_0, arg_1) -> ((RequestBody)requestBodyObject).addExtension(arg_0, arg_1));
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        this.buildResquestBodyContent(requestBody, requestBodyOp, methodAttributes, components, jsonViewAnnotation, classConsumes, methodConsumes, requestBodyObject);
        return Optional.of(requestBodyObject);
    }

    private void buildResquestBodyContent(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, RequestBody requestBodyOp, MethodAttributes methodAttributes, Components components, JsonView jsonViewAnnotation, String[] classConsumes, String[] methodConsumes, RequestBody requestBodyObject) {
        Optional<Content> optionalContent = SpringDocAnnotationsUtils.getContent(requestBody.content(), this.getConsumes(classConsumes), this.getConsumes(methodConsumes), null, components, jsonViewAnnotation, this.parameterBuilder.isOpenapi31());
        if (requestBodyOp == null) {
            if (optionalContent.isPresent()) {
                Content content = optionalContent.get();
                requestBodyObject.setContent(content);
                if (this.containsResponseBodySchema(content)) {
                    methodAttributes.setWithResponseBodySchemaDoc(true);
                }
            }
        } else {
            Content existingContent = requestBodyOp.getContent();
            if (optionalContent.isPresent() && existingContent != null) {
                Content newContent = optionalContent.get();
                if (methodAttributes.isMethodOverloaded()) {
                    Arrays.stream(methodAttributes.getMethodProduces()).filter(mediaTypeStr -> newContent.get(mediaTypeStr) != null).forEach(mediaTypeStr -> {
                        if (((MediaType)newContent.get(mediaTypeStr)).getSchema() != null) {
                            SpringDocAnnotationsUtils.mergeSchema(existingContent, ((MediaType)newContent.get(mediaTypeStr)).getSchema(), mediaTypeStr);
                        }
                    });
                    requestBodyObject.content(existingContent);
                } else {
                    requestBodyObject.content(newContent);
                }
            }
        }
    }

    private boolean containsResponseBodySchema(Content content) {
        return content.entrySet().stream().anyMatch(stringMediaTypeEntry -> ((MediaType)stringMediaTypeEntry.getValue()).getSchema() != null);
    }

    private String[] getConsumes(String[] classConsumes) {
        return classConsumes == null ? new String[]{} : classConsumes;
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, MethodAttributes methodAttributes, Components components) {
        return this.buildRequestBodyFromDoc(requestBody, null, methodAttributes, components, null, null);
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, MethodAttributes methodAttributes, Components components, JsonView jsonViewAnnotation, Locale locale) {
        return this.buildRequestBodyFromDoc(requestBody, null, methodAttributes, components, jsonViewAnnotation, locale);
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, RequestBody requestBodyOp, MethodAttributes methodAttributes, Components components, Locale locale) {
        return this.buildRequestBodyFromDoc(requestBody, requestBodyOp, methodAttributes, components, null, locale);
    }

    public void calculateRequestBodyInfo(Components components, MethodAttributes methodAttributes, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo) {
        RequestBody requestBody = requestBodyInfo.getRequestBody();
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        if (requestBody == null) {
            io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyDoc = (io.swagger.v3.oas.annotations.parameters.RequestBody)methodParameter.getParameterAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class);
            requestBody = this.buildRequestBodyFromDoc(requestBodyDoc, methodAttributes, components).orElse(null);
        }
        RequestPart requestPart = (RequestPart)methodParameter.getParameterAnnotation(RequestPart.class);
        String paramName = null;
        if (requestPart != null) {
            paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestPart.value(), (CharSequence)requestPart.name());
            parameterInfo.setRequired(requestPart.required());
            parameterInfo.setRequestPart(true);
        }
        paramName = (String)StringUtils.defaultIfEmpty(paramName, (CharSequence)parameterInfo.getpName());
        parameterInfo.setpName(paramName);
        requestBody = this.buildRequestBody(requestBody, components, methodAttributes, parameterInfo, requestBodyInfo);
        requestBodyInfo.setRequestBody(requestBody);
    }

    private RequestBody buildRequestBody(RequestBody requestBody, Components components, MethodAttributes methodAttributes, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo) {
        String paramJavadocDescription;
        Schema schema;
        if (requestBody == null) {
            requestBody = new RequestBody();
            requestBodyInfo.setRequestBody(requestBody);
        }
        if (requestBody.getContent() == null) {
            schema = this.parameterBuilder.calculateSchema(components, parameterInfo, requestBodyInfo, methodAttributes.getJsonViewAnnotationForRequestBody());
            this.buildContent(requestBody, methodAttributes, schema);
        } else if (!methodAttributes.isWithResponseBodySchemaDoc()) {
            schema = this.parameterBuilder.calculateSchema(components, parameterInfo, requestBodyInfo, methodAttributes.getJsonViewAnnotationForRequestBody());
            this.mergeContent(requestBody, methodAttributes, schema);
        }
        if (StringUtils.isBlank((CharSequence)requestBody.getDescription()) && this.parameterBuilder.getJavadocProvider() != null && this.parameterBuilder.isRequestBodyPresent(parameterInfo) && !StringUtils.isBlank((CharSequence)(paramJavadocDescription = this.parameterBuilder.getParamJavadoc(this.parameterBuilder.getJavadocProvider(), parameterInfo.getMethodParameter())))) {
            requestBody.setDescription(paramJavadocDescription);
        }
        return requestBody;
    }

    private void mergeContent(RequestBody requestBody, MethodAttributes methodAttributes, Schema<?> schema) {
        Content content = requestBody.getContent();
        this.buildContent(requestBody, methodAttributes, schema, content);
    }

    private void buildContent(RequestBody requestBody, MethodAttributes methodAttributes, Schema<?> schema) {
        Content content = new Content();
        this.buildContent(requestBody, methodAttributes, schema, content);
    }

    private void buildContent(RequestBody requestBody, MethodAttributes methodAttributes, Schema<?> schema, Content content) {
        for (String value : methodAttributes.getMethodConsumes()) {
            MediaType mediaTypeObject = new MediaType();
            mediaTypeObject.setSchema(schema);
            MediaType mediaType = (MediaType)content.get((Object)value);
            if (mediaType != null) {
                if (mediaType.getExample() != null) {
                    mediaTypeObject.setExample(mediaType.getExample());
                }
                if (mediaType.getExamples() != null) {
                    mediaTypeObject.setExamples(mediaType.getExamples());
                }
                if (mediaType.getEncoding() != null) {
                    mediaTypeObject.setEncoding(mediaType.getEncoding());
                }
            }
            content.addMediaType(value, mediaTypeObject);
        }
        requestBody.setContent(content);
    }
}

