/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.setting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.HarvesterSetting;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.HarvesterSettingRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class HarvesterSettingsManager {
    @PersistenceContext
    private EntityManager _entityManager;

    public Element getList(List<String> names) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        List s = settingsRepo.findAllByNames(names);
        Element el = null;
        if (s != null) {
            HarvesterSetting r = null;
            HashMap<Integer, List<HarvesterSetting>> mapSettings = new HashMap<Integer, List<HarvesterSetting>>();
            List<Object> settings = null;
            for (HarvesterSetting h : s) {
                settings = new ArrayList<HarvesterSetting>();
                if (h.getParent() == null) {
                    r = h;
                } else {
                    if (mapSettings.containsKey(h.getParent().getId())) {
                        settings = (List)mapSettings.get(h.getParent().getId());
                    }
                    settings.add(h);
                }
                if (!CollectionUtils.isNotEmpty(settings)) continue;
                mapSettings.put(h.getParent().getId(), settings);
            }
            el = this.buildFromMap(r, mapSettings);
        }
        return el;
    }

    public Element get(String path, int level) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        HarvesterSetting s = settingsRepo.findOneByPath(path);
        return s == null ? null : this.build(s, level);
    }

    public String getValue(String path) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        HarvesterSetting s = settingsRepo.findOneByPath(path);
        return s == null ? null : s.getValue();
    }

    public boolean setName(String path, String name) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        HarvesterSetting updatedSetting = settingsRepo.findOneByPath(path);
        if (updatedSetting == null) {
            return false;
        }
        updatedSetting.setName(name);
        settingsRepo.save((Object)updatedSetting);
        return true;
    }

    public boolean setValue(String path, Object value) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(path, value);
        return this.setValues(values);
    }

    public boolean setValues(Map<String, Object> values) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        boolean success = true;
        ArrayList<HarvesterSetting> toSave = new ArrayList<HarvesterSetting>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String path = entry.getKey();
            String value = this.makeString(entry.getValue());
            HarvesterSetting s = settingsRepo.findOneByPath(path);
            if (s == null) {
                success = false;
                Log.warning((String)"geonetwork.settings", (Object)("Unable to find Settings row for: " + path + ". Check settings table."));
                continue;
            }
            s.setValue(value);
            if (Log.isDebugEnabled((String)"geonetwork.settings")) {
                Log.debug((String)"geonetwork.settings", (Object)("Set path: " + path + ", value: " + value));
            }
            toSave.add(s);
        }
        settingsRepo.saveAll(toSave);
        return success;
    }

    public String add(String path, Object name, Object value) {
        return this.add(path, name, value, false);
    }

    public String add(String path, Object name, Object value, boolean encrypted) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String sName = this.makeString(name);
        String sValue = this.makeString(value);
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        HarvesterSetting parent = settingsRepo.findOneByPath(path);
        if (parent == null) {
            return null;
        }
        HarvesterSetting child = new HarvesterSetting().setParent(parent).setName(sName).setValue(sValue).setEncrypted(encrypted);
        settingsRepo.save((Object)child);
        return Integer.toString(child.getId());
    }

    public boolean remove(String path) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        HarvesterSetting s = settingsRepo.findOneByPath(path);
        if (s == null) {
            return false;
        }
        this.removeChildren(s.getId());
        settingsRepo.delete((Object)s);
        settingsRepo.flush();
        return true;
    }

    public boolean removeChildren(String path) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        HarvesterSetting parent = settingsRepo.findOneByPath(path);
        if (parent == null) {
            return false;
        }
        return this.removeChildren(parent.getId());
    }

    private boolean removeChildren(Integer parent) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        List children = settingsRepo.findAllChildren(parent.intValue());
        for (HarvesterSetting child : children) {
            this.removeChildren(child.getId());
            this.remove(child);
        }
        return true;
    }

    public boolean getValueAsBool(String path, boolean defValue) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        HarvesterSetting setting = settingsRepo.findOneByPath(path);
        if (setting == null) {
            return defValue;
        }
        return setting.getValueAsBool();
    }

    public boolean getValueAsBool(String path) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        HarvesterSetting value = settingsRepo.findOneByPath(path);
        if (value == null) {
            return false;
        }
        return value.getValueAsBool();
    }

    public String getSiteId() {
        SettingManager _settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        return _settingManager.getSiteId();
    }

    public String getSiteName() {
        SettingManager _settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        return _settingManager.getSiteName();
    }

    private String makeString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private Element buildFromMap(HarvesterSetting s, Map<Integer, List<HarvesterSetting>> mapSettings) {
        List<HarvesterSetting> childrenSettings;
        if (s == null) {
            return null;
        }
        Element el = new Element(s.getName());
        el.setAttribute("id", Integer.toString(s.getId()));
        if (s.getValue() != null) {
            Element value = new Element("value");
            value.setText(s.getValue());
            el.addContent((Content)value);
        }
        if ((childrenSettings = mapSettings.get(s.getId())) != null) {
            Element children = new Element("children");
            for (HarvesterSetting childSetting : childrenSettings) {
                children.addContent((Content)this.buildFromMap(childSetting, mapSettings));
            }
            if (children.getContentSize() != 0) {
                el.addContent((Content)children);
            }
        }
        return el;
    }

    private Element build(HarvesterSetting s, int level) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        Element el = new Element(s.getName());
        el.setAttribute("id", Integer.toString(s.getId()));
        if (s.getValue() != null) {
            Element value = new Element("value");
            value.setText(s.getValue());
            el.addContent((Content)value);
        }
        if (level != 0) {
            Element children = new Element("children");
            List childrenHarvestSettings = settingsRepo.findAllChildren(s.getId());
            for (HarvesterSetting child : childrenHarvestSettings) {
                children.addContent((Content)this.build(child, level - 1));
            }
            if (children.getContentSize() != 0) {
                el.addContent((Content)children);
            }
        }
        return el;
    }

    private void remove(HarvesterSetting s) {
        HarvesterSettingRepository settingsRepo = (HarvesterSettingRepository)ApplicationContextHolder.get().getBean(HarvesterSettingRepository.class);
        settingsRepo.delete((Object)s);
    }

    public void refresh() {
        this._entityManager.getEntityManagerFactory().getCache().evict(HarvesterSetting.class);
    }
}

