/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.index.es.EsRestClient;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.ISearchManager;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.search.index.OverviewIndexFieldUpdater;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;

public class EsSearchManager
implements ISearchManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.index");
    public static final String ID = "id";
    public static final String SCHEMA_INDEX_XSLT_FOLDER = "index-fields";
    public static final String SCHEMA_INDEX_XSTL_FILENAME = "index.xsl";
    public static final String SCHEMA_INDEX_SUBTEMPLATE_XSTL_FILENAME = "index-subtemplate.xsl";
    public static final String FIELDNAME = "name";
    public static final String FIELDSTRING = "string";
    public static final Map<String, String> RELATED_INDEX_FIELDS;
    public static final Set<String> FIELDLIST_CORE;
    public static final Set<String> FIELDLIST_RELATED;
    public static final Map<String, String> FIELDLIST_RELATED_SCRIPTED;
    public static final Set<String> FIELDLIST_UUID;
    @Value(value="${es.index.records:gn-records}")
    private String defaultIndex = "records";
    @Value(value="${es.index.records.type:records}")
    private String indexType = "records";
    @Autowired
    public EsRestClient client;
    @Autowired
    OverviewIndexFieldUpdater overviewFieldUpdater;
    private int commitInterval = 200;
    public Map<String, String> listOfDocumentsToIndex = Collections.synchronizedMap(new HashMap());
    private Map<String, String> indexList;
    @Autowired
    private GeonetworkDataDirectory dataDirectory;
    @Autowired
    SourceRepository sourceRepository;
    private static ImmutableSet<String> booleanFields;
    private static ImmutableSet<String> arrayFields;
    private static ImmutableSet<String> booleanValues;
    static ImmutableSet<String> docsChangeIncludedFields;

    public String getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(String defaultIndex) {
        this.defaultIndex = defaultIndex;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    private Path getXSLTForIndexing(Path schemaDir, MetadataType metadataType) {
        Path xsltForIndexing = schemaDir.resolve(SCHEMA_INDEX_XSLT_FOLDER).resolve(metadataType.equals((Object)MetadataType.SUB_TEMPLATE) || metadataType.equals((Object)MetadataType.TEMPLATE_OF_SUB_TEMPLATE) ? SCHEMA_INDEX_SUBTEMPLATE_XSTL_FILENAME : SCHEMA_INDEX_XSTL_FILENAME);
        if (!Files.exists(xsltForIndexing, new LinkOption[0])) {
            throw new RuntimeException(String.format("XSLT for schema indexing does not exist. Create file '%s'.", xsltForIndexing.toString()));
        }
        return xsltForIndexing;
    }

    private void addMDFields(Element doc, Path schemaDir, Element metadata, MetadataType metadataType, IndexingMode indexingMode) {
        Path styleSheet = this.getXSLTForIndexing(schemaDir, metadataType);
        try {
            HashMap<String, Boolean> indexParams = new HashMap<String, Boolean>();
            indexParams.put("fastIndexMode", indexingMode.equals((Object)IndexingMode.core));
            Element fields = Xml.transform((Element)metadata, (Path)styleSheet, indexParams);
            for (Element field : fields.getChildren()) {
                doc.addContent((Content)((Element)field.clone()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Indexing stylesheet contains errors: {} \n  Marking the metadata as _indexingError=1 in index", (Object)e.getMessage());
            doc.addContent((Content)new Element("indexingError").setText("true"));
            doc.addContent((Content)new Element("indexingErrorMsg").setText("GNIDX-XSL||" + e.getMessage()));
            doc.addContent((Content)new Element("draft").setText("n"));
        }
    }

    private void addMoreFields(Element doc, Multimap<String, Object> fields) {
        fields.entries().forEach(e -> doc.addContent((Content)new Element((String)e.getKey()).setText(String.valueOf(e.getValue()))));
    }

    @Override
    public Element makeField(String name, String value) {
        Element field = new Element("Field");
        field.setAttribute(FIELDNAME, name);
        field.setAttribute(FIELDSTRING, value == null ? "" : value);
        return field;
    }

    @Override
    public void init(boolean dropIndexFirst, Optional<List<String>> indices) throws Exception {
        if (this.indexList != null) {
            this.indexList.keySet().forEach(e -> {
                try {
                    if (!indices.isPresent() || ((List)indices.get()).contains(e)) {
                        this.createIndex((String)e, this.indexList.get(e), dropIndexFirst);
                    }
                }
                catch (IOException ex) {
                    LOGGER.error("Error during index creation. Error is: {}", (Object)ex.getMessage());
                }
            });
        }
    }

    private void createIndex(String indexId, String indexName, boolean dropIndexFirst) throws IOException {
        block22: {
            DeleteIndexRequest request;
            if (dropIndexFirst) {
                try {
                    request = new DeleteIndexRequest(indexName);
                    AcknowledgedResponse deleteIndexResponse = this.client.getClient().indices().delete(request, RequestOptions.DEFAULT);
                    if (deleteIndexResponse.isAcknowledged()) {
                        LOGGER.debug("Index '{}' removed.", (Object)indexName);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error during index '{}' removal. Error is: {}", (Object)indexName, (Object)e.getMessage());
                }
            }
            request = new GetIndexRequest(new String[]{indexName});
            try {
                boolean exists = this.client.getClient().indices().exists((GetIndexRequest)request, RequestOptions.DEFAULT);
                if (exists && !dropIndexFirst) {
                    return;
                }
                if (exists && !dropIndexFirst) break block22;
                Path indexConfiguration = this.dataDirectory.getIndexConfigDir().resolve(indexId + ".json");
                if (Files.exists(indexConfiguration, new LinkOption[0])) {
                    String configuration;
                    try (InputStream is = Files.newInputStream(indexConfiguration, StandardOpenOption.READ);){
                        configuration = IOUtils.toString((InputStream)is);
                    }
                    CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
                    createIndexRequest.source(configuration, XContentType.JSON);
                    CreateIndexResponse createIndexResponse = this.client.getClient().indices().create(createIndexRequest, RequestOptions.DEFAULT);
                    if (createIndexResponse.isAcknowledged()) {
                        LOGGER.debug("Index '{}' created", (Object)indexName);
                        break block22;
                    }
                    String message = String.format("Index '%s' was not created. Error is: %s", indexName, createIndexResponse.toString());
                    LOGGER.error(message);
                    throw new IllegalStateException(message);
                }
                throw new FileNotFoundException(String.format("Index configuration file '%s' not found in data directory for building index with name '%s'. Create one or copy the default one.", indexConfiguration.toAbsolutePath(), indexName));
            }
            catch (ElasticsearchParseException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                throw new IOException(ex.getMessage());
            }
            catch (Exception cnce) {
                String message = String.format("Could not connect to index '%s'. Error is %s. Is the index server  up and running?", this.defaultIndex, cnce.getMessage());
                LOGGER.error(message, (Throwable)cnce);
                throw new IOException(message);
            }
        }
    }

    @Override
    public void end() {
    }

    public UpdateResponse updateFields(String id, Map<String, Object> fields) throws IOException {
        fields.put("indexingDate", new Date());
        UpdateRequest updateRequest = new UpdateRequest(this.defaultIndex, id).doc(fields);
        return this.client.getClient().update(updateRequest, RequestOptions.DEFAULT);
    }

    public BulkResponse updateFields(String id, Multimap<String, Object> fields, Set<String> fieldsToRemove) throws IOException {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fields.asMap().forEach((e, v) -> fieldMap.put((String)e, v.toArray()));
        return this.updateFields(id, fieldMap, fieldsToRemove);
    }

    public BulkResponse updateFields(String id, Map<String, Object> fieldMap, Set<String> fieldsToRemove) throws IOException {
        fieldMap.put("indexingDate", new Date());
        BulkRequest bulkrequest = new BulkRequest();
        StringBuilder script = new StringBuilder();
        fieldsToRemove.forEach(f -> script.append(String.format("ctx._source.remove('%s');", f)));
        UpdateRequest deleteFieldRequest = new UpdateRequest(this.defaultIndex, id).script(new Script(ScriptType.INLINE, "painless", script.toString(), Collections.emptyMap()));
        bulkrequest.add(deleteFieldRequest);
        UpdateRequest addFieldRequest = new UpdateRequest(this.defaultIndex, id).doc(fieldMap);
        bulkrequest.add(addFieldRequest);
        return this.client.getClient().bulk(bulkrequest, RequestOptions.DEFAULT);
    }

    public void updateFieldsAsynch(String id, Map<String, Object> fields) {
        fields.put("indexingDate", new Date());
        UpdateRequest request = new UpdateRequest(this.defaultIndex, id).doc(fields);
        ActionListener<UpdateResponse> listener = new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
            }

            public void onFailure(Exception e) {
            }
        };
        this.client.getClient().updateAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
    }

    public UpdateResponse updateField(String id, String field, Object value) throws Exception {
        HashMap<String, Object> updates = new HashMap<String, Object>(2);
        updates.put(this.getPropertyName(field), value);
        return this.updateFields(id, updates);
    }

    public void updateFieldAsynch(String id, String field, Object value) {
        HashMap<String, Object> updates = new HashMap<String, Object>(2);
        updates.put(this.getPropertyName(field), value);
        this.updateFieldsAsynch(id, updates);
    }

    @Override
    public void index(Path schemaDir, Element metadata, String id, Multimap<String, Object> dbFields, MetadataType metadataType, boolean forceRefreshReaders, IndexingMode indexingMode) throws Exception {
        JsonNode errors;
        Element docs = new Element("doc");
        if (schemaDir != null) {
            this.addMDFields(docs, schemaDir, metadata, metadataType, indexingMode);
        }
        this.addMoreFields(docs, dbFields);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode doc = this.documentToJson(docs);
        String catalog = doc.get("source").asText();
        doc.remove("source");
        if (StringUtils.isNotEmpty((String)catalog)) {
            doc.put("sourceCatalogue", catalog);
        }
        if ((errors = doc.get("indexingErrorMsg")) != null) {
            doc.put("indexingError", "true");
        }
        String jsonDocument = mapper.writeValueAsString((Object)doc);
        if (forceRefreshReaders) {
            HashMap<String, String> document = new HashMap<String, String>();
            document.put(id, jsonDocument);
            BulkResponse bulkItemResponses = this.client.bulkRequest(this.defaultIndex, document);
            this.checkIndexResponse(bulkItemResponses, document);
            this.overviewFieldUpdater.process(id);
        } else {
            this.listOfDocumentsToIndex.put(id, jsonDocument);
            if (this.listOfDocumentsToIndex.size() == this.commitInterval) {
                this.sendDocumentsToIndex();
            }
        }
    }

    private void sendDocumentsToIndex() {
        HashMap<String, String> documents = new HashMap<String, String>(this.listOfDocumentsToIndex);
        this.listOfDocumentsToIndex.clear();
        if (documents.size() > 0) {
            try {
                BulkResponse bulkItemResponses = this.client.bulkRequest(this.defaultIndex, documents);
                this.checkIndexResponse(bulkItemResponses, documents);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while indexing {} documents in current indexing list. Error is {}.", (Object)this.listOfDocumentsToIndex.size(), (Object)e.getMessage());
            }
            finally {
                documents.keySet().forEach(uuid -> this.overviewFieldUpdater.process((String)uuid));
            }
        }
    }

    private void checkIndexResponse(BulkResponse bulkItemResponses, Map<String, String> documents) throws IOException {
        if (bulkItemResponses.hasFailures()) {
            BulkResponse response;
            HashMap listErrorOfDocumentsToIndex = new HashMap(bulkItemResponses.getItems().length);
            ArrayList errorDocumentIds = new ArrayList();
            Arrays.stream(bulkItemResponses.getItems()).forEach(e -> {
                if (e.status() != RestStatus.OK && e.status() != RestStatus.CREATED) {
                    errorDocumentIds.add(e.getId());
                    ObjectMapper mapper = new ObjectMapper();
                    ObjectNode docWithErrorInfo = mapper.createObjectNode();
                    String resourceTitle = String.format("Document #%s", e.getId());
                    String id = "";
                    String uuid = "";
                    String isTemplate = "";
                    String failureDoc = (String)documents.get(e.getId());
                    try {
                        JsonNode node = mapper.readTree(failureDoc);
                        resourceTitle = node.get("resourceTitleObject").get("default").asText();
                        id = node.get(ID).asText();
                        uuid = node.get("uuid").asText();
                        isTemplate = node.get("isTemplate").asText();
                    }
                    catch (Exception node) {
                        // empty catch block
                    }
                    docWithErrorInfo.put(ID, id);
                    docWithErrorInfo.put("uuid", uuid);
                    docWithErrorInfo.put("resourceTitle", resourceTitle);
                    docWithErrorInfo.put("isTemplate", isTemplate);
                    docWithErrorInfo.put("draft", "n");
                    docWithErrorInfo.put("indexingError", true);
                    ArrayNode errors = docWithErrorInfo.putArray("indexingErrorMsg");
                    errors.add(e.getFailureMessage());
                    LOGGER.error("Document with error #{}: {}.", (Object)e.getId(), (Object)e.getFailureMessage());
                    LOGGER.error(failureDoc);
                    try {
                        listErrorOfDocumentsToIndex.put(e.getId(), mapper.writeValueAsString((Object)docWithErrorInfo));
                    }
                    catch (JsonProcessingException e1) {
                        LOGGER.error("Generated document for the index is not properly formatted. Check document #{}: {}.", (Object)e.getId(), (Object)e1.getMessage());
                    }
                }
            });
            if (listErrorOfDocumentsToIndex.size() > 0 && (response = this.client.bulkRequest(this.defaultIndex, listErrorOfDocumentsToIndex)).status().getStatus() != 201) {
                LOGGER.error("Failed to save error documents {}.", (Object)Arrays.toString(errorDocumentIds.toArray()));
            }
        }
    }

    public ObjectNode documentToJson(Element xml) {
        ObjectNode doc = new ObjectMapper().createObjectNode();
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<String> elementNames = new ArrayList<String>();
        List fields = xml.getChildren();
        for (Element currentField : fields) {
            boolean isArray;
            String name = currentField.getName();
            boolean isObject = "object".equals(currentField.getAttributeValue("type"));
            if (elementNames.contains(name)) continue;
            elementNames.add(name);
            String propertyName = this.getPropertyName(name);
            List nodeElements = xml.getChildren(name);
            boolean bl = isArray = nodeElements.size() > 1 || arrayFields.contains((Object)propertyName) || propertyName.endsWith("DateForResource") || propertyName.startsWith("cl_");
            if (isArray) {
                ArrayNode arrayNode = doc.putArray(propertyName);
                for (Element node : nodeElements) {
                    if (isObject) {
                        try {
                            arrayNode.add(mapper.readTree(node.getText()));
                        }
                        catch (IOException e) {
                            LOGGER.error("Parsing invalid JSON node {} for property {}. Error is: {}", new Object[]{node.getTextNormalize(), propertyName, e.getMessage()});
                        }
                        continue;
                    }
                    arrayNode.add(booleanFields.contains((Object)propertyName) ? this.parseBoolean(node.getTextNormalize()) : node.getText());
                }
                continue;
            }
            if (name.equals("geom")) {
                try {
                    doc.set("geom", mapper.readTree(((Element)nodeElements.get(0)).getTextNormalize()));
                }
                catch (IOException e) {
                    LOGGER.error("Parsing invalid geometry for JSON node {}. Error is: {}", (Object)((Element)nodeElements.get(0)).getTextNormalize(), (Object)e.getMessage());
                }
                continue;
            }
            if (isObject) {
                try {
                    doc.set(propertyName, mapper.readTree(((Element)nodeElements.get(0)).getTextNormalize()));
                }
                catch (IOException e) {
                    LOGGER.error("Parsing invalid JSON node {} for property {}. Error is: {}", new Object[]{((Element)nodeElements.get(0)).getTextNormalize(), propertyName, e.getMessage()});
                }
                continue;
            }
            doc.put(propertyName, booleanFields.contains((Object)propertyName) ? this.parseBoolean(((Element)nodeElements.get(0)).getTextNormalize()) : ((Element)nodeElements.get(0)).getText());
        }
        return doc;
    }

    private String getPropertyName(String name) {
        return name.startsWith("_") ? name.substring(1) : name;
    }

    private String parseBoolean(String value) {
        return String.valueOf(booleanValues.contains((Object)value));
    }

    @Override
    public void forceIndexChanges() {
        this.sendDocumentsToIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rebuildIndex(ServiceContext context, boolean xlinks, boolean reset, String bucket) throws Exception {
        DataManager dataMan = context.getBean(DataManager.class);
        IMetadataUtils metadataRepository = context.getBean(IMetadataUtils.class);
        if (reset) {
            this.clearIndex();
        }
        if (StringUtils.isNotBlank((String)bucket)) {
            ArrayList<String> listOfIdsToIndex = new ArrayList<String>();
            UserSession session = context.getUserSession();
            SelectionManager sm = SelectionManager.getManager(session);
            Set<String> set = sm.getSelection(bucket);
            synchronized (set) {
                for (String uuid : sm.getSelection(bucket)) {
                    for (AbstractMetadata abstractMetadata : metadataRepository.findAllByUuid(uuid)) {
                        String indexKey = uuid;
                        if (abstractMetadata instanceof MetadataDraft) {
                            indexKey = indexKey + "-draft";
                        }
                        listOfIdsToIndex.add(indexKey);
                    }
                    if (metadataRepository.existsMetadataUuid(uuid)) continue;
                    LOGGER.warn("Selection contains uuid '{}' not found in database", (Object)uuid);
                }
            }
            for (String id : listOfIdsToIndex) {
                dataMan.indexMetadata(id + "", false);
            }
        } else {
            Specification metadataSpec = Specification.where((Specification)MetadataSpecs.isType((MetadataType)MetadataType.METADATA)).or(MetadataSpecs.isType((MetadataType)MetadataType.TEMPLATE));
            List<Integer> metadataIds = metadataRepository.findAllIdsBy((Specification<? extends AbstractMetadata>)Specification.where((Specification)metadataSpec));
            for (Integer id : metadataIds) {
                dataMan.indexMetadata(id + "", false);
            }
        }
        this.sendDocumentsToIndex();
        return true;
    }

    public Map<String, Object> getDocument(String uuid) throws Exception {
        return this.client.getDocument(this.defaultIndex, uuid);
    }

    public SearchResponse query(String luceneQuery, String filterQuery, int startPosition, int maxRecords) throws Exception {
        return this.client.query(this.defaultIndex, luceneQuery, filterQuery, new HashSet(), new HashMap(), startPosition, maxRecords);
    }

    public SearchResponse query(String luceneQuery, String filterQuery, int startPosition, int maxRecords, List<SortBuilder<FieldSortBuilder>> sort) throws Exception {
        return this.client.query(this.defaultIndex, luceneQuery, filterQuery, new HashSet(), new HashMap(), startPosition, maxRecords, sort);
    }

    public SearchResponse query(String luceneQuery, String filterQuery, Set<String> includedFields, int from, int size) throws Exception {
        return this.client.query(this.defaultIndex, luceneQuery, filterQuery, includedFields, from, size);
    }

    public SearchResponse query(String luceneQuery, String filterQuery, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size) throws Exception {
        return this.client.query(this.defaultIndex, luceneQuery, filterQuery, includedFields, scriptedFields, from, size);
    }

    public SearchResponse query(JsonNode jsonRequest, Set<String> includedFields, int from, int size, List<SortBuilder<FieldSortBuilder>> sort) throws Exception {
        return this.client.query(this.defaultIndex, jsonRequest, null, includedFields, new HashMap(), from, size, sort);
    }

    public SearchResponse query(JsonNode jsonRequest, Set<String> includedFields, int from, int size) throws Exception {
        return this.client.query(this.defaultIndex, jsonRequest, null, includedFields, from, size);
    }

    public Map<String, String> getFieldsValues(String id, Set<String> fields, String language) throws Exception {
        return this.client.getFieldsValues(this.defaultIndex, id, fields, language);
    }

    public void clearIndex() throws Exception {
        this.client.deleteByQuery(this.defaultIndex, "*:*");
    }

    @Override
    public Map<String, String> getDocsChangeDate() throws Exception {
        HashMap<String, String> docs = new HashMap<String, String>();
        try {
            int from = 0;
            SettingInfo si = (SettingInfo)ApplicationContextHolder.get().getBean(SettingInfo.class);
            int size = Integer.parseInt(si.getSelectionMaxRecords());
            SearchResponse response = this.client.query(this.defaultIndex, "*", null, docsChangeIncludedFields, from, size);
            response.getHits().forEach(r -> docs.put(r.getId(), (String)r.getSourceAsMap().get("changeDate")));
        }
        catch (Exception e) {
            LOGGER.error("Error while collecting all documents: {}", (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return docs;
    }

    @Override
    public ISODate getDocChangeDate(String mdId) throws Exception {
        int from = 0;
        SettingInfo si = (SettingInfo)ApplicationContextHolder.get().getBean(SettingInfo.class);
        int size = Integer.parseInt(si.getSelectionMaxRecords());
        SearchResponse response = this.client.query(this.defaultIndex, "_id:" + mdId, null, docsChangeIncludedFields, from, size);
        if (response.getHits().getTotalHits().value == 1L) {
            String date = (String)response.getHits().getAt(0).getSourceAsMap().get("changeDate");
            return date != null ? new ISODate(date) : null;
        }
        return null;
    }

    @Override
    public Set<Integer> getDocsWithXLinks() throws Exception {
        return Collections.emptySet();
    }

    @Override
    public void delete(String txt) throws Exception {
        DeleteByQueryRequest request = new DeleteByQueryRequest();
        request.indices(new String[]{this.defaultIndex});
        request.setQuery((QueryBuilder)new QueryStringQueryBuilder(txt));
        request.setRefresh(true);
        this.client.getClient().deleteByQuery(request, RequestOptions.DEFAULT);
    }

    @Override
    public void delete(List<Integer> metadataIds) throws Exception {
        metadataIds.stream().forEach(metadataId -> {
            try {
                this.delete(String.format("+id:%d", metadataId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public long getNumDocs() throws Exception {
        return this.getNumDocs("");
    }

    public long getNumDocs(String query) throws Exception {
        if (StringUtils.isBlank((String)query)) {
            query = "*:*";
        }
        int from = 0;
        SettingInfo si = (SettingInfo)ApplicationContextHolder.get().getBean(SettingInfo.class);
        int size = Integer.parseInt(si.getSelectionMaxRecords());
        SearchResponse response = this.client.query(this.defaultIndex, query, null, docsChangeIncludedFields, from, size);
        return response.getHits().getTotalHits().value;
    }

    public EsRestClient getClient() {
        return this.client;
    }

    void setClient(EsRestClient client) {
        this.client = client;
    }

    public void setIndexList(Map<String, String> indexList) {
        this.indexList = indexList;
    }

    public Map<String, String> getIndexList() {
        return this.indexList;
    }

    public static String analyzeField(String analyzer, String fieldValue) {
        return EsRestClient.analyzeField((String)((EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class)).getDefaultIndex(), (String)analyzer, (String)fieldValue);
    }

    public boolean isIndexing() {
        return this.listOfDocumentsToIndex.size() > 0;
    }

    static {
        FIELDLIST_UUID = ImmutableSet.builder().add((Object)"uuid").build();
        RELATED_INDEX_FIELDS = ImmutableMap.builder().put((Object)"children", (Object)"parentUuid").put((Object)"brothersAndSisters", (Object)"parentUuid").put((Object)"services", (Object)"recordOperateOn").put((Object)"hasfeaturecats", (Object)"hasfeaturecat").put((Object)"hassources", (Object)"hassource").put((Object)"associated", (Object)"agg_associated").put((Object)"datasets", (Object)"uuid").put((Object)"fcats", (Object)"uuid").put((Object)"sources", (Object)"uuid").put((Object)"siblings", (Object)"uuid").put((Object)"parent", (Object)"uuid").put((Object)"uuid", (Object)"uuid").build();
        FIELDLIST_CORE = ImmutableSet.builder().add((Object)ID).add((Object)"uuid").add((Object)"resourceTitle").add((Object)"resourceTitleObject").add((Object)"resourceAbstract").add((Object)"resourceAbstractObject").add((Object)"operatesOn").build();
        FIELDLIST_RELATED = ImmutableSet.builder().add((Object)ID).add((Object)"uuid").add((Object)"resourceTitle").add((Object)"resourceTitleObject").add((Object)"link").add((Object)"format").add((Object)"resourceType").add((Object)"cl_status.key").add((Object)"op*").add((Object)"groupOwner").add((Object)"resourceAbstract").add((Object)"resourceAbstractObject").add((Object)"operatesOn").build();
        FIELDLIST_RELATED_SCRIPTED = ImmutableMap.builder().put((Object)"overview", (Object)"return params['_source'].overview == null ? [] : params['_source'].overview.stream().map(f -> f.url).findFirst().orElse('');").put((Object)"overview_data", (Object)"return params['_source'].overview == null ? [] : params['_source'].overview.stream().map(f -> f.data).filter(Objects::nonNull).findFirst().orElse('');").build();
        arrayFields = ImmutableSet.builder().add((Object)"recordLink").add((Object)"geom").add((Object)"topic").add((Object)"cat").add((Object)"keyword").add((Object)"extentDescriptionObject").add((Object)"extentIdentifierObject").add((Object)"resourceAltTitleObject").add((Object)"resourceCredit").add((Object)"resourceCreditObject").add((Object)"resolutionScaleDenominator").add((Object)"resolutionDistance").add((Object)"extentDescription").add((Object)"inspireTheme").add((Object)"inspireThemeUri").add((Object)"inspireTheme_syn").add((Object)"inspireAnnex").add((Object)"indexingErrorMsg").add((Object)"status").add((Object)"status_text").add((Object)"coordinateSystem").add((Object)"identifier").add((Object)"responsibleParty").add((Object)"mdLanguage").add((Object)"otherLanguage").add((Object)"resourceLanguage").add((Object)"resourceIdentifier").add((Object)"MD_LegalConstraintsOtherConstraints").add((Object)"MD_LegalConstraintsOtherConstraintsObject").add((Object)"MD_LegalConstraintsUseLimitation").add((Object)"MD_LegalConstraintsUseLimitationObject").add((Object)"MD_SecurityConstraintsUseLimitation").add((Object)"MD_SecurityConstraintsUseLimitationObject").add((Object)"overview").add((Object)"sourceDescriptionObject").add((Object)"MD_ConstraintsUseLimitation").add((Object)"MD_ConstraintsUseLimitationObject").add((Object)"resourceType").add((Object)"type").add((Object)"resourceDate").add((Object)"link").add((Object)"linkProtocol").add((Object)"crsDetails").add((Object)"format").add((Object)"orderingInstructionsObject").add((Object)"contact").add((Object)"contactForResource").add((Object)"contactForProcessing").add((Object)"contactForDistribution").add((Object)"OrgForResource").add((Object)"specificationConformance").add((Object)"processSteps").add((Object)"measure").add((Object)"resourceProviderOrgForResource").add((Object)"resourceVerticalRange").add((Object)"resourceTemporalDateRange").add((Object)"resourceTemporalExtentDateRange").add((Object)"resourceTemporalExtentDetails").add((Object)"licenseObject").build();
        booleanFields = ImmutableSet.builder().add((Object)"hasxlinks").add((Object)"hasInspireTheme").add((Object)"hasOverview").add((Object)"_hasxlinks").add((Object)"indexingError").add((Object)"isHarvested").add((Object)"isPublishedToAll").add((Object)"isPublishedToIntranet").add((Object)"isPublishedToGuest").add((Object)"isSchemaValid").add((Object)"isAboveThreshold").add((Object)"isOpenData").build();
        booleanValues = ImmutableSet.builder().add((Object)"1").add((Object)"y").add((Object)"true").build();
        docsChangeIncludedFields = ImmutableSet.builder().add((Object)ID).add((Object)"changeDate").build();
    }
}

