/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.http.client.utils.URIBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.temporal.Instant;

public class OwsUtils {
    public String getDescribeFeatureTypeUrl(String wfsUrl, String featureType, String version) throws Exception {
        URIBuilder builder = new URIBuilder(wfsUrl);
        builder.addParameter("request", "DescribeFeatureType");
        builder.addParameter("service", "WFS");
        builder.addParameter("version", version);
        builder.addParameter("TYPENAME", featureType);
        String url = builder.build().toURL().toString();
        return url;
    }

    public static String getGetCapabilitiesUrl(String wfsUrl, String version) throws Exception {
        URIBuilder builder = new URIBuilder(wfsUrl);
        builder.addParameter("request", "GetCapabilities");
        builder.addParameter("service", "WFS");
        builder.addParameter("version", version);
        String url = builder.build().toURL().toString();
        return url;
    }

    public static String getTypeFromFeatureType(AttributeDescriptor descriptor) {
        String type;
        try {
            type = descriptor.getType().getBinding().isAssignableFrom(String.class) ? "string" : (descriptor.getType().getBinding().isAssignableFrom(Double.class) ? "double" : (descriptor.getType().getBinding().isAssignableFrom(Integer.class) ? "integer" : (descriptor.getType().getBinding().isAssignableFrom(Float.class) ? "double" : (descriptor.getType().getBinding().isAssignableFrom(Date.class) || descriptor.getType().getBinding().isAssignableFrom(Timestamp.class) || descriptor.getType().getBinding().isAssignableFrom(java.sql.Date.class) || descriptor.getType().getBinding().isAssignableFrom(Instant.class) ? "date" : (descriptor.getType().getBinding().isAssignableFrom(Long.class) ? "integer" : (descriptor.getType().getBinding().isAssignableFrom(Short.class) ? "integer" : (descriptor.getType().getBinding().getSuperclass() != null && (descriptor.getType().getBinding().getSuperclass().isAssignableFrom(Geometry.class) || descriptor.getType().getBinding().getSuperclass().isAssignableFrom(GeometryCollection.class)) || descriptor.getType().getBinding().isAssignableFrom(Geometry.class) || descriptor.getType().getBinding().isAssignableFrom(GeometryCollection.class) ? "geometry" : "string")))))));
        }
        catch (Exception e) {
            return "string";
        }
        return type;
    }
}

