/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e=e||self).Cesium={})}(this,function(exports){"use strict";function defined(e){return null!=e}function DeveloperError(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}defined(Object.create)&&(DeveloperError.prototype=Object.create(Error.prototype),DeveloperError.prototype.constructor=DeveloperError),DeveloperError.prototype.toString=function(){var e=this.name+": "+this.message;return defined(this.stack)&&(e+="\n"+this.stack.toString()),e},DeveloperError.throwInstantiationError=function(){throw new DeveloperError("This function defines an interface and should not be called directly.")};var Check={};function getUndefinedErrorMessage(e){return e+" is required, actual value was undefined"}function getFailedTypeErrorMessage(e,t,i){return"Expected "+i+" to be typeof "+t+", actual typeof was "+e}Check.typeOf={},Check.defined=function(e,t){if(!defined(t))throw new DeveloperError(getUndefinedErrorMessage(e))},Check.typeOf.func=function(e,t){if("function"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"function",e))},Check.typeOf.string=function(e,t){if("string"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"string",e))},Check.typeOf.number=function(e,t){if("number"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"number",e))},Check.typeOf.number.lessThan=function(e,t,i){if(Check.typeOf.number(e,t),i<=t)throw new DeveloperError("Expected "+e+" to be less than "+i+", actual value was "+t)},Check.typeOf.number.lessThanOrEquals=function(e,t,i){if(Check.typeOf.number(e,t),i<t)throw new DeveloperError("Expected "+e+" to be less than or equal to "+i+", actual value was "+t)},Check.typeOf.number.greaterThan=function(e,t,i){if(Check.typeOf.number(e,t),t<=i)throw new DeveloperError("Expected "+e+" to be greater than "+i+", actual value was "+t)},Check.typeOf.number.greaterThanOrEquals=function(e,t,i){if(Check.typeOf.number(e,t),t<i)throw new DeveloperError("Expected "+e+" to be greater than or equal to"+i+", actual value was "+t)},Check.typeOf.object=function(e,t){if("object"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"object",e))},Check.typeOf.bool=function(e,t){if("boolean"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"boolean",e))},Check.typeOf.number.equals=function(e,t,i,r){if(Check.typeOf.number(e,i),Check.typeOf.number(t,r),i!==r)throw new DeveloperError(e+" must be equal to "+t+", the actual values are "+i+" and "+r)};var freezeObject=Object.freeze;defined(freezeObject)||(freezeObject=function(e){return e});var freezeObject$1=freezeObject;function defaultValue(e,t){return null!=e?e:t}defaultValue.EMPTY_OBJECT=freezeObject$1({});var MersenneTwister=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};MersenneTwister.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},MersenneTwister.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var i;for(this.mti==this.N+1&&this.init_genrand(5489),i=0;i<this.N-this.M;i++)e=this.mt[i]&this.UPPER_MASK|this.mt[i+1]&this.LOWER_MASK,this.mt[i]=this.mt[i+this.M]^e>>>1^t[1&e];for(;i<this.N-1;i++)e=this.mt[i]&this.UPPER_MASK|this.mt[i+1]&this.LOWER_MASK,this.mt[i]=this.mt[i+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},MersenneTwister.prototype.random=function(){return this.genrand_int32()*(1/4294967296)};var CesiumMath={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536,FOUR_GIGABYTES:4294967296};CesiumMath.sign=defaultValue(Math.sign,function(e){return 0===(e=+e)||e!=e?e:0<e?1:-1}),CesiumMath.signNotZero=function(e){return e<0?-1:1},CesiumMath.toSNorm=function(e,t){return t=defaultValue(t,255),Math.round((.5*CesiumMath.clamp(e,-1,1)+.5)*t)},CesiumMath.fromSNorm=function(e,t){return t=defaultValue(t,255),CesiumMath.clamp(e,0,t)/t*2-1},CesiumMath.normalize=function(e,t,i){return 0===(i=Math.max(i-t,0))?0:CesiumMath.clamp((e-t)/i,0,1)},CesiumMath.sinh=defaultValue(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),CesiumMath.cosh=defaultValue(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),CesiumMath.lerp=function(e,t,i){return(1-i)*e+i*t},CesiumMath.PI=Math.PI,CesiumMath.ONE_OVER_PI=1/Math.PI,CesiumMath.PI_OVER_TWO=Math.PI/2,CesiumMath.PI_OVER_THREE=Math.PI/3,CesiumMath.PI_OVER_FOUR=Math.PI/4,CesiumMath.PI_OVER_SIX=Math.PI/6,CesiumMath.THREE_PI_OVER_TWO=3*Math.PI/2,CesiumMath.TWO_PI=2*Math.PI,CesiumMath.ONE_OVER_TWO_PI=1/(2*Math.PI),CesiumMath.RADIANS_PER_DEGREE=Math.PI/180,CesiumMath.DEGREES_PER_RADIAN=180/Math.PI,CesiumMath.RADIANS_PER_ARCSECOND=CesiumMath.RADIANS_PER_DEGREE/3600,CesiumMath.toRadians=function(e){return e*CesiumMath.RADIANS_PER_DEGREE},CesiumMath.toDegrees=function(e){return e*CesiumMath.DEGREES_PER_RADIAN},CesiumMath.convertLongitudeRange=function(e){var t=CesiumMath.TWO_PI,i=e-Math.floor(e/t)*t;return i<-Math.PI?i+t:i>=Math.PI?i-t:i},CesiumMath.clampToLatitudeRange=function(e){return CesiumMath.clamp(e,-1*CesiumMath.PI_OVER_TWO,CesiumMath.PI_OVER_TWO)},CesiumMath.negativePiToPi=function(e){return CesiumMath.zeroToTwoPi(e+CesiumMath.PI)-CesiumMath.PI},CesiumMath.zeroToTwoPi=function(e){var t=CesiumMath.mod(e,CesiumMath.TWO_PI);return Math.abs(t)<CesiumMath.EPSILON14&&Math.abs(e)>CesiumMath.EPSILON14?CesiumMath.TWO_PI:t},CesiumMath.mod=function(e,t){return(e%t+t)%t},CesiumMath.equalsEpsilon=function(e,t,i,r){r=defaultValue(r,i);var n=Math.abs(e-t);return n<=r||n<=i*Math.max(Math.abs(e),Math.abs(t))},CesiumMath.lessThan=function(e,t,i){return e-t<-i},CesiumMath.lessThanOrEquals=function(e,t,i){return e-t<i},CesiumMath.greaterThan=function(e,t,i){return i<e-t},CesiumMath.greaterThanOrEquals=function(e,t,i){return-i<e-t};var factorials=[1];CesiumMath.factorial=function(e){var t=factorials.length;if(t<=e)for(var i=factorials[t-1],r=t;r<=e;r++){var n=i*r;factorials.push(n),i=n}return factorials[e]},CesiumMath.incrementWrap=function(e,t,i){return i=defaultValue(i,0),t<++e&&(e=i),e},CesiumMath.isPowerOfTwo=function(e){return 0!==e&&0==(e&e-1)},CesiumMath.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},CesiumMath.clamp=function(e,t,i){return e<t?t:i<e?i:e};var randomNumberGenerator=new MersenneTwister;function Cartesian3(e,t,i){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0)}CesiumMath.setRandomNumberSeed=function(e){randomNumberGenerator=new MersenneTwister(e)},CesiumMath.nextRandomNumber=function(){return randomNumberGenerator.random()},CesiumMath.randomBetween=function(e,t){return CesiumMath.nextRandomNumber()*(t-e)+e},CesiumMath.acosClamped=function(e){return Math.acos(CesiumMath.clamp(e,-1,1))},CesiumMath.asinClamped=function(e){return Math.asin(CesiumMath.clamp(e,-1,1))},CesiumMath.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},CesiumMath.logBase=function(e,t){return Math.log(e)/Math.log(t)},CesiumMath.cbrt=defaultValue(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t}),CesiumMath.log2=defaultValue(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),CesiumMath.fog=function(e,t){var i=e*t;return 1-Math.exp(-i*i)},CesiumMath.fastApproximateAtan=function(e){return e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},CesiumMath.fastApproximateAtan2=function(e,t){var i,r,n=Math.abs(e);i=Math.abs(t),r=Math.max(n,i);var a=(i=Math.min(n,i))/r;return n=CesiumMath.fastApproximateAtan(a),n=Math.abs(t)>Math.abs(e)?CesiumMath.PI_OVER_TWO-n:n,n=e<0?CesiumMath.PI-n:n,n=t<0?-n:n},Cartesian3.fromSpherical=function(e,t){defined(t)||(t=new Cartesian3);var i=e.clock,r=e.cone,n=defaultValue(e.magnitude,1),a=n*Math.sin(r);return t.x=a*Math.cos(i),t.y=a*Math.sin(i),t.z=n*Math.cos(r),t},Cartesian3.fromElements=function(e,t,i,r){return defined(r)?(r.x=e,r.y=t,r.z=i,r):new Cartesian3(e,t,i)},Cartesian3.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new Cartesian3(e.x,e.y,e.z)},Cartesian3.fromCartesian4=Cartesian3.clone,Cartesian3.packedLength=3,Cartesian3.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i]=e.z,t},Cartesian3.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian3),i.x=e[t++],i.y=e[t++],i.z=e[t],i},Cartesian3.packArray=function(e,t){var i=e.length;defined(t)?t.length=3*i:t=new Array(3*i);for(var r=0;r<i;++r)Cartesian3.pack(e[r],t,3*r);return t},Cartesian3.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/3:t=new Array(i/3);for(var r=0;r<i;r+=3){var n=r/3;t[n]=Cartesian3.unpack(e,r,t[n])}return t},Cartesian3.fromArray=Cartesian3.unpack,Cartesian3.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},Cartesian3.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},Cartesian3.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i},Cartesian3.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i},Cartesian3.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},Cartesian3.magnitude=function(e){return Math.sqrt(Cartesian3.magnitudeSquared(e))};var distanceScratch=new Cartesian3;Cartesian3.distance=function(e,t){return Cartesian3.subtract(e,t,distanceScratch),Cartesian3.magnitude(distanceScratch)},Cartesian3.distanceSquared=function(e,t){return Cartesian3.subtract(e,t,distanceScratch),Cartesian3.magnitudeSquared(distanceScratch)},Cartesian3.normalize=function(e,t){var i=Cartesian3.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t},Cartesian3.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},Cartesian3.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i},Cartesian3.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i},Cartesian3.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i},Cartesian3.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i},Cartesian3.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i},Cartesian3.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i},Cartesian3.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},Cartesian3.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var lerpScratch=new Cartesian3;Cartesian3.lerp=function(e,t,i,r){return Cartesian3.multiplyByScalar(t,i,lerpScratch),r=Cartesian3.multiplyByScalar(e,1-i,r),Cartesian3.add(lerpScratch,r,r)};var angleBetweenScratch=new Cartesian3,angleBetweenScratch2=new Cartesian3;Cartesian3.angleBetween=function(e,t){Cartesian3.normalize(e,angleBetweenScratch),Cartesian3.normalize(t,angleBetweenScratch2);var i=Cartesian3.dot(angleBetweenScratch,angleBetweenScratch2),r=Cartesian3.magnitude(Cartesian3.cross(angleBetweenScratch,angleBetweenScratch2,angleBetweenScratch));return Math.atan2(r,i)};var mostOrthogonalAxisScratch=new Cartesian3;Cartesian3.mostOrthogonalAxis=function(e,t){var i=Cartesian3.normalize(e,mostOrthogonalAxisScratch);return Cartesian3.abs(i,i),t=i.x<=i.y?i.x<=i.z?Cartesian3.clone(Cartesian3.UNIT_X,t):Cartesian3.clone(Cartesian3.UNIT_Z,t):i.y<=i.z?Cartesian3.clone(Cartesian3.UNIT_Y,t):Cartesian3.clone(Cartesian3.UNIT_Z,t)},Cartesian3.projectVector=function(e,t,i){var r=Cartesian3.dot(e,t)/Cartesian3.dot(t,t);return Cartesian3.multiplyByScalar(t,r,i)},Cartesian3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},Cartesian3.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]},Cartesian3.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)&&CesiumMath.equalsEpsilon(e.z,t.z,i,r)},Cartesian3.cross=function(e,t,i){var r=e.x,n=e.y,a=e.z,o=t.x,s=t.y,l=t.z,c=n*l-a*s,u=a*o-r*l,d=r*s-n*o;return i.x=c,i.y=u,i.z=d,i},Cartesian3.midpoint=function(e,t,i){return i.x=.5*(e.x+t.x),i.y=.5*(e.y+t.y),i.z=.5*(e.z+t.z),i},Cartesian3.fromDegrees=function(e,t,i,r,n){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartesian3.fromRadians(e,t,i,r,n)};var scratchN=new Cartesian3,scratchK=new Cartesian3,wgs84RadiiSquared=new Cartesian3(40680631590769,40680631590769,40408299984661.445);Cartesian3.fromRadians=function(e,t,i,r,n){i=defaultValue(i,0);var a=defined(r)?r.radiiSquared:wgs84RadiiSquared,o=Math.cos(t);scratchN.x=o*Math.cos(e),scratchN.y=o*Math.sin(e),scratchN.z=Math.sin(t),scratchN=Cartesian3.normalize(scratchN,scratchN),Cartesian3.multiplyComponents(a,scratchN,scratchK);var s=Math.sqrt(Cartesian3.dot(scratchN,scratchK));return scratchK=Cartesian3.divideByScalar(scratchK,s,scratchK),scratchN=Cartesian3.multiplyByScalar(scratchN,i,scratchN),defined(n)||(n=new Cartesian3),Cartesian3.add(scratchK,scratchN,n)},Cartesian3.fromDegreesArray=function(e,t,i){var r=e.length;defined(i)?i.length=r/2:i=new Array(r/2);for(var n=0;n<r;n+=2){var a=e[n],o=e[n+1],s=n/2;i[s]=Cartesian3.fromDegrees(a,o,0,t,i[s])}return i},Cartesian3.fromRadiansArray=function(e,t,i){var r=e.length;defined(i)?i.length=r/2:i=new Array(r/2);for(var n=0;n<r;n+=2){var a=e[n],o=e[n+1],s=n/2;i[s]=Cartesian3.fromRadians(a,o,0,t,i[s])}return i},Cartesian3.fromDegreesArrayHeights=function(e,t,i){var r=e.length;defined(i)?i.length=r/3:i=new Array(r/3);for(var n=0;n<r;n+=3){var a=e[n],o=e[n+1],s=e[n+2],l=n/3;i[l]=Cartesian3.fromDegrees(a,o,s,t,i[l])}return i},Cartesian3.fromRadiansArrayHeights=function(e,t,i){var r=e.length;defined(i)?i.length=r/3:i=new Array(r/3);for(var n=0;n<r;n+=3){var a=e[n],o=e[n+1],s=e[n+2],l=n/3;i[l]=Cartesian3.fromRadians(a,o,s,t,i[l])}return i},Cartesian3.ZERO=freezeObject$1(new Cartesian3(0,0,0)),Cartesian3.UNIT_X=freezeObject$1(new Cartesian3(1,0,0)),Cartesian3.UNIT_Y=freezeObject$1(new Cartesian3(0,1,0)),Cartesian3.UNIT_Z=freezeObject$1(new Cartesian3(0,0,1)),Cartesian3.prototype.clone=function(e){return Cartesian3.clone(this,e)},Cartesian3.prototype.equals=function(e){return Cartesian3.equals(this,e)},Cartesian3.prototype.equalsEpsilon=function(e,t,i){return Cartesian3.equalsEpsilon(this,e,t,i)},Cartesian3.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"};var scaleToGeodeticSurfaceIntersection=new Cartesian3,scaleToGeodeticSurfaceGradient=new Cartesian3;function scaleToGeodeticSurface(e,t,i,r,n){var a=e.x,o=e.y,s=e.z,l=t.x,c=t.y,u=t.z,d=a*a*l*l,h=o*o*c*c,p=s*s*u*u,m=d+h+p,f=Math.sqrt(1/m),g=Cartesian3.multiplyByScalar(e,f,scaleToGeodeticSurfaceIntersection);if(m<r)return isFinite(f)?Cartesian3.clone(g,n):void 0;var _=i.x,y=i.y,v=i.z,C=scaleToGeodeticSurfaceGradient;C.x=g.x*_*2,C.y=g.y*y*2,C.z=g.z*v*2;var S,T,x,b,E,P,A,w=(1-f)*Cartesian3.magnitude(e)/(.5*Cartesian3.magnitude(C)),D=0;do{D=(S=d*(E=(T=1/(1+(w-=D)*_))*T)+h*(P=(x=1/(1+w*y))*x)+p*(A=(b=1/(1+w*v))*b)-1)/(-2*(d*(E*T)*_+h*(P*x)*y+p*(A*b)*v))}while(Math.abs(S)>CesiumMath.EPSILON12);return defined(n)?(n.x=a*T,n.y=o*x,n.z=s*b,n):new Cartesian3(a*T,o*x,s*b)}function Cartographic(e,t,i){this.longitude=defaultValue(e,0),this.latitude=defaultValue(t,0),this.height=defaultValue(i,0)}Cartographic.fromRadians=function(e,t,i,r){return i=defaultValue(i,0),defined(r)?(r.longitude=e,r.latitude=t,r.height=i,r):new Cartographic(e,t,i)},Cartographic.fromDegrees=function(e,t,i,r){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartographic.fromRadians(e,t,i,r)};var cartesianToCartographicN=new Cartesian3,cartesianToCartographicP=new Cartesian3,cartesianToCartographicH=new Cartesian3,wgs84OneOverRadii=new Cartesian3(1/6378137,1/6378137,1/6356752.314245179),wgs84OneOverRadiiSquared=new Cartesian3(1/40680631590769,1/40680631590769,1/40408299984661.445),wgs84CenterToleranceSquared=CesiumMath.EPSILON1;Cartographic.fromCartesian=function(e,t,i){var r=defined(t)?t.oneOverRadii:wgs84OneOverRadii,n=defined(t)?t.oneOverRadiiSquared:wgs84OneOverRadiiSquared,a=scaleToGeodeticSurface(e,r,n,defined(t)?t._centerToleranceSquared:wgs84CenterToleranceSquared,cartesianToCartographicP);if(defined(a)){var o=Cartesian3.multiplyComponents(a,n,cartesianToCartographicN);o=Cartesian3.normalize(o,o);var s=Cartesian3.subtract(e,a,cartesianToCartographicH),l=Math.atan2(o.y,o.x),c=Math.asin(o.z),u=CesiumMath.sign(Cartesian3.dot(s,e))*Cartesian3.magnitude(s);return defined(i)?(i.longitude=l,i.latitude=c,i.height=u,i):new Cartographic(l,c,u)}},Cartographic.toCartesian=function(e,t,i){return Cartesian3.fromRadians(e.longitude,e.latitude,e.height,t,i)},Cartographic.clone=function(e,t){if(defined(e))return defined(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new Cartographic(e.longitude,e.latitude,e.height)},Cartographic.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},Cartographic.equalsEpsilon=function(e,t,i){return e===t||defined(e)&&defined(t)&&Math.abs(e.longitude-t.longitude)<=i&&Math.abs(e.latitude-t.latitude)<=i&&Math.abs(e.height-t.height)<=i},Cartographic.ZERO=freezeObject$1(new Cartographic(0,0,0)),Cartographic.prototype.clone=function(e){return Cartographic.clone(this,e)},Cartographic.prototype.equals=function(e){return Cartographic.equals(this,e)},Cartographic.prototype.equalsEpsilon=function(e,t){return Cartographic.equalsEpsilon(this,e,t)},Cartographic.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"};var definePropertyWorks=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),defineProperties=Object.defineProperties;definePropertyWorks&&defined(defineProperties)||(defineProperties=function(e){return e});var defineProperties$1=defineProperties;function initialize(e,t,i,r){t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),e._radii=new Cartesian3(t,i,r),e._radiiSquared=new Cartesian3(t*t,i*i,r*r),e._radiiToTheFourth=new Cartesian3(t*t*t*t,i*i*i*i,r*r*r*r),e._oneOverRadii=new Cartesian3(0===t?0:1/t,0===i?0:1/i,0===r?0:1/r),e._oneOverRadiiSquared=new Cartesian3(0===t?0:1/(t*t),0===i?0:1/(i*i),0===r?0:1/(r*r)),e._minimumRadius=Math.min(t,i,r),e._maximumRadius=Math.max(t,i,r),e._centerToleranceSquared=CesiumMath.EPSILON1,0!==e._radiiSquared.z&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function Ellipsoid(e,t,i){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,initialize(this,e,t,i)}defineProperties$1(Ellipsoid.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),Ellipsoid.clone=function(e,t){if(defined(e)){var i=e._radii;return defined(t)?(Cartesian3.clone(i,t._radii),Cartesian3.clone(e._radiiSquared,t._radiiSquared),Cartesian3.clone(e._radiiToTheFourth,t._radiiToTheFourth),Cartesian3.clone(e._oneOverRadii,t._oneOverRadii),Cartesian3.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new Ellipsoid(i.x,i.y,i.z)}},Ellipsoid.fromCartesian3=function(e,t){return defined(t)||(t=new Ellipsoid),defined(e)&&initialize(t,e.x,e.y,e.z),t},Ellipsoid.WGS84=freezeObject$1(new Ellipsoid(6378137,6378137,6356752.314245179)),Ellipsoid.UNIT_SPHERE=freezeObject$1(new Ellipsoid(1,1,1)),Ellipsoid.MOON=freezeObject$1(new Ellipsoid(CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS)),Ellipsoid.prototype.clone=function(e){return Ellipsoid.clone(this,e)},Ellipsoid.packedLength=Cartesian3.packedLength,Ellipsoid.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),t},Ellipsoid.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t);return Ellipsoid.fromCartesian3(r,i)},Ellipsoid.prototype.geocentricSurfaceNormal=Cartesian3.normalize,Ellipsoid.prototype.geodeticSurfaceNormalCartographic=function(e,t){var i=e.longitude,r=e.latitude,n=Math.cos(r),a=n*Math.cos(i),o=n*Math.sin(i),s=Math.sin(r);return defined(t)||(t=new Cartesian3),t.x=a,t.y=o,t.z=s,Cartesian3.normalize(t,t)},Ellipsoid.prototype.geodeticSurfaceNormal=function(e,t){return defined(t)||(t=new Cartesian3),t=Cartesian3.multiplyComponents(e,this._oneOverRadiiSquared,t),Cartesian3.normalize(t,t)};var cartographicToCartesianNormal=new Cartesian3,cartographicToCartesianK=new Cartesian3;Ellipsoid.prototype.cartographicToCartesian=function(e,t){var i=cartographicToCartesianNormal,r=cartographicToCartesianK;this.geodeticSurfaceNormalCartographic(e,i),Cartesian3.multiplyComponents(this._radiiSquared,i,r);var n=Math.sqrt(Cartesian3.dot(i,r));return Cartesian3.divideByScalar(r,n,r),Cartesian3.multiplyByScalar(i,e.height,i),defined(t)||(t=new Cartesian3),Cartesian3.add(r,i,t)},Ellipsoid.prototype.cartographicArrayToCartesianArray=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;r++)t[r]=this.cartographicToCartesian(e[r],t[r]);return t};var cartesianToCartographicN$1=new Cartesian3,cartesianToCartographicP$1=new Cartesian3,cartesianToCartographicH$1=new Cartesian3;function GeographicProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}Ellipsoid.prototype.cartesianToCartographic=function(e,t){var i=this.scaleToGeodeticSurface(e,cartesianToCartographicP$1);if(defined(i)){var r=this.geodeticSurfaceNormal(i,cartesianToCartographicN$1),n=Cartesian3.subtract(e,i,cartesianToCartographicH$1),a=Math.atan2(r.y,r.x),o=Math.asin(r.z),s=CesiumMath.sign(Cartesian3.dot(n,e))*Cartesian3.magnitude(n);return defined(t)?(t.longitude=a,t.latitude=o,t.height=s,t):new Cartographic(a,o,s)}},Ellipsoid.prototype.cartesianArrayToCartographicArray=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;++r)t[r]=this.cartesianToCartographic(e[r],t[r]);return t},Ellipsoid.prototype.scaleToGeodeticSurface=function(e,t){return scaleToGeodeticSurface(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},Ellipsoid.prototype.scaleToGeocentricSurface=function(e,t){defined(t)||(t=new Cartesian3);var i=e.x,r=e.y,n=e.z,a=this._oneOverRadiiSquared,o=1/Math.sqrt(i*i*a.x+r*r*a.y+n*n*a.z);return Cartesian3.multiplyByScalar(e,o,t)},Ellipsoid.prototype.transformPositionToScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._oneOverRadii,t)},Ellipsoid.prototype.transformPositionFromScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._radii,t)},Ellipsoid.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this._radii,e._radii)},Ellipsoid.prototype.toString=function(){return this._radii.toString()},Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,t,i){t=defaultValue(t,0);var r=this._squaredXOverSquaredZ;if(defined(i)||(i=new Cartesian3),i.x=0,i.y=0,i.z=e.z*(1-r),!(Math.abs(i.z)>=this._radii.z-t))return i},defineProperties$1(GeographicProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),GeographicProjection.prototype.project=function(e,t){var i=this._semimajorAxis,r=e.longitude*i,n=e.latitude*i,a=e.height;return defined(t)?(t.x=r,t.y=n,t.z=a,t):new Cartesian3(r,n,a)},GeographicProjection.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,r=e.x*i,n=e.y*i,a=e.z;return defined(t)?(t.longitude=r,t.latitude=n,t.height=a,t):new Cartographic(r,n,a)};var Intersect={OUTSIDE:-1,INTERSECTING:0,INSIDE:1},Intersect$1=freezeObject$1(Intersect);function Interval(e,t){this.start=defaultValue(e,0),this.stop=defaultValue(t,0)}function Matrix3(e,t,i,r,n,a,o,s,l){this[0]=defaultValue(e,0),this[1]=defaultValue(r,0),this[2]=defaultValue(o,0),this[3]=defaultValue(t,0),this[4]=defaultValue(n,0),this[5]=defaultValue(s,0),this[6]=defaultValue(i,0),this[7]=defaultValue(a,0),this[8]=defaultValue(l,0)}Matrix3.packedLength=9,Matrix3.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t},Matrix3.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix3),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i},Matrix3.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new Matrix3(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},Matrix3.fromArray=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix3),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i},Matrix3.fromColumnMajorArray=function(e,t){return Matrix3.clone(e,t)},Matrix3.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new Matrix3(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},Matrix3.fromQuaternion=function(e,t){var i=e.x*e.x,r=e.x*e.y,n=e.x*e.z,a=e.x*e.w,o=e.y*e.y,s=e.y*e.z,l=e.y*e.w,c=e.z*e.z,u=e.z*e.w,d=e.w*e.w,h=i-o-c+d,p=2*(r-u),m=2*(n+l),f=2*(r+u),g=o-i-c+d,_=2*(s-a),y=2*(n-l),v=2*(s+a),C=-i-o+c+d;return defined(t)?(t[0]=h,t[1]=f,t[2]=y,t[3]=p,t[4]=g,t[5]=v,t[6]=m,t[7]=_,t[8]=C,t):new Matrix3(h,p,m,f,g,_,y,v,C)},Matrix3.fromHeadingPitchRoll=function(e,t){var i=Math.cos(-e.pitch),r=Math.cos(-e.heading),n=Math.cos(e.roll),a=Math.sin(-e.pitch),o=Math.sin(-e.heading),s=Math.sin(e.roll),l=i*r,c=-n*o+s*a*r,u=s*o+n*a*r,d=i*o,h=n*r+s*a*o,p=-s*r+n*a*o,m=-a,f=s*i,g=n*i;return defined(t)?(t[0]=l,t[1]=d,t[2]=m,t[3]=c,t[4]=h,t[5]=f,t[6]=u,t[7]=p,t[8]=g,t):new Matrix3(l,c,u,d,h,p,m,f,g)},Matrix3.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new Matrix3(e.x,0,0,0,e.y,0,0,0,e.z)},Matrix3.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new Matrix3(e,0,0,0,e,0,0,0,e)},Matrix3.fromCrossProduct=function(e,t){return defined(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new Matrix3(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},Matrix3.fromRotationX=function(e,t){var i=Math.cos(e),r=Math.sin(e);return defined(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=i,t[5]=r,t[6]=0,t[7]=-r,t[8]=i,t):new Matrix3(1,0,0,0,i,-r,0,r,i)},Matrix3.fromRotationY=function(e,t){var i=Math.cos(e),r=Math.sin(e);return defined(t)?(t[0]=i,t[1]=0,t[2]=-r,t[3]=0,t[4]=1,t[5]=0,t[6]=r,t[7]=0,t[8]=i,t):new Matrix3(i,0,r,0,1,0,-r,0,i)},Matrix3.fromRotationZ=function(e,t){var i=Math.cos(e),r=Math.sin(e);return defined(t)?(t[0]=i,t[1]=r,t[2]=0,t[3]=-r,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(i,-r,0,r,i,0,0,0,1)},Matrix3.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},Matrix3.getElementIndex=function(e,t){return 3*e+t},Matrix3.getColumn=function(e,t,i){var r=3*t,n=e[r],a=e[1+r],o=e[2+r];return i.x=n,i.y=a,i.z=o,i},Matrix3.setColumn=function(e,t,i,r){var n=3*t;return(r=Matrix3.clone(e,r))[n]=i.x,r[1+n]=i.y,r[2+n]=i.z,r},Matrix3.getRow=function(e,t,i){var r=e[t],n=e[t+3],a=e[t+6];return i.x=r,i.y=n,i.z=a,i},Matrix3.setRow=function(e,t,i,r){return(r=Matrix3.clone(e,r))[t]=i.x,r[t+3]=i.y,r[t+6]=i.z,r};var scratchColumn=new Cartesian3;Matrix3.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[3],e[4],e[5],scratchColumn)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[6],e[7],e[8],scratchColumn)),t};var scratchScale=new Cartesian3;Matrix3.getMaximumScale=function(e){return Matrix3.getScale(e,scratchScale),Cartesian3.maximumComponent(scratchScale)},Matrix3.multiply=function(e,t,i){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],n=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],l=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],u=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],d=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return i[0]=r,i[1]=n,i[2]=a,i[3]=o,i[4]=s,i[5]=l,i[6]=c,i[7]=u,i[8]=d,i},Matrix3.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i},Matrix3.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i},Matrix3.multiplyByVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[3]*n+e[6]*a,s=e[1]*r+e[4]*n+e[7]*a,l=e[2]*r+e[5]*n+e[8]*a;return i.x=o,i.y=s,i.z=l,i},Matrix3.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i},Matrix3.multiplyByScale=function(e,t,i){return i[0]=e[0]*t.x,i[1]=e[1]*t.x,i[2]=e[2]*t.x,i[3]=e[3]*t.y,i[4]=e[4]*t.y,i[5]=e[5]*t.y,i[6]=e[6]*t.z,i[7]=e[7]*t.z,i[8]=e[8]*t.z,i},Matrix3.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},Matrix3.transpose=function(e,t){var i=e[0],r=e[3],n=e[6],a=e[1],o=e[4],s=e[7],l=e[2],c=e[5],u=e[8];return t[0]=i,t[1]=r,t[2]=n,t[3]=a,t[4]=o,t[5]=s,t[6]=l,t[7]=c,t[8]=u,t};var UNIT=new Cartesian3(1,1,1);function computeFrobeniusNorm(e){for(var t=0,i=0;i<9;++i){var r=e[i];t+=r*r}return Math.sqrt(t)}Matrix3.getRotation=function(e,t){var i=Cartesian3.divideComponents(UNIT,Matrix3.getScale(e,scratchScale),scratchScale);return t=Matrix3.multiplyByScale(e,i,t)};var rowVal=[1,0,0],colVal=[2,2,1];function offDiagonalFrobeniusNorm(e){for(var t=0,i=0;i<3;++i){var r=e[Matrix3.getElementIndex(colVal[i],rowVal[i])];t+=2*r*r}return Math.sqrt(t)}function shurDecomposition(e,t){for(var i=CesiumMath.EPSILON15,r=0,n=1,a=0;a<3;++a){var o=Math.abs(e[Matrix3.getElementIndex(colVal[a],rowVal[a])]);r<o&&(n=a,r=o)}var s=1,l=0,c=rowVal[n],u=colVal[n];if(Math.abs(e[Matrix3.getElementIndex(u,c)])>i){var d,h=(e[Matrix3.getElementIndex(u,u)]-e[Matrix3.getElementIndex(c,c)])/2/e[Matrix3.getElementIndex(u,c)];l=(d=h<0?-1/(-h+Math.sqrt(1+h*h)):1/(h+Math.sqrt(1+h*h)))*(s=1/Math.sqrt(1+d*d))}return(t=Matrix3.clone(Matrix3.IDENTITY,t))[Matrix3.getElementIndex(c,c)]=t[Matrix3.getElementIndex(u,u)]=s,t[Matrix3.getElementIndex(u,c)]=l,t[Matrix3.getElementIndex(c,u)]=-l,t}var jMatrix=new Matrix3,jMatrixTranspose=new Matrix3;function Cartesian4(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0),this.w=defaultValue(r,0)}Matrix3.computeEigenDecomposition=function(e,t){var i=CesiumMath.EPSILON20,r=0,n=0;defined(t)||(t={});for(var a=t.unitary=Matrix3.clone(Matrix3.IDENTITY,t.unitary),o=t.diagonal=Matrix3.clone(e,t.diagonal),s=i*computeFrobeniusNorm(o);n<10&&offDiagonalFrobeniusNorm(o)>s;)shurDecomposition(o,jMatrix),Matrix3.transpose(jMatrix,jMatrixTranspose),Matrix3.multiply(o,jMatrix,o),Matrix3.multiply(jMatrixTranspose,o,o),Matrix3.multiply(a,jMatrix,a),2<++r&&(++n,r=0);return t},Matrix3.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},Matrix3.determinant=function(e){var t=e[0],i=e[3],r=e[6],n=e[1],a=e[4],o=e[7],s=e[2],l=e[5],c=e[8];return t*(a*c-l*o)+n*(l*r-i*c)+s*(i*o-a*r)},Matrix3.inverse=function(e,t){var i=e[0],r=e[1],n=e[2],a=e[3],o=e[4],s=e[5],l=e[6],c=e[7],u=e[8],d=Matrix3.determinant(e);t[0]=o*u-c*s,t[1]=c*n-r*u,t[2]=r*s-o*n,t[3]=l*s-a*u,t[4]=i*u-l*n,t[5]=a*n-i*s,t[6]=a*c-l*o,t[7]=l*r-i*c,t[8]=i*o-a*r;var h=1/d;return Matrix3.multiplyByScalar(t,h,t)},Matrix3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},Matrix3.equalsEpsilon=function(e,t,i){return e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i},Matrix3.IDENTITY=freezeObject$1(new Matrix3(1,0,0,0,1,0,0,0,1)),Matrix3.ZERO=freezeObject$1(new Matrix3(0,0,0,0,0,0,0,0,0)),Matrix3.COLUMN0ROW0=0,Matrix3.COLUMN0ROW1=1,Matrix3.COLUMN0ROW2=2,Matrix3.COLUMN1ROW0=3,Matrix3.COLUMN1ROW1=4,Matrix3.COLUMN1ROW2=5,Matrix3.COLUMN2ROW0=6,Matrix3.COLUMN2ROW1=7,Matrix3.COLUMN2ROW2=8,defineProperties$1(Matrix3.prototype,{length:{get:function(){return Matrix3.packedLength}}}),Matrix3.prototype.clone=function(e){return Matrix3.clone(this,e)},Matrix3.prototype.equals=function(e){return Matrix3.equals(this,e)},Matrix3.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]},Matrix3.prototype.equalsEpsilon=function(e,t){return Matrix3.equalsEpsilon(this,e,t)},Matrix3.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},Cartesian4.fromElements=function(e,t,i,r,n){return defined(n)?(n.x=e,n.y=t,n.z=i,n.w=r,n):new Cartesian4(e,t,i,r)},Cartesian4.fromColor=function(e,t){return defined(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new Cartesian4(e.red,e.green,e.blue,e.alpha)},Cartesian4.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Cartesian4(e.x,e.y,e.z,e.w)},Cartesian4.packedLength=4,Cartesian4.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.z,t[i]=e.w,t},Cartesian4.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian4),i.x=e[t++],i.y=e[t++],i.z=e[t++],i.w=e[t],i},Cartesian4.packArray=function(e,t){var i=e.length;defined(t)?t.length=4*i:t=new Array(4*i);for(var r=0;r<i;++r)Cartesian4.pack(e[r],t,4*r);return t},Cartesian4.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/4:t=new Array(i/4);for(var r=0;r<i;r+=4){var n=r/4;t[n]=Cartesian4.unpack(e,r,t[n])}return t},Cartesian4.fromArray=Cartesian4.unpack,Cartesian4.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},Cartesian4.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},Cartesian4.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i.w=Math.min(e.w,t.w),i},Cartesian4.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i.w=Math.max(e.w,t.w),i},Cartesian4.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Cartesian4.magnitude=function(e){return Math.sqrt(Cartesian4.magnitudeSquared(e))};var distanceScratch$1=new Cartesian4;Cartesian4.distance=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$1),Cartesian4.magnitude(distanceScratch$1)},Cartesian4.distanceSquared=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$1),Cartesian4.magnitudeSquared(distanceScratch$1)},Cartesian4.normalize=function(e,t){var i=Cartesian4.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t.w=e.w/i,t},Cartesian4.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Cartesian4.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i.w=e.w*t.w,i},Cartesian4.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i.w=e.w/t.w,i},Cartesian4.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},Cartesian4.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},Cartesian4.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},Cartesian4.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},Cartesian4.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Cartesian4.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var lerpScratch$1=new Cartesian4;Cartesian4.lerp=function(e,t,i,r){return Cartesian4.multiplyByScalar(t,i,lerpScratch$1),r=Cartesian4.multiplyByScalar(e,1-i,r),Cartesian4.add(lerpScratch$1,r,r)};var mostOrthogonalAxisScratch$1=new Cartesian4;Cartesian4.mostOrthogonalAxis=function(e,t){var i=Cartesian4.normalize(e,mostOrthogonalAxisScratch$1);return Cartesian4.abs(i,i),t=i.x<=i.y?i.x<=i.z?i.x<=i.w?Cartesian4.clone(Cartesian4.UNIT_X,t):Cartesian4.clone(Cartesian4.UNIT_W,t):i.z<=i.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t):i.y<=i.z?i.y<=i.w?Cartesian4.clone(Cartesian4.UNIT_Y,t):Cartesian4.clone(Cartesian4.UNIT_W,t):i.z<=i.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t)},Cartesian4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Cartesian4.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]&&e.w===t[i+3]},Cartesian4.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)&&CesiumMath.equalsEpsilon(e.z,t.z,i,r)&&CesiumMath.equalsEpsilon(e.w,t.w,i,r)},Cartesian4.ZERO=freezeObject$1(new Cartesian4(0,0,0,0)),Cartesian4.UNIT_X=freezeObject$1(new Cartesian4(1,0,0,0)),Cartesian4.UNIT_Y=freezeObject$1(new Cartesian4(0,1,0,0)),Cartesian4.UNIT_Z=freezeObject$1(new Cartesian4(0,0,1,0)),Cartesian4.UNIT_W=freezeObject$1(new Cartesian4(0,0,0,1)),Cartesian4.prototype.clone=function(e){return Cartesian4.clone(this,e)},Cartesian4.prototype.equals=function(e){return Cartesian4.equals(this,e)},Cartesian4.prototype.equalsEpsilon=function(e,t,i){return Cartesian4.equalsEpsilon(this,e,t,i)},Cartesian4.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var scratchFloatArray=new Float32Array(1),SHIFT_LEFT_8=256,SHIFT_LEFT_16=65536,SHIFT_LEFT_24=16777216,SHIFT_RIGHT_8=1/SHIFT_LEFT_8,SHIFT_RIGHT_16=1/SHIFT_LEFT_16,SHIFT_RIGHT_24=1/SHIFT_LEFT_24,BIAS=38;Cartesian4.packFloat=function(e,t){if(defined(t)||(t=new Cartesian4),scratchFloatArray[0]=e,0===(e=scratchFloatArray[0]))return Cartesian4.clone(Cartesian4.ZERO,t);var i,r=e<0?1:0;isFinite(e)?(e=Math.abs(e),i=Math.floor(CesiumMath.logBase(e,10))+1,e/=Math.pow(10,i)):(e=.1,i=BIAS);var n=e*SHIFT_LEFT_8;return t.x=Math.floor(n),n=(n-t.x)*SHIFT_LEFT_8,t.y=Math.floor(n),n=(n-t.y)*SHIFT_LEFT_8,t.z=Math.floor(n),t.w=2*(i+BIAS)+r,t},Cartesian4.unpackFloat=function(e){var t=e.w/2,i=Math.floor(t),r=2*(t-i);if(r=-(r=2*r-1),BIAS<=(i-=BIAS))return r<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var n=r*e.x*SHIFT_RIGHT_8;return n+=r*e.y*SHIFT_RIGHT_16,(n+=r*e.z*SHIFT_RIGHT_24)*Math.pow(10,i)};var warnings={};function oneTimeWarning(e,t){defined(warnings[e])||(warnings[e]=!0,console.warn(defaultValue(t,e)))}function deprecationWarning(e,t){oneTimeWarning(e,t)}function RuntimeError(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}function Matrix4(e,t,i,r,n,a,o,s,l,c,u,d,h,p,m,f){this[0]=defaultValue(e,0),this[1]=defaultValue(n,0),this[2]=defaultValue(l,0),this[3]=defaultValue(h,0),this[4]=defaultValue(t,0),this[5]=defaultValue(a,0),this[6]=defaultValue(c,0),this[7]=defaultValue(p,0),this[8]=defaultValue(i,0),this[9]=defaultValue(o,0),this[10]=defaultValue(u,0),this[11]=defaultValue(m,0),this[12]=defaultValue(r,0),this[13]=defaultValue(s,0),this[14]=defaultValue(d,0),this[15]=defaultValue(f,0)}oneTimeWarning.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",oneTimeWarning.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",oneTimeWarning.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",oneTimeWarning.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",defined(Object.create)&&(RuntimeError.prototype=Object.create(Error.prototype),RuntimeError.prototype.constructor=RuntimeError),RuntimeError.prototype.toString=function(){var e=this.name+": "+this.message;return defined(this.stack)&&(e+="\n"+this.stack.toString()),e},Matrix4.packedLength=16,Matrix4.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},Matrix4.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix4),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},Matrix4.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new Matrix4(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},Matrix4.fromArray=Matrix4.unpack,Matrix4.fromColumnMajorArray=function(e,t){return Matrix4.clone(e,t)},Matrix4.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new Matrix4(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},Matrix4.fromRotationTranslation=function(e,t,i){return t=defaultValue(t,Cartesian3.ZERO),defined(i)?(i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=0,i[4]=e[3],i[5]=e[4],i[6]=e[5],i[7]=0,i[8]=e[6],i[9]=e[7],i[10]=e[8],i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,i):new Matrix4(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},Matrix4.fromTranslationQuaternionRotationScale=function(e,t,i,r){defined(r)||(r=new Matrix4);var n=i.x,a=i.y,o=i.z,s=t.x*t.x,l=t.x*t.y,c=t.x*t.z,u=t.x*t.w,d=t.y*t.y,h=t.y*t.z,p=t.y*t.w,m=t.z*t.z,f=t.z*t.w,g=t.w*t.w,_=s-d-m+g,y=2*(l-f),v=2*(c+p),C=2*(l+f),S=d-s-m+g,T=2*(h-u),x=2*(c-p),b=2*(h+u),E=-s-d+m+g;return r[0]=_*n,r[1]=C*n,r[2]=x*n,r[3]=0,r[4]=y*a,r[5]=S*a,r[6]=b*a,r[7]=0,r[8]=v*o,r[9]=T*o,r[10]=E*o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r},Matrix4.fromTranslationRotationScale=function(e,t){return Matrix4.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},Matrix4.fromTranslation=function(e,t){return Matrix4.fromRotationTranslation(Matrix3.IDENTITY,e,t)},Matrix4.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},Matrix4.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var fromCameraF=new Cartesian3,fromCameraR=new Cartesian3,fromCameraU=new Cartesian3;Matrix4.fromCamera=function(e,t){var i=e.position,r=e.direction,n=e.up;Cartesian3.normalize(r,fromCameraF),Cartesian3.normalize(Cartesian3.cross(fromCameraF,n,fromCameraR),fromCameraR),Cartesian3.normalize(Cartesian3.cross(fromCameraR,fromCameraF,fromCameraU),fromCameraU);var a=fromCameraR.x,o=fromCameraR.y,s=fromCameraR.z,l=fromCameraF.x,c=fromCameraF.y,u=fromCameraF.z,d=fromCameraU.x,h=fromCameraU.y,p=fromCameraU.z,m=i.x,f=i.y,g=i.z,_=a*-m+o*-f+s*-g,y=d*-m+h*-f+p*-g,v=l*m+c*f+u*g;return defined(t)?(t[0]=a,t[1]=d,t[2]=-l,t[3]=0,t[4]=o,t[5]=h,t[6]=-c,t[7]=0,t[8]=s,t[9]=p,t[10]=-u,t[11]=0,t[12]=_,t[13]=y,t[14]=v,t[15]=1,t):new Matrix4(a,o,s,_,d,h,p,y,-l,-c,-u,v,0,0,0,1)},Matrix4.computePerspectiveFieldOfView=function(e,t,i,r,n){var a=1/Math.tan(.5*e),o=a/t,s=(r+i)/(i-r),l=2*r*i/(i-r);return n[0]=o,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=a,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=s,n[11]=-1,n[12]=0,n[13]=0,n[14]=l,n[15]=0,n},Matrix4.computeOrthographicOffCenter=function(e,t,i,r,n,a,o){var s=1/(t-e),l=1/(r-i),c=1/(a-n),u=-(t+e)*s,d=-(r+i)*l,h=-(a+n)*c;return s*=2,l*=2,c*=-2,o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=l,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=u,o[13]=d,o[14]=h,o[15]=1,o},Matrix4.computePerspectiveOffCenter=function(e,t,i,r,n,a,o){var s=2*n/(t-e),l=2*n/(r-i),c=(t+e)/(t-e),u=(r+i)/(r-i),d=-(a+n)/(a-n),h=-2*a*n/(a-n);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=l,o[6]=0,o[7]=0,o[8]=c,o[9]=u,o[10]=d,o[11]=-1,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},Matrix4.computeInfinitePerspectiveOffCenter=function(e,t,i,r,n,a){var o=2*n/(t-e),s=2*n/(r-i),l=(t+e)/(t-e),c=(r+i)/(r-i),u=-2*n;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=l,a[9]=c,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=u,a[15]=0,a},Matrix4.computeViewportTransformation=function(e,t,i,r){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var n=defaultValue(e.x,0),a=defaultValue(e.y,0),o=defaultValue(e.width,0),s=defaultValue(e.height,0);t=defaultValue(t,0);var l=.5*o,c=.5*s,u=.5*((i=defaultValue(i,1))-t),d=l,h=c,p=u,m=n+l,f=a+c,g=t+u;return r[0]=d,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=h,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=p,r[11]=0,r[12]=m,r[13]=f,r[14]=g,r[15]=1,r},Matrix4.computeView=function(e,t,i,r,n){return n[0]=r.x,n[1]=i.x,n[2]=-t.x,n[3]=0,n[4]=r.y,n[5]=i.y,n[6]=-t.y,n[7]=0,n[8]=r.z,n[9]=i.z,n[10]=-t.z,n[11]=0,n[12]=-Cartesian3.dot(r,e),n[13]=-Cartesian3.dot(i,e),n[14]=Cartesian3.dot(t,e),n[15]=1,n},Matrix4.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},Matrix4.getElementIndex=function(e,t){return 4*e+t},Matrix4.getColumn=function(e,t,i){var r=4*t,n=e[r],a=e[1+r],o=e[2+r],s=e[3+r];return i.x=n,i.y=a,i.z=o,i.w=s,i},Matrix4.setColumn=function(e,t,i,r){var n=4*t;return(r=Matrix4.clone(e,r))[n]=i.x,r[1+n]=i.y,r[2+n]=i.z,r[3+n]=i.w,r},Matrix4.setTranslation=function(e,t,i){return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=e[15],i};var scaleScratch=new Cartesian3;Matrix4.setScale=function(e,t,i){var r=Matrix4.getScale(e,scaleScratch),n=Cartesian3.divideComponents(t,r,scaleScratch);return Matrix4.multiplyByScale(e,n,i)},Matrix4.getRow=function(e,t,i){var r=e[t],n=e[t+4],a=e[t+8],o=e[t+12];return i.x=r,i.y=n,i.z=a,i.w=o,i},Matrix4.setRow=function(e,t,i,r){return(r=Matrix4.clone(e,r))[t]=i.x,r[t+4]=i.y,r[t+8]=i.z,r[t+12]=i.w,r};var scratchColumn$1=new Cartesian3;Matrix4.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn$1)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[4],e[5],e[6],scratchColumn$1)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[8],e[9],e[10],scratchColumn$1)),t};var scratchScale$1=new Cartesian3;Matrix4.getMaximumScale=function(e){return Matrix4.getScale(e,scratchScale$1),Cartesian3.maximumComponent(scratchScale$1)},Matrix4.multiply=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[3],s=e[4],l=e[5],c=e[6],u=e[7],d=e[8],h=e[9],p=e[10],m=e[11],f=e[12],g=e[13],_=e[14],y=e[15],v=t[0],C=t[1],S=t[2],T=t[3],x=t[4],b=t[5],E=t[6],P=t[7],A=t[8],w=t[9],D=t[10],M=t[11],I=t[12],R=t[13],O=t[14],L=t[15],F=r*v+s*C+d*S+f*T,N=n*v+l*C+h*S+g*T,V=a*v+c*C+p*S+_*T,B=o*v+u*C+m*S+y*T,k=r*x+s*b+d*E+f*P,$=n*x+l*b+h*E+g*P,z=a*x+c*b+p*E+_*P,U=o*x+u*b+m*E+y*P,G=r*A+s*w+d*D+f*M,H=n*A+l*w+h*D+g*M,W=a*A+c*w+p*D+_*M,q=o*A+u*w+m*D+y*M,j=r*I+s*R+d*O+f*L,Y=n*I+l*R+h*O+g*L,X=a*I+c*R+p*O+_*L,Q=o*I+u*R+m*O+y*L;return i[0]=F,i[1]=N,i[2]=V,i[3]=B,i[4]=k,i[5]=$,i[6]=z,i[7]=U,i[8]=G,i[9]=H,i[10]=W,i[11]=q,i[12]=j,i[13]=Y,i[14]=X,i[15]=Q,i},Matrix4.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i[9]=e[9]+t[9],i[10]=e[10]+t[10],i[11]=e[11]+t[11],i[12]=e[12]+t[12],i[13]=e[13]+t[13],i[14]=e[14]+t[14],i[15]=e[15]+t[15],i},Matrix4.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i[9]=e[9]-t[9],i[10]=e[10]-t[10],i[11]=e[11]-t[11],i[12]=e[12]-t[12],i[13]=e[13]-t[13],i[14]=e[14]-t[14],i[15]=e[15]-t[15],i},Matrix4.multiplyTransformation=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[4],s=e[5],l=e[6],c=e[8],u=e[9],d=e[10],h=e[12],p=e[13],m=e[14],f=t[0],g=t[1],_=t[2],y=t[4],v=t[5],C=t[6],S=t[8],T=t[9],x=t[10],b=t[12],E=t[13],P=t[14],A=r*f+o*g+c*_,w=n*f+s*g+u*_,D=a*f+l*g+d*_,M=r*y+o*v+c*C,I=n*y+s*v+u*C,R=a*y+l*v+d*C,O=r*S+o*T+c*x,L=n*S+s*T+u*x,F=a*S+l*T+d*x,N=r*b+o*E+c*P+h,V=n*b+s*E+u*P+p,B=a*b+l*E+d*P+m;return i[0]=A,i[1]=w,i[2]=D,i[3]=0,i[4]=M,i[5]=I,i[6]=R,i[7]=0,i[8]=O,i[9]=L,i[10]=F,i[11]=0,i[12]=N,i[13]=V,i[14]=B,i[15]=1,i},Matrix4.multiplyByMatrix3=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[4],s=e[5],l=e[6],c=e[8],u=e[9],d=e[10],h=t[0],p=t[1],m=t[2],f=t[3],g=t[4],_=t[5],y=t[6],v=t[7],C=t[8],S=r*h+o*p+c*m,T=n*h+s*p+u*m,x=a*h+l*p+d*m,b=r*f+o*g+c*_,E=n*f+s*g+u*_,P=a*f+l*g+d*_,A=r*y+o*v+c*C,w=n*y+s*v+u*C,D=a*y+l*v+d*C;return i[0]=S,i[1]=T,i[2]=x,i[3]=0,i[4]=b,i[5]=E,i[6]=P,i[7]=0,i[8]=A,i[9]=w,i[10]=D,i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=e[15],i},Matrix4.multiplyByTranslation=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=r*e[0]+n*e[4]+a*e[8]+e[12],s=r*e[1]+n*e[5]+a*e[9]+e[13],l=r*e[2]+n*e[6]+a*e[10]+e[14];return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=o,i[13]=s,i[14]=l,i[15]=e[15],i};var uniformScaleScratch=new Cartesian3;Matrix4.multiplyByUniformScale=function(e,t,i){return uniformScaleScratch.x=t,uniformScaleScratch.y=t,uniformScaleScratch.z=t,Matrix4.multiplyByScale(e,uniformScaleScratch,i)},Matrix4.multiplyByScale=function(e,t,i){var r=t.x,n=t.y,a=t.z;return 1===r&&1===n&&1===a?Matrix4.clone(e,i):(i[0]=r*e[0],i[1]=r*e[1],i[2]=r*e[2],i[3]=0,i[4]=n*e[4],i[5]=n*e[5],i[6]=n*e[6],i[7]=0,i[8]=a*e[8],i[9]=a*e[9],i[10]=a*e[10],i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=1,i)},Matrix4.multiplyByVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=t.w,s=e[0]*r+e[4]*n+e[8]*a+e[12]*o,l=e[1]*r+e[5]*n+e[9]*a+e[13]*o,c=e[2]*r+e[6]*n+e[10]*a+e[14]*o,u=e[3]*r+e[7]*n+e[11]*a+e[15]*o;return i.x=s,i.y=l,i.z=c,i.w=u,i},Matrix4.multiplyByPointAsVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[4]*n+e[8]*a,s=e[1]*r+e[5]*n+e[9]*a,l=e[2]*r+e[6]*n+e[10]*a;return i.x=o,i.y=s,i.z=l,i},Matrix4.multiplyByPoint=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[4]*n+e[8]*a+e[12],s=e[1]*r+e[5]*n+e[9]*a+e[13],l=e[2]*r+e[6]*n+e[10]*a+e[14];return i.x=o,i.y=s,i.z=l,i},Matrix4.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i[9]=e[9]*t,i[10]=e[10]*t,i[11]=e[11]*t,i[12]=e[12]*t,i[13]=e[13]*t,i[14]=e[14]*t,i[15]=e[15]*t,i},Matrix4.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},Matrix4.transpose=function(e,t){var i=e[1],r=e[2],n=e[3],a=e[6],o=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=i,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=n,t[13]=o,t[14]=s,t[15]=e[15],t},Matrix4.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},Matrix4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},Matrix4.equalsEpsilon=function(e,t,i){return e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i&&Math.abs(e[9]-t[9])<=i&&Math.abs(e[10]-t[10])<=i&&Math.abs(e[11]-t[11])<=i&&Math.abs(e[12]-t[12])<=i&&Math.abs(e[13]-t[13])<=i&&Math.abs(e[14]-t[14])<=i&&Math.abs(e[15]-t[15])<=i},Matrix4.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},Matrix4.getRotation=function(e,t){return deprecationWarning("Matrix4.getRotation","Matrix4.getRotation is deprecated and will be removed in Cesium 1.65. Use Matrix4.getMatrix3 instead."),Matrix4.getMatrix3(e,t)},Matrix4.getMatrix3=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var scratchInverseRotation=new Matrix3,scratchMatrix3Zero=new Matrix3,scratchBottomRow=new Cartesian4,scratchExpectedBottomRow=new Cartesian4(0,0,0,1);function Rectangle(e,t,i,r){this.west=defaultValue(e,0),this.south=defaultValue(t,0),this.east=defaultValue(i,0),this.north=defaultValue(r,0)}Matrix4.inverse=function(e,t){var i=e[0],r=e[4],n=e[8],a=e[12],o=e[1],s=e[5],l=e[9],c=e[13],u=e[2],d=e[6],h=e[10],p=e[14],m=e[3],f=e[7],g=e[11],_=e[15],y=h*_,v=p*g,C=d*_,S=p*f,T=d*g,x=h*f,b=u*_,E=p*m,P=u*g,A=h*m,w=u*f,D=d*m,M=y*s+S*l+T*c-(v*s+C*l+x*c),I=v*o+b*l+A*c-(y*o+E*l+P*c),R=C*o+E*s+w*c-(S*o+b*s+D*c),O=x*o+P*s+D*l-(T*o+A*s+w*l),L=v*r+C*n+x*a-(y*r+S*n+T*a),F=y*i+E*n+P*a-(v*i+b*n+A*a),N=S*i+b*r+D*a-(C*i+E*r+w*a),V=T*i+A*r+w*n-(x*i+P*r+D*n),B=(y=n*c)*f+(S=a*s)*g+(T=r*l)*_-((v=a*l)*f+(C=r*c)*g+(x=n*s)*_),k=v*m+(b=i*c)*g+(A=n*o)*_-(y*m+(E=a*o)*g+(P=i*l)*_),$=C*m+E*f+(w=i*s)*_-(S*m+b*f+(D=r*o)*_),z=x*m+P*f+D*g-(T*m+A*f+w*g),U=C*h+x*p+v*d-(T*p+y*d+S*h),G=P*p+y*u+E*h-(b*h+A*p+v*u),H=b*d+D*p+S*u-(w*p+C*u+E*d),W=w*h+T*u+A*d-(P*d+D*h+x*u),q=i*M+r*I+n*R+a*O;if(Math.abs(q)<CesiumMath.EPSILON21){if(Matrix3.equalsEpsilon(Matrix4.getMatrix3(e,scratchInverseRotation),scratchMatrix3Zero,CesiumMath.EPSILON7)&&Cartesian4.equals(Matrix4.getRow(e,3,scratchBottomRow),scratchExpectedBottomRow))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;throw new RuntimeError("matrix is not invertible because its determinate is zero.")}return q=1/q,t[0]=M*q,t[1]=I*q,t[2]=R*q,t[3]=O*q,t[4]=L*q,t[5]=F*q,t[6]=N*q,t[7]=V*q,t[8]=B*q,t[9]=k*q,t[10]=$*q,t[11]=z*q,t[12]=U*q,t[13]=G*q,t[14]=H*q,t[15]=W*q,t},Matrix4.inverseTransformation=function(e,t){var i=e[0],r=e[1],n=e[2],a=e[4],o=e[5],s=e[6],l=e[8],c=e[9],u=e[10],d=e[12],h=e[13],p=e[14],m=-i*d-r*h-n*p,f=-a*d-o*h-s*p,g=-l*d-c*h-u*p;return t[0]=i,t[1]=a,t[2]=l,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=n,t[9]=s,t[10]=u,t[11]=0,t[12]=m,t[13]=f,t[14]=g,t[15]=1,t},Matrix4.IDENTITY=freezeObject$1(new Matrix4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),Matrix4.ZERO=freezeObject$1(new Matrix4(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),Matrix4.COLUMN0ROW0=0,Matrix4.COLUMN0ROW1=1,Matrix4.COLUMN0ROW2=2,Matrix4.COLUMN0ROW3=3,Matrix4.COLUMN1ROW0=4,Matrix4.COLUMN1ROW1=5,Matrix4.COLUMN1ROW2=6,Matrix4.COLUMN1ROW3=7,Matrix4.COLUMN2ROW0=8,Matrix4.COLUMN2ROW1=9,Matrix4.COLUMN2ROW2=10,Matrix4.COLUMN2ROW3=11,Matrix4.COLUMN3ROW0=12,Matrix4.COLUMN3ROW1=13,Matrix4.COLUMN3ROW2=14,Matrix4.COLUMN3ROW3=15,defineProperties$1(Matrix4.prototype,{length:{get:function(){return Matrix4.packedLength}}}),Matrix4.prototype.clone=function(e){return Matrix4.clone(this,e)},Matrix4.prototype.equals=function(e){return Matrix4.equals(this,e)},Matrix4.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]&&e[9]===t[i+9]&&e[10]===t[i+10]&&e[11]===t[i+11]&&e[12]===t[i+12]&&e[13]===t[i+13]&&e[14]===t[i+14]&&e[15]===t[i+15]},Matrix4.prototype.equalsEpsilon=function(e,t){return Matrix4.equalsEpsilon(this,e,t)},Matrix4.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},defineProperties$1(Rectangle.prototype,{width:{get:function(){return Rectangle.computeWidth(this)}},height:{get:function(){return Rectangle.computeHeight(this)}}}),Rectangle.packedLength=4,Rectangle.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.west,t[i++]=e.south,t[i++]=e.east,t[i]=e.north,t},Rectangle.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Rectangle),i.west=e[t++],i.south=e[t++],i.east=e[t++],i.north=e[t],i},Rectangle.computeWidth=function(e){var t=e.east,i=e.west;return t<i&&(t+=CesiumMath.TWO_PI),t-i},Rectangle.computeHeight=function(e){return e.north-e.south},Rectangle.fromDegrees=function(e,t,i,r,n){return e=CesiumMath.toRadians(defaultValue(e,0)),t=CesiumMath.toRadians(defaultValue(t,0)),i=CesiumMath.toRadians(defaultValue(i,0)),r=CesiumMath.toRadians(defaultValue(r,0)),defined(n)?(n.west=e,n.south=t,n.east=i,n.north=r,n):new Rectangle(e,t,i,r)},Rectangle.fromRadians=function(e,t,i,r,n){return defined(n)?(n.west=defaultValue(e,0),n.south=defaultValue(t,0),n.east=defaultValue(i,0),n.north=defaultValue(r,0),n):new Rectangle(e,t,i,r)},Rectangle.fromCartographicArray=function(e,t){for(var i=Number.MAX_VALUE,r=-Number.MAX_VALUE,n=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,l=0,c=e.length;l<c;l++){var u=e[l];i=Math.min(i,u.longitude),r=Math.max(r,u.longitude),o=Math.min(o,u.latitude),s=Math.max(s,u.latitude);var d=0<=u.longitude?u.longitude:u.longitude+CesiumMath.TWO_PI;n=Math.min(n,d),a=Math.max(a,d)}return a-n<r-i&&(i=n,(r=a)>CesiumMath.PI&&(r-=CesiumMath.TWO_PI),i>CesiumMath.PI&&(i-=CesiumMath.TWO_PI)),defined(t)?(t.west=i,t.south=o,t.east=r,t.north=s,t):new Rectangle(i,o,r,s)},Rectangle.fromCartesianArray=function(e,t,i){t=defaultValue(t,Ellipsoid.WGS84);for(var r=Number.MAX_VALUE,n=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,s=Number.MAX_VALUE,l=-Number.MAX_VALUE,c=0,u=e.length;c<u;c++){var d=t.cartesianToCartographic(e[c]);r=Math.min(r,d.longitude),n=Math.max(n,d.longitude),s=Math.min(s,d.latitude),l=Math.max(l,d.latitude);var h=0<=d.longitude?d.longitude:d.longitude+CesiumMath.TWO_PI;a=Math.min(a,h),o=Math.max(o,h)}return o-a<n-r&&(r=a,(n=o)>CesiumMath.PI&&(n-=CesiumMath.TWO_PI),r>CesiumMath.PI&&(r-=CesiumMath.TWO_PI)),defined(i)?(i.west=r,i.south=s,i.east=n,i.north=l,i):new Rectangle(r,s,n,l)},Rectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new Rectangle(e.west,e.south,e.east,e.north)},Rectangle.equalsEpsilon=function(e,t,i){return e===t||defined(e)&&defined(t)&&Math.abs(e.west-t.west)<=i&&Math.abs(e.south-t.south)<=i&&Math.abs(e.east-t.east)<=i&&Math.abs(e.north-t.north)<=i},Rectangle.prototype.clone=function(e){return Rectangle.clone(this,e)},Rectangle.prototype.equals=function(e){return Rectangle.equals(this,e)},Rectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},Rectangle.prototype.equalsEpsilon=function(e,t){return Rectangle.equalsEpsilon(this,e,t)},Rectangle.validate=function(e){},Rectangle.southwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.south,t.height=0,t):new Cartographic(e.west,e.south)},Rectangle.northwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.north,t.height=0,t):new Cartographic(e.west,e.north)},Rectangle.northeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.north,t.height=0,t):new Cartographic(e.east,e.north)},Rectangle.southeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.south,t.height=0,t):new Cartographic(e.east,e.south)},Rectangle.center=function(e,t){var i=e.east,r=e.west;i<r&&(i+=CesiumMath.TWO_PI);var n=CesiumMath.negativePiToPi(.5*(r+i)),a=.5*(e.south+e.north);return defined(t)?(t.longitude=n,t.latitude=a,t.height=0,t):new Cartographic(n,a)},Rectangle.intersection=function(e,t,i){var r=e.east,n=e.west,a=t.east,o=t.west;r<n&&0<a?r+=CesiumMath.TWO_PI:a<o&&0<r&&(a+=CesiumMath.TWO_PI),r<n&&o<0?o+=CesiumMath.TWO_PI:a<o&&n<0&&(n+=CesiumMath.TWO_PI);var s=CesiumMath.negativePiToPi(Math.max(n,o)),l=CesiumMath.negativePiToPi(Math.min(r,a));if(!((e.west<e.east||t.west<t.east)&&l<=s)){var c=Math.max(e.south,t.south),u=Math.min(e.north,t.north);if(!(u<=c))return defined(i)?(i.west=s,i.south=c,i.east=l,i.north=u,i):new Rectangle(s,c,l,u)}},Rectangle.simpleIntersection=function(e,t,i){var r=Math.max(e.west,t.west),n=Math.max(e.south,t.south),a=Math.min(e.east,t.east),o=Math.min(e.north,t.north);if(!(o<=n||a<=r))return defined(i)?(i.west=r,i.south=n,i.east=a,i.north=o,i):new Rectangle(r,n,a,o)},Rectangle.union=function(e,t,i){defined(i)||(i=new Rectangle);var r=e.east,n=e.west,a=t.east,o=t.west;r<n&&0<a?r+=CesiumMath.TWO_PI:a<o&&0<r&&(a+=CesiumMath.TWO_PI),r<n&&o<0?o+=CesiumMath.TWO_PI:a<o&&n<0&&(n+=CesiumMath.TWO_PI);var s=CesiumMath.convertLongitudeRange(Math.min(n,o)),l=CesiumMath.convertLongitudeRange(Math.max(r,a));return i.west=s,i.south=Math.min(e.south,t.south),i.east=l,i.north=Math.max(e.north,t.north),i},Rectangle.expand=function(e,t,i){return defined(i)||(i=new Rectangle),i.west=Math.min(e.west,t.longitude),i.south=Math.min(e.south,t.latitude),i.east=Math.max(e.east,t.longitude),i.north=Math.max(e.north,t.latitude),i},Rectangle.contains=function(e,t){var i=t.longitude,r=t.latitude,n=e.west,a=e.east;return a<n&&(a+=CesiumMath.TWO_PI,i<0&&(i+=CesiumMath.TWO_PI)),(n<i||CesiumMath.equalsEpsilon(i,n,CesiumMath.EPSILON14))&&(i<a||CesiumMath.equalsEpsilon(i,a,CesiumMath.EPSILON14))&&r>=e.south&&r<=e.north};var subsampleLlaScratch=new Cartographic;function BoundingSphere(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.radius=defaultValue(t,0)}Rectangle.subsample=function(e,t,i,r){t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,0),defined(r)||(r=[]);var n=0,a=e.north,o=e.south,s=e.east,l=e.west,c=subsampleLlaScratch;c.height=i,c.longitude=l,c.latitude=a,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=s,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.latitude=o,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=l,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.latitude=a<0?a:0<o?o:0;for(var u=1;u<8;++u)c.longitude=-Math.PI+u*CesiumMath.PI_OVER_TWO,Rectangle.contains(e,c)&&(r[n]=t.cartographicToCartesian(c,r[n]),n++);return 0===c.latitude&&(c.longitude=l,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=s,r[n]=t.cartographicToCartesian(c,r[n]),n++),r.length=n,r},Rectangle.MAX_VALUE=freezeObject$1(new Rectangle(-Math.PI,-CesiumMath.PI_OVER_TWO,Math.PI,CesiumMath.PI_OVER_TWO));var fromPointsXMin=new Cartesian3,fromPointsYMin=new Cartesian3,fromPointsZMin=new Cartesian3,fromPointsXMax=new Cartesian3,fromPointsYMax=new Cartesian3,fromPointsZMax=new Cartesian3,fromPointsCurrentPos=new Cartesian3,fromPointsScratch=new Cartesian3,fromPointsRitterCenter=new Cartesian3,fromPointsMinBoxPt=new Cartesian3,fromPointsMaxBoxPt=new Cartesian3,fromPointsNaiveCenterScratch=new Cartesian3,volumeConstant=4/3*CesiumMath.PI;BoundingSphere.fromPoints=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;var i,r=Cartesian3.clone(e[0],fromPointsCurrentPos),n=Cartesian3.clone(r,fromPointsXMin),a=Cartesian3.clone(r,fromPointsYMin),o=Cartesian3.clone(r,fromPointsZMin),s=Cartesian3.clone(r,fromPointsXMax),l=Cartesian3.clone(r,fromPointsYMax),c=Cartesian3.clone(r,fromPointsZMax),u=e.length;for(i=1;i<u;i++){Cartesian3.clone(e[i],r);var d=r.x,h=r.y,p=r.z;d<n.x&&Cartesian3.clone(r,n),d>s.x&&Cartesian3.clone(r,s),h<a.y&&Cartesian3.clone(r,a),h>l.y&&Cartesian3.clone(r,l),p<o.z&&Cartesian3.clone(r,o),p>c.z&&Cartesian3.clone(r,c)}var m=Cartesian3.magnitudeSquared(Cartesian3.subtract(s,n,fromPointsScratch)),f=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),_=n,y=s,v=m;v<f&&(v=f,_=a,y=l),v<g&&(v=g,_=o,y=c);var C=fromPointsRitterCenter;C.x=.5*(_.x+y.x),C.y=.5*(_.y+y.y),C.z=.5*(_.z+y.z);var S=Cartesian3.magnitudeSquared(Cartesian3.subtract(y,C,fromPointsScratch)),T=Math.sqrt(S),x=fromPointsMinBoxPt;x.x=n.x,x.y=a.y,x.z=o.z;var b=fromPointsMaxBoxPt;b.x=s.x,b.y=l.y,b.z=c.z;var E=Cartesian3.midpoint(x,b,fromPointsNaiveCenterScratch),P=0;for(i=0;i<u;i++){Cartesian3.clone(e[i],r);var A=Cartesian3.magnitude(Cartesian3.subtract(r,E,fromPointsScratch));P<A&&(P=A);var w=Cartesian3.magnitudeSquared(Cartesian3.subtract(r,C,fromPointsScratch));if(S<w){var D=Math.sqrt(w);S=(T=.5*(T+D))*T;var M=D-T;C.x=(T*C.x+M*r.x)/D,C.y=(T*C.y+M*r.y)/D,C.z=(T*C.z+M*r.z)/D}}return T<P?(Cartesian3.clone(C,t.center),t.radius=T):(Cartesian3.clone(E,t.center),t.radius=P),t};var defaultProjection=new GeographicProjection,fromRectangle2DLowerLeft=new Cartesian3,fromRectangle2DUpperRight=new Cartesian3,fromRectangle2DSouthwest=new Cartographic,fromRectangle2DNortheast=new Cartographic;BoundingSphere.fromRectangle2D=function(e,t,i){return BoundingSphere.fromRectangleWithHeights2D(e,t,0,0,i)},BoundingSphere.fromRectangleWithHeights2D=function(e,t,i,r,n){if(defined(n)||(n=new BoundingSphere),!defined(e))return n.center=Cartesian3.clone(Cartesian3.ZERO,n.center),n.radius=0,n;t=defaultValue(t,defaultProjection),Rectangle.southwest(e,fromRectangle2DSouthwest),fromRectangle2DSouthwest.height=i,Rectangle.northeast(e,fromRectangle2DNortheast),fromRectangle2DNortheast.height=r;var a=t.project(fromRectangle2DSouthwest,fromRectangle2DLowerLeft),o=t.project(fromRectangle2DNortheast,fromRectangle2DUpperRight),s=o.x-a.x,l=o.y-a.y,c=o.z-a.z;n.radius=.5*Math.sqrt(s*s+l*l+c*c);var u=n.center;return u.x=a.x+.5*s,u.y=a.y+.5*l,u.z=a.z+.5*c,n};var fromRectangle3DScratch=[];BoundingSphere.fromRectangle3D=function(e,t,i,r){if(t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,0),defined(r)||(r=new BoundingSphere),!defined(e))return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;var n=Rectangle.subsample(e,t,i,fromRectangle3DScratch);return BoundingSphere.fromPoints(n,r)},BoundingSphere.fromVertices=function(e,t,i,r){if(defined(r)||(r=new BoundingSphere),!defined(e)||0===e.length)return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;t=defaultValue(t,Cartesian3.ZERO),i=defaultValue(i,3);var n=fromPointsCurrentPos;n.x=e[0]+t.x,n.y=e[1]+t.y,n.z=e[2]+t.z;var a,o=Cartesian3.clone(n,fromPointsXMin),s=Cartesian3.clone(n,fromPointsYMin),l=Cartesian3.clone(n,fromPointsZMin),c=Cartesian3.clone(n,fromPointsXMax),u=Cartesian3.clone(n,fromPointsYMax),d=Cartesian3.clone(n,fromPointsZMax),h=e.length;for(a=0;a<h;a+=i){var p=e[a]+t.x,m=e[a+1]+t.y,f=e[a+2]+t.z;n.x=p,n.y=m,n.z=f,p<o.x&&Cartesian3.clone(n,o),p>c.x&&Cartesian3.clone(n,c),m<s.y&&Cartesian3.clone(n,s),m>u.y&&Cartesian3.clone(n,u),f<l.z&&Cartesian3.clone(n,l),f>d.z&&Cartesian3.clone(n,d)}var g=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(u,s,fromPointsScratch)),y=Cartesian3.magnitudeSquared(Cartesian3.subtract(d,l,fromPointsScratch)),v=o,C=c,S=g;S<_&&(S=_,v=s,C=u),S<y&&(S=y,v=l,C=d);var T=fromPointsRitterCenter;T.x=.5*(v.x+C.x),T.y=.5*(v.y+C.y),T.z=.5*(v.z+C.z);var x=Cartesian3.magnitudeSquared(Cartesian3.subtract(C,T,fromPointsScratch)),b=Math.sqrt(x),E=fromPointsMinBoxPt;E.x=o.x,E.y=s.y,E.z=l.z;var P=fromPointsMaxBoxPt;P.x=c.x,P.y=u.y,P.z=d.z;var A=Cartesian3.midpoint(E,P,fromPointsNaiveCenterScratch),w=0;for(a=0;a<h;a+=i){n.x=e[a]+t.x,n.y=e[a+1]+t.y,n.z=e[a+2]+t.z;var D=Cartesian3.magnitude(Cartesian3.subtract(n,A,fromPointsScratch));w<D&&(w=D);var M=Cartesian3.magnitudeSquared(Cartesian3.subtract(n,T,fromPointsScratch));if(x<M){var I=Math.sqrt(M);x=(b=.5*(b+I))*b;var R=I-b;T.x=(b*T.x+R*n.x)/I,T.y=(b*T.y+R*n.y)/I,T.z=(b*T.z+R*n.z)/I}}return b<w?(Cartesian3.clone(T,r.center),r.radius=b):(Cartesian3.clone(A,r.center),r.radius=w),r},BoundingSphere.fromEncodedCartesianVertices=function(e,t,i){if(defined(i)||(i=new BoundingSphere),!defined(e)||!defined(t)||e.length!==t.length||0===e.length)return i.center=Cartesian3.clone(Cartesian3.ZERO,i.center),i.radius=0,i;var r=fromPointsCurrentPos;r.x=e[0]+t[0],r.y=e[1]+t[1],r.z=e[2]+t[2];var n,a=Cartesian3.clone(r,fromPointsXMin),o=Cartesian3.clone(r,fromPointsYMin),s=Cartesian3.clone(r,fromPointsZMin),l=Cartesian3.clone(r,fromPointsXMax),c=Cartesian3.clone(r,fromPointsYMax),u=Cartesian3.clone(r,fromPointsZMax),d=e.length;for(n=0;n<d;n+=3){var h=e[n]+t[n],p=e[n+1]+t[n+1],m=e[n+2]+t[n+2];r.x=h,r.y=p,r.z=m,h<a.x&&Cartesian3.clone(r,a),h>l.x&&Cartesian3.clone(r,l),p<o.y&&Cartesian3.clone(r,o),p>c.y&&Cartesian3.clone(r,c),m<s.z&&Cartesian3.clone(r,s),m>u.z&&Cartesian3.clone(r,u)}var f=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(u,s,fromPointsScratch)),y=a,v=l,C=f;C<g&&(C=g,y=o,v=c),C<_&&(C=_,y=s,v=u);var S=fromPointsRitterCenter;S.x=.5*(y.x+v.x),S.y=.5*(y.y+v.y),S.z=.5*(y.z+v.z);var T=Cartesian3.magnitudeSquared(Cartesian3.subtract(v,S,fromPointsScratch)),x=Math.sqrt(T),b=fromPointsMinBoxPt;b.x=a.x,b.y=o.y,b.z=s.z;var E=fromPointsMaxBoxPt;E.x=l.x,E.y=c.y,E.z=u.z;var P=Cartesian3.midpoint(b,E,fromPointsNaiveCenterScratch),A=0;for(n=0;n<d;n+=3){r.x=e[n]+t[n],r.y=e[n+1]+t[n+1],r.z=e[n+2]+t[n+2];var w=Cartesian3.magnitude(Cartesian3.subtract(r,P,fromPointsScratch));A<w&&(A=w);var D=Cartesian3.magnitudeSquared(Cartesian3.subtract(r,S,fromPointsScratch));if(T<D){var M=Math.sqrt(D);T=(x=.5*(x+M))*x;var I=M-x;S.x=(x*S.x+I*r.x)/M,S.y=(x*S.y+I*r.y)/M,S.z=(x*S.z+I*r.z)/M}}return x<A?(Cartesian3.clone(S,i.center),i.radius=x):(Cartesian3.clone(P,i.center),i.radius=A),i},BoundingSphere.fromCornerPoints=function(e,t,i){defined(i)||(i=new BoundingSphere);var r=Cartesian3.midpoint(e,t,i.center);return i.radius=Cartesian3.distance(r,t),i},BoundingSphere.fromEllipsoid=function(e,t){return defined(t)||(t=new BoundingSphere),Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=e.maximumRadius,t};var fromBoundingSpheresScratch=new Cartesian3;BoundingSphere.fromBoundingSpheres=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;var i=e.length;if(1===i)return BoundingSphere.clone(e[0],t);if(2===i)return BoundingSphere.union(e[0],e[1],t);var r,n=[];for(r=0;r<i;r++)n.push(e[r].center);var a=(t=BoundingSphere.fromPoints(n,t)).center,o=t.radius;for(r=0;r<i;r++){var s=e[r];o=Math.max(o,Cartesian3.distance(a,s.center,fromBoundingSpheresScratch)+s.radius)}return t.radius=o,t};var fromOrientedBoundingBoxScratchU=new Cartesian3,fromOrientedBoundingBoxScratchV=new Cartesian3,fromOrientedBoundingBoxScratchW=new Cartesian3;BoundingSphere.fromOrientedBoundingBox=function(e,t){defined(t)||(t=new BoundingSphere);var i=e.halfAxes,r=Matrix3.getColumn(i,0,fromOrientedBoundingBoxScratchU),n=Matrix3.getColumn(i,1,fromOrientedBoundingBoxScratchV),a=Matrix3.getColumn(i,2,fromOrientedBoundingBoxScratchW);return Cartesian3.add(r,n,r),Cartesian3.add(r,a,r),t.center=Cartesian3.clone(e.center,t.center),t.radius=Cartesian3.magnitude(r),t},BoundingSphere.clone=function(e,t){if(defined(e))return defined(t)?(t.center=Cartesian3.clone(e.center,t.center),t.radius=e.radius,t):new BoundingSphere(e.center,e.radius)},BoundingSphere.packedLength=4,BoundingSphere.pack=function(e,t,i){i=defaultValue(i,0);var r=e.center;return t[i++]=r.x,t[i++]=r.y,t[i++]=r.z,t[i]=e.radius,t},BoundingSphere.unpack=function(e,t,i){t=defaultValue(t,0),defined(i)||(i=new BoundingSphere);var r=i.center;return r.x=e[t++],r.y=e[t++],r.z=e[t++],i.radius=e[t],i};var unionScratch=new Cartesian3,unionScratchCenter=new Cartesian3;BoundingSphere.union=function(e,t,i){defined(i)||(i=new BoundingSphere);var r=e.center,n=e.radius,a=t.center,o=t.radius,s=Cartesian3.subtract(a,r,unionScratch),l=Cartesian3.magnitude(s);if(l+o<=n)return e.clone(i),i;if(l+n<=o)return t.clone(i),i;var c=.5*(n+l+o),u=Cartesian3.multiplyByScalar(s,(c-n)/l,unionScratchCenter);return Cartesian3.add(u,r,u),Cartesian3.clone(u,i.center),i.radius=c,i};var expandScratch=new Cartesian3;BoundingSphere.expand=function(e,t,i){i=BoundingSphere.clone(e,i);var r=Cartesian3.magnitude(Cartesian3.subtract(t,i.center,expandScratch));return r>i.radius&&(i.radius=r),i},BoundingSphere.intersectPlane=function(e,t){var i=e.center,r=e.radius,n=t.normal,a=Cartesian3.dot(n,i)+t.distance;return a<-r?Intersect$1.OUTSIDE:a<r?Intersect$1.INTERSECTING:Intersect$1.INSIDE},BoundingSphere.transform=function(e,t,i){return defined(i)||(i=new BoundingSphere),i.center=Matrix4.multiplyByPoint(t,e.center,i.center),i.radius=Matrix4.getMaximumScale(t)*e.radius,i};var distanceSquaredToScratch=new Cartesian3;BoundingSphere.distanceSquaredTo=function(e,t){var i=Cartesian3.subtract(e.center,t,distanceSquaredToScratch);return Cartesian3.magnitudeSquared(i)-e.radius*e.radius},BoundingSphere.transformWithoutScale=function(e,t,i){return defined(i)||(i=new BoundingSphere),i.center=Matrix4.multiplyByPoint(t,e.center,i.center),i.radius=e.radius,i};var scratchCartesian3=new Cartesian3;BoundingSphere.computePlaneDistances=function(e,t,i,r){defined(r)||(r=new Interval);var n=Cartesian3.subtract(e.center,t,scratchCartesian3),a=Cartesian3.dot(i,n);return r.start=a-e.radius,r.stop=a+e.radius,r};for(var projectTo2DNormalScratch=new Cartesian3,projectTo2DEastScratch=new Cartesian3,projectTo2DNorthScratch=new Cartesian3,projectTo2DWestScratch=new Cartesian3,projectTo2DSouthScratch=new Cartesian3,projectTo2DCartographicScratch=new Cartographic,projectTo2DPositionsScratch=new Array(8),n=0;n<8;++n)projectTo2DPositionsScratch[n]=new Cartesian3;var projectTo2DProjection=new GeographicProjection;function URI(e){if(e instanceof URI)this.scheme=e.scheme,this.authority=e.authority,this.path=e.path,this.query=e.query,this.fragment=e.fragment;else if(e){var t=parseRegex.exec(e);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}BoundingSphere.projectTo2D=function(e,t,i){var r=(t=defaultValue(t,projectTo2DProjection)).ellipsoid,n=e.center,a=e.radius,o=r.geodeticSurfaceNormal(n,projectTo2DNormalScratch),s=Cartesian3.cross(Cartesian3.UNIT_Z,o,projectTo2DEastScratch);Cartesian3.normalize(s,s);var l=Cartesian3.cross(o,s,projectTo2DNorthScratch);Cartesian3.normalize(l,l),Cartesian3.multiplyByScalar(o,a,o),Cartesian3.multiplyByScalar(l,a,l),Cartesian3.multiplyByScalar(s,a,s);var c=Cartesian3.negate(l,projectTo2DSouthScratch),u=Cartesian3.negate(s,projectTo2DWestScratch),d=projectTo2DPositionsScratch,h=d[0];Cartesian3.add(o,l,h),Cartesian3.add(h,s,h),h=d[1],Cartesian3.add(o,l,h),Cartesian3.add(h,u,h),h=d[2],Cartesian3.add(o,c,h),Cartesian3.add(h,u,h),h=d[3],Cartesian3.add(o,c,h),Cartesian3.add(h,s,h),Cartesian3.negate(o,o),h=d[4],Cartesian3.add(o,l,h),Cartesian3.add(h,s,h),h=d[5],Cartesian3.add(o,l,h),Cartesian3.add(h,u,h),h=d[6],Cartesian3.add(o,c,h),Cartesian3.add(h,u,h),h=d[7],Cartesian3.add(o,c,h),Cartesian3.add(h,s,h);for(var p=d.length,m=0;m<p;++m){var f=d[m];Cartesian3.add(n,f,f);var g=r.cartesianToCartographic(f,projectTo2DCartographicScratch);t.project(g,f)}var _=(n=(i=BoundingSphere.fromPoints(d,i)).center).x,y=n.y,v=n.z;return n.x=v,n.y=_,n.z=y,i},BoundingSphere.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},BoundingSphere.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&e.radius===t.radius},BoundingSphere.prototype.intersectPlane=function(e){return BoundingSphere.intersectPlane(this,e)},BoundingSphere.prototype.distanceSquaredTo=function(e){return BoundingSphere.distanceSquaredTo(this,e)},BoundingSphere.prototype.computePlaneDistances=function(e,t,i){return BoundingSphere.computePlaneDistances(this,e,t,i)},BoundingSphere.prototype.isOccluded=function(e){return BoundingSphere.isOccluded(this,e)},BoundingSphere.prototype.equals=function(e){return BoundingSphere.equals(this,e)},BoundingSphere.prototype.clone=function(e){return BoundingSphere.clone(this,e)},BoundingSphere.prototype.volume=function(){var e=this.radius;return volumeConstant*e*e*e},URI.prototype.scheme=null,URI.prototype.authority=null,URI.prototype.path="",URI.prototype.query=null,URI.prototype.fragment=null;var parseRegex=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");URI.prototype.getScheme=function(){return this.scheme},URI.prototype.getAuthority=function(){return this.authority},URI.prototype.getPath=function(){return this.path},URI.prototype.getQuery=function(){return this.query},URI.prototype.getFragment=function(){return this.fragment},URI.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},URI.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},URI.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},URI.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(authorityRegex,replaceAuthority).replace(caseRegex,replaceCase)),this.path&&(this.path=this.path.replace(caseRegex,replaceCase)),this.query&&(this.query=this.query.replace(caseRegex,replaceCase)),this.fragment&&(this.fragment=this.fragment.replace(caseRegex,replaceCase))};var caseRegex=/%[0-9a-z]{2}/gi,percentRegex=/[a-zA-Z0-9\-\._~]/,authorityRegex=/(.*@)?([^@:]*)(:.*)?/,reduceArray,slice,undef;function replaceCase(e){var t=unescape(e);return percentRegex.test(t)?t:e.toUpperCase()}function replaceAuthority(e,t,i,r){return(t||"")+i.toLowerCase()+(r||"")}function getAbsoluteUri(e,t){var i;return"undefined"!=typeof document&&(i=document),getAbsoluteUri._implementation(e,t,i)}function when(e,t,i,r){return resolve(e).then(t,i,r)}function resolve(e){var t;return e instanceof Promise$1?e:isPromise(e)?(t=defer(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),t.promise):fulfilled(e)}function reject(e){return when(e,rejected)}function Promise$1(e){this.then=e}function fulfilled(t){return new Promise$1(function(e){try{return resolve(e?e(t):t)}catch(e){return rejected(e)}})}function rejected(i){return new Promise$1(function(e,t){try{return t?resolve(t(i)):rejected(i)}catch(e){return rejected(e)}})}function defer(){var e,o,s,r,t,i;return e=new Promise$1(n),o=[],s=[],r=function(t,i,r){var n,a;return n=defer(),a="function"==typeof r?function(e){try{n.progress(r(e))}catch(e){n.progress(e)}}:function(e){n.progress(e)},o.push(function(e){e.then(t,i).then(n.resolve,n.reject,a)}),s.push(a),n.promise},t=function(e){return processQueue(s,e),e},i=function(e){return e=resolve(e),r=e.then,i=resolve,t=noop,processQueue(o,e),s=o=undef,e},{then:n,resolve:a,reject:l,progress:c,promise:e,resolver:{resolve:a,reject:l,progress:c}};function n(e,t,i){return r(e,t,i)}function a(e){return i(e)}function l(e){return i(rejected(e))}function c(e){return t(e)}}function isPromise(e){return e&&"function"==typeof e.then}function some(e,p,m,f,g){return checkCallbacks(2,arguments),when(e,function(e){var t,i,r,n,a,o,s,l,c,u;if(c=e.length>>>0,t=Math.max(0,Math.min(p,c)),r=[],i=c-t+1,n=[],a=defer(),t)for(l=a.progress,s=function(e){n.push(e),--i||(o=s=noop,a.reject(n))},o=function(e){r.push(e),--t||(o=s=noop,a.resolve(r))},u=0;u<c;++u)u in e&&when(e[u],h,d,l);else a.resolve(r);return a.then(m,f,g);function d(e){s(e)}function h(e){o(e)}})}function any(e,t,i,r){return some(e,1,function(e){return t?t(e[0]):e[0]},i,r)}function all(e,t,i,r){return checkCallbacks(1,arguments),map(e,identity).then(t,i,r)}function join(){return map(arguments,identity)}function map(e,s){return when(e,function(e){var i,t,r,n,a,o;if(r=t=e.length>>>0,i=[],o=defer(),r)for(n=function(e,t){when(e,s).then(function(e){i[t]=e,--r||o.resolve(i)},o.reject)},a=0;a<t;a++)a in e?n(e[a],a):--r;else o.resolve(i);return o.promise})}function reduce(e,a){var t=slice.call(arguments,1);return when(e,function(e){var n;return n=e.length,t[0]=function(e,i,r){return when(e,function(t){return when(i,function(e){return a(t,e,r,n)})})},reduceArray.apply(e,t)})}function chain(e,t,i){var r=2<arguments.length;return when(e,function(e){return e=r?i:e,t.resolve(e),e},function(e){return t.reject(e),rejected(e)},t.progress)}function processQueue(e,t){for(var i,r=0;i=e[r++];)i(t)}function checkCallbacks(e,t){for(var i,r=t.length;e<r;)if(null!=(i=t[--r])&&"function"!=typeof i)throw new Error("arg "+r+" must be a function")}function noop(){}function identity(e){return e}function appendForwardSlash(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}function clone(e,t){if(null===e||"object"!=typeof e)return e;t=defaultValue(t,!1);var i=new e.constructor;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];t&&(n=clone(n,t)),i[r]=n}return i}function combine(e,t,i){i=defaultValue(i,!1);var r,n,a,o={},s=defined(e),l=defined(t);if(s)for(r in e)e.hasOwnProperty(r)&&(n=e[r],l&&i&&"object"==typeof n&&t.hasOwnProperty(r)?(a=t[r],o[r]="object"==typeof a?combine(n,a,i):n):o[r]=n);if(l)for(r in t)t.hasOwnProperty(r)&&!o.hasOwnProperty(r)&&(a=t[r],o[r]=a);return o}function getBaseUri(e,t){var i="",r=e.lastIndexOf("/");return-1!==r&&(i=e.substring(0,r+1)),t&&(defined((e=new URI(e)).query)&&(i+="?"+e.query),defined(e.fragment)&&(i+="#"+e.fragment)),i}function getExtensionFromUri(e){var t=new URI(e);t.normalize();var i=t.path,r=i.lastIndexOf("/");return-1!==r&&(i=i.substr(r+1)),i=-1===(r=i.lastIndexOf("."))?"":i.substr(r+1)}URI.prototype.resolve=function(e){var t=new URI;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=e.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=e.authority,""==this.path?(t.path=e.path,t.query=this.query||e.query):("/"==this.path.charAt(0)?t.path=this.path:e.authority&&""==e.path?t.path="/"+this.path:t.path=e.path.substring(0,e.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments(),t.query=this.query))),t.fragment=this.fragment,t},URI.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),i=[],r=""==t[0];r&&t.shift();for(""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?i.pop():"."!=e&&i.push(e);"."!=e&&".."!=e||i.push(""),r&&i.unshift(""),this.path=i.join("/")},URI.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},getAbsoluteUri._implementation=function(e,t,i){if(!defined(t)){if(void 0===i)return e;t=defaultValue(i.baseURI,i.location.href)}var r=new URI(t);return new URI(e).resolve(r).toString()},when.defer=defer,when.resolve=resolve,when.reject=reject,when.join=join,when.all=all,when.map=map,when.reduce=reduce,when.any=any,when.some=some,when.chain=chain,when.isPromise=isPromise,Promise$1.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(undef,e)},yield:function(e){return this.then(function(){return e})},spread:function(t){return this.then(function(e){return all(e,function(e){return t.apply(undef,e)})})}},slice=[].slice,reduceArray=[].reduce||function(e){var t,i,r,n,a;if(a=0,n=(t=Object(this)).length>>>0,(i=arguments).length<=1)for(;;){if(a in t){r=t[a++];break}if(++a>=n)throw new TypeError}else r=i[1];for(;a<n;++a)a in t&&(r=e(r,t[a],a,t));return r};var blobUriRegex=/^blob:/i,a;function isBlobUri(e){return blobUriRegex.test(e)}function isCrossOriginUrl(e){defined(a)||(a=document.createElement("a")),a.href=window.location.href;var t=a.host,i=a.protocol;return a.href=e,a.href=a.href,i!==a.protocol||t!==a.host}var dataUriRegex=/^data:/i;function isDataUri(e){return dataUriRegex.test(e)}function loadAndExecuteScript(e){var t=when.defer(),i=document.createElement("script");i.async=!0,i.src=e;var r=document.getElementsByTagName("head")[0];return i.onload=function(){i.onload=void 0,r.removeChild(i),t.resolve()},i.onerror=function(e){t.reject(e)},r.appendChild(i),t.promise}var isArray=Array.isArray;defined(isArray)||(isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)});var isArray$1=isArray;function objectToQuery(e){var t="";for(var i in e)if(e.hasOwnProperty(i)){var r=e[i],n=encodeURIComponent(i)+"=";if(isArray$1(r))for(var a=0,o=r.length;a<o;++a)t+=n+encodeURIComponent(r[a])+"&";else t+=n+encodeURIComponent(r)+"&"}return t=t.slice(0,-1)}function queryToObject(e){var t={};if(""===e)return t;for(var i=e.replace(/\+/g,"%20").split(/[&;]/),r=0,n=i.length;r<n;++r){var a=i[r].split("="),o=decodeURIComponent(a[0]),s=a[1];s=defined(s)?decodeURIComponent(s):"";var l=t[o];"string"==typeof l?t[o]=[l,s]:isArray$1(l)?l.push(s):t[o]=s}return t}var RequestState={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5},RequestState$1=freezeObject$1(RequestState),RequestType={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3},RequestType$1=freezeObject$1(RequestType);function Request(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.throttleByServer,!1),i=defaultValue(e.throttle,!1);this.url=e.url,this.requestFunction=e.requestFunction,this.cancelFunction=e.cancelFunction,this.priorityFunction=e.priorityFunction,this.priority=defaultValue(e.priority,0),this.throttle=i,this.throttleByServer=t,this.type=defaultValue(e.type,RequestType$1.OTHER),this.serverKey=void 0,this.state=RequestState$1.UNISSUED,this.deferred=void 0,this.cancelled=!1}function parseResponseHeaders(e){var t={};if(!e)return t;for(var i=e.split("\r\n"),r=0;r<i.length;++r){var n=i[r],a=n.indexOf(": ");if(0<a){var o=n.substring(0,a),s=n.substring(a+2);t[o]=s}}return t}function RequestErrorEvent(e,t,i){this.statusCode=e,this.response=t,this.responseHeaders=i,"string"==typeof this.responseHeaders&&(this.responseHeaders=parseResponseHeaders(this.responseHeaders))}function Event(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function compareNumber(e,t){return t-e}function Heap(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function swap(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function sortRequests(e,t){return e.priority-t.priority}Request.prototype.cancel=function(){this.cancelled=!0},Request.prototype.clone=function(e){return defined(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new Request(this)},RequestErrorEvent.prototype.toString=function(){var e="Request has failed.";return defined(this.statusCode)&&(e+=" Status Code: "+this.statusCode),e},defineProperties$1(Event.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),Event.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var i=this;return function(){i.removeEventListener(e,t)}},Event.prototype.removeEventListener=function(e,t){for(var i=this._listeners,r=this._scopes,n=-1,a=0;a<i.length;a++)if(i[a]===e&&r[a]===t){n=a;break}return-1!==n&&(this._insideRaiseEvent?(this._toRemove.push(n),i[n]=void 0,r[n]=void 0):(i.splice(n,1),r.splice(n,1)),!0)},Event.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var t=this._listeners,i=this._scopes,r=t.length;for(e=0;e<r;e++){defined(t[e])&&t[e].apply(i[e],arguments)}var n=this._toRemove;if(0<(r=n.length)){for(n.sort(compareNumber),e=0;e<r;e++){var a=n[e];t.splice(a,1),i.splice(a,1)}n.length=0}this._insideRaiseEvent=!1},defineProperties$1(Heap.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&0<e&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),Heap.prototype.reserve=function(e){e=defaultValue(e,this._length),this._array.length=e},Heap.prototype.heapify=function(e){e=defaultValue(e,0);for(var t=this._length,i=this._comparator,r=this._array,n=-1,a=!0;a;){var o=2*(e+1),s=o-1;n=s<t&&i(r[s],r[e])<0?s:e,o<t&&i(r[o],r[n])<0&&(n=o),n!==e?(swap(r,n,e),e=n):a=!1}},Heap.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);0<=t;--t)this.heapify(t)},Heap.prototype.insert=function(e){var t,i=this._array,r=this._comparator,n=this._maximumLength,a=this._length++;for(a<i.length?i[a]=e:i.push(e);0!==a;){var o=Math.floor((a-1)/2);if(!(r(i[a],i[o])<0))break;swap(i,a,o),a=o}return defined(n)&&this._length>n&&(t=i[n],this._length=n),t},Heap.prototype.pop=function(e){if(e=defaultValue(e,0),0!==this._length){var t=this._array,i=t[e];return swap(t,e,--this._length),this.heapify(e),i}};var statistics={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},priorityHeapLength=20,requestHeap=new Heap({comparator:sortRequests});requestHeap.maximumLength=priorityHeapLength,requestHeap.reserve(priorityHeapLength);var activeRequests=[],numberOfActiveRequestsByServer={},pageUri="undefined"!=typeof document?new URI(document.location.href):new URI,requestCompletedEvent=new Event;function RequestScheduler(){}function updatePriority(e){defined(e.priorityFunction)&&(e.priority=e.priorityFunction())}function serverHasOpenSlots(e){var t=defaultValue(RequestScheduler.requestsByServer[e],RequestScheduler.maximumRequestsPerServer);return numberOfActiveRequestsByServer[e]<t}function issueRequest(e){return e.state===RequestState$1.UNISSUED&&(e.state=RequestState$1.ISSUED,e.deferred=when.defer()),e.deferred.promise}function getRequestReceivedFunction(t){return function(e){t.state!==RequestState$1.CANCELLED&&(--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[t.serverKey],requestCompletedEvent.raiseEvent(),t.state=RequestState$1.RECEIVED,t.deferred.resolve(e))}}function getRequestFailedFunction(t){return function(e){t.state!==RequestState$1.CANCELLED&&(++statistics.numberOfFailedRequests,--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[t.serverKey],requestCompletedEvent.raiseEvent(e),t.state=RequestState$1.FAILED,t.deferred.reject(e))}}function startRequest(e){var t=issueRequest(e);return e.state=RequestState$1.ACTIVE,activeRequests.push(e),++statistics.numberOfActiveRequests,++statistics.numberOfActiveRequestsEver,++numberOfActiveRequestsByServer[e.serverKey],e.requestFunction().then(getRequestReceivedFunction(e)).otherwise(getRequestFailedFunction(e)),t}function cancelRequest(e){var t=e.state===RequestState$1.ACTIVE;e.state=RequestState$1.CANCELLED,++statistics.numberOfCancelledRequests,e.deferred.reject(),t&&(--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],++statistics.numberOfCancelledActiveRequests),defined(e.cancelFunction)&&e.cancelFunction()}function updateStatistics(){RequestScheduler.debugShowStatistics&&(0===statistics.numberOfActiveRequests&&0<statistics.lastNumberOfActiveRequests&&(0<statistics.numberOfAttemptedRequests&&(console.log("Number of attempted requests: "+statistics.numberOfAttemptedRequests),statistics.numberOfAttemptedRequests=0),0<statistics.numberOfCancelledRequests&&(console.log("Number of cancelled requests: "+statistics.numberOfCancelledRequests),statistics.numberOfCancelledRequests=0),0<statistics.numberOfCancelledActiveRequests&&(console.log("Number of cancelled active requests: "+statistics.numberOfCancelledActiveRequests),statistics.numberOfCancelledActiveRequests=0),0<statistics.numberOfFailedRequests&&(console.log("Number of failed requests: "+statistics.numberOfFailedRequests),statistics.numberOfFailedRequests=0)),statistics.lastNumberOfActiveRequests=statistics.numberOfActiveRequests)}RequestScheduler.maximumRequests=50,RequestScheduler.maximumRequestsPerServer=6,RequestScheduler.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},RequestScheduler.throttleRequests=!0,RequestScheduler.debugShowStatistics=!1,RequestScheduler.requestCompletedEvent=requestCompletedEvent,defineProperties$1(RequestScheduler,{statistics:{get:function(){return statistics}},priorityHeapLength:{get:function(){return priorityHeapLength},set:function(e){if(e<priorityHeapLength)for(;requestHeap.length>e;){cancelRequest(requestHeap.pop())}priorityHeapLength=e,requestHeap.maximumLength=e,requestHeap.reserve(e)}}}),RequestScheduler.update=function(){var e,t,i=0,r=activeRequests.length;for(e=0;e<r;++e)(t=activeRequests[e]).cancelled&&cancelRequest(t),t.state===RequestState$1.ACTIVE?0<i&&(activeRequests[e-i]=t):++i;activeRequests.length-=i;var n=requestHeap.internalArray,a=requestHeap.length;for(e=0;e<a;++e)updatePriority(n[e]);requestHeap.resort();for(var o=Math.max(RequestScheduler.maximumRequests-activeRequests.length,0),s=0;s<o&&0<requestHeap.length;)(t=requestHeap.pop()).cancelled?cancelRequest(t):!t.throttleByServer||serverHasOpenSlots(t.serverKey)?(startRequest(t),++s):cancelRequest(t);updateStatistics()},RequestScheduler.getServerKey=function(e){var t=new URI(e).resolve(pageUri);t.normalize();var i=t.authority;return/:/.test(i)||(i=i+":"+("https"===t.scheme?"443":"80")),defined(numberOfActiveRequestsByServer[i])||(numberOfActiveRequestsByServer[i]=0),i},RequestScheduler.request=function(e){if(isDataUri(e.url)||isBlobUri(e.url))return requestCompletedEvent.raiseEvent(),e.state=RequestState$1.RECEIVED,e.requestFunction();if(++statistics.numberOfAttemptedRequests,defined(e.serverKey)||(e.serverKey=RequestScheduler.getServerKey(e.url)),!e.throttleByServer||serverHasOpenSlots(e.serverKey)){if(!RequestScheduler.throttleRequests||!e.throttle)return startRequest(e);if(!(activeRequests.length>=RequestScheduler.maximumRequests)){updatePriority(e);var t=requestHeap.insert(e);if(defined(t)){if(t===e)return;cancelRequest(t)}return issueRequest(e)}}},RequestScheduler.clearForSpecs=function(){for(;0<requestHeap.length;){cancelRequest(requestHeap.pop())}for(var e=activeRequests.length,t=0;t<e;++t)cancelRequest(activeRequests[t]);activeRequests.length=0,numberOfActiveRequestsByServer={},statistics.numberOfAttemptedRequests=0,statistics.numberOfActiveRequests=0,statistics.numberOfCancelledRequests=0,statistics.numberOfCancelledActiveRequests=0,statistics.numberOfFailedRequests=0,statistics.numberOfActiveRequestsEver=0,statistics.lastNumberOfActiveRequests=0},RequestScheduler.numberOfActiveRequestsByServer=function(e){return numberOfActiveRequestsByServer[e]},RequestScheduler.requestHeap=requestHeap;var TrustedServers={},_servers={};function getAuthority(e){var t=new URI(e);t.normalize();var i=t.getAuthority();if(defined(i)){if(-1!==i.indexOf("@"))i=i.split("@")[1];if(-1===i.indexOf(":")){var r=t.getScheme();if(defined(r)||(r=(r=window.location.protocol).substring(0,r.length-1)),"http"===r)i+=":80";else{if("https"!==r)return;i+=":443"}}return i}}TrustedServers.add=function(e,t){var i=e.toLowerCase()+":"+t;defined(_servers[i])||(_servers[i]=!0)},TrustedServers.remove=function(e,t){var i=e.toLowerCase()+":"+t;defined(_servers[i])&&delete _servers[i]},TrustedServers.contains=function(e){var t=getAuthority(e);return!(!defined(t)||!defined(_servers[t]))},TrustedServers.clear=function(){_servers={}};var xhrBlobSupported=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),(e.responseType="blob")===e.responseType}catch(e){return!1}}(),supportsImageBitmapOptionsPromise;function parseQuery(e,t,i,r){var n,a=e.query;if(!defined(a)||0===a.length)return{};if(-1===a.indexOf("=")){var o={};o[a]=void 0,n=o}else n=queryToObject(a);t._queryParameters=i?combineQueryParameters(n,t._queryParameters,r):n,e.query=void 0}function stringifyQuery(e,t){var i=t._queryParameters,r=Object.keys(i);1!==r.length||defined(i[r[0]])?e.query=objectToQuery(i):e.query=r[0]}function defaultClone(e,t){return defined(e)?defined(e.clone)?e.clone():clone(e):t}function checkAndResetRequest(e){if(e.state===RequestState$1.ISSUED||e.state===RequestState$1.ACTIVE)throw new RuntimeError("The Resource is already being fetched.");e.state=RequestState$1.UNISSUED,e.deferred=void 0}function combineQueryParameters(e,t,i){if(!i)return combine(e,t);var r=clone(e,!0);for(var n in t)if(t.hasOwnProperty(n)){var a=r[n],o=t[n];defined(a)?(Array.isArray(a)||(a=r[n]=[a]),r[n]=a.concat(o)):r[n]=Array.isArray(o)?o.slice():o}return r}function Resource(e){"string"==typeof(e=defaultValue(e,defaultValue.EMPTY_OBJECT))&&(e={url:e}),this._url=void 0,this._templateValues=defaultClone(e.templateValues,{}),this._queryParameters=defaultClone(e.queryParameters,{}),this.headers=defaultClone(e.headers,{}),this.request=defaultValue(e.request,new Request),this.proxy=e.proxy,this.retryCallback=e.retryCallback,this.retryAttempts=defaultValue(e.retryAttempts,0),this._retryCount=0;var t=new URI(e.url);parseQuery(t,this,!0,!0),t.fragment=void 0,this._url=t.toString()}function fetchImage(e){var r=e.resource,n=e.flipY,a=e.preferImageBitmap,i=r.request;i.url=r.url,i.requestFunction=function(){var e=r.url,t=!1;r.isDataUri||r.isBlobUri||(t=r.isCrossOriginUrl);var i=when.defer();return Resource._Implementations.createImage(e,t,i,n,a),i.promise};var t=RequestScheduler.request(i);if(defined(t))return t.otherwise(function(t){return i.state!==RequestState$1.FAILED?when.reject(t):r.retryOnError(t).then(function(e){return e?(i.state=RequestState$1.UNISSUED,i.deferred=void 0,fetchImage({resource:r,flipY:n,preferImageBitmap:a})):when.reject(t)})})}function fetchJsonp(i,r,n){var e={};e[r]=n,i.setQueryParameters(e);var a=i.request;a.url=i.url,a.requestFunction=function(){var t=when.defer();return window[n]=function(e){t.resolve(e);try{delete window[n]}catch(e){window[n]=void 0}},Resource._Implementations.loadAndExecuteScript(i.url,n,t),t.promise};var t=RequestScheduler.request(a);if(defined(t))return t.otherwise(function(t){return a.state!==RequestState$1.FAILED?when.reject(t):i.retryOnError(t).then(function(e){return e?(a.state=RequestState$1.UNISSUED,a.deferred=void 0,fetchJsonp(i,r,n)):when.reject(t)})})}Resource.createIfNeeded=function(e){return e instanceof Resource?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new Resource({url:e})},Resource.supportsImageBitmapOptions=function(){if(defined(supportsImageBitmapOptionsPromise))return supportsImageBitmapOptionsPromise;if("function"!=typeof createImageBitmap)return supportsImageBitmapOptionsPromise=when.resolve(!1);return supportsImageBitmapOptionsPromise=Resource.fetchBlob({url:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg=="}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},defineProperties$1(Resource,{isBlobSupported:{get:function(){return xhrBlobSupported}}}),defineProperties$1(Resource.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(e){var t=new URI(e);parseQuery(t,this,!1),t.fragment=void 0,this._url=t.toString()}},extension:{get:function(){return getExtensionFromUri(this._url)}},isDataUri:{get:function(){return isDataUri(this._url)}},isBlobUri:{get:function(){return isBlobUri(this._url)}},isCrossOriginUrl:{get:function(){return isCrossOriginUrl(this._url)}},hasHeaders:{get:function(){return 0<Object.keys(this.headers).length}}}),Resource.prototype.getUrlComponent=function(e,t){if(this.isDataUri)return this._url;var i=new URI(this._url);e&&stringifyQuery(i,this);var r=i.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),n=this._templateValues;return r=r.replace(/{(.*?)}/g,function(e,t){var i=n[t];return defined(i)?encodeURIComponent(i):e}),t&&defined(this.proxy)&&(r=this.proxy.getURL(r)),r},Resource.prototype.setQueryParameters=function(e,t){this._queryParameters=t?combineQueryParameters(this._queryParameters,e,!1):combineQueryParameters(e,this._queryParameters,!1)},Resource.prototype.appendQueryParameters=function(e){this._queryParameters=combineQueryParameters(e,this._queryParameters,!0)},Resource.prototype.setTemplateValues=function(e,t){this._templateValues=t?combine(this._templateValues,e):combine(e,this._templateValues)},Resource.prototype.getDerivedResource=function(e){var t=this.clone();if(t._retryCount=0,defined(e.url)){var i=new URI(e.url);parseQuery(i,t,!0,defaultValue(e.preserveQueryParameters,!1)),i.fragment=void 0,t._url=i.resolve(new URI(getAbsoluteUri(this._url))).toString()}return defined(e.queryParameters)&&(t._queryParameters=combine(e.queryParameters,t._queryParameters)),defined(e.templateValues)&&(t._templateValues=combine(e.templateValues,t.templateValues)),defined(e.headers)&&(t.headers=combine(e.headers,t.headers)),defined(e.proxy)&&(t.proxy=e.proxy),defined(e.request)&&(t.request=e.request),defined(e.retryCallback)&&(t.retryCallback=e.retryCallback),defined(e.retryAttempts)&&(t.retryAttempts=e.retryAttempts),t},Resource.prototype.retryOnError=function(e){var t=this.retryCallback;if("function"!=typeof t||this._retryCount>=this.retryAttempts)return when(!1);var i=this;return when(t(this,e)).then(function(e){return++i._retryCount,e})},Resource.prototype.clone=function(e){return defined(e)||(e=new Resource({url:this._url})),e._url=this._url,e._queryParameters=clone(this._queryParameters),e._templateValues=clone(this._templateValues),e.headers=clone(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},Resource.prototype.getBaseUri=function(e){return getBaseUri(this.getUrlComponent(e),e)},Resource.prototype.appendForwardSlash=function(){this._url=appendForwardSlash(this._url)},Resource.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},Resource.fetchArrayBuffer=function(e){return new Resource(e).fetchArrayBuffer()},Resource.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},Resource.fetchBlob=function(e){return new Resource(e).fetchBlob()},Resource.prototype.fetchImage=function(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.preferImageBitmap,!1),i=defaultValue(e.preferBlob,!1),r=defaultValue(e.flipY,!1);if(checkAndResetRequest(this.request),!xhrBlobSupported||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!i)return fetchImage({resource:this,flipY:r,preferImageBitmap:t});var n,a,o,s=this.fetchBlob();return defined(s)?Resource.supportsImageBitmapOptions().then(function(e){return n=e&&t,s}).then(function(e){if(defined(e)){if(o=e,n)return Resource.createImageBitmapFromBlob(e,{flipY:r,premultiplyAlpha:!1});var t=window.URL.createObjectURL(e);return fetchImage({resource:a=new Resource({url:t}),flipY:r,preferImageBitmap:!1})}}).then(function(e){if(defined(e))return e.blob=o,n||window.URL.revokeObjectURL(a.url),e}).otherwise(function(e){return defined(a)&&window.URL.revokeObjectURL(a.url),e.blob=o,when.reject(e)}):void 0},Resource.fetchImage=function(e){return new Resource(e).fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},Resource.prototype.fetchText=function(){return this.fetch({responseType:"text"})},Resource.fetchText=function(e){return new Resource(e).fetchText()},Resource.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(defined(e))return e.then(function(e){if(defined(e))return JSON.parse(e)})},Resource.fetchJson=function(e){return new Resource(e).fetchJson()},Resource.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},Resource.fetchXML=function(e){return new Resource(e).fetchXML()},Resource.prototype.fetchJsonp=function(e){var t;for(e=defaultValue(e,"callback"),checkAndResetRequest(this.request);t="loadJsonp"+Math.random().toString().substring(2,8),defined(window[t]););return fetchJsonp(this,e,t)},Resource.fetchJsonp=function(e){return new Resource(e).fetchJsonp(e.callbackParameterName)},Resource.prototype._makeRequest=function(s){var l=this;checkAndResetRequest(l.request);var c=l.request;c.url=l.url,c.requestFunction=function(){var e=s.responseType,t=combine(s.headers,l.headers),i=s.overrideMimeType,r=s.method,n=s.data,a=when.defer(),o=Resource._Implementations.loadWithXhr(l.url,e,r,n,t,a,i);return defined(o)&&defined(o.abort)&&(c.cancelFunction=function(){o.abort()}),a.promise};var e=RequestScheduler.request(c);if(defined(e))return e.then(function(e){return e}).otherwise(function(t){return c.state!==RequestState$1.FAILED?when.reject(t):l.retryOnError(t).then(function(e){return e?(c.state=RequestState$1.UNISSUED,c.deferred=void 0,l.fetch(s)):when.reject(t)})})};var dataUriRegex$1=/^data:(.*?)(;base64)?,(.*)$/;function decodeDataUriText(e,t){var i=decodeURIComponent(t);return e?atob(i):i}function decodeDataUriArrayBuffer(e,t){for(var i=decodeDataUriText(e,t),r=new ArrayBuffer(i.length),n=new Uint8Array(r),a=0;a<i.length;a++)n[a]=i.charCodeAt(a);return r}function decodeDataUri(e,t){t=defaultValue(t,"");var i=e[1],r=!!e[2],n=e[3];switch(t){case"":case"text":return decodeDataUriText(r,n);case"arraybuffer":return decodeDataUriArrayBuffer(r,n);case"blob":var a=decodeDataUriArrayBuffer(r,n);return new Blob([a],{type:i});case"document":return(new DOMParser).parseFromString(decodeDataUriText(r,n),i);case"json":return JSON.parse(decodeDataUriText(r,n))}}function loadImageElement(e,t,i){var r=new Image;r.onload=function(){i.resolve(r)},r.onerror=function(e){i.reject(e)},t&&(TrustedServers.contains(e)?r.crossOrigin="use-credentials":r.crossOrigin=""),r.src=e}function decodeResponse(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function loadWithHttpRequest(e,r,t,i,n,a,o){var s=global.require,l=s("url").parse(e),c="https:"===l.protocol?s("https"):s("http"),u=s("zlib"),d={protocol:l.protocol,hostname:l.hostname,port:l.port,path:l.path,query:l.query,method:t,headers:n};c.request(d).on("response",function(t){if(t.statusCode<200||300<=t.statusCode)a.reject(new RequestErrorEvent(t.statusCode,t,t.headers));else{var i=[];t.on("data",function(e){i.push(e)}),t.on("end",function(){var e=Buffer.concat(i);"gzip"===t.headers["content-encoding"]?u.gunzip(e,function(e,t){e?a.reject(new RuntimeError("Error decompressing response.")):a.resolve(decodeResponse(t,r))}):a.resolve(decodeResponse(e,r))})}}).on("error",function(e){a.reject(new RequestErrorEvent)}).end()}Resource.prototype.fetch=function(e){return(e=defaultClone(e,{})).method="GET",this._makeRequest(e)},Resource.fetch=function(e){return new Resource(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.delete=function(e){return(e=defaultClone(e,{})).method="DELETE",this._makeRequest(e)},Resource.delete=function(e){return new Resource(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},Resource.prototype.head=function(e){return(e=defaultClone(e,{})).method="HEAD",this._makeRequest(e)},Resource.head=function(e){return new Resource(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.options=function(e){return(e=defaultClone(e,{})).method="OPTIONS",this._makeRequest(e)},Resource.options=function(e){return new Resource(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.post=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="POST",t.data=e,this._makeRequest(t)},Resource.post=function(e){return new Resource(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.put=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PUT",t.data=e,this._makeRequest(t)},Resource.put=function(e){return new Resource(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.patch=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},Resource.patch=function(e){return new Resource(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource._Implementations={},Resource._Implementations.createImage=function(t,i,r,n,a){Resource.supportsImageBitmapOptions().then(function(e){if(e&&a)return Resource.fetchBlob({url:t}).then(function(e){if(defined(e))return Resource.createImageBitmapFromBlob(e,{flipY:n,premultiplyAlpha:!1});r.reject(new RuntimeError("Successfully retrieved "+t+" but it contained no content."))}).then(r.resolve);loadImageElement(t,i,r)}).otherwise(r.reject)},Resource.createImageBitmapFromBlob=function(e,t){return Check.defined("options",t),Check.typeOf.bool("options.flipY",t.flipY),Check.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var noXMLHttpRequest="undefined"==typeof XMLHttpRequest;Resource._Implementations.loadWithXhr=function(e,n,a,t,i,o,r){var s=dataUriRegex$1.exec(e);if(null===s){if(!noXMLHttpRequest){var l=new XMLHttpRequest;if(TrustedServers.contains(e)&&(l.withCredentials=!0),l.open(a,e,!0),defined(r)&&defined(l.overrideMimeType)&&l.overrideMimeType(r),defined(i))for(var c in i)i.hasOwnProperty(c)&&l.setRequestHeader(c,i[c]);defined(n)&&(l.responseType=n);var u=!1;return"string"==typeof e&&(u=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),l.onload=function(){if(!(l.status<200||300<=l.status)||u&&0===l.status){var e=l.response,t=l.responseType;if("HEAD"===a||"OPTIONS"===a){var i=l.getAllResponseHeaders().trim().split(/[\r\n]+/),r={};return i.forEach(function(e){var t=e.split(": "),i=t.shift();r[i]=t.join(": ")}),void o.resolve(r)}if(204===l.status)o.resolve();else if(!defined(e)||defined(n)&&t!==n)if("json"===n&&"string"==typeof e)try{o.resolve(JSON.parse(e))}catch(e){o.reject(e)}else(""===t||"document"===t)&&defined(l.responseXML)&&l.responseXML.hasChildNodes()?o.resolve(l.responseXML):""!==t&&"text"!==t||!defined(l.responseText)?o.reject(new RuntimeError("Invalid XMLHttpRequest response type.")):o.resolve(l.responseText);else o.resolve(e)}else o.reject(new RequestErrorEvent(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){o.reject(new RequestErrorEvent)},l.send(t),l}loadWithHttpRequest(e,n,a,t,i,o)}else o.resolve(decodeDataUri(s,n))},Resource._Implementations.loadAndExecuteScript=function(e,t,i){return loadAndExecuteScript(e).otherwise(i.reject)},Resource._DefaultImplementations={},Resource._DefaultImplementations.createImage=Resource._Implementations.createImage,Resource._DefaultImplementations.loadWithXhr=Resource._Implementations.loadWithXhr,Resource._DefaultImplementations.loadAndExecuteScript=Resource._Implementations.loadAndExecuteScript,Resource.DEFAULT=freezeObject$1(new Resource({url:"undefined"==typeof document?"":document.location.href.split("?")[0]}));var cesiumScriptRegex=/((?:.*\/)|^)Cesium\.js$/,a$1,baseResource,implementation;function getBaseUrlFromCesiumScript(){for(var e=document.getElementsByTagName("script"),t=0,i=e.length;t<i;++t){var r=e[t].getAttribute("src"),n=cesiumScriptRegex.exec(r);if(null!==n)return n[1]}}function tryMakeAbsolute(e){return"undefined"==typeof document?e:(defined(a$1)||(a$1=document.createElement("a")),a$1.href=e,a$1.href=a$1.href,a$1.href)}function getCesiumBaseUrl(){return defined(baseResource)||(e="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:"object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?getAbsoluteUri("..",buildModuleUrl("Core/buildModuleUrl.js")):getBaseUrlFromCesiumScript(),(baseResource=new Resource({url:tryMakeAbsolute(e)})).appendForwardSlash()),baseResource;var e}function buildModuleUrlFromRequireToUrl(e){return tryMakeAbsolute(require.toUrl("../"+e))}function buildModuleUrlFromBaseUrl(e){return getCesiumBaseUrl().getDerivedResource({url:e}).url}function buildModuleUrl(e){return defined(implementation)||(implementation="object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?buildModuleUrlFromRequireToUrl:buildModuleUrlFromBaseUrl),implementation(e)}function Cartesian2(e,t){this.x=defaultValue(e,0),this.y=defaultValue(t,0)}buildModuleUrl._cesiumScriptRegex=cesiumScriptRegex,buildModuleUrl._buildModuleUrlFromBaseUrl=buildModuleUrlFromBaseUrl,buildModuleUrl._clearBaseResource=function(){baseResource=void 0},buildModuleUrl.setBaseUrl=function(e){baseResource=Resource.DEFAULT.getDerivedResource({url:e})},buildModuleUrl.getCesiumBaseUrl=getCesiumBaseUrl,Cartesian2.fromElements=function(e,t,i){return defined(i)?(i.x=e,i.y=t,i):new Cartesian2(e,t)},Cartesian2.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t):new Cartesian2(e.x,e.y)},Cartesian2.fromCartesian3=Cartesian2.clone,Cartesian2.fromCartesian4=Cartesian2.clone,Cartesian2.packedLength=2,Cartesian2.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i]=e.y,t},Cartesian2.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian2),i.x=e[t++],i.y=e[t],i},Cartesian2.packArray=function(e,t){var i=e.length;defined(t)?t.length=2*i:t=new Array(2*i);for(var r=0;r<i;++r)Cartesian2.pack(e[r],t,2*r);return t},Cartesian2.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/2:t=new Array(i/2);for(var r=0;r<i;r+=2){var n=r/2;t[n]=Cartesian2.unpack(e,r,t[n])}return t},Cartesian2.fromArray=Cartesian2.unpack,Cartesian2.maximumComponent=function(e){return Math.max(e.x,e.y)},Cartesian2.minimumComponent=function(e){return Math.min(e.x,e.y)},Cartesian2.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i},Cartesian2.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i},Cartesian2.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},Cartesian2.magnitude=function(e){return Math.sqrt(Cartesian2.magnitudeSquared(e))};var distanceScratch$2=new Cartesian2;Cartesian2.distance=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$2),Cartesian2.magnitude(distanceScratch$2)},Cartesian2.distanceSquared=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$2),Cartesian2.magnitudeSquared(distanceScratch$2)},Cartesian2.normalize=function(e,t){var i=Cartesian2.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t},Cartesian2.dot=function(e,t){return e.x*t.x+e.y*t.y},Cartesian2.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i},Cartesian2.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i},Cartesian2.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i},Cartesian2.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i},Cartesian2.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i},Cartesian2.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i},Cartesian2.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},Cartesian2.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var lerpScratch$2=new Cartesian2;Cartesian2.lerp=function(e,t,i,r){return Cartesian2.multiplyByScalar(t,i,lerpScratch$2),r=Cartesian2.multiplyByScalar(e,1-i,r),Cartesian2.add(lerpScratch$2,r,r)};var angleBetweenScratch$1=new Cartesian2,angleBetweenScratch2$1=new Cartesian2;Cartesian2.angleBetween=function(e,t){return Cartesian2.normalize(e,angleBetweenScratch$1),Cartesian2.normalize(t,angleBetweenScratch2$1),CesiumMath.acosClamped(Cartesian2.dot(angleBetweenScratch$1,angleBetweenScratch2$1))};var mostOrthogonalAxisScratch$2=new Cartesian2;function GeographicTilingScheme(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._rectangle=defaultValue(e.rectangle,Rectangle.MAX_VALUE),this._projection=new GeographicProjection(this._ellipsoid),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1)}Cartesian2.mostOrthogonalAxis=function(e,t){var i=Cartesian2.normalize(e,mostOrthogonalAxisScratch$2);return Cartesian2.abs(i,i),t=i.x<=i.y?Cartesian2.clone(Cartesian2.UNIT_X,t):Cartesian2.clone(Cartesian2.UNIT_Y,t)},Cartesian2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y},Cartesian2.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]},Cartesian2.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)},Cartesian2.ZERO=freezeObject$1(new Cartesian2(0,0)),Cartesian2.UNIT_X=freezeObject$1(new Cartesian2(1,0)),Cartesian2.UNIT_Y=freezeObject$1(new Cartesian2(0,1)),Cartesian2.prototype.clone=function(e){return Cartesian2.clone(this,e)},Cartesian2.prototype.equals=function(e){return Cartesian2.equals(this,e)},Cartesian2.prototype.equalsEpsilon=function(e,t,i){return Cartesian2.equalsEpsilon(this,e,t,i)},Cartesian2.prototype.toString=function(){return"("+this.x+", "+this.y+")"},defineProperties$1(GeographicTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),GeographicTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},GeographicTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},GeographicTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){var i=CesiumMath.toDegrees(e.west),r=CesiumMath.toDegrees(e.south),n=CesiumMath.toDegrees(e.east),a=CesiumMath.toDegrees(e.north);return defined(t)?(t.west=i,t.south=r,t.east=n,t.north=a,t):new Rectangle(i,r,n,a)},GeographicTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,i,r){var n=this.tileXYToRectangle(e,t,i,r);return n.west=CesiumMath.toDegrees(n.west),n.south=CesiumMath.toDegrees(n.south),n.east=CesiumMath.toDegrees(n.east),n.north=CesiumMath.toDegrees(n.north),n},GeographicTilingScheme.prototype.tileXYToRectangle=function(e,t,i,r){var n=this._rectangle,a=this.getNumberOfXTilesAtLevel(i),o=this.getNumberOfYTilesAtLevel(i),s=n.width/a,l=e*s+n.west,c=(e+1)*s+n.west,u=n.height/o,d=n.north-t*u,h=n.north-(t+1)*u;return defined(r)||(r=new Rectangle(l,h,c,d)),r.west=l,r.south=h,r.east=c,r.north=d,r},GeographicTilingScheme.prototype.positionToTileXY=function(e,t,i){var r=this._rectangle;if(Rectangle.contains(r,e)){var n=this.getNumberOfXTilesAtLevel(t),a=this.getNumberOfYTilesAtLevel(t),o=r.width/n,s=r.height/a,l=e.longitude;r.east<r.west&&(l+=CesiumMath.TWO_PI);var c=(l-r.west)/o|0;n<=c&&(c=n-1);var u=(r.north-e.latitude)/s|0;return a<=u&&(u=a-1),defined(i)?(i.x=c,i.y=u,i):new Cartesian2(c,u)}};var scratchDiagonalCartesianNE=new Cartesian3,scratchDiagonalCartesianSW=new Cartesian3,scratchDiagonalCartographic=new Cartographic,scratchCenterCartesian=new Cartesian3,scratchSurfaceCartesian=new Cartesian3,scratchBoundingSphere=new BoundingSphere,tilingScheme=new GeographicTilingScheme,scratchCorners=[new Cartographic,new Cartographic,new Cartographic,new Cartographic],scratchTileXY=new Cartesian2,ApproximateTerrainHeights={};function getTileXYLevel(e){Cartographic.fromRadians(e.east,e.north,0,scratchCorners[0]),Cartographic.fromRadians(e.west,e.north,0,scratchCorners[1]),Cartographic.fromRadians(e.east,e.south,0,scratchCorners[2]),Cartographic.fromRadians(e.west,e.south,0,scratchCorners[3]);var t,i=0,r=0,n=0,a=0,o=ApproximateTerrainHeights._terrainHeightsMaxLevel;for(t=0;t<=o;++t){for(var s=!1,l=0;l<4;++l){var c=scratchCorners[l];if(tilingScheme.positionToTileXY(c,t,scratchTileXY),0===l)n=scratchTileXY.x,a=scratchTileXY.y;else if(n!==scratchTileXY.x||a!==scratchTileXY.y){s=!0;break}}if(s)break;i=n,r=a}if(0!==t)return{x:i,y:r,level:o<t?o:t-1}}ApproximateTerrainHeights.initialize=function(){var e=ApproximateTerrainHeights._initPromise;return defined(e)?e:(e=Resource.fetchJson(buildModuleUrl("Assets/approximateTerrainHeights.json")).then(function(e){ApproximateTerrainHeights._terrainHeights=e}),ApproximateTerrainHeights._initPromise=e)},ApproximateTerrainHeights.getMinimumMaximumHeights=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getTileXYLevel(e),r=ApproximateTerrainHeights._defaultMinTerrainHeight,n=ApproximateTerrainHeights._defaultMaxTerrainHeight;if(defined(i)){var a=i.level+"-"+i.x+"-"+i.y,o=ApproximateTerrainHeights._terrainHeights[a];defined(o)&&(r=o[0],n=o[1]),t.cartographicToCartesian(Rectangle.northeast(e,scratchDiagonalCartographic),scratchDiagonalCartesianNE),t.cartographicToCartesian(Rectangle.southwest(e,scratchDiagonalCartographic),scratchDiagonalCartesianSW),Cartesian3.midpoint(scratchDiagonalCartesianSW,scratchDiagonalCartesianNE,scratchCenterCartesian);var s=t.scaleToGeodeticSurface(scratchCenterCartesian,scratchSurfaceCartesian);if(defined(s)){var l=Cartesian3.distance(scratchCenterCartesian,s);r=Math.min(r,-l)}else r=ApproximateTerrainHeights._defaultMinTerrainHeight}return{minimumTerrainHeight:r=Math.max(ApproximateTerrainHeights._defaultMinTerrainHeight,r),maximumTerrainHeight:n}},ApproximateTerrainHeights.getBoundingSphere=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getTileXYLevel(e),r=ApproximateTerrainHeights._defaultMaxTerrainHeight;if(defined(i)){var n=i.level+"-"+i.x+"-"+i.y,a=ApproximateTerrainHeights._terrainHeights[n];defined(a)&&(r=a[1])}var o=BoundingSphere.fromRectangle3D(e,t,0);return BoundingSphere.fromRectangle3D(e,t,r,scratchBoundingSphere),BoundingSphere.union(o,scratchBoundingSphere,o)},ApproximateTerrainHeights._terrainHeightsMaxLevel=6,ApproximateTerrainHeights._defaultMaxTerrainHeight=9e3,ApproximateTerrainHeights._defaultMinTerrainHeight=-1e5,ApproximateTerrainHeights._terrainHeights=void 0,ApproximateTerrainHeights._initPromise=void 0,defineProperties$1(ApproximateTerrainHeights,{initialized:{get:function(){return defined(ApproximateTerrainHeights._terrainHeights)}}});var html=["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"],svg=["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","audio","canvas","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","video","view","vkern"],svgFilters=["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"],mathMl=["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmuliscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mpspace","msqrt","mystyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"],text=["#text"],html$1=["accept","action","align","alt","autocomplete","background","bgcolor","border","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","coords","crossorigin","datetime","default","dir","disabled","download","enctype","face","for","headers","height","hidden","high","href","hreflang","id","integrity","ismap","label","lang","list","loop","low","max","maxlength","media","method","min","multiple","name","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","type","usemap","valign","value","width","xmlns"],svg$1=["accent-height","accumulate","additivive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","tabindex","targetx","targety","transform","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"],mathMl$1=["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"],xml=["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"];function addToSet(e,t){for(var i=t.length;i--;)"string"==typeof t[i]&&(t[i]=t[i].toLowerCase()),e[t[i]]=!0;return e}function clone$1(e){var t={},i=void 0;for(i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i]);return t}var MUSTACHE_EXPR=/\{\{[\s\S]*|[\s\S]*\}\}/gm,ERB_EXPR=/<%[\s\S]*|[\s\S]*%>/gm,DATA_ATTR=/^data-[\-\w.\u00B7-\uFFFF]/,ARIA_ATTR=/^aria-[\-\w]+$/,IS_ALLOWED_URI=/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i,IS_SCRIPT_OR_DATA=/^(?:\w+script|data):/i,ATTR_WHITESPACE=/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205f\u3000]/g,_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function _toConsumableArray(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}var getGlobal=function(){return"undefined"==typeof window?null:window};function createDOMPurify(){function h(e){return createDOMPurify(e)}var l=0<arguments.length&&void 0!==arguments[0]?arguments[0]:getGlobal();if(h.version="1.0.8",h.removed=[],!l||!l.document||9!==l.document.nodeType)return h.isSupported=!1,h;var c=l.document,a=!1,o=!1,s=l.document,u=l.DocumentFragment,e=l.HTMLTemplateElement,d=l.Node,t=l.NodeFilter,i=l.NamedNodeMap,r=void 0===i?l.NamedNodeMap||l.MozNamedAttrMap:i,n=l.Text,p=l.Comment,m=l.DOMParser;if("function"==typeof e){var f=s.createElement("template");f.content&&f.content.ownerDocument&&(s=f.content.ownerDocument)}var g=s,_=g.implementation,y=g.createNodeIterator,v=g.getElementsByTagName,C=g.createDocumentFragment,S=c.importNode,T={};h.isSupported=_&&void 0!==_.createHTMLDocument&&9!==s.documentMode;function x(e){"object"!==(void 0===e?"undefined":_typeof(e))&&(e={}),L="ALLOWED_TAGS"in e?addToSet({},e.ALLOWED_TAGS):F,N="ALLOWED_ATTR"in e?addToSet({},e.ALLOWED_ATTR):V,B="FORBID_TAGS"in e?addToSet({},e.FORBID_TAGS):{},k="FORBID_ATTR"in e?addToSet({},e.FORBID_ATTR):{},ee="USE_PROFILES"in e&&e.USE_PROFILES,$=!1!==e.ALLOW_ARIA_ATTR,z=!1!==e.ALLOW_DATA_ATTR,U=e.ALLOW_UNKNOWN_PROTOCOLS||!1,G=e.SAFE_FOR_JQUERY||!1,H=e.SAFE_FOR_TEMPLATES||!1,W=e.WHOLE_DOCUMENT||!1,Y=e.RETURN_DOM||!1,X=e.RETURN_DOM_FRAGMENT||!1,Q=e.RETURN_DOM_IMPORT||!1,j=e.FORCE_BODY||!1,J=!1!==e.SANITIZE_DOM,Z=!1!==e.KEEP_CONTENT,K=e.IN_PLACE||!1,O=e.ALLOWED_URI_REGEXP||O,H&&(z=!1),X&&(Y=!0),ee&&(L=addToSet({},[].concat(_toConsumableArray(text))),N=[],!0===ee.html&&(addToSet(L,html),addToSet(N,html$1)),!0===ee.svg&&(addToSet(L,svg),addToSet(N,svg$1),addToSet(N,xml)),!0===ee.svgFilters&&(addToSet(L,svgFilters),addToSet(N,svg$1),addToSet(N,xml)),!0===ee.mathMl&&(addToSet(L,mathMl),addToSet(N,mathMl$1),addToSet(N,xml))),e.ADD_TAGS&&(L===F&&(L=clone$1(L)),addToSet(L,e.ADD_TAGS)),e.ADD_ATTR&&(N===V&&(N=clone$1(N)),addToSet(N,e.ADD_ATTR)),e.ADD_URI_SAFE_ATTR&&addToSet(re,e.ADD_URI_SAFE_ATTR),Z&&(L["#text"]=!0),W&&addToSet(L,["html","head","body"]),L.table&&addToSet(L,["tbody"]),Object&&"freeze"in Object&&Object.freeze(e),ne=e}function b(t){h.removed.push({element:t});try{t.parentNode.removeChild(t)}catch(e){t.outerHTML=""}}function E(e,t){try{h.removed.push({attribute:t.getAttributeNode(e),from:t})}catch(e){h.removed.push({attribute:null,from:t})}t.removeAttribute(e)}function P(e){var t=void 0,i=void 0;if(j)e="<remove></remove>"+e;else{var r=e.match(/^[\s]+/);(i=r&&r[0])&&(e=e.slice(i.length))}if(a)try{t=(new m).parseFromString(e,"text/html")}catch(e){}if(o&&addToSet(B,["title"]),!t||!t.documentElement){var n=(t=_.createHTMLDocument("")).body;n.parentNode.removeChild(n.parentNode.firstElementChild),n.outerHTML=e}return i&&t.body.insertBefore(s.createTextNode(i),t.body.childNodes[0]||null),v.call(t,W?"html":"body")[0]}var A=MUSTACHE_EXPR,w=ERB_EXPR,D=DATA_ATTR,M=ARIA_ATTR,I=IS_SCRIPT_OR_DATA,R=ATTR_WHITESPACE,O=IS_ALLOWED_URI,L=null,F=addToSet({},[].concat(_toConsumableArray(html),_toConsumableArray(svg),_toConsumableArray(svgFilters),_toConsumableArray(mathMl),_toConsumableArray(text))),N=null,V=addToSet({},[].concat(_toConsumableArray(html$1),_toConsumableArray(svg$1),_toConsumableArray(mathMl$1),_toConsumableArray(xml))),B=null,k=null,$=!0,z=!0,U=!1,G=!1,H=!1,W=!1,q=!1,j=!1,Y=!1,X=!1,Q=!1,J=!0,Z=!0,K=!1,ee={},te=addToSet({},["audio","head","math","script","style","template","svg","video"]),ie=addToSet({},["audio","video","img","source","image"]),re=addToSet({},["alt","class","for","id","label","name","pattern","placeholder","summary","title","value","style","xmlns"]),ne=null,ae=s.createElement("form");h.isSupported&&(function(){try{P('<svg><p><style><img src="</style><img src=x onerror=alert(1)//">').querySelector("svg img")&&(a=!0)}catch(e){}}(),function(){try{P("<x/><title>&lt;/title&gt;&lt;img&gt;").querySelector("title").textContent.match(/<\/title/)&&(o=!0)}catch(e){}}());function oe(e){return y.call(e.ownerDocument||e,e,t.SHOW_ELEMENT|t.SHOW_COMMENT|t.SHOW_TEXT,function(){return t.FILTER_ACCEPT},!1)}function se(e){return"object"===(void 0===d?"undefined":_typeof(d))?e instanceof d:e&&"object"===(void 0===e?"undefined":_typeof(e))&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName}function le(e,t,i){T[e]&&T[e].forEach(function(e){e.call(h,t,i,ne)})}function ce(e){var t=void 0;if(le("beforeSanitizeElements",e,null),function(e){return!(e instanceof n||e instanceof p)&&!("string"==typeof e.nodeName&&"string"==typeof e.textContent&&"function"==typeof e.removeChild&&e.attributes instanceof r&&"function"==typeof e.removeAttribute&&"function"==typeof e.setAttribute)}(e))return b(e),!0;var i=e.nodeName.toLowerCase();if(le("uponSanitizeElement",e,{tagName:i,allowedTags:L}),L[i]&&!B[i])return!G||e.firstElementChild||e.content&&e.content.firstElementChild||!/</g.test(e.textContent)||(h.removed.push({element:e.cloneNode()}),e.innerHTML?e.innerHTML=e.innerHTML.replace(/</g,"&lt;"):e.innerHTML=e.textContent.replace(/</g,"&lt;")),H&&3===e.nodeType&&(t=(t=(t=e.textContent).replace(A," ")).replace(w," "),e.textContent!==t&&(h.removed.push({element:e.cloneNode()}),e.textContent=t)),le("afterSanitizeElements",e,null),!1;if(Z&&!te[i]&&"function"==typeof e.insertAdjacentHTML)try{e.insertAdjacentHTML("AfterEnd",e.innerHTML)}catch(e){}return b(e),!0}function ue(e,t,i){if(J&&("id"===t||"name"===t)&&(i in s||i in ae))return!1;if(H&&(i=(i=i.replace(A," ")).replace(w," ")),!(z&&D.test(t)||$&&M.test(t))){if(!N[t]||k[t])return!1;if(!re[t]&&!O.test(i.replace(R,"")))if("src"!==t&&"xlink:href"!==t||"script"===e||0!==i.indexOf("data:")||!ie[e]){if((!U||I.test(i.replace(R,"")))&&i)return!1}else;}return!0}function de(e){var t=void 0,i=void 0,r=void 0,n=void 0,a=void 0;le("beforeSanitizeAttributes",e,null);var o=e.attributes;if(o){var s={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:N};for(a=o.length;a--;){var l=t=o[a],c=l.name,u=l.namespaceURI;if(i=t.value.trim(),r=c.toLowerCase(),s.attrName=r,s.attrValue=i,s.keepAttr=!0,le("uponSanitizeAttribute",e,s),i=s.attrValue,"name"===r&&"IMG"===e.nodeName&&o.id)n=o.id,o=Array.prototype.slice.apply(o),E("id",e),E(c,e),o.indexOf(n)>a&&e.setAttribute("id",n.value);else{if("INPUT"===e.nodeName&&"type"===r&&"file"===i&&(N[r]||!k[r]))continue;"id"===c&&e.setAttribute(c,""),E(c,e)}if(s.keepAttr){var d=e.nodeName.toLowerCase();if(ue(d,r,i))try{u?e.setAttributeNS(u,c,i):e.setAttribute(c,i),h.removed.pop()}catch(e){}}}le("afterSanitizeAttributes",e,null)}}function he(e){var t=void 0,i=oe(e);for(le("beforeSanitizeShadowDOM",e,null);t=i.nextNode();)le("uponSanitizeShadowNode",t,null),ce(t)||(t.content instanceof u&&he(t.content),de(t));le("afterSanitizeShadowDOM",e,null)}return h.sanitize=function(e,t){var i=void 0,r=void 0,n=void 0,a=void 0,o=void 0;if("string"!=typeof(e=e||"\x3c!--\x3e")&&!se(e)){if("function"!=typeof e.toString)throw new TypeError("toString is not a function");if("string"!=typeof(e=e.toString()))throw new TypeError("dirty is not a string, aborting")}if(!h.isSupported){if("object"===_typeof(l.toStaticHTML)||"function"==typeof l.toStaticHTML){if("string"==typeof e)return l.toStaticHTML(e);if(se(e))return l.toStaticHTML(e.outerHTML)}return e}if(q||x(t),h.removed=[],!K)if(e instanceof d)1===(r=(i=P("\x3c!--\x3e")).ownerDocument.importNode(e,!0)).nodeType&&"BODY"===r.nodeName?i=r:i.appendChild(r);else{if(!Y&&!W&&-1===e.indexOf("<"))return e;if(!(i=P(e)))return Y?null:""}i&&j&&b(i.firstChild);for(var s=oe(K?e:i);n=s.nextNode();)3===n.nodeType&&n===a||ce(n)||(n.content instanceof u&&he(n.content),de(n),a=n);if(K)return e;if(Y){if(X)for(o=C.call(i.ownerDocument);i.firstChild;)o.appendChild(i.firstChild);else o=i;return Q&&(o=S.call(c,o,!0)),o}return W?i.outerHTML:i.innerHTML},h.setConfig=function(e){x(e),q=!0},h.clearConfig=function(){ne=null,q=!1},h.isValidAttribute=function(e,t,i){ne||x({});var r=e.toLowerCase(),n=t.toLowerCase();return ue(r,n,i)},h.addHook=function(e,t){"function"==typeof t&&(T[e]=T[e]||[],T[e].push(t))},h.removeHook=function(e){T[e]&&T[e].pop()},h.removeHooks=function(e){T[e]&&(T[e]=[])},h.removeAllHooks=function(){T={}},h}var purify=createDOMPurify(),nextCreditId=0,creditToId={};function Credit(e,t){var i,r=e;defined(creditToId[r])?i=creditToId[r]:(i=nextCreditId++,creditToId[r]=i),t=defaultValue(t,!1),this._id=i,this._html=e,this._showOnScreen=t,this._element=void 0}defineProperties$1(Credit.prototype,{html:{get:function(){return this._html}},id:{get:function(){return this._id}},showOnScreen:{get:function(){return this._showOnScreen}},element:{get:function(){if(!defined(this._element)){var e=purify.sanitize(this._html),t=document.createElement("div");t._creditId=this._id,t.style.display="inline",t.innerHTML=e;for(var i=t.querySelectorAll("a"),r=0;r<i.length;r++)i[r].setAttribute("target","_blank");this._element=t}return this._element}}}),Credit.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._id===t._id},Credit.prototype.equals=function(e){return Credit.equals(this,e)},Credit.getIonCredit=function(e){var t=defined(e.collapsible)&&!e.collapsible,i=new Credit(e.html,t);return i._isIon=-1!==i.html.indexOf("ion-credit.png"),i},Credit.clone=function(e){if(defined(e))return new Credit(e.html,e.showOnScreen)};var HeightmapEncoding={NONE:0,LERC:1},HeightmapEncoding$1=freezeObject$1(HeightmapEncoding);function AxisAlignedBoundingBox(e,t,i){this.minimum=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.maximum=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),i=defined(i)?Cartesian3.clone(i):Cartesian3.midpoint(this.minimum,this.maximum,new Cartesian3),this.center=i}AxisAlignedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new AxisAlignedBoundingBox),!defined(e)||0===e.length)return t.minimum=Cartesian3.clone(Cartesian3.ZERO,t.minimum),t.maximum=Cartesian3.clone(Cartesian3.ZERO,t.maximum),t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t;for(var i=e[0].x,r=e[0].y,n=e[0].z,a=e[0].x,o=e[0].y,s=e[0].z,l=e.length,c=1;c<l;c++){var u=e[c],d=u.x,h=u.y,p=u.z;i=Math.min(d,i),a=Math.max(d,a),r=Math.min(h,r),o=Math.max(h,o),n=Math.min(p,n),s=Math.max(p,s)}var m=t.minimum;m.x=i,m.y=r,m.z=n;var f=t.maximum;return f.x=a,f.y=o,f.z=s,t.center=Cartesian3.midpoint(m,f,t.center),t},AxisAlignedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(t.minimum=Cartesian3.clone(e.minimum,t.minimum),t.maximum=Cartesian3.clone(e.maximum,t.maximum),t.center=Cartesian3.clone(e.center,t.center),t):new AxisAlignedBoundingBox(e.minimum,e.maximum,e.center)},AxisAlignedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Cartesian3.equals(e.minimum,t.minimum)&&Cartesian3.equals(e.maximum,t.maximum)};var intersectScratch=new Cartesian3;function EllipsoidalOccluder(e,t){this._ellipsoid=e,this._cameraPosition=new Cartesian3,this._cameraPositionInScaledSpace=new Cartesian3,this._distanceToLimbInScaledSpaceSquared=0,defined(t)&&(this.cameraPosition=t)}AxisAlignedBoundingBox.intersectPlane=function(e,t){intersectScratch=Cartesian3.subtract(e.maximum,e.minimum,intersectScratch);var i=Cartesian3.multiplyByScalar(intersectScratch,.5,intersectScratch),r=t.normal,n=i.x*Math.abs(r.x)+i.y*Math.abs(r.y)+i.z*Math.abs(r.z),a=Cartesian3.dot(e.center,r)+t.distance;return 0<a-n?Intersect$1.INSIDE:a+n<0?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},AxisAlignedBoundingBox.prototype.clone=function(e){return AxisAlignedBoundingBox.clone(this,e)},AxisAlignedBoundingBox.prototype.intersectPlane=function(e){return AxisAlignedBoundingBox.intersectPlane(this,e)},AxisAlignedBoundingBox.prototype.equals=function(e){return AxisAlignedBoundingBox.equals(this,e)},defineProperties$1(EllipsoidalOccluder.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=Cartesian3.magnitudeSquared(t)-1;Cartesian3.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=t,this._distanceToLimbInScaledSpaceSquared=i}}});var scratchCartesian=new Cartesian3;EllipsoidalOccluder.prototype.isPointVisible=function(e){var t=this._ellipsoid.transformPositionToScaledSpace(e,scratchCartesian);return this.isScaledSpacePointVisible(t)},EllipsoidalOccluder.prototype.isScaledSpacePointVisible=function(e){var t=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared,r=Cartesian3.subtract(e,t,scratchCartesian),n=-Cartesian3.dot(r,t);return!(i<0?0<n:i<n&&n*n/Cartesian3.magnitudeSquared(r)>i)},EllipsoidalOccluder.prototype.computeHorizonCullingPoint=function(e,t,i){defined(i)||(i=new Cartesian3);for(var r=this._ellipsoid,n=computeScaledSpaceDirectionToPoint(r,e),a=0,o=0,s=t.length;o<s;++o){var l=computeMagnitude(r,t[o],n);a=Math.max(a,l)}return magnitudeToPoint(n,a,i)};var positionScratch=new Cartesian3;EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVertices=function(e,t,i,r,n){defined(n)||(n=new Cartesian3),r=defaultValue(r,Cartesian3.ZERO);for(var a=this._ellipsoid,o=computeScaledSpaceDirectionToPoint(a,e),s=0,l=0,c=t.length;l<c;l+=i){positionScratch.x=t[l]+r.x,positionScratch.y=t[l+1]+r.y,positionScratch.z=t[l+2]+r.z;var u=computeMagnitude(a,positionScratch,o);s=Math.max(s,u)}return magnitudeToPoint(o,s,n)};var subsampleScratch=[];EllipsoidalOccluder.prototype.computeHorizonCullingPointFromRectangle=function(e,t,i){var r=Rectangle.subsample(e,t,0,subsampleScratch),n=BoundingSphere.fromPoints(r);if(!(Cartesian3.magnitude(n.center)<.1*t.minimumRadius))return this.computeHorizonCullingPoint(n.center,r,i)};var scaledSpaceScratch=new Cartesian3,directionScratch=new Cartesian3;function computeMagnitude(e,t,i){var r=e.transformPositionToScaledSpace(t,scaledSpaceScratch),n=Cartesian3.magnitudeSquared(r),a=Math.sqrt(n),o=Cartesian3.divideByScalar(r,a,directionScratch);n=Math.max(1,n);var s=1/(a=Math.max(1,a));return 1/(Cartesian3.dot(o,i)*s-Cartesian3.magnitude(Cartesian3.cross(o,i,o))*(Math.sqrt(n-1)*s))}function magnitudeToPoint(e,t,i){if(!(t<=0||t===1/0||t!=t))return Cartesian3.multiplyByScalar(e,t,i)}var directionToPointScratch=new Cartesian3;function computeScaledSpaceDirectionToPoint(e,t){return Cartesian3.equals(t,Cartesian3.ZERO)?t:(e.transformPositionToScaledSpace(t,directionToPointScratch),Cartesian3.normalize(directionToPointScratch,directionToPointScratch))}var QuadraticRealPolynomial={};function addWithCancellationCheck(e,t,i){var r=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<i?0:r}QuadraticRealPolynomial.computeDiscriminant=function(e,t,i){return t*t-4*e*i},QuadraticRealPolynomial.computeRealRoots=function(e,t,i){var r;if(0===e)return 0===t?[]:[-i/t];if(0===t){if(0===i)return[0,0];var n=Math.abs(i),a=Math.abs(e);if(n<a&&n/a<CesiumMath.EPSILON14)return[0,0];if(a<n&&a/n<CesiumMath.EPSILON14)return[];if((r=-i/e)<0)return[];var o=Math.sqrt(r);return[-o,o]}if(0===i)return(r=-t/e)<0?[r,0]:[0,r];var s=addWithCancellationCheck(t*t,-(4*e*i),CesiumMath.EPSILON14);if(s<0)return[];var l=-.5*addWithCancellationCheck(t,CesiumMath.sign(t)*Math.sqrt(s),CesiumMath.EPSILON14);return 0<t?[l/e,i/l]:[i/l,l/e]};var CubicRealPolynomial={};function computeRealRoots(e,t,i,r){var n,a,o=e,s=t/3,l=i/3,c=r,u=o*l,d=s*c,h=s*s,p=l*l,m=o*l-h,f=o*c-s*l,g=s*c-p,_=4*m*g-f*f;if(_<0){var y,v,C,S=-((C=u*p<=h*d?-2*s*(v=m)+(y=o)*f:-(y=c)*f+2*l*(v=g))<0?-1:1)*Math.abs(y)*Math.sqrt(-_),T=(a=S-C)/2,x=T<0?-Math.pow(-T,1/3):Math.pow(T,1/3),b=a===S?-x:-v/x;return n=v<=0?x+b:-C/(x*x+b*b+v),u*p<=h*d?[(n-s)/o]:[-c/(n+l)]}var E=m,P=-2*s*m+o*f,A=g,w=-c*f+2*l*g,D=Math.sqrt(_),M=Math.sqrt(3)/2,I=Math.abs(Math.atan2(o*D,-P)/3);n=2*Math.sqrt(-E);var R=Math.cos(I);a=n*R;var O=n*(-R/2-M*Math.sin(I)),L=2*s<a+O?a-s:O-s,F=o,N=L/F;I=Math.abs(Math.atan2(c*D,-w)/3);var V=-c,B=(a=(n=2*Math.sqrt(-A))*(R=Math.cos(I)))+(O=n*(-R/2-M*Math.sin(I)))<2*l?a+l:O+l,k=V/B,$=-L*B-F*V,z=(l*$-s*(L*V))/(-s*$+l*(F*B));return N<=z?N<=k?z<=k?[N,z,k]:[N,k,z]:[k,N,z]:N<=k?[z,N,k]:z<=k?[z,k,N]:[k,z,N]}CubicRealPolynomial.computeDiscriminant=function(e,t,i,r){var n=t*t,a=i*i;return 18*e*t*i*r+n*a-27*(e*e)*(r*r)-4*(e*a*i+n*t*r)},CubicRealPolynomial.computeRealRoots=function(e,t,i,r){var n,a;if(0===e)return QuadraticRealPolynomial.computeRealRoots(t,i,r);if(0!==t)return 0===i?0===r?(a=-t/e)<0?[a,0,0]:[0,0,a]:computeRealRoots(e,t,0,r):0===r?0===(n=QuadraticRealPolynomial.computeRealRoots(e,t,i)).length?[0]:n[1]<=0?[n[0],n[1],0]:0<=n[0]?[0,n[0],n[1]]:[n[0],0,n[1]]:computeRealRoots(e,t,i,r);if(0!==i)return 0===r?0===(n=QuadraticRealPolynomial.computeRealRoots(e,0,i)).Length?[0]:[n[0],0,n[1]]:computeRealRoots(e,0,i,r);if(0===r)return[0,0,0];var o=(a=-r/e)<0?-Math.pow(-a,1/3):Math.pow(a,1/3);return[o,o,o]};var QuarticRealPolynomial={};function original(e,t,i,r){var n=e*e,a=t-3*n/8,o=i-t*e/2+n*e/8,s=r-i*e/4+t*n/16-3*n*n/256,l=CubicRealPolynomial.computeRealRoots(1,2*a,a*a-4*s,-o*o);if(0<l.length){var c=-e/4,u=l[l.length-1];if(Math.abs(u)<CesiumMath.EPSILON14){var d=QuadraticRealPolynomial.computeRealRoots(1,a,s);if(2===d.length){var h,p=d[0],m=d[1];if(0<=p&&0<=m){var f=Math.sqrt(p),g=Math.sqrt(m);return[c-g,c-f,c+f,c+g]}if(0<=p&&m<0)return[c-(h=Math.sqrt(p)),c+h];if(p<0&&0<=m)return[c-(h=Math.sqrt(m)),c+h]}return[]}if(0<u){var _=Math.sqrt(u),y=(a+u-o/_)/2,v=(a+u+o/_)/2,C=QuadraticRealPolynomial.computeRealRoots(1,_,y),S=QuadraticRealPolynomial.computeRealRoots(1,-_,v);return 0!==C.length?(C[0]+=c,C[1]+=c,0!==S.length?(S[0]+=c,S[1]+=c,C[1]<=S[0]?[C[0],C[1],S[0],S[1]]:S[1]<=C[0]?[S[0],S[1],C[0],C[1]]:C[0]>=S[0]&&C[1]<=S[1]?[S[0],C[0],C[1],S[1]]:S[0]>=C[0]&&S[1]<=C[1]?[C[0],S[0],S[1],C[1]]:C[0]>S[0]&&C[0]<S[1]?[S[0],C[0],S[1],C[1]]:[C[0],S[0],C[1],S[1]]):C):0!==S.length?(S[0]+=c,S[1]+=c,S):[]}}return[]}function neumark(e,t,i,r){var n=e*e,a=-2*t,o=i*e+t*t-4*r,s=n*r-i*t*e+i*i,l=CubicRealPolynomial.computeRealRoots(1,a,o,s);if(0<l.length){var c,u,d,h,p,m,f=l[0],g=t-f,_=g*g,y=e/2,v=g/2,C=_-4*r,S=_+4*Math.abs(r),T=n-4*f,x=n+4*Math.abs(f);if(f<0||C*x<T*S){var b=Math.sqrt(T);c=b/2,u=0===b?0:(e*v-i)/b}else{var E=Math.sqrt(C);c=0===E?0:(e*v-i)/E,u=E/2}0==y&&0===c?h=d=0:CesiumMath.sign(y)===CesiumMath.sign(c)?h=f/(d=y+c):d=f/(h=y-c),0==v&&0===u?m=p=0:CesiumMath.sign(v)===CesiumMath.sign(u)?m=r/(p=v+u):p=r/(m=v-u);var P=QuadraticRealPolynomial.computeRealRoots(1,d,p),A=QuadraticRealPolynomial.computeRealRoots(1,h,m);if(0!==P.length)return 0!==A.length?P[1]<=A[0]?[P[0],P[1],A[0],A[1]]:A[1]<=P[0]?[A[0],A[1],P[0],P[1]]:P[0]>=A[0]&&P[1]<=A[1]?[A[0],P[0],P[1],A[1]]:A[0]>=P[0]&&A[1]<=P[1]?[P[0],A[0],A[1],P[1]]:P[0]>A[0]&&P[0]<A[1]?[A[0],P[0],A[1],P[1]]:[P[0],A[0],P[1],A[1]]:P;if(0!==A.length)return A}return[]}function Ray(e,t){t=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),Cartesian3.equals(t,Cartesian3.ZERO)||Cartesian3.normalize(t,t),this.origin=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.direction=t}QuarticRealPolynomial.computeDiscriminant=function(e,t,i,r,n){var a=e*e,o=t*t,s=o*t,l=i*i,c=l*i,u=r*r,d=u*r,h=n*n;return o*l*u-4*s*d-4*e*c*u+18*e*t*i*d-27*a*u*u+256*(a*e)*(h*n)+n*(18*s*i*r-4*o*c+16*e*l*l-80*e*t*l*r-6*e*o*u+144*a*i*u)+h*(144*e*o*i-27*o*o-128*a*l-192*a*t*r)},QuarticRealPolynomial.computeRealRoots=function(e,t,i,r,n){if(Math.abs(e)<CesiumMath.EPSILON15)return CubicRealPolynomial.computeRealRoots(t,i,r,n);var a=t/e,o=i/e,s=r/e,l=n/e,c=a<0?1:0;switch(c+=o<0?c+1:c,c+=s<0?c+1:c,c+=l<0?c+1:c){case 0:return original(a,o,s,l);case 1:case 2:return neumark(a,o,s,l);case 3:case 4:return original(a,o,s,l);case 5:return neumark(a,o,s,l);case 6:case 7:return original(a,o,s,l);case 8:return neumark(a,o,s,l);case 9:case 10:return original(a,o,s,l);case 11:return neumark(a,o,s,l);case 12:case 13:case 14:case 15:return original(a,o,s,l);default:return}},Ray.clone=function(e,t){if(defined(e))return defined(t)?(t.origin=Cartesian3.clone(e.origin),t.direction=Cartesian3.clone(e.direction),t):new Ray(e.origin,e.direction)},Ray.getPoint=function(e,t,i){return defined(i)||(i=new Cartesian3),i=Cartesian3.multiplyByScalar(e.direction,t,i),Cartesian3.add(e.origin,i,i)};var IntersectionTests={rayPlane:function(e,t,i){defined(i)||(i=new Cartesian3);var r=e.origin,n=e.direction,a=t.normal,o=Cartesian3.dot(a,n);if(!(Math.abs(o)<CesiumMath.EPSILON15)){var s=(-t.distance-Cartesian3.dot(a,r))/o;if(!(s<0))return i=Cartesian3.multiplyByScalar(n,s,i),Cartesian3.add(r,i,i)}}},scratchEdge0=new Cartesian3,scratchEdge1=new Cartesian3,scratchPVec=new Cartesian3,scratchTVec=new Cartesian3,scratchQVec=new Cartesian3;IntersectionTests.rayTriangleParametric=function(e,t,i,r,n){n=defaultValue(n,!1);var a,o,s,l,c,u=e.origin,d=e.direction,h=Cartesian3.subtract(i,t,scratchEdge0),p=Cartesian3.subtract(r,t,scratchEdge1),m=Cartesian3.cross(d,p,scratchPVec),f=Cartesian3.dot(h,m);if(n){if(f<CesiumMath.EPSILON6)return;if(a=Cartesian3.subtract(u,t,scratchTVec),(s=Cartesian3.dot(a,m))<0||f<s)return;if(o=Cartesian3.cross(a,h,scratchQVec),(l=Cartesian3.dot(d,o))<0||f<s+l)return;c=Cartesian3.dot(p,o)/f}else{if(Math.abs(f)<CesiumMath.EPSILON6)return;var g=1/f;if(a=Cartesian3.subtract(u,t,scratchTVec),(s=Cartesian3.dot(a,m)*g)<0||1<s)return;if(o=Cartesian3.cross(a,h,scratchQVec),(l=Cartesian3.dot(d,o)*g)<0||1<s+l)return;c=Cartesian3.dot(p,o)*g}return c},IntersectionTests.rayTriangle=function(e,t,i,r,n,a){var o=IntersectionTests.rayTriangleParametric(e,t,i,r,n);if(defined(o)&&!(o<0))return defined(a)||(a=new Cartesian3),Cartesian3.multiplyByScalar(e.direction,o,a),Cartesian3.add(e.origin,a,a)};var scratchLineSegmentTriangleRay=new Ray;function solveQuadratic(e,t,i,r){var n=t*t-4*e*i;if(!(n<0)){if(0<n){var a=1/(2*e),o=Math.sqrt(n),s=(-t+o)*a,l=(-t-o)*a;return s<l?(r.root0=s,r.root1=l):(r.root0=l,r.root1=s),r}var c=-t/(2*e);if(0!=c)return r.root0=r.root1=c,r}}IntersectionTests.lineSegmentTriangle=function(e,t,i,r,n,a,o){var s=scratchLineSegmentTriangleRay;Cartesian3.clone(e,s.origin),Cartesian3.subtract(t,e,s.direction),Cartesian3.normalize(s.direction,s.direction);var l=IntersectionTests.rayTriangleParametric(s,i,r,n,a);if(!(!defined(l)||l<0||l>Cartesian3.distance(e,t)))return defined(o)||(o=new Cartesian3),Cartesian3.multiplyByScalar(s.direction,l,o),Cartesian3.add(s.origin,o,o)};var raySphereRoots={root0:0,root1:0};function raySphere(e,t,i){defined(i)||(i=new Interval);var r=e.origin,n=e.direction,a=t.center,o=t.radius*t.radius,s=Cartesian3.subtract(r,a,scratchPVec),l=solveQuadratic(Cartesian3.dot(n,n),2*Cartesian3.dot(n,s),Cartesian3.magnitudeSquared(s)-o,raySphereRoots);if(defined(l))return i.start=l.root0,i.stop=l.root1,i}IntersectionTests.raySphere=function(e,t,i){if(defined(i=raySphere(e,t,i))&&!(i.stop<0))return i.start=Math.max(i.start,0),i};var scratchLineSegmentRay=new Ray;IntersectionTests.lineSegmentSphere=function(e,t,i,r){var n=scratchLineSegmentRay;Cartesian3.clone(e,n.origin);var a=Cartesian3.subtract(t,e,n.direction),o=Cartesian3.magnitude(a);if(Cartesian3.normalize(a,a),!(!defined(r=raySphere(n,i,r))||r.stop<0||r.start>o))return r.start=Math.max(r.start,0),r.stop=Math.min(r.stop,o),r};var scratchQ=new Cartesian3,scratchW=new Cartesian3;function addWithCancellationCheck$1(e,t,i){var r=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<i?0:r}function quadraticVectorExpression(e,t,i,r,n){var a,o=r*r,s=n*n,l=(e[Matrix3.COLUMN1ROW1]-e[Matrix3.COLUMN2ROW2])*s,c=n*(r*addWithCancellationCheck$1(e[Matrix3.COLUMN1ROW0],e[Matrix3.COLUMN0ROW1],CesiumMath.EPSILON15)+t.y),u=e[Matrix3.COLUMN0ROW0]*o+e[Matrix3.COLUMN2ROW2]*s+r*t.x+i,d=s*addWithCancellationCheck$1(e[Matrix3.COLUMN2ROW1],e[Matrix3.COLUMN1ROW2],CesiumMath.EPSILON15),h=n*(r*addWithCancellationCheck$1(e[Matrix3.COLUMN2ROW0],e[Matrix3.COLUMN0ROW2])+t.z),p=[];if(0==h&&0==d){if(0===(a=QuadraticRealPolynomial.computeRealRoots(l,c,u)).length)return p;var m=a[0],f=Math.sqrt(Math.max(1-m*m,0));if(p.push(new Cartesian3(r,n*m,n*-f)),p.push(new Cartesian3(r,n*m,n*f)),2===a.length){var g=a[1],_=Math.sqrt(Math.max(1-g*g,0));p.push(new Cartesian3(r,n*g,n*-_)),p.push(new Cartesian3(r,n*g,n*_))}return p}var y=h*h,v=d*d,C=h*d,S=l*l+v,T=2*(c*l+C),x=2*u*l+c*c-v+y,b=2*(u*c-C),E=u*u-y;if(0==S&&0==T&&0==x&&0==b)return p;var P=(a=QuarticRealPolynomial.computeRealRoots(S,T,x,b,E)).length;if(0===P)return p;for(var A=0;A<P;++A){var w=a[A],D=w*w,M=Math.max(1-D,0),I=Math.sqrt(M),R=(CesiumMath.sign(l)===CesiumMath.sign(u)?addWithCancellationCheck$1(l*D+u,c*w,CesiumMath.EPSILON12):CesiumMath.sign(u)===CesiumMath.sign(c*w)?addWithCancellationCheck$1(l*D,c*w+u,CesiumMath.EPSILON12):addWithCancellationCheck$1(l*D+c*w,u,CesiumMath.EPSILON12))*addWithCancellationCheck$1(d*w,h,CesiumMath.EPSILON15);R<0?p.push(new Cartesian3(r,n*w,n*I)):0<R?p.push(new Cartesian3(r,n*w,n*-I)):0!==I?(p.push(new Cartesian3(r,n*w,n*-I)),p.push(new Cartesian3(r,n*w,n*I)),++A):p.push(new Cartesian3(r,n*w,n*I))}return p}IntersectionTests.rayEllipsoid=function(e,t){var i,r,n,a,o,s=t.oneOverRadii,l=Cartesian3.multiplyComponents(s,e.origin,scratchQ),c=Cartesian3.multiplyComponents(s,e.direction,scratchW),u=Cartesian3.magnitudeSquared(l),d=Cartesian3.dot(l,c);if(1<u){if(0<=d)return;var h=d*d;if(i=u-1,h<(n=(r=Cartesian3.magnitudeSquared(c))*i))return;if(n<h){a=d*d-n;var p=(o=-d+Math.sqrt(a))/r,m=i/o;return p<m?new Interval(p,m):{start:m,stop:p}}var f=Math.sqrt(i/r);return new Interval(f,f)}return u<1?(i=u-1,a=d*d-(n=(r=Cartesian3.magnitudeSquared(c))*i),new Interval(0,(o=-d+Math.sqrt(a))/r)):d<0?new Interval(0,-d/(r=Cartesian3.magnitudeSquared(c))):void 0};var firstAxisScratch=new Cartesian3,secondAxisScratch=new Cartesian3,thirdAxisScratch=new Cartesian3,referenceScratch=new Cartesian3,bCart=new Cartesian3,bScratch=new Matrix3,btScratch=new Matrix3,diScratch=new Matrix3,dScratch=new Matrix3,cScratch=new Matrix3,tempMatrix=new Matrix3,aScratch=new Matrix3,sScratch=new Cartesian3,closestScratch=new Cartesian3,surfPointScratch=new Cartographic;IntersectionTests.grazingAltitudeLocation=function(e,t){var i=e.origin,r=e.direction;if(!Cartesian3.equals(i,Cartesian3.ZERO)){var n=t.geodeticSurfaceNormal(i,firstAxisScratch);if(0<=Cartesian3.dot(r,n))return i}var a=defined(this.rayEllipsoid(e,t)),o=t.transformPositionToScaledSpace(r,firstAxisScratch),s=Cartesian3.normalize(o,o),l=Cartesian3.mostOrthogonalAxis(o,referenceScratch),c=Cartesian3.normalize(Cartesian3.cross(l,s,secondAxisScratch),secondAxisScratch),u=Cartesian3.normalize(Cartesian3.cross(s,c,thirdAxisScratch),thirdAxisScratch),d=bScratch;d[0]=s.x,d[1]=s.y,d[2]=s.z,d[3]=c.x,d[4]=c.y,d[5]=c.z,d[6]=u.x,d[7]=u.y,d[8]=u.z;var h=Matrix3.transpose(d,btScratch),p=Matrix3.fromScale(t.radii,diScratch),m=Matrix3.fromScale(t.oneOverRadii,dScratch),f=cScratch;f[0]=0,f[1]=-r.z,f[2]=r.y,f[3]=r.z,f[4]=0,f[5]=-r.x,f[6]=-r.y,f[7]=r.x,f[8]=0;var g,_,y=Matrix3.multiply(Matrix3.multiply(h,m,tempMatrix),f,tempMatrix),v=Matrix3.multiply(Matrix3.multiply(y,p,aScratch),d,aScratch),C=Matrix3.multiplyByVector(y,i,bCart),S=quadraticVectorExpression(v,Cartesian3.negate(C,firstAxisScratch),0,0,1),T=S.length;if(0<T){for(var x=Cartesian3.clone(Cartesian3.ZERO,closestScratch),b=Number.NEGATIVE_INFINITY,E=0;E<T;++E){g=Matrix3.multiplyByVector(p,Matrix3.multiplyByVector(d,S[E],sScratch),sScratch);var P=Cartesian3.normalize(Cartesian3.subtract(g,i,referenceScratch),referenceScratch),A=Cartesian3.dot(P,r);b<A&&(b=A,x=Cartesian3.clone(g,x))}var w=t.cartesianToCartographic(x,surfPointScratch);return b=CesiumMath.clamp(b,0,1),_=Cartesian3.magnitude(Cartesian3.subtract(x,i,referenceScratch))*Math.sqrt(1-b*b),_=a?-_:_,w.height=_,t.cartographicToCartesian(w,new Cartesian3)}};var lineSegmentPlaneDifference=new Cartesian3;function Plane(e,t){this.normal=Cartesian3.clone(e),this.distance=t}IntersectionTests.lineSegmentPlane=function(e,t,i,r){defined(r)||(r=new Cartesian3);var n=Cartesian3.subtract(t,e,lineSegmentPlaneDifference),a=i.normal,o=Cartesian3.dot(a,n);if(!(Math.abs(o)<CesiumMath.EPSILON6)){var s=Cartesian3.dot(a,e),l=-(i.distance+s)/o;if(!(l<0||1<l))return Cartesian3.multiplyByScalar(n,l,r),Cartesian3.add(e,r,r),r}},IntersectionTests.trianglePlaneIntersection=function(e,t,i,r){var n,a,o=r.normal,s=r.distance,l=Cartesian3.dot(o,e)+s<0,c=Cartesian3.dot(o,t)+s<0,u=Cartesian3.dot(o,i)+s<0,d=0;if(d+=l?1:0,d+=c?1:0,1!=(d+=u?1:0)&&2!=d||(n=new Cartesian3,a=new Cartesian3),1==d){if(l)return IntersectionTests.lineSegmentPlane(e,t,r,n),IntersectionTests.lineSegmentPlane(e,i,r,a),{positions:[e,t,i,n,a],indices:[0,3,4,1,2,4,1,4,3]};if(c)return IntersectionTests.lineSegmentPlane(t,i,r,n),IntersectionTests.lineSegmentPlane(t,e,r,a),{positions:[e,t,i,n,a],indices:[1,3,4,2,0,4,2,4,3]};if(u)return IntersectionTests.lineSegmentPlane(i,e,r,n),IntersectionTests.lineSegmentPlane(i,t,r,a),{positions:[e,t,i,n,a],indices:[2,3,4,0,1,4,0,4,3]}}else if(2==d){if(!l)return IntersectionTests.lineSegmentPlane(t,e,r,n),IntersectionTests.lineSegmentPlane(i,e,r,a),{positions:[e,t,i,n,a],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return IntersectionTests.lineSegmentPlane(i,t,r,n),IntersectionTests.lineSegmentPlane(e,t,r,a),{positions:[e,t,i,n,a],indices:[2,0,4,2,4,3,1,3,4]};if(!u)return IntersectionTests.lineSegmentPlane(e,i,r,n),IntersectionTests.lineSegmentPlane(t,i,r,a),{positions:[e,t,i,n,a],indices:[0,1,4,0,4,3,2,3,4]}}},Plane.fromPointNormal=function(e,t,i){var r=-Cartesian3.dot(t,e);return defined(i)?(Cartesian3.clone(t,i.normal),i.distance=r,i):new Plane(t,r)};var scratchNormal=new Cartesian3;Plane.fromCartesian4=function(e,t){var i=Cartesian3.fromCartesian4(e,scratchNormal),r=e.w;return defined(t)?(Cartesian3.clone(i,t.normal),t.distance=r,t):new Plane(i,r)},Plane.getPointDistance=function(e,t){return Cartesian3.dot(e.normal,t)+e.distance};var scratchCartesian$1=new Cartesian3;Plane.projectPointOntoPlane=function(e,t,i){defined(i)||(i=new Cartesian3);var r=Plane.getPointDistance(e,t),n=Cartesian3.multiplyByScalar(e.normal,r,scratchCartesian$1);return Cartesian3.subtract(t,n,i)};var scratchPosition=new Cartesian3;function binarySearch(e,t,i){for(var r,n,a=0,o=e.length-1;a<=o;)if((n=i(e[r=~~((a+o)/2)],t))<0)a=1+r;else{if(!(0<n))return r;o=r-1}return~(o+1)}function EarthOrientationParametersSample(e,t,i,r,n){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=i,this.yPoleOffset=r,this.ut1MinusUtc=n}function sprintf(){function v(e,t,i,r){i=i||" ";var n=e.length>=t?"":Array(1+t-e.length>>>0).join(i);return r?e+n:n+e}function C(e,t,i,r,n,a){var o=r-e.length;return 0<o&&(e=i||!n?v(e,r,a,i):e.slice(0,t.length)+v("",o,"0",!0)+e.slice(t.length)),e}function S(e,t,i,r,n,a,o){var s=e>>>0;return e=(i=i&&s&&{2:"0b",8:"0",16:"0x"}[t]||"")+v(s.toString(t),a||0,"0",!1),C(e,i,r,n,o)}function T(e,t,i,r,n,a){return null!=r&&(e=e.slice(0,r)),C(e,"",t,i,n,a)}var x=arguments,b=0,e=x[b++];return e.replace(/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,function(e,t,i,r,n,a,o){var s,l,c,u,d;if("%%"==e)return"%";for(var h=!1,p="",m=!1,f=!1,g=" ",_=i.length,y=0;i&&y<_;y++)switch(i.charAt(y)){case" ":p=" ";break;case"+":p="+";break;case"-":h=!0;break;case"'":g=i.charAt(y+1);break;case"0":m=!0;break;case"#":f=!0}if((r=r?"*"==r?+x[b++]:"*"==r.charAt(0)?+x[r.slice(1,-1)]:+r:0)<0&&(r=-r,h=!0),!isFinite(r))throw new Error("sprintf: (minimum-)width must be finite");switch(a=a?"*"==a?+x[b++]:"*"==a.charAt(0)?+x[a.slice(1,-1)]:+a:-1<"fFeE".indexOf(o)?6:"d"==o?0:void 0,d=t?x[t.slice(0,-1)]:x[b++],o){case"s":return T(String(d),h,r,a,m,g);case"c":return T(String.fromCharCode(+d),h,r,a,m);case"b":return S(d,2,f,h,r,a,m);case"o":return S(d,8,f,h,r,a,m);case"x":return S(d,16,f,h,r,a,m);case"X":return S(d,16,f,h,r,a,m).toUpperCase();case"u":return S(d,10,f,h,r,a,m);case"i":case"d":return s=+d||0,d=(l=(s=Math.round(s-s%1))<0?"-":p)+v(String(Math.abs(s)),a,"0",!1),C(d,l,h,r,m);case"e":case"E":case"f":case"F":case"g":case"G":return l=(s=+d)<0?"-":p,c=["toExponential","toFixed","toPrecision"]["efg".indexOf(o.toLowerCase())],u=["toString","toUpperCase"]["eEfFgG".indexOf(o)%2],d=l+Math.abs(s)[c](a),C(d,l,h,r,m)[u]();default:return e}})}function GregorianDate(e,t,i,r,n,a,o,s){this.year=e,this.month=t,this.day=i,this.hour=r,this.minute=n,this.second=a,this.millisecond=o,this.isLeapSecond=s}function isLeapYear(e){return e%4==0&&e%100!=0||e%400==0}function LeapSecond(e,t){this.julianDate=e,this.offset=t}Plane.transform=function(e,t,i){return Matrix4.multiplyByPointAsVector(t,e.normal,scratchNormal),Cartesian3.normalize(scratchNormal,scratchNormal),Cartesian3.multiplyByScalar(e.normal,-e.distance,scratchPosition),Matrix4.multiplyByPoint(t,scratchPosition,scratchPosition),Plane.fromPointNormal(scratchPosition,scratchNormal,i)},Plane.clone=function(e,t){return defined(t)?(Cartesian3.clone(e.normal,t.normal),t.distance=e.distance,t):new Plane(e.normal,e.distance)},Plane.equals=function(e,t){return e.distance===t.distance&&Cartesian3.equals(e.normal,t.normal)},Plane.ORIGIN_XY_PLANE=freezeObject$1(new Plane(Cartesian3.UNIT_Z,0)),Plane.ORIGIN_YZ_PLANE=freezeObject$1(new Plane(Cartesian3.UNIT_X,0)),Plane.ORIGIN_ZX_PLANE=freezeObject$1(new Plane(Cartesian3.UNIT_Y,0));var TimeConstants={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5},TimeConstants$1=freezeObject$1(TimeConstants),TimeStandard={UTC:0,TAI:1},TimeStandard$1=freezeObject$1(TimeStandard),gregorianDateScratch=new GregorianDate,daysInMonth=[31,28,31,30,31,30,31,31,30,31,30,31],daysInLeapFeburary=29;function compareLeapSecondDates(e,t){return JulianDate.compare(e.julianDate,t.julianDate)}var binarySearchScratchLeapSecond=new LeapSecond;function convertUtcToTai(e){binarySearchScratchLeapSecond.julianDate=e;var t=JulianDate.leapSeconds,i=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates);i<0&&(i=~i),i>=t.length&&(i=t.length-1);var r=t[i].offset;0<i&&r<JulianDate.secondsDifference(t[i].julianDate,e)&&(r=t[--i].offset);JulianDate.addSeconds(e,r,e)}function convertTaiToUtc(e,t){binarySearchScratchLeapSecond.julianDate=e;var i=JulianDate.leapSeconds,r=binarySearch(i,binarySearchScratchLeapSecond,compareLeapSecondDates);if(r<0&&(r=~r),0===r)return JulianDate.addSeconds(e,-i[0].offset,t);if(r>=i.length)return JulianDate.addSeconds(e,-i[r-1].offset,t);var n=JulianDate.secondsDifference(i[r].julianDate,e);return 0===n?JulianDate.addSeconds(e,-i[r].offset,t):n<=1?void 0:JulianDate.addSeconds(e,-i[--r].offset,t)}function setComponents(e,t,i){var r=t/TimeConstants$1.SECONDS_PER_DAY|0;return e+=r,(t-=TimeConstants$1.SECONDS_PER_DAY*r)<0&&(e--,t+=TimeConstants$1.SECONDS_PER_DAY),i.dayNumber=e,i.secondsOfDay=t,i}function computeJulianDateComponents(e,t,i,r,n,a,o){var s=(t-14)/12|0,l=e+4800+s,c=(1461*l/4|0)+(367*(t-2-12*s)/12|0)-(3*((l+100)/100|0)/4|0)+i-32075;(r-=12)<0&&(r+=24);var u=a+(r*TimeConstants$1.SECONDS_PER_HOUR+n*TimeConstants$1.SECONDS_PER_MINUTE+o*TimeConstants$1.SECONDS_PER_MILLISECOND);return 43200<=u&&(c-=1),[c,u]}var matchCalendarYear=/^(\d{4})$/,matchCalendarMonth=/^(\d{4})-(\d{2})$/,matchOrdinalDate=/^(\d{4})-?(\d{3})$/,matchWeekDate=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,matchCalendarDate=/^(\d{4})-?(\d{2})-?(\d{2})$/,utcOffset=/([Z+\-])?(\d{2})?:?(\d{2})?$/,matchHours=/^(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutes=/^(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutesSeconds=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source;function JulianDate(e,t,i){this.dayNumber=void 0,this.secondsOfDay=void 0,e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,TimeStandard$1.UTC);var r=0|e;setComponents(r,t+=(e-r)*TimeConstants$1.SECONDS_PER_DAY,this),i===TimeStandard$1.UTC&&convertUtcToTai(this)}JulianDate.fromGregorianDate=function(e,t){var i=computeJulianDateComponents(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return defined(t)?(setComponents(i[0],i[1],t),convertUtcToTai(t),t):new JulianDate(i[0],i[1],TimeStandard$1.UTC)},JulianDate.fromDate=function(e,t){var i=computeJulianDateComponents(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return defined(t)?(setComponents(i[0],i[1],t),convertUtcToTai(t),t):new JulianDate(i[0],i[1],TimeStandard$1.UTC)},JulianDate.fromIso8601=function(e,t){var i,r,n,a,o=(e=e.replace(",",".")).split("T"),s=1,l=1,c=0,u=0,d=0,h=0,p=o[0],m=o[1];if(null!==(o=p.match(matchCalendarDate)))i=+o[1],s=+o[2],l=+o[3];else if(null!==(o=p.match(matchCalendarMonth)))i=+o[1],s=+o[2];else if(null!==(o=p.match(matchCalendarYear)))i=+o[1];else{var f;if(null!==(o=p.match(matchOrdinalDate)))i=+o[1],f=+o[2],n=isLeapYear(i);else if(null!==(o=p.match(matchWeekDate)))i=+o[1],f=7*+o[2]+(+o[3]||0)-new Date(Date.UTC(i,0,4)).getUTCDay()-3;(r=new Date(Date.UTC(i,0,1))).setUTCDate(f),s=r.getUTCMonth()+1,l=r.getUTCDate()}if(n=isLeapYear(i),defined(m)){null!==(o=m.match(matchHoursMinutesSeconds))?(c=+o[1],u=+o[2],d=+o[3],h=1e3*(o[4]||0),a=5):null!==(o=m.match(matchHoursMinutes))?(c=+o[1],u=+o[2],d=60*(o[3]||0),a=4):null!==(o=m.match(matchHours))&&(c=+o[1],u=60*(o[2]||0),a=3);var g=o[a],_=+o[a+1],y=+(o[a+2]||0);switch(g){case"+":c-=_,u-=y;break;case"-":c+=_,u+=y;break;case"Z":break;default:u+=new Date(Date.UTC(i,s-1,l,c,u)).getTimezoneOffset()}}var v=60===d;for(v&&d--;60<=u;)u-=60,c++;for(;24<=c;)c-=24,l++;for(r=n&&2===s?daysInLeapFeburary:daysInMonth[s-1];r<l;)l-=r,12<++s&&(s-=12,i++),r=n&&2===s?daysInLeapFeburary:daysInMonth[s-1];for(;u<0;)u+=60,c--;for(;c<0;)c+=24,l--;for(;l<1;)--s<1&&(s+=12,i--),l+=r=n&&2===s?daysInLeapFeburary:daysInMonth[s-1];var C=computeJulianDateComponents(i,s,l,c,u,d,h);return defined(t)?(setComponents(C[0],C[1],t),convertUtcToTai(t)):t=new JulianDate(C[0],C[1],TimeStandard$1.UTC),v&&JulianDate.addSeconds(t,1,t),t},JulianDate.now=function(e){return JulianDate.fromDate(new Date,e)};var toGregorianDateScratch=new JulianDate(0,0,TimeStandard$1.TAI);function EarthOrientationParameters(e){if(e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=defaultValue(e.addNewLeapSeconds,!0),defined(e.data))onDataReady(this,e.data);else if(defined(e.url)){var t=Resource.createIfNeeded(e.url),i=this;this._downloadPromise=when(t.fetchJson(),function(e){onDataReady(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else onDataReady(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function compareLeapSecondDates$1(e,t){return JulianDate.compare(e.julianDate,t)}function onDataReady(e,t){if(defined(t.columnNames))if(defined(t.samples)){var i=t.columnNames.indexOf("modifiedJulianDateUtc"),r=t.columnNames.indexOf("xPoleWanderRadians"),n=t.columnNames.indexOf("yPoleWanderRadians"),a=t.columnNames.indexOf("ut1MinusUtcSeconds"),o=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),s=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),l=t.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||r<0||n<0||a<0||o<0||s<0||l<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var c,u=e._samples=t.samples,d=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=r,e._yPoleWanderRadiansColumn=n,e._ut1MinusUtcSecondsColumn=a,e._xCelestialPoleOffsetRadiansColumn=o,e._yCelestialPoleOffsetRadiansColumn=s,e._taiMinusUtcSecondsColumn=l,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var h=e._addNewLeapSeconds,p=0,m=u.length;p<m;p+=e._columnCount){var f=u[p+i],g=u[p+l],_=new JulianDate(f+TimeConstants$1.MODIFIED_JULIAN_DATE_DIFFERENCE,g,TimeStandard$1.TAI);if(d.push(_),h){if(g!==c&&defined(c)){var y=JulianDate.leapSeconds,v=binarySearch(y,_,compareLeapSecondDates$1);if(v<0){var C=new LeapSecond(_,g);y.splice(~v,0,C)}}c=g}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function fillResultFromIndex(e,t,i,r,n){var a=i*r;n.xPoleWander=t[a+e._xPoleWanderRadiansColumn],n.yPoleWander=t[a+e._yPoleWanderRadiansColumn],n.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],n.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],n.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function linearInterp(e,t,i){return t+e*(i-t)}function interpolate(e,t,i,r,n,a,o){var s=e._columnCount;if(a>t.length-1)return o.xPoleWander=0,o.yPoleWander=0,o.xPoleOffset=0,o.yPoleOffset=0,o.ut1MinusUtc=0,o;var l=t[n],c=t[a];if(l.equals(c)||r.equals(l))return fillResultFromIndex(e,i,n,s,o),o;if(r.equals(c))return fillResultFromIndex(e,i,a,s,o),o;var u=JulianDate.secondsDifference(r,l)/JulianDate.secondsDifference(c,l),d=n*s,h=a*s,p=i[d+e._ut1MinusUtcSecondsColumn],m=i[h+e._ut1MinusUtcSecondsColumn],f=m-p;if(.5<f||f<-.5){var g=i[d+e._taiMinusUtcSecondsColumn],_=i[h+e._taiMinusUtcSecondsColumn];g!==_&&(c.equals(r)?p=m:m-=_-g)}return o.xPoleWander=linearInterp(u,i[d+e._xPoleWanderRadiansColumn],i[h+e._xPoleWanderRadiansColumn]),o.yPoleWander=linearInterp(u,i[d+e._yPoleWanderRadiansColumn],i[h+e._yPoleWanderRadiansColumn]),o.xPoleOffset=linearInterp(u,i[d+e._xCelestialPoleOffsetRadiansColumn],i[h+e._xCelestialPoleOffsetRadiansColumn]),o.yPoleOffset=linearInterp(u,i[d+e._yCelestialPoleOffsetRadiansColumn],i[h+e._yCelestialPoleOffsetRadiansColumn]),o.ut1MinusUtc=linearInterp(u,p,m),o}function HeadingPitchRoll(e,t,i){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.roll=defaultValue(i,0)}function Iau2006XysSample(e,t,i){this.x=e,this.y=t,this.s=i}function Iau2006XysData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._xysFileUrlTemplate=Resource.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=defaultValue(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=defaultValue(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new JulianDate(this._sampleZeroJulianEphemerisDate,0,TimeStandard$1.TAI),this._stepSizeDays=defaultValue(e.stepSizeDays,1),this._samplesPerXysFile=defaultValue(e.samplesPerXysFile,1e3),this._totalSamples=defaultValue(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,i=this._denominators=new Array(t+1),r=this._xTable=new Array(t+1),n=Math.pow(this._stepSizeDays,t),a=0;a<=t;++a){i[a]=n,r[a]=a*this._stepSizeDays;for(var o=0;o<=t;++o)o!==a&&(i[a]*=a-o);i[a]=1/i[a]}this._work=new Array(t+1),this._coef=new Array(t+1)}JulianDate.toGregorianDate=function(e,t){var i=!1,r=convertTaiToUtc(e,toGregorianDateScratch);defined(r)||(JulianDate.addSeconds(e,-1,toGregorianDateScratch),r=convertTaiToUtc(toGregorianDateScratch,toGregorianDateScratch),i=!0);var n=r.dayNumber,a=r.secondsOfDay;43200<=a&&(n+=1);var o=n+68569|0,s=4*o/146097|0,l=4e3*((o=o-((146097*s+3)/4|0)|0)+1)/1461001|0,c=80*(o=o-(1461*l/4|0)+31|0)/2447|0,u=o-(2447*c/80|0)|0,d=2+c-12*(o=c/11|0)|0,h=100*(s-49)+l+o|0,p=a/TimeConstants$1.SECONDS_PER_HOUR|0,m=a-p*TimeConstants$1.SECONDS_PER_HOUR,f=m/TimeConstants$1.SECONDS_PER_MINUTE|0,g=0|(m-=f*TimeConstants$1.SECONDS_PER_MINUTE),_=(m-g)/TimeConstants$1.SECONDS_PER_MILLISECOND;return 23<(p+=12)&&(p-=24),i&&(g+=1),defined(t)?(t.year=h,t.month=d,t.day=u,t.hour=p,t.minute=f,t.second=g,t.millisecond=_,t.isLeapSecond=i,t):new GregorianDate(h,d,u,p,f,g,_,i)},JulianDate.toDate=function(e){var t=JulianDate.toGregorianDate(e,gregorianDateScratch),i=t.second;return t.isLeapSecond&&(i-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,i,t.millisecond))},JulianDate.toIso8601=function(e,t){var i=JulianDate.toGregorianDate(e,gregorianDateScratch),r=i.year,n=i.month,a=i.day,o=i.hour,s=i.minute,l=i.second,c=i.millisecond;return 1e4===r&&1===n&&1===a&&0===o&&0===s&&0===l&&0===c&&(r=9999,n=12,a=31,o=24),defined(t)||0===c?defined(t)&&0!==t?sprintf("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",r,n,a,o,s,l,(.01*c).toFixed(t).replace(".","").slice(0,t)):sprintf("%04d-%02d-%02dT%02d:%02d:%02dZ",r,n,a,o,s,l):sprintf("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",r,n,a,o,s,l,(.01*c).toString().replace(".",""))},JulianDate.clone=function(e,t){if(defined(e))return defined(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new JulianDate(e.dayNumber,e.secondsOfDay,TimeStandard$1.TAI)},JulianDate.compare=function(e,t){var i=e.dayNumber-t.dayNumber;return 0!=i?i:e.secondsOfDay-t.secondsOfDay},JulianDate.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},JulianDate.equalsEpsilon=function(e,t,i){return e===t||defined(e)&&defined(t)&&Math.abs(JulianDate.secondsDifference(e,t))<=i},JulianDate.totalDays=function(e){return e.dayNumber+e.secondsOfDay/TimeConstants$1.SECONDS_PER_DAY},JulianDate.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*TimeConstants$1.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},JulianDate.daysDifference=function(e,t){return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY},JulianDate.computeTaiMinusUtc=function(e){binarySearchScratchLeapSecond.julianDate=e;var t=JulianDate.leapSeconds,i=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates);return i<0&&(i=~i,--i<0&&(i=0)),t[i].offset},JulianDate.addSeconds=function(e,t,i){return setComponents(e.dayNumber,e.secondsOfDay+t,i)},JulianDate.addMinutes=function(e,t,i){var r=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_MINUTE;return setComponents(e.dayNumber,r,i)},JulianDate.addHours=function(e,t,i){var r=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_HOUR;return setComponents(e.dayNumber,r,i)},JulianDate.addDays=function(e,t,i){return setComponents(e.dayNumber+t,e.secondsOfDay,i)},JulianDate.lessThan=function(e,t){return JulianDate.compare(e,t)<0},JulianDate.lessThanOrEquals=function(e,t){return JulianDate.compare(e,t)<=0},JulianDate.greaterThan=function(e,t){return 0<JulianDate.compare(e,t)},JulianDate.greaterThanOrEquals=function(e,t){return 0<=JulianDate.compare(e,t)},JulianDate.prototype.clone=function(e){return JulianDate.clone(this,e)},JulianDate.prototype.equals=function(e){return JulianDate.equals(this,e)},JulianDate.prototype.equalsEpsilon=function(e,t){return JulianDate.equalsEpsilon(this,e,t)},JulianDate.prototype.toString=function(){return JulianDate.toIso8601(this)},JulianDate.leapSeconds=[new LeapSecond(new JulianDate(2441317,43210,TimeStandard$1.TAI),10),new LeapSecond(new JulianDate(2441499,43211,TimeStandard$1.TAI),11),new LeapSecond(new JulianDate(2441683,43212,TimeStandard$1.TAI),12),new LeapSecond(new JulianDate(2442048,43213,TimeStandard$1.TAI),13),new LeapSecond(new JulianDate(2442413,43214,TimeStandard$1.TAI),14),new LeapSecond(new JulianDate(2442778,43215,TimeStandard$1.TAI),15),new LeapSecond(new JulianDate(2443144,43216,TimeStandard$1.TAI),16),new LeapSecond(new JulianDate(2443509,43217,TimeStandard$1.TAI),17),new LeapSecond(new JulianDate(2443874,43218,TimeStandard$1.TAI),18),new LeapSecond(new JulianDate(2444239,43219,TimeStandard$1.TAI),19),new LeapSecond(new JulianDate(2444786,43220,TimeStandard$1.TAI),20),new LeapSecond(new JulianDate(2445151,43221,TimeStandard$1.TAI),21),new LeapSecond(new JulianDate(2445516,43222,TimeStandard$1.TAI),22),new LeapSecond(new JulianDate(2446247,43223,TimeStandard$1.TAI),23),new LeapSecond(new JulianDate(2447161,43224,TimeStandard$1.TAI),24),new LeapSecond(new JulianDate(2447892,43225,TimeStandard$1.TAI),25),new LeapSecond(new JulianDate(2448257,43226,TimeStandard$1.TAI),26),new LeapSecond(new JulianDate(2448804,43227,TimeStandard$1.TAI),27),new LeapSecond(new JulianDate(2449169,43228,TimeStandard$1.TAI),28),new LeapSecond(new JulianDate(2449534,43229,TimeStandard$1.TAI),29),new LeapSecond(new JulianDate(2450083,43230,TimeStandard$1.TAI),30),new LeapSecond(new JulianDate(2450630,43231,TimeStandard$1.TAI),31),new LeapSecond(new JulianDate(2451179,43232,TimeStandard$1.TAI),32),new LeapSecond(new JulianDate(2453736,43233,TimeStandard$1.TAI),33),new LeapSecond(new JulianDate(2454832,43234,TimeStandard$1.TAI),34),new LeapSecond(new JulianDate(2456109,43235,TimeStandard$1.TAI),35),new LeapSecond(new JulianDate(2457204,43236,TimeStandard$1.TAI),36),new LeapSecond(new JulianDate(2457754,43237,TimeStandard$1.TAI),37)],EarthOrientationParameters.NONE=freezeObject$1({getPromiseToLoad:function(){return when()},compute:function(e,t){return defined(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new EarthOrientationParametersSample(0,0,0,0,0),t}}),EarthOrientationParameters.prototype.getPromiseToLoad=function(){return when(this._downloadPromise)},EarthOrientationParameters.prototype.compute=function(e,t){if(defined(this._samples)){if(defined(t)||(t=new EarthOrientationParametersSample(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var i=this._dates,r=this._lastIndex,n=0,a=0;if(defined(r)){var o=i[r],s=i[r+1],l=JulianDate.lessThanOrEquals(o,e),c=!defined(s),u=c||JulianDate.greaterThanOrEquals(s,e);if(l&&u)return n=r,!c&&s.equals(e)&&++n,a=n+1,interpolate(this,i,this._samples,e,n,a,t),t}var d=binarySearch(i,e,JulianDate.compare,this._dateColumn);return 0<=d?(d<i.length-1&&i[d+1].equals(e)&&++d,a=n=d):(n=(a=~d)-1)<0&&(n=0),this._lastIndex=n,interpolate(this,i,this._samples,e,n,a,t),t}if(defined(this._dataError))throw new RuntimeError(this._dataError)},HeadingPitchRoll.fromQuaternion=function(e,t){defined(t)||(t=new HeadingPitchRoll);var i=2*(e.w*e.y-e.z*e.x),r=1-2*(e.x*e.x+e.y*e.y),n=2*(e.w*e.x+e.y*e.z),a=1-2*(e.y*e.y+e.z*e.z),o=2*(e.w*e.z+e.x*e.y);return t.heading=-Math.atan2(o,a),t.roll=Math.atan2(n,r),t.pitch=-CesiumMath.asinClamped(i),t},HeadingPitchRoll.fromDegrees=function(e,t,i,r){return defined(r)||(r=new HeadingPitchRoll),r.heading=e*CesiumMath.RADIANS_PER_DEGREE,r.pitch=t*CesiumMath.RADIANS_PER_DEGREE,r.roll=i*CesiumMath.RADIANS_PER_DEGREE,r},HeadingPitchRoll.clone=function(e,t){if(defined(e))return defined(t)?(t.heading=e.heading,t.pitch=e.pitch,t.roll=e.roll,t):new HeadingPitchRoll(e.heading,e.pitch,e.roll)},HeadingPitchRoll.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.heading===t.heading&&e.pitch===t.pitch&&e.roll===t.roll},HeadingPitchRoll.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.heading,t.heading,i,r)&&CesiumMath.equalsEpsilon(e.pitch,t.pitch,i,r)&&CesiumMath.equalsEpsilon(e.roll,t.roll,i,r)},HeadingPitchRoll.prototype.clone=function(e){return HeadingPitchRoll.clone(this,e)},HeadingPitchRoll.prototype.equals=function(e){return HeadingPitchRoll.equals(this,e)},HeadingPitchRoll.prototype.equalsEpsilon=function(e,t,i){return HeadingPitchRoll.equalsEpsilon(this,e,t,i)},HeadingPitchRoll.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"};var julianDateScratch=new JulianDate(0,0,TimeStandard$1.TAI),_supportsFullscreen;function getDaysSinceEpoch(e,t,i){var r=julianDateScratch;return r.dayNumber=t,r.secondsOfDay=i,JulianDate.daysDifference(r,e._sampleZeroDateTT)}function requestXysChunk(o,s){if(o._chunkDownloadsInProgress[s])return o._chunkDownloadsInProgress[s];var l=when.defer();o._chunkDownloadsInProgress[s]=l;var e=o._xysFileUrlTemplate;return when((defined(e)?e.getDerivedResource({templateValues:{0:s}}):new Resource({url:buildModuleUrl("Assets/IAU2006_XYS/IAU2006_XYS_"+s+".json")})).fetchJson(),function(e){o._chunkDownloadsInProgress[s]=!1;for(var t=o._samples,i=e.samples,r=s*o._samplesPerXysFile*3,n=0,a=i.length;n<a;++n)t[r+n]=i[n];l.resolve()}),l.promise}Iau2006XysData.prototype.preload=function(e,t,i,r){var n=getDaysSinceEpoch(this,e,t),a=getDaysSinceEpoch(this,i,r),o=n/this._stepSizeDays-this._interpolationOrder/2|0;o<0&&(o=0);var s=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var l=o/this._samplesPerXysFile|0,c=s/this._samplesPerXysFile|0,u=[],d=l;d<=c;++d)u.push(requestXysChunk(this,d));return when.all(u)},Iau2006XysData.prototype.computeXysRadians=function(e,t,i){var r=getDaysSinceEpoch(this,e,t);if(!(r<0)){var n=r/this._stepSizeDays|0;if(!(n>=this._totalSamples)){var a=this._interpolationOrder,o=n-(a/2|0);o<0&&(o=0);var s=o+a;s>=this._totalSamples&&(o=(s=this._totalSamples-1)-a)<0&&(o=0);var l=!1,c=this._samples;if(defined(c[3*o])||(requestXysChunk(this,o/this._samplesPerXysFile|0),l=!0),defined(c[3*s])||(requestXysChunk(this,s/this._samplesPerXysFile|0),l=!0),!l){defined(i)?(i.x=0,i.y=0,i.s=0):i=new Iau2006XysSample(0,0,0);var u,d,h=r-o*this._stepSizeDays,p=this._work,m=this._denominators,f=this._coef,g=this._xTable;for(u=0;u<=a;++u)p[u]=h-g[u];for(u=0;u<=a;++u){for(f[u]=1,d=0;d<=a;++d)d!==u&&(f[u]*=p[d]);f[u]*=m[u];var _=3*(o+u);i.x+=f[u]*c[_++],i.y+=f[u]*c[_++],i.s+=f[u]*c[_]}return i}}}};var _names={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},Fullscreen={},theNavigator,isChromeResult,chromeVersionResult,isSafariResult,safariVersionResult,isWebkitResult,webkitVersionResult,isInternetExplorerResult,internetExplorerVersionResult,isEdgeResult,edgeVersionResult,isFirefoxResult,firefoxVersionResult,isWindowsResult,hasPointerEvents,imageRenderingValueResult,supportsImageRenderingPixelatedResult;function extractVersion(e){for(var t=e.split("."),i=0,r=t.length;i<r;++i)t[i]=parseInt(t[i],10);return t}function isChrome(){if(!defined(isChromeResult)&&(isChromeResult=!1,!isEdge())){var e=/ Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isChromeResult=!0,chromeVersionResult=extractVersion(e[1]))}return isChromeResult}function chromeVersion(){return isChrome()&&chromeVersionResult}function isSafari(){if(!defined(isSafariResult)&&(isSafariResult=!1,!isChrome()&&!isEdge()&&/ Safari\/[\.0-9]+/.test(theNavigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isSafariResult=!0,safariVersionResult=extractVersion(e[1]))}return isSafariResult}function safariVersion(){return isSafari()&&safariVersionResult}function isWebkit(){if(!defined(isWebkitResult)){isWebkitResult=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent);null!==e&&(isWebkitResult=!0,(webkitVersionResult=extractVersion(e[1])).isNightly=!!e[2])}return isWebkitResult}function webkitVersion(){return isWebkit()&&webkitVersionResult}function isInternetExplorer(){var e;defined(isInternetExplorerResult)||(isInternetExplorerResult=!1,"Microsoft Internet Explorer"===theNavigator.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent))&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1])):"Netscape"===theNavigator.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent))&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1])));return isInternetExplorerResult}function internetExplorerVersion(){return isInternetExplorer()&&internetExplorerVersionResult}function isEdge(){if(!defined(isEdgeResult)){isEdgeResult=!1;var e=/ Edge\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isEdgeResult=!0,edgeVersionResult=extractVersion(e[1]))}return isEdgeResult}function edgeVersion(){return isEdge()&&edgeVersionResult}function isFirefox(){if(!defined(isFirefoxResult)){isFirefoxResult=!1;var e=/Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isFirefoxResult=!0,firefoxVersionResult=extractVersion(e[1]))}return isFirefoxResult}function isWindows(){return defined(isWindowsResult)||(isWindowsResult=/Windows/i.test(theNavigator.appVersion)),isWindowsResult}function firefoxVersion(){return isFirefox()&&firefoxVersionResult}function supportsPointerEvents(){return defined(hasPointerEvents)||(hasPointerEvents=!isFirefox()&&"undefined"!=typeof PointerEvent&&(!defined(theNavigator.pointerEnabled)||theNavigator.pointerEnabled)),hasPointerEvents}function supportsImageRenderingPixelated(){if(!defined(supportsImageRenderingPixelatedResult)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var t=e.style.imageRendering;(supportsImageRenderingPixelatedResult=defined(t)&&""!==t)&&(imageRenderingValueResult=t)}return supportsImageRenderingPixelatedResult}function imageRenderingValue(){return supportsImageRenderingPixelated()?imageRenderingValueResult:void 0}function supportsWebP(){return supportsWebP._result}defineProperties$1(Fullscreen,{element:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenElement]}},changeEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenchange}},errorEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenerror}},enabled:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenEnabled]}},fullscreen:{get:function(){if(Fullscreen.supportsFullscreen())return null!==Fullscreen.element}}}),Fullscreen.supportsFullscreen=function(){if(defined(_supportsFullscreen))return _supportsFullscreen;_supportsFullscreen=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return _names.requestFullscreen="requestFullscreen",_names.exitFullscreen="exitFullscreen",_names.fullscreenEnabled="fullscreenEnabled",_names.fullscreenElement="fullscreenElement",_names.fullscreenchange="fullscreenchange",_names.fullscreenerror="fullscreenerror",_supportsFullscreen=!0;for(var t,i=["webkit","moz","o","ms","khtml"],r=0,n=i.length;r<n;++r){var a=i[r];"function"==typeof e[t=a+"RequestFullscreen"]?(_names.requestFullscreen=t,_supportsFullscreen=!0):"function"==typeof e[t=a+"RequestFullScreen"]&&(_names.requestFullscreen=t,_supportsFullscreen=!0),t=a+"ExitFullscreen","function"==typeof document[t]?_names.exitFullscreen=t:(t=a+"CancelFullScreen","function"==typeof document[t]&&(_names.exitFullscreen=t)),t=a+"FullscreenEnabled",void 0!==document[t]?_names.fullscreenEnabled=t:(t=a+"FullScreenEnabled",void 0!==document[t]&&(_names.fullscreenEnabled=t)),t=a+"FullscreenElement",void 0!==document[t]?_names.fullscreenElement=t:(t=a+"FullScreenElement",void 0!==document[t]&&(_names.fullscreenElement=t)),t=a+"fullscreenchange",void 0!==document["on"+t]&&("ms"===a&&(t="MSFullscreenChange"),_names.fullscreenchange=t),t=a+"fullscreenerror",void 0!==document["on"+t]&&("ms"===a&&(t="MSFullscreenError"),_names.fullscreenerror=t)}return _supportsFullscreen},Fullscreen.requestFullscreen=function(e,t){Fullscreen.supportsFullscreen()&&e[_names.requestFullscreen]({vrDisplay:t})},Fullscreen.exitFullscreen=function(){Fullscreen.supportsFullscreen()&&document[_names.exitFullscreen]()},Fullscreen._names=_names,theNavigator="undefined"!=typeof navigator?navigator:{},supportsWebP._promise=void 0,supportsWebP._result=void 0,supportsWebP.initialize=function(){if(defined(supportsWebP._promise))return supportsWebP._promise;var e=when.defer();if(supportsWebP._promise=e.promise,isEdge())return supportsWebP._result=!1,e.resolve(supportsWebP._result),e.promise;var t=new Image;return t.onload=function(){supportsWebP._result=0<t.width&&0<t.height,e.resolve(supportsWebP._result)},t.onerror=function(){supportsWebP._result=!1,e.resolve(supportsWebP._result)},t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",e.promise},defineProperties$1(supportsWebP,{initialized:{get:function(){return defined(supportsWebP._result)}}});var typedArrayTypes=[];"undefined"!=typeof ArrayBuffer&&(typedArrayTypes.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&typedArrayTypes.push(CanvasPixelArray));var FeatureDetection={isChrome:isChrome,chromeVersion:chromeVersion,isSafari:isSafari,safariVersion:safariVersion,isWebkit:isWebkit,webkitVersion:webkitVersion,isInternetExplorer:isInternetExplorer,internetExplorerVersion:internetExplorerVersion,isEdge:isEdge,edgeVersion:edgeVersion,isFirefox:isFirefox,firefoxVersion:firefoxVersion,isWindows:isWindows,hardwareConcurrency:defaultValue(theNavigator.hardwareConcurrency,3),supportsPointerEvents:supportsPointerEvents,supportsImageRenderingPixelated:supportsImageRenderingPixelated,supportsWebP:supportsWebP,imageRenderingValue:imageRenderingValue,typedArrayTypes:typedArrayTypes};function Quaternion(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0),this.w=defaultValue(r,0)}FeatureDetection.supportsFullscreen=function(){return Fullscreen.supportsFullscreen()},FeatureDetection.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},FeatureDetection.supportsWebWorkers=function(){return"undefined"!=typeof Worker},FeatureDetection.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!FeatureDetection.isEdge()};var fromAxisAngleScratch=new Cartesian3;Quaternion.fromAxisAngle=function(e,t,i){var r=t/2,n=Math.sin(r),a=(fromAxisAngleScratch=Cartesian3.normalize(e,fromAxisAngleScratch)).x*n,o=fromAxisAngleScratch.y*n,s=fromAxisAngleScratch.z*n,l=Math.cos(r);return defined(i)?(i.x=a,i.y=o,i.z=s,i.w=l,i):new Quaternion(a,o,s,l)};var fromRotationMatrixNext=[1,2,0],fromRotationMatrixQuat=new Array(3);Quaternion.fromRotationMatrix=function(e,t){var i,r,n,a,o,s=e[Matrix3.COLUMN0ROW0],l=e[Matrix3.COLUMN1ROW1],c=e[Matrix3.COLUMN2ROW2],u=s+l+c;if(0<u)o=.5*(i=Math.sqrt(u+1)),i=.5/i,r=(e[Matrix3.COLUMN1ROW2]-e[Matrix3.COLUMN2ROW1])*i,n=(e[Matrix3.COLUMN2ROW0]-e[Matrix3.COLUMN0ROW2])*i,a=(e[Matrix3.COLUMN0ROW1]-e[Matrix3.COLUMN1ROW0])*i;else{var d=fromRotationMatrixNext,h=0;s<l&&(h=1),s<c&&l<c&&(h=2);var p=d[h],m=d[p];i=Math.sqrt(e[Matrix3.getElementIndex(h,h)]-e[Matrix3.getElementIndex(p,p)]-e[Matrix3.getElementIndex(m,m)]+1);var f=fromRotationMatrixQuat;f[h]=.5*i,i=.5/i,o=(e[Matrix3.getElementIndex(m,p)]-e[Matrix3.getElementIndex(p,m)])*i,f[p]=(e[Matrix3.getElementIndex(p,h)]+e[Matrix3.getElementIndex(h,p)])*i,f[m]=(e[Matrix3.getElementIndex(m,h)]+e[Matrix3.getElementIndex(h,m)])*i,r=-f[0],n=-f[1],a=-f[2]}return defined(t)?(t.x=r,t.y=n,t.z=a,t.w=o,t):new Quaternion(r,n,a,o)};var scratchHPRQuaternion=new Quaternion,scratchHeadingQuaternion=new Quaternion,scratchPitchQuaternion=new Quaternion,scratchRollQuaternion=new Quaternion;Quaternion.fromHeadingPitchRoll=function(e,t){return scratchRollQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_X,e.roll,scratchHPRQuaternion),scratchPitchQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Y,-e.pitch,t),t=Quaternion.multiply(scratchPitchQuaternion,scratchRollQuaternion,scratchPitchQuaternion),scratchHeadingQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-e.heading,scratchHPRQuaternion),Quaternion.multiply(scratchHeadingQuaternion,t,t)};var sampledQuaternionAxis=new Cartesian3,sampledQuaternionRotation=new Cartesian3,sampledQuaternionTempQuaternion=new Quaternion,sampledQuaternionQuaternion0=new Quaternion,sampledQuaternionQuaternion0Conjugate=new Quaternion;Quaternion.packedLength=4,Quaternion.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.z,t[i]=e.w,t},Quaternion.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Quaternion),i.x=e[t],i.y=e[t+1],i.z=e[t+2],i.w=e[t+3],i},Quaternion.packedInterpolationLength=3,Quaternion.convertPackedArrayForInterpolation=function(e,t,i,r){Quaternion.unpack(e,4*i,sampledQuaternionQuaternion0Conjugate),Quaternion.conjugate(sampledQuaternionQuaternion0Conjugate,sampledQuaternionQuaternion0Conjugate);for(var n=0,a=i-t+1;n<a;n++){var o=3*n;Quaternion.unpack(e,4*(t+n),sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0Conjugate,sampledQuaternionTempQuaternion),sampledQuaternionTempQuaternion.w<0&&Quaternion.negate(sampledQuaternionTempQuaternion,sampledQuaternionTempQuaternion),Quaternion.computeAxis(sampledQuaternionTempQuaternion,sampledQuaternionAxis);var s=Quaternion.computeAngle(sampledQuaternionTempQuaternion);r[o]=sampledQuaternionAxis.x*s,r[1+o]=sampledQuaternionAxis.y*s,r[2+o]=sampledQuaternionAxis.z*s}},Quaternion.unpackInterpolationResult=function(e,t,i,r,n){defined(n)||(n=new Quaternion),Cartesian3.fromArray(e,0,sampledQuaternionRotation);var a=Cartesian3.magnitude(sampledQuaternionRotation);return Quaternion.unpack(t,4*r,sampledQuaternionQuaternion0),0===a?Quaternion.clone(Quaternion.IDENTITY,sampledQuaternionTempQuaternion):Quaternion.fromAxisAngle(sampledQuaternionRotation,a,sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0,n)},Quaternion.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Quaternion(e.x,e.y,e.z,e.w)},Quaternion.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},Quaternion.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Quaternion.magnitude=function(e){return Math.sqrt(Quaternion.magnitudeSquared(e))},Quaternion.normalize=function(e,t){var i=1/Quaternion.magnitude(e),r=e.x*i,n=e.y*i,a=e.z*i,o=e.w*i;return t.x=r,t.y=n,t.z=a,t.w=o,t},Quaternion.inverse=function(e,t){var i=Quaternion.magnitudeSquared(e);return t=Quaternion.conjugate(e,t),Quaternion.multiplyByScalar(t,1/i,t)},Quaternion.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},Quaternion.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},Quaternion.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Quaternion.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Quaternion.multiply=function(e,t,i){var r=e.x,n=e.y,a=e.z,o=e.w,s=t.x,l=t.y,c=t.z,u=t.w,d=o*s+r*u+n*c-a*l,h=o*l-r*c+n*u+a*s,p=o*c+r*l-n*s+a*u,m=o*u-r*s-n*l-a*c;return i.x=d,i.y=h,i.z=p,i.w=m,i},Quaternion.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},Quaternion.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},Quaternion.computeAxis=function(e,t){var i=e.w;if(Math.abs(i-1)<CesiumMath.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-i*i);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},Quaternion.computeAngle=function(e){return Math.abs(e.w-1)<CesiumMath.EPSILON6?0:2*Math.acos(e.w)};var lerpScratch$3=new Quaternion;Quaternion.lerp=function(e,t,i,r){return lerpScratch$3=Quaternion.multiplyByScalar(t,i,lerpScratch$3),r=Quaternion.multiplyByScalar(e,1-i,r),Quaternion.add(lerpScratch$3,r,r)};var slerpEndNegated=new Quaternion,slerpScaledP=new Quaternion,slerpScaledR=new Quaternion;Quaternion.slerp=function(e,t,i,r){var n=Quaternion.dot(e,t),a=t;if(n<0&&(n=-n,a=slerpEndNegated=Quaternion.negate(t,slerpEndNegated)),1-n<CesiumMath.EPSILON6)return Quaternion.lerp(e,a,i,r);var o=Math.acos(n);return slerpScaledP=Quaternion.multiplyByScalar(e,Math.sin((1-i)*o),slerpScaledP),slerpScaledR=Quaternion.multiplyByScalar(a,Math.sin(i*o),slerpScaledR),r=Quaternion.add(slerpScaledP,slerpScaledR,r),Quaternion.multiplyByScalar(r,1/Math.sin(o),r)},Quaternion.log=function(e,t){var i=CesiumMath.acosClamped(e.w),r=0;return 0!==i&&(r=i/Math.sin(i)),Cartesian3.multiplyByScalar(e,r,t)},Quaternion.exp=function(e,t){var i=Cartesian3.magnitude(e),r=0;return 0!==i&&(r=Math.sin(i)/i),t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t.w=Math.cos(i),t};var squadScratchCartesian0=new Cartesian3,squadScratchCartesian1=new Cartesian3,squadScratchQuaternion0=new Quaternion,squadScratchQuaternion1=new Quaternion;Quaternion.computeInnerQuadrangle=function(e,t,i,r){var n=Quaternion.conjugate(t,squadScratchQuaternion0);Quaternion.multiply(n,i,squadScratchQuaternion1);var a=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian0);Quaternion.multiply(n,e,squadScratchQuaternion1);var o=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian1);return Cartesian3.add(a,o,a),Cartesian3.multiplyByScalar(a,.25,a),Cartesian3.negate(a,a),Quaternion.exp(a,squadScratchQuaternion0),Quaternion.multiply(t,squadScratchQuaternion0,r)},Quaternion.squad=function(e,t,i,r,n,a){var o=Quaternion.slerp(e,t,n,squadScratchQuaternion0),s=Quaternion.slerp(i,r,n,squadScratchQuaternion1);return Quaternion.slerp(o,s,2*n*(1-n),a)};for(var fastSlerpScratchQuaternion=new Quaternion,opmu=1.9011074535173003,u=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],v=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bT=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bD=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],i=0;i<7;++i){var s=i+1,t=2*s+1;u[i]=1/(s*t),v[i]=s/t}u[7]=opmu/136,v[7]=8*opmu/17,Quaternion.fastSlerp=function(e,t,i,r){var n,a=Quaternion.dot(e,t);0<=a?n=1:(n=-1,a=-a);for(var o=a-1,s=1-i,l=i*i,c=s*s,d=7;0<=d;--d)bT[d]=(u[d]*l-v[d])*o,bD[d]=(u[d]*c-v[d])*o;var h=n*i*(1+bT[0]*(1+bT[1]*(1+bT[2]*(1+bT[3]*(1+bT[4]*(1+bT[5]*(1+bT[6]*(1+bT[7])))))))),p=s*(1+bD[0]*(1+bD[1]*(1+bD[2]*(1+bD[3]*(1+bD[4]*(1+bD[5]*(1+bD[6]*(1+bD[7])))))))),m=Quaternion.multiplyByScalar(e,p,fastSlerpScratchQuaternion);return Quaternion.multiplyByScalar(t,h,r),Quaternion.add(m,r,r)},Quaternion.fastSquad=function(e,t,i,r,n,a){var o=Quaternion.fastSlerp(e,t,n,squadScratchQuaternion0),s=Quaternion.fastSlerp(i,r,n,squadScratchQuaternion1);return Quaternion.fastSlerp(o,s,2*n*(1-n),a)},Quaternion.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Quaternion.equalsEpsilon=function(e,t,i){return e===t||defined(e)&&defined(t)&&Math.abs(e.x-t.x)<=i&&Math.abs(e.y-t.y)<=i&&Math.abs(e.z-t.z)<=i&&Math.abs(e.w-t.w)<=i},Quaternion.ZERO=freezeObject$1(new Quaternion(0,0,0,0)),Quaternion.IDENTITY=freezeObject$1(new Quaternion(0,0,0,1)),Quaternion.prototype.clone=function(e){return Quaternion.clone(this,e)},Quaternion.prototype.equals=function(e){return Quaternion.equals(this,e)},Quaternion.prototype.equalsEpsilon=function(e,t){return Quaternion.equalsEpsilon(this,e,t)},Quaternion.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var Transforms={},vectorProductLocalFrame={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},degeneratePositionLocalFrame={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},localFrameToFixedFrameCache={},scratchCalculateCartesian={east:new Cartesian3,north:new Cartesian3,up:new Cartesian3,west:new Cartesian3,south:new Cartesian3,down:new Cartesian3},scratchFirstCartesian=new Cartesian3,scratchSecondCartesian=new Cartesian3,scratchThirdCartesian=new Cartesian3;Transforms.localFrameToFixedFrameGenerator=function(o,s){if(!vectorProductLocalFrame.hasOwnProperty(o)||!vectorProductLocalFrame[o].hasOwnProperty(s))throw new DeveloperError("firstAxis and secondAxis must be east, north, up, west, south or down.");var e,l=vectorProductLocalFrame[o][s],t=o+s;return defined(localFrameToFixedFrameCache[t])?e=localFrameToFixedFrameCache[t]:(e=function(e,t,i){if(defined(i)||(i=new Matrix4),CesiumMath.equalsEpsilon(e.x,0,CesiumMath.EPSILON14)&&CesiumMath.equalsEpsilon(e.y,0,CesiumMath.EPSILON14)){var r=CesiumMath.sign(e.z);Cartesian3.unpack(degeneratePositionLocalFrame[o],0,scratchFirstCartesian),"east"!==o&&"west"!==o&&Cartesian3.multiplyByScalar(scratchFirstCartesian,r,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[s],0,scratchSecondCartesian),"east"!==s&&"west"!==s&&Cartesian3.multiplyByScalar(scratchSecondCartesian,r,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[l],0,scratchThirdCartesian),"east"!==l&&"west"!==l&&Cartesian3.multiplyByScalar(scratchThirdCartesian,r,scratchThirdCartesian)}else{(t=defaultValue(t,Ellipsoid.WGS84)).geodeticSurfaceNormal(e,scratchCalculateCartesian.up);var n=scratchCalculateCartesian.up,a=scratchCalculateCartesian.east;a.x=-e.y,a.y=e.x,a.z=0,Cartesian3.normalize(a,scratchCalculateCartesian.east),Cartesian3.cross(n,a,scratchCalculateCartesian.north),Cartesian3.multiplyByScalar(scratchCalculateCartesian.up,-1,scratchCalculateCartesian.down),Cartesian3.multiplyByScalar(scratchCalculateCartesian.east,-1,scratchCalculateCartesian.west),Cartesian3.multiplyByScalar(scratchCalculateCartesian.north,-1,scratchCalculateCartesian.south),scratchFirstCartesian=scratchCalculateCartesian[o],scratchSecondCartesian=scratchCalculateCartesian[s],scratchThirdCartesian=scratchCalculateCartesian[l]}return i[0]=scratchFirstCartesian.x,i[1]=scratchFirstCartesian.y,i[2]=scratchFirstCartesian.z,i[3]=0,i[4]=scratchSecondCartesian.x,i[5]=scratchSecondCartesian.y,i[6]=scratchSecondCartesian.z,i[7]=0,i[8]=scratchThirdCartesian.x,i[9]=scratchThirdCartesian.y,i[10]=scratchThirdCartesian.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},localFrameToFixedFrameCache[t]=e),e},Transforms.eastNorthUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("east","north"),Transforms.northEastDownToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","east"),Transforms.northUpEastToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","up"),Transforms.northWestUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","west");var scratchHPRQuaternion$1=new Quaternion,scratchScale$2=new Cartesian3(1,1,1),scratchHPRMatrix4=new Matrix4;Transforms.headingPitchRollToFixedFrame=function(e,t,i,r,n){r=defaultValue(r,Transforms.eastNorthUpToFixedFrame);var a=Quaternion.fromHeadingPitchRoll(t,scratchHPRQuaternion$1),o=Matrix4.fromTranslationQuaternionRotationScale(Cartesian3.ZERO,a,scratchScale$2,scratchHPRMatrix4);return n=r(e,i,n),Matrix4.multiply(n,o,n)};var scratchENUMatrix4=new Matrix4,scratchHPRMatrix3=new Matrix3;Transforms.headingPitchRollQuaternion=function(e,t,i,r,n){var a=Transforms.headingPitchRollToFixedFrame(e,t,i,r,scratchENUMatrix4),o=Matrix4.getMatrix3(a,scratchHPRMatrix3);return Quaternion.fromRotationMatrix(o,n)};var noScale=new Cartesian3(1,1,1),hprCenterScratch=new Cartesian3,ffScratch=new Matrix4,hprTransformScratch=new Matrix4,hprRotationScratch=new Matrix3,hprQuaternionScratch=new Quaternion;Transforms.fixedFrameToHeadingPitchRoll=function(e,t,i,r){t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,Transforms.eastNorthUpToFixedFrame),defined(r)||(r=new HeadingPitchRoll);var n=Matrix4.getTranslation(e,hprCenterScratch);if(Cartesian3.equals(n,Cartesian3.ZERO))return r.heading=0,r.pitch=0,r.roll=0,r;var a=Matrix4.inverseTransformation(i(n,t,ffScratch),ffScratch),o=Matrix4.setScale(e,noScale,hprTransformScratch);o=Matrix4.setTranslation(o,Cartesian3.ZERO,o),a=Matrix4.multiply(a,o,a);var s=Quaternion.fromRotationMatrix(Matrix4.getMatrix3(a,hprRotationScratch),hprQuaternionScratch);return s=Quaternion.normalize(s,s),HeadingPitchRoll.fromQuaternion(s,r)};var gmstConstant0=24110.54841,gmstConstant1=8640184.812866,gmstConstant2=.093104,gmstConstant3=-62e-7,rateCoef=11772758384668e-32,wgs84WRPrecessing=72921158553e-15,twoPiOverSecondsInDay=CesiumMath.TWO_PI/86400,dateInUtc=new JulianDate;Transforms.computeTemeToPseudoFixedMatrix=function(e,t){var i,r=(dateInUtc=JulianDate.addSeconds(e,-JulianDate.computeTaiMinusUtc(e),dateInUtc)).dayNumber,n=dateInUtc.secondsOfDay,a=r-2451545;i=43200<=n?(.5+a)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY:(a-.5)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY;var o=(gmstConstant0+i*(gmstConstant1+i*(gmstConstant2+i*gmstConstant3)))*twoPiOverSecondsInDay%CesiumMath.TWO_PI+(wgs84WRPrecessing+rateCoef*(r-2451545.5))*((n+.5*TimeConstants$1.SECONDS_PER_DAY)%TimeConstants$1.SECONDS_PER_DAY),s=Math.cos(o),l=Math.sin(o);return defined(t)?(t[0]=s,t[1]=-l,t[2]=0,t[3]=l,t[4]=s,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(s,l,0,-l,s,0,0,0,1)},Transforms.iau2006XysData=new Iau2006XysData,Transforms.earthOrientationParameters=EarthOrientationParameters.NONE;var ttMinusTai=32.184,j2000ttDays=2451545;Transforms.preloadIcrfFixed=function(e){var t=e.start.dayNumber,i=e.start.secondsOfDay+ttMinusTai,r=e.stop.dayNumber,n=e.stop.secondsOfDay+ttMinusTai,a=Transforms.iau2006XysData.preload(t,i,r,n),o=Transforms.earthOrientationParameters.getPromiseToLoad();return when.all([a,o])},Transforms.computeIcrfToFixedMatrix=function(e,t){defined(t)||(t=new Matrix3);var i=Transforms.computeFixedToIcrfMatrix(e,t);if(defined(i))return Matrix3.transpose(i,t)};var xysScratch=new Iau2006XysSample(0,0,0),eopScratch=new EarthOrientationParametersSample(0,0,0,0,0,0),rotation1Scratch=new Matrix3,rotation2Scratch=new Matrix3;Transforms.computeFixedToIcrfMatrix=function(e,t){defined(t)||(t=new Matrix3);var i=Transforms.earthOrientationParameters.compute(e,eopScratch);if(defined(i)){var r=e.dayNumber,n=e.secondsOfDay+ttMinusTai,a=Transforms.iau2006XysData.computeXysRadians(r,n,xysScratch);if(defined(a)){var o=a.x+i.xPoleOffset,s=a.y+i.yPoleOffset,l=1/(1+Math.sqrt(1-o*o-s*s)),c=rotation1Scratch;c[0]=1-l*o*o,c[3]=-l*o*s,c[6]=o,c[1]=-l*o*s,c[4]=1-l*s*s,c[7]=s,c[2]=-o,c[5]=-s,c[8]=1-l*(o*o+s*s);var u=Matrix3.fromRotationZ(-a.s,rotation2Scratch),d=Matrix3.multiply(c,u,rotation1Scratch),h=e.dayNumber-2451545,p=(e.secondsOfDay-JulianDate.computeTaiMinusUtc(e)+i.ut1MinusUtc)/TimeConstants$1.SECONDS_PER_DAY,m=.779057273264+p+.00273781191135448*(h+p);m=m%1*CesiumMath.TWO_PI;var f=Matrix3.fromRotationZ(m,rotation2Scratch),g=Matrix3.multiply(d,f,rotation1Scratch),_=Math.cos(i.xPoleWander),y=Math.cos(i.yPoleWander),v=Math.sin(i.xPoleWander),C=Math.sin(i.yPoleWander),S=r-j2000ttDays+n/TimeConstants$1.SECONDS_PER_DAY,T=-47e-6*(S/=36525)*CesiumMath.RADIANS_PER_DEGREE/3600,x=Math.cos(T),b=Math.sin(T),E=rotation2Scratch;return E[0]=_*x,E[1]=_*b,E[2]=v,E[3]=-y*b+C*v*x,E[4]=y*x+C*v*b,E[5]=-C*_,E[6]=-C*b-y*v*x,E[7]=C*x-y*v*b,E[8]=y*_,Matrix3.multiply(g,E,t)}}};var pointToWindowCoordinatesTemp=new Cartesian4;Transforms.pointToWindowCoordinates=function(e,t,i,r){return(r=Transforms.pointToGLWindowCoordinates(e,t,i,r)).y=2*t[5]-r.y,r},Transforms.pointToGLWindowCoordinates=function(e,t,i,r){defined(r)||(r=new Cartesian2);var n=pointToWindowCoordinatesTemp;return Matrix4.multiplyByVector(e,Cartesian4.fromElements(i.x,i.y,i.z,1,n),n),Cartesian4.multiplyByScalar(n,1/n.w,n),Matrix4.multiplyByVector(t,n,n),Cartesian2.fromCartesian4(n,r)};var normalScratch=new Cartesian3,rightScratch=new Cartesian3,upScratch=new Cartesian3;Transforms.rotationMatrixFromPositionVelocity=function(e,t,i,r){var n=defaultValue(i,Ellipsoid.WGS84).geodeticSurfaceNormal(e,normalScratch),a=Cartesian3.cross(t,n,rightScratch);Cartesian3.equalsEpsilon(a,Cartesian3.ZERO,CesiumMath.EPSILON6)&&(a=Cartesian3.clone(Cartesian3.UNIT_X,a));var o=Cartesian3.cross(a,t,upScratch);return Cartesian3.normalize(o,o),Cartesian3.cross(t,o,a),Cartesian3.negate(a,a),Cartesian3.normalize(a,a),defined(r)||(r=new Matrix3),r[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=a.x,r[4]=a.y,r[5]=a.z,r[6]=o.x,r[7]=o.y,r[8]=o.z,r};var swizzleMatrix=new Matrix4(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),scratchCartographic=new Cartographic,scratchCartesian3Projection=new Cartesian3,scratchCenter=new Cartesian3,scratchRotation=new Matrix3,scratchFromENU=new Matrix4,scratchToENU=new Matrix4;Transforms.basisTo2D=function(e,t,i){var r=Matrix4.getTranslation(t,scratchCenter),n=e.ellipsoid,a=n.cartesianToCartographic(r,scratchCartographic),o=e.project(a,scratchCartesian3Projection);Cartesian3.fromElements(o.z,o.x,o.y,o);var s=Transforms.eastNorthUpToFixedFrame(r,n,scratchFromENU),l=Matrix4.inverseTransformation(s,scratchToENU),c=Matrix4.getMatrix3(t,scratchRotation),u=Matrix4.multiplyByMatrix3(l,c,i);return Matrix4.multiply(swizzleMatrix,u,i),Matrix4.setTranslation(i,o,i),i},Transforms.wgs84To2DModelMatrix=function(e,t,i){var r=e.ellipsoid,n=Transforms.eastNorthUpToFixedFrame(t,r,scratchFromENU),a=Matrix4.inverseTransformation(n,scratchToENU),o=r.cartesianToCartographic(t,scratchCartographic),s=e.project(o,scratchCartesian3Projection);Cartesian3.fromElements(s.z,s.x,s.y,s);var l=Matrix4.fromTranslation(s,scratchFromENU);return Matrix4.multiply(swizzleMatrix,a,i),Matrix4.multiply(l,i,i),i};var scratchCart4=new Cartesian4;function EllipsoidTangentPlane(e,t){e=(t=defaultValue(t,Ellipsoid.WGS84)).scaleToGeodeticSurface(e);var i=Transforms.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(i,0,scratchCart4)),this._yAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(i,1,scratchCart4));var r=Cartesian3.fromCartesian4(Matrix4.getColumn(i,2,scratchCart4));this._plane=Plane.fromPointNormal(e,r)}defineProperties$1(EllipsoidTangentPlane.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var tmp=new AxisAlignedBoundingBox;EllipsoidTangentPlane.fromPoints=function(e,t){return new EllipsoidTangentPlane(AxisAlignedBoundingBox.fromPoints(e,tmp).center,t)};var scratchProjectPointOntoPlaneRay=new Ray,scratchProjectPointOntoPlaneCartesian3=new Cartesian3;EllipsoidTangentPlane.prototype.projectPointOntoPlane=function(e,t){var i=scratchProjectPointOntoPlaneRay;i.origin=e,Cartesian3.normalize(e,i.direction);var r=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3);if(defined(r)||(Cartesian3.negate(i.direction,i.direction),r=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3)),defined(r)){var n=Cartesian3.subtract(r,this._origin,r),a=Cartesian3.dot(this._xAxis,n),o=Cartesian3.dot(this._yAxis,n);return defined(t)?(t.x=a,t.y=o,t):new Cartesian2(a,o)}},EllipsoidTangentPlane.prototype.projectPointsOntoPlane=function(e,t){defined(t)||(t=[]);for(var i=0,r=e.length,n=0;n<r;n++){var a=this.projectPointOntoPlane(e[n],t[i]);defined(a)&&(t[i]=a,i++)}return t.length=i,t},EllipsoidTangentPlane.prototype.projectPointToNearestOnPlane=function(e,t){defined(t)||(t=new Cartesian2);var i=scratchProjectPointOntoPlaneRay;i.origin=e,Cartesian3.clone(this._plane.normal,i.direction);var r=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3);defined(r)||(Cartesian3.negate(i.direction,i.direction),r=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3));var n=Cartesian3.subtract(r,this._origin,r),a=Cartesian3.dot(this._xAxis,n),o=Cartesian3.dot(this._yAxis,n);return t.x=a,t.y=o,t},EllipsoidTangentPlane.prototype.projectPointsToNearestOnPlane=function(e,t){defined(t)||(t=[]);var i=e.length;t.length=i;for(var r=0;r<i;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var projectPointsOntoEllipsoidScratch=new Cartesian3;function OrientedBoundingBox(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.halfAxes=Matrix3.clone(defaultValue(t,Matrix3.ZERO))}EllipsoidTangentPlane.prototype.projectPointOntoEllipsoid=function(e,t){defined(t)||(t=new Cartesian3);var i=this._ellipsoid,r=this._origin,n=this._xAxis,a=this._yAxis,o=projectPointsOntoEllipsoidScratch;return Cartesian3.multiplyByScalar(n,e.x,o),t=Cartesian3.add(r,o,t),Cartesian3.multiplyByScalar(a,e.y,o),Cartesian3.add(t,o,t),i.scaleToGeocentricSurface(t,t),t},EllipsoidTangentPlane.prototype.projectPointsOntoEllipsoid=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;++r)t[r]=this.projectPointOntoEllipsoid(e[r],t[r]);return t},OrientedBoundingBox.packedLength=Cartesian3.packedLength+Matrix3.packedLength,OrientedBoundingBox.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e.center,t,i),Matrix3.pack(e.halfAxes,t,i+Cartesian3.packedLength),t},OrientedBoundingBox.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new OrientedBoundingBox),Cartesian3.unpack(e,t,i.center),Matrix3.unpack(e,t+Cartesian3.packedLength,i.halfAxes),i};var scratchCartesian1=new Cartesian3,scratchCartesian2=new Cartesian3,scratchCartesian3$1=new Cartesian3,scratchCartesian4=new Cartesian3,scratchCartesian5=new Cartesian3,scratchCartesian6=new Cartesian3,scratchCovarianceResult=new Matrix3,scratchEigenResult={unitary:new Matrix3,diagonal:new Matrix3};OrientedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new OrientedBoundingBox),!defined(e)||0===e.length)return t.halfAxes=Matrix3.ZERO,t.center=Cartesian3.ZERO,t;var i,r=e.length,n=Cartesian3.clone(e[0],scratchCartesian1);for(i=1;i<r;i++)Cartesian3.add(n,e[i],n);var a=1/r;Cartesian3.multiplyByScalar(n,a,n);var o,s=0,l=0,c=0,u=0,d=0,h=0;for(i=0;i<r;i++)s+=(o=Cartesian3.subtract(e[i],n,scratchCartesian2)).x*o.x,l+=o.x*o.y,c+=o.x*o.z,u+=o.y*o.y,d+=o.y*o.z,h+=o.z*o.z;s*=a,l*=a,c*=a,u*=a,d*=a,h*=a;var p=scratchCovarianceResult;p[0]=s,p[1]=l,p[2]=c,p[3]=l,p[4]=u,p[5]=d,p[6]=c,p[7]=d,p[8]=h;var m=Matrix3.computeEigenDecomposition(p,scratchEigenResult),f=Matrix3.clone(m.unitary,t.halfAxes),g=Matrix3.getColumn(f,0,scratchCartesian4),_=Matrix3.getColumn(f,1,scratchCartesian5),y=Matrix3.getColumn(f,2,scratchCartesian6),v=-Number.MAX_VALUE,C=-Number.MAX_VALUE,S=-Number.MAX_VALUE,T=Number.MAX_VALUE,x=Number.MAX_VALUE,b=Number.MAX_VALUE;for(i=0;i<r;i++)o=e[i],v=Math.max(Cartesian3.dot(g,o),v),C=Math.max(Cartesian3.dot(_,o),C),S=Math.max(Cartesian3.dot(y,o),S),T=Math.min(Cartesian3.dot(g,o),T),x=Math.min(Cartesian3.dot(_,o),x),b=Math.min(Cartesian3.dot(y,o),b);g=Cartesian3.multiplyByScalar(g,.5*(T+v),g),_=Cartesian3.multiplyByScalar(_,.5*(x+C),_),y=Cartesian3.multiplyByScalar(y,.5*(b+S),y);var E=Cartesian3.add(g,_,t.center);Cartesian3.add(E,y,E);var P=scratchCartesian3$1;return P.x=v-T,P.y=C-x,P.z=S-b,Cartesian3.multiplyByScalar(P,.5,P),Matrix3.multiplyByScale(t.halfAxes,P,t.halfAxes),t};var scratchOffset=new Cartesian3,scratchScale$3=new Cartesian3;function fromTangentPlaneExtents(e,t,i,r,n,a,o,s){defined(s)||(s=new OrientedBoundingBox);var l=s.halfAxes;Matrix3.setColumn(l,0,e.xAxis,l),Matrix3.setColumn(l,1,e.yAxis,l),Matrix3.setColumn(l,2,e.zAxis,l);var c=scratchOffset;c.x=(t+i)/2,c.y=(r+n)/2,c.z=(a+o)/2;var u=scratchScale$3;u.x=(i-t)/2,u.y=(n-r)/2,u.z=(o-a)/2;var d=s.center;return c=Matrix3.multiplyByVector(l,c,c),Cartesian3.add(e.origin,c,d),Matrix3.multiplyByScale(l,u,l),s}var scratchRectangleCenterCartographic=new Cartographic,scratchRectangleCenter=new Cartesian3,perimeterCartographicScratch=[new Cartographic,new Cartographic,new Cartographic,new Cartographic,new Cartographic,new Cartographic,new Cartographic,new Cartographic],perimeterCartesianScratch=[new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3],perimeterProjectedScratch=[new Cartesian2,new Cartesian2,new Cartesian2,new Cartesian2,new Cartesian2,new Cartesian2,new Cartesian2,new Cartesian2];OrientedBoundingBox.fromRectangle=function(e,t,i,r,n){t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,Ellipsoid.WGS84);var a=Rectangle.center(e,scratchRectangleCenterCartographic),o=new EllipsoidTangentPlane(r.cartographicToCartesian(a,scratchRectangleCenter),r),s=o.plane,l=perimeterCartographicScratch[0],c=perimeterCartographicScratch[1],u=perimeterCartographicScratch[2],d=perimeterCartographicScratch[3],h=perimeterCartographicScratch[4],p=perimeterCartographicScratch[5],m=perimeterCartographicScratch[6],f=perimeterCartographicScratch[7],g=a.longitude,_=e.south<0&&0<e.north?0:a.latitude;m.latitude=p.latitude=h.latitude=e.south,f.latitude=d.latitude=_,l.latitude=c.latitude=u.latitude=e.north,m.longitude=f.longitude=l.longitude=e.west,p.longitude=c.longitude=g,h.longitude=d.longitude=u.longitude=e.east,u.height=c.height=l.height=f.height=m.height=p.height=h.height=d.height=i,r.cartographicArrayToCartesianArray(perimeterCartographicScratch,perimeterCartesianScratch),o.projectPointsToNearestOnPlane(perimeterCartesianScratch,perimeterProjectedScratch);var y=Math.min(perimeterProjectedScratch[6].x,perimeterProjectedScratch[7].x,perimeterProjectedScratch[0].x),v=Math.max(perimeterProjectedScratch[2].x,perimeterProjectedScratch[3].x,perimeterProjectedScratch[4].x),C=Math.min(perimeterProjectedScratch[4].y,perimeterProjectedScratch[5].y,perimeterProjectedScratch[6].y),S=Math.max(perimeterProjectedScratch[0].y,perimeterProjectedScratch[1].y,perimeterProjectedScratch[2].y);return u.height=l.height=h.height=m.height=t,r.cartographicArrayToCartesianArray(perimeterCartographicScratch,perimeterCartesianScratch),fromTangentPlaneExtents(o,y,v,C,S,Math.min(Plane.getPointDistance(s,perimeterCartesianScratch[0]),Plane.getPointDistance(s,perimeterCartesianScratch[2]),Plane.getPointDistance(s,perimeterCartesianScratch[4]),Plane.getPointDistance(s,perimeterCartesianScratch[6])),i,n)},OrientedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(Cartesian3.clone(e.center,t.center),Matrix3.clone(e.halfAxes,t.halfAxes),t):new OrientedBoundingBox(e.center,e.halfAxes)},OrientedBoundingBox.intersectPlane=function(e,t){var i=e.center,r=t.normal,n=e.halfAxes,a=r.x,o=r.y,s=r.z,l=Math.abs(a*n[Matrix3.COLUMN0ROW0]+o*n[Matrix3.COLUMN0ROW1]+s*n[Matrix3.COLUMN0ROW2])+Math.abs(a*n[Matrix3.COLUMN1ROW0]+o*n[Matrix3.COLUMN1ROW1]+s*n[Matrix3.COLUMN1ROW2])+Math.abs(a*n[Matrix3.COLUMN2ROW0]+o*n[Matrix3.COLUMN2ROW1]+s*n[Matrix3.COLUMN2ROW2]),c=Cartesian3.dot(r,i)+t.distance;return c<=-l?Intersect$1.OUTSIDE:l<=c?Intersect$1.INSIDE:Intersect$1.INTERSECTING};var scratchCartesianU=new Cartesian3,scratchCartesianV=new Cartesian3,scratchCartesianW=new Cartesian3,scratchPPrime=new Cartesian3;OrientedBoundingBox.distanceSquaredTo=function(e,t){var i=Cartesian3.subtract(t,e.center,scratchOffset),r=e.halfAxes,n=Matrix3.getColumn(r,0,scratchCartesianU),a=Matrix3.getColumn(r,1,scratchCartesianV),o=Matrix3.getColumn(r,2,scratchCartesianW),s=Cartesian3.magnitude(n),l=Cartesian3.magnitude(a),c=Cartesian3.magnitude(o);Cartesian3.normalize(n,n),Cartesian3.normalize(a,a),Cartesian3.normalize(o,o);var u=scratchPPrime;u.x=Cartesian3.dot(i,n),u.y=Cartesian3.dot(i,a),u.z=Cartesian3.dot(i,o);var d,h=0;return u.x<-s?h+=(d=u.x+s)*d:u.x>s&&(h+=(d=u.x-s)*d),u.y<-l?h+=(d=u.y+l)*d:u.y>l&&(h+=(d=u.y-l)*d),u.z<-c?h+=(d=u.z+c)*d:u.z>c&&(h+=(d=u.z-c)*d),h};var scratchCorner=new Cartesian3,scratchToCenter=new Cartesian3;OrientedBoundingBox.computePlaneDistances=function(e,t,i,r){defined(r)||(r=new Interval);var n=Number.POSITIVE_INFINITY,a=Number.NEGATIVE_INFINITY,o=e.center,s=e.halfAxes,l=Matrix3.getColumn(s,0,scratchCartesianU),c=Matrix3.getColumn(s,1,scratchCartesianV),u=Matrix3.getColumn(s,2,scratchCartesianW),d=Cartesian3.add(l,c,scratchCorner);Cartesian3.add(d,u,d),Cartesian3.add(d,o,d);var h=Cartesian3.subtract(d,t,scratchToCenter),p=Cartesian3.dot(i,h);return n=Math.min(p,n),a=Math.max(p,a),Cartesian3.add(o,l,d),Cartesian3.add(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.add(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.add(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.subtract(o,l,d),Cartesian3.add(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.subtract(o,l,d),Cartesian3.add(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.subtract(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.subtract(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),r.start=n,r.stop=a,r};var scratchBoundingSphere$1=new BoundingSphere;OrientedBoundingBox.isOccluded=function(e,t){var i=BoundingSphere.fromOrientedBoundingBox(e,scratchBoundingSphere$1);return!t.isBoundingSphereVisible(i)},OrientedBoundingBox.prototype.intersectPlane=function(e){return OrientedBoundingBox.intersectPlane(this,e)},OrientedBoundingBox.prototype.distanceSquaredTo=function(e){return OrientedBoundingBox.distanceSquaredTo(this,e)},OrientedBoundingBox.prototype.computePlaneDistances=function(e,t,i){return OrientedBoundingBox.computePlaneDistances(this,e,t,i)},OrientedBoundingBox.prototype.isOccluded=function(e){return OrientedBoundingBox.isOccluded(this,e)},OrientedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Matrix3.equals(e.halfAxes,t.halfAxes)},OrientedBoundingBox.prototype.clone=function(e){return OrientedBoundingBox.clone(this,e)},OrientedBoundingBox.prototype.equals=function(e){return OrientedBoundingBox.equals(this,e)};var RIGHT_SHIFT=1/256,LEFT_SHIFT=256,AttributeCompression={octEncodeInRange:function(e,t,i){if(i.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),i.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=i.x,n=i.y;i.x=(1-Math.abs(n))*CesiumMath.signNotZero(r),i.y=(1-Math.abs(r))*CesiumMath.signNotZero(n)}return i.x=CesiumMath.toSNorm(i.x,t),i.y=CesiumMath.toSNorm(i.y,t),i},octEncode:function(e,t){return AttributeCompression.octEncodeInRange(e,255,t)}},octEncodeScratch=new Cartesian2,uint8ForceArray=new Uint8Array(1);function forceUint8(e){return uint8ForceArray[0]=e,uint8ForceArray[0]}AttributeCompression.octEncodeToCartesian4=function(e,t){return AttributeCompression.octEncodeInRange(e,65535,octEncodeScratch),t.x=forceUint8(octEncodeScratch.x*RIGHT_SHIFT),t.y=forceUint8(octEncodeScratch.x),t.z=forceUint8(octEncodeScratch.y*RIGHT_SHIFT),t.w=forceUint8(octEncodeScratch.y),t},AttributeCompression.octDecodeInRange=function(e,t,i,r){if(r.x=CesiumMath.fromSNorm(e,i),r.y=CesiumMath.fromSNorm(t,i),r.z=1-(Math.abs(r.x)+Math.abs(r.y)),r.z<0){var n=r.x;r.x=(1-Math.abs(r.y))*CesiumMath.signNotZero(n),r.y=(1-Math.abs(n))*CesiumMath.signNotZero(r.y)}return Cartesian3.normalize(r,r)},AttributeCompression.octDecode=function(e,t,i){return AttributeCompression.octDecodeInRange(e,t,255,i)},AttributeCompression.octDecodeFromCartesian4=function(e,t){var i=e.x,r=e.y,n=e.z,a=e.w,o=i*LEFT_SHIFT+r,s=n*LEFT_SHIFT+a;return AttributeCompression.octDecodeInRange(o,s,65535,t)},AttributeCompression.octPackFloat=function(e){return 256*e.x+e.y};var scratchEncodeCart2=new Cartesian2;function zigZagDecode(e){return e>>1^-(1&e)}AttributeCompression.octEncodeFloat=function(e){return AttributeCompression.octEncode(e,scratchEncodeCart2),AttributeCompression.octPackFloat(scratchEncodeCart2)},AttributeCompression.octDecodeFloat=function(e,t){var i=e/256,r=Math.floor(i),n=256*(i-r);return AttributeCompression.octDecode(r,n,t)},AttributeCompression.octPack=function(e,t,i,r){var n=AttributeCompression.octEncodeFloat(e),a=AttributeCompression.octEncodeFloat(t),o=AttributeCompression.octEncode(i,scratchEncodeCart2);return r.x=65536*o.x+n,r.y=65536*o.y+a,r},AttributeCompression.octUnpack=function(e,t,i,r){var n=e.x/65536,a=Math.floor(n),o=65536*(n-a);n=e.y/65536;var s=Math.floor(n),l=65536*(n-s);AttributeCompression.octDecodeFloat(o,t),AttributeCompression.octDecodeFloat(l,i),AttributeCompression.octDecode(a,s,r)},AttributeCompression.compressTextureCoordinates=function(e){return 4096*(4095*e.x|0)+(4095*e.y|0)},AttributeCompression.decompressTextureCoordinates=function(e,t){var i=e/4096,r=Math.floor(i);return t.x=r/4095,t.y=(e-4096*r)/4095,t},AttributeCompression.zigZagDeltaDecode=function(e,t,i){for(var r=e.length,n=0,a=0,o=0,s=0;s<r;++s)n+=zigZagDecode(e[s]),a+=zigZagDecode(t[s]),e[s]=n,t[s]=a,defined(i)&&(o+=zigZagDecode(i[s]),i[s]=o)};var WebGLConstants={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047},WebGLConstants$1=freezeObject$1(WebGLConstants),ComponentDatatype={BYTE:WebGLConstants$1.BYTE,UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,SHORT:WebGLConstants$1.SHORT,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,INT:WebGLConstants$1.INT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,DOUBLE:WebGLConstants$1.DOUBLE,getSizeInBytes:function(e){switch(e){case ComponentDatatype.BYTE:return Int8Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case ComponentDatatype.SHORT:return Int16Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case ComponentDatatype.INT:return Int32Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case ComponentDatatype.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case ComponentDatatype.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},fromTypedArray:function(e){return e instanceof Int8Array?ComponentDatatype.BYTE:e instanceof Uint8Array?ComponentDatatype.UNSIGNED_BYTE:e instanceof Int16Array?ComponentDatatype.SHORT:e instanceof Uint16Array?ComponentDatatype.UNSIGNED_SHORT:e instanceof Int32Array?ComponentDatatype.INT:e instanceof Uint32Array?ComponentDatatype.UNSIGNED_INT:e instanceof Float32Array?ComponentDatatype.FLOAT:e instanceof Float64Array?ComponentDatatype.DOUBLE:void 0},validate:function(e){return defined(e)&&(e===ComponentDatatype.BYTE||e===ComponentDatatype.UNSIGNED_BYTE||e===ComponentDatatype.SHORT||e===ComponentDatatype.UNSIGNED_SHORT||e===ComponentDatatype.INT||e===ComponentDatatype.UNSIGNED_INT||e===ComponentDatatype.FLOAT||e===ComponentDatatype.DOUBLE)},createTypedArray:function(e,t){switch(e){case ComponentDatatype.BYTE:return new Int8Array(t);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t);case ComponentDatatype.SHORT:return new Int16Array(t);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t);case ComponentDatatype.INT:return new Int32Array(t);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t);case ComponentDatatype.FLOAT:return new Float32Array(t);case ComponentDatatype.DOUBLE:return new Float64Array(t)}},createArrayBufferView:function(e,t,i,r){switch(i=defaultValue(i,0),r=defaultValue(r,(t.byteLength-i)/ComponentDatatype.getSizeInBytes(e)),e){case ComponentDatatype.BYTE:return new Int8Array(t,i,r);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t,i,r);case ComponentDatatype.SHORT:return new Int16Array(t,i,r);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t,i,r);case ComponentDatatype.INT:return new Int32Array(t,i,r);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t,i,r);case ComponentDatatype.FLOAT:return new Float32Array(t,i,r);case ComponentDatatype.DOUBLE:return new Float64Array(t,i,r)}},fromName:function(e){switch(e){case"BYTE":return ComponentDatatype.BYTE;case"UNSIGNED_BYTE":return ComponentDatatype.UNSIGNED_BYTE;case"SHORT":return ComponentDatatype.SHORT;case"UNSIGNED_SHORT":return ComponentDatatype.UNSIGNED_SHORT;case"INT":return ComponentDatatype.INT;case"UNSIGNED_INT":return ComponentDatatype.UNSIGNED_INT;case"FLOAT":return ComponentDatatype.FLOAT;case"DOUBLE":return ComponentDatatype.DOUBLE}}},ComponentDatatype$1=freezeObject$1(ComponentDatatype),TerrainQuantization={NONE:0,BITS12:1},TerrainQuantization$1=freezeObject$1(TerrainQuantization),cartesian3Scratch=new Cartesian3,cartesian3DimScratch=new Cartesian3,cartesian2Scratch=new Cartesian2,matrix4Scratch=new Matrix4,matrix4Scratch2=new Matrix4,SHIFT_LEFT_12=Math.pow(2,12);function TerrainEncoding(e,t,i,r,n,a){var o,s,l,c=TerrainQuantization$1.NONE;if(defined(e)&&defined(t)&&defined(i)&&defined(r)){var u=e.minimum,d=e.maximum,h=Cartesian3.subtract(d,u,cartesian3DimScratch),p=i-t;c=Math.max(Cartesian3.maximumComponent(h),p)<SHIFT_LEFT_12-1?TerrainQuantization$1.BITS12:TerrainQuantization$1.NONE,o=e.center,s=Matrix4.inverseTransformation(r,new Matrix4);var m=Cartesian3.negate(u,cartesian3Scratch);Matrix4.multiply(Matrix4.fromTranslation(m,matrix4Scratch),s,s);var f=cartesian3Scratch;f.x=1/h.x,f.y=1/h.y,f.z=1/h.z,Matrix4.multiply(Matrix4.fromScale(f,matrix4Scratch),s,s),l=Matrix4.clone(r),Matrix4.setTranslation(l,Cartesian3.ZERO,l),r=Matrix4.clone(r,new Matrix4);var g=Matrix4.fromTranslation(u,matrix4Scratch),_=Matrix4.fromScale(h,matrix4Scratch2),y=Matrix4.multiply(g,_,matrix4Scratch);Matrix4.multiply(r,y,r),Matrix4.multiply(l,y,l)}this.quantization=c,this.minimumHeight=t,this.maximumHeight=i,this.center=o,this.toScaledENU=s,this.fromScaledENU=r,this.matrix=l,this.hasVertexNormals=n,this.hasWebMercatorT=defaultValue(a,!1)}TerrainEncoding.prototype.encode=function(e,t,i,r,n,a,o){var s=r.x,l=r.y;if(this.quantization===TerrainQuantization$1.BITS12){(i=Matrix4.multiplyByPoint(this.toScaledENU,i,cartesian3Scratch)).x=CesiumMath.clamp(i.x,0,1),i.y=CesiumMath.clamp(i.y,0,1),i.z=CesiumMath.clamp(i.z,0,1);var c=this.maximumHeight-this.minimumHeight,u=CesiumMath.clamp((n-this.minimumHeight)/c,0,1);Cartesian2.fromElements(i.x,i.y,cartesian2Scratch);var d=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);Cartesian2.fromElements(i.z,u,cartesian2Scratch);var h=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);Cartesian2.fromElements(s,l,cartesian2Scratch);var p=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);if(e[t++]=d,e[t++]=h,e[t++]=p,this.hasWebMercatorT){Cartesian2.fromElements(o,0,cartesian2Scratch);var m=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);e[t++]=m}}else Cartesian3.subtract(i,this.center,cartesian3Scratch),e[t++]=cartesian3Scratch.x,e[t++]=cartesian3Scratch.y,e[t++]=cartesian3Scratch.z,e[t++]=n,e[t++]=s,e[t++]=l,this.hasWebMercatorT&&(e[t++]=o);return this.hasVertexNormals&&(e[t++]=AttributeCompression.octPackFloat(a)),t},TerrainEncoding.prototype.decodePosition=function(e,t,i){if(defined(i)||(i=new Cartesian3),t*=this.getStride(),this.quantization!==TerrainQuantization$1.BITS12)return i.x=e[t],i.y=e[t+1],i.z=e[t+2],Cartesian3.add(i,this.center,i);var r=AttributeCompression.decompressTextureCoordinates(e[t],cartesian2Scratch);i.x=r.x,i.y=r.y;var n=AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch);return i.z=n.x,Matrix4.multiplyByPoint(this.fromScaledENU,i,i)},TerrainEncoding.prototype.decodeTextureCoordinates=function(e,t,i){return defined(i)||(i=new Cartesian2),t*=this.getStride(),this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+2],i):Cartesian2.fromElements(e[t+4],e[t+5],i)},TerrainEncoding.prototype.decodeHeight=function(e,t){return t*=this.getStride(),this.quantization!==TerrainQuantization$1.BITS12?e[t+3]:AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight},TerrainEncoding.prototype.decodeWebMercatorT=function(e,t){return t*=this.getStride(),this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+3],cartesian2Scratch).x:e[t+6]},TerrainEncoding.prototype.getOctEncodedNormal=function(e,t,i){var r=e[t=(t+1)*this.getStride()-1]/256,n=Math.floor(r),a=256*(r-n);return Cartesian2.fromElements(n,a,i)},TerrainEncoding.prototype.getStride=function(){var e;switch(this.quantization){case TerrainQuantization$1.BITS12:e=3;break;default:e=6}return this.hasWebMercatorT&&++e,this.hasVertexNormals&&++e,e};var attributesNone={position3DAndHeight:0,textureCoordAndEncodedNormals:1},attributes={compressed0:0,compressed1:1};function WebMercatorProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}TerrainEncoding.prototype.getAttributes=function(e){var t,i=ComponentDatatype$1.FLOAT,r=ComponentDatatype$1.getSizeInBytes(i);if(this.quantization===TerrainQuantization$1.NONE){var n=2;return this.hasWebMercatorT&&++n,this.hasVertexNormals&&++n,t=(4+n)*r,[{index:attributesNone.position3DAndHeight,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:4,offsetInBytes:0,strideInBytes:t},{index:attributesNone.textureCoordAndEncodedNormals,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:n,offsetInBytes:4*r,strideInBytes:t}]}var a=3,o=0;return(this.hasWebMercatorT||this.hasVertexNormals)&&++a,this.hasWebMercatorT&&this.hasVertexNormals?(t=(a+ ++o)*r,[{index:attributes.compressed0,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:a,offsetInBytes:0,strideInBytes:t},{index:attributes.compressed1,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:o,offsetInBytes:a*r,strideInBytes:t}]):[{index:attributes.compressed0,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:a}]},TerrainEncoding.prototype.getAttributeLocations=function(){return this.quantization===TerrainQuantization$1.NONE?attributesNone:attributes},TerrainEncoding.clone=function(e,t){return defined(t)||(t=new TerrainEncoding),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=Cartesian3.clone(e.center),t.toScaledENU=Matrix4.clone(e.toScaledENU),t.fromScaledENU=Matrix4.clone(e.fromScaledENU),t.matrix=Matrix4.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t},defineProperties$1(WebMercatorProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),WebMercatorProjection.mercatorAngleToGeodeticLatitude=function(e){return CesiumMath.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},WebMercatorProjection.geodeticLatitudeToMercatorAngle=function(e){e>WebMercatorProjection.MaximumLatitude?e=WebMercatorProjection.MaximumLatitude:e<-WebMercatorProjection.MaximumLatitude&&(e=-WebMercatorProjection.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},WebMercatorProjection.MaximumLatitude=WebMercatorProjection.mercatorAngleToGeodeticLatitude(Math.PI),WebMercatorProjection.prototype.project=function(e,t){var i=this._semimajorAxis,r=e.longitude*i,n=WebMercatorProjection.geodeticLatitudeToMercatorAngle(e.latitude)*i,a=e.height;return defined(t)?(t.x=r,t.y=n,t.z=a,t):new Cartesian3(r,n,a)},WebMercatorProjection.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,r=e.x*i,n=WebMercatorProjection.mercatorAngleToGeodeticLatitude(e.y*i),a=e.z;return defined(t)?(t.longitude=r,t.latitude=n,t.height=a,t):new Cartographic(r,n,a)};var HeightmapTessellator={};HeightmapTessellator.DEFAULT_STRUCTURE=freezeObject$1({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1});var cartesian3Scratch$1=new Cartesian3,matrix4Scratch$1=new Matrix4,minimumScratch=new Cartesian3,maximumScratch=new Cartesian3;function returnTrue(){return!0}function destroyObject(e,t){function i(){}for(var r in e)"function"==typeof e[r]&&(e[r]=i);e.isDestroyed=returnTrue}function canTransferArrayBuffer(){if(!defined(TaskProcessor._canTransferArrayBuffer)){var r=new Worker(getWorkerUrl("Workers/transferTypedArrayTest.js"));r.postMessage=defaultValue(r.webkitPostMessage,r.postMessage);var e=new Int8Array([99]);try{r.postMessage({array:e},[e.buffer])}catch(e){return TaskProcessor._canTransferArrayBuffer=!1,TaskProcessor._canTransferArrayBuffer}var n=when.defer();r.onmessage=function(e){var t=e.data.array,i=defined(t)&&99===t[0];n.resolve(i),r.terminate(),TaskProcessor._canTransferArrayBuffer=i},TaskProcessor._canTransferArrayBuffer=n.promise}return TaskProcessor._canTransferArrayBuffer}HeightmapTessellator.computeVertices=function(e){var t,i,r,n,a=Math.cos,o=Math.sin,s=Math.sqrt,l=Math.atan,c=Math.exp,u=CesiumMath.PI_OVER_TWO,d=CesiumMath.toRadians,h=e.heightmap,p=e.width,m=e.height,f=e.skirtHeight,g=defaultValue(e.isGeographic,!0),_=defaultValue(e.ellipsoid,Ellipsoid.WGS84),y=1/_.maximumRadius,v=e.nativeRectangle,C=e.rectangle;n=defined(C)?(t=C.west,i=C.south,r=C.east,C.north):g?(t=d(v.west),i=d(v.south),r=d(v.east),d(v.north)):(t=v.west*y,i=u-2*l(c(-v.south*y)),r=v.east*y,u-2*l(c(-v.north*y)));var S=e.relativeToCenter,T=defined(S);S=T?S:Cartesian3.ZERO;var x=defaultValue(e.exaggeration,1),b=defaultValue(e.includeWebMercatorT,!1),E=defaultValue(e.structure,HeightmapTessellator.DEFAULT_STRUCTURE),P=defaultValue(E.heightScale,HeightmapTessellator.DEFAULT_STRUCTURE.heightScale),A=defaultValue(E.heightOffset,HeightmapTessellator.DEFAULT_STRUCTURE.heightOffset),w=defaultValue(E.elementsPerHeight,HeightmapTessellator.DEFAULT_STRUCTURE.elementsPerHeight),D=defaultValue(E.stride,HeightmapTessellator.DEFAULT_STRUCTURE.stride),M=defaultValue(E.elementMultiplier,HeightmapTessellator.DEFAULT_STRUCTURE.elementMultiplier),I=defaultValue(E.isBigEndian,HeightmapTessellator.DEFAULT_STRUCTURE.isBigEndian),R=Rectangle.computeWidth(v),O=Rectangle.computeHeight(v),L=R/(p-1),F=O/(m-1);g||(R*=y,O*=y);var N,V,B=_.radiiSquared,k=B.x,$=B.y,z=B.z,U=65536,G=-65536,H=Transforms.eastNorthUpToFixedFrame(S,_),W=Matrix4.inverseTransformation(H,matrix4Scratch$1);b&&(N=WebMercatorProjection.geodeticLatitudeToMercatorAngle(i),V=1/(WebMercatorProjection.geodeticLatitudeToMercatorAngle(n)-N));var q=minimumScratch;q.x=Number.POSITIVE_INFINITY,q.y=Number.POSITIVE_INFINITY,q.z=Number.POSITIVE_INFINITY;var j=maximumScratch;j.x=Number.NEGATIVE_INFINITY,j.y=Number.NEGATIVE_INFINITY,j.z=Number.NEGATIVE_INFINITY;var Y=Number.POSITIVE_INFINITY,X=p+(0<f?2:0),Q=m+(0<f?2:0),J=X*Q,Z=new Array(J),K=new Array(J),ee=new Array(J),te=b?new Array(J):[],ie=0,re=m,ne=0,ae=p;0<f&&(--ie,++re,--ne,++ae);for(var oe=0,se=ie;se<re;++se){var le=se;le<0&&(le=0),m<=le&&(le=m-1);var ce,ue=v.north-F*le,de=a(ue=g?d(ue):u-2*l(c(-ue*y))),he=o(ue),pe=z*he,me=(ue-i)/(n-i);me=CesiumMath.clamp(me,0,1),b&&(ce=(WebMercatorProjection.geodeticLatitudeToMercatorAngle(ue)-N)*V);for(var fe=ne;fe<ae;++fe){var ge=fe;ge<0&&(ge=0),p<=ge&&(ge=p-1);var _e=v.west+L*ge;g?_e=d(_e):_e*=y;var ye,ve,Ce=le*(p*D)+ge*D;if(1===w)ye=h[Ce];else if(ye=0,I)for(ve=0;ve<w;++ve)ye=ye*M+h[Ce+ve];else for(ve=w-1;0<=ve;--ve)ye=ye*M+h[Ce+ve];ye=(ye*P+A)*x;var Se=(_e-t)/(r-t);if(Se=CesiumMath.clamp(Se,0,1),ee[oe]=new Cartesian2(Se,me),G=Math.max(G,ye),U=Math.min(U,ye),fe!==ge||se!==le){fe<0?_e-=1e-5*R:_e+=1e-5*R,se<0?ue+=1e-5*O:ue-=1e-5*O,de=a(ue),pe=z*(he=o(ue)),ye-=f}var Te=de*a(_e),xe=de*o(_e),be=k*Te,Ee=$*xe,Pe=1/s(be*Te+Ee*xe+pe*he),Ae=be*Pe,we=Ee*Pe,De=pe*Pe,Me=new Cartesian3;Me.x=Ae+Te*ye,Me.y=we+xe*ye,Me.z=De+he*ye,Z[oe]=Me,K[oe]=ye,b&&(te[oe]=ce),oe++,Matrix4.multiplyByPoint(W,Me,cartesian3Scratch$1),Cartesian3.minimumByComponent(cartesian3Scratch$1,q,q),Cartesian3.maximumByComponent(cartesian3Scratch$1,j,j),Y=Math.min(Y,ye)}}var Ie,Re,Oe=BoundingSphere.fromPoints(Z);defined(C)&&C.width<CesiumMath.PI_OVER_TWO+CesiumMath.EPSILON5&&(Ie=OrientedBoundingBox.fromRectangle(C,U,G,_)),T&&(Re=new EllipsoidalOccluder(_).computeHorizonCullingPoint(S,Z));for(var Le,Fe,Ne,Ve,Be=new TerrainEncoding(new AxisAlignedBoundingBox(q,j,S),Y,G,H,!1,b),ke=new Float32Array(J*Be.getStride()),$e=0,ze=0;ze<J;++ze)$e=Be.encode(ke,$e,Z[ze],ee[ze],K[ze],void 0,te[ze]);if(0<f){Ve=[],Fe=[];for(var Ue=0;Ue<p;++Ue)Ve.push(X+1+Ue),Fe.push(X*(Q-1)-2-Ue);Le=[],Ne=[];for(var Ge=0;Ge<m;++Ge)Ne.push((Ge+1)*X+p),Le.push((m-Ge)*X+1)}else{Ve=[],Fe=[];for(var He=0;He<p;++He)Ve.push(He),Fe.push(p*m-1-He);Le=[],Ne=[];for(var We=0;We<m;++We)Ne.push((We+1)*p-1),Le.push((m-We-1)*p)}return{vertices:ke,maximumHeight:G,minimumHeight:U,encoding:Be,boundingSphere3D:Oe,orientedBoundingBox:Ie,occludeePointInScaledSpace:Re,westIndicesSouthToNorth:Le,southIndicesEastToWest:Fe,eastIndicesNorthToSouth:Ne,northIndicesWestToEast:Ve}};var taskCompletedEvent=new Event,bootstrapperUrlResult;function completeTask(e,t){--e._activeTasks;var i=t.id;if(defined(i)){var r=e._deferreds,n=r[i];if(defined(t.error)){var a=t.error;"RuntimeError"===a.name?(a=new RuntimeError(t.error.message)).stack=t.error.stack:"DeveloperError"===a.name&&((a=new DeveloperError(t.error.message)).stack=t.error.stack),taskCompletedEvent.raiseEvent(a),n.reject(a)}else taskCompletedEvent.raiseEvent(),n.resolve(t.result);delete r[i]}}function getWorkerUrl(e){var t=buildModuleUrl(e);if(isCrossOriginUrl(t)){var i,r='importScripts("'+t+'");';try{i=new Blob([r],{type:"application/javascript"})}catch(e){var n=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder);n.append(r),i=n.getBlob("application/javascript")}t=(window.URL||window.webkitURL).createObjectURL(i)}return t}function getBootstrapperUrl(){return defined(bootstrapperUrlResult)||(bootstrapperUrlResult=getWorkerUrl("Workers/cesiumWorkerBootstrapper.js")),bootstrapperUrlResult}function createWorker(t){var e=new Worker(getBootstrapperUrl());e.postMessage=defaultValue(e.webkitPostMessage,e.postMessage);var i={loaderConfig:{paths:{Workers:buildModuleUrl("Workers")},baseUrl:buildModuleUrl.getCesiumBaseUrl().url},workerModule:TaskProcessor._workerModulePrefix+t._workerName};return e.postMessage(i),e.onmessage=function(e){completeTask(t,e.data)},e}function getWebAssemblyLoaderConfig(e,t){var i={modulePath:void 0,wasmBinaryFile:void 0,wasmBinary:void 0};if(FeatureDetection.supportsWebAssembly())return i.modulePath=buildModuleUrl(t.modulePath),i.wasmBinaryFile=buildModuleUrl(t.wasmBinaryFile),Resource.fetchArrayBuffer({url:i.wasmBinaryFile}).then(function(e){return i.wasmBinary=e,i});if(!defined(t.fallbackModulePath))throw new RuntimeError("This browser does not support Web Assembly, and no backup module was provided for "+e._workerName);return i.modulePath=buildModuleUrl(t.fallbackModulePath),when.resolve(i)}function TaskProcessor(e,t){this._workerName=e,this._maximumActiveTasks=defaultValue(t,5),this._activeTasks=0,this._deferreds={},this._nextID=0}var emptyTransferableObjectArray=[];function TerrainMesh(e,t,i,r,n,a,o,s,l,c,u,d,h,p,m){this.center=e,this.vertices=t,this.stride=defaultValue(s,6),this.indices=i,this.minimumHeight=r,this.maximumHeight=n,this.boundingSphere3D=a,this.occludeePointInScaledSpace=o,this.orientedBoundingBox=l,this.encoding=c,this.exaggeration=u,this.westIndicesSouthToNorth=d,this.southIndicesEastToWest=h,this.eastIndicesNorthToSouth=p,this.northIndicesWestToEast=m}function TerrainProvider(){DeveloperError.throwInstantiationError()}TaskProcessor.prototype.scheduleTask=function(r,n){if(defined(this._worker)||(this._worker=createWorker(this)),!(this._activeTasks>=this._maximumActiveTasks)){++this._activeTasks;var a=this;return when(canTransferArrayBuffer(),function(e){defined(n)?e||(n.length=0):n=emptyTransferableObjectArray;var t=a._nextID++,i=when.defer();return a._deferreds[t]=i,a._worker.postMessage({id:t,parameters:r,canTransferArrayBuffer:e},n),i.promise})}},TaskProcessor.prototype.initWebAssemblyModule=function(e){defined(this._worker)||(this._worker=createWorker(this));var n=when.defer(),a=this,o=this._worker;return getWebAssemblyLoaderConfig(this,e).then(function(r){return when(canTransferArrayBuffer(),function(e){var t,i=r.wasmBinary;defined(i)&&e&&(t=[i]),o.onmessage=function(e){o.onmessage=function(e){completeTask(a,e.data)},n.resolve(e.data)},o.postMessage({webAssemblyConfig:r},t)})}),n},TaskProcessor.prototype.isDestroyed=function(){return!1},TaskProcessor.prototype.destroy=function(){return defined(this._worker)&&this._worker.terminate(),destroyObject(this)},TaskProcessor.taskCompletedEvent=taskCompletedEvent,TaskProcessor._defaultWorkerModulePrefix="Workers/",TaskProcessor._workerModulePrefix=TaskProcessor._defaultWorkerModulePrefix,TaskProcessor._canTransferArrayBuffer=void 0,defineProperties$1(TerrainProvider.prototype,{errorEvent:{get:DeveloperError.throwInstantiationError},credit:{get:DeveloperError.throwInstantiationError},tilingScheme:{get:DeveloperError.throwInstantiationError},ready:{get:DeveloperError.throwInstantiationError},readyPromise:{get:DeveloperError.throwInstantiationError},hasWaterMask:{get:DeveloperError.throwInstantiationError},hasVertexNormals:{get:DeveloperError.throwInstantiationError},availability:{get:DeveloperError.throwInstantiationError}});var regularGridIndexArrays=[];function HeightmapTerrainData(e){this._buffer=e.buffer,this._width=e.width,this._height=e.height,this._childTileMask=defaultValue(e.childTileMask,15),this._encoding=defaultValue(e.encoding,HeightmapEncoding$1.NONE);var t=HeightmapTessellator.DEFAULT_STRUCTURE,i=e.structure;defined(i)?i!==t&&(i.heightScale=defaultValue(i.heightScale,t.heightScale),i.heightOffset=defaultValue(i.heightOffset,t.heightOffset),i.elementsPerHeight=defaultValue(i.elementsPerHeight,t.elementsPerHeight),i.stride=defaultValue(i.stride,t.stride),i.elementMultiplier=defaultValue(i.elementMultiplier,t.elementMultiplier),i.isBigEndian=defaultValue(i.isBigEndian,t.isBigEndian)):i=t,this._structure=i,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._skirtHeight=void 0,this._bufferType=this._encoding===HeightmapEncoding$1.LERC?Float32Array:this._buffer.constructor,this._mesh=void 0}TerrainProvider.getRegularGridIndices=function(e,t){var i=regularGridIndexArrays[e];defined(i)||(regularGridIndexArrays[e]=i=[]);var r=i[t];if(!defined(r)){r=e*t<CesiumMath.SIXTY_FOUR_KILOBYTES?i[t]=new Uint16Array((e-1)*(t-1)*6):i[t]=new Uint32Array((e-1)*(t-1)*6);for(var n=0,a=0,o=0;o<t-1;++o){for(var s=0;s<e-1;++s){var l=n,c=l+e,u=c+1,d=l+1;r[a++]=l,r[a++]=c,r[a++]=d,r[a++]=d,r[a++]=c,r[a++]=u,++n}++n}}return r},TerrainProvider.heightmapTerrainQuality=.25,TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,i){return 2*e.maximumRadius*Math.PI*TerrainProvider.heightmapTerrainQuality/(t*i)},TerrainProvider.prototype.requestTileGeometry=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getLevelMaximumGeometricError=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getTileDataAvailable=DeveloperError.throwInstantiationError,TerrainProvider.prototype.loadTileDataAvailability=DeveloperError.throwInstantiationError,defineProperties$1(HeightmapTerrainData.prototype,{credits:{get:function(){}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}}});var taskProcessor=new TaskProcessor("createVerticesFromHeightmap");function interpolateHeight(e,t,i,r,n,a,o,s,l,c){var u=(l-a.west)*(o-1)/(a.east-a.west),d=(c-a.south)*(s-1)/(a.north-a.south),h=0|u,p=h+1;o<=p&&(p=o-1,h=o-2);var m=0|d,f=m+1;return s<=f&&(f=s-1,m=s-2),f=s-1-f,triangleInterpolateHeight(u-h,d-m,getHeight(e,t,i,r,n,(m=s-1-m)*o+h),getHeight(e,t,i,r,n,m*o+p),getHeight(e,t,i,r,n,f*o+h),getHeight(e,t,i,r,n,f*o+p))}function interpolateMeshHeight(e,t,i,r,n,a,o,s,l,c,u){var d=(l-a.west)*(o-1)/(a.east-a.west),h=(c-a.south)*(s-1)/(a.north-a.south);0<n&&(d+=1,h+=1,o+=2,s+=2);var p=0|d,m=p+1;(0<n?o-1:o)<=m&&(m=o-1,p=o-2);var f=0|h,g=f+1;(0<n?s-1:s)<=g&&(g=s-1,f=s-2);var _=h-f;return f=s-1-f,g=s-1-g,triangleInterpolateHeight(d-p,_,(t.decodeHeight(e,f*o+p)/u-i)/r,(t.decodeHeight(e,f*o+m)/u-i)/r,(t.decodeHeight(e,g*o+p)/u-i)/r,(t.decodeHeight(e,g*o+m)/u-i)/r)}function triangleInterpolateHeight(e,t,i,r,n,a){return t<e?i+e*(r-i)+t*(a-r):i+e*(a-n)+t*(n-i)}function getHeight(e,t,i,r,n,a){a*=r;var o,s=0;if(n)for(o=0;o<t;++o)s=s*i+e[a+o];else for(o=t-1;0<=o;--o)s=s*i+e[a+o];return s}function setHeight(e,t,i,r,n,a,o,s){var l;if(o*=n,a)for(l=0;l<t-1;++l)e[o+l]=s/r|0,s-=e[o+l]*r,r/=i;else for(l=t-1;0<l;--l)e[o+l]=s/r|0,s-=e[o+l]*r,r/=i;e[o+l]=s}function TileAvailability(e,t){this._tilingScheme=e,this._maximumLevel=t,this._rootNodes=[]}HeightmapTerrainData.prototype.createMesh=function(e,t,i,r,n){var a=e.ellipsoid,o=e.tileXYToNativeRectangle(t,i,r),s=e.tileXYToRectangle(t,i,r);n=defaultValue(n,1);var l=a.cartographicToCartesian(Rectangle.center(s)),c=this._structure,u=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(a,this._width,e.getNumberOfXTilesAtLevel(0))/(1<<r);this._skirtHeight=Math.min(4*u,1e3);var d=taskProcessor.scheduleTask({heightmap:this._buffer,structure:c,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:o,rectangle:s,relativeToCenter:l,ellipsoid:a,skirtHeight:this._skirtHeight,isGeographic:e.projection instanceof GeographicProjection,exaggeration:n,encoding:this._encoding});if(defined(d)){var h=this;return when(d,function(e){return h._mesh=new TerrainMesh(l,new Float32Array(e.vertices),TerrainProvider.getRegularGridIndices(e.gridWidth,e.gridHeight),e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),n,e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),h._buffer=void 0,h._mesh})}},HeightmapTerrainData.prototype._createMeshSync=function(e,t,i,r,n){var a=e.ellipsoid,o=e.tileXYToNativeRectangle(t,i,r),s=e.tileXYToRectangle(t,i,r);n=defaultValue(n,1);var l=a.cartographicToCartesian(Rectangle.center(s)),c=this._structure,u=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(a,this._width,e.getNumberOfXTilesAtLevel(0))/(1<<r);this._skirtHeight=Math.min(4*u,1e3);var d=HeightmapTessellator.computeVertices({heightmap:this._buffer,structure:c,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:o,rectangle:s,relativeToCenter:l,ellipsoid:a,skirtHeight:this._skirtHeight,isGeographic:e.projection instanceof GeographicProjection,exaggeration:n});this._buffer=void 0;var h=this._width,p=this._height;return 0<this._skirtHeight&&(h+=2,p+=2),new TerrainMesh(l,d.vertices,TerrainProvider.getRegularGridIndices(h,p),d.minimumHeight,d.maximumHeight,d.boundingSphere3D,d.occludeePointInScaledSpace,d.encoding.getStride(),d.orientedBoundingBox,d.encoding,n,d.westIndicesSouthToNorth,d.southIndicesEastToWest,d.eastIndicesNorthToSouth,d.northIndicesWestToEast)},HeightmapTerrainData.prototype.interpolateHeight=function(e,t,i){var r,n=this._width,a=this._height,o=this._structure,s=o.stride,l=o.elementsPerHeight,c=o.elementMultiplier,u=o.isBigEndian,d=o.heightOffset,h=o.heightScale;defined(this._mesh)?r=interpolateMeshHeight(this._mesh.vertices,this._mesh.encoding,d,h,this._skirtHeight,e,n,a,t,i,this._mesh.exaggeration):r=(r=interpolateHeight(this._buffer,l,c,s,u,e,n,a,t,i))*h+d;return r},HeightmapTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(s)){for(var l=this._width,c=this._height,u=this._structure,d=this._skirtHeight,h=u.stride,p=new this._bufferType(l*c*h),m=s.vertices,f=s.encoding,g=e.tileXYToRectangle(t,i,r),_=e.tileXYToRectangle(n,a,o),y=u.heightOffset,v=u.heightScale,C=s.exaggeration,S=u.elementsPerHeight,T=u.elementMultiplier,x=u.isBigEndian,b=Math.pow(T,S-1),E=0;E<c;++E)for(var P=CesiumMath.lerp(_.north,_.south,E/(c-1)),A=0;A<l;++A){var w=interpolateMeshHeight(m,f,y,v,d,g,l,c,CesiumMath.lerp(_.west,_.east,A/(l-1)),P,C);setHeight(p,S,T,b,h,x,E*l+A,w=(w=w<u.lowestEncodedHeight?u.lowestEncodedHeight:w)>u.highestEncodedHeight?u.highestEncodedHeight:w)}return new HeightmapTerrainData({buffer:p,width:l,height:c,childTileMask:0,structure:this._structure,createdByUpsampling:!0})}},HeightmapTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},HeightmapTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var rectangleScratch=new Rectangle;function findNode(e,t,i,r){for(var n=r.length,a=0;a<n;++a){var o=r[a];if(o.x===t&&o.y===i&&o.level===e)return!0}return!1}TileAvailability.prototype.addAvailableTileRange=function(e,t,i,r,n){var a=this._tilingScheme,o=this._rootNodes;if(0===e)for(var s=i;s<=n;++s)for(var l=t;l<=r;++l)findNode(e,l,s,o)||o.push(new QuadtreeNode(a,void 0,0,l,s));a.tileXYToRectangle(t,i,e,rectangleScratch);var c=rectangleScratch.west,u=rectangleScratch.north;a.tileXYToRectangle(r,n,e,rectangleScratch);for(var d=rectangleScratch.east,h=new RectangleWithLevel(e,c,rectangleScratch.south,d,u),p=0;p<o.length;++p){var m=o[p];rectanglesOverlap(m.extent,h)&&putRectangleInQuadtree(this._maximumLevel,m,h)}},TileAvailability.prototype.computeMaximumLevelAtPosition=function(e){for(var t,i=0;i<this._rootNodes.length;++i){var r=this._rootNodes[i];if(rectangleContainsPosition(r.extent,e)){t=r;break}}return defined(t)?findMaxLevelFromNode(void 0,t,e):-1};var rectanglesScratch=[],remainingToCoverByLevelScratch=[],westScratch=new Rectangle,eastScratch=new Rectangle;TileAvailability.prototype.computeBestAvailableLevelOverRectangle=function(e){var t=rectanglesScratch;t.length=0,e.east<e.west?(t.push(Rectangle.fromRadians(-Math.PI,e.south,e.east,e.north,westScratch)),t.push(Rectangle.fromRadians(e.west,e.south,Math.PI,e.north,eastScratch))):t.push(e);var i,r=remainingToCoverByLevelScratch;for(i=r.length=0;i<this._rootNodes.length;++i)updateCoverageWithNode(r,this._rootNodes[i],t);for(i=r.length-1;0<=i;--i)if(defined(r[i])&&0===r[i].length)return i;return 0};var cartographicScratch=new Cartographic;function QuadtreeNode(e,t,i,r,n){this.tilingScheme=e,this.parent=t,this.level=i,this.x=r,this.y=n,this.extent=e.tileXYToRectangle(r,n,i),this.rectangles=[],this._sw=void 0,this._se=void 0,this._nw=void 0,this._ne=void 0}function RectangleWithLevel(e,t,i,r,n){this.level=e,this.west=t,this.south=i,this.east=r,this.north=n}function rectanglesOverlap(e,t){var i=Math.max(e.west,t.west),r=Math.max(e.south,t.south),n=Math.min(e.east,t.east);return r<Math.min(e.north,t.north)&&i<n}function putRectangleInQuadtree(e,t,i){for(;t.level<e;)if(rectangleFullyContainsRectangle(t.nw.extent,i))t=t.nw;else if(rectangleFullyContainsRectangle(t.ne.extent,i))t=t.ne;else if(rectangleFullyContainsRectangle(t.sw.extent,i))t=t.sw;else{if(!rectangleFullyContainsRectangle(t.se.extent,i))break;t=t.se}if(0===t.rectangles.length||t.rectangles[t.rectangles.length-1].level<=i.level)t.rectangles.push(i);else{var r=binarySearch(t.rectangles,i.level,rectangleLevelComparator);r<=0&&(r=~r),t.rectangles.splice(r,0,i)}}function rectangleLevelComparator(e,t){return e.level-t}function rectangleFullyContainsRectangle(e,t){return t.west>=e.west&&t.east<=e.east&&t.south>=e.south&&t.north<=e.north}function rectangleContainsPosition(e,t){return t.longitude>=e.west&&t.longitude<=e.east&&t.latitude>=e.south&&t.latitude<=e.north}function findMaxLevelFromNode(e,t,i){for(var r=0,n=!1;!n;){var a=t._nw&&rectangleContainsPosition(t._nw.extent,i),o=t._ne&&rectangleContainsPosition(t._ne.extent,i),s=t._sw&&rectangleContainsPosition(t._sw.extent,i),l=t._se&&rectangleContainsPosition(t._se.extent,i);if(1<a+o+s+l){a&&(r=Math.max(r,findMaxLevelFromNode(t,t._nw,i))),o&&(r=Math.max(r,findMaxLevelFromNode(t,t._ne,i))),s&&(r=Math.max(r,findMaxLevelFromNode(t,t._sw,i))),l&&(r=Math.max(r,findMaxLevelFromNode(t,t._se,i)));break}a?t=t._nw:o?t=t._ne:s?t=t._sw:l?t=t._se:n=!0}for(;t!==e;){for(var c=t.rectangles,u=c.length-1;0<=u&&c[u].level>r;--u){var d=c[u];rectangleContainsPosition(d,i)&&(r=d.level)}t=t.parent}return r}function updateCoverageWithNode(e,t,i){if(t){var r,n=!1;for(r=0;r<i.length;++r)n=n||rectanglesOverlap(t.extent,i[r]);if(n){var a=t.rectangles;for(r=0;r<a.length;++r){var o=a[r];e[o.level]||(e[o.level]=i),e[o.level]=subtractRectangle(e[o.level],o)}updateCoverageWithNode(e,t._nw,i),updateCoverageWithNode(e,t._ne,i),updateCoverageWithNode(e,t._sw,i),updateCoverageWithNode(e,t._se,i)}}}function subtractRectangle(e,t){for(var i=[],r=0;r<e.length;++r){var n=e[r];rectanglesOverlap(n,t)?(n.west<t.west&&i.push(new Rectangle(n.west,n.south,t.west,n.north)),n.east>t.east&&i.push(new Rectangle(t.east,n.south,n.east,n.north)),n.south<t.south&&i.push(new Rectangle(Math.max(t.west,n.west),n.south,Math.min(t.east,n.east),t.south)),n.north>t.north&&i.push(new Rectangle(Math.max(t.west,n.west),t.north,Math.min(t.east,n.east),n.north))):i.push(n)}return i}function formatError(e){var t,i=e.name,r=e.message;t=defined(i)&&defined(r)?i+": "+r:e.toString();var n=e.stack;return defined(n)&&(t+="\n"+n),t}function TileProviderError(e,t,i,r,n,a,o){this.provider=e,this.message=t,this.x=i,this.y=r,this.level=n,this.timesRetried=defaultValue(a,0),this.retry=!1,this.error=o}function WebMercatorTilingScheme(e){if(e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1),this._projection=new WebMercatorProjection(this._ellipsoid),defined(e.rectangleSouthwestInMeters)&&defined(e.rectangleNortheastInMeters))this._rectangleSouthwestInMeters=e.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=e.rectangleNortheastInMeters;else{var t=this._ellipsoid.maximumRadius*Math.PI;this._rectangleSouthwestInMeters=new Cartesian2(-t,-t),this._rectangleNortheastInMeters=new Cartesian2(t,t)}var i=this._projection.unproject(this._rectangleSouthwestInMeters),r=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new Rectangle(i.longitude,i.latitude,r.longitude,r.latitude)}TileAvailability.prototype.isTileAvailable=function(e,t,i){var r=this._tilingScheme.tileXYToRectangle(t,i,e,rectangleScratch);return Rectangle.center(r,cartographicScratch),this.computeMaximumLevelAtPosition(cartographicScratch)>=e},TileAvailability.prototype.computeChildMaskForTile=function(e,t,i){var r=e+1;if(r>=this._maximumLevel)return 0;var n=0;return n|=this.isTileAvailable(r,2*t,2*i+1)?1:0,n|=this.isTileAvailable(r,2*t+1,2*i+1)?2:0,n|=this.isTileAvailable(r,2*t,2*i)?4:0,n|=this.isTileAvailable(r,2*t+1,2*i)?8:0},defineProperties$1(QuadtreeNode.prototype,{nw:{get:function(){return this._nw||(this._nw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y)),this._nw}},ne:{get:function(){return this._ne||(this._ne=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y)),this._ne}},sw:{get:function(){return this._sw||(this._sw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y+1)),this._sw}},se:{get:function(){return this._se||(this._se=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y+1)),this._se}}}),TileProviderError.handleError=function(e,t,i,r,n,a,o,s,l){var c=e;return defined(e)?(c.provider=t,c.message=r,c.x=n,c.y=a,c.level=o,c.retry=!1,c.error=l,++c.timesRetried):c=new TileProviderError(t,r,n,a,o,0,l),0<i.numberOfListeners?i.raiseEvent(c):console.log('An error occurred in "'+t.constructor.name+'": '+formatError(r)),c.retry&&defined(s)&&s(),c},TileProviderError.handleSuccess=function(e){defined(e)&&(e.timesRetried=-1)},defineProperties$1(WebMercatorTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),WebMercatorTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},WebMercatorTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},WebMercatorTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){var i=this._projection,r=i.project(Rectangle.southwest(e)),n=i.project(Rectangle.northeast(e));return defined(t)?(t.west=r.x,t.south=r.y,t.east=n.x,t.north=n.y,t):new Rectangle(r.x,r.y,n.x,n.y)},WebMercatorTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,i,r){var n=this.getNumberOfXTilesAtLevel(i),a=this.getNumberOfYTilesAtLevel(i),o=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/n,s=this._rectangleSouthwestInMeters.x+e*o,l=this._rectangleSouthwestInMeters.x+(e+1)*o,c=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/a,u=this._rectangleNortheastInMeters.y-t*c,d=this._rectangleNortheastInMeters.y-(t+1)*c;return defined(r)?(r.west=s,r.south=d,r.east=l,r.north=u,r):new Rectangle(s,d,l,u)},WebMercatorTilingScheme.prototype.tileXYToRectangle=function(e,t,i,r){var n=this.tileXYToNativeRectangle(e,t,i,r),a=this._projection,o=a.unproject(new Cartesian2(n.west,n.south)),s=a.unproject(new Cartesian2(n.east,n.north));return n.west=o.longitude,n.south=o.latitude,n.east=s.longitude,n.north=s.latitude,n},WebMercatorTilingScheme.prototype.positionToTileXY=function(e,t,i){var r=this._rectangle;if(Rectangle.contains(r,e)){var n=this.getNumberOfXTilesAtLevel(t),a=this.getNumberOfYTilesAtLevel(t),o=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/n,s=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/a,l=this._projection.project(e),c=(l.x-this._rectangleSouthwestInMeters.x)/o|0;n<=c&&(c=n-1);var u=(this._rectangleNortheastInMeters.y-l.y)/s|0;return a<=u&&(u=a-1),defined(i)?(i.x=c,i.y=u,i):new Cartesian2(c,u)}};var ALL_CHILDREN=15;function ArcGISTiledElevationTerrainProvider(e){this._resource=void 0,this._credit=void 0,this._tilingScheme=void 0,this._levelZeroMaximumGeometricError=void 0,this._maxLevel=void 0,this._terrainDataStructure=void 0,this._ready=!1,this._width=void 0,this._height=void 0,this._encoding=void 0;var i=e.token;this._hasAvailability=!1,this._tilesAvailable=void 0,this._tilesAvailablityLoaded=void 0,this._availableCache={};var s=this,l=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._readyPromise=when(e.url).then(function(e){var t=Resource.createIfNeeded(e);return t.appendForwardSlash(),defined(i)&&(t=t.getDerivedResource({queryParameters:{token:i}})),(s._resource=t).getDerivedResource({queryParameters:{f:"pjson"}}).fetchJson()}).then(function(e){var t=e.copyrightText;defined(t)&&(s._credit=new Credit(t));var i=e.spatialReference,r=defaultValue(i.latestWkid,i.wkid),n=e.extent,a={ellipsoid:l};if(4326===r)a.rectangle=Rectangle.fromDegrees(n.xmin,n.ymin,n.xmax,n.ymax),s._tilingScheme=new GeographicTilingScheme(a);else{if(3857!==r)return when.reject(new RuntimeError("Invalid spatial reference"));a.rectangleSouthwestInMeters=new Cartesian2(n.xmin,n.ymin),a.rectangleNortheastInMeters=new Cartesian2(n.xmax,n.ymax),s._tilingScheme=new WebMercatorTilingScheme(a)}var o=e.tileInfo;return defined(o)?(s._width=o.rows+1,s._height=o.cols+1,s._encoding="LERC"===o.format?HeightmapEncoding$1.LERC:HeightmapEncoding$1.NONE,s._lodCount=o.lods.length-1,(s._hasAvailability=-1!==e.capabilities.indexOf("Tilemap"))&&(s._tilesAvailable=new TileAvailability(s._tilingScheme,s._lodCount),s._tilesAvailable.addAvailableTileRange(0,0,0,s._tilingScheme.getNumberOfXTilesAtLevel(0),s._tilingScheme.getNumberOfYTilesAtLevel(0)),s._tilesAvailablityLoaded=new TileAvailability(s._tilingScheme,s._lodCount)),s._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(s._tilingScheme.ellipsoid,s._width,s._tilingScheme.getNumberOfXTilesAtLevel(0)),1<e.bandCount&&console.log("ArcGISTiledElevationTerrainProvider: Terrain data has more than 1 band. Using the first one."),s._terrainDataStructure={elementMultiplier:1,lowestEncodedHeight:e.minValues[0],highestEncodedHeight:e.maxValues[0]},s._ready=!0):when.reject(new RuntimeError("tileInfo is required"))}).otherwise(function(e){var t="An error occurred while accessing "+s._resource.url+".";return TileProviderError.handleError(void 0,s,s._errorEvent,t),when.reject(e)}),this._errorEvent=new Event}function isTileAvailable(e,t,i,r){if(e._hasAvailability){var n=e._tilesAvailablityLoaded,a=e._tilesAvailable;return!(t>e._lodCount)&&(!!a.isTileAvailable(t,i,r)||!n.isTileAvailable(t,i,r)&&void 0)}}function findRange(e,t,i,r){for(var n=t-1,a=i-1,o=r[e.y*t+e.x],s=[],l={startX:e.x,startY:e.y,endX:0,endY:0},c=new Cartesian2(e.x+1,e.y+1),u=!1,d=!1;!u||!d;){var h=c.x,p=d?c.y+1:c.y;if(!u){for(var m=e.y;m<p;++m)if(r[m*t+c.x]!==o){u=!0;break}u?(s.push(new Cartesian2(c.x,e.y)),--c.x,--h,l.endX=c.x):c.x===n?(l.endX=c.x,u=!0):++c.x}if(!d){for(var f=c.y*t,g=e.x;g<=h;++g)if(r[f+g]!==o){d=!0;break}d?(s.push(new Cartesian2(e.x,c.y)),--c.y,l.endY=c.y):c.y===a?(l.endY=c.y,d=!0):++c.y}}return{endingIndices:s,range:l,value:o}}function computeAvailability(e,t,i,r,n){var a=[];if(n.every(function(e){return e===n[0]}))return 1===n[0]&&a.push({startX:e,startY:t,endX:e+i-1,endY:t+r-1}),a;for(var o=[new Cartesian2(0,0)];0<o.length;){var s=findRange(o.pop(),i,r,n);if(1===s.value){var l=s.range;l.startX+=e,l.endX+=e,l.startY+=t,l.endY+=t,a.push(l)}var c=s.endingIndices;0<c.length&&(o=o.concat(c))}return a}function requestAvailability(a,o,s,l){if(!a._hasAvailability)return{};var c=128*Math.floor(s/128),u=128*Math.floor(l/128),d=Math.min(1<<o,128),t="tilemap/"+o+"/"+u+"/"+c+"/"+d+"/"+d,i=a._availableCache;if(defined(i[t]))return i[t];var e=new Request({throttle:!0,throttleByServer:!0,type:RequestType$1.TERRAIN}),r=a._resource.getDerivedResource({url:t,request:e}).fetchJson();return defined(r)?(r=r.then(function(e){var t=computeAvailability(c,u,d,d,e.data);a._tilesAvailablityLoaded.addAvailableTileRange(c,u,c+d,u+d);for(var i=a._tilesAvailable,r=0;r<t.length;++r){var n=t[r];i.addAvailableTileRange(o,n.startX,n.startY,n.endX,n.endY)}return isTileAvailable(a,o,s,l)}),i[t]={promise:r,request:e},{promise:r=r.always(function(e){return delete i[t],e}),request:e}):{}}defineProperties$1(ArcGISTiledElevationTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),ArcGISTiledElevationTerrainProvider.prototype.requestTileGeometry=function(t,i,r,n){var a,e=this._resource.getDerivedResource({url:"tile/"+r+"/"+i+"/"+t,request:n}),o=this._hasAvailability,s=when.resolve(!0);if(o&&!defined(isTileAvailable(this,r+1,2*t,2*i))){var l=requestAvailability(this,r+1,2*t,2*i);s=l.promise,a=l.request}var c=e.fetchArrayBuffer();if(defined(c)&&defined(s)){var u=this,d=this._tilesAvailable;return when.join(c,s).then(function(e){return new HeightmapTerrainData({buffer:e[0],width:u._width,height:u._height,childTileMask:o?d.computeChildMaskForTile(r,t,i):ALL_CHILDREN,structure:u._terrainDataStructure,encoding:u._encoding})}).otherwise(function(e){return defined(a)&&a.state===RequestState$1.CANCELLED?(n.cancel(),n.deferred.promise.always(function(){return n.state=RequestState$1.CANCELLED,when.reject(e)})):when.reject(e)})}},ArcGISTiledElevationTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},ArcGISTiledElevationTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){if(this._hasAvailability){var r=isTileAvailable(this,i,e,t);if(defined(r))return r;requestAvailability(this,i,e,t)}},ArcGISTiledElevationTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var ArcType={NONE:0,GEODESIC:1,RHUMB:2},ArcType$1=freezeObject$1(ArcType);function AssociativeArray(){this._array=[],this._hash={}}defineProperties$1(AssociativeArray.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}}),AssociativeArray.prototype.contains=function(e){return defined(this._hash[e])},AssociativeArray.prototype.set=function(e,t){t!==this._hash[e]&&(this.remove(e),this._hash[e]=t,this._array.push(t))},AssociativeArray.prototype.get=function(e){return this._hash[e]},AssociativeArray.prototype.remove=function(e){var t=this._hash[e],i=defined(t);if(i){var r=this._array;r.splice(r.indexOf(t),1),delete this._hash[e]}return i},AssociativeArray.prototype.removeAll=function(){var e=this._array;0<e.length&&(this._hash={},e.length=0)};var BingMapsApi={defaultKey:void 0,getKey:function(e){return defined(e)?e:BingMapsApi.defaultKey}},url="https://dev.virtualearth.net/REST/v1/Locations";function BingMapsGeocoderService(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).key;this._key=BingMapsApi.getKey(t),this._resource=new Resource({url:url,queryParameters:{key:this._key}})}function BoundingRectangle(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.width=defaultValue(i,0),this.height=defaultValue(r,0)}defineProperties$1(BingMapsGeocoderService.prototype,{url:{get:function(){return url}},key:{get:function(){return this._key}}}),BingMapsGeocoderService.prototype.geocode=function(e){return this._resource.getDerivedResource({queryParameters:{query:e}}).fetchJsonp("jsonp").then(function(e){return 0===e.resourceSets.length?[]:e.resourceSets[0].resources.map(function(e){var t=e.bbox,i=t[0],r=t[1],n=t[2],a=t[3];return{displayName:e.name,destination:Rectangle.fromDegrees(r,i,a,n)}})})},BoundingRectangle.packedLength=4,BoundingRectangle.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.width,t[i]=e.height,t},BoundingRectangle.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new BoundingRectangle),i.x=e[t++],i.y=e[t++],i.width=e[t++],i.height=e[t],i},BoundingRectangle.fromPoints=function(e,t){if(defined(t)||(t=new BoundingRectangle),!defined(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var i=e.length,r=e[0].x,n=e[0].y,a=e[0].x,o=e[0].y,s=1;s<i;s++){var l=e[s],c=l.x,u=l.y;r=Math.min(c,r),a=Math.max(c,a),n=Math.min(u,n),o=Math.max(u,o)}return t.x=r,t.y=n,t.width=a-r,t.height=o-n,t};var defaultProjection$1=new GeographicProjection,fromRectangleLowerLeft=new Cartographic,fromRectangleUpperRight=new Cartographic;function arrayFill(e,t,i,r){if("function"==typeof e.fill)return e.fill(t,i,r);for(var n=e.length>>>0,a=defaultValue(i,0),o=a<0?Math.max(n+a,0):Math.min(a,n),s=defaultValue(r,n),l=s<0?Math.max(n+s,0):Math.min(s,n);o<l;)e[o]=t,o++;return e}BoundingRectangle.fromRectangle=function(e,t,i){if(defined(i)||(i=new BoundingRectangle),!defined(e))return i.x=0,i.y=0,i.width=0,i.height=0,i;var r=(t=defaultValue(t,defaultProjection$1)).project(Rectangle.southwest(e,fromRectangleLowerLeft)),n=t.project(Rectangle.northeast(e,fromRectangleUpperRight));return Cartesian2.subtract(n,r,n),i.x=r.x,i.y=r.y,i.width=n.x,i.height=n.y,i},BoundingRectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new BoundingRectangle(e.x,e.y,e.width,e.height)},BoundingRectangle.union=function(e,t,i){defined(i)||(i=new BoundingRectangle);var r=Math.min(e.x,t.x),n=Math.min(e.y,t.y),a=Math.max(e.x+e.width,t.x+t.width),o=Math.max(e.y+e.height,t.y+t.height);return i.x=r,i.y=n,i.width=a-r,i.height=o-n,i},BoundingRectangle.expand=function(e,t,i){i=BoundingRectangle.clone(e,i);var r=t.x-i.x,n=t.y-i.y;return r>i.width?i.width=r:r<0&&(i.width-=r,i.x=t.x),n>i.height?i.height=n:n<0&&(i.height-=n,i.y=t.y),i},BoundingRectangle.intersect=function(e,t){var i=e.x,r=e.y,n=t.x,a=t.y;return i>n+t.width||i+e.width<n||r+e.height<a||r>a+t.height?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},BoundingRectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},BoundingRectangle.prototype.clone=function(e){return BoundingRectangle.clone(this,e)},BoundingRectangle.prototype.intersect=function(e){return BoundingRectangle.intersect(this,e)},BoundingRectangle.prototype.equals=function(e){return BoundingRectangle.equals(this,e)};var GeometryType={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3},GeometryType$1=freezeObject$1(GeometryType);function Matrix2(e,t,i,r){this[0]=defaultValue(e,0),this[1]=defaultValue(i,0),this[2]=defaultValue(t,0),this[3]=defaultValue(r,0)}Matrix2.packedLength=4,Matrix2.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t},Matrix2.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix2),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i},Matrix2.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new Matrix2(e[0],e[2],e[1],e[3])},Matrix2.fromArray=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix2),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i},Matrix2.fromColumnMajorArray=function(e,t){return Matrix2.clone(e,t)},Matrix2.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new Matrix2(e[0],e[1],e[2],e[3])},Matrix2.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new Matrix2(e.x,0,0,e.y)},Matrix2.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new Matrix2(e,0,0,e)},Matrix2.fromRotation=function(e,t){var i=Math.cos(e),r=Math.sin(e);return defined(t)?(t[0]=i,t[1]=r,t[2]=-r,t[3]=i,t):new Matrix2(i,-r,r,i)},Matrix2.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},Matrix2.getElementIndex=function(e,t){return 2*e+t},Matrix2.getColumn=function(e,t,i){var r=2*t,n=e[r],a=e[1+r];return i.x=n,i.y=a,i},Matrix2.setColumn=function(e,t,i,r){var n=2*t;return(r=Matrix2.clone(e,r))[n]=i.x,r[1+n]=i.y,r},Matrix2.getRow=function(e,t,i){var r=e[t],n=e[t+2];return i.x=r,i.y=n,i},Matrix2.setRow=function(e,t,i,r){return(r=Matrix2.clone(e,r))[t]=i.x,r[t+2]=i.y,r};var scratchColumn$2=new Cartesian2;Matrix2.getScale=function(e,t){return t.x=Cartesian2.magnitude(Cartesian2.fromElements(e[0],e[1],scratchColumn$2)),t.y=Cartesian2.magnitude(Cartesian2.fromElements(e[2],e[3],scratchColumn$2)),t};var scratchScale$4=new Cartesian2;Matrix2.getMaximumScale=function(e){return Matrix2.getScale(e,scratchScale$4),Cartesian2.maximumComponent(scratchScale$4)},Matrix2.multiply=function(e,t,i){var r=e[0]*t[0]+e[2]*t[1],n=e[0]*t[2]+e[2]*t[3],a=e[1]*t[0]+e[3]*t[1],o=e[1]*t[2]+e[3]*t[3];return i[0]=r,i[1]=a,i[2]=n,i[3]=o,i},Matrix2.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i},Matrix2.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i},Matrix2.multiplyByVector=function(e,t,i){var r=e[0]*t.x+e[2]*t.y,n=e[1]*t.x+e[3]*t.y;return i.x=r,i.y=n,i},Matrix2.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i},Matrix2.multiplyByScale=function(e,t,i){return i[0]=e[0]*t.x,i[1]=e[1]*t.x,i[2]=e[2]*t.y,i[3]=e[3]*t.y,i},Matrix2.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},Matrix2.transpose=function(e,t){var i=e[0],r=e[2],n=e[1],a=e[3];return t[0]=i,t[1]=r,t[2]=n,t[3]=a,t},Matrix2.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},Matrix2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},Matrix2.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]},Matrix2.equalsEpsilon=function(e,t,i){return e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i},Matrix2.IDENTITY=freezeObject$1(new Matrix2(1,0,0,1)),Matrix2.ZERO=freezeObject$1(new Matrix2(0,0,0,0)),Matrix2.COLUMN0ROW0=0,Matrix2.COLUMN0ROW1=1,Matrix2.COLUMN1ROW0=2,Matrix2.COLUMN1ROW1=3,defineProperties$1(Matrix2.prototype,{length:{get:function(){return Matrix2.packedLength}}}),Matrix2.prototype.clone=function(e){return Matrix2.clone(this,e)},Matrix2.prototype.equals=function(e){return Matrix2.equals(this,e)},Matrix2.prototype.equalsEpsilon=function(e,t){return Matrix2.equalsEpsilon(this,e,t)},Matrix2.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"};var PrimitiveType={POINTS:WebGLConstants$1.POINTS,LINES:WebGLConstants$1.LINES,LINE_LOOP:WebGLConstants$1.LINE_LOOP,LINE_STRIP:WebGLConstants$1.LINE_STRIP,TRIANGLES:WebGLConstants$1.TRIANGLES,TRIANGLE_STRIP:WebGLConstants$1.TRIANGLE_STRIP,TRIANGLE_FAN:WebGLConstants$1.TRIANGLE_FAN,validate:function(e){return e===PrimitiveType.POINTS||e===PrimitiveType.LINES||e===PrimitiveType.LINE_LOOP||e===PrimitiveType.LINE_STRIP||e===PrimitiveType.TRIANGLES||e===PrimitiveType.TRIANGLE_STRIP||e===PrimitiveType.TRIANGLE_FAN}},PrimitiveType$1=freezeObject$1(PrimitiveType);function Geometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=defaultValue(e.geometryType,GeometryType$1.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}Geometry.computeNumberOfVertices=function(e){var t=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&defined(e.attributes[i])&&defined(e.attributes[i].values)){var r=e.attributes[i];t=r.values.length/r.componentsPerAttribute}return t};var rectangleCenterScratch=new Cartographic,enuCenterScratch=new Cartesian3,fixedFrameToEnuScratch=new Matrix4,boundingRectanglePointsCartographicScratch=[new Cartographic,new Cartographic,new Cartographic],boundingRectanglePointsEnuScratch=[new Cartesian2,new Cartesian2,new Cartesian2],points2DScratch=[new Cartesian2,new Cartesian2,new Cartesian2],pointEnuScratch=new Cartesian3,enuRotationScratch=new Quaternion,enuRotationMatrixScratch=new Matrix4,rotation2DScratch=new Matrix2;function GeometryAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.values=e.values}function GeometryAttributes(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.bitangent=e.bitangent,this.tangent=e.tangent,this.color=e.color}Geometry._textureCoordinateRotationPoints=function(e,t,i,r){var n,a=Rectangle.center(r,rectangleCenterScratch),o=Cartographic.toCartesian(a,i,enuCenterScratch),s=Transforms.eastNorthUpToFixedFrame(o,i,fixedFrameToEnuScratch),l=Matrix4.inverse(s,fixedFrameToEnuScratch),c=boundingRectanglePointsEnuScratch,u=boundingRectanglePointsCartographicScratch;u[0].longitude=r.west,u[0].latitude=r.south,u[1].longitude=r.west,u[1].latitude=r.north,u[2].longitude=r.east,u[2].latitude=r.south;var d=pointEnuScratch;for(n=0;n<3;n++)Cartographic.toCartesian(u[n],i,d),d=Matrix4.multiplyByPointAsVector(l,d,d),c[n].x=d.x,c[n].y=d.y;var h=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-t,enuRotationScratch),p=Matrix3.fromQuaternion(h,enuRotationMatrixScratch),m=e.length,f=Number.POSITIVE_INFINITY,g=Number.POSITIVE_INFINITY,_=Number.NEGATIVE_INFINITY,y=Number.NEGATIVE_INFINITY;for(n=0;n<m;n++)d=Matrix4.multiplyByPointAsVector(l,e[n],d),d=Matrix3.multiplyByVector(p,d,d),f=Math.min(f,d.x),g=Math.min(g,d.y),_=Math.max(_,d.x),y=Math.max(y,d.y);var v=Matrix2.fromRotation(t,rotation2DScratch),C=points2DScratch;C[0].x=f,C[0].y=g,C[1].x=f,C[1].y=y,C[2].x=_,C[2].y=g;var S=c[0],T=c[2].x-S.x,x=c[1].y-S.y;for(n=0;n<3;n++){var b=C[n];Matrix2.multiplyByVector(v,b,b),b.x=(b.x-S.x)/T,b.y=(b.y-S.y)/x}var E=C[0],P=C[1],A=C[2],w=new Array(6);return Cartesian2.pack(E,w),Cartesian2.pack(P,w,2),Cartesian2.pack(A,w,4),w};var GeometryOffsetAttribute={NONE:0,TOP:1,ALL:2},GeometryOffsetAttribute$1=freezeObject$1(GeometryOffsetAttribute);function VertexFormat(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=defaultValue(e.position,!1),this.normal=defaultValue(e.normal,!1),this.st=defaultValue(e.st,!1),this.bitangent=defaultValue(e.bitangent,!1),this.tangent=defaultValue(e.tangent,!1),this.color=defaultValue(e.color,!1)}VertexFormat.POSITION_ONLY=freezeObject$1(new VertexFormat({position:!0})),VertexFormat.POSITION_AND_NORMAL=freezeObject$1(new VertexFormat({position:!0,normal:!0})),VertexFormat.POSITION_NORMAL_AND_ST=freezeObject$1(new VertexFormat({position:!0,normal:!0,st:!0})),VertexFormat.POSITION_AND_ST=freezeObject$1(new VertexFormat({position:!0,st:!0})),VertexFormat.POSITION_AND_COLOR=freezeObject$1(new VertexFormat({position:!0,color:!0})),VertexFormat.ALL=freezeObject$1(new VertexFormat({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),VertexFormat.DEFAULT=VertexFormat.POSITION_NORMAL_AND_ST,VertexFormat.packedLength=6,VertexFormat.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.position?1:0,t[i++]=e.normal?1:0,t[i++]=e.st?1:0,t[i++]=e.tangent?1:0,t[i++]=e.bitangent?1:0,t[i]=e.color?1:0,t},VertexFormat.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new VertexFormat),i.position=1===e[t++],i.normal=1===e[t++],i.st=1===e[t++],i.tangent=1===e[t++],i.bitangent=1===e[t++],i.color=1===e[t],i},VertexFormat.clone=function(e,t){if(defined(e))return defined(t)||(t=new VertexFormat),t.position=e.position,t.normal=e.normal,t.st=e.st,t.tangent=e.tangent,t.bitangent=e.bitangent,t.color=e.color,t};var diffScratch=new Cartesian3;function BoxGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,i=e.maximum,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._minimum=Cartesian3.clone(t),this._maximum=Cartesian3.clone(i),this._vertexFormat=r,this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxGeometry"}BoxGeometry.fromDimensions=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,i=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxGeometry({minimum:Cartesian3.negate(i,new Cartesian3),maximum:i,vertexFormat:e.vertexFormat,offsetAttribute:e.offsetAttribute})},BoxGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxGeometry({minimum:e.minimum,maximum:e.maximum})},BoxGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+1,BoxGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._minimum,t,i),Cartesian3.pack(e._maximum,t,i+Cartesian3.packedLength),VertexFormat.pack(e._vertexFormat,t,i+2*Cartesian3.packedLength),t[i+2*Cartesian3.packedLength+VertexFormat.packedLength]=defaultValue(e._offsetAttribute,-1),t};var scratchMin=new Cartesian3,scratchMax=new Cartesian3,scratchVertexFormat=new VertexFormat,scratchOptions={minimum:scratchMin,maximum:scratchMax,vertexFormat:scratchVertexFormat,offsetAttribute:void 0},unitBoxGeometry;BoxGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchMin),n=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax),a=VertexFormat.unpack(e,t+2*Cartesian3.packedLength,scratchVertexFormat),o=e[t+2*Cartesian3.packedLength+VertexFormat.packedLength];return defined(i)?(i._minimum=Cartesian3.clone(r,i._minimum),i._maximum=Cartesian3.clone(n,i._maximum),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._offsetAttribute=-1===o?void 0:o,i):(scratchOptions.offsetAttribute=-1===o?void 0:o,new BoxGeometry(scratchOptions))},BoxGeometry.createGeometry=function(e){var t=e._minimum,i=e._maximum,r=e._vertexFormat;if(!Cartesian3.equals(t,i)){var n,a,o=new GeometryAttributes;if(r.position&&(r.st||r.normal||r.tangent||r.bitangent)){if(r.position&&((a=new Float64Array(72))[0]=t.x,a[1]=t.y,a[2]=i.z,a[3]=i.x,a[4]=t.y,a[5]=i.z,a[6]=i.x,a[7]=i.y,a[8]=i.z,a[9]=t.x,a[10]=i.y,a[11]=i.z,a[12]=t.x,a[13]=t.y,a[14]=t.z,a[15]=i.x,a[16]=t.y,a[17]=t.z,a[18]=i.x,a[19]=i.y,a[20]=t.z,a[21]=t.x,a[22]=i.y,a[23]=t.z,a[24]=i.x,a[25]=t.y,a[26]=t.z,a[27]=i.x,a[28]=i.y,a[29]=t.z,a[30]=i.x,a[31]=i.y,a[32]=i.z,a[33]=i.x,a[34]=t.y,a[35]=i.z,a[36]=t.x,a[37]=t.y,a[38]=t.z,a[39]=t.x,a[40]=i.y,a[41]=t.z,a[42]=t.x,a[43]=i.y,a[44]=i.z,a[45]=t.x,a[46]=t.y,a[47]=i.z,a[48]=t.x,a[49]=i.y,a[50]=t.z,a[51]=i.x,a[52]=i.y,a[53]=t.z,a[54]=i.x,a[55]=i.y,a[56]=i.z,a[57]=t.x,a[58]=i.y,a[59]=i.z,a[60]=t.x,a[61]=t.y,a[62]=t.z,a[63]=i.x,a[64]=t.y,a[65]=t.z,a[66]=i.x,a[67]=t.y,a[68]=i.z,a[69]=t.x,a[70]=t.y,a[71]=i.z,o.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})),r.normal){var s=new Float32Array(72);s[0]=0,s[1]=0,s[2]=1,s[3]=0,s[4]=0,s[5]=1,s[6]=0,s[7]=0,s[8]=1,s[9]=0,s[10]=0,s[11]=1,s[12]=0,s[13]=0,s[14]=-1,s[15]=0,s[16]=0,s[17]=-1,s[18]=0,s[19]=0,s[20]=-1,s[21]=0,s[22]=0,s[23]=-1,s[24]=1,s[25]=0,s[26]=0,s[27]=1,s[28]=0,s[29]=0,s[30]=1,s[31]=0,s[32]=0,s[33]=1,s[34]=0,s[35]=0,s[36]=-1,s[37]=0,s[38]=0,s[39]=-1,s[40]=0,s[41]=0,s[42]=-1,s[43]=0,s[44]=0,s[45]=-1,s[46]=0,s[47]=0,s[48]=0,s[49]=1,s[50]=0,s[51]=0,s[52]=1,s[53]=0,s[54]=0,s[55]=1,s[56]=0,s[57]=0,s[58]=1,s[59]=0,s[60]=0,s[61]=-1,s[62]=0,s[63]=0,s[64]=-1,s[65]=0,s[66]=0,s[67]=-1,s[68]=0,s[69]=0,s[70]=-1,s[71]=0,o.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:s})}if(r.st){var l=new Float32Array(48);l[0]=0,l[1]=0,l[2]=1,l[3]=0,l[4]=1,l[5]=1,l[6]=0,l[7]=1,l[8]=1,l[9]=0,l[10]=0,l[11]=0,l[12]=0,l[13]=1,l[14]=1,l[15]=1,l[16]=0,l[17]=0,l[18]=1,l[19]=0,l[20]=1,l[21]=1,l[22]=0,l[23]=1,l[24]=1,l[25]=0,l[26]=0,l[27]=0,l[28]=0,l[29]=1,l[30]=1,l[31]=1,l[32]=1,l[33]=0,l[34]=0,l[35]=0,l[36]=0,l[37]=1,l[38]=1,l[39]=1,l[40]=0,l[41]=0,l[42]=1,l[43]=0,l[44]=1,l[45]=1,l[46]=0,l[47]=1,o.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:l})}if(r.tangent){var c=new Float32Array(72);c[0]=1,c[1]=0,c[2]=0,c[3]=1,c[4]=0,c[5]=0,c[6]=1,c[7]=0,c[8]=0,c[9]=1,c[10]=0,c[11]=0,c[12]=-1,c[13]=0,c[14]=0,c[15]=-1,c[16]=0,c[17]=0,c[18]=-1,c[19]=0,c[20]=0,c[21]=-1,c[22]=0,c[23]=0,c[24]=0,c[25]=1,c[26]=0,c[27]=0,c[28]=1,c[29]=0,c[30]=0,c[31]=1,c[32]=0,c[33]=0,c[34]=1,c[35]=0,c[36]=0,c[37]=-1,c[38]=0,c[39]=0,c[40]=-1,c[41]=0,c[42]=0,c[43]=-1,c[44]=0,c[45]=0,c[46]=-1,c[47]=0,c[48]=-1,c[49]=0,c[50]=0,c[51]=-1,c[52]=0,c[53]=0,c[54]=-1,c[55]=0,c[56]=0,c[57]=-1,c[58]=0,c[59]=0,c[60]=1,c[61]=0,c[62]=0,c[63]=1,c[64]=0,c[65]=0,c[66]=1,c[67]=0,c[68]=0,c[69]=1,c[70]=0,c[71]=0,o.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:c})}if(r.bitangent){var u=new Float32Array(72);u[0]=0,u[1]=1,u[2]=0,u[3]=0,u[4]=1,u[5]=0,u[6]=0,u[7]=1,u[8]=0,u[9]=0,u[10]=1,u[11]=0,u[12]=0,u[13]=1,u[14]=0,u[15]=0,u[16]=1,u[17]=0,u[18]=0,u[19]=1,u[20]=0,u[21]=0,u[22]=1,u[23]=0,u[24]=0,u[25]=0,u[26]=1,u[27]=0,u[28]=0,u[29]=1,u[30]=0,u[31]=0,u[32]=1,u[33]=0,u[34]=0,u[35]=1,u[36]=0,u[37]=0,u[38]=1,u[39]=0,u[40]=0,u[41]=1,u[42]=0,u[43]=0,u[44]=1,u[45]=0,u[46]=0,u[47]=1,u[48]=0,u[49]=0,u[50]=1,u[51]=0,u[52]=0,u[53]=1,u[54]=0,u[55]=0,u[56]=1,u[57]=0,u[58]=0,u[59]=1,u[60]=0,u[61]=0,u[62]=1,u[63]=0,u[64]=0,u[65]=1,u[66]=0,u[67]=0,u[68]=1,u[69]=0,u[70]=0,u[71]=1,o.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:u})}(n=new Uint16Array(36))[0]=0,n[1]=1,n[2]=2,n[3]=0,n[4]=2,n[5]=3,n[6]=6,n[7]=5,n[8]=4,n[9]=7,n[10]=6,n[11]=4,n[12]=8,n[13]=9,n[14]=10,n[15]=8,n[16]=10,n[17]=11,n[18]=14,n[19]=13,n[20]=12,n[21]=15,n[22]=14,n[23]=12,n[24]=18,n[25]=17,n[26]=16,n[27]=19,n[28]=18,n[29]=16,n[30]=20,n[31]=21,n[32]=22,n[33]=20,n[34]=22,n[35]=23}else(a=new Float64Array(24))[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=i.x,a[4]=t.y,a[5]=t.z,a[6]=i.x,a[7]=i.y,a[8]=t.z,a[9]=t.x,a[10]=i.y,a[11]=t.z,a[12]=t.x,a[13]=t.y,a[14]=i.z,a[15]=i.x,a[16]=t.y,a[17]=i.z,a[18]=i.x,a[19]=i.y,a[20]=i.z,a[21]=t.x,a[22]=i.y,a[23]=i.z,o.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a}),(n=new Uint16Array(36))[0]=4,n[1]=5,n[2]=6,n[3]=4,n[4]=6,n[5]=7,n[6]=1,n[7]=0,n[8]=3,n[9]=1,n[10]=3,n[11]=2,n[12]=1,n[13]=6,n[14]=5,n[15]=1,n[16]=2,n[17]=6,n[18]=2,n[19]=3,n[20]=7,n[21]=2,n[22]=7,n[23]=6,n[24]=3,n[25]=0,n[26]=4,n[27]=3,n[28]=4,n[29]=7,n[30]=0,n[31]=1,n[32]=5,n[33]=0,n[34]=5,n[35]=4;var d=Cartesian3.subtract(i,t,diffScratch),h=.5*Cartesian3.magnitude(d);if(defined(e._offsetAttribute)){var p=a.length,m=new Uint8Array(p/3);arrayFill(m,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),o.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:m})}return new Geometry({attributes:o,indices:n,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,h),offsetAttribute:e._offsetAttribute})}},BoxGeometry.getUnitBox=function(){return defined(unitBoxGeometry)||(unitBoxGeometry=BoxGeometry.createGeometry(BoxGeometry.fromDimensions({dimensions:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY}))),unitBoxGeometry};var diffScratch$1=new Cartesian3;function BoxOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,i=e.maximum;this._min=Cartesian3.clone(t),this._max=Cartesian3.clone(i),this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxOutlineGeometry"}BoxOutlineGeometry.fromDimensions=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,i=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxOutlineGeometry({minimum:Cartesian3.negate(i,new Cartesian3),maximum:i,offsetAttribute:e.offsetAttribute})},BoxOutlineGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxOutlineGeometry({minimum:e.minimum,maximum:e.maximum})},BoxOutlineGeometry.packedLength=2*Cartesian3.packedLength+1,BoxOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._min,t,i),Cartesian3.pack(e._max,t,i+Cartesian3.packedLength),t[i+2*Cartesian3.packedLength]=defaultValue(e._offsetAttribute,-1),t};var scratchMin$1=new Cartesian3,scratchMax$1=new Cartesian3,scratchOptions$1={minimum:scratchMin$1,maximum:scratchMax$1,offsetAttribute:void 0};function CartographicGeocoderService(){}function Spline(){this.times=void 0,this.points=void 0,DeveloperError.throwInstantiationError()}function LinearSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times;this._times=i,this._points=t,this._lastTimeIndex=0}BoxOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchMin$1),n=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax$1),a=e[t+2*Cartesian3.packedLength];return defined(i)?(i._min=Cartesian3.clone(r,i._min),i._max=Cartesian3.clone(n,i._max),i._offsetAttribute=-1===a?void 0:a,i):(scratchOptions$1.offsetAttribute=-1===a?void 0:a,new BoxOutlineGeometry(scratchOptions$1))},BoxOutlineGeometry.createGeometry=function(e){var t=e._min,i=e._max;if(!Cartesian3.equals(t,i)){var r=new GeometryAttributes,n=new Uint16Array(24),a=new Float64Array(24);a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=i.x,a[4]=t.y,a[5]=t.z,a[6]=i.x,a[7]=i.y,a[8]=t.z,a[9]=t.x,a[10]=i.y,a[11]=t.z,a[12]=t.x,a[13]=t.y,a[14]=i.z,a[15]=i.x,a[16]=t.y,a[17]=i.z,a[18]=i.x,a[19]=i.y,a[20]=i.z,a[21]=t.x,a[22]=i.y,a[23]=i.z,r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a}),n[0]=4,n[1]=5,n[2]=5,n[3]=6,n[4]=6,n[5]=7,n[6]=7,n[7]=4,n[8]=0,n[9]=1,n[10]=1,n[11]=2,n[12]=2,n[13]=3,n[14]=3,n[15]=0,n[16]=0,n[17]=4,n[18]=1,n[19]=5,n[20]=2,n[21]=6,n[22]=3,n[23]=7;var o=Cartesian3.subtract(i,t,diffScratch$1),s=.5*Cartesian3.magnitude(o);if(defined(e._offsetAttribute)){var l=a.length,c=new Uint8Array(l/3);arrayFill(c,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),r.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})}return new Geometry({attributes:r,indices:n,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,s),offsetAttribute:e._offsetAttribute})}},CartographicGeocoderService.prototype.geocode=function(e){var t=e.match(/[^\s,\n]+/g);if(2===t.length||3===t.length){var i=+t[0],r=+t[1],n=3===t.length?+t[2]:300;if(isNaN(i)&&isNaN(r))for(var a=/^(\d+.?\d*)([nsew])/i,o=0;o<t.length;++o){var s=t[o].match(a);a.test(t[o])&&3===s.length&&(/^[ns]/i.test(s[2])?r=/^[n]/i.test(s[2])?+s[1]:-s[1]:/^[ew]/i.test(s[2])&&(i=/^[e]/i.test(s[2])?+s[1]:-s[1]))}if(!isNaN(i)&&!isNaN(r)&&!isNaN(n)){var l={displayName:e,destination:Cartesian3.fromDegrees(i,r,n)};return when.resolve([l])}}return when.resolve([])},Spline.prototype.evaluate=DeveloperError.throwInstantiationError,Spline.prototype.findTimeInterval=function(e,t){var i,r=this.times,n=r.length;if(e>=r[t=defaultValue(t,0)]){if(t+1<n&&e<r[t+1])return t;if(t+2<n&&e<r[t+2])return t+1}else if(0<=t-1&&e>=r[t-1])return t-1;if(e>r[t])for(i=t;i<n-1&&!(e>=r[i]&&e<r[i+1]);++i);else for(i=t-1;0<=i&&!(e>=r[i]&&e<r[i+1]);--i);return i===n-1&&(i=n-2),i},Spline.prototype.wrapTime=function(e){var t=this.times,i=t[t.length-1],r=t[0],n=i-r;return e<r&&(e+=(Math.floor((r-e)/n)+1)*n),i<e&&(e-=(Math.floor((e-i)/n)+1)*n),e},Spline.prototype.clampTime=function(e){var t=this.times;return CesiumMath.clamp(e,t[0],t[t.length-1])},defineProperties$1(LinearSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),LinearSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,LinearSpline.prototype.wrapTime=Spline.prototype.wrapTime,LinearSpline.prototype.clampTime=Spline.prototype.clampTime,LinearSpline.prototype.evaluate=function(e,t){var i=this.points,r=this.times,n=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),a=(e-r[n])/(r[n+1]-r[n]);return defined(t)||(t=new Cartesian3),Cartesian3.lerp(i[n],i[n+1],a,t)};var TridiagonalSystemSolver={solve:function(e,t,i,r){var n,a,o=new Array(i.length),s=new Array(r.length),l=new Array(r.length);for(n=0;n<s.length;n++)s[n]=new Cartesian3,l[n]=new Cartesian3;for(o[0]=i[0]/t[0],s[0]=Cartesian3.multiplyByScalar(r[0],1/t[0],s[0]),n=1;n<o.length;++n)a=1/(t[n]-o[n-1]*e[n-1]),o[n]=i[n]*a,s[n]=Cartesian3.subtract(r[n],Cartesian3.multiplyByScalar(s[n-1],e[n-1],s[n]),s[n]),s[n]=Cartesian3.multiplyByScalar(s[n],a,s[n]);for(a=1/(t[n]-o[n-1]*e[n-1]),s[n]=Cartesian3.subtract(r[n],Cartesian3.multiplyByScalar(s[n-1],e[n-1],s[n]),s[n]),s[n]=Cartesian3.multiplyByScalar(s[n],a,s[n]),l[l.length-1]=s[s.length-1],n=l.length-2;0<=n;--n)l[n]=Cartesian3.subtract(s[n],Cartesian3.multiplyByScalar(l[n+1],o[n],l[n]),l[n]);return l}},scratchLower=[],scratchDiagonal=[],scratchUpper=[],scratchRight=[];function generateClamped(e,t,i){var r,n=scratchLower,a=scratchUpper,o=scratchDiagonal,s=scratchRight;n.length=a.length=e.length-1,o.length=s.length=e.length,n[0]=o[0]=1;var l=s[a[0]=0];for(defined(l)||(l=s[0]=new Cartesian3),Cartesian3.clone(t,l),r=1;r<n.length-1;++r)n[r]=a[r]=1,o[r]=4,defined(l=s[r])||(l=s[r]=new Cartesian3),Cartesian3.subtract(e[r+1],e[r-1],l),Cartesian3.multiplyByScalar(l,3,l);return n[r]=0,a[r]=1,o[r]=4,defined(l=s[r])||(l=s[r]=new Cartesian3),Cartesian3.subtract(e[r+1],e[r-1],l),Cartesian3.multiplyByScalar(l,3,l),defined(l=s[r+(o[r+1]=1)])||(l=s[r+1]=new Cartesian3),Cartesian3.clone(i,l),TridiagonalSystemSolver.solve(n,o,a,s)}function generateNatural(e){var t,i=scratchLower,r=scratchUpper,n=scratchDiagonal,a=scratchRight;i.length=r.length=e.length-1,n.length=a.length=e.length,i[0]=r[0]=1,n[0]=2;var o=a[0];for(defined(o)||(o=a[0]=new Cartesian3),Cartesian3.subtract(e[1],e[0],o),Cartesian3.multiplyByScalar(o,3,o),t=1;t<i.length;++t)i[t]=r[t]=1,n[t]=4,defined(o=a[t])||(o=a[t]=new Cartesian3),Cartesian3.subtract(e[t+1],e[t-1],o),Cartesian3.multiplyByScalar(o,3,o);return n[t]=2,defined(o=a[t])||(o=a[t]=new Cartesian3),Cartesian3.subtract(e[t],e[t-1],o),Cartesian3.multiplyByScalar(o,3,o),TridiagonalSystemSolver.solve(i,n,r,a)}function HermiteSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times,r=e.inTangents,n=e.outTangents;this._times=i,this._points=t,this._inTangents=r,this._outTangents=n,this._lastTimeIndex=0}defineProperties$1(HermiteSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},inTangents:{get:function(){return this._inTangents}},outTangents:{get:function(){return this._outTangents}}}),HermiteSpline.createC1=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points,r=e.tangents,n=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:n})},HermiteSpline.createNaturalCubic=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points;if(i.length<3)return new LinearSpline({points:i,times:t});var r=generateNatural(i),n=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:n})},HermiteSpline.createClampedCubic=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points,r=e.firstTangent,n=e.lastTangent;if(i.length<3)return new LinearSpline({points:i,times:t});var a=generateClamped(i,r,n),o=a.slice(0,a.length-1);return new HermiteSpline({times:t,points:i,inTangents:a.slice(1,a.length),outTangents:o})},HermiteSpline.hermiteCoefficientMatrix=new Matrix4(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0),HermiteSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval;var scratchTimeVec=new Cartesian4,scratchTemp=new Cartesian3;HermiteSpline.prototype.wrapTime=Spline.prototype.wrapTime,HermiteSpline.prototype.clampTime=Spline.prototype.clampTime,HermiteSpline.prototype.evaluate=function(e,t){defined(t)||(t=new Cartesian3);var i=this.points,r=this.times,n=this.inTangents,a=this.outTangents,o=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),s=(e-r[o])/(r[o+1]-r[o]),l=scratchTimeVec;l.z=s,l.y=s*s,l.x=l.y*s,l.w=1;var c=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,l,l);return t=Cartesian3.multiplyByScalar(i[o],c.x,t),Cartesian3.multiplyByScalar(i[o+1],c.y,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(a[o],c.z,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(n[o],c.w,scratchTemp),Cartesian3.add(t,scratchTemp,t)};var scratchTimeVec$1=new Cartesian4,scratchTemp0=new Cartesian3,scratchTemp1=new Cartesian3;function createEvaluateFunction(u){var d=u.points,h=u.times;if(d.length<3){var r=h[0],n=1/(h[1]-r),a=d[0],o=d[1];return function(e,t){defined(t)||(t=new Cartesian3);var i=(e-r)*n;return Cartesian3.lerp(a,o,i,t)}}return function(e,t){defined(t)||(t=new Cartesian3);var i,r,n,a,o,s=u._lastTimeIndex=u.findTimeInterval(e,u._lastTimeIndex),l=(e-h[s])/(h[s+1]-h[s]),c=scratchTimeVec$1;return c.z=l,c.y=l*l,c.x=c.y*l,c.w=1,o=0===s?(i=d[0],r=d[1],n=u.firstTangent,a=Cartesian3.subtract(d[2],i,scratchTemp0),Cartesian3.multiplyByScalar(a,.5,a),Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,c,c)):s===d.length-2?(i=d[s],r=d[s+1],a=u.lastTangent,n=Cartesian3.subtract(r,d[s-1],scratchTemp0),Cartesian3.multiplyByScalar(n,.5,n),Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,c,c)):(i=d[s-1],r=d[s],n=d[s+1],a=d[s+2],Matrix4.multiplyByVector(CatmullRomSpline.catmullRomCoefficientMatrix,c,c)),t=Cartesian3.multiplyByScalar(i,o.x,t),Cartesian3.multiplyByScalar(r,o.y,scratchTemp1),Cartesian3.add(t,scratchTemp1,t),Cartesian3.multiplyByScalar(n,o.z,scratchTemp1),Cartesian3.add(t,scratchTemp1,t),Cartesian3.multiplyByScalar(a,o.w,scratchTemp1),Cartesian3.add(t,scratchTemp1,t)}}var firstTangentScratch=new Cartesian3,lastTangentScratch=new Cartesian3;function CatmullRomSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times,r=e.firstTangent,n=e.lastTangent;if(2<t.length&&(defined(r)||(r=firstTangentScratch,Cartesian3.multiplyByScalar(t[1],2,r),Cartesian3.subtract(r,t[2],r),Cartesian3.subtract(r,t[0],r),Cartesian3.multiplyByScalar(r,.5,r)),!defined(n))){var a=t.length-1;n=lastTangentScratch,Cartesian3.multiplyByScalar(t[a-1],2,n),Cartesian3.subtract(t[a],n,n),Cartesian3.add(n,t[a-2],n),Cartesian3.multiplyByScalar(n,.5,n)}this._times=i,this._points=t,this._firstTangent=Cartesian3.clone(r),this._lastTangent=Cartesian3.clone(n),this._evaluateFunction=createEvaluateFunction(this),this._lastTimeIndex=0}function getStringFromTypedArray(e,t,i){return t=defaultValue(t,0),i=defaultValue(i,e.byteLength-t),e=e.subarray(t,t+i),getStringFromTypedArray.decode(e)}function inRange(e,t,i){return t<=e&&e<=i}function utf8Handler(e){for(var t=0,i=0,r=0,n=128,a=191,o=[],s=e.length,l=0;l<s;++l){var c=e[l];if(0===r){if(inRange(c,0,127)){o.push(c);continue}if(inRange(c,194,223)){r=1,t=31&c;continue}if(inRange(c,224,239)){224===c&&(n=160),237===c&&(a=159),r=2,t=15&c;continue}if(inRange(c,240,244)){240===c&&(n=144),244===c&&(a=143),r=3,t=7&c;continue}throw new RuntimeError("String decoding failed.")}inRange(c,n,a)?(n=128,a=191,t=t<<6|63&c,++i===r&&(o.push(t),t=r=i=0)):(t=r=i=0,n=128,a=191,--l)}return o}defineProperties$1(CatmullRomSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},firstTangent:{get:function(){return this._firstTangent}},lastTangent:{get:function(){return this._lastTangent}}}),CatmullRomSpline.catmullRomCoefficientMatrix=new Matrix4(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0),CatmullRomSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,CatmullRomSpline.prototype.wrapTime=Spline.prototype.wrapTime,CatmullRomSpline.prototype.clampTime=Spline.prototype.clampTime,CatmullRomSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},getStringFromTypedArray.decodeWithTextDecoder=function(e){return new TextDecoder("utf-8").decode(e)},getStringFromTypedArray.decodeWithFromCharCode=function(e){for(var t="",i=utf8Handler(e),r=i.length,n=0;n<r;++n){var a=i[n];a<=65535?t+=String.fromCharCode(a):(a-=65536,t+=String.fromCharCode(55296+(a>>10),56320+(1023&a)))}return t},"undefined"!=typeof TextDecoder?getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithTextDecoder:getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithFromCharCode;var IndexDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case IndexDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},fromSizeInBytes:function(e){switch(e){case 2:return IndexDatatype.UNSIGNED_SHORT;case 4:return IndexDatatype.UNSIGNED_INT;case 1:return IndexDatatype.UNSIGNED_BYTE}},validate:function(e){return defined(e)&&(e===IndexDatatype.UNSIGNED_BYTE||e===IndexDatatype.UNSIGNED_SHORT||e===IndexDatatype.UNSIGNED_INT)},createTypedArray:function(e,t){return e>=CesiumMath.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},createTypedArrayFromArrayBuffer:function(e,t,i,r){return e>=CesiumMath.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,i,r):new Uint16Array(t,i,r)}},IndexDatatype$1=freezeObject$1(IndexDatatype),Intersections2D={};function QuantizedMeshTerrainData(e){this._quantizedVertices=e.quantizedVertices,this._encodedNormals=e.encodedNormals,this._indices=e.indices,this._minimumHeight=e.minimumHeight,this._maximumHeight=e.maximumHeight,this._boundingSphere=e.boundingSphere,this._orientedBoundingBox=e.orientedBoundingBox,this._horizonOcclusionPoint=e.horizonOcclusionPoint,this._credits=e.credits;var t=this._quantizedVertices.length/3,i=this._uValues=this._quantizedVertices.subarray(0,t),r=this._vValues=this._quantizedVertices.subarray(t,2*t);function n(e,t){return r[e]-r[t]}function a(e,t){return i[e]-i[t]}this._heightValues=this._quantizedVertices.subarray(2*t,3*t),this._westIndices=sortIndicesIfNecessary(e.westIndices,n,t),this._southIndices=sortIndicesIfNecessary(e.southIndices,a,t),this._eastIndices=sortIndicesIfNecessary(e.eastIndices,n,t),this._northIndices=sortIndicesIfNecessary(e.northIndices,a,t),this._westSkirtHeight=e.westSkirtHeight,this._southSkirtHeight=e.southSkirtHeight,this._eastSkirtHeight=e.eastSkirtHeight,this._northSkirtHeight=e.northSkirtHeight,this._childTileMask=defaultValue(e.childTileMask,15),this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._mesh=void 0}Intersections2D.clipTriangleAtAxisAlignedThreshold=function(e,t,i,r,n,a){var o,s,l;defined(a)?a.length=0:a=[],l=t?(o=i<e,s=r<e,n<e):(o=e<i,s=e<r,e<n);var c,u,d,h,p,m,f=o+s+l;return 1===f?o?(c=(e-i)/(r-i),u=(e-i)/(n-i),a.push(1),a.push(2),1!==u&&(a.push(-1),a.push(0),a.push(2),a.push(u)),1!==c&&(a.push(-1),a.push(0),a.push(1),a.push(c))):s?(d=(e-r)/(n-r),h=(e-r)/(i-r),a.push(2),a.push(0),1!==h&&(a.push(-1),a.push(1),a.push(0),a.push(h)),1!==d&&(a.push(-1),a.push(1),a.push(2),a.push(d))):l&&(p=(e-n)/(i-n),m=(e-n)/(r-n),a.push(0),a.push(1),1!==m&&(a.push(-1),a.push(2),a.push(1),a.push(m)),1!==p&&(a.push(-1),a.push(2),a.push(0),a.push(p))):2===f?o||i===e?s||r===e?l||n===e||(u=(e-i)/(n-i),d=(e-r)/(n-r),a.push(2),a.push(-1),a.push(0),a.push(2),a.push(u),a.push(-1),a.push(1),a.push(2),a.push(d)):(m=(e-n)/(r-n),c=(e-i)/(r-i),a.push(1),a.push(-1),a.push(2),a.push(1),a.push(m),a.push(-1),a.push(0),a.push(1),a.push(c)):(h=(e-r)/(i-r),p=(e-n)/(i-n),a.push(0),a.push(-1),a.push(1),a.push(0),a.push(h),a.push(-1),a.push(2),a.push(0),a.push(p)):3!==f&&(a.push(0),a.push(1),a.push(2)),a},Intersections2D.computeBarycentricCoordinates=function(e,t,i,r,n,a,o,s,l){var c=i-o,u=o-n,d=a-s,h=r-s,p=1/(d*c+u*h),m=t-s,f=e-o,g=(d*f+u*m)*p,_=(-h*f+c*m)*p,y=1-g-_;return defined(l)?(l.x=g,l.y=_,l.z=y,l):new Cartesian3(g,_,y)},Intersections2D.computeLineSegmentLineSegmentIntersection=function(e,t,i,r,n,a,o,s,l){var c=(s-a)*(i-e)-(o-n)*(r-t);if(0!=c){var u=((o-n)*(t-a)-(s-a)*(e-n))/c,d=((i-e)*(t-a)-(r-t)*(e-n))/c;return 0<=u&&u<=1&&0<=d&&d<=1?(defined(l)||(l=new Cartesian2),l.x=e+u*(i-e),l.y=t+u*(r-t),l):void 0}},defineProperties$1(QuantizedMeshTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}},canUpsample:{get:function(){return defined(this._mesh)}}});var arrayScratch=[];function sortIndicesIfNecessary(e,t,i){arrayScratch.length=e.length;for(var r=!1,n=0,a=e.length;n<a;++n)arrayScratch[n]=e[n],r=r||0<n&&0<t(e[n-1],e[n]);return r?(arrayScratch.sort(t),IndexDatatype$1.createTypedArray(i,arrayScratch)):e}var createMeshTaskProcessor=new TaskProcessor("createVerticesFromQuantizedTerrainMesh");QuantizedMeshTerrainData.prototype.createMesh=function(e,t,i,r,h){var n=e.ellipsoid,a=e.tileXYToRectangle(t,i,r);h=defaultValue(h,1);var o=createMeshTaskProcessor.scheduleTask({minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,quantizedVertices:this._quantizedVertices,octEncodedNormals:this._encodedNormals,includeWebMercatorT:!0,indices:this._indices,westIndices:this._westIndices,southIndices:this._southIndices,eastIndices:this._eastIndices,northIndices:this._northIndices,westSkirtHeight:this._westSkirtHeight,southSkirtHeight:this._southSkirtHeight,eastSkirtHeight:this._eastSkirtHeight,northSkirtHeight:this._northSkirtHeight,rectangle:a,relativeToCenter:this._boundingSphere.center,ellipsoid:n,exaggeration:h});if(defined(o)){var p=this;return when(o,function(e){var t=p._quantizedVertices.length/3;t+=p._westIndices.length+p._southIndices.length+p._eastIndices.length+p._northIndices.length;var i=IndexDatatype$1.createTypedArray(t,e.indices),r=new Float32Array(e.vertices),n=e.center,a=e.minimumHeight,o=e.maximumHeight,s=defaultValue(BoundingSphere.clone(e.boundingSphere),p._boundingSphere),l=defaultValue(OrientedBoundingBox.clone(e.orientedBoundingBox),p._orientedBoundingBox),c=Cartesian3.clone(p._horizonOcclusionPoint),u=e.vertexStride,d=TerrainEncoding.clone(e.encoding);return p._skirtIndex=e.skirtIndex,p._vertexCountWithoutSkirts=p._quantizedVertices.length/3,p._mesh=new TerrainMesh(n,r,i,a,o,s,c,u,l,d,h,e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),p._quantizedVertices=void 0,p._encodedNormals=void 0,p._indices=void 0,p._uValues=void 0,p._vValues=void 0,p._heightValues=void 0,p._westIndices=void 0,p._southIndices=void 0,p._eastIndices=void 0,p._northIndices=void 0,p._mesh})}};var upsampleTaskProcessor=new TaskProcessor("upsampleQuantizedTerrainMesh");QuantizedMeshTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(this._mesh)){var l=2*t!==n,c=2*i===a,u=e.ellipsoid,d=e.tileXYToRectangle(n,a,o),h=upsampleTaskProcessor.scheduleTask({vertices:s.vertices,vertexCountWithoutSkirts:this._vertexCountWithoutSkirts,indices:s.indices,skirtIndex:this._skirtIndex,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:l,isNorthChild:c,childRectangle:d,ellipsoid:u,exaggeration:s.exaggeration});if(defined(h)){var p=Math.min(this._westSkirtHeight,this._eastSkirtHeight);p=Math.min(p,this._southSkirtHeight),p=Math.min(p,this._northSkirtHeight);var m=l?.5*p:this._westSkirtHeight,f=c?.5*p:this._southSkirtHeight,g=l?this._eastSkirtHeight:.5*p,_=c?this._northSkirtHeight:.5*p,y=this._credits;return when(h).then(function(e){var t,i=new Uint16Array(e.vertices),r=IndexDatatype$1.createTypedArray(i.length/3,e.indices);return defined(e.encodedNormals)&&(t=new Uint8Array(e.encodedNormals)),new QuantizedMeshTerrainData({quantizedVertices:i,indices:r,encodedNormals:t,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:m,southSkirtHeight:f,eastSkirtHeight:g,northSkirtHeight:_,childTileMask:0,credits:y,createdByUpsampling:!0})})}}};var maxShort=32767,barycentricCoordinateScratch=new Cartesian3;function pointInBoundingBox(e,t,i,r,n,a,o,s){var l=Math.min(i,n,o),c=Math.max(i,n,o),u=Math.min(r,a,s),d=Math.max(r,a,s);return l<=e&&e<=c&&u<=t&&t<=d}QuantizedMeshTerrainData.prototype.interpolateHeight=function(e,t,i){var r=CesiumMath.clamp((t-e.west)/e.width,0,1);r*=maxShort;var n=CesiumMath.clamp((i-e.south)/e.height,0,1);return n*=maxShort,defined(this._mesh)?interpolateMeshHeight$1(this,r,n):interpolateHeight$1(this,r,n)};var texCoordScratch0=new Cartesian2,texCoordScratch1=new Cartesian2,texCoordScratch2=new Cartesian2;function interpolateMeshHeight$1(e,t,i){for(var r=e._mesh,n=r.vertices,a=r.encoding,o=r.indices,s=0,l=o.length;s<l;s+=3){var c=o[s],u=o[s+1],d=o[s+2],h=a.decodeTextureCoordinates(n,c,texCoordScratch0),p=a.decodeTextureCoordinates(n,u,texCoordScratch1),m=a.decodeTextureCoordinates(n,d,texCoordScratch2);if(pointInBoundingBox(t,i,h.x,h.y,p.x,p.y,m.x,m.y)){var f=Intersections2D.computeBarycentricCoordinates(t,i,h.x,h.y,p.x,p.y,m.x,m.y,barycentricCoordinateScratch);if(-1e-15<=f.x&&-1e-15<=f.y&&-1e-15<=f.z){var g=a.decodeHeight(n,c),_=a.decodeHeight(n,u),y=a.decodeHeight(n,d);return f.x*g+f.y*_+f.z*y}}}}function interpolateHeight$1(e,t,i){for(var r=e._uValues,n=e._vValues,a=e._heightValues,o=e._indices,s=0,l=o.length;s<l;s+=3){var c=o[s],u=o[s+1],d=o[s+2],h=r[c],p=r[u],m=r[d],f=n[c],g=n[u],_=n[d];if(pointInBoundingBox(t,i,h,f,p,g,m,_)){var y=Intersections2D.computeBarycentricCoordinates(t,i,h,f,p,g,m,_,barycentricCoordinateScratch);if(-1e-15<=y.x&&-1e-15<=y.y&&-1e-15<=y.z){var v=y.x*a[c]+y.y*a[u]+y.z*a[d];return CesiumMath.lerp(e._minimumHeight,e._maximumHeight,v/maxShort)}}}}function LayerInformation(e){this.resource=e.resource,this.version=e.version,this.isHeightmap=e.isHeightmap,this.tileUrlTemplates=e.tileUrlTemplates,this.availability=e.availability,this.hasVertexNormals=e.hasVertexNormals,this.hasWaterMask=e.hasWaterMask,this.hasMetadata=e.hasMetadata,this.availabilityLevels=e.availabilityLevels,this.availabilityTilesLoaded=e.availabilityTilesLoaded,this.littleEndianExtensionSize=e.littleEndianExtensionSize,this.availabilityTilesLoaded=e.availabilityTilesLoaded,this.availabilityPromiseCache={}}function CesiumTerrainProvider(e){this._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1,ellipsoid:e.ellipsoid}),this._heightmapWidth=65,this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,this._heightmapWidth,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._heightmapStructure=void 0,this._hasWaterMask=!1,this._hasVertexNormals=!1,this._requestVertexNormals=defaultValue(e.requestVertexNormals,!1),this._requestWaterMask=defaultValue(e.requestWaterMask,!1),this._requestMetadata=defaultValue(e.requestMetadata,!0),this._errorEvent=new Event;var t=e.credit;"string"==typeof t&&(t=new Credit(t)),this._credit=t,this._availability=void 0;var i=when.defer();this._ready=!1,this._readyPromise=i,this._tileCredits=void 0;var S,T,x,b=this,E=this._layers=[],P="",A=[],w=0;function D(e){var t;if(!e.format)return t="The tile format is not specified in the layer.json file.",void(x=TileProviderError.handleError(x,b,b._errorEvent,t,void 0,void 0,void 0,I));if(!e.tiles||0===e.tiles.length)return t="The layer.json file does not specify any tile URL templates.",void(x=TileProviderError.handleError(x,b,b._errorEvent,t,void 0,void 0,void 0,I));var i=!1,r=!1,n=!1,a=!0,o=!1;if("heightmap-1.0"===e.format)o=!0,defined(b._heightmapStructure)||(b._heightmapStructure={heightScale:.2,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1,lowestEncodedHeight:0,highestEncodedHeight:65535}),r=!0,b._requestWaterMask=!0;else if(0!==e.format.indexOf("quantized-mesh-1."))return t='The tile format "'+e.format+'" is invalid or not supported.',void(x=TileProviderError.handleError(x,b,b._errorEvent,t,void 0,void 0,void 0,I));var s,l=e.tiles,c=e.maxzoom;w=Math.max(w,c),defined(e.extensions)&&-1!==e.extensions.indexOf("octvertexnormals")?i=!0:defined(e.extensions)&&-1!==e.extensions.indexOf("vertexnormals")&&(a=!(i=!0)),defined(e.extensions)&&-1!==e.extensions.indexOf("watermask")&&(r=!0),defined(e.extensions)&&-1!==e.extensions.indexOf("metadata")&&(n=!0);var u,d=e.metadataAvailability,h=e.available;if(defined(h)&&!defined(d)){u=new TileAvailability(b._tilingScheme,h.length);for(var p=0;p<h.length;++p){var m=h[p],f=b._tilingScheme.getNumberOfYTilesAtLevel(p);defined(A[p])||(A[p]=[]);for(var g=0;g<m.length;++g){var _=m[g],y=f-_.endY-1,v=f-_.startY-1;A[p].push([_.startX,y,_.endX,v]),u.addAvailableTileRange(p,_.startX,y,_.endX,v)}}}else defined(d)&&(s=new TileAvailability(b._tilingScheme,c),u=new TileAvailability(b._tilingScheme,c),A[0]=[[0,0,1,0]],u.addAvailableTileRange(0,0,0,1,0));b._hasWaterMask=b._hasWaterMask||r,b._hasVertexNormals=b._hasVertexNormals||i,b._hasMetadata=b._hasMetadata||n,defined(e.attribution)&&(0<P.length&&(P+=" "),P+=e.attribution),E.push(new LayerInformation({resource:S,version:e.version,isHeightmap:o,tileUrlTemplates:l,availability:u,hasVertexNormals:i,hasWaterMask:r,hasMetadata:n,availabilityLevels:d,availabilityTilesLoaded:s,littleEndianExtensionSize:a}));var C=e.parentUrl;return defined(C)?defined(u)?((S=S.getDerivedResource({url:C})).appendForwardSlash(),when((T=S.getDerivedResource({url:"layer.json"})).fetchJson(),D,M)):(console.log("A layer.json can't have a parentUrl if it does't have an available array."),when.resolve()):when.resolve()}function M(e){var t="An error occurred while accessing "+T.url+".";x=TileProviderError.handleError(x,b,b._errorEvent,t,void 0,void 0,void 0,I)}function r(e){D(e).then(function(){if(!defined(x)){var e=A.length;if(0<e)for(var t=b._availability=new TileAvailability(b._tilingScheme,w),i=0;i<e;++i)for(var r=A[i],n=0;n<r.length;++n){var a=r[n];t.addAvailableTileRange(i,a[0],a[1],a[2],a[3])}if(0<P.length){var o=new Credit(P);defined(b._tileCredits)?b._tileCredits.push(o):b._tileCredits=[o]}b._ready=!0,b._readyPromise.resolve(!0)}})}function n(e){defined(e)&&404===e.statusCode?r({tilejson:"2.1.0",format:"heightmap-1.0",version:"1.0.0",scheme:"tms",tiles:["{z}/{x}/{y}.terrain?v={version}"]}):M()}function I(){when(T.fetchJson()).then(r).otherwise(n)}when(e.url).then(function(e){var t=Resource.createIfNeeded(e);t.appendForwardSlash(),T=(S=t).getDerivedResource({url:"layer.json"}),b._tileCredits=t.credits,I()}).otherwise(function(e){i.reject(e)})}QuantizedMeshTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},QuantizedMeshTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var QuantizedMeshExtensionIds={OCT_VERTEX_NORMALS:1,WATER_MASK:2,METADATA:4};function getRequestHeader(e){return defined(e)&&0!==e.length?{Accept:"application/vnd.quantized-mesh;extensions="+e.join("-")+",application/octet-stream;q=0.9,*/*;q=0.01"}:{Accept:"application/vnd.quantized-mesh,application/octet-stream;q=0.9,*/*;q=0.01"}}function createHeightmapTerrainData(e,t,i,r,n,a){var o=new Uint16Array(t,0,e._heightmapWidth*e._heightmapWidth);return new HeightmapTerrainData({buffer:o,childTileMask:new Uint8Array(t,o.byteLength,1)[0],waterMask:new Uint8Array(t,o.byteLength+1,t.byteLength-o.byteLength-1),width:e._heightmapWidth,height:e._heightmapWidth,structure:e._heightmapStructure,credits:e._tileCredits})}function createQuantizedMeshTerrainData(e,t,i,r,n,a,o){var s=o.littleEndianExtensionSize,l=0,c=3*Float64Array.BYTES_PER_ELEMENT,u=4*Float64Array.BYTES_PER_ELEMENT,d=3*Uint16Array.BYTES_PER_ELEMENT,h=Uint16Array.BYTES_PER_ELEMENT,p=3*h,m=new DataView(t),f=new Cartesian3(m.getFloat64(l,!0),m.getFloat64(l+8,!0),m.getFloat64(l+16,!0));l+=c;var g=m.getFloat32(l,!0);l+=Float32Array.BYTES_PER_ELEMENT;var _=m.getFloat32(l,!0);l+=Float32Array.BYTES_PER_ELEMENT;var y=new BoundingSphere(new Cartesian3(m.getFloat64(l,!0),m.getFloat64(l+8,!0),m.getFloat64(l+16,!0)),m.getFloat64(l+c,!0));l+=u;var v=new Cartesian3(m.getFloat64(l,!0),m.getFloat64(l+8,!0),m.getFloat64(l+16,!0));l+=c;var C=m.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var S=new Uint16Array(t,l,3*C);l+=C*d,65536<C&&(p=3*(h=Uint32Array.BYTES_PER_ELEMENT));var T=S.subarray(0,C),x=S.subarray(C,2*C),b=S.subarray(2*C,3*C);AttributeCompression.zigZagDeltaDecode(T,x,b),l%h!=0&&(l+=h-l%h);var E=m.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var P=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,l,3*E);l+=E*p;for(var A=0,w=P.length,D=0;D<w;++D){var M=P[D];P[D]=A-M,0===M&&++A}var I=m.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var R=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,l,I);l+=I*h;var O=m.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var L=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,l,O);l+=O*h;var F=m.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var N=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,l,F);l+=F*h;var V=m.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var B,k,$=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,l,V);for(l+=V*h;l<m.byteLength;){var z=m.getUint8(l,!0);l+=Uint8Array.BYTES_PER_ELEMENT;var U=m.getUint32(l,s);if(l+=Uint32Array.BYTES_PER_ELEMENT,z===QuantizedMeshExtensionIds.OCT_VERTEX_NORMALS&&e._requestVertexNormals)B=new Uint8Array(t,l,2*C);else if(z===QuantizedMeshExtensionIds.WATER_MASK&&e._requestWaterMask)k=new Uint8Array(t,l,U);else if(z===QuantizedMeshExtensionIds.METADATA&&e._requestMetadata){var G=m.getUint32(l,!0);if(0<G){var H=getStringFromTypedArray(new Uint8Array(t),l+Uint32Array.BYTES_PER_ELEMENT,G),W=JSON.parse(H).available;if(defined(W))for(var q=0;q<W.length;++q)for(var j=i+q+1,Y=W[q],X=e._tilingScheme.getNumberOfYTilesAtLevel(j),Q=0;Q<Y.length;++Q){var J=Y[Q],Z=X-J.endY-1,K=X-J.startY-1;e.availability.addAvailableTileRange(j,J.startX,Z,J.endX,K),o.availability.addAvailableTileRange(j,J.startX,Z,J.endX,K)}}o.availabilityTilesLoaded.addAvailableTileRange(i,r,n,r,n)}l+=U}var ee,te=5*e.getLevelMaximumGeometricError(i),ie=e._tilingScheme.tileXYToRectangle(r,n,i);return ie.width<CesiumMath.PI_OVER_TWO+CesiumMath.EPSILON5&&(ee=OrientedBoundingBox.fromRectangle(ie,g,_,e._tilingScheme.ellipsoid)),new QuantizedMeshTerrainData({center:f,minimumHeight:g,maximumHeight:_,boundingSphere:y,orientedBoundingBox:ee,horizonOcclusionPoint:v,quantizedVertices:S,encodedNormals:B,indices:P,westIndices:R,southIndices:L,eastIndices:N,northIndices:$,westSkirtHeight:te,southSkirtHeight:te,eastSkirtHeight:te,northSkirtHeight:te,childTileMask:e.availability.computeChildMaskForTile(i,r,n),waterMask:k,credits:e._tileCredits})}function requestTileGeometry(t,i,r,n,a,e){if(!defined(a))return when.reject(new RuntimeError("Terrain tile doesn't exist"));var o=a.tileUrlTemplates;if(0!==o.length){var s,l,c=t._tilingScheme.getNumberOfYTilesAtLevel(n)-r-1,u=[];t._requestVertexNormals&&a.hasVertexNormals&&u.push(a.littleEndianExtensionSize?"octvertexnormals":"vertexnormals"),t._requestWaterMask&&a.hasWaterMask&&u.push("watermask"),t._requestMetadata&&a.hasMetadata&&u.push("metadata");var d=o[(i+c+n)%o.length],h=a.resource;s=defined(h._ionEndpoint)&&!defined(h._ionEndpoint.externalType)?(0!==u.length&&(l={extensions:u.join("-")}),getRequestHeader(void 0)):getRequestHeader(u);var p=h.getDerivedResource({url:d,templateValues:{version:a.version,z:n,x:i,y:c},queryParameters:l,headers:s,request:e}).fetchArrayBuffer();if(defined(p))return p.then(function(e){return defined(t._heightmapStructure)?createHeightmapTerrainData(t,e):createQuantizedMeshTerrainData(t,e,n,i,r,c,a)})}}function getAvailabilityTile(e,t,i,r){if(0!==r){var n=e.availabilityLevels,a=r%n==0?r-n:(r/n|0)*n,o=1<<r-a;return{level:a,x:t/o|0,y:i/o|0}}}function checkLayer(e,t,i,r,n,a){if(!defined(n.availabilityLevels))return{result:!1};for(var o,s=function(){delete n.availabilityPromiseCache[o]},l=n.availabilityTilesLoaded,c=n.availability,u=getAvailabilityTile(n,t,i,r);defined(u);){if(c.isTileAvailable(u.level,u.x,u.y)&&!l.isTileAvailable(u.level,u.x,u.y)){var d;if(!a&&(o=u.level+"-"+u.x+"-"+u.y,!defined(d=n.availabilityPromiseCache[o]))){var h=new Request({throttle:!0,throttleByServer:!0,type:RequestType$1.TERRAIN});defined(d=requestTileGeometry(e,u.x,u.y,u.level,n,h))&&(n.availabilityPromiseCache[o]=d).then(s)}return{result:!0,promise:d}}u=getAvailabilityTile(n,u.x,u.y,u.level)}return{result:!1}}CesiumTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n,a=this._layers,o=a.length;if(1===o)n=a[0];else for(var s=0;s<o;++s){var l=a[s];if(!defined(l.availability)||l.availability.isTileAvailable(i,e,t)){n=l;break}}return requestTileGeometry(this,e,t,i,n,r)},defineProperties$1(CesiumTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return this._hasWaterMask&&this._requestWaterMask}},hasVertexNormals:{get:function(){return this._hasVertexNormals&&this._requestVertexNormals}},hasMetadata:{get:function(){return this._hasMetadata&&this._requestMetadata}},requestVertexNormals:{get:function(){return this._requestVertexNormals}},requestWaterMask:{get:function(){return this._requestWaterMask}},requestMetadata:{get:function(){return this._requestMetadata}},availability:{get:function(){return this._availability}}}),CesiumTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},CesiumTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){if(defined(this._availability)){if(i>this._availability._maximumLevel)return!1;if(this._availability.isTileAvailable(i,e,t))return!0;if(!this._hasMetadata)return!1;for(var r=this._layers,n=r.length,a=0;a<n;++a){if(checkLayer(this,e,t,i,r[a],0===a).result)return}return!1}},CesiumTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){if(!(!defined(this._availability)||i>this._availability._maximumLevel||this._availability.isTileAvailable(i,e,t))&&this._hasMetadata)for(var r=this._layers,n=r.length,a=0;a<n;++a){var o=checkLayer(this,e,t,i,r[a],0===a);if(defined(o.promise))return o.promise}},CesiumTerrainProvider._getAvailabilityTile=getAvailabilityTile;var EllipseGeometryLibrary={},rotAxis=new Cartesian3,tempVec=new Cartesian3,unitQuat=new Quaternion,rotMtx=new Matrix3;function pointOnEllipsoid(e,t,i,r,n,a,o,s,l,c){var u=e+t;Cartesian3.multiplyByScalar(r,Math.cos(u),rotAxis),Cartesian3.multiplyByScalar(i,Math.sin(u),tempVec),Cartesian3.add(rotAxis,tempVec,rotAxis);var d=Math.cos(e);d*=d;var h=Math.sin(e);h*=h;var p=a/Math.sqrt(o*d+n*h)/s;return Quaternion.fromAxisAngle(rotAxis,p,unitQuat),Matrix3.fromQuaternion(unitQuat,rotMtx),Matrix3.multiplyByVector(rotMtx,l,c),Cartesian3.normalize(c,c),Cartesian3.multiplyByScalar(c,s,c),c}var scratchCartesian1$1=new Cartesian3,scratchCartesian2$1=new Cartesian3,scratchCartesian3$2=new Cartesian3,scratchNormal$1=new Cartesian3;EllipseGeometryLibrary.raisePositionsToHeight=function(e,t,i){for(var r=t.ellipsoid,n=t.height,a=t.extrudedHeight,o=i?e.length/3*2:e.length/3,s=new Float64Array(3*o),l=e.length,c=i?l:0,u=0;u<l;u+=3){var d=u+1,h=u+2,p=Cartesian3.fromArray(e,u,scratchCartesian1$1);r.scaleToGeodeticSurface(p,p);var m=Cartesian3.clone(p,scratchCartesian2$1),f=r.geodeticSurfaceNormal(p,scratchNormal$1),g=Cartesian3.multiplyByScalar(f,n,scratchCartesian3$2);Cartesian3.add(p,g,p),i&&(Cartesian3.multiplyByScalar(f,a,g),Cartesian3.add(m,g,m),s[u+c]=m.x,s[d+c]=m.y,s[h+c]=m.z),s[u]=p.x,s[d]=p.y,s[h]=p.z}return s};var unitPosScratch=new Cartesian3,eastVecScratch=new Cartesian3,northVecScratch=new Cartesian3;function GeometryInstance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.geometry=e.geometry,this.modelMatrix=Matrix4.clone(defaultValue(e.modelMatrix,Matrix4.IDENTITY)),this.id=e.id,this.pickPrimitive=e.pickPrimitive,this.attributes=defaultValue(e.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}EllipseGeometryLibrary.computeEllipsePositions=function(e,t,i){var r=e.semiMinorAxis,n=e.semiMajorAxis,a=e.rotation,o=e.center,s=8*e.granularity,l=r*r,c=n*n,u=n*r,d=Cartesian3.magnitude(o),h=Cartesian3.normalize(o,unitPosScratch),p=Cartesian3.cross(Cartesian3.UNIT_Z,o,eastVecScratch);p=Cartesian3.normalize(p,p);var m=Cartesian3.cross(h,p,northVecScratch),f=1+Math.ceil(CesiumMath.PI_OVER_TWO/s),g=CesiumMath.PI_OVER_TWO/(f-1),_=CesiumMath.PI_OVER_TWO-f*g;_<0&&(f-=Math.ceil(Math.abs(_)/g));var y,v,C,S,T,x=t?new Array(3*(f*(f+2)*2)):void 0,b=0,E=scratchCartesian1$1,P=scratchCartesian2$1,A=4*f*3,w=A-1,D=0,M=i?new Array(A):void 0;for(E=pointOnEllipsoid(_=CesiumMath.PI_OVER_TWO,a,m,p,l,u,c,d,h,E),t&&(x[b++]=E.x,x[b++]=E.y,x[b++]=E.z),i&&(M[w--]=E.z,M[w--]=E.y,M[w--]=E.x),_=CesiumMath.PI_OVER_TWO-g,y=1;y<f+1;++y){if(E=pointOnEllipsoid(_,a,m,p,l,u,c,d,h,E),P=pointOnEllipsoid(Math.PI-_,a,m,p,l,u,c,d,h,P),t){for(x[b++]=E.x,x[b++]=E.y,x[b++]=E.z,C=2*y+2,v=1;v<C-1;++v)S=v/(C-1),T=Cartesian3.lerp(E,P,S,scratchCartesian3$2),x[b++]=T.x,x[b++]=T.y,x[b++]=T.z;x[b++]=P.x,x[b++]=P.y,x[b++]=P.z}i&&(M[w--]=E.z,M[w--]=E.y,M[w--]=E.x,M[D++]=P.x,M[D++]=P.y,M[D++]=P.z),_=CesiumMath.PI_OVER_TWO-(y+1)*g}for(y=f;1<y;--y){if(E=pointOnEllipsoid(-(_=CesiumMath.PI_OVER_TWO-(y-1)*g),a,m,p,l,u,c,d,h,E),P=pointOnEllipsoid(_+Math.PI,a,m,p,l,u,c,d,h,P),t){for(x[b++]=E.x,x[b++]=E.y,x[b++]=E.z,C=2*(y-1)+2,v=1;v<C-1;++v)S=v/(C-1),T=Cartesian3.lerp(E,P,S,scratchCartesian3$2),x[b++]=T.x,x[b++]=T.y,x[b++]=T.z;x[b++]=P.x,x[b++]=P.y,x[b++]=P.z}i&&(M[w--]=E.z,M[w--]=E.y,M[w--]=E.x,M[D++]=P.x,M[D++]=P.y,M[D++]=P.z)}E=pointOnEllipsoid(-(_=CesiumMath.PI_OVER_TWO),a,m,p,l,u,c,d,h,E);var I={};return t&&(x[b++]=E.x,x[b++]=E.y,x[b++]=E.z,I.positions=x,I.numPts=f),i&&(M[w--]=E.z,M[w--]=E.y,M[w--]=E.x,I.outerPositions=M),I};var scratchCartesian1$2=new Cartesian3,scratchCartesian2$2=new Cartesian3,scratchCartesian3$3=new Cartesian3;function barycentricCoordinates(e,t,i,r,n){var a,o,s,l,c,u,d,h;if(defined(n)||(n=new Cartesian3),defined(t.z)){if(Cartesian3.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,n);if(Cartesian3.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,n);if(Cartesian3.equalsEpsilon(e,r,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,n);a=Cartesian3.subtract(i,t,scratchCartesian1$2),o=Cartesian3.subtract(r,t,scratchCartesian2$2),s=Cartesian3.subtract(e,t,scratchCartesian3$3),l=Cartesian3.dot(a,a),c=Cartesian3.dot(a,o),u=Cartesian3.dot(a,s),d=Cartesian3.dot(o,o),h=Cartesian3.dot(o,s)}else{if(Cartesian2.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,n);if(Cartesian2.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,n);if(Cartesian2.equalsEpsilon(e,r,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,n);a=Cartesian2.subtract(i,t,scratchCartesian1$2),o=Cartesian2.subtract(r,t,scratchCartesian2$2),s=Cartesian2.subtract(e,t,scratchCartesian3$3),l=Cartesian2.dot(a,a),c=Cartesian2.dot(a,o),u=Cartesian2.dot(a,s),d=Cartesian2.dot(o,o),h=Cartesian2.dot(o,s)}n.y=d*u-c*h,n.z=l*h-c*u;var p=l*d-c*c;return 0!==n.y&&(n.y/=p),0!==n.z&&(n.z/=p),n.x=1-n.y-n.z,n}function EncodedCartesian3(){this.high=Cartesian3.clone(Cartesian3.ZERO),this.low=Cartesian3.clone(Cartesian3.ZERO)}EncodedCartesian3.encode=function(e,t){var i;return defined(t)||(t={high:0,low:0}),0<=e?(i=65536*Math.floor(e/65536),t.high=i,t.low=e-i):(i=65536*Math.floor(-e/65536),t.high=-i,t.low=e+i),t};var scratchEncode={high:0,low:0};EncodedCartesian3.fromCartesian=function(e,t){defined(t)||(t=new EncodedCartesian3);var i=t.high,r=t.low;return EncodedCartesian3.encode(e.x,scratchEncode),i.x=scratchEncode.high,r.x=scratchEncode.low,EncodedCartesian3.encode(e.y,scratchEncode),i.y=scratchEncode.high,r.y=scratchEncode.low,EncodedCartesian3.encode(e.z,scratchEncode),i.z=scratchEncode.high,r.z=scratchEncode.low,t};var encodedP=new EncodedCartesian3;EncodedCartesian3.writeElements=function(e,t,i){EncodedCartesian3.fromCartesian(e,encodedP);var r=encodedP.high,n=encodedP.low;t[i]=r.x,t[i+1]=r.y,t[i+2]=r.z,t[i+3]=n.x,t[i+4]=n.y,t[i+5]=n.z};var Tipsify={calculateACMR:function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,i=e.maximumIndex,r=defaultValue(e.cacheSize,24),n=t.length;if(!defined(i))for(var a=i=0,o=t[a];a<n;)i<o&&(i=o),o=t[++a];for(var s=[],l=0;l<i+1;l++)s[l]=0;for(var c=r+1,u=0;u<n;++u)c-s[t[u]]>r&&(s[t[u]]=c,++c);return(c-r+1)/(n/3)}};Tipsify.tipsify=function(e){var h,t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,i=e.maximumIndex,r=defaultValue(e.cacheSize,24);function n(e,t,i,r,n,a,o){for(var s,l=-1,c=-1,u=0;u<i.length;){var d=i[u];r[d].numLiveTriangles&&(s=0,n-r[d].timeStamp+2*r[d].numLiveTriangles<=t&&(s=n-r[d].timeStamp),(c<s||-1===c)&&(c=s,l=d)),++u}return-1===l?function(e,t,i,r){for(;1<=t.length;){var n=t[t.length-1];if(t.splice(t.length-1,1),0<e[n].numLiveTriangles)return n}for(;h<r;){if(0<e[h].numLiveTriangles)return++h-1;++h}return-1}(r,a,0,o):l}var a=t.length,o=0,s=0,l=t[s],c=a;if(defined(i))o=i+1;else{for(;s<c;)o<l&&(o=l),l=t[++s];if(-1===o)return 0;++o}var u,d=[];for(u=0;u<o;u++)d[u]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};for(var p=s=0;s<c;)d[t[s]].vertexTriangles.push(p),++d[t[s]].numLiveTriangles,d[t[s+1]].vertexTriangles.push(p),++d[t[s+1]].numLiveTriangles,d[t[s+2]].vertexTriangles.push(p),++d[t[s+2]].numLiveTriangles,++p,s+=3;var m=0,f=r+1;h=1;var g,_,y,v,C=[],S=[],T=0,x=[],b=a/3,E=[];for(u=0;u<b;u++)E[u]=!1;for(;-1!==m;){C=[],v=(_=d[m]).vertexTriangles.length;for(var P=0;P<v;++P)if(!E[p=_.vertexTriangles[P]]){E[p]=!0,s=p+p+p;for(var A=0;A<3;++A)y=t[s],C.push(y),S.push(y),x[T]=y,++T,--(g=d[y]).numLiveTriangles,f-g.timeStamp>r&&(g.timeStamp=f,++f),++s}m=n(0,r,C,d,f,S,o)}return x};var GeometryPipeline={};function addTriangle(e,t,i,r,n){e[t++]=i,e[t++]=r,e[t++]=r,e[t++]=n,e[t++]=n,e[t]=i}function trianglesToLines(e){for(var t=e.length,i=t/3*6,r=IndexDatatype$1.createTypedArray(t,i),n=0,a=0;a<t;a+=3,n+=6)addTriangle(r,n,e[a],e[a+1],e[a+2]);return r}function triangleStripToLines(e){var t=e.length;if(3<=t){var i=6*(t-2),r=IndexDatatype$1.createTypedArray(t,i);addTriangle(r,0,e[0],e[1],e[2]);for(var n=6,a=3;a<t;++a,n+=6)addTriangle(r,n,e[a-1],e[a],e[a-2]);return r}return new Uint16Array}function triangleFanToLines(e){if(0<e.length){for(var t=e.length-1,i=6*(t-1),r=IndexDatatype$1.createTypedArray(t,i),n=e[0],a=0,o=1;o<t;++o,a+=6)addTriangle(r,a,n,e[o],e[o+1]);return r}return new Uint16Array}function copyAttributesDescriptions(e){var t={};for(var i in e)if(e.hasOwnProperty(i)&&defined(e[i])&&defined(e[i].values)){var r=e[i];t[i]=new GeometryAttribute({componentDatatype:r.componentDatatype,componentsPerAttribute:r.componentsPerAttribute,normalize:r.normalize,values:[]})}return t}function copyVertex(e,t,i){for(var r in t)if(t.hasOwnProperty(r)&&defined(t[r])&&defined(t[r].values))for(var n=t[r],a=0;a<n.componentsPerAttribute;++a)e[r].values.push(n.values[i*n.componentsPerAttribute+a])}GeometryPipeline.toWireframe=function(e){var t=e.indices;if(defined(t)){switch(e.primitiveType){case PrimitiveType$1.TRIANGLES:e.indices=trianglesToLines(t);break;case PrimitiveType$1.TRIANGLE_STRIP:e.indices=triangleStripToLines(t);break;case PrimitiveType$1.TRIANGLE_FAN:e.indices=triangleFanToLines(t)}e.primitiveType=PrimitiveType$1.LINES}return e},GeometryPipeline.createLineSegmentsForVectors=function(e,t,i){t=defaultValue(t,"normal"),i=defaultValue(i,1e4);for(var r,n=e.attributes.position.values,a=e.attributes[t].values,o=n.length,s=new Float64Array(2*o),l=0,c=0;c<o;c+=3)s[l++]=n[c],s[l++]=n[c+1],s[l++]=n[c+2],s[l++]=n[c]+a[c]*i,s[l++]=n[c+1]+a[c+1]*i,s[l++]=n[c+2]+a[c+2]*i;var u=e.boundingSphere;return defined(u)&&(r=new BoundingSphere(u.center,u.radius+i)),new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},primitiveType:PrimitiveType$1.LINES,boundingSphere:r})},GeometryPipeline.createAttributeLocations=function(e){var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],r=e.attributes,n={},a=0,o=i.length;for(t=0;t<o;++t){var s=i[t];defined(r[s])&&(n[s]=a++)}for(var l in r)r.hasOwnProperty(l)&&!defined(n[l])&&(n[l]=a++);return n},GeometryPipeline.reorderForPreVertexCache=function(e){var t=Geometry.computeNumberOfVertices(e),i=e.indices;if(defined(i)){for(var r=new Int32Array(t),n=0;n<t;n++)r[n]=-1;for(var a,o=i,s=o.length,l=IndexDatatype$1.createTypedArray(t,s),c=0,u=0,d=0;c<s;)-1!==(a=r[o[c]])?l[u]=a:(r[a=o[c]]=d,l[u]=d,++d),++c,++u;e.indices=l;var h=e.attributes;for(var p in h)if(h.hasOwnProperty(p)&&defined(h[p])&&defined(h[p].values)){for(var m=h[p],f=m.values,g=0,_=m.componentsPerAttribute,y=ComponentDatatype$1.createTypedArray(m.componentDatatype,d*_);g<t;){var v=r[g];if(-1!==v)for(var C=0;C<_;C++)y[_*v+C]=f[_*g+C];++g}m.values=y}}return e},GeometryPipeline.reorderForPostVertexCache=function(e,t){var i=e.indices;if(e.primitiveType===PrimitiveType$1.TRIANGLES&&defined(i)){for(var r=i.length,n=0,a=0;a<r;a++)i[a]>n&&(n=i[a]);e.indices=Tipsify.tipsify({indices:i,maximumIndex:n,cacheSize:t})}return e},GeometryPipeline.fitToUnsignedShortIndices=function(e){var t=[],i=Geometry.computeNumberOfVertices(e);if(defined(e.indices)&&i>=CesiumMath.SIXTY_FOUR_KILOBYTES){var r,n=[],a=[],o=0,s=copyAttributesDescriptions(e.attributes),l=e.indices,c=l.length;e.primitiveType===PrimitiveType$1.TRIANGLES?r=3:e.primitiveType===PrimitiveType$1.LINES?r=2:e.primitiveType===PrimitiveType$1.POINTS&&(r=1);for(var u=0;u<c;u+=r){for(var d=0;d<r;++d){var h=l[u+d],p=n[h];defined(p)||(p=o++,n[h]=p,copyVertex(s,e.attributes,h)),a.push(p)}o+r>=CesiumMath.SIXTY_FOUR_KILOBYTES&&(t.push(new Geometry({attributes:s,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),n=[],a=[],o=0,s=copyAttributesDescriptions(e.attributes))}0!==a.length&&t.push(new Geometry({attributes:s,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var scratchProjectTo2DCartesian3=new Cartesian3,scratchProjectTo2DCartographic=new Cartographic;GeometryPipeline.projectTo2D=function(e,t,i,r,n){for(var a=e.attributes[t],o=(n=defined(n)?n:new GeographicProjection).ellipsoid,s=a.values,l=new Float64Array(s.length),c=0,u=0;u<s.length;u+=3){var d=Cartesian3.fromArray(s,u,scratchProjectTo2DCartesian3),h=o.cartesianToCartographic(d,scratchProjectTo2DCartographic),p=n.project(h,scratchProjectTo2DCartesian3);l[c++]=p.x,l[c++]=p.y,l[c++]=p.z}return e.attributes[i]=a,e.attributes[r]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l}),delete e.attributes[t],e};var encodedResult={high:0,low:0};GeometryPipeline.encodeAttribute=function(e,t,i,r){for(var n=e.attributes[t],a=n.values,o=a.length,s=new Float32Array(o),l=new Float32Array(o),c=0;c<o;++c)EncodedCartesian3.encode(a[c],encodedResult),s[c]=encodedResult.high,l[c]=encodedResult.low;var u=n.componentsPerAttribute;return e.attributes[i]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:u,values:s}),e.attributes[r]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:u,values:l}),delete e.attributes[t],e};var scratchCartesian3$4=new Cartesian3;function transformPoint(e,t){if(defined(t))for(var i=t.values,r=i.length,n=0;n<r;n+=3)Cartesian3.unpack(i,n,scratchCartesian3$4),Matrix4.multiplyByPoint(e,scratchCartesian3$4,scratchCartesian3$4),Cartesian3.pack(scratchCartesian3$4,i,n)}function transformVector(e,t){if(defined(t))for(var i=t.values,r=i.length,n=0;n<r;n+=3)Cartesian3.unpack(i,n,scratchCartesian3$4),Matrix3.multiplyByVector(e,scratchCartesian3$4,scratchCartesian3$4),scratchCartesian3$4=Cartesian3.normalize(scratchCartesian3$4,scratchCartesian3$4),Cartesian3.pack(scratchCartesian3$4,i,n)}var inverseTranspose=new Matrix4,normalMatrix=new Matrix3;function findAttributesInAllGeometries(e,t){var i,r=e.length,n={},a=e[0][t].attributes;for(i in a)if(a.hasOwnProperty(i)&&defined(a[i])&&defined(a[i].values)){for(var o=a[i],s=o.values.length,l=!0,c=1;c<r;++c){var u=e[c][t].attributes[i];if(!defined(u)||o.componentDatatype!==u.componentDatatype||o.componentsPerAttribute!==u.componentsPerAttribute||o.normalize!==u.normalize){l=!1;break}s+=u.values.length}l&&(n[i]=new GeometryAttribute({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:ComponentDatatype$1.createTypedArray(o.componentDatatype,s)}))}return n}GeometryPipeline.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(Matrix4.equals(t,Matrix4.IDENTITY))return e;var i=e.geometry.attributes;transformPoint(t,i.position),transformPoint(t,i.prevPosition),transformPoint(t,i.nextPosition),(defined(i.normal)||defined(i.tangent)||defined(i.bitangent))&&(Matrix4.inverse(t,inverseTranspose),Matrix4.transpose(inverseTranspose,inverseTranspose),Matrix4.getMatrix3(inverseTranspose,normalMatrix),transformVector(normalMatrix,i.normal),transformVector(normalMatrix,i.tangent),transformVector(normalMatrix,i.bitangent));var r=e.geometry.boundingSphere;return defined(r)&&(e.geometry.boundingSphere=BoundingSphere.transform(r,t,r)),e.modelMatrix=Matrix4.clone(Matrix4.IDENTITY),e};var tempScratch=new Cartesian3;function combineGeometries(e,t){var i,r,n,a,o,s,l,c,u=e.length,d=(e[0].modelMatrix,defined(e[0][t].indices)),h=e[0][t].primitiveType,p=findAttributesInAllGeometries(e,t);for(i in p)if(p.hasOwnProperty(i))for(o=p[i].values,r=a=0;r<u;++r)for(l=(s=e[r][t].attributes[i].values).length,n=0;n<l;++n)o[a++]=s[n];if(d){var m=0;for(r=0;r<u;++r)m+=e[r][t].indices.length;var f=Geometry.computeNumberOfVertices(new Geometry({attributes:p,primitiveType:PrimitiveType$1.POINTS})),g=IndexDatatype$1.createTypedArray(f,m),_=0,y=0;for(r=0;r<u;++r){var v=e[r][t].indices,C=v.length;for(a=0;a<C;++a)g[_++]=y+v[a];y+=Geometry.computeNumberOfVertices(e[r][t])}c=g}var S,T=new Cartesian3,x=0;for(r=0;r<u;++r){if(!defined(S=e[r][t].boundingSphere)){T=void 0;break}Cartesian3.add(S.center,T,T)}if(defined(T))for(Cartesian3.divideByScalar(T,u,T),r=0;r<u;++r){S=e[r][t].boundingSphere;var b=Cartesian3.magnitude(Cartesian3.subtract(S.center,T,tempScratch))+S.radius;x<b&&(x=b)}return new Geometry({attributes:p,indices:c,primitiveType:h,boundingSphere:defined(T)?new BoundingSphere(T,x):void 0})}GeometryPipeline.combineInstances=function(e){for(var t=[],i=[],r=e.length,n=0;n<r;++n){var a=e[n];defined(a.geometry)?t.push(a):defined(a.westHemisphereGeometry)&&defined(a.eastHemisphereGeometry)&&i.push(a)}var o=[];return 0<t.length&&o.push(combineGeometries(t,"geometry")),0<i.length&&(o.push(combineGeometries(i,"westHemisphereGeometry")),o.push(combineGeometries(i,"eastHemisphereGeometry"))),o};var normal=new Cartesian3,v0=new Cartesian3,v1=new Cartesian3,v2=new Cartesian3;GeometryPipeline.computeNormal=function(e){var t,i=e.indices,r=e.attributes,n=r.position.values,a=r.position.values.length/3,o=i.length,s=new Array(a),l=new Array(o/3),c=new Array(o);for(t=0;t<a;t++)s[t]={indexOffset:0,count:0,currentCount:0};var u=0;for(t=0;t<o;t+=3){var d=i[t],h=i[t+1],p=i[t+2],m=3*d,f=3*h,g=3*p;v0.x=n[m],v0.y=n[1+m],v0.z=n[2+m],v1.x=n[f],v1.y=n[1+f],v1.z=n[2+f],v2.x=n[g],v2.y=n[1+g],v2.z=n[2+g],s[d].count++,s[h].count++,s[p].count++,Cartesian3.subtract(v1,v0,v1),Cartesian3.subtract(v2,v0,v2),l[u]=Cartesian3.cross(v1,v2,new Cartesian3),u++}var _,y=0;for(t=0;t<a;t++)s[t].indexOffset+=y,y+=s[t].count;for(t=u=0;t<o;t+=3){var v=(_=s[i[t]]).indexOffset+_.currentCount;c[v]=u,_.currentCount++,c[v=(_=s[i[t+1]]).indexOffset+_.currentCount]=u,_.currentCount++,c[v=(_=s[i[t+2]]).indexOffset+_.currentCount]=u,_.currentCount++,u++}var C=new Float32Array(3*a);for(t=0;t<a;t++){var S=3*t;if(_=s[t],Cartesian3.clone(Cartesian3.ZERO,normal),0<_.count){for(u=0;u<_.count;u++)Cartesian3.add(normal,l[c[_.indexOffset+u]],normal);Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&Cartesian3.clone(l[c[_.indexOffset]],normal)}Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&(normal.z=1),Cartesian3.normalize(normal,normal),C[S]=normal.x,C[1+S]=normal.y,C[2+S]=normal.z}return e.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C}),e};var normalScratch$1=new Cartesian3,normalScale=new Cartesian3,tScratch=new Cartesian3;GeometryPipeline.computeTangentAndBitangent=function(e){e.attributes;var t,i,r,n,a=e.indices,o=e.attributes.position.values,s=e.attributes.normal.values,l=e.attributes.st.values,c=e.attributes.position.values.length/3,u=a.length,d=new Array(3*c);for(t=0;t<d.length;t++)d[t]=0;for(t=0;t<u;t+=3){var h=a[t],p=a[t+1],m=a[t+2];r=3*p,n=3*m;var f=2*h,g=2*p,_=2*m,y=o[i=3*h],v=o[i+1],C=o[i+2],S=l[f],T=l[1+f],x=l[1+g]-T,b=l[1+_]-T,E=1/((l[g]-S)*b-(l[_]-S)*x),P=(b*(o[r]-y)-x*(o[n]-y))*E,A=(b*(o[r+1]-v)-x*(o[n+1]-v))*E,w=(b*(o[r+2]-C)-x*(o[n+2]-C))*E;d[i]+=P,d[i+1]+=A,d[i+2]+=w,d[r]+=P,d[r+1]+=A,d[r+2]+=w,d[n]+=P,d[n+1]+=A,d[n+2]+=w}var D=new Float32Array(3*c),M=new Float32Array(3*c);for(t=0;t<c;t++){r=(i=3*t)+1,n=i+2;var I=Cartesian3.fromArray(s,i,normalScratch$1),R=Cartesian3.fromArray(d,i,tScratch),O=Cartesian3.dot(I,R);Cartesian3.multiplyByScalar(I,O,normalScale),Cartesian3.normalize(Cartesian3.subtract(R,normalScale,R),R),D[i]=R.x,D[r]=R.y,D[n]=R.z,Cartesian3.normalize(Cartesian3.cross(I,R,R),R),M[i]=R.x,M[r]=R.y,M[n]=R.z}return e.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:D}),e.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:M}),e};var scratchCartesian2$3=new Cartesian2,toEncode1=new Cartesian3,toEncode2=new Cartesian3,toEncode3=new Cartesian3,encodeResult2=new Cartesian2;function indexTriangles(e){if(defined(e.indices))return e;for(var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,t),r=0;r<t;++r)i[r]=r;return e.indices=i,e}function indexTriangleFan(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,3*(t-2));i[0]=1,i[1]=0,i[2]=2;for(var r=3,n=3;n<t;++n)i[r++]=n-1,i[r++]=0,i[r++]=n;return e.indices=i,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexTriangleStrip(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,3*(t-2));i[0]=0,i[1]=1,i[2]=2,3<t&&(i[3]=0,i[4]=2,i[5]=3);for(var r=6,n=3;n<t-1;n+=2)i[r++]=n,i[r++]=n-1,i[r++]=n+1,n+2<t&&(i[r++]=n,i[r++]=n+1,i[r++]=n+2);return e.indices=i,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexLines(e){if(defined(e.indices))return e;for(var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,t),r=0;r<t;++r)i[r]=r;return e.indices=i,e}function indexLineStrip(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,2*(t-1));i[0]=0,i[1]=1;for(var r=2,n=2;n<t;++n)i[r++]=n-1,i[r++]=n;return e.indices=i,e.primitiveType=PrimitiveType$1.LINES,e}function indexLineLoop(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,2*t);i[0]=0,i[1]=1;for(var r=2,n=2;n<t;++n)i[r++]=n-1,i[r++]=n;return i[r++]=t-1,i[r]=0,e.indices=i,e.primitiveType=PrimitiveType$1.LINES,e}function indexPrimitive(e){switch(e.primitiveType){case PrimitiveType$1.TRIANGLE_FAN:return indexTriangleFan(e);case PrimitiveType$1.TRIANGLE_STRIP:return indexTriangleStrip(e);case PrimitiveType$1.TRIANGLES:return indexTriangles(e);case PrimitiveType$1.LINE_STRIP:return indexLineStrip(e);case PrimitiveType$1.LINE_LOOP:return indexLineLoop(e);case PrimitiveType$1.LINES:return indexLines(e)}return e}function offsetPointFromXZPlane(e,t){Math.abs(e.y)<CesiumMath.EPSILON6&&(e.y=t?-CesiumMath.EPSILON6:CesiumMath.EPSILON6)}function offsetTriangleFromXZPlane(e,t,i){if(0!==e.y&&0!==t.y&&0!==i.y)return offsetPointFromXZPlane(e,e.y<0),offsetPointFromXZPlane(t,t.y<0),void offsetPointFromXZPlane(i,i.y<0);var r=Math.abs(e.y),n=Math.abs(t.y),a=Math.abs(i.y),o=(n<r?a<r?CesiumMath.sign(e.y):CesiumMath.sign(i.y):a<n?CesiumMath.sign(t.y):CesiumMath.sign(i.y))<0;offsetPointFromXZPlane(e,o),offsetPointFromXZPlane(t,o),offsetPointFromXZPlane(i,o)}GeometryPipeline.compressVertices=function(e){var t,i,r=e.attributes.extrudeDirection;if(defined(r)){var n=r.values;i=n.length/3;var a=new Float32Array(2*i),o=0;for(t=0;t<i;++t)Cartesian3.fromArray(n,3*t,toEncode1),Cartesian3.equals(toEncode1,Cartesian3.ZERO)?o+=2:(encodeResult2=AttributeCompression.octEncodeInRange(toEncode1,65535,encodeResult2),a[o++]=encodeResult2.x,a[o++]=encodeResult2.y);return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:a}),delete e.attributes.extrudeDirection,e}var s=e.attributes.normal,l=e.attributes.st,c=defined(s),u=defined(l);if(!c&&!u)return e;var d,h,p,m,f=e.attributes.tangent,g=e.attributes.bitangent,_=defined(f),y=defined(g);c&&(d=s.values),u&&(h=l.values),_&&(p=f.values),y&&(m=g.values);var v=i=(c?d.length:h.length)/(c?3:2),C=u&&c?2:1;C+=_||y?1:0;var S=new Float32Array(v*=C),T=0;for(t=0;t<i;++t){u&&(Cartesian2.fromArray(h,2*t,scratchCartesian2$3),S[T++]=AttributeCompression.compressTextureCoordinates(scratchCartesian2$3));var x=3*t;c&&defined(p)&&defined(m)?(Cartesian3.fromArray(d,x,toEncode1),Cartesian3.fromArray(p,x,toEncode2),Cartesian3.fromArray(m,x,toEncode3),AttributeCompression.octPack(toEncode1,toEncode2,toEncode3,scratchCartesian2$3),S[T++]=scratchCartesian2$3.x,S[T++]=scratchCartesian2$3.y):(c&&(Cartesian3.fromArray(d,x,toEncode1),S[T++]=AttributeCompression.octEncodeFloat(toEncode1)),_&&(Cartesian3.fromArray(p,x,toEncode1),S[T++]=AttributeCompression.octEncodeFloat(toEncode1)),y&&(Cartesian3.fromArray(m,x,toEncode1),S[T++]=AttributeCompression.octEncodeFloat(toEncode1)))}return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:C,values:S}),c&&delete e.attributes.normal,u&&delete e.attributes.st,y&&delete e.attributes.bitangent,_&&delete e.attributes.tangent,e};var c3=new Cartesian3;function getXZIntersectionOffsetPoints(e,t,i,r){Cartesian3.add(e,Cartesian3.multiplyByScalar(Cartesian3.subtract(t,e,c3),e.y/(e.y-t.y),c3),i),Cartesian3.clone(i,r),offsetPointFromXZPlane(i,!0),offsetPointFromXZPlane(r,!1)}var u1=new Cartesian3,u2=new Cartesian3,q1=new Cartesian3,q2=new Cartesian3,splitTriangleResult={positions:new Array(7),indices:new Array(9)};function splitTriangle(e,t,i){if(!(0<=e.x||0<=t.x||0<=i.x)){offsetTriangleFromXZPlane(e,t,i);var r=e.y<0,n=t.y<0,a=i.y<0,o=0;o+=r?1:0,o+=n?1:0,o+=a?1:0;var s=splitTriangleResult.indices;1==o?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,r?(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,i,u2,q2),s[0]=0,s[3]=1,s[4]=2,s[6]=1):n?(getXZIntersectionOffsetPoints(t,i,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=1,s[3]=2,s[4]=0,s[6]=2):a&&(getXZIntersectionOffsetPoints(i,e,u1,q1),getXZIntersectionOffsetPoints(i,t,u2,q2),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2==o&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,r?n?a||(getXZIntersectionOffsetPoints(i,e,u1,q1),getXZIntersectionOffsetPoints(i,t,u2,q2),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(getXZIntersectionOffsetPoints(t,i,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,i,u2,q2),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var l=splitTriangleResult.positions;return l[0]=e,l[1]=t,l[2]=i,l.length=3,1!=o&&2!=o||(l[3]=u1,l[4]=u2,l[5]=q1,l[6]=q2,l.length=7),splitTriangleResult}}function updateGeometryAfterSplit(e,t){var i=e.attributes;if(0!==i.position.values.length){for(var r in i)if(i.hasOwnProperty(r)&&defined(i[r])&&defined(i[r].values)){var n=i[r];n.values=ComponentDatatype$1.createTypedArray(n.componentDatatype,n.values)}var a=Geometry.computeNumberOfVertices(e);return e.indices=IndexDatatype$1.createTypedArray(a,e.indices),t&&(e.boundingSphere=BoundingSphere.fromVertices(i.position.values)),e}}function copyGeometryForSplit(e){var t=e.attributes,i={};for(var r in t)if(t.hasOwnProperty(r)&&defined(t[r])&&defined(t[r].values)){var n=t[r];i[r]=new GeometryAttribute({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return new Geometry({attributes:i,indices:[],primitiveType:e.primitiveType})}function updateInstanceAfterSplit(e,t,i){var r=defined(e.geometry.boundingSphere);t=updateGeometryAfterSplit(t,r),defined(i=updateGeometryAfterSplit(i,r))&&!defined(t)?e.geometry=i:!defined(i)&&defined(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=i,e.geometry=void 0)}function generateBarycentricInterpolateFunction(h,p){var m=new h,f=new h,g=new h;return function(e,t,i,r,n,a,o,s){var l=h.fromArray(n,e*p,m),c=h.fromArray(n,t*p,f),u=h.fromArray(n,i*p,g);h.multiplyByScalar(l,r.x,l),h.multiplyByScalar(c,r.y,c),h.multiplyByScalar(u,r.z,u);var d=h.add(l,c,l);h.add(d,u,d),s&&h.normalize(d,d),h.pack(d,a,o*p)}}var interpolateAndPackCartesian4=generateBarycentricInterpolateFunction(Cartesian4,4),interpolateAndPackCartesian3=generateBarycentricInterpolateFunction(Cartesian3,3),interpolateAndPackCartesian2=generateBarycentricInterpolateFunction(Cartesian2,2),interpolateAndPackBoolean=function(e,t,i,r,n,a,o){var s=n[e]*r.x,l=n[t]*r.y,c=n[i]*r.z;a[o]=s+l+c>CesiumMath.EPSILON6?1:0},p0Scratch=new Cartesian3,p1Scratch=new Cartesian3,p2Scratch=new Cartesian3,barycentricScratch=new Cartesian3;function computeTriangleAttributes(e,t,i,r,n,a,o,s,l,c,u,d,h,p,m,f){if(defined(a)||defined(o)||defined(s)||defined(l)||defined(c)||0!==p){var g=barycentricCoordinates(r,Cartesian3.fromArray(n,3*e,p0Scratch),Cartesian3.fromArray(n,3*t,p1Scratch),Cartesian3.fromArray(n,3*i,p2Scratch),barycentricScratch);if(defined(a)&&interpolateAndPackCartesian3(e,t,i,g,a,d.normal.values,f,!0),defined(c)){var _,y=Cartesian3.fromArray(c,3*e,p0Scratch),v=Cartesian3.fromArray(c,3*t,p1Scratch),C=Cartesian3.fromArray(c,3*i,p2Scratch);Cartesian3.multiplyByScalar(y,g.x,y),Cartesian3.multiplyByScalar(v,g.y,v),Cartesian3.multiplyByScalar(C,g.z,C),Cartesian3.equals(y,Cartesian3.ZERO)&&Cartesian3.equals(v,Cartesian3.ZERO)&&Cartesian3.equals(C,Cartesian3.ZERO)?((_=p0Scratch).x=0,_.y=0,_.z=0):(_=Cartesian3.add(y,v,y),Cartesian3.add(_,C,_),Cartesian3.normalize(_,_)),Cartesian3.pack(_,d.extrudeDirection.values,3*f)}if(defined(u)&&interpolateAndPackBoolean(e,t,i,g,u,d.applyOffset.values,f),defined(o)&&interpolateAndPackCartesian3(e,t,i,g,o,d.tangent.values,f,!0),defined(s)&&interpolateAndPackCartesian3(e,t,i,g,s,d.bitangent.values,f,!0),defined(l)&&interpolateAndPackCartesian2(e,t,i,g,l,d.st.values,f),0<p)for(var S=0;S<p;S++){var T=h[S];genericInterpolate(e,t,i,g,f,m[T],d[T])}}}function genericInterpolate(e,t,i,r,n,a,o){var s=a.componentsPerAttribute,l=a.values,c=o.values;switch(s){case 4:interpolateAndPackCartesian4(e,t,i,r,l,c,n,!1);break;case 3:interpolateAndPackCartesian3(e,t,i,r,l,c,n,!1);break;case 2:interpolateAndPackCartesian2(e,t,i,r,l,c,n,!1);break;default:c[n]=l[e]*r.x+l[t]*r.y+l[i]*r.z}}function insertSplitPoint(e,t,i,r,n,a){var o=e.position.values.length/3;if(-1===n)return e.position.values.push(a.x,a.y,a.z),t.push(o),o;var s=r[n],l=i[s];return-1===l?(i[s]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(l),l)}var NAMED_ATTRIBUTES={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function splitLongitudeTriangles(e){var t=e.geometry,i=t.attributes,r=i.position.values,n=defined(i.normal)?i.normal.values:void 0,a=defined(i.bitangent)?i.bitangent.values:void 0,o=defined(i.tangent)?i.tangent.values:void 0,s=defined(i.st)?i.st.values:void 0,l=defined(i.extrudeDirection)?i.extrudeDirection.values:void 0,c=defined(i.applyOffset)?i.applyOffset.values:void 0,u=t.indices,d=[];for(var h in i)i.hasOwnProperty(h)&&!NAMED_ATTRIBUTES[h]&&defined(i[h])&&d.push(h);var p,m,f,g,_=d.length,y=copyGeometryForSplit(t),v=copyGeometryForSplit(t),C=[];C.length=r.length/3;var S=[];for(S.length=r.length/3,g=0;g<C.length;++g)C[g]=-1,S[g]=-1;var T=u.length;for(g=0;g<T;g+=3){var x=u[g],b=u[g+1],E=u[g+2],P=Cartesian3.fromArray(r,3*x),A=Cartesian3.fromArray(r,3*b),w=Cartesian3.fromArray(r,3*E),D=splitTriangle(P,A,w);if(defined(D)&&3<D.positions.length)for(var M=D.positions,I=D.indices,R=I.length,O=0;O<R;++O){var L=I[O],F=M[L];f=F.y<0?(p=v.attributes,m=v.indices,C):(p=y.attributes,m=y.indices,S),computeTriangleAttributes(x,b,E,F,r,n,o,a,s,l,c,p,d,_,i,insertSplitPoint(p,m,f,u,L<3?g+L:-1,F))}else defined(D)&&(P=D.positions[0],A=D.positions[1],w=D.positions[2]),f=P.y<0?(p=v.attributes,m=v.indices,C):(p=y.attributes,m=y.indices,S),computeTriangleAttributes(x,b,E,P,r,n,o,a,s,l,c,p,d,_,i,insertSplitPoint(p,m,f,u,g,P)),computeTriangleAttributes(x,b,E,A,r,n,o,a,s,l,c,p,d,_,i,insertSplitPoint(p,m,f,u,g+1,A)),computeTriangleAttributes(x,b,E,w,r,n,o,a,s,l,c,p,d,_,i,insertSplitPoint(p,m,f,u,g+2,w))}updateInstanceAfterSplit(e,v,y)}var xzPlane=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),offsetScratch=new Cartesian3,offsetPointScratch=new Cartesian3;function computeLineAttributes(e,t,i,r,n,a,o){if(defined(o)){var s=Cartesian3.fromArray(r,3*e,p0Scratch);Cartesian3.equalsEpsilon(s,i,CesiumMath.EPSILON10)?a.applyOffset.values[n]=o[e]:a.applyOffset.values[n]=o[t]}}function splitLongitudeLines(e){var t,i=e.geometry,r=i.attributes,n=r.position.values,a=defined(r.applyOffset)?r.applyOffset.values:void 0,o=i.indices,s=copyGeometryForSplit(i),l=copyGeometryForSplit(i),c=o.length,u=[];u.length=n.length/3;var d=[];for(d.length=n.length/3,t=0;t<u.length;++t)u[t]=-1,d[t]=-1;for(t=0;t<c;t+=2){var h=o[t],p=o[t+1],m=Cartesian3.fromArray(n,3*h,p0Scratch),f=Cartesian3.fromArray(n,3*p,p1Scratch);Math.abs(m.y)<CesiumMath.EPSILON6&&(m.y<0?m.y=-CesiumMath.EPSILON6:m.y=CesiumMath.EPSILON6),Math.abs(f.y)<CesiumMath.EPSILON6&&(f.y<0?f.y=-CesiumMath.EPSILON6:f.y=CesiumMath.EPSILON6);var g=s.attributes,_=s.indices,y=d,v=l.attributes,C=l.indices,S=u,T=IntersectionTests.lineSegmentPlane(m,f,xzPlane,p2Scratch);if(defined(T)){var x=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,5*CesiumMath.EPSILON9,offsetScratch);m.y<0&&(Cartesian3.negate(x,x),g=l.attributes,_=l.indices,y=u,v=s.attributes,C=s.indices,S=d);var b=Cartesian3.add(T,x,offsetPointScratch);computeLineAttributes(h,p,m,n,insertSplitPoint(g,_,y,o,t,m),g,a),computeLineAttributes(h,p,b,n,insertSplitPoint(g,_,y,o,-1,b),g,a),Cartesian3.negate(x,x),Cartesian3.add(T,x,b),computeLineAttributes(h,p,b,n,insertSplitPoint(v,C,S,o,-1,b),v,a),computeLineAttributes(h,p,f,n,insertSplitPoint(v,C,S,o,t+1,f),v,a)}else{var E,P,A;A=m.y<0?(E=l.attributes,P=l.indices,u):(E=s.attributes,P=s.indices,d),computeLineAttributes(h,p,m,n,insertSplitPoint(E,P,A,o,t,m),E,a),computeLineAttributes(h,p,f,n,insertSplitPoint(E,P,A,o,t+1,f),E,a)}}updateInstanceAfterSplit(e,l,s)}var cartesian2Scratch0=new Cartesian2,cartesian2Scratch1=new Cartesian2,cartesian3Scratch0=new Cartesian3,cartesian3Scratch2=new Cartesian3,cartesian3Scratch3=new Cartesian3,cartesian3Scratch4=new Cartesian3,cartesian3Scratch5=new Cartesian3,cartesian3Scratch6=new Cartesian3,cartesian4Scratch0=new Cartesian4;function updateAdjacencyAfterSplit(e){for(var t=e.attributes,i=t.position.values,r=t.prevPosition.values,n=t.nextPosition.values,a=i.length,o=0;o<a;o+=3){var s=Cartesian3.unpack(i,o,cartesian3Scratch0);if(!(0<s.x)){var l=Cartesian3.unpack(r,o,cartesian3Scratch2);(s.y<0&&0<l.y||0<s.y&&l.y<0)&&(0<o-3?(r[o]=i[o-3],r[o+1]=i[o-2],r[o+2]=i[o-1]):Cartesian3.pack(s,r,o));var c=Cartesian3.unpack(n,o,cartesian3Scratch3);(s.y<0&&0<c.y||0<s.y&&c.y<0)&&(o+3<a?(n[o]=i[o+3],n[o+1]=i[o+4],n[o+2]=i[o+5]):Cartesian3.pack(s,n,o))}}}var offsetScalar=5*CesiumMath.EPSILON9,coplanarOffset=CesiumMath.EPSILON6;function splitLongitudePolyline(e){var t,i,r,n=e.geometry,a=n.attributes,o=a.position.values,s=a.prevPosition.values,l=a.nextPosition.values,c=a.expandAndWidth.values,u=defined(a.st)?a.st.values:void 0,d=defined(a.color)?a.color.values:void 0,h=copyGeometryForSplit(n),p=copyGeometryForSplit(n),m=!1,f=o.length/3;for(t=0;t<f;t+=4){var g=t,_=t+2,y=Cartesian3.fromArray(o,3*g,cartesian3Scratch0),v=Cartesian3.fromArray(o,3*_,cartesian3Scratch2);if(Math.abs(y.y)<coplanarOffset)for(y.y=coplanarOffset*(v.y<0?-1:1),o[3*t+1]=y.y,o[3*(t+1)+1]=y.y,i=3*g;i<3*g+12;i+=3)s[i]=o[3*t],s[i+1]=o[3*t+1],s[i+2]=o[3*t+2];if(Math.abs(v.y)<coplanarOffset)for(v.y=coplanarOffset*(y.y<0?-1:1),o[3*(t+2)+1]=v.y,o[3*(t+3)+1]=v.y,i=3*g;i<3*g+12;i+=3)l[i]=o[3*(t+2)],l[i+1]=o[3*(t+2)+1],l[i+2]=o[3*(t+2)+2];var C=h.attributes,S=h.indices,T=p.attributes,x=p.indices,b=IntersectionTests.lineSegmentPlane(y,v,xzPlane,cartesian3Scratch4);if(defined(b)){m=!0;var E=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,offsetScalar,cartesian3Scratch5);y.y<0&&(Cartesian3.negate(E,E),C=p.attributes,S=p.indices,T=h.attributes,x=h.indices);var P=Cartesian3.add(b,E,cartesian3Scratch6);C.position.values.push(y.x,y.y,y.z,y.x,y.y,y.z),C.position.values.push(P.x,P.y,P.z),C.position.values.push(P.x,P.y,P.z),C.prevPosition.values.push(s[3*g],s[3*g+1],s[3*g+2]),C.prevPosition.values.push(s[3*g+3],s[3*g+4],s[3*g+5]),C.prevPosition.values.push(y.x,y.y,y.z,y.x,y.y,y.z),C.nextPosition.values.push(P.x,P.y,P.z),C.nextPosition.values.push(P.x,P.y,P.z),C.nextPosition.values.push(P.x,P.y,P.z),C.nextPosition.values.push(P.x,P.y,P.z),Cartesian3.negate(E,E),Cartesian3.add(b,E,P),T.position.values.push(P.x,P.y,P.z),T.position.values.push(P.x,P.y,P.z),T.position.values.push(v.x,v.y,v.z,v.x,v.y,v.z),T.prevPosition.values.push(P.x,P.y,P.z),T.prevPosition.values.push(P.x,P.y,P.z),T.prevPosition.values.push(P.x,P.y,P.z),T.prevPosition.values.push(P.x,P.y,P.z),T.nextPosition.values.push(v.x,v.y,v.z,v.x,v.y,v.z),T.nextPosition.values.push(l[3*_],l[3*_+1],l[3*_+2]),T.nextPosition.values.push(l[3*_+3],l[3*_+4],l[3*_+5]);var A=Cartesian2.fromArray(c,2*g,cartesian2Scratch0),w=Math.abs(A.y);C.expandAndWidth.values.push(-1,w,1,w),C.expandAndWidth.values.push(-1,-w,1,-w),T.expandAndWidth.values.push(-1,w,1,w),T.expandAndWidth.values.push(-1,-w,1,-w);var D=Cartesian3.magnitudeSquared(Cartesian3.subtract(b,y,cartesian3Scratch3));if(D/=Cartesian3.magnitudeSquared(Cartesian3.subtract(v,y,cartesian3Scratch3)),defined(d)){var M=Cartesian4.fromArray(d,4*g,cartesian4Scratch0),I=Cartesian4.fromArray(d,4*_,cartesian4Scratch0),R=CesiumMath.lerp(M.x,I.x,D),O=CesiumMath.lerp(M.y,I.y,D),L=CesiumMath.lerp(M.z,I.z,D),F=CesiumMath.lerp(M.w,I.w,D);for(i=4*g;i<4*g+8;++i)C.color.values.push(d[i]);for(C.color.values.push(R,O,L,F),C.color.values.push(R,O,L,F),T.color.values.push(R,O,L,F),T.color.values.push(R,O,L,F),i=4*_;i<4*_+8;++i)T.color.values.push(d[i])}if(defined(u)){var N=Cartesian2.fromArray(u,2*g,cartesian2Scratch0),V=Cartesian2.fromArray(u,2*(t+3),cartesian2Scratch1),B=CesiumMath.lerp(N.x,V.x,D);for(i=2*g;i<2*g+4;++i)C.st.values.push(u[i]);for(C.st.values.push(B,N.y),C.st.values.push(B,V.y),T.st.values.push(B,N.y),T.st.values.push(B,V.y),i=2*_;i<2*_+4;++i)T.st.values.push(u[i])}r=C.position.values.length/3-4,S.push(r,r+2,r+1),S.push(r+1,r+2,r+3),r=T.position.values.length/3-4,x.push(r,r+2,r+1),x.push(r+1,r+2,r+3)}else{var k,$;for($=y.y<0?(k=p.attributes,p.indices):(k=h.attributes,h.indices),k.position.values.push(y.x,y.y,y.z),k.position.values.push(y.x,y.y,y.z),k.position.values.push(v.x,v.y,v.z),k.position.values.push(v.x,v.y,v.z),i=3*t;i<3*t+12;++i)k.prevPosition.values.push(s[i]),k.nextPosition.values.push(l[i]);for(i=2*t;i<2*t+8;++i)k.expandAndWidth.values.push(c[i]),defined(u)&&k.st.values.push(u[i]);if(defined(d))for(i=4*t;i<4*t+16;++i)k.color.values.push(d[i]);r=k.position.values.length/3-4,$.push(r,r+2,r+1),$.push(r+1,r+2,r+3)}}m&&(updateAdjacencyAfterSplit(p),updateAdjacencyAfterSplit(h)),updateInstanceAfterSplit(e,p,h)}GeometryPipeline.splitLongitude=function(e){var t=e.geometry,i=t.boundingSphere;if(defined(i)&&(0<i.center.x-i.radius||BoundingSphere.intersectPlane(i,Plane.ORIGIN_ZX_PLANE)!==Intersect$1.INTERSECTING))return e;if(t.geometryType!==GeometryType$1.NONE)switch(t.geometryType){case GeometryType$1.POLYLINES:splitLongitudePolyline(e);break;case GeometryType$1.TRIANGLES:splitLongitudeTriangles(e);break;case GeometryType$1.LINES:splitLongitudeLines(e)}else indexPrimitive(t),t.primitiveType===PrimitiveType$1.TRIANGLES?splitLongitudeTriangles(e):t.primitiveType===PrimitiveType$1.LINES&&splitLongitudeLines(e);return e};var scratchCartesian1$3=new Cartesian3,scratchCartesian2$4=new Cartesian3,scratchCartesian3$5=new Cartesian3,scratchCartesian4$1=new Cartesian3,texCoordScratch=new Cartesian2,textureMatrixScratch=new Matrix3,tangentMatrixScratch=new Matrix3,quaternionScratch=new Quaternion,scratchNormal$2=new Cartesian3,scratchTangent=new Cartesian3,scratchBitangent=new Cartesian3,scratchCartographic$1=new Cartographic,projectedCenterScratch=new Cartesian3,scratchMinTexCoord=new Cartesian2,scratchMaxTexCoord=new Cartesian2;function computeTopBottomAttributes(e,t,i){var r=t.vertexFormat,n=t.center,a=t.semiMajorAxis,o=t.semiMinorAxis,s=t.ellipsoid,l=t.stRotation,c=i?e.length/3*2:e.length/3,u=t.shadowVolume,d=r.st?new Float32Array(2*c):void 0,h=r.normal?new Float32Array(3*c):void 0,p=r.tangent?new Float32Array(3*c):void 0,m=r.bitangent?new Float32Array(3*c):void 0,f=u?new Float32Array(3*c):void 0,g=0,_=scratchNormal$2,y=scratchTangent,v=scratchBitangent,C=new GeographicProjection(s),S=C.project(s.cartesianToCartographic(n,scratchCartographic$1),projectedCenterScratch),T=s.scaleToGeodeticSurface(n,scratchCartesian1$3);s.geodeticSurfaceNormal(T,T);var x=textureMatrixScratch,b=tangentMatrixScratch;if(0!==l){var E=Quaternion.fromAxisAngle(T,l,quaternionScratch);x=Matrix3.fromQuaternion(E,x),E=Quaternion.fromAxisAngle(T,-l,quaternionScratch),b=Matrix3.fromQuaternion(E,b)}else x=Matrix3.clone(Matrix3.IDENTITY,x),b=Matrix3.clone(Matrix3.IDENTITY,b);for(var P=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),A=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord),w=e.length,D=i?w:0,M=D/3*2,I=0;I<w;I+=3){var R=I+1,O=I+2,L=Cartesian3.fromArray(e,I,scratchCartesian1$3);if(r.st){var F=Matrix3.multiplyByVector(x,L,scratchCartesian2$4),N=C.project(s.cartesianToCartographic(F,scratchCartographic$1),scratchCartesian3$5);Cartesian3.subtract(N,S,N),texCoordScratch.x=(N.x+a)/(2*a),texCoordScratch.y=(N.y+o)/(2*o),P.x=Math.min(texCoordScratch.x,P.x),P.y=Math.min(texCoordScratch.y,P.y),A.x=Math.max(texCoordScratch.x,A.x),A.y=Math.max(texCoordScratch.y,A.y),i&&(d[g+M]=texCoordScratch.x,d[g+1+M]=texCoordScratch.y),d[g++]=texCoordScratch.x,d[g++]=texCoordScratch.y}(r.normal||r.tangent||r.bitangent||u)&&(_=s.geodeticSurfaceNormal(L,_),u&&(f[I+D]=-_.x,f[R+D]=-_.y,f[O+D]=-_.z),(r.normal||r.tangent||r.bitangent)&&((r.tangent||r.bitangent)&&(y=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,_,y),y),Matrix3.multiplyByVector(b,y,y)),r.normal&&(h[I]=_.x,h[R]=_.y,h[O]=_.z,i&&(h[I+D]=-_.x,h[R+D]=-_.y,h[O+D]=-_.z)),r.tangent&&(p[I]=y.x,p[R]=y.y,p[O]=y.z,i&&(p[I+D]=-y.x,p[R+D]=-y.y,p[O+D]=-y.z)),r.bitangent&&(v=Cartesian3.normalize(Cartesian3.cross(_,y,v),v),m[I]=v.x,m[R]=v.y,m[O]=v.z,i&&(m[I+D]=v.x,m[R+D]=v.y,m[O+D]=v.z))))}if(r.st){w=d.length;for(var V=0;V<w;V+=2)d[V]=(d[V]-P.x)/(A.x-P.x),d[V+1]=(d[V+1]-P.y)/(A.y-P.y)}var B=new GeometryAttributes;if(r.position){var k=EllipseGeometryLibrary.raisePositionsToHeight(e,t,i);B.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:k})}if(r.st&&(B.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:d})),r.normal&&(B.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),r.tangent&&(B.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),r.bitangent&&(B.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),u&&(B.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),i&&defined(t.offsetAttribute)){var $=new Uint8Array(c);if(t.offsetAttribute===GeometryOffsetAttribute$1.TOP)$=arrayFill($,1,0,c/2);else $=arrayFill($,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);B.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:$})}return B}function topIndices(e){var t,i,r,n,a,o=new Array(e*(e+1)*12-6),s=0;for(r=1,n=t=0;n<3;n++)o[s++]=r++,o[s++]=t,o[s++]=r;for(n=2;n<e+1;++n){for(r=n*(n+1)-1,t=(n-1)*n-1,o[s++]=r++,o[s++]=t,o[s++]=r,i=2*n,a=0;a<i-1;++a)o[s++]=r,o[s++]=t++,o[s++]=t,o[s++]=r++,o[s++]=t,o[s++]=r;o[s++]=r++,o[s++]=t,o[s++]=r}for(i=2*e,++r,++t,n=0;n<i-1;++n)o[s++]=r,o[s++]=t++,o[s++]=t,o[s++]=r++,o[s++]=t,o[s++]=r;for(o[s++]=r,o[s++]=t++,o[s++]=t,o[s++]=r++,o[s++]=t++,o[s++]=t,++t,n=e-1;1<n;--n){for(o[s++]=t++,o[s++]=t,o[s++]=r,i=2*n,a=0;a<i-1;++a)o[s++]=r,o[s++]=t++,o[s++]=t,o[s++]=r++,o[s++]=t,o[s++]=r;o[s++]=t++,o[s++]=t++,o[s++]=r++}for(n=0;n<3;n++)o[s++]=t++,o[s++]=t,o[s++]=r;return o}var boundingSphereCenter=new Cartesian3;function computeEllipse(e){var t=e.center;boundingSphereCenter=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter),e.height,boundingSphereCenter);var i=new BoundingSphere(boundingSphereCenter=Cartesian3.add(t,boundingSphereCenter,boundingSphereCenter),e.semiMajorAxis),r=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!1),n=r.positions,a=r.numPts,o=computeTopBottomAttributes(n,e,!1),s=topIndices(a);return{boundingSphere:i,attributes:o,indices:s=IndexDatatype$1.createTypedArray(n.length/3,s)}}function computeWallAttributes(e,t){var i=t.vertexFormat,r=t.center,n=t.semiMajorAxis,a=t.semiMinorAxis,o=t.ellipsoid,s=t.height,l=t.extrudedHeight,c=t.stRotation,u=e.length/3*2,d=new Float64Array(3*u),h=i.st?new Float32Array(2*u):void 0,p=i.normal?new Float32Array(3*u):void 0,m=i.tangent?new Float32Array(3*u):void 0,f=i.bitangent?new Float32Array(3*u):void 0,g=t.shadowVolume,_=g?new Float32Array(3*u):void 0,y=0,v=scratchNormal$2,C=scratchTangent,S=scratchBitangent,T=new GeographicProjection(o),x=T.project(o.cartesianToCartographic(r,scratchCartographic$1),projectedCenterScratch),b=o.scaleToGeodeticSurface(r,scratchCartesian1$3);o.geodeticSurfaceNormal(b,b);for(var E=Quaternion.fromAxisAngle(b,c,quaternionScratch),P=Matrix3.fromQuaternion(E,textureMatrixScratch),A=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),w=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord),D=e.length,M=D/3*2,I=0;I<D;I+=3){var R,O=I+1,L=I+2,F=Cartesian3.fromArray(e,I,scratchCartesian1$3);if(i.st){var N=Matrix3.multiplyByVector(P,F,scratchCartesian2$4),V=T.project(o.cartesianToCartographic(N,scratchCartographic$1),scratchCartesian3$5);Cartesian3.subtract(V,x,V),texCoordScratch.x=(V.x+n)/(2*n),texCoordScratch.y=(V.y+a)/(2*a),A.x=Math.min(texCoordScratch.x,A.x),A.y=Math.min(texCoordScratch.y,A.y),w.x=Math.max(texCoordScratch.x,w.x),w.y=Math.max(texCoordScratch.y,w.y),h[y+M]=texCoordScratch.x,h[y+1+M]=texCoordScratch.y,h[y++]=texCoordScratch.x,h[y++]=texCoordScratch.y}F=o.scaleToGeodeticSurface(F,F),R=Cartesian3.clone(F,scratchCartesian2$4),v=o.geodeticSurfaceNormal(F,v),g&&(_[I+D]=-v.x,_[O+D]=-v.y,_[L+D]=-v.z);var B=Cartesian3.multiplyByScalar(v,s,scratchCartesian4$1);if(F=Cartesian3.add(F,B,F),B=Cartesian3.multiplyByScalar(v,l,B),R=Cartesian3.add(R,B,R),i.position&&(d[I+D]=R.x,d[O+D]=R.y,d[L+D]=R.z,d[I]=F.x,d[O]=F.y,d[L]=F.z),i.normal||i.tangent||i.bitangent){S=Cartesian3.clone(v,S);var k=Cartesian3.fromArray(e,(I+3)%D,scratchCartesian4$1);Cartesian3.subtract(k,F,k);var $=Cartesian3.subtract(R,F,scratchCartesian3$5);v=Cartesian3.normalize(Cartesian3.cross($,k,v),v),i.normal&&(p[I]=v.x,p[O]=v.y,p[L]=v.z,p[I+D]=v.x,p[O+D]=v.y,p[L+D]=v.z),i.tangent&&(C=Cartesian3.normalize(Cartesian3.cross(S,v,C),C),m[I]=C.x,m[O]=C.y,m[L]=C.z,m[I+D]=C.x,m[I+1+D]=C.y,m[I+2+D]=C.z),i.bitangent&&(f[I]=S.x,f[O]=S.y,f[L]=S.z,f[I+D]=S.x,f[O+D]=S.y,f[L+D]=S.z)}}if(i.st){D=h.length;for(var z=0;z<D;z+=2)h[z]=(h[z]-A.x)/(w.x-A.x),h[z+1]=(h[z+1]-A.y)/(w.y-A.y)}var U=new GeometryAttributes;if(i.position&&(U.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d})),i.st&&(U.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:h})),i.normal&&(U.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),i.tangent&&(U.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),i.bitangent&&(U.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),g&&(U.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),defined(t.offsetAttribute)){var G=new Uint8Array(u);if(t.offsetAttribute===GeometryOffsetAttribute$1.TOP)G=arrayFill(G,1,0,u/2);else G=arrayFill(G,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);U.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:G})}return U}function computeWallIndices(e){for(var t=e.length/3,i=IndexDatatype$1.createTypedArray(t,6*t),r=0,n=0;n<t;n++){var a=n,o=n+t,s=(a+1)%t,l=s+t;i[r++]=a,i[r++]=o,i[r++]=s,i[r++]=s,i[r++]=o,i[r++]=l}return i}var topBoundingSphere=new BoundingSphere,bottomBoundingSphere=new BoundingSphere;function computeExtrudedEllipse(e){var t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,scratchCartesian1$3),e.height,scratchCartesian1$3);topBoundingSphere.center=Cartesian3.add(t,n,topBoundingSphere.center),topBoundingSphere.radius=r,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),bottomBoundingSphere.center=Cartesian3.add(t,n,bottomBoundingSphere.center),bottomBoundingSphere.radius=r;var a=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!0),o=a.positions,s=a.numPts,l=a.outerPositions,c=BoundingSphere.union(topBoundingSphere,bottomBoundingSphere),u=computeTopBottomAttributes(o,e,!0),d=topIndices(s),h=d.length;d.length=2*h;for(var p=o.length/3,m=0;m<h;m+=3)d[m+h]=d[m+2]+p,d[m+1+h]=d[m+1]+p,d[m+2+h]=d[m]+p;var f=new Geometry({attributes:u,indices:IndexDatatype$1.createTypedArray(2*p/3,d),primitiveType:PrimitiveType$1.TRIANGLES}),g=computeWallAttributes(l,e);d=computeWallIndices(l);var _=new Geometry({attributes:g,indices:IndexDatatype$1.createTypedArray(2*l.length/3,d),primitiveType:PrimitiveType$1.TRIANGLES}),y=GeometryPipeline.combineInstances([new GeometryInstance({geometry:f}),new GeometryInstance({geometry:_})]);return{boundingSphere:c,attributes:y[0].attributes,indices:y[0].indices}}function computeRectangle(e,t,i,r,n,a,o){for(var s=EllipseGeometryLibrary.computeEllipsePositions({center:e,semiMajorAxis:t,semiMinorAxis:i,rotation:r,granularity:n},!1,!0).outerPositions,l=s.length/3,c=new Array(l),u=0;u<l;++u)c[u]=Cartesian3.fromArray(s,3*u);var d=Rectangle.fromCartesianArray(c,a,o);return d.width>CesiumMath.PI&&(d.north=0<d.north?CesiumMath.PI_OVER_TWO-CesiumMath.EPSILON7:d.north,d.south=d.south<0?CesiumMath.EPSILON7-CesiumMath.PI_OVER_TWO:d.south,d.east=CesiumMath.PI,d.west=-CesiumMath.PI),d}function EllipseGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,n=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),s=defaultValue(e.height,0),l=defaultValue(e.extrudedHeight,s);this._center=Cartesian3.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=Ellipsoid.clone(i),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._height=Math.max(l,s),this._granularity=a,this._vertexFormat=VertexFormat.clone(o),this._extrudedHeight=Math.min(l,s),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createEllipseGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0}EllipseGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+9,EllipseGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._center,t,i),i+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchCenter$1=new Cartesian3,scratchEllipsoid=new Ellipsoid,scratchVertexFormat$1=new VertexFormat,scratchOptions$2={center:scratchCenter$1,ellipsoid:scratchEllipsoid,vertexFormat:scratchVertexFormat$1,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};function textureCoordinateRotationPoints(e){var t=-e._stRotation;if(0==t)return[0,0,0,1,1,0];for(var i=EllipseGeometryLibrary.computeEllipsePositions({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,rotation:e._rotation,granularity:e._granularity},!1,!0).outerPositions,r=i.length/3,n=new Array(r),a=0;a<r;++a)n[a]=Cartesian3.fromArray(i,3*a);var o=e._ellipsoid,s=e.rectangle;return Geometry._textureCoordinateRotationPoints(n,t,o,s)}function CircleGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,i={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation,shadowVolume:e.shadowVolume};this._ellipseGeometry=new EllipseGeometry(i),this._workerName="createCircleGeometry"}EllipseGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchCenter$1);t+=Cartesian3.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$1);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],m=e[t];return defined(i)?(i._center=Cartesian3.clone(r,i._center),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._semiMajorAxis=o,i._semiMinorAxis=s,i._rotation=l,i._stRotation=c,i._height=u,i._granularity=d,i._extrudedHeight=h,i._shadowVolume=p,i._offsetAttribute=-1===m?void 0:m,i):(scratchOptions$2.height=u,scratchOptions$2.extrudedHeight=h,scratchOptions$2.granularity=d,scratchOptions$2.stRotation=c,scratchOptions$2.rotation=l,scratchOptions$2.semiMajorAxis=o,scratchOptions$2.semiMinorAxis=s,scratchOptions$2.shadowVolume=p,scratchOptions$2.offsetAttribute=-1===m?void 0:m,new EllipseGeometry(scratchOptions$2))},EllipseGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=e.semiMajorAxis,a=e.semiMinorAxis,o=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);return computeRectangle(i,n,a,defaultValue(e.rotation,0),o,r,t)},EllipseGeometry.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){var t=e._height,i=e._extrudedHeight,r=!CesiumMath.equalsEpsilon(t,i,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var n,a={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};if(r)a.extrudedHeight=i,a.shadowVolume=e._shadowVolume,a.offsetAttribute=e._offsetAttribute,n=computeExtrudedEllipse(a);else if(n=computeEllipse(a),defined(e._offsetAttribute)){var o=n.attributes.position.values.length,s=new Uint8Array(o/3);arrayFill(s,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:s})}return new Geometry({attributes:n.attributes,indices:n.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})}},EllipseGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,a=t(r,n),o=i(r,n);return new EllipseGeometry({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:n,rotation:e._rotation,stRotation:e._stRotation,granularity:r,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},defineProperties$1(EllipseGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle(this._center,this._semiMajorAxis,this._semiMinorAxis,this._rotation,this._granularity,this._ellipsoid)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints(this)),this._textureCoordinateRotationPoints}}}),CircleGeometry.packedLength=EllipseGeometry.packedLength,CircleGeometry.pack=function(e,t,i){return EllipseGeometry.pack(e._ellipseGeometry,t,i)};var scratchEllipseGeometry=new EllipseGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$3={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new VertexFormat,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0,shadowVolume:void 0};CircleGeometry.unpack=function(e,t,i){var r=EllipseGeometry.unpack(e,t,scratchEllipseGeometry);return scratchOptions$3.center=Cartesian3.clone(r._center,scratchOptions$3.center),scratchOptions$3.ellipsoid=Ellipsoid.clone(r._ellipsoid,scratchOptions$3.ellipsoid),scratchOptions$3.height=r._height,scratchOptions$3.extrudedHeight=r._extrudedHeight,scratchOptions$3.granularity=r._granularity,scratchOptions$3.vertexFormat=VertexFormat.clone(r._vertexFormat,scratchOptions$3.vertexFormat),scratchOptions$3.stRotation=r._stRotation,scratchOptions$3.shadowVolume=r._shadowVolume,defined(i)?(scratchOptions$3.semiMajorAxis=r._semiMajorAxis,scratchOptions$3.semiMinorAxis=r._semiMinorAxis,i._ellipseGeometry=new EllipseGeometry(scratchOptions$3),i):(scratchOptions$3.radius=r._semiMajorAxis,new CircleGeometry(scratchOptions$3))},CircleGeometry.createGeometry=function(e){return EllipseGeometry.createGeometry(e._ellipseGeometry)},CircleGeometry.createShadowVolume=function(e,t,i){var r=e._ellipseGeometry._granularity,n=e._ellipseGeometry._ellipsoid,a=t(r,n),o=i(r,n);return new CircleGeometry({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:n,stRotation:e._ellipseGeometry._stRotation,granularity:r,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},defineProperties$1(CircleGeometry.prototype,{rectangle:{get:function(){return this._ellipseGeometry.rectangle}},textureCoordinateRotationPoints:{get:function(){return this._ellipseGeometry.textureCoordinateRotationPoints}}});var scratchCartesian1$4=new Cartesian3,boundingSphereCenter$1=new Cartesian3;function computeEllipse$1(e){var t=e.center;boundingSphereCenter$1=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter$1),e.height,boundingSphereCenter$1);for(var i=new BoundingSphere(boundingSphereCenter$1=Cartesian3.add(t,boundingSphereCenter$1,boundingSphereCenter$1),e.semiMajorAxis),r=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,n=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(r,e,!1)})}),a=r.length/3,o=IndexDatatype$1.createTypedArray(a,2*a),s=0,l=0;l<a;++l)o[s++]=l,o[s++]=(l+1)%a;return{boundingSphere:i,attributes:n,indices:o}}var topBoundingSphere$1=new BoundingSphere,bottomBoundingSphere$1=new BoundingSphere;function computeExtrudedEllipse$1(e){var t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,scratchCartesian1$4),e.height,scratchCartesian1$4);topBoundingSphere$1.center=Cartesian3.add(t,n,topBoundingSphere$1.center),topBoundingSphere$1.radius=r,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),bottomBoundingSphere$1.center=Cartesian3.add(t,n,bottomBoundingSphere$1.center),bottomBoundingSphere$1.radius=r;var a=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,o=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(a,e,!0)})});a=o.position.values;var s=BoundingSphere.union(topBoundingSphere$1,bottomBoundingSphere$1),l=a.length/3;if(defined(e.offsetAttribute)){var c=new Uint8Array(l);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)c=arrayFill(c,1,0,l/2);else c=arrayFill(c,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);o.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})}var u=defaultValue(e.numberOfVerticalLines,16);u=CesiumMath.clamp(u,0,l/2);var d=IndexDatatype$1.createTypedArray(l,2*l+2*u);l/=2;var h,p,m=0;for(h=0;h<l;++h)d[m++]=h,d[m++]=(h+1)%l,d[m++]=h+l,d[m++]=(h+1)%l+l;if(0<u){var f=Math.min(u,l);p=Math.round(l/f);var g=Math.min(p*u,l);for(h=0;h<g;h+=p)d[m++]=h,d[m++]=h+l}return{boundingSphere:s,attributes:o,indices:d}}function EllipseOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,n=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.height,0),s=defaultValue(e.extrudedHeight,o);this._center=Cartesian3.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=Ellipsoid.clone(i),this._rotation=defaultValue(e.rotation,0),this._height=Math.max(s,o),this._granularity=a,this._extrudedHeight=Math.min(s,o),this._numberOfVerticalLines=Math.max(defaultValue(e.numberOfVerticalLines,16),0),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipseOutlineGeometry"}EllipseOutlineGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+8,EllipseOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._center,t,i),i+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._numberOfVerticalLines,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchCenter$2=new Cartesian3,scratchEllipsoid$1=new Ellipsoid,scratchOptions$4={center:scratchCenter$2,ellipsoid:scratchEllipsoid$1,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function CircleOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,i={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new EllipseOutlineGeometry(i),this._workerName="createCircleOutlineGeometry"}EllipseOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchCenter$2);t+=Cartesian3.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$1);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._center=Cartesian3.clone(r,i._center),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._semiMajorAxis=a,i._semiMinorAxis=o,i._rotation=s,i._height=l,i._granularity=c,i._extrudedHeight=u,i._numberOfVerticalLines=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$4.height=l,scratchOptions$4.extrudedHeight=u,scratchOptions$4.granularity=c,scratchOptions$4.rotation=s,scratchOptions$4.semiMajorAxis=a,scratchOptions$4.semiMinorAxis=o,scratchOptions$4.numberOfVerticalLines=d,scratchOptions$4.offsetAttribute=-1===h?void 0:h,new EllipseOutlineGeometry(scratchOptions$4))},EllipseOutlineGeometry.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){var t=e._height,i=e._extrudedHeight,r=!CesiumMath.equalsEpsilon(t,i,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var n,a={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};if(r)a.extrudedHeight=i,a.offsetAttribute=e._offsetAttribute,n=computeExtrudedEllipse$1(a);else if(n=computeEllipse$1(a),defined(e._offsetAttribute)){var o=n.attributes.position.values.length,s=new Uint8Array(o/3);arrayFill(s,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:s})}return new Geometry({attributes:n.attributes,indices:n.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})}},CircleOutlineGeometry.packedLength=EllipseOutlineGeometry.packedLength,CircleOutlineGeometry.pack=function(e,t,i){return EllipseOutlineGeometry.pack(e._ellipseGeometry,t,i)};var scratchEllipseGeometry$1=new EllipseOutlineGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$5={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};CircleOutlineGeometry.unpack=function(e,t,i){var r=EllipseOutlineGeometry.unpack(e,t,scratchEllipseGeometry$1);return scratchOptions$5.center=Cartesian3.clone(r._center,scratchOptions$5.center),scratchOptions$5.ellipsoid=Ellipsoid.clone(r._ellipsoid,scratchOptions$5.ellipsoid),scratchOptions$5.height=r._height,scratchOptions$5.extrudedHeight=r._extrudedHeight,scratchOptions$5.granularity=r._granularity,scratchOptions$5.numberOfVerticalLines=r._numberOfVerticalLines,defined(i)?(scratchOptions$5.semiMajorAxis=r._semiMajorAxis,scratchOptions$5.semiMinorAxis=r._semiMinorAxis,i._ellipseGeometry=new EllipseOutlineGeometry(scratchOptions$5),i):(scratchOptions$5.radius=r._semiMajorAxis,new CircleOutlineGeometry(scratchOptions$5))},CircleOutlineGeometry.createGeometry=function(e){return EllipseOutlineGeometry.createGeometry(e._ellipseGeometry)};var ClockRange={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2},ClockRange$1=freezeObject$1(ClockRange),ClockStep={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2},ClockStep$1=freezeObject$1(ClockStep),getTimestamp;getTimestamp="undefined"!=typeof performance&&"function"==typeof performance.now&&isFinite(performance.now())?function(){return performance.now()}:function(){return Date.now()};var getTimestamp$1=getTimestamp,scratchArrayBuffer,scratchUint32Array,scratchUint8Array;function Clock(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).currentTime,i=e.startTime,r=e.stopTime;t=defined(t)?JulianDate.clone(t):defined(i)?JulianDate.clone(i):defined(r)?JulianDate.addDays(r,-1,new JulianDate):JulianDate.now(),i=defined(i)?JulianDate.clone(i):JulianDate.clone(t),r=defined(r)?JulianDate.clone(r):JulianDate.addDays(i,1,new JulianDate),this.startTime=i,this.stopTime=r,this.clockRange=defaultValue(e.clockRange,ClockRange$1.UNBOUNDED),this.canAnimate=defaultValue(e.canAnimate,!0),this.onTick=new Event,this.onStop=new Event,this._currentTime=void 0,this._multiplier=void 0,this._clockStep=void 0,this._shouldAnimate=void 0,this._lastSystemTime=getTimestamp$1(),this.currentTime=t,this.multiplier=defaultValue(e.multiplier,1),this.shouldAnimate=defaultValue(e.shouldAnimate,!1),this.clockStep=defaultValue(e.clockStep,ClockStep$1.SYSTEM_CLOCK_MULTIPLIER)}function hue2rgb(e,t,i){return i<0&&(i+=1),1<i&&(i-=1),6*i<1?e+6*(t-e)*i:2*i<1?t:3*i<2?e+(t-e)*(2/3-i)*6:e}function Color(e,t,i,r){this.red=defaultValue(e,1),this.green=defaultValue(t,1),this.blue=defaultValue(i,1),this.alpha=defaultValue(r,1)}defineProperties$1(Clock.prototype,{currentTime:{get:function(){return this._currentTime},set:function(e){JulianDate.equals(this._currentTime,e)||(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._currentTime=e)}},multiplier:{get:function(){return this._multiplier},set:function(e){this._multiplier!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._multiplier=e)}},clockStep:{get:function(){return this._clockStep},set:function(e){e===ClockStep$1.SYSTEM_CLOCK&&(this._multiplier=1,this._shouldAnimate=!0,this._currentTime=JulianDate.now()),this._clockStep=e}},shouldAnimate:{get:function(){return this._shouldAnimate},set:function(e){this._shouldAnimate!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._shouldAnimate=e)}}}),Clock.prototype.tick=function(){var e=getTimestamp$1(),t=JulianDate.clone(this._currentTime);if(this.canAnimate&&this._shouldAnimate){var i=this._clockStep;if(i===ClockStep$1.SYSTEM_CLOCK)t=JulianDate.now(t);else{var r=this._multiplier;if(i===ClockStep$1.TICK_DEPENDENT)t=JulianDate.addSeconds(t,r,t);else{var n=e-this._lastSystemTime;t=JulianDate.addSeconds(t,r*(n/1e3),t)}var a=this.clockRange,o=this.startTime,s=this.stopTime;if(a===ClockRange$1.CLAMPED)JulianDate.lessThan(t,o)?t=JulianDate.clone(o,t):JulianDate.greaterThan(t,s)&&(t=JulianDate.clone(s,t),this.onStop.raiseEvent(this));else if(a===ClockRange$1.LOOP_STOP)for(JulianDate.lessThan(t,o)&&(t=JulianDate.clone(o,t));JulianDate.greaterThan(t,s);)t=JulianDate.addSeconds(o,JulianDate.secondsDifference(t,s),t),this.onStop.raiseEvent(this)}}return this._currentTime=t,this._lastSystemTime=e,this.onTick.raiseEvent(this),t},Color.fromCartesian4=function(e,t){return defined(t)?(t.red=e.x,t.green=e.y,t.blue=e.z,t.alpha=e.w,t):new Color(e.x,e.y,e.z,e.w)},Color.fromBytes=function(e,t,i,r,n){return e=Color.byteToFloat(defaultValue(e,255)),t=Color.byteToFloat(defaultValue(t,255)),i=Color.byteToFloat(defaultValue(i,255)),r=Color.byteToFloat(defaultValue(r,255)),defined(n)?(n.red=e,n.green=t,n.blue=i,n.alpha=r,n):new Color(e,t,i,r)},Color.fromAlpha=function(e,t,i){return defined(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=t,i):new Color(e.red,e.green,e.blue,t)},FeatureDetection.supportsTypedArrays()&&(scratchArrayBuffer=new ArrayBuffer(4),scratchUint32Array=new Uint32Array(scratchArrayBuffer),scratchUint8Array=new Uint8Array(scratchArrayBuffer)),Color.fromRgba=function(e,t){return scratchUint32Array[0]=e,Color.fromBytes(scratchUint8Array[0],scratchUint8Array[1],scratchUint8Array[2],scratchUint8Array[3],t)},Color.fromHsl=function(e,t,i,r,n){e=defaultValue(e,0)%1,t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,1);var a=i,o=i,s=i;if(0!==t){var l,c=2*i-(l=i<.5?i*(1+t):i+t-i*t);a=hue2rgb(c,l,e+1/3),o=hue2rgb(c,l,e),s=hue2rgb(c,l,e-1/3)}return defined(n)?(n.red=a,n.green=o,n.blue=s,n.alpha=r,n):new Color(a,o,s,r)},Color.fromRandom=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).red;if(!defined(i)){var r=defaultValue(e.minimumRed,0),n=defaultValue(e.maximumRed,1);i=r+CesiumMath.nextRandomNumber()*(n-r)}var a=e.green;if(!defined(a)){var o=defaultValue(e.minimumGreen,0),s=defaultValue(e.maximumGreen,1);a=o+CesiumMath.nextRandomNumber()*(s-o)}var l=e.blue;if(!defined(l)){var c=defaultValue(e.minimumBlue,0),u=defaultValue(e.maximumBlue,1);l=c+CesiumMath.nextRandomNumber()*(u-c)}var d=e.alpha;if(!defined(d)){var h=defaultValue(e.minimumAlpha,0),p=defaultValue(e.maximumAlpha,1);d=h+CesiumMath.nextRandomNumber()*(p-h)}return defined(t)?(t.red=i,t.green=a,t.blue=l,t.alpha=d,t):new Color(i,a,l,d)};var rgbMatcher=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,rrggbbMatcher=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,rgbParenthesesMatcher=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,hslParenthesesMatcher=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;function ColorGeometryInstanceAttribute(e,t,i,r){e=defaultValue(e,1),t=defaultValue(t,1),i=defaultValue(i,1),r=defaultValue(r,1),this.value=new Uint8Array([Color.floatToByte(e),Color.floatToByte(t),Color.floatToByte(i),Color.floatToByte(r)])}function CompressedTextureBuffer(e,t,i,r){this._format=e,this._width=t,this._height=i,this._buffer=r}Color.fromCssColorString=function(e,t){defined(t)||(t=new Color);var i=Color[e.toUpperCase()];if(defined(i))return Color.clone(i,t),t;var r=rgbMatcher.exec(e);return null!==r?(t.red=parseInt(r[1],16)/15,t.green=parseInt(r[2],16)/15,t.blue=parseInt(r[3],16)/15,t.alpha=1,t):null!==(r=rrggbbMatcher.exec(e))?(t.red=parseInt(r[1],16)/255,t.green=parseInt(r[2],16)/255,t.blue=parseInt(r[3],16)/255,t.alpha=1,t):null!==(r=rgbParenthesesMatcher.exec(e))?(t.red=parseFloat(r[1])/("%"===r[1].substr(-1)?100:255),t.green=parseFloat(r[2])/("%"===r[2].substr(-1)?100:255),t.blue=parseFloat(r[3])/("%"===r[3].substr(-1)?100:255),t.alpha=parseFloat(defaultValue(r[4],"1.0")),t):null!==(r=hslParenthesesMatcher.exec(e))?Color.fromHsl(parseFloat(r[1])/360,parseFloat(r[2])/100,parseFloat(r[3])/100,parseFloat(defaultValue(r[4],"1.0")),t):t=void 0},Color.packedLength=4,Color.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.red,t[i++]=e.green,t[i++]=e.blue,t[i]=e.alpha,t},Color.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Color),i.red=e[t++],i.green=e[t++],i.blue=e[t++],i.alpha=e[t],i},Color.byteToFloat=function(e){return e/255},Color.floatToByte=function(e){return 1===e?255:256*e|0},Color.clone=function(e,t){if(defined(e))return defined(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new Color(e.red,e.green,e.blue,e.alpha)},Color.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},Color.equalsArray=function(e,t,i){return e.red===t[i]&&e.green===t[i+1]&&e.blue===t[i+2]&&e.alpha===t[i+3]},Color.prototype.clone=function(e){return Color.clone(this,e)},Color.prototype.equals=function(e){return Color.equals(this,e)},Color.prototype.equalsEpsilon=function(e,t){return this===e||defined(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},Color.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},Color.prototype.toCssColorString=function(){var e=Color.floatToByte(this.red),t=Color.floatToByte(this.green),i=Color.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+i+")":"rgba("+e+","+t+","+i+","+this.alpha+")"},Color.prototype.toBytes=function(e){var t=Color.floatToByte(this.red),i=Color.floatToByte(this.green),r=Color.floatToByte(this.blue),n=Color.floatToByte(this.alpha);return defined(e)?(e[0]=t,e[1]=i,e[2]=r,e[3]=n,e):[t,i,r,n]},Color.prototype.toRgba=function(){return scratchUint8Array[0]=Color.floatToByte(this.red),scratchUint8Array[1]=Color.floatToByte(this.green),scratchUint8Array[2]=Color.floatToByte(this.blue),scratchUint8Array[3]=Color.floatToByte(this.alpha),scratchUint32Array[0]},Color.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},Color.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},Color.prototype.withAlpha=function(e,t){return Color.fromAlpha(this,e,t)},Color.add=function(e,t,i){return i.red=e.red+t.red,i.green=e.green+t.green,i.blue=e.blue+t.blue,i.alpha=e.alpha+t.alpha,i},Color.subtract=function(e,t,i){return i.red=e.red-t.red,i.green=e.green-t.green,i.blue=e.blue-t.blue,i.alpha=e.alpha-t.alpha,i},Color.multiply=function(e,t,i){return i.red=e.red*t.red,i.green=e.green*t.green,i.blue=e.blue*t.blue,i.alpha=e.alpha*t.alpha,i},Color.divide=function(e,t,i){return i.red=e.red/t.red,i.green=e.green/t.green,i.blue=e.blue/t.blue,i.alpha=e.alpha/t.alpha,i},Color.mod=function(e,t,i){return i.red=e.red%t.red,i.green=e.green%t.green,i.blue=e.blue%t.blue,i.alpha=e.alpha%t.alpha,i},Color.multiplyByScalar=function(e,t,i){return i.red=e.red*t,i.green=e.green*t,i.blue=e.blue*t,i.alpha=e.alpha*t,i},Color.divideByScalar=function(e,t,i){return i.red=e.red/t,i.green=e.green/t,i.blue=e.blue/t,i.alpha=e.alpha/t,i},Color.ALICEBLUE=freezeObject$1(Color.fromCssColorString("#F0F8FF")),Color.ANTIQUEWHITE=freezeObject$1(Color.fromCssColorString("#FAEBD7")),Color.AQUA=freezeObject$1(Color.fromCssColorString("#00FFFF")),Color.AQUAMARINE=freezeObject$1(Color.fromCssColorString("#7FFFD4")),Color.AZURE=freezeObject$1(Color.fromCssColorString("#F0FFFF")),Color.BEIGE=freezeObject$1(Color.fromCssColorString("#F5F5DC")),Color.BISQUE=freezeObject$1(Color.fromCssColorString("#FFE4C4")),Color.BLACK=freezeObject$1(Color.fromCssColorString("#000000")),Color.BLANCHEDALMOND=freezeObject$1(Color.fromCssColorString("#FFEBCD")),Color.BLUE=freezeObject$1(Color.fromCssColorString("#0000FF")),Color.BLUEVIOLET=freezeObject$1(Color.fromCssColorString("#8A2BE2")),Color.BROWN=freezeObject$1(Color.fromCssColorString("#A52A2A")),Color.BURLYWOOD=freezeObject$1(Color.fromCssColorString("#DEB887")),Color.CADETBLUE=freezeObject$1(Color.fromCssColorString("#5F9EA0")),Color.CHARTREUSE=freezeObject$1(Color.fromCssColorString("#7FFF00")),Color.CHOCOLATE=freezeObject$1(Color.fromCssColorString("#D2691E")),Color.CORAL=freezeObject$1(Color.fromCssColorString("#FF7F50")),Color.CORNFLOWERBLUE=freezeObject$1(Color.fromCssColorString("#6495ED")),Color.CORNSILK=freezeObject$1(Color.fromCssColorString("#FFF8DC")),Color.CRIMSON=freezeObject$1(Color.fromCssColorString("#DC143C")),Color.CYAN=freezeObject$1(Color.fromCssColorString("#00FFFF")),Color.DARKBLUE=freezeObject$1(Color.fromCssColorString("#00008B")),Color.DARKCYAN=freezeObject$1(Color.fromCssColorString("#008B8B")),Color.DARKGOLDENROD=freezeObject$1(Color.fromCssColorString("#B8860B")),Color.DARKGRAY=freezeObject$1(Color.fromCssColorString("#A9A9A9")),Color.DARKGREEN=freezeObject$1(Color.fromCssColorString("#006400")),Color.DARKGREY=Color.DARKGRAY,Color.DARKKHAKI=freezeObject$1(Color.fromCssColorString("#BDB76B")),Color.DARKMAGENTA=freezeObject$1(Color.fromCssColorString("#8B008B")),Color.DARKOLIVEGREEN=freezeObject$1(Color.fromCssColorString("#556B2F")),Color.DARKORANGE=freezeObject$1(Color.fromCssColorString("#FF8C00")),Color.DARKORCHID=freezeObject$1(Color.fromCssColorString("#9932CC")),Color.DARKRED=freezeObject$1(Color.fromCssColorString("#8B0000")),Color.DARKSALMON=freezeObject$1(Color.fromCssColorString("#E9967A")),Color.DARKSEAGREEN=freezeObject$1(Color.fromCssColorString("#8FBC8F")),Color.DARKSLATEBLUE=freezeObject$1(Color.fromCssColorString("#483D8B")),Color.DARKSLATEGRAY=freezeObject$1(Color.fromCssColorString("#2F4F4F")),Color.DARKSLATEGREY=Color.DARKSLATEGRAY,Color.DARKTURQUOISE=freezeObject$1(Color.fromCssColorString("#00CED1")),Color.DARKVIOLET=freezeObject$1(Color.fromCssColorString("#9400D3")),Color.DEEPPINK=freezeObject$1(Color.fromCssColorString("#FF1493")),Color.DEEPSKYBLUE=freezeObject$1(Color.fromCssColorString("#00BFFF")),Color.DIMGRAY=freezeObject$1(Color.fromCssColorString("#696969")),Color.DIMGREY=Color.DIMGRAY,Color.DODGERBLUE=freezeObject$1(Color.fromCssColorString("#1E90FF")),Color.FIREBRICK=freezeObject$1(Color.fromCssColorString("#B22222")),Color.FLORALWHITE=freezeObject$1(Color.fromCssColorString("#FFFAF0")),Color.FORESTGREEN=freezeObject$1(Color.fromCssColorString("#228B22")),Color.FUCHSIA=freezeObject$1(Color.fromCssColorString("#FF00FF")),Color.GAINSBORO=freezeObject$1(Color.fromCssColorString("#DCDCDC")),Color.GHOSTWHITE=freezeObject$1(Color.fromCssColorString("#F8F8FF")),Color.GOLD=freezeObject$1(Color.fromCssColorString("#FFD700")),Color.GOLDENROD=freezeObject$1(Color.fromCssColorString("#DAA520")),Color.GRAY=freezeObject$1(Color.fromCssColorString("#808080")),Color.GREEN=freezeObject$1(Color.fromCssColorString("#008000")),Color.GREENYELLOW=freezeObject$1(Color.fromCssColorString("#ADFF2F")),Color.GREY=Color.GRAY,Color.HONEYDEW=freezeObject$1(Color.fromCssColorString("#F0FFF0")),Color.HOTPINK=freezeObject$1(Color.fromCssColorString("#FF69B4")),Color.INDIANRED=freezeObject$1(Color.fromCssColorString("#CD5C5C")),Color.INDIGO=freezeObject$1(Color.fromCssColorString("#4B0082")),Color.IVORY=freezeObject$1(Color.fromCssColorString("#FFFFF0")),Color.KHAKI=freezeObject$1(Color.fromCssColorString("#F0E68C")),Color.LAVENDER=freezeObject$1(Color.fromCssColorString("#E6E6FA")),Color.LAVENDAR_BLUSH=freezeObject$1(Color.fromCssColorString("#FFF0F5")),Color.LAWNGREEN=freezeObject$1(Color.fromCssColorString("#7CFC00")),Color.LEMONCHIFFON=freezeObject$1(Color.fromCssColorString("#FFFACD")),Color.LIGHTBLUE=freezeObject$1(Color.fromCssColorString("#ADD8E6")),Color.LIGHTCORAL=freezeObject$1(Color.fromCssColorString("#F08080")),Color.LIGHTCYAN=freezeObject$1(Color.fromCssColorString("#E0FFFF")),Color.LIGHTGOLDENRODYELLOW=freezeObject$1(Color.fromCssColorString("#FAFAD2")),Color.LIGHTGRAY=freezeObject$1(Color.fromCssColorString("#D3D3D3")),Color.LIGHTGREEN=freezeObject$1(Color.fromCssColorString("#90EE90")),Color.LIGHTGREY=Color.LIGHTGRAY,Color.LIGHTPINK=freezeObject$1(Color.fromCssColorString("#FFB6C1")),Color.LIGHTSEAGREEN=freezeObject$1(Color.fromCssColorString("#20B2AA")),Color.LIGHTSKYBLUE=freezeObject$1(Color.fromCssColorString("#87CEFA")),Color.LIGHTSLATEGRAY=freezeObject$1(Color.fromCssColorString("#778899")),Color.LIGHTSLATEGREY=Color.LIGHTSLATEGRAY,Color.LIGHTSTEELBLUE=freezeObject$1(Color.fromCssColorString("#B0C4DE")),Color.LIGHTYELLOW=freezeObject$1(Color.fromCssColorString("#FFFFE0")),Color.LIME=freezeObject$1(Color.fromCssColorString("#00FF00")),Color.LIMEGREEN=freezeObject$1(Color.fromCssColorString("#32CD32")),Color.LINEN=freezeObject$1(Color.fromCssColorString("#FAF0E6")),Color.MAGENTA=freezeObject$1(Color.fromCssColorString("#FF00FF")),Color.MAROON=freezeObject$1(Color.fromCssColorString("#800000")),Color.MEDIUMAQUAMARINE=freezeObject$1(Color.fromCssColorString("#66CDAA")),Color.MEDIUMBLUE=freezeObject$1(Color.fromCssColorString("#0000CD")),Color.MEDIUMORCHID=freezeObject$1(Color.fromCssColorString("#BA55D3")),Color.MEDIUMPURPLE=freezeObject$1(Color.fromCssColorString("#9370DB")),Color.MEDIUMSEAGREEN=freezeObject$1(Color.fromCssColorString("#3CB371")),Color.MEDIUMSLATEBLUE=freezeObject$1(Color.fromCssColorString("#7B68EE")),Color.MEDIUMSPRINGGREEN=freezeObject$1(Color.fromCssColorString("#00FA9A")),Color.MEDIUMTURQUOISE=freezeObject$1(Color.fromCssColorString("#48D1CC")),Color.MEDIUMVIOLETRED=freezeObject$1(Color.fromCssColorString("#C71585")),Color.MIDNIGHTBLUE=freezeObject$1(Color.fromCssColorString("#191970")),Color.MINTCREAM=freezeObject$1(Color.fromCssColorString("#F5FFFA")),Color.MISTYROSE=freezeObject$1(Color.fromCssColorString("#FFE4E1")),Color.MOCCASIN=freezeObject$1(Color.fromCssColorString("#FFE4B5")),Color.NAVAJOWHITE=freezeObject$1(Color.fromCssColorString("#FFDEAD")),Color.NAVY=freezeObject$1(Color.fromCssColorString("#000080")),Color.OLDLACE=freezeObject$1(Color.fromCssColorString("#FDF5E6")),Color.OLIVE=freezeObject$1(Color.fromCssColorString("#808000")),Color.OLIVEDRAB=freezeObject$1(Color.fromCssColorString("#6B8E23")),Color.ORANGE=freezeObject$1(Color.fromCssColorString("#FFA500")),Color.ORANGERED=freezeObject$1(Color.fromCssColorString("#FF4500")),Color.ORCHID=freezeObject$1(Color.fromCssColorString("#DA70D6")),Color.PALEGOLDENROD=freezeObject$1(Color.fromCssColorString("#EEE8AA")),Color.PALEGREEN=freezeObject$1(Color.fromCssColorString("#98FB98")),Color.PALETURQUOISE=freezeObject$1(Color.fromCssColorString("#AFEEEE")),Color.PALEVIOLETRED=freezeObject$1(Color.fromCssColorString("#DB7093")),Color.PAPAYAWHIP=freezeObject$1(Color.fromCssColorString("#FFEFD5")),Color.PEACHPUFF=freezeObject$1(Color.fromCssColorString("#FFDAB9")),Color.PERU=freezeObject$1(Color.fromCssColorString("#CD853F")),Color.PINK=freezeObject$1(Color.fromCssColorString("#FFC0CB")),Color.PLUM=freezeObject$1(Color.fromCssColorString("#DDA0DD")),Color.POWDERBLUE=freezeObject$1(Color.fromCssColorString("#B0E0E6")),Color.PURPLE=freezeObject$1(Color.fromCssColorString("#800080")),Color.RED=freezeObject$1(Color.fromCssColorString("#FF0000")),Color.ROSYBROWN=freezeObject$1(Color.fromCssColorString("#BC8F8F")),Color.ROYALBLUE=freezeObject$1(Color.fromCssColorString("#4169E1")),Color.SADDLEBROWN=freezeObject$1(Color.fromCssColorString("#8B4513")),Color.SALMON=freezeObject$1(Color.fromCssColorString("#FA8072")),Color.SANDYBROWN=freezeObject$1(Color.fromCssColorString("#F4A460")),Color.SEAGREEN=freezeObject$1(Color.fromCssColorString("#2E8B57")),Color.SEASHELL=freezeObject$1(Color.fromCssColorString("#FFF5EE")),Color.SIENNA=freezeObject$1(Color.fromCssColorString("#A0522D")),Color.SILVER=freezeObject$1(Color.fromCssColorString("#C0C0C0")),Color.SKYBLUE=freezeObject$1(Color.fromCssColorString("#87CEEB")),Color.SLATEBLUE=freezeObject$1(Color.fromCssColorString("#6A5ACD")),Color.SLATEGRAY=freezeObject$1(Color.fromCssColorString("#708090")),Color.SLATEGREY=Color.SLATEGRAY,Color.SNOW=freezeObject$1(Color.fromCssColorString("#FFFAFA")),Color.SPRINGGREEN=freezeObject$1(Color.fromCssColorString("#00FF7F")),Color.STEELBLUE=freezeObject$1(Color.fromCssColorString("#4682B4")),Color.TAN=freezeObject$1(Color.fromCssColorString("#D2B48C")),Color.TEAL=freezeObject$1(Color.fromCssColorString("#008080")),Color.THISTLE=freezeObject$1(Color.fromCssColorString("#D8BFD8")),Color.TOMATO=freezeObject$1(Color.fromCssColorString("#FF6347")),Color.TURQUOISE=freezeObject$1(Color.fromCssColorString("#40E0D0")),Color.VIOLET=freezeObject$1(Color.fromCssColorString("#EE82EE")),Color.WHEAT=freezeObject$1(Color.fromCssColorString("#F5DEB3")),Color.WHITE=freezeObject$1(Color.fromCssColorString("#FFFFFF")),Color.WHITESMOKE=freezeObject$1(Color.fromCssColorString("#F5F5F5")),Color.YELLOW=freezeObject$1(Color.fromCssColorString("#FFFF00")),Color.YELLOWGREEN=freezeObject$1(Color.fromCssColorString("#9ACD32")),Color.TRANSPARENT=freezeObject$1(new Color(0,0,0,0)),defineProperties$1(ColorGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}}),ColorGeometryInstanceAttribute.fromColor=function(e){return new ColorGeometryInstanceAttribute(e.red,e.green,e.blue,e.alpha)},ColorGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?e.toBytes(t):new Uint8Array(e.toBytes())},ColorGeometryInstanceAttribute.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.value[0]===t.value[0]&&e.value[1]===t.value[1]&&e.value[2]===t.value[2]&&e.value[3]===t.value[3]},defineProperties$1(CompressedTextureBuffer.prototype,{internalFormat:{get:function(){return this._format}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},bufferView:{get:function(){return this._buffer}}}),CompressedTextureBuffer.clone=function(e){if(defined(e))return new CompressedTextureBuffer(e._format,e._width,e._height,e._buffer)},CompressedTextureBuffer.prototype.clone=function(){return CompressedTextureBuffer.clone(this)};var removeDuplicatesEpsilon=CesiumMath.EPSILON10;function arrayRemoveDuplicates(e,t,i){if(defined(e)){i=defaultValue(i,!1);var r,n,a,o=e.length;if(o<2)return e;for(r=1;r<o&&!t(n=e[r-1],a=e[r],removeDuplicatesEpsilon);++r);if(r===o)return i&&t(e[0],e[e.length-1],removeDuplicatesEpsilon)?e.slice(1):e;for(var s=e.slice(0,r);r<o;++r)t(n,a=e[r],removeDuplicatesEpsilon)||(s.push(a),n=a);return i&&1<s.length&&t(s[0],s[s.length-1],removeDuplicatesEpsilon)&&s.shift(),s}}var CoplanarPolygonGeometryLibrary={},scratchIntersectionPoint=new Cartesian3,scratchXAxis=new Cartesian3,scratchYAxis=new Cartesian3,scratchZAxis=new Cartesian3,obbScratch=new OrientedBoundingBox;function projectTo2D(e,t,i,r,n){var a=Cartesian3.subtract(e,t,scratchIntersectionPoint),o=Cartesian3.dot(i,a),s=Cartesian3.dot(r,a);return Cartesian2.fromElements(o,s,n)}function calculateM(e,t,i){if(0===e)return t*i;var r=e*e,n=r*r,a=n*r,o=a*r,s=o*r,l=s*r,c=i;return t*((1-r/4-3*n/64-5*a/256-175*o/16384-441*s/65536-4851*l/1048576)*c-(3*r/8+3*n/32+45*a/1024+105*o/4096+2205*s/131072+6237*l/524288)*Math.sin(2*c)+(15*n/256+45*a/1024+525*o/16384+1575*s/65536+155925*l/8388608)*Math.sin(4*c)-(35*a/3072+175*o/12288+3675*s/262144+13475*l/1048576)*Math.sin(6*c)+(315*o/131072+2205*s/524288+43659*l/8388608)*Math.sin(8*c)-(693*s/1310720+6237*l/5242880)*Math.sin(10*c)+1001*l/8388608*Math.sin(12*c))}function calculateInverseM(e,t,i){var r=e/i;if(0===t)return r;var n=r*r,a=n*r,o=a*r,s=t*t,l=s*s,c=l*s,u=c*s,d=u*s,h=d*s,p=Math.sin(2*r),m=Math.cos(2*r),f=Math.sin(4*r),g=Math.cos(4*r),_=Math.sin(6*r),y=Math.cos(6*r),v=Math.sin(8*r),C=Math.cos(8*r),S=Math.sin(10*r);return r+r*s/4+7*r*l/64+15*r*c/256+579*r*u/16384+1515*r*d/65536+16837*r*h/1048576+(3*r*l/16+45*r*c/256-r*(32*n-561)*u/4096-r*(232*n-1677)*d/16384+r*(399985-90560*n+512*o)*h/5242880)*m+(21*r*c/256+483*r*u/4096-r*(224*n-1969)*d/16384-r*(33152*n-112599)*h/1048576)*g+(151*r*u/4096+4681*r*d/65536+1479*r*h/16384-453*a*h/32768)*y+(1097*r*d/65536+42783*r*h/1048576)*C+8011*r*h/1048576*Math.cos(10*r)+(3*s/8+3*l/16+213*c/2048-3*n*c/64+255*u/4096-33*n*u/512+20861*d/524288-33*n*d/512+o*d/1024+28273*h/1048576-471*n*h/8192+9*o*h/4096)*p+(21*l/256+21*c/256+533*u/8192-21*n*u/512+197*d/4096-315*n*d/4096+584039*h/16777216-12517*n*h/131072+7*o*h/2048)*f+(151*c/6144+151*u/4096+5019*d/131072-453*n*d/16384+26965*h/786432-8607*n*h/131072)*_+(1097*u/131072+1097*d/65536+225797*h/10485760-1097*n*h/65536)*v+(8011*d/2621440+8011*h/1048576)*S+293393*h/251658240*Math.sin(12*r)}function calculateSigma(e,t){if(0===e)return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)));var i=e*Math.sin(t);return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)))-e/2*Math.log((1+i)/(1-i))}function calculateHeading(e,t,i,r,n){var a=calculateSigma(e._ellipticity,i),o=calculateSigma(e._ellipticity,n);return Math.atan2(CesiumMath.negativePiToPi(r-t),o-a)}function calculateArcLength(e,t,i,r,n,a,o){var s=e._heading,l=a-r,c=0;if(CesiumMath.equalsEpsilon(Math.abs(s),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8))if(t===i)c=t*Math.cos(n)*CesiumMath.negativePiToPi(l);else{var u=Math.sin(n);c=t*Math.cos(n)*CesiumMath.negativePiToPi(l)/Math.sqrt(1-e._ellipticitySquared*u*u)}else{var d=calculateM(e._ellipticity,t,n);c=(calculateM(e._ellipticity,t,o)-d)/Math.cos(s)}return Math.abs(c)}CoplanarPolygonGeometryLibrary.validOutline=function(e){var t=OrientedBoundingBox.fromPoints(e,obbScratch).halfAxes,i=Matrix3.getColumn(t,0,scratchXAxis),r=Matrix3.getColumn(t,1,scratchYAxis),n=Matrix3.getColumn(t,2,scratchZAxis),a=Cartesian3.magnitude(i),o=Cartesian3.magnitude(r),s=Cartesian3.magnitude(n);return!(0===a&&(0===o||0===s)||0===o&&0===s)},CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments=function(e,t,i,r){var n,a,o=OrientedBoundingBox.fromPoints(e,obbScratch),s=o.halfAxes,l=Matrix3.getColumn(s,0,scratchXAxis),c=Matrix3.getColumn(s,1,scratchYAxis),u=Matrix3.getColumn(s,2,scratchZAxis),d=Cartesian3.magnitude(l),h=Cartesian3.magnitude(c),p=Cartesian3.magnitude(u),m=Math.min(d,h,p);return(0!==d||0!==h&&0!==p)&&(0!==h||0!==p)&&(m!==h&&m!==p||(n=l),m===d?n=c:m===p&&(a=c),m!==d&&m!==h||(a=u),Cartesian3.normalize(n,i),Cartesian3.normalize(a,r),Cartesian3.clone(o.center,t),!0)},CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction=function(r,n,a){return function(e){for(var t=new Array(e.length),i=0;i<e.length;i++)t[i]=projectTo2D(e[i],r,n,a);return t}},CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction=function(i,r,n){return function(e,t){return projectTo2D(e,i,r,n,t)}};var scratchCart1=new Cartesian3,scratchCart2=new Cartesian3;function computeProperties(e,t,i,r){Cartesian3.normalize(r.cartographicToCartesian(t,scratchCart2),scratchCart1),Cartesian3.normalize(r.cartographicToCartesian(i,scratchCart2),scratchCart2);var n=r.maximumRadius,a=r.minimumRadius,o=n*n,s=a*a;e._ellipticitySquared=(o-s)/o,e._ellipticity=Math.sqrt(e._ellipticitySquared),e._start=Cartographic.clone(t,e._start),e._start.height=0,e._end=Cartographic.clone(i,e._end),e._end.height=0,e._heading=calculateHeading(e,t.longitude,t.latitude,i.longitude,i.latitude),e._distance=calculateArcLength(e,r.maximumRadius,r.minimumRadius,t.longitude,t.latitude,i.longitude,i.latitude)}function interpolateUsingSurfaceDistance(e,t,i,r,n,a){var o,s,l,c=n*n;if(Math.abs(CesiumMath.PI_OVER_TWO-Math.abs(t))>CesiumMath.EPSILON8){s=calculateInverseM(calculateM(n,r,e.latitude)+i*Math.cos(t),n,r);var u=calculateSigma(n,e.latitude),d=calculateSigma(n,s);l=Math.tan(t)*(d-u),o=CesiumMath.negativePiToPi(e.longitude+l)}else{var h;if(s=e.latitude,0===n)h=r*Math.cos(e.latitude);else{var p=Math.sin(e.latitude);h=r*Math.cos(e.latitude)/Math.sqrt(1-c*p*p)}l=i/h,o=0<t?CesiumMath.negativePiToPi(e.longitude+l):CesiumMath.negativePiToPi(e.longitude-l)}return defined(a)?(a.longitude=o,a.latitude=s,a.height=0,a):new Cartographic(o,s,0)}function EllipsoidRhumbLine(e,t,i){var r=defaultValue(i,Ellipsoid.WGS84);this._ellipsoid=r,this._start=new Cartographic,this._end=new Cartographic,this._heading=void 0,this._distance=void 0,this._ellipticity=void 0,this._ellipticitySquared=void 0,defined(e)&&defined(t)&&computeProperties(this,e,t,r)}function earcut(e,t,i){i=i||2;var r,n,a,o,s,l,c,u=t&&t.length,d=u?t[0]*i:e.length,h=linkedList(e,0,d,i,!0),p=[];if(!h)return p;if(u&&(h=eliminateHoles(e,t,h,i)),e.length>80*i){r=a=e[0],n=o=e[1];for(var m=i;m<d;m+=i)(s=e[m])<r&&(r=s),(l=e[m+1])<n&&(n=l),a<s&&(a=s),o<l&&(o=l);c=Math.max(a-r,o-n)}return earcutLinked(h,p,i,r,n,c),p}function linkedList(e,t,i,r,n){var a,o;if(n===0<signedArea(e,t,i,r))for(a=t;a<i;a+=r)o=insertNode(a,e[a],e[a+1],o);else for(a=i-r;t<=a;a-=r)o=insertNode(a,e[a],e[a+1],o);return o&&equals(o,o.next)&&(removeNode(o),o=o.next),o}function filterPoints(e,t){if(!e)return e;t=t||e;var i,r=e;do{if(i=!1,r.steiner||!equals(r,r.next)&&0!==area(r.prev,r,r.next))r=r.next;else{if(removeNode(r),(r=t=r.prev)===r.next)return null;i=!0}}while(i||r!==t);return t}function earcutLinked(e,t,i,r,n,a,o){if(e){!o&&a&&indexCurve(e,r,n,a);for(var s,l,c=e;e.prev!==e.next;)if(s=e.prev,l=e.next,a?isEarHashed(e,r,n,a):isEar(e))t.push(s.i/i),t.push(e.i/i),t.push(l.i/i),removeNode(e),e=l.next,c=l.next;else if((e=l)===c){o?1===o?earcutLinked(e=cureLocalIntersections(e,t,i),t,i,r,n,a,2):2===o&&splitEarcut(e,t,i,r,n,a):earcutLinked(filterPoints(e),t,i,r,n,a,1);break}}}function isEar(e){var t=e.prev,i=e,r=e.next;if(0<=area(t,i,r))return!1;for(var n=e.next.next;n!==e.prev;){if(pointInTriangle(t.x,t.y,i.x,i.y,r.x,r.y,n.x,n.y)&&0<=area(n.prev,n,n.next))return!1;n=n.next}return!0}function isEarHashed(e,t,i,r){var n=e.prev,a=e,o=e.next;if(0<=area(n,a,o))return!1;for(var s=n.x<a.x?n.x<o.x?n.x:o.x:a.x<o.x?a.x:o.x,l=n.y<a.y?n.y<o.y?n.y:o.y:a.y<o.y?a.y:o.y,c=n.x>a.x?n.x>o.x?n.x:o.x:a.x>o.x?a.x:o.x,u=n.y>a.y?n.y>o.y?n.y:o.y:a.y>o.y?a.y:o.y,d=zOrder(s,l,t,i,r),h=zOrder(c,u,t,i,r),p=e.nextZ;p&&p.z<=h;){if(p!==e.prev&&p!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,p.x,p.y)&&0<=area(p.prev,p,p.next))return!1;p=p.nextZ}for(p=e.prevZ;p&&p.z>=d;){if(p!==e.prev&&p!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,p.x,p.y)&&0<=area(p.prev,p,p.next))return!1;p=p.prevZ}return!0}function cureLocalIntersections(e,t,i){var r=e;do{var n=r.prev,a=r.next.next;!equals(n,a)&&intersects(n,r,r.next,a)&&locallyInside(n,a)&&locallyInside(a,n)&&(t.push(n.i/i),t.push(r.i/i),t.push(a.i/i),removeNode(r),removeNode(r.next),r=e=a),r=r.next}while(r!==e);return r}function splitEarcut(e,t,i,r,n,a){var o=e;do{for(var s=o.next.next;s!==o.prev;){if(o.i!==s.i&&isValidDiagonal(o,s)){var l=splitPolygon(o,s);return o=filterPoints(o,o.next),l=filterPoints(l,l.next),earcutLinked(o,t,i,r,n,a),void earcutLinked(l,t,i,r,n,a)}s=s.next}o=o.next}while(o!==e)}function eliminateHoles(e,t,i,r){var n,a,o,s=[];for(n=0,a=t.length;n<a;n++)(o=linkedList(e,t[n]*r,n<a-1?t[n+1]*r:e.length,r,!1))===o.next&&(o.steiner=!0),s.push(getLeftmost(o));for(s.sort(compareX),n=0;n<s.length;n++)eliminateHole(s[n],i),i=filterPoints(i,i.next);return i}function compareX(e,t){return e.x-t.x}function eliminateHole(e,t){if(t=findHoleBridge(e,t)){var i=splitPolygon(t,e);filterPoints(i,i.next)}}function findHoleBridge(e,t){var i,r=t,n=e.x,a=e.y,o=-1/0;do{if(a<=r.y&&a>=r.next.y){var s=r.x+(a-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(s<=n&&o<s){if((o=s)===n){if(a===r.y)return r;if(a===r.next.y)return r.next}i=r.x<r.next.x?r:r.next}}r=r.next}while(r!==t);if(!i)return null;if(n===o)return i.prev;var l,c=i,u=i.x,d=i.y,h=1/0;for(r=i.next;r!==c;)n>=r.x&&r.x>=u&&pointInTriangle(a<d?n:o,a,u,d,a<d?o:n,a,r.x,r.y)&&((l=Math.abs(a-r.y)/(n-r.x))<h||l===h&&r.x>i.x)&&locallyInside(r,e)&&(i=r,h=l),r=r.next;return i}function indexCurve(e,t,i,r){for(var n=e;null===n.z&&(n.z=zOrder(n.x,n.y,t,i,r)),n.prevZ=n.prev,n.nextZ=n.next,(n=n.next)!==e;);n.prevZ.nextZ=null,n.prevZ=null,sortLinked(n)}function sortLinked(e){var t,i,r,n,a,o,s,l,c=1;do{for(i=e,a=e=null,o=0;i;){for(o++,r=i,t=s=0;t<c&&(s++,r=r.nextZ);t++);for(l=c;0<s||0<l&&r;)0===s?(r=(n=r).nextZ,l--):0!==l&&r?i.z<=r.z?(i=(n=i).nextZ,s--):(r=(n=r).nextZ,l--):(i=(n=i).nextZ,s--),a?a.nextZ=n:e=n,n.prevZ=a,a=n;i=r}a.nextZ=null,c*=2}while(1<o);return e}function zOrder(e,t,i,r,n){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-i)/n)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)/n)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function getLeftmost(e){for(var t=e,i=e;t.x<i.x&&(i=t),(t=t.next)!==e;);return i}function pointInTriangle(e,t,i,r,n,a,o,s){return 0<=(n-o)*(t-s)-(e-o)*(a-s)&&0<=(e-o)*(r-s)-(i-o)*(t-s)&&0<=(i-o)*(a-s)-(n-o)*(r-s)}function isValidDiagonal(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!intersectsPolygon(e,t)&&locallyInside(e,t)&&locallyInside(t,e)&&middleInside(e,t)}function area(e,t,i){return(t.y-e.y)*(i.x-t.x)-(t.x-e.x)*(i.y-t.y)}function equals(e,t){return e.x===t.x&&e.y===t.y}function intersects(e,t,i,r){return!!(equals(e,t)&&equals(i,r)||equals(e,r)&&equals(i,t))||0<area(e,t,i)!=0<area(e,t,r)&&0<area(i,r,e)!=0<area(i,r,t)}function intersectsPolygon(e,t){var i=e;do{if(i.i!==e.i&&i.next.i!==e.i&&i.i!==t.i&&i.next.i!==t.i&&intersects(i,i.next,e,t))return!0;i=i.next}while(i!==e);return!1}function locallyInside(e,t){return area(e.prev,e,e.next)<0?0<=area(e,t,e.next)&&0<=area(e,e.prev,t):area(e,t,e.prev)<0||area(e,e.next,t)<0}function middleInside(e,t){for(var i=e,r=!1,n=(e.x+t.x)/2,a=(e.y+t.y)/2;i.y>a!=i.next.y>a&&n<(i.next.x-i.x)*(a-i.y)/(i.next.y-i.y)+i.x&&(r=!r),(i=i.next)!==e;);return r}function splitPolygon(e,t){var i=new Node$1(e.i,e.x,e.y),r=new Node$1(t.i,t.x,t.y),n=e.next,a=t.prev;return(e.next=t).prev=e,(i.next=n).prev=i,(r.next=i).prev=r,(a.next=r).prev=a,r}function insertNode(e,t,i,r){var n=new Node$1(e,t,i);return r?(n.next=r.next,(n.prev=r).next.prev=n,r.next=n):(n.prev=n).next=n,n}function removeNode(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function Node$1(e,t,i){this.i=e,this.x=t,this.y=i,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function signedArea(e,t,i,r){for(var n=0,a=t,o=i-r;a<i;a+=r)n+=(e[o]-e[a])*(e[a+1]+e[o+1]),o=a;return n}defineProperties$1(EllipsoidRhumbLine.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},heading:{get:function(){return this._heading}}}),EllipsoidRhumbLine.fromStartHeadingDistance=function(e,t,i,r,n){var a=defaultValue(r,Ellipsoid.WGS84),o=a.maximumRadius,s=a.minimumRadius,l=o*o,c=s*s,u=Math.sqrt((l-c)/l),d=interpolateUsingSurfaceDistance(e,t=CesiumMath.negativePiToPi(t),i,a.maximumRadius,u);return!defined(n)||defined(r)&&!r.equals(n.ellipsoid)?new EllipsoidRhumbLine(e,d,a):(n.setEndPoints(e,d),n)},EllipsoidRhumbLine.prototype.setEndPoints=function(e,t){computeProperties(this,e,t,this._ellipsoid)},EllipsoidRhumbLine.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(e*this._distance,t)},EllipsoidRhumbLine.prototype.interpolateUsingSurfaceDistance=function(e,t){return interpolateUsingSurfaceDistance(this._start,this._heading,e,this._ellipsoid.maximumRadius,this._ellipticity,t)},EllipsoidRhumbLine.prototype.findIntersectionWithLongitude=function(e,t){var i=this._ellipticity,r=this._heading,n=Math.abs(r),a=this._start;if(e=CesiumMath.negativePiToPi(e),CesiumMath.equalsEpsilon(Math.abs(e),Math.PI,CesiumMath.EPSILON14)&&(e=CesiumMath.sign(a.longitude)*Math.PI),defined(t)||(t=new Cartographic),Math.abs(CesiumMath.PI_OVER_TWO-n)<=CesiumMath.EPSILON8)return t.longitude=e,t.latitude=a.latitude,t.height=0,t;if(CesiumMath.equalsEpsilon(Math.abs(CesiumMath.PI_OVER_TWO-n),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)){if(CesiumMath.equalsEpsilon(e,a.longitude,CesiumMath.EPSILON12))return;return t.longitude=e,t.latitude=CesiumMath.PI_OVER_TWO*CesiumMath.sign(CesiumMath.PI_OVER_TWO-r),t.height=0,t}var o,s=a.latitude,l=i*Math.sin(s),c=Math.tan(.5*(CesiumMath.PI_OVER_TWO+s))*Math.exp((e-a.longitude)/Math.tan(r)),u=(1+l)/(1-l),d=a.latitude;do{o=d;var h=i*Math.sin(o),p=(1+h)/(1-h);d=2*Math.atan(c*Math.pow(p/u,i/2))-CesiumMath.PI_OVER_TWO}while(!CesiumMath.equalsEpsilon(d,o,CesiumMath.EPSILON12));return t.longitude=e,t.latitude=d,t.height=0,t},EllipsoidRhumbLine.prototype.findIntersectionWithLatitude=function(e,t){var i=this._ellipticity,r=this._heading,n=this._start;if(!CesiumMath.equalsEpsilon(Math.abs(r),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)){var a=calculateSigma(i,n.latitude),o=calculateSigma(i,e),s=Math.tan(r)*(o-a),l=CesiumMath.negativePiToPi(n.longitude+s);return defined(t)?(t.longitude=l,t.latitude=e,t.height=0,t):new Cartographic(l,e,0)}},earcut.deviation=function(e,t,i,r){var n=t&&t.length,a=n?t[0]*i:e.length,o=Math.abs(signedArea(e,0,a,i));if(n)for(var s=0,l=t.length;s<l;s++){var c=t[s]*i,u=s<l-1?t[s+1]*i:e.length;o-=Math.abs(signedArea(e,c,u,i))}var d=0;for(s=0;s<r.length;s+=3){var h=r[s]*i,p=r[s+1]*i,m=r[s+2]*i;d+=Math.abs((e[h]-e[m])*(e[1+p]-e[1+h])-(e[h]-e[p])*(e[1+m]-e[1+h]))}return 0===o&&0===d?0:Math.abs((d-o)/o)},earcut.flatten=function(e){for(var t=e[0][0].length,i={vertices:[],holes:[],dimensions:t},r=0,n=0;n<e.length;n++){for(var a=0;a<e[n].length;a++)for(var o=0;o<t;o++)i.vertices.push(e[n][a][o]);0<n&&(r+=e[n-1].length,i.holes.push(r))}return i};var WindingOrder={CLOCKWISE:WebGLConstants$1.CW,COUNTER_CLOCKWISE:WebGLConstants$1.CCW,validate:function(e){return e===WindingOrder.CLOCKWISE||e===WindingOrder.COUNTER_CLOCKWISE}},WindingOrder$1=freezeObject$1(WindingOrder),scaleToGeodeticHeightN=new Cartesian3,scaleToGeodeticHeightP=new Cartesian3,PolygonPipeline={computeArea2D:function(e){for(var t=e.length,i=0,r=t-1,n=0;n<t;r=n++){var a=e[r],o=e[n];i+=a.x*o.y-o.x*a.y}return.5*i},computeWindingOrder2D:function(e){return 0<PolygonPipeline.computeArea2D(e)?WindingOrder$1.COUNTER_CLOCKWISE:WindingOrder$1.CLOCKWISE},triangulate:function(e,t){return earcut(Cartesian2.packArray(e),t,2)}},subdivisionV0Scratch=new Cartesian3,subdivisionV1Scratch=new Cartesian3,subdivisionV2Scratch=new Cartesian3,subdivisionS0Scratch=new Cartesian3,subdivisionS1Scratch=new Cartesian3,subdivisionS2Scratch=new Cartesian3,subdivisionMidScratch=new Cartesian3;PolygonPipeline.computeSubdivision=function(e,t,i,r){r=defaultValue(r,CesiumMath.RADIANS_PER_DEGREE);var n,a=i.slice(0),o=t.length,s=new Array(3*o),l=0;for(n=0;n<o;n++){var c=t[n];s[l++]=c.x,s[l++]=c.y,s[l++]=c.z}for(var u=[],d={},h=e.maximumRadius,p=CesiumMath.chordLength(r,h),m=p*p;0<a.length;){var f,g,_=a.pop(),y=a.pop(),v=a.pop(),C=Cartesian3.fromArray(s,3*v,subdivisionV0Scratch),S=Cartesian3.fromArray(s,3*y,subdivisionV1Scratch),T=Cartesian3.fromArray(s,3*_,subdivisionV2Scratch),x=Cartesian3.multiplyByScalar(Cartesian3.normalize(C,subdivisionS0Scratch),h,subdivisionS0Scratch),b=Cartesian3.multiplyByScalar(Cartesian3.normalize(S,subdivisionS1Scratch),h,subdivisionS1Scratch),E=Cartesian3.multiplyByScalar(Cartesian3.normalize(T,subdivisionS2Scratch),h,subdivisionS2Scratch),P=Cartesian3.magnitudeSquared(Cartesian3.subtract(x,b,subdivisionMidScratch)),A=Cartesian3.magnitudeSquared(Cartesian3.subtract(b,E,subdivisionMidScratch)),w=Cartesian3.magnitudeSquared(Cartesian3.subtract(E,x,subdivisionMidScratch)),D=Math.max(P,A,w);m<D?P===D?(defined(n=d[f=Math.min(v,y)+" "+Math.max(v,y)])||(g=Cartesian3.add(C,S,subdivisionMidScratch),Cartesian3.multiplyByScalar(g,.5,g),s.push(g.x,g.y,g.z),n=s.length/3-1,d[f]=n),a.push(v,n,_),a.push(n,y,_)):A===D?(defined(n=d[f=Math.min(y,_)+" "+Math.max(y,_)])||(g=Cartesian3.add(S,T,subdivisionMidScratch),Cartesian3.multiplyByScalar(g,.5,g),s.push(g.x,g.y,g.z),n=s.length/3-1,d[f]=n),a.push(y,n,v),a.push(n,_,v)):w===D&&(defined(n=d[f=Math.min(_,v)+" "+Math.max(_,v)])||(g=Cartesian3.add(T,C,subdivisionMidScratch),Cartesian3.multiplyByScalar(g,.5,g),s.push(g.x,g.y,g.z),n=s.length/3-1,d[f]=n),a.push(_,n,y),a.push(n,v,y)):(u.push(v),u.push(y),u.push(_))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},indices:u,primitiveType:PrimitiveType$1.TRIANGLES})};var subdivisionC0Scratch=new Cartographic,subdivisionC1Scratch=new Cartographic,subdivisionC2Scratch=new Cartographic,subdivisionCartographicScratch=new Cartographic;function Queue(){this._array=[],this._offset=0,this._length=0}PolygonPipeline.computeRhumbLineSubdivision=function(e,t,i,r){r=defaultValue(r,CesiumMath.RADIANS_PER_DEGREE);var n,a=i.slice(0),o=t.length,s=new Array(3*o),l=0;for(n=0;n<o;n++){var c=t[n];s[l++]=c.x,s[l++]=c.y,s[l++]=c.z}for(var u=[],d={},h=e.maximumRadius,p=CesiumMath.chordLength(r,h),m=new EllipsoidRhumbLine(void 0,void 0,e),f=new EllipsoidRhumbLine(void 0,void 0,e),g=new EllipsoidRhumbLine(void 0,void 0,e);0<a.length;){var _=a.pop(),y=a.pop(),v=a.pop(),C=Cartesian3.fromArray(s,3*v,subdivisionV0Scratch),S=Cartesian3.fromArray(s,3*y,subdivisionV1Scratch),T=Cartesian3.fromArray(s,3*_,subdivisionV2Scratch),x=e.cartesianToCartographic(C,subdivisionC0Scratch),b=e.cartesianToCartographic(S,subdivisionC1Scratch),E=e.cartesianToCartographic(T,subdivisionC2Scratch);m.setEndPoints(x,b);var P=m.surfaceDistance;f.setEndPoints(b,E);var A=f.surfaceDistance;g.setEndPoints(E,x);var w,D,M,I,R=g.surfaceDistance,O=Math.max(P,A,R);p<O?P===O?(defined(n=d[w=Math.min(v,y)+" "+Math.max(v,y)])||(D=m.interpolateUsingFraction(.5,subdivisionCartographicScratch),M=.5*(x.height+b.height),I=Cartesian3.fromRadians(D.longitude,D.latitude,M,e,subdivisionMidScratch),s.push(I.x,I.y,I.z),n=s.length/3-1,d[w]=n),a.push(v,n,_),a.push(n,y,_)):A===O?(defined(n=d[w=Math.min(y,_)+" "+Math.max(y,_)])||(D=f.interpolateUsingFraction(.5,subdivisionCartographicScratch),M=.5*(b.height+E.height),I=Cartesian3.fromRadians(D.longitude,D.latitude,M,e,subdivisionMidScratch),s.push(I.x,I.y,I.z),n=s.length/3-1,d[w]=n),a.push(y,n,v),a.push(n,_,v)):R===O&&(defined(n=d[w=Math.min(_,v)+" "+Math.max(_,v)])||(D=g.interpolateUsingFraction(.5,subdivisionCartographicScratch),M=.5*(E.height+x.height),I=Cartesian3.fromRadians(D.longitude,D.latitude,M,e,subdivisionMidScratch),s.push(I.x,I.y,I.z),n=s.length/3-1,d[w]=n),a.push(_,n,y),a.push(n,v,y)):(u.push(v),u.push(y),u.push(_))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},indices:u,primitiveType:PrimitiveType$1.TRIANGLES})},PolygonPipeline.scaleToGeodeticHeight=function(e,t,i,r){i=defaultValue(i,Ellipsoid.WGS84);var n=scaleToGeodeticHeightN,a=scaleToGeodeticHeightP;if(t=defaultValue(t,0),r=defaultValue(r,!0),defined(e))for(var o=e.length,s=0;s<o;s+=3)Cartesian3.fromArray(e,s,a),r&&(a=i.scaleToGeodeticSurface(a,a)),0!==t&&(n=i.geodeticSurfaceNormal(a,n),Cartesian3.multiplyByScalar(n,t,n),Cartesian3.add(a,n,a)),e[s]=a.x,e[s+1]=a.y,e[s+2]=a.z;return e},defineProperties$1(Queue.prototype,{length:{get:function(){return this._length}}}),Queue.prototype.enqueue=function(e){this._array.push(e),this._length++},Queue.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,i=e[t];return e[t]=void 0,10<++t&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,i}},Queue.prototype.peek=function(){if(0!==this._length)return this._array[this._offset]},Queue.prototype.contains=function(e){return-1!==this._array.indexOf(e)},Queue.prototype.clear=function(){this._array.length=this._offset=this._length=0},Queue.prototype.sort=function(e){0<this._offset&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)};var PolygonGeometryLibrary={computeHierarchyPackedLength:function(e){for(var t=0,i=[e];0<i.length;){var r=i.pop();if(defined(r)){t+=2;var n=r.positions,a=r.holes;if(defined(n)&&(t+=n.length*Cartesian3.packedLength),defined(a))for(var o=a.length,s=0;s<o;++s)i.push(a[s])}}return t},packPolygonHierarchy:function(e,t,i){for(var r=[e];0<r.length;){var n=r.pop();if(defined(n)){var a=n.positions,o=n.holes;if(t[i++]=defined(a)?a.length:0,t[i++]=defined(o)?o.length:0,defined(a))for(var s=a.length,l=0;l<s;++l,i+=3)Cartesian3.pack(a[l],t,i);if(defined(o))for(var c=o.length,u=0;u<c;++u)r.push(o[u])}}return i},unpackPolygonHierarchy:function(e,t){for(var i=e[t++],r=e[t++],n=new Array(i),a=0<r?new Array(r):void 0,o=0;o<i;++o,t+=Cartesian3.packedLength)n[o]=Cartesian3.unpack(e,t);for(var s=0;s<r;++s)a[s]=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t),t=a[s].startingIndex,delete a[s].startingIndex;return{positions:n,holes:a,startingIndex:t}}},distanceScratch$3=new Cartesian3;function getPointAtDistance(e,t,i,r){return Cartesian3.subtract(t,e,distanceScratch$3),Cartesian3.multiplyByScalar(distanceScratch$3,i/r,distanceScratch$3),Cartesian3.add(e,distanceScratch$3,distanceScratch$3),[distanceScratch$3.x,distanceScratch$3.y,distanceScratch$3.z]}PolygonGeometryLibrary.subdivideLineCount=function(e,t,i){var r=Cartesian3.distance(e,t)/i,n=Math.max(0,Math.ceil(CesiumMath.log2(r)));return Math.pow(2,n)};var scratchCartographic0=new Cartographic,scratchCartographic1=new Cartographic,scratchCartographic2=new Cartographic,scratchCartesian0=new Cartesian3;PolygonGeometryLibrary.subdivideRhumbLineCount=function(e,t,i,r){var n=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0),e.cartesianToCartographic(i,scratchCartographic1),e).surfaceDistance/r,a=Math.max(0,Math.ceil(CesiumMath.log2(n)));return Math.pow(2,a)},PolygonGeometryLibrary.subdivideLine=function(e,t,i,r){var n=PolygonGeometryLibrary.subdivideLineCount(e,t,i),a=Cartesian3.distance(e,t),o=a/n;defined(r)||(r=[]);var s=r;s.length=3*n;for(var l=0,c=0;c<n;c++){var u=getPointAtDistance(e,t,c*o,a);s[l++]=u[0],s[l++]=u[1],s[l++]=u[2]}return s},PolygonGeometryLibrary.subdivideRhumbLine=function(e,t,i,r,n){var a=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0),e.cartesianToCartographic(i,scratchCartographic1),e),o=a.surfaceDistance/r,s=Math.max(0,Math.ceil(CesiumMath.log2(o))),l=Math.pow(2,s),c=a.surfaceDistance/l;defined(n)||(n=[]);var u=n;u.length=3*l;for(var d=0,h=0;h<l;h++){var p=a.interpolateUsingSurfaceDistance(h*c,scratchCartographic2),m=e.cartographicToCartesian(p,scratchCartesian0);u[d++]=m.x,u[d++]=m.y,u[d++]=m.z}return u};var scaleToGeodeticHeightN1=new Cartesian3,scaleToGeodeticHeightN2=new Cartesian3,scaleToGeodeticHeightP1=new Cartesian3,scaleToGeodeticHeightP2=new Cartesian3;PolygonGeometryLibrary.scaleToGeodeticHeightExtruded=function(e,t,i,r,n){r=defaultValue(r,Ellipsoid.WGS84);var a=scaleToGeodeticHeightN1,o=scaleToGeodeticHeightN2,s=scaleToGeodeticHeightP1,l=scaleToGeodeticHeightP2;if(defined(e)&&defined(e.attributes)&&defined(e.attributes.position))for(var c=e.attributes.position.values,u=c.length/2,d=0;d<u;d+=3)Cartesian3.fromArray(c,d,s),r.geodeticSurfaceNormal(s,a),l=r.scaleToGeodeticSurface(s,l),o=Cartesian3.multiplyByScalar(a,i,o),o=Cartesian3.add(l,o,o),c[d+u]=o.x,c[d+1+u]=o.y,c[d+2+u]=o.z,n&&(l=Cartesian3.clone(s,l)),o=Cartesian3.multiplyByScalar(a,t,o),o=Cartesian3.add(l,o,o),c[d]=o.x,c[d+1]=o.y,c[d+2]=o.z;return e},PolygonGeometryLibrary.polygonOutlinesFromHierarchy=function(e,t,i){var r,n,a,o=[],s=new Queue;for(s.enqueue(e);0!==s.length;){var l=s.dequeue(),c=l.positions;if(t)for(a=c.length,r=0;r<a;r++)i.scaleToGeodeticSurface(c[r],c[r]);if(!((c=arrayRemoveDuplicates(c,Cartesian3.equalsEpsilon,!0)).length<3)){var u=l.holes?l.holes.length:0;for(r=0;r<u;r++){var d=l.holes[r],h=d.positions;if(t)for(a=h.length,n=0;n<a;++n)i.scaleToGeodeticSurface(h[n],h[n]);if(!((h=arrayRemoveDuplicates(h,Cartesian3.equalsEpsilon,!0)).length<3)){o.push(h);var p=0;for(defined(d.holes)&&(p=d.holes.length),n=0;n<p;n++)s.enqueue(d.holes[n])}}o.push(c)}}return o},PolygonGeometryLibrary.polygonsFromHierarchy=function(e,t,i,r){var n=[],a=[],o=new Queue;for(o.enqueue(e);0!==o.length;){var s,l,c=o.dequeue(),u=c.positions,d=c.holes;if(i)for(l=u.length,s=0;s<l;s++)r.scaleToGeodeticSurface(u[s],u[s]);if(!((u=arrayRemoveDuplicates(u,Cartesian3.equalsEpsilon,!0)).length<3)){var h=t(u);if(defined(h)){var p=[],m=PolygonPipeline.computeWindingOrder2D(h);m===WindingOrder$1.CLOCKWISE&&(h.reverse(),u=u.slice().reverse());var f,g=u.slice(),_=defined(d)?d.length:0,y=[];for(s=0;s<_;s++){var v=d[s],C=v.positions;if(i)for(l=C.length,f=0;f<l;++f)r.scaleToGeodeticSurface(C[f],C[f]);if(!((C=arrayRemoveDuplicates(C,Cartesian3.equalsEpsilon,!0)).length<3)){var S=t(C);if(defined(S)){(m=PolygonPipeline.computeWindingOrder2D(S))===WindingOrder$1.CLOCKWISE&&(S.reverse(),C=C.slice().reverse()),y.push(C),p.push(g.length),g=g.concat(C),h=h.concat(S);var T=0;for(defined(v.holes)&&(T=v.holes.length),f=0;f<T;f++)o.enqueue(v.holes[f])}}}n.push({outerRing:u,holes:y}),a.push({positions:g,positions2D:h,holes:p})}}}return{hierarchy:n,polygons:a}};var computeBoundingRectangleCartesian2=new Cartesian2,computeBoundingRectangleCartesian3=new Cartesian3,computeBoundingRectangleQuaternion=new Quaternion,computeBoundingRectangleMatrix3=new Matrix3;PolygonGeometryLibrary.computeBoundingRectangle=function(e,t,i,r,n){for(var a=Quaternion.fromAxisAngle(e,r,computeBoundingRectangleQuaternion),o=Matrix3.fromQuaternion(a,computeBoundingRectangleMatrix3),s=Number.POSITIVE_INFINITY,l=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,d=i.length,h=0;h<d;++h){var p=Cartesian3.clone(i[h],computeBoundingRectangleCartesian3);Matrix3.multiplyByVector(o,p,p);var m=t(p,computeBoundingRectangleCartesian2);defined(m)&&(s=Math.min(s,m.x),l=Math.max(l,m.x),c=Math.min(c,m.y),u=Math.max(u,m.y))}return n.x=s,n.y=c,n.width=l-s,n.height=u-c,n},PolygonGeometryLibrary.createGeometryFromPositions=function(e,t,i,r,n,a){var o=PolygonPipeline.triangulate(t.positions2D,t.holes);o.length<3&&(o=[0,1,2]);var s=t.positions;if(r){for(var l=s.length,c=new Array(3*l),u=0,d=0;d<l;d++){var h=s[d];c[u++]=h.x,c[u++]=h.y,c[u++]=h.z}var p=new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c})},indices:o,primitiveType:PrimitiveType$1.TRIANGLES});return n.normal?GeometryPipeline.computeNormal(p):p}return a===ArcType$1.GEODESIC?PolygonPipeline.computeSubdivision(e,s,o,i):a===ArcType$1.RHUMB?PolygonPipeline.computeRhumbLineSubdivision(e,s,o,i):void 0};var computeWallIndicesSubdivided=[],p1Scratch$1=new Cartesian3,p2Scratch$1=new Cartesian3;PolygonGeometryLibrary.computeWallGeometry=function(e,t,i,r,n){var a,o,s,l,c,u=e.length,d=0;if(r)for(o=3*u*2,a=new Array(2*o),s=0;s<u;s++)l=e[s],c=e[(s+1)%u],a[d]=a[d+o]=l.x,a[++d]=a[d+o]=l.y,a[++d]=a[d+o]=l.z,a[++d]=a[d+o]=c.x,a[++d]=a[d+o]=c.y,a[++d]=a[d+o]=c.z,++d;else{var h=CesiumMath.chordLength(i,t.maximumRadius),p=0;if(n===ArcType$1.GEODESIC)for(s=0;s<u;s++)p+=PolygonGeometryLibrary.subdivideLineCount(e[s],e[(s+1)%u],h);else if(n===ArcType$1.RHUMB)for(s=0;s<u;s++)p+=PolygonGeometryLibrary.subdivideRhumbLineCount(t,e[s],e[(s+1)%u],h);for(o=3*(p+u),a=new Array(2*o),s=0;s<u;s++){var m;l=e[s],c=e[(s+1)%u],n===ArcType$1.GEODESIC?m=PolygonGeometryLibrary.subdivideLine(l,c,h,computeWallIndicesSubdivided):n===ArcType$1.RHUMB&&(m=PolygonGeometryLibrary.subdivideRhumbLine(t,l,c,h,computeWallIndicesSubdivided));for(var f=m.length,g=0;g<f;++g,++d)a[d]=m[g],a[d+o]=m[g];a[d]=c.x,a[d+o]=c.x,a[++d]=c.y,a[d+o]=c.y,a[++d]=c.z,a[d+o]=c.z,++d}}u=a.length;var _=IndexDatatype$1.createTypedArray(u/3,u-6*e.length),y=0;for(u/=6,s=0;s<u;s++){var v=s,C=v+1,S=v+u,T=S+1;l=Cartesian3.fromArray(a,3*v,p1Scratch$1),c=Cartesian3.fromArray(a,3*C,p2Scratch$1),Cartesian3.equalsEpsilon(l,c,CesiumMath.EPSILON10,CesiumMath.EPSILON10)||(_[y++]=v,_[y++]=S,_[y++]=C,_[y++]=C,_[y++]=S,_[y++]=T)}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:_,primitiveType:PrimitiveType$1.TRIANGLES})};var scratchPosition$1=new Cartesian3,scratchBR=new BoundingRectangle,stScratch=new Cartesian2,textureCoordinatesOrigin=new Cartesian2,scratchNormal$3=new Cartesian3,scratchTangent$1=new Cartesian3,scratchBitangent$1=new Cartesian3,centerScratch=new Cartesian3,axis1Scratch=new Cartesian3,axis2Scratch=new Cartesian3,quaternionScratch$1=new Quaternion,textureMatrixScratch$1=new Matrix3,tangentRotationScratch=new Matrix3,surfaceNormalScratch=new Cartesian3;function createGeometryFromPolygon(e,t,i,r,n,a,o,s){var l=e.positions,c=PolygonPipeline.triangulate(e.positions2D,e.holes);c.length<3&&(c=[0,1,2]);var u=IndexDatatype$1.createTypedArray(l.length,c.length);u.set(c);var d=textureMatrixScratch$1;if(0!==r){var h=Quaternion.fromAxisAngle(a,r,quaternionScratch$1);if(d=Matrix3.fromQuaternion(h,d),t.tangent||t.bitangent){h=Quaternion.fromAxisAngle(a,-r,quaternionScratch$1);var p=Matrix3.fromQuaternion(h,tangentRotationScratch);o=Cartesian3.normalize(Matrix3.multiplyByVector(p,o,o),o),t.bitangent&&(s=Cartesian3.normalize(Cartesian3.cross(a,o,s),s))}}else d=Matrix3.clone(Matrix3.IDENTITY,d);var m=textureCoordinatesOrigin;t.st&&(m.x=i.x,m.y=i.y);for(var f=l.length,g=3*f,_=new Float64Array(g),y=t.normal?new Float32Array(g):void 0,v=t.tangent?new Float32Array(g):void 0,C=t.bitangent?new Float32Array(g):void 0,S=t.st?new Float32Array(2*f):void 0,T=0,x=0,b=0,E=0,P=0,A=0;A<f;A++){var w=l[A];if(_[T++]=w.x,_[T++]=w.y,_[T++]=w.z,t.st){var D=n(Matrix3.multiplyByVector(d,w,scratchPosition$1),stScratch);Cartesian2.subtract(D,m,D);var M=CesiumMath.clamp(D.x/i.width,0,1),I=CesiumMath.clamp(D.y/i.height,0,1);S[P++]=M,S[P++]=I}t.normal&&(y[x++]=a.x,y[x++]=a.y,y[x++]=a.z),t.tangent&&(v[E++]=o.x,v[E++]=o.y,v[E++]=o.z),t.bitangent&&(C[b++]=s.x,C[b++]=s.y,C[b++]=s.z)}var R=new GeometryAttributes;return t.position&&(R.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:_})),t.normal&&(R.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})),t.tangent&&(R.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:v})),t.bitangent&&(R.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C})),t.st&&(R.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:S})),new Geometry({attributes:R,indices:u,primitiveType:PrimitiveType$1.TRIANGLES})}function CoplanarPolygonGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy,i=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=VertexFormat.clone(i),this._polygonHierarchy=t,this._stRotation=defaultValue(e.stRotation,0),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createCoplanarPolygonGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+VertexFormat.packedLength+Ellipsoid.packedLength+2}CoplanarPolygonGeometry.fromPositions=function(e){return new CoplanarPolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid})},CoplanarPolygonGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._stRotation,t[i]=e.packedLength,t};var scratchEllipsoid$2=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$2=new VertexFormat,scratchOptions$6={polygonHierarchy:{}};function createGeometryFromPositions(e){for(var t=e.length,i=new Float64Array(3*t),r=IndexDatatype$1.createTypedArray(t,2*t),n=0,a=0,o=0;o<t;o++){var s=e[o];i[n++]=s.x,i[n++]=s.y,i[n++]=s.z,r[a++]=o,r[a++]=(o+1)%t}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i})}),indices:r,primitiveType:PrimitiveType$1.LINES})}function CoplanarPolygonOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy;this._polygonHierarchy=t,this._workerName="createCoplanarPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+1}CoplanarPolygonGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$2);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$2);t+=VertexFormat.packedLength;var o=e[t++],s=e[t];return defined(i)||(i=new CoplanarPolygonGeometry(scratchOptions$6)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._stRotation=o,i.packedLength=s,i},CoplanarPolygonGeometry.createGeometry=function(e){var t=e._vertexFormat,i=e._polygonHierarchy,r=e._stRotation,n=i.positions;if(!((n=arrayRemoveDuplicates(n,Cartesian3.equalsEpsilon,!0)).length<3)){var a=scratchNormal$3,o=scratchTangent$1,s=scratchBitangent$1,l=axis1Scratch,c=axis2Scratch;if(CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments(n,centerScratch,l,c)){if(a=Cartesian3.cross(l,c,a),a=Cartesian3.normalize(a,a),!Cartesian3.equalsEpsilon(centerScratch,Cartesian3.ZERO,CesiumMath.EPSILON6)){var u=e._ellipsoid.geodeticSurfaceNormal(centerScratch,surfaceNormalScratch);Cartesian3.dot(a,u)<0&&(a=Cartesian3.negate(a,a),l=Cartesian3.negate(l,l))}var d=CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction(centerScratch,l,c),h=CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction(centerScratch,l,c);t.tangent&&(o=Cartesian3.clone(l,o)),t.bitangent&&(s=Cartesian3.clone(c,s));var p=PolygonGeometryLibrary.polygonsFromHierarchy(i,d,!1),m=p.hierarchy,f=p.polygons;if(0!==m.length){n=m[0].outerRing;for(var g=BoundingSphere.fromPoints(n),_=PolygonGeometryLibrary.computeBoundingRectangle(a,h,n,r,scratchBR),y=[],v=0;v<f.length;v++){var C=new GeometryInstance({geometry:createGeometryFromPolygon(f[v],t,_,r,h,a,o,s)});y.push(C)}var S=GeometryPipeline.combineInstances(y)[0];S.attributes.position.values=new Float64Array(S.attributes.position.values),S.indices=IndexDatatype$1.createTypedArray(S.attributes.position.values.length/3,S.indices);var T=S.attributes;return t.position||delete T.position,new Geometry({attributes:T,indices:S.indices,primitiveType:S.primitiveType,boundingSphere:g})}}}},CoplanarPolygonOutlineGeometry.fromPositions=function(e){return new CoplanarPolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions}})},CoplanarPolygonOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),t[i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i)]=e.packedLength,t};var scratchOptions$7={polygonHierarchy:{}};CoplanarPolygonOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=e[t];return defined(i)||(i=new CoplanarPolygonOutlineGeometry(scratchOptions$7)),i._polygonHierarchy=r,i.packedLength=n,i},CoplanarPolygonOutlineGeometry.createGeometry=function(e){var t=e._polygonHierarchy,i=t.positions;if(!((i=arrayRemoveDuplicates(i,Cartesian3.equalsEpsilon,!0)).length<3)&&CoplanarPolygonGeometryLibrary.validOutline(i)){var r=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(t,!1);if(0!==r.length){for(var n=[],a=0;a<r.length;a++){var o=new GeometryInstance({geometry:createGeometryFromPositions(r[a])});n.push(o)}var s=GeometryPipeline.combineInstances(n)[0],l=BoundingSphere.fromPoints(t.positions);return new Geometry({attributes:s.attributes,indices:s.indices,primitiveType:s.primitiveType,boundingSphere:l})}}};var CornerType={ROUNDED:0,MITERED:1,BEVELED:2},CornerType$1=freezeObject$1(CornerType);function setConstants(e){var t=e._uSquared,i=e._ellipsoid.maximumRadius,r=e._ellipsoid.minimumRadius,n=(i-r)/i,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),s=(1-n)*Math.tan(e._start.latitude),l=1/Math.sqrt(1+s*s),c=l*s,u=Math.atan2(s,a),d=l*o,h=d*d,p=1-h,m=Math.sqrt(p),f=t/4,g=f*f,_=g*f,y=g*g,v=1+f-3*g/4+5*_/4-175*y/64,C=1-f+15*g/8-35*_/8,S=1-3*f+35*g/4,T=1-5*f,x=v*u-C*Math.sin(2*u)*f/2-S*Math.sin(4*u)*g/16-T*Math.sin(6*u)*_/48-5*Math.sin(8*u)*y/512,b=e._constants;b.a=i,b.b=r,b.f=n,b.cosineHeading=a,b.sineHeading=o,b.tanU=s,b.cosineU=l,b.sineU=c,b.sigma=u,b.sineAlpha=d,b.sineSquaredAlpha=h,b.cosineSquaredAlpha=p,b.cosineAlpha=m,b.u2Over4=f,b.u4Over16=g,b.u6Over64=_,b.u8Over256=y,b.a0=v,b.a1=C,b.a2=S,b.a3=T,b.distanceRatio=x}function computeC(e,t){return e*t*(4+e*(4-3*t))/16}function computeDeltaLambda(e,t,i,r,n,a,o){var s=computeC(e,i);return(1-s)*e*t*(r+s*n*(o+s*a*(2*o*o-1)))}function vincentyInverseFormula(e,t,i,r,n,a,o){var s,l,c,u,d,h=(t-i)/t,p=a-r,m=Math.atan((1-h)*Math.tan(n)),f=Math.atan((1-h)*Math.tan(o)),g=Math.cos(m),_=Math.sin(m),y=Math.cos(f),v=Math.sin(f),C=g*y,S=g*v,T=_*v,x=_*y,b=p,E=CesiumMath.TWO_PI,P=Math.cos(b),A=Math.sin(b);do{P=Math.cos(b),A=Math.sin(b);var w,D=S-x*P;c=Math.sqrt(y*y*A*A+D*D),l=T+C*P,s=Math.atan2(c,l),E=b,d=l-2*T/(u=0===c?(w=0,1):1-(w=C*A/c)*w),isNaN(d)&&(d=0),b=p+computeDeltaLambda(h,w,u,s,c,l,d)}while(Math.abs(b-E)>CesiumMath.EPSILON12);var M=u*(t*t-i*i)/(i*i),I=M*(256+M*(M*(74-47*M)-128))/1024,R=d*d,O=i*(1+M*(4096+M*(M*(320-175*M)-768))/16384)*(s-I*c*(d+I*(l*(2*R-1)-I*d*(4*c*c-3)*(4*R-3)/6)/4)),L=Math.atan2(y*A,S-x*P),F=Math.atan2(g*A,S*P-x);e._distance=O,e._startHeading=L,e._endHeading=F,e._uSquared=M}var scratchCart1$1=new Cartesian3,scratchCart2$1=new Cartesian3;function computeProperties$1(e,t,i,r){Cartesian3.normalize(r.cartographicToCartesian(t,scratchCart2$1),scratchCart1$1),Cartesian3.normalize(r.cartographicToCartesian(i,scratchCart2$1),scratchCart2$1);vincentyInverseFormula(e,r.maximumRadius,r.minimumRadius,t.longitude,t.latitude,i.longitude,i.latitude),e._start=Cartographic.clone(t,e._start),e._end=Cartographic.clone(i,e._end),e._start.height=0,e._end.height=0,setConstants(e)}function EllipsoidGeodesic(e,t,i){var r=defaultValue(i,Ellipsoid.WGS84);this._ellipsoid=r,this._start=new Cartographic,this._end=new Cartographic,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,defined(e)&&defined(t)&&computeProperties$1(this,e,t,r)}defineProperties$1(EllipsoidGeodesic.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),EllipsoidGeodesic.prototype.setEndPoints=function(e,t){computeProperties$1(this,e,t,this._ellipsoid)},EllipsoidGeodesic.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},EllipsoidGeodesic.prototype.interpolateUsingSurfaceDistance=function(e,t){var i=this._constants,r=i.distanceRatio+e/i.b,n=Math.cos(2*r),a=Math.cos(4*r),o=Math.cos(6*r),s=Math.sin(2*r),l=Math.sin(4*r),c=Math.sin(6*r),u=Math.sin(8*r),d=r*r,h=r*d,p=i.u8Over256,m=i.u2Over4,f=i.u6Over64,g=i.u4Over16,_=2*h*p*n/3+r*(1-m+7*g/4-15*f/4+579*p/64-(g-15*f/4+187*p/16)*n-(5*f/4-115*p/16)*a-29*p*o/16)+(m/2-g+71*f/32-85*p/16)*s+(5*g/16-5*f/4+383*p/96)*l-d*((f-11*p/2)*s+5*p*l/2)+(29*f/96-29*p/16)*c+539*p*u/1536,y=Math.asin(Math.sin(_)*i.cosineAlpha),v=Math.atan(i.a/i.b*Math.tan(y));_-=i.sigma;var C=Math.cos(2*i.sigma+_),S=Math.sin(_),T=Math.cos(_),x=i.cosineU*T,b=i.sineU*S,E=Math.atan2(S*i.sineHeading,x-b*i.cosineHeading)-computeDeltaLambda(i.f,i.sineAlpha,i.cosineSquaredAlpha,_,S,T,C);return defined(t)?(t.longitude=this._start.longitude+E,t.latitude=v,t.height=0,t):new Cartographic(this._start.longitude+E,v,0)};var PolylinePipeline={numberOfPoints:function(e,t,i){var r=Cartesian3.distance(e,t);return Math.ceil(r/i)},numberOfPointsRhumbLine:function(e,t,i){var r=Math.pow(e.longitude-t.longitude,2)+Math.pow(e.latitude-t.latitude,2);return Math.ceil(Math.sqrt(r/(i*i)))}},cartoScratch=new Cartographic;PolylinePipeline.extractHeights=function(e,t){for(var i=e.length,r=new Array(i),n=0;n<i;n++){var a=e[n];r[n]=t.cartesianToCartographic(a,cartoScratch).height}return r};var wrapLongitudeInversMatrix=new Matrix4,wrapLongitudeOrigin=new Cartesian3,wrapLongitudeXZNormal=new Cartesian3,wrapLongitudeXZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeYZNormal=new Cartesian3,wrapLongitudeYZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeIntersection=new Cartesian3,wrapLongitudeOffset=new Cartesian3,subdivideHeightsScratchArray=[];function subdivideHeights(e,t,i){var r,n=subdivideHeightsScratchArray;if(n.length=e,t===i){for(r=0;r<e;r++)n[r]=t;return n}var a=(i-t)/e;for(r=0;r<e;r++){var o=t+r*a;n[r]=o}return n}var carto1=new Cartographic,carto2=new Cartographic,cartesian=new Cartesian3,scaleFirst=new Cartesian3,scaleLast=new Cartesian3,ellipsoidGeodesic=new EllipsoidGeodesic,ellipsoidRhumb=new EllipsoidRhumbLine;function generateCartesianArc(e,t,i,r,n,a,o,s){var l=r.scaleToGeodeticSurface(e,scaleFirst),c=r.scaleToGeodeticSurface(t,scaleLast),u=PolylinePipeline.numberOfPoints(e,t,i),d=r.cartesianToCartographic(l,carto1),h=r.cartesianToCartographic(c,carto2),p=subdivideHeights(u,n,a);ellipsoidGeodesic.setEndPoints(d,h);var m=ellipsoidGeodesic.surfaceDistance/u,f=s;d.height=n;var g=r.cartographicToCartesian(d,cartesian);Cartesian3.pack(g,o,f),f+=3;for(var _=1;_<u;_++){var y=ellipsoidGeodesic.interpolateUsingSurfaceDistance(_*m,carto2);y.height=p[_],g=r.cartographicToCartesian(y,cartesian),Cartesian3.pack(g,o,f),f+=3}return f}function generateCartesianRhumbArc(e,t,i,r,n,a,o,s){var l=r.scaleToGeodeticSurface(e,scaleFirst),c=r.scaleToGeodeticSurface(t,scaleLast),u=r.cartesianToCartographic(l,carto1),d=r.cartesianToCartographic(c,carto2),h=PolylinePipeline.numberOfPointsRhumbLine(u,d,i),p=subdivideHeights(h,n,a);ellipsoidRhumb.ellipsoid.equals(r)||(ellipsoidRhumb=new EllipsoidRhumbLine(void 0,void 0,r)),ellipsoidRhumb.setEndPoints(u,d);var m=ellipsoidRhumb.surfaceDistance/h,f=s;u.height=n;var g=r.cartographicToCartesian(u,cartesian);Cartesian3.pack(g,o,f),f+=3;for(var _=1;_<h;_++){var y=ellipsoidRhumb.interpolateUsingSurfaceDistance(_*m,carto2);y.height=p[_],g=r.cartographicToCartesian(y,cartesian),Cartesian3.pack(g,o,f),f+=3}return f}PolylinePipeline.wrapLongitude=function(e,t){var i=[],r=[];if(defined(e)&&0<e.length){t=defaultValue(t,Matrix4.IDENTITY);var n=Matrix4.inverseTransformation(t,wrapLongitudeInversMatrix),a=Matrix4.multiplyByPoint(n,Cartesian3.ZERO,wrapLongitudeOrigin),o=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(n,Cartesian3.UNIT_Y,wrapLongitudeXZNormal),wrapLongitudeXZNormal),s=Plane.fromPointNormal(a,o,wrapLongitudeXZPlane),l=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(n,Cartesian3.UNIT_X,wrapLongitudeYZNormal),wrapLongitudeYZNormal),c=Plane.fromPointNormal(a,l,wrapLongitudeYZPlane),u=1;i.push(Cartesian3.clone(e[0]));for(var d=i[0],h=e.length,p=1;p<h;++p){var m=e[p];if(Plane.getPointDistance(c,d)<0||Plane.getPointDistance(c,m)<0){var f=IntersectionTests.lineSegmentPlane(d,m,s,wrapLongitudeIntersection);if(defined(f)){var g=Cartesian3.multiplyByScalar(o,5e-9,wrapLongitudeOffset);Plane.getPointDistance(s,d)<0&&Cartesian3.negate(g,g),i.push(Cartesian3.add(f,g,new Cartesian3)),r.push(u+1),Cartesian3.negate(g,g),i.push(Cartesian3.add(f,g,new Cartesian3)),u=1}}i.push(Cartesian3.clone(e[p])),u++,d=m}r.push(u)}return{positions:i,lengths:r}},PolylinePipeline.generateArc=function(e){defined(e)||(e={});var t=e.positions,i=t.length,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.height,0),a=isArray$1(n);if(i<1)return[];if(1===i){var o=r.scaleToGeodeticSurface(t[0],scaleFirst);if(0!==(n=a?n[0]:n)){var s=r.geodeticSurfaceNormal(o,cartesian);Cartesian3.multiplyByScalar(s,n,s),Cartesian3.add(o,s,o)}return[o.x,o.y,o.z]}var l=e.minDistance;if(!defined(l)){var c=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);l=CesiumMath.chordLength(c,r.maximumRadius)}var u,d=0;for(u=0;u<i-1;u++)d+=PolylinePipeline.numberOfPoints(t[u],t[u+1],l);var h=3*(d+1),p=new Array(h),m=0;for(u=0;u<i-1;u++){m=generateCartesianArc(t[u],t[u+1],l,r,a?n[u]:n,a?n[u+1]:n,p,m)}subdivideHeightsScratchArray.length=0;var f=t[i-1],g=r.cartesianToCartographic(f,carto1);g.height=a?n[i-1]:n;var _=r.cartographicToCartesian(g,cartesian);return Cartesian3.pack(_,p,h-3),p};var scratchCartographic0$1=new Cartographic,scratchCartographic1$1=new Cartographic;PolylinePipeline.generateRhumbArc=function(e){defined(e)||(e={});var t=e.positions,i=t.length,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.height,0),a=isArray$1(n);if(i<1)return[];if(1===i){var o=r.scaleToGeodeticSurface(t[0],scaleFirst);if(0!==(n=a?n[0]:n)){var s=r.geodeticSurfaceNormal(o,cartesian);Cartesian3.multiplyByScalar(s,n,s),Cartesian3.add(o,s,o)}return[o.x,o.y,o.z]}var l,c,u=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),d=0,h=r.cartesianToCartographic(t[0],scratchCartographic0$1);for(l=0;l<i-1;l++)c=r.cartesianToCartographic(t[l+1],scratchCartographic1$1),d+=PolylinePipeline.numberOfPointsRhumbLine(h,c,u),h=Cartographic.clone(c,scratchCartographic0$1);var p=3*(d+1),m=new Array(p),f=0;for(l=0;l<i-1;l++){f=generateCartesianRhumbArc(t[l],t[l+1],u,r,a?n[l]:n,a?n[l+1]:n,m,f)}subdivideHeightsScratchArray.length=0;var g=t[i-1],_=r.cartesianToCartographic(g,carto1);_.height=a?n[i-1]:n;var y=r.cartographicToCartesian(_,cartesian);return Cartesian3.pack(y,m,p-3),m},PolylinePipeline.generateCartesianArc=function(e){for(var t=PolylinePipeline.generateArc(e),i=t.length/3,r=new Array(i),n=0;n<i;n++)r[n]=Cartesian3.unpack(t,3*n);return r},PolylinePipeline.generateCartesianRhumbArc=function(e){for(var t=PolylinePipeline.generateRhumbArc(e),i=t.length/3,r=new Array(i),n=0;n<i;n++)r[n]=Cartesian3.unpack(t,3*n);return r};var scratch2Array=[new Cartesian3,new Cartesian3],scratchCartesian1$5=new Cartesian3,scratchCartesian2$5=new Cartesian3,scratchCartesian3$6=new Cartesian3,scratchCartesian4$2=new Cartesian3,scratchCartesian5$1=new Cartesian3,scratchCartesian6$1=new Cartesian3,scratchCartesian7=new Cartesian3,scratchCartesian8=new Cartesian3,scratchCartesian9=new Cartesian3,scratch1=new Cartesian3,scratch2=new Cartesian3,PolylineVolumeGeometryLibrary={},cartographic=new Cartographic;function scaleToSurface(e,t){for(var i=new Array(e.length),r=0;r<e.length;r++){var n=e[r];cartographic=t.cartesianToCartographic(n,cartographic),i[r]=cartographic.height,e[r]=t.scaleToGeodeticSurface(n,n)}return i}function subdivideHeights$1(e,t,i,r){var n,a=e[0],o=e[1],s=Cartesian3.angleBetween(a,o),l=Math.ceil(s/r),c=new Array(l);if(t===i){for(n=0;n<l;n++)c[n]=t;return c.push(i),c}var u=(i-t)/l;for(n=1;n<l;n++){var d=t+n*u;c[n]=d}return c[0]=t,c.push(i),c}var nextScratch=new Cartesian3,prevScratch=new Cartesian3;function computeRotationAngle(e,t,i,r){var n=new EllipsoidTangentPlane(i,r),a=n.projectPointOntoPlane(Cartesian3.add(i,e,nextScratch),nextScratch),o=n.projectPointOntoPlane(Cartesian3.add(i,t,prevScratch),prevScratch),s=Cartesian2.angleBetween(a,o);return 0<=o.x*a.y-o.y*a.x?-s:s}var negativeX=new Cartesian3(-1,0,0),transform=new Matrix4,translation=new Matrix4,rotationZ=new Matrix3,scaleMatrix=Matrix3.IDENTITY.clone(),westScratch$1=new Cartesian3,finalPosScratch=new Cartesian4,heightCartesian=new Cartesian3;function addPosition(e,t,i,r,n,a,o,s){var l=westScratch$1,c=finalPosScratch;transform=Transforms.eastNorthUpToFixedFrame(e,n,transform),l=Matrix4.multiplyByPointAsVector(transform,negativeX,l);var u=computeRotationAngle(l=Cartesian3.normalize(l,l),t,e,n);rotationZ=Matrix3.fromRotationZ(u,rotationZ),heightCartesian.z=a,transform=Matrix4.multiplyTransformation(transform,Matrix4.fromRotationTranslation(rotationZ,heightCartesian,translation),transform);var d=scaleMatrix;d[0]=o;for(var h=0;h<s;h++)for(var p=0;p<i.length;p+=3)c=Cartesian3.fromArray(i,p,c),c=Matrix3.multiplyByVector(d,c,c),c=Matrix4.multiplyByPoint(transform,c,c),r.push(c.x,c.y,c.z);return r}var centerScratch$1=new Cartesian3;function addPositions(e,t,i,r,n,a,o){for(var s=0;s<e.length;s+=3){r=addPosition(Cartesian3.fromArray(e,s,centerScratch$1),t,i,r,n,a[s/3],o,1)}return r}function convertShapeTo3DDuplicate(e,t){var i=e.length,r=new Array(6*i),n=0,a=t.x+t.width/2,o=t.y+t.height/2,s=e[0];r[n++]=s.x-a,r[n++]=0,r[n++]=s.y-o;for(var l=1;l<i;l++){var c=(s=e[l]).x-a,u=s.y-o;r[n++]=c,r[n++]=0,r[n++]=u,r[n++]=c,r[n++]=0,r[n++]=u}return s=e[0],r[n++]=s.x-a,r[n++]=0,r[n++]=s.y-o,r}function convertShapeTo3D(e,t){for(var i=e.length,r=new Array(3*i),n=0,a=t.x+t.width/2,o=t.y+t.height/2,s=0;s<i;s++)r[n++]=e[s].x-a,r[n++]=0,r[n++]=e[s].y-o;return r}var quaterion=new Quaternion,startPointScratch=new Cartesian3,rotMatrix=new Matrix3;function computeRoundCorner(e,t,i,r,n,a,o,s,l,c){var u,d,h=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1),Cartesian3.subtract(i,e,scratch2)),p=r===CornerType$1.BEVELED?0:Math.ceil(h/CesiumMath.toRadians(5));if(u=n?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1),h/(p+1),quaterion),rotMatrix):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,h/(p+1),quaterion),rotMatrix),t=Cartesian3.clone(t,startPointScratch),0<p)for(var m=c?2:1,f=0;f<p;f++)t=Matrix3.multiplyByVector(u,t,t),d=Cartesian3.subtract(t,e,scratch1),d=Cartesian3.normalize(d,d),n||(d=Cartesian3.negate(d,d)),o=addPosition(a.scaleToGeodeticSurface(t,scratch2),d,s,o,a,l,1,m);else d=Cartesian3.subtract(t,e,scratch1),d=Cartesian3.normalize(d,d),n||(d=Cartesian3.negate(d,d)),o=addPosition(a.scaleToGeodeticSurface(t,scratch2),d,s,o,a,l,1,1),i=Cartesian3.clone(i,startPointScratch),d=Cartesian3.subtract(i,e,scratch1),d=Cartesian3.normalize(d,d),n||(d=Cartesian3.negate(d,d)),o=addPosition(a.scaleToGeodeticSurface(i,scratch2),d,s,o,a,l,1,1);return o}PolylineVolumeGeometryLibrary.removeDuplicatesFromShape=function(e){for(var t=e.length,i=[],r=t-1,n=0;n<t;r=n++){var a=e[r],o=e[n];Cartesian2.equals(a,o)||i.push(o)}return i},PolylineVolumeGeometryLibrary.angleIsGreaterThanPi=function(e,t,i,r){var n=new EllipsoidTangentPlane(i,r),a=n.projectPointOntoPlane(Cartesian3.add(i,e,nextScratch),nextScratch),o=n.projectPointOntoPlane(Cartesian3.add(i,t,prevScratch),prevScratch);return 0<=o.x*a.y-o.y*a.x};var scratchForwardProjection=new Cartesian3,scratchBackwardProjection=new Cartesian3;PolylineVolumeGeometryLibrary.computePositions=function(e,t,i,r,n){var a=r._ellipsoid,o=scaleToSurface(e,a),s=r._granularity,l=r._cornerType,c=n?convertShapeTo3DDuplicate(t,i):convertShapeTo3D(t,i),u=n?convertShapeTo3D(t,i):void 0,d=i.height/2,h=i.width/2,p=e.length,m=[],f=n?[]:void 0,g=scratchCartesian1$5,_=scratchCartesian2$5,y=scratchCartesian3$6,v=scratchCartesian4$2,C=scratchCartesian5$1,S=scratchCartesian6$1,T=scratchCartesian7,x=scratchCartesian8,b=scratchCartesian9,E=e[0],P=e[1];v=a.geodeticSurfaceNormal(E,v),g=Cartesian3.subtract(P,E,g),g=Cartesian3.normalize(g,g),x=Cartesian3.cross(v,g,x),x=Cartesian3.normalize(x,x);var A,w=o[0],D=o[1];n&&(f=addPosition(E,x,u,f,a,w+d,1,1)),b=Cartesian3.clone(E,b),E=P,_=Cartesian3.negate(g,_);for(var M=1;M<p-1;M++){var I=n?2:1;P=e[M+1],g=Cartesian3.subtract(P,E,g),g=Cartesian3.normalize(g,g),y=Cartesian3.add(g,_,y),y=Cartesian3.normalize(y,y),v=a.geodeticSurfaceNormal(E,v);var R=Cartesian3.multiplyByScalar(v,Cartesian3.dot(g,v),scratchForwardProjection);Cartesian3.subtract(g,R,R),Cartesian3.normalize(R,R);var O=Cartesian3.multiplyByScalar(v,Cartesian3.dot(_,v),scratchBackwardProjection);if(Cartesian3.subtract(_,O,O),Cartesian3.normalize(O,O),!CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(R,O)),1,CesiumMath.EPSILON7)){y=Cartesian3.cross(y,v,y),y=Cartesian3.cross(v,y,y),y=Cartesian3.normalize(y,y);var L=1/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(y,_,scratch1))),F=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(g,_,E,a);b=(F?(C=Cartesian3.add(E,Cartesian3.multiplyByScalar(y,L*h,y),C),S=Cartesian3.add(C,Cartesian3.multiplyByScalar(x,h,S),S),scratch2Array[0]=Cartesian3.clone(b,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(S,scratch2Array[1]),A=subdivideHeights$1(scratch2Array,w+d,D+d,s),m=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),x,c,m,a,A,1),x=Cartesian3.cross(v,g,x),x=Cartesian3.normalize(x,x),T=Cartesian3.add(C,Cartesian3.multiplyByScalar(x,h,T),T),l===CornerType$1.ROUNDED||l===CornerType$1.BEVELED?computeRoundCorner(C,S,T,l,F,a,m,c,D+d,n):m=addPosition(E,y=Cartesian3.negate(y,y),c,m,a,D+d,L,I)):(C=Cartesian3.add(E,Cartesian3.multiplyByScalar(y,L*h,y),C),S=Cartesian3.add(C,Cartesian3.multiplyByScalar(x,-h,S),S),scratch2Array[0]=Cartesian3.clone(b,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(S,scratch2Array[1]),A=subdivideHeights$1(scratch2Array,w+d,D+d,s),m=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),x,c,m,a,A,1),x=Cartesian3.cross(v,g,x),x=Cartesian3.normalize(x,x),T=Cartesian3.add(C,Cartesian3.multiplyByScalar(x,-h,T),T),l===CornerType$1.ROUNDED||l===CornerType$1.BEVELED?computeRoundCorner(C,S,T,l,F,a,m,c,D+d,n):m=addPosition(E,y,c,m,a,D+d,L,I)),Cartesian3.clone(T,b)),_=Cartesian3.negate(g,_)}else m=addPosition(b,x,c,m,a,w+d,1,1),b=E;w=D,D=o[M+1],E=P}scratch2Array[0]=Cartesian3.clone(b,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(E,scratch2Array[1]),A=subdivideHeights$1(scratch2Array,w+d,D+d,s),m=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),x,c,m,a,A,1),n&&(f=addPosition(E,x,u,f,a,D+d,1,1)),p=m.length;var N=n?p+f.length:p,V=new Float64Array(N);return V.set(m),n&&V.set(f,p),V};var CorridorGeometryLibrary={},scratch1$1=new Cartesian3,scratch2$1=new Cartesian3,scratch3=new Cartesian3,scratch4=new Cartesian3,scaleArray2=[new Cartesian3,new Cartesian3],cartesian1=new Cartesian3,cartesian2=new Cartesian3,cartesian3=new Cartesian3,cartesian4=new Cartesian3,cartesian5=new Cartesian3,cartesian6=new Cartesian3,cartesian7=new Cartesian3,cartesian8=new Cartesian3,cartesian9=new Cartesian3,cartesian10=new Cartesian3,quaterion$1=new Quaternion,rotMatrix$1=new Matrix3;function computeRoundCorner$1(e,t,i,r,n){var a,o=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1$1),Cartesian3.subtract(i,e,scratch2$1)),s=r===CornerType$1.BEVELED?1:Math.ceil(o/CesiumMath.toRadians(5))+1,l=3*s,c=new Array(l);c[l-3]=i.x,c[l-2]=i.y,c[l-1]=i.z,a=n?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1$1),o/s,quaterion$1),rotMatrix$1):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,o/s,quaterion$1),rotMatrix$1);var u=0;t=Cartesian3.clone(t,scratch1$1);for(var d=0;d<s;d++)t=Matrix3.multiplyByVector(a,t,t),c[u++]=t.x,c[u++]=t.y,c[u++]=t.z;return c}function addEndCaps(e){var t=cartesian1,i=cartesian2,r=cartesian3,n=e[1];i=Cartesian3.fromArray(e[1],n.length-3,i),r=Cartesian3.fromArray(e[0],0,r);var a=computeRoundCorner$1(t=Cartesian3.midpoint(i,r,t),i,r,CornerType$1.ROUNDED,!1),o=e.length-1,s=e[o-1];return n=e[o],i=Cartesian3.fromArray(s,s.length-3,i),r=Cartesian3.fromArray(n,0,r),[a,computeRoundCorner$1(t=Cartesian3.midpoint(i,r,t),i,r,CornerType$1.ROUNDED,!1)]}function computeMiteredCorner(e,t,i,r){var n=scratch1$1;return[(n=(r||(t=Cartesian3.negate(t,t)),Cartesian3.add(e,t,n))).x,n.y,n.z,i.x,i.y,i.z]}function addShiftedPositions(e,t,i,r){for(var n=new Array(e.length),a=new Array(e.length),o=Cartesian3.multiplyByScalar(t,i,scratch1$1),s=Cartesian3.negate(o,scratch2$1),l=0,c=e.length-1,u=0;u<e.length;u+=3){var d=Cartesian3.fromArray(e,u,scratch3),h=Cartesian3.add(d,s,scratch4);n[l++]=h.x,n[l++]=h.y,n[l++]=h.z;var p=Cartesian3.add(d,o,scratch4);a[c--]=p.z,a[c--]=p.y,a[c--]=p.x}return r.push(n,a),r}CorridorGeometryLibrary.addAttribute=function(e,t,i,r){var n=t.x,a=t.y,o=t.z;defined(i)&&(e[i]=n,e[i+1]=a,e[i+2]=o),defined(r)&&(e[r]=o,e[r-1]=a,e[r-2]=n)};var scratchForwardProjection$1=new Cartesian3,scratchBackwardProjection$1=new Cartesian3;CorridorGeometryLibrary.computePositions=function(e){var t=e.granularity,i=e.positions,r=e.ellipsoid,n=e.width/2,a=e.cornerType,o=e.saveAttributes,s=cartesian1,l=cartesian2,c=cartesian3,u=cartesian4,d=cartesian5,h=cartesian6,p=cartesian7,m=cartesian8,f=cartesian9,g=cartesian10,_=[],y=o?[]:void 0,v=o?[]:void 0,C=i[0],S=i[1];l=Cartesian3.normalize(Cartesian3.subtract(S,C,l),l),s=r.geodeticSurfaceNormal(C,s),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),o&&(y.push(u.x,u.y,u.z),v.push(s.x,s.y,s.z)),p=Cartesian3.clone(C,p),C=S,c=Cartesian3.negate(l,c);var T,x,b=[],E=i.length;for(T=1;T<E-1;T++){s=r.geodeticSurfaceNormal(C,s),S=i[T+1],l=Cartesian3.normalize(Cartesian3.subtract(S,C,l),l),d=Cartesian3.normalize(Cartesian3.add(l,c,d),d);var P=Cartesian3.multiplyByScalar(s,Cartesian3.dot(l,s),scratchForwardProjection$1);Cartesian3.subtract(l,P,P),Cartesian3.normalize(P,P);var A=Cartesian3.multiplyByScalar(s,Cartesian3.dot(c,s),scratchBackwardProjection$1);if(Cartesian3.subtract(c,A,A),Cartesian3.normalize(A,A),!CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(P,A)),1,CesiumMath.EPSILON7)){d=Cartesian3.cross(d,s,d),d=Cartesian3.cross(s,d,d),d=Cartesian3.normalize(d,d);var w=n/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(d,c,scratch1$1))),D=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(l,c,C,r);d=Cartesian3.multiplyByScalar(d,w,d),D?(m=Cartesian3.add(C,d,m),g=Cartesian3.add(m,Cartesian3.multiplyByScalar(u,n,g),g),f=Cartesian3.add(m,Cartesian3.multiplyByScalar(u,2*n,f),f),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),v.push(s.x,s.y,s.z)),h=Cartesian3.clone(f,h),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),f=Cartesian3.add(m,Cartesian3.multiplyByScalar(u,2*n,f),f),p=Cartesian3.add(m,Cartesian3.multiplyByScalar(u,n,p),p),a===CornerType$1.ROUNDED||a===CornerType$1.BEVELED?b.push({leftPositions:computeRoundCorner$1(m,h,f,a,D)}):b.push({leftPositions:computeMiteredCorner(C,Cartesian3.negate(d,d),f,D)})):(f=Cartesian3.add(C,d,f),g=Cartesian3.add(f,Cartesian3.negate(Cartesian3.multiplyByScalar(u,n,g),g),g),m=Cartesian3.add(f,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*n,m),m),m),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),v.push(s.x,s.y,s.z)),h=Cartesian3.clone(m,h),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),m=Cartesian3.add(f,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*n,m),m),m),p=Cartesian3.add(f,Cartesian3.negate(Cartesian3.multiplyByScalar(u,n,p),p),p),a===CornerType$1.ROUNDED||a===CornerType$1.BEVELED?b.push({rightPositions:computeRoundCorner$1(f,h,m,a,D)}):b.push({rightPositions:computeMiteredCorner(C,d,m,D)})),c=Cartesian3.negate(l,c)}C=S}return s=r.geodeticSurfaceNormal(C,s),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(C,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),v.push(s.x,s.y,s.z)),a===CornerType$1.ROUNDED&&(x=addEndCaps(_)),{positions:_,corners:b,lefts:y,normals:v,endPositions:x}};var cartesian1$1=new Cartesian3,cartesian2$1=new Cartesian3,cartesian3$1=new Cartesian3,cartesian4$1=new Cartesian3,cartesian5$1=new Cartesian3,cartesian6$1=new Cartesian3,scratch1$2=new Cartesian3,scratch2$2=new Cartesian3;function scaleToSurface$1(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}function addNormals(e,t,i,r,n,a){var o=e.normals,s=e.tangents,l=e.bitangents,c=Cartesian3.normalize(Cartesian3.cross(i,t,scratch1$2),scratch1$2);a.normal&&CorridorGeometryLibrary.addAttribute(o,t,r,n),a.tangent&&CorridorGeometryLibrary.addAttribute(s,c,r,n),a.bitangent&&CorridorGeometryLibrary.addAttribute(l,i,r,n)}function combine$1(e,t,i){var r,n,a,o=e.positions,s=e.corners,l=e.endPositions,c=e.lefts,u=e.normals,d=new GeometryAttributes,h=0,p=0,m=0;for(n=0;n<o.length;n+=2)h+=a=o[n].length-3,m+=2*a,p+=o[n+1].length-3;for(h+=3,p+=3,n=0;n<s.length;n++){r=s[n];var f=s[n].leftPositions;defined(f)?h+=a=f.length:p+=a=s[n].rightPositions.length,m+=a}var g,_=defined(l);_&&(h+=g=l[0].length-3,p+=g,m+=6*(g/=3));var y,v,C,S,T,x,b=h+p,E=new Float64Array(b),P={normals:t.normal?new Float32Array(b):void 0,tangents:t.tangent?new Float32Array(b):void 0,bitangents:t.bitangent?new Float32Array(b):void 0},A=0,w=b-1,D=cartesian1$1,M=cartesian2$1,I=g/2,R=IndexDatatype$1.createTypedArray(b/3,m),O=0;if(_){x=cartesian3$1,T=cartesian4$1;var L=l[0];for(D=Cartesian3.fromArray(u,0,D),M=Cartesian3.fromArray(c,0,M),n=0;n<I;n++)x=Cartesian3.fromArray(L,3*(I-1-n),x),T=Cartesian3.fromArray(L,3*(I+n),T),CorridorGeometryLibrary.addAttribute(E,T,A),CorridorGeometryLibrary.addAttribute(E,x,void 0,w),addNormals(P,D,M,A,w,t),S=(v=A/3)+1,C=(y=(w-2)/3)-1,R[O++]=y,R[O++]=v,R[O++]=C,R[O++]=C,R[O++]=v,R[O++]=S,A+=3,w-=3}var F,N,V=0,B=0,k=o[V++],$=o[V++];for(E.set(k,A),E.set($,w-$.length+1),M=Cartesian3.fromArray(c,B,M),a=$.length-3,n=0;n<a;n+=3)F=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,n,scratch1$2),scratch1$2),N=i.geodeticSurfaceNormal(Cartesian3.fromArray($,a-n,scratch2$2),scratch2$2),addNormals(P,D=Cartesian3.normalize(Cartesian3.add(F,N,D),D),M,A,w,t),S=(v=A/3)+1,C=(y=(w-2)/3)-1,R[O++]=y,R[O++]=v,R[O++]=C,R[O++]=C,R[O++]=v,R[O++]=S,A+=3,w-=3;for(F=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,a,scratch1$2),scratch1$2),N=i.geodeticSurfaceNormal(Cartesian3.fromArray($,a,scratch2$2),scratch2$2),D=Cartesian3.normalize(Cartesian3.add(F,N,D),D),B+=3,n=0;n<s.length;n++){var z,U,G,H=(r=s[n]).leftPositions,W=r.rightPositions,q=cartesian6$1,j=cartesian3$1,Y=cartesian4$1;if(D=Cartesian3.fromArray(u,B,D),defined(H)){for(addNormals(P,D,M,void 0,w,t),w-=3,U=S,G=C,z=0;z<H.length/3;z++)q=Cartesian3.fromArray(H,3*z,q),R[O++]=U,R[O++]=G-z-1,R[O++]=G-z,CorridorGeometryLibrary.addAttribute(E,q,void 0,w),j=Cartesian3.fromArray(E,3*(G-z-1),j),Y=Cartesian3.fromArray(E,3*U,Y),addNormals(P,D,M=Cartesian3.normalize(Cartesian3.subtract(j,Y,M),M),void 0,w,t),w-=3;q=Cartesian3.fromArray(E,3*U,q),j=Cartesian3.subtract(Cartesian3.fromArray(E,3*G,j),q,j),Y=Cartesian3.subtract(Cartesian3.fromArray(E,3*(G-z),Y),q,Y),addNormals(P,D,M=Cartesian3.normalize(Cartesian3.add(j,Y,M),M),A,void 0,t),A+=3}else{for(addNormals(P,D,M,A,void 0,t),A+=3,U=C,G=S,z=0;z<W.length/3;z++)q=Cartesian3.fromArray(W,3*z,q),R[O++]=U,R[O++]=G+z,R[O++]=G+z+1,CorridorGeometryLibrary.addAttribute(E,q,A),j=Cartesian3.fromArray(E,3*U,j),Y=Cartesian3.fromArray(E,3*(G+z),Y),addNormals(P,D,M=Cartesian3.normalize(Cartesian3.subtract(j,Y,M),M),A,void 0,t),A+=3;q=Cartesian3.fromArray(E,3*U,q),j=Cartesian3.subtract(Cartesian3.fromArray(E,3*(G+z),j),q,j),Y=Cartesian3.subtract(Cartesian3.fromArray(E,3*G,Y),q,Y),addNormals(P,D,M=Cartesian3.normalize(Cartesian3.negate(Cartesian3.add(Y,j,M),M),M),void 0,w,t),w-=3}for(k=o[V++],$=o[V++],k.splice(0,3),$.splice($.length-3,3),E.set(k,A),E.set($,w-$.length+1),a=$.length-3,B+=3,M=Cartesian3.fromArray(c,B,M),z=0;z<$.length;z+=3)F=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,z,scratch1$2),scratch1$2),N=i.geodeticSurfaceNormal(Cartesian3.fromArray($,a-z,scratch2$2),scratch2$2),addNormals(P,D=Cartesian3.normalize(Cartesian3.add(F,N,D),D),M,A,w,t),v=(S=A/3)-1,y=(C=(w-2)/3)+1,R[O++]=y,R[O++]=v,R[O++]=C,R[O++]=C,R[O++]=v,R[O++]=S,A+=3,w-=3;A-=3,w+=3}if(addNormals(P,D=Cartesian3.fromArray(u,u.length-3,D),M,A,w,t),_){A+=3,w-=3,x=cartesian3$1,T=cartesian4$1;var X=l[1];for(n=0;n<I;n++)x=Cartesian3.fromArray(X,3*(g-n-1),x),T=Cartesian3.fromArray(X,3*n,T),CorridorGeometryLibrary.addAttribute(E,x,void 0,w),CorridorGeometryLibrary.addAttribute(E,T,A),addNormals(P,D,M,A,w,t),v=(S=A/3)-1,y=(C=(w-2)/3)+1,R[O++]=y,R[O++]=v,R[O++]=C,R[O++]=C,R[O++]=v,R[O++]=S,A+=3,w-=3}if(d.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:E}),t.st){var Q,J,Z=new Float32Array(b/3*2),K=0;if(_){h/=3,p/=3;var ee,te=Math.PI/(g+1);J=1/(h-g+1),Q=1/(p-g+1);var ie=g/2;for(n=1+ie;n<g+1;n++)ee=CesiumMath.PI_OVER_TWO+te*n,Z[K++]=Q*(1+Math.cos(ee)),Z[K++]=.5*(1+Math.sin(ee));for(n=1;n<p-g+1;n++)Z[K++]=n*Q,Z[K++]=0;for(n=g;ie<n;n--)ee=CesiumMath.PI_OVER_TWO-n*te,Z[K++]=1-Q*(1+Math.cos(ee)),Z[K++]=.5*(1+Math.sin(ee));for(n=ie;0<n;n--)ee=CesiumMath.PI_OVER_TWO-te*n,Z[K++]=1-J*(1+Math.cos(ee)),Z[K++]=.5*(1+Math.sin(ee));for(n=h-g;0<n;n--)Z[K++]=n*J,Z[K++]=1;for(n=1;n<1+ie;n++)ee=CesiumMath.PI_OVER_TWO+te*n,Z[K++]=J*(1+Math.cos(ee)),Z[K++]=.5*(1+Math.sin(ee))}else{for(J=1/((h/=3)-1),Q=1/((p/=3)-1),n=0;n<p;n++)Z[K++]=n*Q,Z[K++]=0;for(n=h;0<n;n--)Z[K++]=(n-1)*J,Z[K++]=1}d.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:Z})}return t.normal&&(d.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:P.normals})),t.tangent&&(d.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:P.tangents})),t.bitangent&&(d.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:P.bitangents})),{attributes:d,indices:R}}function extrudedAttributes(e,t){if(!(t.normal||t.tangent||t.bitangent||t.st))return e;var i,r,n=e.position.values;(t.normal||t.bitangent)&&(i=e.normal.values,r=e.bitangent.values);var a,o=e.position.values.length/18,s=3*o,l=2*o,c=2*s;if(t.normal||t.bitangent||t.tangent){var u=t.normal?new Float32Array(6*s):void 0,d=t.tangent?new Float32Array(6*s):void 0,h=t.bitangent?new Float32Array(6*s):void 0,p=cartesian1$1,m=cartesian2$1,f=cartesian3$1,g=cartesian4$1,_=cartesian5$1,y=cartesian6$1,v=c;for(a=0;a<s;a+=3){var C=v+c;p=Cartesian3.fromArray(n,a,p),m=Cartesian3.fromArray(n,a+s,m),f=Cartesian3.fromArray(n,(a+3)%s,f),m=Cartesian3.subtract(m,p,m),f=Cartesian3.subtract(f,p,f),g=Cartesian3.normalize(Cartesian3.cross(m,f,g),g),t.normal&&(CorridorGeometryLibrary.addAttribute(u,g,C),CorridorGeometryLibrary.addAttribute(u,g,C+3),CorridorGeometryLibrary.addAttribute(u,g,v),CorridorGeometryLibrary.addAttribute(u,g,v+3)),(t.tangent||t.bitangent)&&(y=Cartesian3.fromArray(i,a,y),t.bitangent&&(CorridorGeometryLibrary.addAttribute(h,y,C),CorridorGeometryLibrary.addAttribute(h,y,C+3),CorridorGeometryLibrary.addAttribute(h,y,v),CorridorGeometryLibrary.addAttribute(h,y,v+3)),t.tangent&&(_=Cartesian3.normalize(Cartesian3.cross(y,g,_),_),CorridorGeometryLibrary.addAttribute(d,_,C),CorridorGeometryLibrary.addAttribute(d,_,C+3),CorridorGeometryLibrary.addAttribute(d,_,v),CorridorGeometryLibrary.addAttribute(d,_,v+3))),v+=6}if(t.normal){for(u.set(i),a=0;a<s;a+=3)u[a+s]=-i[a],u[a+s+1]=-i[a+1],u[a+s+2]=-i[a+2];e.normal.values=u}else e.normal=void 0;if(t.bitangent?(h.set(r),h.set(r,s),e.bitangent.values=h):e.bitangent=void 0,t.tangent){var S=e.tangent.values;d.set(S),d.set(S,s),e.tangent.values=d}}if(t.st){var T=e.st.values,x=new Float32Array(6*l);x.set(T),x.set(T,l);for(var b=2*l,E=0;E<2;E++){for(x[b++]=T[0],x[b++]=T[1],a=2;a<l;a+=2){var P=T[a],A=T[a+1];x[b++]=P,x[b++]=A,x[b++]=P,x[b++]=A}x[b++]=T[0],x[b++]=T[1]}e.st.values=x}return e}function addWallPositions(e,t,i){i[t++]=e[0],i[t++]=e[1],i[t++]=e[2];for(var r=3;r<e.length;r+=3){var n=e[r],a=e[r+1],o=e[r+2];i[t++]=n,i[t++]=a,i[t++]=o,i[t++]=n,i[t++]=a,i[t++]=o}return i[t++]=e[0],i[t++]=e[1],i[t++]=e[2],i}function computePositionsExtruded(e,t){var i=new VertexFormat({position:t.position,normal:t.normal||t.bitangent||e.shadowVolume,tangent:t.tangent,bitangent:t.normal||t.bitangent,st:t.st}),r=e.ellipsoid,n=combine$1(CorridorGeometryLibrary.computePositions(e),i,r),a=e.height,o=e.extrudedHeight,s=n.attributes,l=n.indices,c=s.position.values,u=c.length,d=new Float64Array(6*u),h=new Float64Array(u);h.set(c);var p,m=new Float64Array(4*u);m=addWallPositions(c=PolygonPipeline.scaleToGeodeticHeight(c,a,r),0,m),m=addWallPositions(h=PolygonPipeline.scaleToGeodeticHeight(h,o,r),2*u,m),d.set(c),d.set(h,u),d.set(m,2*u),s.position.values=d,s=extrudedAttributes(s,t);var f=u/3;if(e.shadowVolume){var g=s.normal.values;u=g.length;var _=new Float32Array(6*u);for(p=0;p<u;p++)g[p]=-g[p];_.set(g,u),_=addWallPositions(g,4*u,_),s.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_}),t.normal||(s.normal=void 0)}if(defined(e.offsetAttribute)){var y=new Uint8Array(6*f);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)y=arrayFill(y,1,0,f),y=arrayFill(y,1,2*f,4*f);else y=arrayFill(y,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);s.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:y})}var v=l.length,C=f+f,S=IndexDatatype$1.createTypedArray(d.length/3,2*v+3*C);S.set(l);var T,x,b,E,P=v;for(p=0;p<v;p+=3){var A=l[p],w=l[p+1],D=l[p+2];S[P++]=D+f,S[P++]=w+f,S[P++]=A+f}for(p=0;p<C;p+=2)b=(T=p+C)+1,E=(x=T+C)+1,S[P++]=T,S[P++]=x,S[P++]=b,S[P++]=b,S[P++]=x,S[P++]=E;return{attributes:s,indices:S}}var scratchCartesian1$6=new Cartesian3,scratchCartesian2$6=new Cartesian3,scratchCartographic$2=new Cartographic;function computeOffsetPoints(e,t,i,r,n,a){var o=Cartesian3.subtract(t,e,scratchCartesian1$6);Cartesian3.normalize(o,o);var s=i.geodeticSurfaceNormal(e,scratchCartesian2$6),l=Cartesian3.cross(o,s,scratchCartesian1$6);Cartesian3.multiplyByScalar(l,r,l);var c=n.latitude,u=n.longitude,d=a.latitude,h=a.longitude;Cartesian3.add(e,l,scratchCartesian2$6),i.cartesianToCartographic(scratchCartesian2$6,scratchCartographic$2);var p=scratchCartographic$2.latitude,m=scratchCartographic$2.longitude;c=Math.min(c,p),u=Math.min(u,m),d=Math.max(d,p),h=Math.max(h,m),Cartesian3.subtract(e,l,scratchCartesian2$6),i.cartesianToCartographic(scratchCartesian2$6,scratchCartographic$2),p=scratchCartographic$2.latitude,m=scratchCartographic$2.longitude,c=Math.min(c,p),u=Math.min(u,m),d=Math.max(d,p),h=Math.max(h,m),n.latitude=c,n.longitude=u,a.latitude=d,a.longitude=h}var scratchCartesianOffset=new Cartesian3,scratchCartesianEnds=new Cartesian3,scratchCartographicMin=new Cartographic,scratchCartographicMax=new Cartographic;function computeRectangle$1(e,t,i,r,n){var a=arrayRemoveDuplicates(e=scaleToSurface$1(e,t),Cartesian3.equalsEpsilon),o=a.length;if(o<2||i<=0)return new Rectangle;var s,l,c=.5*i;if(scratchCartographicMin.latitude=Number.POSITIVE_INFINITY,scratchCartographicMin.longitude=Number.POSITIVE_INFINITY,scratchCartographicMax.latitude=Number.NEGATIVE_INFINITY,scratchCartographicMax.longitude=Number.NEGATIVE_INFINITY,r===CornerType$1.ROUNDED){var u=a[0];Cartesian3.subtract(u,a[1],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,c,scratchCartesianOffset),Cartesian3.add(u,scratchCartesianOffset,scratchCartesianEnds),t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$2),s=scratchCartographic$2.latitude,l=scratchCartographic$2.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,s),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,s),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l)}for(var d=0;d<o-1;++d)computeOffsetPoints(a[d],a[d+1],t,c,scratchCartographicMin,scratchCartographicMax);var h=a[o-1];Cartesian3.subtract(h,a[o-2],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,c,scratchCartesianOffset),Cartesian3.add(h,scratchCartesianOffset,scratchCartesianEnds),computeOffsetPoints(h,scratchCartesianEnds,t,c,scratchCartographicMin,scratchCartographicMax),r===CornerType$1.ROUNDED&&(t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$2),s=scratchCartographic$2.latitude,l=scratchCartographic$2.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,s),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,s),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l));var p=defined(n)?n:new Rectangle;return p.north=scratchCartographicMax.latitude,p.south=scratchCartographicMin.latitude,p.east=scratchCartographicMax.longitude,p.west=scratchCartographicMin.longitude,p}function CorridorGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width,r=defaultValue(e.height,0),n=defaultValue(e.extrudedHeight,r);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._width=i,this._height=Math.max(r,n),this._extrudedHeight=Math.min(r,n),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createCorridorGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7}CorridorGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._positions,n=r.length;t[i++]=n;for(var a=0;a<n;++a,i+=Cartesian3.packedLength)Cartesian3.pack(r[a],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._width,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._cornerType,t[i++]=e._granularity,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchEllipsoid$3=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$3=new VertexFormat,scratchOptions$8={positions:void 0,ellipsoid:scratchEllipsoid$3,vertexFormat:scratchVertexFormat$3,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,shadowVolume:void 0,offsetAttribute:void 0};CorridorGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=Ellipsoid.unpack(e,t,scratchEllipsoid$3);t+=Ellipsoid.packedLength;var s=VertexFormat.unpack(e,t,scratchVertexFormat$3);t+=VertexFormat.packedLength;var l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],m=e[t];return defined(i)?(i._positions=n,i._ellipsoid=Ellipsoid.clone(o,i._ellipsoid),i._vertexFormat=VertexFormat.clone(s,i._vertexFormat),i._width=l,i._height=c,i._extrudedHeight=u,i._cornerType=d,i._granularity=h,i._shadowVolume=p,i._offsetAttribute=-1===m?void 0:m,i):(scratchOptions$8.positions=n,scratchOptions$8.width=l,scratchOptions$8.height=c,scratchOptions$8.extrudedHeight=u,scratchOptions$8.cornerType=d,scratchOptions$8.granularity=h,scratchOptions$8.shadowVolume=p,scratchOptions$8.offsetAttribute=-1===m?void 0:m,new CorridorGeometry(scratchOptions$8))},CorridorGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,r=e.width;return computeRectangle$1(i,defaultValue(e.ellipsoid,Ellipsoid.WGS84),r,defaultValue(e.cornerType,CornerType$1.ROUNDED),t)},CorridorGeometry.createGeometry=function(e){var t=e._positions,i=e._width,r=e._ellipsoid,n=arrayRemoveDuplicates(t=scaleToSurface$1(t,r),Cartesian3.equalsEpsilon);if(!(n.length<2||i<=0)){var a,o=e._height,s=e._extrudedHeight,l=!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2),c=e._vertexFormat,u={ellipsoid:r,positions:n,width:i,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!0};if(l)u.height=o,u.extrudedHeight=s,u.shadowVolume=e._shadowVolume,u.offsetAttribute=e._offsetAttribute,a=computePositionsExtruded(u,c);else if((a=combine$1(CorridorGeometryLibrary.computePositions(u),c,r)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,o,r),defined(e._offsetAttribute)){var d=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,h=a.attributes.position.values.length,p=new Uint8Array(h/3);arrayFill(p,d),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:p})}var m=a.attributes,f=BoundingSphere.fromVertices(m.position.values,void 0,3);return c.position||(a.attributes.position.values=void 0),new Geometry({attributes:m,indices:a.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:f,offsetAttribute:e._offsetAttribute})}},CorridorGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,a=t(r,n),o=i(r,n);return new CorridorGeometry({positions:e._positions,width:e._width,cornerType:e._cornerType,ellipsoid:n,granularity:r,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},defineProperties$1(CorridorGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle$1(this._positions,this._ellipsoid,this._width,this._cornerType)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return[0,0,0,1,1,0]}}});var cartesian1$2=new Cartesian3,cartesian2$2=new Cartesian3,cartesian3$2=new Cartesian3;function scaleToSurface$2(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}function combine$2(e,t){var i,r,n,a=[],o=e.positions,s=e.corners,l=e.endPositions,c=new GeometryAttributes,u=0,d=0,h=0;for(r=0;r<o.length;r+=2)u+=n=o[r].length-3,h+=n/3*4,d+=o[r+1].length-3;for(u+=3,d+=3,r=0;r<s.length;r++){i=s[r];var p=s[r].leftPositions;defined(p)?u+=n=p.length:d+=n=s[r].rightPositions.length,h+=n/3*2}var m,f=defined(l);f&&(u+=m=l[0].length-3,d+=m,h+=4*(m/=3));var g,_,y,v,C,S,T=u+d,x=new Float64Array(T),b=0,E=T-1,P=m/2,A=IndexDatatype$1.createTypedArray(T/3,h+4),w=0;if(A[w++]=b/3,A[w++]=(E-2)/3,f){a.push(b/3),S=cartesian1$2,C=cartesian2$2;var D=l[0];for(r=0;r<P;r++)S=Cartesian3.fromArray(D,3*(P-1-r),S),C=Cartesian3.fromArray(D,3*(P+r),C),CorridorGeometryLibrary.addAttribute(x,C,b),CorridorGeometryLibrary.addAttribute(x,S,void 0,E),v=(_=b/3)+1,y=(g=(E-2)/3)-1,A[w++]=g,A[w++]=y,A[w++]=_,A[w++]=v,b+=3,E-=3}var M=0,I=o[M++],R=o[M++];for(x.set(I,b),x.set(R,E-R.length+1),n=R.length-3,a.push(b/3,(E-2)/3),r=0;r<n;r+=3)v=(_=b/3)+1,y=(g=(E-2)/3)-1,A[w++]=g,A[w++]=y,A[w++]=_,A[w++]=v,b+=3,E-=3;for(r=0;r<s.length;r++){var O,L,F=(i=s[r]).leftPositions,N=i.rightPositions,V=cartesian3$2;if(defined(F)){for(E-=3,L=y,a.push(v),O=0;O<F.length/3;O++)V=Cartesian3.fromArray(F,3*O,V),A[w++]=L-O-1,A[w++]=L-O,CorridorGeometryLibrary.addAttribute(x,V,void 0,E),E-=3;a.push(L-Math.floor(F.length/6)),t===CornerType$1.BEVELED&&a.push((E-2)/3+1),b+=3}else{for(b+=3,L=v,a.push(y),O=0;O<N.length/3;O++)V=Cartesian3.fromArray(N,3*O,V),A[w++]=L+O,A[w++]=L+O+1,CorridorGeometryLibrary.addAttribute(x,V,b),b+=3;a.push(L+Math.floor(N.length/6)),t===CornerType$1.BEVELED&&a.push(b/3-1),E-=3}for(I=o[M++],R=o[M++],I.splice(0,3),R.splice(R.length-3,3),x.set(I,b),x.set(R,E-R.length+1),n=R.length-3,O=0;O<R.length;O+=3)_=(v=b/3)-1,g=(y=(E-2)/3)+1,A[w++]=g,A[w++]=y,A[w++]=_,A[w++]=v,b+=3,E-=3;b-=3,E+=3,a.push(b/3,(E-2)/3)}if(f){b+=3,E-=3,S=cartesian1$2,C=cartesian2$2;var B=l[1];for(r=0;r<P;r++)S=Cartesian3.fromArray(B,3*(m-r-1),S),C=Cartesian3.fromArray(B,3*r,C),CorridorGeometryLibrary.addAttribute(x,S,void 0,E),CorridorGeometryLibrary.addAttribute(x,C,b),_=(v=b/3)-1,g=(y=(E-2)/3)+1,A[w++]=g,A[w++]=y,A[w++]=_,A[w++]=v,b+=3,E-=3;a.push(b/3)}else a.push(b/3,(E-2)/3);return A[w++]=b/3,A[w++]=(E-2)/3,c.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:x}),{attributes:c,indices:A,wallIndices:a}}function computePositionsExtruded$1(e){var t=e.ellipsoid,i=combine$2(CorridorGeometryLibrary.computePositions(e),e.cornerType),r=i.wallIndices,n=e.height,a=e.extrudedHeight,o=i.attributes,s=i.indices,l=o.position.values,c=l.length,u=new Float64Array(c);u.set(l);var d,h=new Float64Array(2*c);if(l=PolygonPipeline.scaleToGeodeticHeight(l,n,t),u=PolygonPipeline.scaleToGeodeticHeight(u,a,t),h.set(l),h.set(u,c),o.position.values=h,c/=3,defined(e.offsetAttribute)){var p=new Uint8Array(2*c);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)p=arrayFill(p,1,0,c);else p=arrayFill(p,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);o.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:p})}var m=s.length,f=IndexDatatype$1.createTypedArray(h.length/3,2*(m+r.length));f.set(s);var g,_,y=m;for(d=0;d<m;d+=2){var v=s[d],C=s[d+1];f[y++]=v+c,f[y++]=C+c}for(d=0;d<r.length;d++)_=(g=r[d])+c,f[y++]=g,f[y++]=_;return{attributes:o,indices:f}}function CorridorOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width,r=defaultValue(e.height,0),n=defaultValue(e.extrudedHeight,r);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._width=i,this._height=Math.max(r,n),this._extrudedHeight=Math.min(r,n),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._offsetAttribute=e.offsetAttribute,this._workerName="createCorridorOutlineGeometry",this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+6}CorridorOutlineGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._positions,n=r.length;t[i++]=n;for(var a=0;a<n;++a,i+=Cartesian3.packedLength)Cartesian3.pack(r[a],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._width,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._cornerType,t[i++]=e._granularity,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchEllipsoid$4=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$9={positions:void 0,ellipsoid:scratchEllipsoid$4,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,offsetAttribute:void 0};function CullingVolume(e){this.planes=defaultValue(e,[])}CorridorOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=Ellipsoid.unpack(e,t,scratchEllipsoid$4);t+=Ellipsoid.packedLength;var s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._positions=n,i._ellipsoid=Ellipsoid.clone(o,i._ellipsoid),i._width=s,i._height=l,i._extrudedHeight=c,i._cornerType=u,i._granularity=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$9.positions=n,scratchOptions$9.width=s,scratchOptions$9.height=l,scratchOptions$9.extrudedHeight=c,scratchOptions$9.cornerType=u,scratchOptions$9.granularity=d,scratchOptions$9.offsetAttribute=-1===h?void 0:h,new CorridorOutlineGeometry(scratchOptions$9))},CorridorOutlineGeometry.createGeometry=function(e){var t=e._positions,i=e._width,r=e._ellipsoid,n=arrayRemoveDuplicates(t=scaleToSurface$2(t,r),Cartesian3.equalsEpsilon);if(!(n.length<2||i<=0)){var a,o=e._height,s=e._extrudedHeight,l=!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2),c={ellipsoid:r,positions:n,width:i,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!1};if(l)c.height=o,c.extrudedHeight=s,c.offsetAttribute=e._offsetAttribute,a=computePositionsExtruded$1(c);else if((a=combine$2(CorridorGeometryLibrary.computePositions(c),c.cornerType)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,o,r),defined(e._offsetAttribute)){var u=a.attributes.position.values.length,d=new Uint8Array(u/3);arrayFill(d,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:d})}var h=a.attributes,p=BoundingSphere.fromVertices(h.position.values,void 0,3);return new Geometry({attributes:h,indices:a.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:p,offsetAttribute:e._offsetAttribute})}};var faces=[new Cartesian3,new Cartesian3,new Cartesian3];Cartesian3.clone(Cartesian3.UNIT_X,faces[0]),Cartesian3.clone(Cartesian3.UNIT_Y,faces[1]),Cartesian3.clone(Cartesian3.UNIT_Z,faces[2]);var scratchPlaneCenter=new Cartesian3,scratchPlaneNormal=new Cartesian3,scratchPlane=new Plane(new Cartesian3(1,0,0),0);CullingVolume.fromBoundingSphere=function(e,t){defined(t)||(t=new CullingVolume);var i=faces.length,r=t.planes;r.length=2*i;for(var n=e.center,a=e.radius,o=0,s=0;s<i;++s){var l=faces[s],c=r[o],u=r[o+1];defined(c)||(c=r[o]=new Cartesian4),defined(u)||(u=r[o+1]=new Cartesian4),Cartesian3.multiplyByScalar(l,-a,scratchPlaneCenter),Cartesian3.add(n,scratchPlaneCenter,scratchPlaneCenter),c.x=l.x,c.y=l.y,c.z=l.z,c.w=-Cartesian3.dot(l,scratchPlaneCenter),Cartesian3.multiplyByScalar(l,a,scratchPlaneCenter),Cartesian3.add(n,scratchPlaneCenter,scratchPlaneCenter),u.x=-l.x,u.y=-l.y,u.z=-l.z,u.w=-Cartesian3.dot(Cartesian3.negate(l,scratchPlaneNormal),scratchPlaneCenter),o+=2}return t},CullingVolume.prototype.computeVisibility=function(e){for(var t=this.planes,i=!1,r=0,n=t.length;r<n;++r){var a=e.intersectPlane(Plane.fromCartesian4(t[r],scratchPlane));if(a===Intersect$1.OUTSIDE)return Intersect$1.OUTSIDE;a===Intersect$1.INTERSECTING&&(i=!0)}return i?Intersect$1.INTERSECTING:Intersect$1.INSIDE},CullingVolume.prototype.computeVisibilityWithPlaneMask=function(e,t){if(t===CullingVolume.MASK_OUTSIDE||t===CullingVolume.MASK_INSIDE)return t;for(var i=CullingVolume.MASK_INSIDE,r=this.planes,n=0,a=r.length;n<a;++n){var o=n<31?1<<n:0;if(!(n<31&&0==(t&o))){var s=e.intersectPlane(Plane.fromCartesian4(r[n],scratchPlane));if(s===Intersect$1.OUTSIDE)return CullingVolume.MASK_OUTSIDE;s===Intersect$1.INTERSECTING&&(i|=o)}}return i},CullingVolume.MASK_OUTSIDE=4294967295,CullingVolume.MASK_INSIDE=0,CullingVolume.MASK_INDETERMINATE=2147483647;var CylinderGeometryLibrary={computePositions:function(e,t,i,r,n){var a,o=.5*e,s=-o,l=r+r,c=new Float64Array(3*(n?2*l:l)),u=0,d=0,h=n?3*l:0,p=n?3*(l+r):3*r;for(a=0;a<r;a++){var m=a/r*CesiumMath.TWO_PI,f=Math.cos(m),g=Math.sin(m),_=f*i,y=g*i,v=f*t,C=g*t;c[d+h]=_,c[d+h+1]=y,c[d+h+2]=s,c[d+p]=v,c[d+p+1]=C,c[d+p+2]=o,d+=3,n&&(c[u++]=_,c[u++]=y,c[u++]=s,c[u++]=v,c[u++]=C,c[u++]=o)}return c}},radiusScratch=new Cartesian2,normalScratch$2=new Cartesian3,bitangentScratch=new Cartesian3,tangentScratch=new Cartesian3,positionScratch$1=new Cartesian3;function CylinderGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,i=e.topRadius,r=e.bottomRadius,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),a=defaultValue(e.slices,128);this._length=t,this._topRadius=i,this._bottomRadius=r,this._vertexFormat=VertexFormat.clone(n),this._slices=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderGeometry"}CylinderGeometry.packedLength=VertexFormat.packedLength+5,CylinderGeometry.pack=function(e,t,i){return i=defaultValue(i,0),VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchVertexFormat$4=new VertexFormat,scratchOptions$a={vertexFormat:scratchVertexFormat$4,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,offsetAttribute:void 0},unitCylinderGeometry;CylinderGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=VertexFormat.unpack(e,t,scratchVertexFormat$4);t+=VertexFormat.packedLength;var n=e[t++],a=e[t++],o=e[t++],s=e[t++],l=e[t];return defined(i)?(i._vertexFormat=VertexFormat.clone(r,i._vertexFormat),i._length=n,i._topRadius=a,i._bottomRadius=o,i._slices=s,i._offsetAttribute=-1===l?void 0:l,i):(scratchOptions$a.length=n,scratchOptions$a.topRadius=a,scratchOptions$a.bottomRadius=o,scratchOptions$a.slices=s,scratchOptions$a.offsetAttribute=-1===l?void 0:l,new CylinderGeometry(scratchOptions$a))},CylinderGeometry.createGeometry=function(e){var t=e._length,i=e._topRadius,r=e._bottomRadius,n=e._vertexFormat,a=e._slices;if(!(t<=0||i<0||r<0||0===i&&0===r)){var o,s=a+a,l=a+s,c=s+s,u=CylinderGeometryLibrary.computePositions(t,i,r,a,!0),d=n.st?new Float32Array(2*c):void 0,h=n.normal?new Float32Array(3*c):void 0,p=n.tangent?new Float32Array(3*c):void 0,m=n.bitangent?new Float32Array(3*c):void 0,f=n.normal||n.tangent||n.bitangent;if(f){var g=n.tangent||n.bitangent,_=0,y=0,v=0,C=Math.atan2(r-i,t),S=normalScratch$2;S.z=Math.sin(C);var T=Math.cos(C),x=tangentScratch,b=bitangentScratch;for(o=0;o<a;o++){var E=o/a*CesiumMath.TWO_PI,P=T*Math.cos(E),A=T*Math.sin(E);f&&(S.x=P,S.y=A,g&&(x=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,S,x),x)),n.normal&&(h[_++]=S.x,h[_++]=S.y,h[_++]=S.z,h[_++]=S.x,h[_++]=S.y,h[_++]=S.z),n.tangent&&(p[y++]=x.x,p[y++]=x.y,p[y++]=x.z,p[y++]=x.x,p[y++]=x.y,p[y++]=x.z),n.bitangent&&(b=Cartesian3.normalize(Cartesian3.cross(S,x,b),b),m[v++]=b.x,m[v++]=b.y,m[v++]=b.z,m[v++]=b.x,m[v++]=b.y,m[v++]=b.z))}for(o=0;o<a;o++)n.normal&&(h[_++]=0,h[_++]=0,h[_++]=-1),n.tangent&&(p[y++]=1,p[y++]=0,p[y++]=0),n.bitangent&&(m[v++]=0,m[v++]=-1,m[v++]=0);for(o=0;o<a;o++)n.normal&&(h[_++]=0,h[_++]=0,h[_++]=1),n.tangent&&(p[y++]=1,p[y++]=0,p[y++]=0),n.bitangent&&(m[v++]=0,m[v++]=1,m[v++]=0)}var w=12*a-12,D=IndexDatatype$1.createTypedArray(c,w),M=0,I=0;for(o=0;o<a-1;o++)D[M++]=I,D[M++]=I+2,D[M++]=I+3,D[M++]=I,D[M++]=I+3,D[M++]=I+1,I+=2;for(D[M++]=s-2,D[M++]=0,D[M++]=1,D[M++]=s-2,D[M++]=1,D[M++]=s-1,o=1;o<a-1;o++)D[M++]=s+o+1,D[M++]=s+o,D[M++]=s;for(o=1;o<a-1;o++)D[M++]=l,D[M++]=l+o,D[M++]=l+o+1;var R=0;if(n.st){var O=Math.max(i,r);for(o=0;o<c;o++){var L=Cartesian3.fromArray(u,3*o,positionScratch$1);d[R++]=(L.x+O)/(2*O),d[R++]=(L.y+O)/(2*O)}}var F=new GeometryAttributes;n.position&&(F.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:u})),n.normal&&(F.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),n.tangent&&(F.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),n.bitangent&&(F.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),n.st&&(F.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:d})),radiusScratch.x=.5*t,radiusScratch.y=Math.max(r,i);var N=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch));if(defined(e._offsetAttribute)){t=u.length;var V=new Uint8Array(t/3);arrayFill(V,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),F.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:V})}return new Geometry({attributes:F,indices:D,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:N,offsetAttribute:e._offsetAttribute})}},CylinderGeometry.getUnitCylinder=function(){return defined(unitCylinderGeometry)||(unitCylinderGeometry=CylinderGeometry.createGeometry(new CylinderGeometry({topRadius:1,bottomRadius:1,length:1,vertexFormat:VertexFormat.POSITION_ONLY}))),unitCylinderGeometry};var radiusScratch$1=new Cartesian2;function CylinderOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,i=e.topRadius,r=e.bottomRadius,n=defaultValue(e.slices,128),a=Math.max(defaultValue(e.numberOfVerticalLines,16),0);this._length=t,this._topRadius=i,this._bottomRadius=r,this._slices=n,this._numberOfVerticalLines=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderOutlineGeometry"}CylinderOutlineGeometry.packedLength=6,CylinderOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i++]=e._numberOfVerticalLines,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchOptions$b={length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function DefaultProxy(e){this.proxy=e}function DistanceDisplayCondition(e,t){e=defaultValue(e,0),this._near=e,t=defaultValue(t,Number.MAX_VALUE),this._far=t}function DistanceDisplayConditionGeometryInstanceAttribute(e,t){e=defaultValue(e,0),t=defaultValue(t,Number.MAX_VALUE),this.value=new Float32Array([e,t])}function DoublyLinkedList(){this.head=void 0,this.tail=void 0,this._length=0}function DoublyLinkedListNode(e,t,i){this.item=e,this.previous=t,this.next=i}function remove(e,t){defined(t.previous)&&defined(t.next)?(t.previous.next=t.next,t.next.previous=t.previous):defined(t.previous)?(t.previous.next=void 0,e.tail=t.previous):defined(t.next)?(t.next.previous=void 0,e.head=t.next):(e.head=void 0,e.tail=void 0),t.next=void 0,t.previous=void 0}CylinderOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=e[t++],n=e[t++],a=e[t++],o=e[t++],s=e[t++],l=e[t];return defined(i)?(i._length=r,i._topRadius=n,i._bottomRadius=a,i._slices=o,i._numberOfVerticalLines=s,i._offsetAttribute=-1===l?void 0:l,i):(scratchOptions$b.length=r,scratchOptions$b.topRadius=n,scratchOptions$b.bottomRadius=a,scratchOptions$b.slices=o,scratchOptions$b.numberOfVerticalLines=s,scratchOptions$b.offsetAttribute=-1===l?void 0:l,new CylinderOutlineGeometry(scratchOptions$b))},CylinderOutlineGeometry.createGeometry=function(e){var t=e._length,i=e._topRadius,r=e._bottomRadius,n=e._slices,a=e._numberOfVerticalLines;if(!(t<=0||i<0||r<0||0===i&&0===r)){var o,s=2*n,l=CylinderGeometryLibrary.computePositions(t,i,r,n,!1),c=2*n;if(0<a){var u=Math.min(a,n);o=Math.round(n/u),c+=u}var d,h=IndexDatatype$1.createTypedArray(s,2*c),p=0;for(d=0;d<n-1;d++)h[p++]=d,h[p++]=d+1,h[p++]=d+n,h[p++]=d+1+n;if(h[p++]=n-1,h[p++]=0,h[p++]=n+n-1,h[p++]=n,0<a)for(d=0;d<n;d+=o)h[p++]=d,h[p++]=d+n;var m=new GeometryAttributes;m.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l}),radiusScratch$1.x=.5*t,radiusScratch$1.y=Math.max(r,i);var f=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch$1));if(defined(e._offsetAttribute)){t=l.length;var g=new Uint8Array(t/3);arrayFill(g,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),m.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:g})}return new Geometry({attributes:m,indices:h,primitiveType:PrimitiveType$1.LINES,boundingSphere:f,offsetAttribute:e._offsetAttribute})}},DefaultProxy.prototype.getURL=function(e){var t=-1===this.proxy.indexOf("?")?"?":"";return this.proxy+t+encodeURIComponent(e)},defineProperties$1(DistanceDisplayCondition.prototype,{near:{get:function(){return this._near},set:function(e){this._near=e}},far:{get:function(){return this._far},set:function(e){this._far=e}}}),DistanceDisplayCondition.packedLength=2,DistanceDisplayCondition.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.near,t[i]=e.far,t},DistanceDisplayCondition.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new DistanceDisplayCondition),i.near=e[t++],i.far=e[t],i},DistanceDisplayCondition.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.far===t.far},DistanceDisplayCondition.clone=function(e,t){if(defined(e))return defined(t)||(t=new DistanceDisplayCondition),t.near=e.near,t.far=e.far,t},DistanceDisplayCondition.prototype.clone=function(e){return DistanceDisplayCondition.clone(this,e)},DistanceDisplayCondition.prototype.equals=function(e){return DistanceDisplayCondition.equals(this,e)},defineProperties$1(DistanceDisplayConditionGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 2}},normalize:{get:function(){return!1}}}),DistanceDisplayConditionGeometryInstanceAttribute.fromDistanceDisplayCondition=function(e){return new DistanceDisplayConditionGeometryInstanceAttribute(e.near,e.far)},DistanceDisplayConditionGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e.near,t[1]=e.far,t):new Float32Array([e.near,e.far])},defineProperties$1(DoublyLinkedList.prototype,{length:{get:function(){return this._length}}}),DoublyLinkedList.prototype.add=function(e){var t=new DoublyLinkedListNode(e,this.tail,void 0);return defined(this.tail)?this.tail.next=t:this.head=t,this.tail=t,++this._length,t},DoublyLinkedList.prototype.remove=function(e){defined(e)&&(remove(this,e),--this._length)},DoublyLinkedList.prototype.splice=function(e,t){if(e!==t){remove(this,t);var i=e.next;e.next=t,this.tail===e?this.tail=t:i.previous=t,t.next=i,t.previous=e}},void 0===Date.now&&(Date.now=function(){return(new Date).valueOf()});var TWEEN=TWEEN||(Fwb=[],{REVISION:"13",getAll:function(){return Fwb},removeAll:function(){Fwb=[]},add:function(e){Fwb.push(e)},remove:function(e){var t=Fwb.indexOf(e);-1!==t&&Fwb.splice(t,1)},update:function(e){if(0===Fwb.length)return!1;var t=0;for(e=void 0!==e?e:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?window.performance.now():Date.now();t<Fwb.length;)Fwb[t].update(e)?t++:Fwb.splice(t,1);return!0}}),Fwb,Pyb;TWEEN.Tween=function(e){var c=e,u={},d={},h={},p=1e3,m=0,f=!1,i=!1,g=0,_=null,y=TWEEN.Easing.Linear.None,v=TWEEN.Interpolation.Linear,C=[],S=null,T=!1,x=null,b=null,t=null;for(var r in e)u[r]=parseFloat(e[r],10);this.to=function(e,t){return void 0!==t&&(p=t),d=e,this},this.start=function(e){for(var t in TWEEN.add(this),T=!(i=!0),_=void 0!==e?e:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?window.performance.now():Date.now(),_+=g,d){if(d[t]instanceof Array){if(0===d[t].length)continue;d[t]=[c[t]].concat(d[t])}u[t]=c[t],u[t]instanceof Array==!1&&(u[t]*=1),h[t]=u[t]||0}return this},this.stop=function(){return i&&(TWEEN.remove(this),i=!1,null!==t&&t.call(c),this.stopChainedTweens()),this},this.stopChainedTweens=function(){for(var e=0,t=C.length;e<t;e++)C[e].stop()},this.delay=function(e){return g=e,this},this.repeat=function(e){return m=e,this},this.yoyo=function(e){return f=e,this},this.easing=function(e){return y=e,this},this.interpolation=function(e){return v=e,this},this.chain=function(){return C=arguments,this},this.onStart=function(e){return S=e,this},this.onUpdate=function(e){return x=e,this},this.onComplete=function(e){return b=e,this},this.onStop=function(e){return t=e,this},this.update=function(e){var t;if(e<_)return!0;!1===T&&(null!==S&&S.call(c),T=!0);var i=(e-_)/p,r=y(i=1<i?1:i);for(t in d){var n=u[t]||0,a=d[t];a instanceof Array?c[t]=v(a,r):("string"==typeof a&&(a=n+parseFloat(a,10)),"number"==typeof a&&(c[t]=n+(a-n)*r))}if(null!==x&&x.call(c,r),1!=i)return!0;if(0<m){for(t in isFinite(m)&&m--,h){if("string"==typeof d[t]&&(h[t]=h[t]+parseFloat(d[t],10)),f){var o=h[t];h[t]=d[t],d[t]=o}u[t]=h[t]}return _=e+g,!0}null!==b&&b.call(c);for(var s=0,l=C.length;s<l;s++)C[s].start(e);return!1}},TWEEN.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(2-Math.pow(2,-10*(e-1)))}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){var t,i=.1;return 0===e?0:1===e?1:(t=!i||i<1?(i=1,.1):.4*Math.asin(1/i)/(2*Math.PI),-i*Math.pow(2,10*(e-=1))*Math.sin((e-t)*(2*Math.PI)/.4))},Out:function(e){var t,i=.1;return 0===e?0:1===e?1:(t=!i||i<1?(i=1,.1):.4*Math.asin(1/i)/(2*Math.PI),i*Math.pow(2,-10*e)*Math.sin((e-t)*(2*Math.PI)/.4)+1)},InOut:function(e){var t,i=.1;return 0===e?0:1===e?1:(t=!i||i<1?(i=1,.1):.4*Math.asin(1/i)/(2*Math.PI),(e*=2)<1?i*Math.pow(2,10*(e-=1))*Math.sin((e-t)*(2*Math.PI)/.4)*-.5:i*Math.pow(2,-10*(e-=1))*Math.sin((e-t)*(2*Math.PI)/.4)*.5+1)}},Back:{In:function(e){return e*e*(2.70158*e-1.70158)},Out:function(e){return--e*e*(2.70158*e+1.70158)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?e*e*((1+t)*e-t)*.5:.5*((e-=2)*e*((1+t)*e+t)+2)}},Bounce:{In:function(e){return 1-TWEEN.Easing.Bounce.Out(1-e)},Out:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(e){return e<.5?.5*TWEEN.Easing.Bounce.In(2*e):.5*TWEEN.Easing.Bounce.Out(2*e-1)+.5}}},TWEEN.Interpolation={Linear:function(e,t){var i=e.length-1,r=i*t,n=Math.floor(r),a=TWEEN.Interpolation.Utils.Linear;return t<0?a(e[0],e[1],r):1<t?a(e[i],e[i-1],i-r):a(e[n],e[i<n+1?i:n+1],r-n)},Bezier:function(e,t){var i,r=0,n=e.length-1,a=Math.pow,o=TWEEN.Interpolation.Utils.Bernstein;for(i=0;i<=n;i++)r+=a(1-t,n-i)*a(t,i)*e[i]*o(n,i);return r},CatmullRom:function(e,t){var i=e.length-1,r=i*t,n=Math.floor(r),a=TWEEN.Interpolation.Utils.CatmullRom;return e[0]===e[i]?(t<0&&(n=Math.floor(r=i*(1+t))),a(e[(n-1+i)%i],e[n],e[(n+1)%i],e[(n+2)%i],r-n)):t<0?e[0]-(a(e[0],e[0],e[1],e[1],-r)-e[0]):1<t?e[i]-(a(e[i],e[i],e[i-1],e[i-1],r-i)-e[i]):a(e[n?n-1:0],e[n],e[i<n+1?i:n+1],e[i<n+2?i:n+2],r-n)},Utils:{Linear:function(e,t,i){return(t-e)*i+e},Bernstein:function(e,t){var i=TWEEN.Interpolation.Utils.Factorial;return i(e)/i(t)/i(e-t)},Factorial:(Pyb=[1],function(e){var t,i=1;if(Pyb[e])return Pyb[e];for(t=e;1<t;t--)i*=t;return Pyb[e]=i}),CatmullRom:function(e,t,i,r,n){var a=.5*(i-e),o=.5*(r-t),s=n*n;return(2*t-2*i+a+o)*(n*s)+(-3*t+3*i-2*a-o)*s+a*n+t}}};var EasingFunction={LINEAR_NONE:TWEEN.Easing.Linear.None,QUADRACTIC_IN:TWEEN.Easing.Quadratic.In,QUADRACTIC_OUT:TWEEN.Easing.Quadratic.Out,QUADRACTIC_IN_OUT:TWEEN.Easing.Quadratic.InOut,CUBIC_IN:TWEEN.Easing.Cubic.In,CUBIC_OUT:TWEEN.Easing.Cubic.Out,CUBIC_IN_OUT:TWEEN.Easing.Cubic.InOut,QUARTIC_IN:TWEEN.Easing.Quartic.In,QUARTIC_OUT:TWEEN.Easing.Quartic.Out,QUARTIC_IN_OUT:TWEEN.Easing.Quartic.InOut,QUINTIC_IN:TWEEN.Easing.Quintic.In,QUINTIC_OUT:TWEEN.Easing.Quintic.Out,QUINTIC_IN_OUT:TWEEN.Easing.Quintic.InOut,SINUSOIDAL_IN:TWEEN.Easing.Sinusoidal.In,SINUSOIDAL_OUT:TWEEN.Easing.Sinusoidal.Out,SINUSOIDAL_IN_OUT:TWEEN.Easing.Sinusoidal.InOut,EXPONENTIAL_IN:TWEEN.Easing.Exponential.In,EXPONENTIAL_OUT:TWEEN.Easing.Exponential.Out,EXPONENTIAL_IN_OUT:TWEEN.Easing.Exponential.InOut,CIRCULAR_IN:TWEEN.Easing.Circular.In,CIRCULAR_OUT:TWEEN.Easing.Circular.Out,CIRCULAR_IN_OUT:TWEEN.Easing.Circular.InOut,ELASTIC_IN:TWEEN.Easing.Elastic.In,ELASTIC_OUT:TWEEN.Easing.Elastic.Out,ELASTIC_IN_OUT:TWEEN.Easing.Elastic.InOut,BACK_IN:TWEEN.Easing.Back.In,BACK_OUT:TWEEN.Easing.Back.Out,BACK_IN_OUT:TWEEN.Easing.Back.InOut,BOUNCE_IN:TWEEN.Easing.Bounce.In,BOUNCE_OUT:TWEEN.Easing.Bounce.Out,BOUNCE_IN_OUT:TWEEN.Easing.Bounce.InOut},EasingFunction$1=freezeObject$1(EasingFunction),scratchPosition$2=new Cartesian3,scratchNormal$4=new Cartesian3,scratchTangent$2=new Cartesian3,scratchBitangent$2=new Cartesian3,scratchNormalST=new Cartesian3,defaultRadii=new Cartesian3(1,1,1),cos=Math.cos,sin=Math.sin;function EllipsoidGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.radii,defaultRadii),i=defaultValue(e.innerRadii,t),r=defaultValue(e.minimumClock,0),n=defaultValue(e.maximumClock,CesiumMath.TWO_PI),a=defaultValue(e.minimumCone,0),o=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,64)),l=Math.round(defaultValue(e.slicePartitions,64)),c=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(i),this._minimumClock=r,this._maximumClock=n,this._minimumCone=a,this._maximumCone=o,this._stackPartitions=s,this._slicePartitions=l,this._vertexFormat=VertexFormat.clone(c),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidGeometry"}EllipsoidGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+7,EllipsoidGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),i+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,i),i+=Cartesian3.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._minimumClock,t[i++]=e._maximumClock,t[i++]=e._minimumCone,t[i++]=e._maximumCone,t[i++]=e._stackPartitions,t[i++]=e._slicePartitions,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRadii=new Cartesian3,scratchInnerRadii=new Cartesian3,scratchVertexFormat$5=new VertexFormat,scratchOptions$c={radii:scratchRadii,innerRadii:scratchInnerRadii,vertexFormat:scratchVertexFormat$5,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,offsetAttribute:void 0},unitEllipsoidGeometry;EllipsoidGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchRadii);t+=Cartesian3.packedLength;var n=Cartesian3.unpack(e,t,scratchInnerRadii);t+=Cartesian3.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$5);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._radii=Cartesian3.clone(r,i._radii),i._innerRadii=Cartesian3.clone(n,i._innerRadii),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._minimumClock=o,i._maximumClock=s,i._minimumCone=l,i._maximumCone=c,i._stackPartitions=u,i._slicePartitions=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$c.minimumClock=o,scratchOptions$c.maximumClock=s,scratchOptions$c.minimumCone=l,scratchOptions$c.maximumCone=c,scratchOptions$c.stackPartitions=u,scratchOptions$c.slicePartitions=d,scratchOptions$c.offsetAttribute=-1===h?void 0:h,new EllipsoidGeometry(scratchOptions$c))},EllipsoidGeometry.createGeometry=function(e){var t=e._radii;if(!(t.x<=0||t.y<=0||t.z<=0)){var i=e._innerRadii;if(!(i.x<=0||i.y<=0||i.z<=0)){var r,n,a=e._minimumClock,o=e._maximumClock,s=e._minimumCone,l=e._maximumCone,c=e._vertexFormat,u=e._slicePartitions+1,d=e._stackPartitions+1;(u=Math.round(u*Math.abs(o-a)/CesiumMath.TWO_PI))<2&&(u=2),(d=Math.round(d*Math.abs(l-s)/CesiumMath.PI))<2&&(d=2);var h=0,p=[s],m=[a];for(r=0;r<d;r++)p.push(s+r*(l-s)/(d-1));for(p.push(l),n=0;n<u;n++)m.push(a+n*(o-a)/(u-1));m.push(o);var f=p.length,g=m.length,_=0,y=1,v=i.x!==t.x||i.y!==t.y||i.z!==t.z,C=!1,S=!1,T=!1;v&&(y=2,0<s&&(C=!0,_+=u-1),l<Math.PI&&(S=!0,_+=u-1),(o-a)%CesiumMath.TWO_PI?(T=!0,_+=2*(d-1)+1):_+=1);var x=g*f*y,b=new Float64Array(3*x),E=arrayFill(new Array(x),!1),P=arrayFill(new Array(x),!1),A=u*d*y,w=6*(A+_+1-(u+d)*y),D=IndexDatatype$1.createTypedArray(A,w),M=c.normal?new Float32Array(3*x):void 0,I=c.tangent?new Float32Array(3*x):void 0,R=c.bitangent?new Float32Array(3*x):void 0,O=c.st?new Float32Array(2*x):void 0,L=new Array(f),F=new Array(f);for(r=0;r<f;r++)L[r]=sin(p[r]),F[r]=cos(p[r]);var N=new Array(g),V=new Array(g);for(n=0;n<g;n++)V[n]=cos(m[n]),N[n]=sin(m[n]);for(r=0;r<f;r++)for(n=0;n<g;n++)b[h++]=t.x*L[r]*V[n],b[h++]=t.y*L[r]*N[n],b[h++]=t.z*F[r];var B,k,$,z,U=x/2;if(v)for(r=0;r<f;r++)for(n=0;n<g;n++)b[h++]=i.x*L[r]*V[n],b[h++]=i.y*L[r]*N[n],b[h++]=i.z*F[r],E[U]=!0,0<r&&r!==f-1&&0!==n&&n!==g-1&&(P[U]=!0),U++;for(h=0,r=1;r<f-2;r++)for(B=r*g,k=(r+1)*g,n=1;n<g-2;n++)D[h++]=k+n,D[h++]=k+n+1,D[h++]=B+n+1,D[h++]=k+n,D[h++]=B+n+1,D[h++]=B+n;if(v){var G=f*g;for(r=1;r<f-2;r++)for(B=G+r*g,k=G+(r+1)*g,n=1;n<g-2;n++)D[h++]=k+n,D[h++]=B+n,D[h++]=B+n+1,D[h++]=k+n,D[h++]=B+n+1,D[h++]=k+n+1}if(v){if(C)for(z=f*g,r=1;r<g-2;r++)D[h++]=r,D[h++]=r+1,D[h++]=z+r+1,D[h++]=r,D[h++]=z+r+1,D[h++]=z+r;if(S)for($=f*g-g,z=f*g*y-g,r=1;r<g-2;r++)D[h++]=$+r+1,D[h++]=$+r,D[h++]=z+r,D[h++]=$+r+1,D[h++]=z+r,D[h++]=z+r+1}if(T){for(r=1;r<f-2;r++)z=g*f+g*r,$=g*r,D[h++]=z,D[h++]=$+g,D[h++]=$,D[h++]=z,D[h++]=z+g,D[h++]=$+g;for(r=1;r<f-2;r++)z=g*f+g*(r+1)-1,$=g*(r+1)-1,D[h++]=$+g,D[h++]=z,D[h++]=$,D[h++]=$+g,D[h++]=z+g,D[h++]=z}var H=new GeometryAttributes;c.position&&(H.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:b}));var W,q=0,j=0,Y=0,X=0,Q=x/2,J=Ellipsoid.fromCartesian3(t),Z=Ellipsoid.fromCartesian3(i);if(c.st||c.normal||c.tangent||c.bitangent){for(r=0;r<x;r++){W=E[r]?Z:J;var K=Cartesian3.fromArray(b,3*r,scratchPosition$2),ee=W.geodeticSurfaceNormal(K,scratchNormal$4);if(P[r]&&Cartesian3.negate(ee,ee),c.st){var te=Cartesian2.negate(ee,scratchNormalST);O[q++]=Math.atan2(te.y,te.x)/CesiumMath.TWO_PI+.5,O[q++]=Math.asin(ee.z)/Math.PI+.5}if(c.normal&&(M[j++]=ee.x,M[j++]=ee.y,M[j++]=ee.z),c.tangent||c.bitangent){var ie,re=scratchTangent$2,ne=0;if(E[r]&&(ne=Q),ie=!C&&ne<=r&&r<ne+2*g?Cartesian3.UNIT_X:Cartesian3.UNIT_Z,Cartesian3.cross(ie,ee,re),Cartesian3.normalize(re,re),c.tangent&&(I[Y++]=re.x,I[Y++]=re.y,I[Y++]=re.z),c.bitangent){var ae=Cartesian3.cross(ee,re,scratchBitangent$2);Cartesian3.normalize(ae,ae),R[X++]=ae.x,R[X++]=ae.y,R[X++]=ae.z}}}c.st&&(H.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:O})),c.normal&&(H.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:M})),c.tangent&&(H.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:I})),c.bitangent&&(H.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:R}))}if(defined(e._offsetAttribute)){var oe=b.length,se=new Uint8Array(oe/3);arrayFill(se,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),H.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:se})}return new Geometry({attributes:H,indices:D,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromEllipsoid(J),offsetAttribute:e._offsetAttribute})}}},EllipsoidGeometry.getUnitEllipsoid=function(){return defined(unitEllipsoidGeometry)||(unitEllipsoidGeometry=EllipsoidGeometry.createGeometry(new EllipsoidGeometry({radii:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY}))),unitEllipsoidGeometry};var defaultRadii$1=new Cartesian3(1,1,1),cos$1=Math.cos,sin$1=Math.sin;function EllipsoidOutlineGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.radii,defaultRadii$1),i=defaultValue(e.innerRadii,t),r=defaultValue(e.minimumClock,0),n=defaultValue(e.maximumClock,CesiumMath.TWO_PI),a=defaultValue(e.minimumCone,0),o=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,10)),l=Math.round(defaultValue(e.slicePartitions,8)),c=Math.round(defaultValue(e.subdivisions,128));this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(i),this._minimumClock=r,this._maximumClock=n,this._minimumCone=a,this._maximumCone=o,this._stackPartitions=s,this._slicePartitions=l,this._subdivisions=c,this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidOutlineGeometry"}EllipsoidOutlineGeometry.packedLength=2*Cartesian3.packedLength+8,EllipsoidOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),i+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,i),i+=Cartesian3.packedLength,t[i++]=e._minimumClock,t[i++]=e._maximumClock,t[i++]=e._minimumCone,t[i++]=e._maximumCone,t[i++]=e._stackPartitions,t[i++]=e._slicePartitions,t[i++]=e._subdivisions,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRadii$1=new Cartesian3,scratchInnerRadii$1=new Cartesian3,scratchOptions$d={radii:scratchRadii$1,innerRadii:scratchInnerRadii$1,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0,offsetAttribute:void 0};function EllipsoidTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._tilingScheme=e.tilingScheme,defined(this._tilingScheme)||(this._tilingScheme=new GeographicTilingScheme({ellipsoid:defaultValue(e.ellipsoid,Ellipsoid.WGS84)})),this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,64,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._errorEvent=new Event,this._readyPromise=when.resolve(!0)}function EventHelper(){this._removalFunctions=[]}EllipsoidOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchRadii$1);t+=Cartesian3.packedLength;var n=Cartesian3.unpack(e,t,scratchInnerRadii$1);t+=Cartesian3.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._radii=Cartesian3.clone(r,i._radii),i._innerRadii=Cartesian3.clone(n,i._innerRadii),i._minimumClock=a,i._maximumClock=o,i._minimumCone=s,i._maximumCone=l,i._stackPartitions=c,i._slicePartitions=u,i._subdivisions=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$d.minimumClock=a,scratchOptions$d.maximumClock=o,scratchOptions$d.minimumCone=s,scratchOptions$d.maximumCone=l,scratchOptions$d.stackPartitions=c,scratchOptions$d.slicePartitions=u,scratchOptions$d.subdivisions=d,scratchOptions$d.offsetAttribute=-1===h?void 0:h,new EllipsoidOutlineGeometry(scratchOptions$d))},EllipsoidOutlineGeometry.createGeometry=function(e){var t=e._radii;if(!(t.x<=0||t.y<=0||t.z<=0)){var i=e._innerRadii;if(!(i.x<=0||i.y<=0||i.z<=0)){var r=e._minimumClock,n=e._maximumClock,a=e._minimumCone,o=e._maximumCone,s=e._subdivisions,l=Ellipsoid.fromCartesian3(t),c=e._slicePartitions+1,u=e._stackPartitions+1;(c=Math.round(c*Math.abs(n-r)/CesiumMath.TWO_PI))<2&&(c=2),(u=Math.round(u*Math.abs(o-a)/CesiumMath.PI))<2&&(u=2);var d=0,h=1,p=i.x!==t.x||i.y!==t.y||i.z!==t.z,m=!1,f=!1;p&&(h=2,0<a&&(m=!0,d+=c),o<Math.PI&&(f=!0,d+=c));var g,_,y,v,C=s*h*(u+c),S=new Float64Array(3*C),T=2*(C+d-(c+u)*h),x=IndexDatatype$1.createTypedArray(C,T),b=0,E=new Array(u),P=new Array(u);for(g=0;g<u;g++)v=a+g*(o-a)/(u-1),E[g]=sin$1(v),P[g]=cos$1(v);var A=new Array(s),w=new Array(s);for(g=0;g<s;g++)y=r+g*(n-r)/(s-1),A[g]=sin$1(y),w[g]=cos$1(y);for(g=0;g<u;g++)for(_=0;_<s;_++)S[b++]=t.x*E[g]*w[_],S[b++]=t.y*E[g]*A[_],S[b++]=t.z*P[g];if(p)for(g=0;g<u;g++)for(_=0;_<s;_++)S[b++]=i.x*E[g]*w[_],S[b++]=i.y*E[g]*A[_],S[b++]=i.z*P[g];for(E.length=s,P.length=s,g=0;g<s;g++)v=a+g*(o-a)/(s-1),E[g]=sin$1(v),P[g]=cos$1(v);for(A.length=c,w.length=c,g=0;g<c;g++)y=r+g*(n-r)/(c-1),A[g]=sin$1(y),w[g]=cos$1(y);for(g=0;g<s;g++)for(_=0;_<c;_++)S[b++]=t.x*E[g]*w[_],S[b++]=t.y*E[g]*A[_],S[b++]=t.z*P[g];if(p)for(g=0;g<s;g++)for(_=0;_<c;_++)S[b++]=i.x*E[g]*w[_],S[b++]=i.y*E[g]*A[_],S[b++]=i.z*P[g];for(g=b=0;g<u*h;g++){var D=g*s;for(_=0;_<s-1;_++)x[b++]=D+_,x[b++]=D+_+1}var M=u*s*h;for(g=0;g<c;g++)for(_=0;_<s-1;_++)x[b++]=M+g+_*c,x[b++]=M+g+(_+1)*c;if(p)for(M=u*s*h+c*s,g=0;g<c;g++)for(_=0;_<s-1;_++)x[b++]=M+g+_*c,x[b++]=M+g+(_+1)*c;if(p){var I=u*s*h,R=I+s*c;if(m)for(g=0;g<c;g++)x[b++]=I+g,x[b++]=R+g;if(f)for(I+=s*c-c,R+=s*c-c,g=0;g<c;g++)x[b++]=I+g,x[b++]=R+g}var O=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:S})});if(defined(e._offsetAttribute)){var L=S.length,F=new Uint8Array(L/3);arrayFill(F,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),O.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:F})}return new Geometry({attributes:O,indices:x,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromEllipsoid(l),offsetAttribute:e._offsetAttribute})}}},defineProperties$1(EllipsoidTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),EllipsoidTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}))},EllipsoidTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},EllipsoidTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},EllipsoidTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){},EventHelper.prototype.add=function(e,t,i){var r=e.addEventListener(t,i);this._removalFunctions.push(r);var n=this;return function(){r();var e=n._removalFunctions;e.splice(e.indexOf(r),1)}},EventHelper.prototype.removeAll=function(){for(var e=this._removalFunctions,t=0,i=e.length;t<i;++t)e[t]();e.length=0};var ExtrapolationType={NONE:0,HOLD:1,EXTRAPOLATE:2},ExtrapolationType$1=freezeObject$1(ExtrapolationType);function OrthographicOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._orthographicMatrix=new Matrix4}function update(e){e.top===e._top&&e.bottom===e._bottom&&e.left===e._left&&e.right===e._right&&e.near===e._near&&e.far===e._far||(e._left=e.left,e._right=e.right,e._top=e.top,e._bottom=e.bottom,e._near=e.near,e._far=e.far,e._orthographicMatrix=Matrix4.computeOrthographicOffCenter(e.left,e.right,e.bottom,e.top,e.near,e.far,e._orthographicMatrix))}defineProperties$1(OrthographicOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update(this),this._orthographicMatrix}}});var getPlanesRight=new Cartesian3,getPlanesNearCenter=new Cartesian3,getPlanesPoint=new Cartesian3,negateScratch=new Cartesian3;function OrthographicFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new OrthographicOffCenterFrustum,this.width=e.width,this._width=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far}function update$1(e){var t=e._offCenterFrustum;if(e.width!==e._width||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far){e._aspectRatio=e.aspectRatio,e._width=e.width,e._near=e.near,e._far=e.far;var i=1/e.aspectRatio;t.right=.5*e.width,t.left=-t.right,t.top=i*t.right,t.bottom=-t.top,t.near=e.near,t.far=e.far}}function PerspectiveOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._perspectiveMatrix=new Matrix4,this._infinitePerspective=new Matrix4}function update$2(e){var t=e.top,i=e.bottom,r=e.right,n=e.left,a=e.near,o=e.far;t===e._top&&i===e._bottom&&n===e._left&&r===e._right&&a===e._near&&o===e._far||(e._left=n,e._right=r,e._top=t,e._bottom=i,e._near=a,e._far=o,e._perspectiveMatrix=Matrix4.computePerspectiveOffCenter(n,r,i,t,a,o,e._perspectiveMatrix),e._infinitePerspective=Matrix4.computeInfinitePerspectiveOffCenter(n,r,i,t,a,e._infinitePerspective))}OrthographicOffCenterFrustum.prototype.computeCullingVolume=function(e,t,i){var r=this._cullingVolume.planes,n=this.top,a=this.bottom,o=this.right,s=this.left,l=this.near,c=this.far,u=Cartesian3.cross(t,i,getPlanesRight);Cartesian3.normalize(u,u);var d=getPlanesNearCenter;Cartesian3.multiplyByScalar(t,l,d),Cartesian3.add(e,d,d);var h=getPlanesPoint;Cartesian3.multiplyByScalar(u,s,h),Cartesian3.add(d,h,h);var p=r[0];return defined(p)||(p=r[0]=new Cartesian4),p.x=u.x,p.y=u.y,p.z=u.z,p.w=-Cartesian3.dot(u,h),Cartesian3.multiplyByScalar(u,o,h),Cartesian3.add(d,h,h),defined(p=r[1])||(p=r[1]=new Cartesian4),p.x=-u.x,p.y=-u.y,p.z=-u.z,p.w=-Cartesian3.dot(Cartesian3.negate(u,negateScratch),h),Cartesian3.multiplyByScalar(i,a,h),Cartesian3.add(d,h,h),defined(p=r[2])||(p=r[2]=new Cartesian4),p.x=i.x,p.y=i.y,p.z=i.z,p.w=-Cartesian3.dot(i,h),Cartesian3.multiplyByScalar(i,n,h),Cartesian3.add(d,h,h),defined(p=r[3])||(p=r[3]=new Cartesian4),p.x=-i.x,p.y=-i.y,p.z=-i.z,p.w=-Cartesian3.dot(Cartesian3.negate(i,negateScratch),h),defined(p=r[4])||(p=r[4]=new Cartesian4),p.x=t.x,p.y=t.y,p.z=t.z,p.w=-Cartesian3.dot(t,d),Cartesian3.multiplyByScalar(t,c,h),Cartesian3.add(e,h,h),defined(p=r[5])||(p=r[5]=new Cartesian4),p.x=-t.x,p.y=-t.y,p.z=-t.z,p.w=-Cartesian3.dot(Cartesian3.negate(t,negateScratch),h),this._cullingVolume},OrthographicOffCenterFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){update(this),r instanceof Cartesian2&&(n=r,r=1,deprecationWarning("getPixelDimensions-parameter-change","getPixelDimensions now takes a pixelRatio argument before the result argument in Cesium 1.63. The previous function definition will no longer work in 1.65."));var a=r*(this.right-this.left)/e,o=r*(this.top-this.bottom)/t;return n.x=a,n.y=o,n},OrthographicOffCenterFrustum.prototype.clone=function(e){return defined(e)||(e=new OrthographicOffCenterFrustum),e.left=this.left,e.right=this.right,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},OrthographicOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof OrthographicOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},OrthographicOffCenterFrustum.prototype.equalsEpsilon=function(e,t,i){return e===this||defined(e)&&e instanceof OrthographicOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,i)&&CesiumMath.equalsEpsilon(this.left,e.left,t,i)&&CesiumMath.equalsEpsilon(this.top,e.top,t,i)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,i)&&CesiumMath.equalsEpsilon(this.near,e.near,t,i)&&CesiumMath.equalsEpsilon(this.far,e.far,t,i)},OrthographicFrustum.packedLength=4,OrthographicFrustum.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.width,t[i++]=e.aspectRatio,t[i++]=e.near,t[i]=e.far,t},OrthographicFrustum.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new OrthographicFrustum),i.width=e[t++],i.aspectRatio=e[t++],i.near=e[t++],i.far=e[t],i},defineProperties$1(OrthographicFrustum.prototype,{projectionMatrix:{get:function(){return update$1(this),this._offCenterFrustum.projectionMatrix}}}),OrthographicFrustum.prototype.computeCullingVolume=function(e,t,i){return update$1(this),this._offCenterFrustum.computeCullingVolume(e,t,i)},OrthographicFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){return update$1(this),r instanceof Cartesian2&&(n=r,r=1,deprecationWarning("getPixelDimensions-parameter-change","getPixelDimensions now takes a pixelRatio argument before the result argument in Cesium 1.63. The previous function definition will no longer work in 1.65.")),this._offCenterFrustum.getPixelDimensions(e,t,i,r,n)},OrthographicFrustum.prototype.clone=function(e){return defined(e)||(e=new OrthographicFrustum),e.aspectRatio=this.aspectRatio,e.width=this.width,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._width=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},OrthographicFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$1(this),update$1(e),this.width===e.width&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},OrthographicFrustum.prototype.equalsEpsilon=function(e,t,i){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$1(this),update$1(e),CesiumMath.equalsEpsilon(this.width,e.width,t,i)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,i)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,i))},defineProperties$1(PerspectiveOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update$2(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return update$2(this),this._infinitePerspective}}});var getPlanesRight$1=new Cartesian3,getPlanesNearCenter$1=new Cartesian3,getPlanesFarCenter=new Cartesian3,getPlanesNormal=new Cartesian3;function PerspectiveFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new PerspectiveOffCenterFrustum,this.fov=e.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this.xOffset=defaultValue(e.xOffset,0),this._xOffset=this.xOffset,this.yOffset=defaultValue(e.yOffset,0),this._yOffset=this.yOffset}function update$3(e){var t=e._offCenterFrustum;e.fov===e._fov&&e.aspectRatio===e._aspectRatio&&e.near===e._near&&e.far===e._far&&e.xOffset===e._xOffset&&e.yOffset===e._yOffset||(e._aspectRatio=e.aspectRatio,e._fov=e.fov,e._fovy=e.aspectRatio<=1?e.fov:2*Math.atan(Math.tan(.5*e.fov)/e.aspectRatio),e._near=e.near,e._far=e.far,e._sseDenominator=2*Math.tan(.5*e._fovy),e._xOffset=e.xOffset,e._yOffset=e.yOffset,t.top=e.near*Math.tan(.5*e._fovy),t.bottom=-t.top,t.right=e.aspectRatio*t.top,t.left=-t.right,t.near=e.near,t.far=e.far,t.right+=e.xOffset,t.left+=e.xOffset,t.top+=e.yOffset,t.bottom+=e.yOffset)}PerspectiveOffCenterFrustum.prototype.computeCullingVolume=function(e,t,i){var r=this._cullingVolume.planes,n=this.top,a=this.bottom,o=this.right,s=this.left,l=this.near,c=this.far,u=Cartesian3.cross(t,i,getPlanesRight$1),d=getPlanesNearCenter$1;Cartesian3.multiplyByScalar(t,l,d),Cartesian3.add(e,d,d);var h=getPlanesFarCenter;Cartesian3.multiplyByScalar(t,c,h),Cartesian3.add(e,h,h);var p=getPlanesNormal;Cartesian3.multiplyByScalar(u,s,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.normalize(p,p),Cartesian3.cross(p,i,p),Cartesian3.normalize(p,p);var m=r[0];return defined(m)||(m=r[0]=new Cartesian4),m.x=p.x,m.y=p.y,m.z=p.z,m.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(u,o,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(i,p,p),Cartesian3.normalize(p,p),defined(m=r[1])||(m=r[1]=new Cartesian4),m.x=p.x,m.y=p.y,m.z=p.z,m.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(i,a,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(u,p,p),Cartesian3.normalize(p,p),defined(m=r[2])||(m=r[2]=new Cartesian4),m.x=p.x,m.y=p.y,m.z=p.z,m.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(i,n,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(p,u,p),Cartesian3.normalize(p,p),defined(m=r[3])||(m=r[3]=new Cartesian4),m.x=p.x,m.y=p.y,m.z=p.z,m.w=-Cartesian3.dot(p,e),defined(m=r[4])||(m=r[4]=new Cartesian4),m.x=t.x,m.y=t.y,m.z=t.z,m.w=-Cartesian3.dot(t,d),Cartesian3.negate(t,p),defined(m=r[5])||(m=r[5]=new Cartesian4),m.x=p.x,m.y=p.y,m.z=p.z,m.w=-Cartesian3.dot(p,h),this._cullingVolume},PerspectiveOffCenterFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){update$2(this),r instanceof Cartesian2&&(n=r,r=1,deprecationWarning("getPixelDimensions-parameter-change","getPixelDimensions now takes a pixelRatio argument before the result argument in Cesium 1.63. The previous function definition will no longer work in 1.65."));var a=1/this.near,o=this.top*a,s=2*r*i*o/t,l=2*r*i*(o=this.right*a)/e;return n.x=l,n.y=s,n},PerspectiveOffCenterFrustum.prototype.clone=function(e){return defined(e)||(e=new PerspectiveOffCenterFrustum),e.right=this.right,e.left=this.left,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},PerspectiveOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof PerspectiveOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},PerspectiveOffCenterFrustum.prototype.equalsEpsilon=function(e,t,i){return e===this||defined(e)&&e instanceof PerspectiveOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,i)&&CesiumMath.equalsEpsilon(this.left,e.left,t,i)&&CesiumMath.equalsEpsilon(this.top,e.top,t,i)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,i)&&CesiumMath.equalsEpsilon(this.near,e.near,t,i)&&CesiumMath.equalsEpsilon(this.far,e.far,t,i)},PerspectiveFrustum.packedLength=6,PerspectiveFrustum.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.fov,t[i++]=e.aspectRatio,t[i++]=e.near,t[i++]=e.far,t[i++]=e.xOffset,t[i]=e.yOffset,t},PerspectiveFrustum.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new PerspectiveFrustum),i.fov=e[t++],i.aspectRatio=e[t++],i.near=e[t++],i.far=e[t++],i.xOffset=e[t++],i.yOffset=e[t],i},defineProperties$1(PerspectiveFrustum.prototype,{projectionMatrix:{get:function(){return update$3(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return update$3(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return update$3(this),this._fovy}},sseDenominator:{get:function(){return update$3(this),this._sseDenominator}}}),PerspectiveFrustum.prototype.computeCullingVolume=function(e,t,i){return update$3(this),this._offCenterFrustum.computeCullingVolume(e,t,i)},PerspectiveFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){return update$3(this),r instanceof Cartesian2&&(n=r,r=1,deprecationWarning("getPixelDimensions-parameter-change","getPixelDimensions now takes a pixelRatio argument before the result argument in Cesium 1.63. The previous function definition will no longer work in 1.65.")),this._offCenterFrustum.getPixelDimensions(e,t,i,r,n)},PerspectiveFrustum.prototype.clone=function(e){return defined(e)||(e=new PerspectiveFrustum),e.aspectRatio=this.aspectRatio,e.fov=this.fov,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._fov=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},PerspectiveFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$3(this),update$3(e),this.fov===e.fov&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},PerspectiveFrustum.prototype.equalsEpsilon=function(e,t,i){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$3(this),update$3(e),CesiumMath.equalsEpsilon(this.fov,e.fov,t,i)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,i)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,i))};var PERSPECTIVE=0,ORTHOGRAPHIC=1;function FrustumGeometry(e){var t,i,r=e.frustum,n=e.orientation,a=e.origin,o=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),s=defaultValue(e._drawNearPlane,!0);r instanceof PerspectiveFrustum?(t=PERSPECTIVE,i=PerspectiveFrustum.packedLength):r instanceof OrthographicFrustum&&(t=ORTHOGRAPHIC,i=OrthographicFrustum.packedLength),this._frustumType=t,this._frustum=r.clone(),this._origin=Cartesian3.clone(a),this._orientation=Quaternion.clone(n),this._drawNearPlane=s,this._vertexFormat=o,this._workerName="createFrustumGeometry",this.packedLength=2+i+Cartesian3.packedLength+Quaternion.packedLength+VertexFormat.packedLength}FrustumGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._frustumType,n=e._frustum;return(t[i++]=r)===PERSPECTIVE?(PerspectiveFrustum.pack(n,t,i),i+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(n,t,i),i+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,i),i+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,i),i+=Quaternion.packedLength,VertexFormat.pack(e._vertexFormat,t,i),t[i+=VertexFormat.packedLength]=e._drawNearPlane?1:0,t};var scratchPackPerspective=new PerspectiveFrustum,scratchPackOrthographic=new OrthographicFrustum,scratchPackQuaternion=new Quaternion,scratchPackorigin=new Cartesian3,scratchVertexFormat$6=new VertexFormat;function getAttributes(e,t,i,r,n,a,o,s){for(var l=e/3*2,c=0;c<4;++c)defined(t)&&(t[e]=a.x,t[e+1]=a.y,t[e+2]=a.z),defined(i)&&(i[e]=o.x,i[e+1]=o.y,i[e+2]=o.z),defined(r)&&(r[e]=s.x,r[e+1]=s.y,r[e+2]=s.z),e+=3;n[l]=0,n[1+l]=0,n[2+l]=1,n[3+l]=0,n[4+l]=1,n[5+l]=1,n[6+l]=0,n[7+l]=1}FrustumGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r,n=e[t++];n===PERSPECTIVE?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic),t+=OrthographicFrustum.packedLength);var a=Cartesian3.unpack(e,t,scratchPackorigin);t+=Cartesian3.packedLength;var o=Quaternion.unpack(e,t,scratchPackQuaternion);t+=Quaternion.packedLength;var s=VertexFormat.unpack(e,t,scratchVertexFormat$6),l=1===e[t+=VertexFormat.packedLength];if(!defined(i))return new FrustumGeometry({frustum:r,origin:a,orientation:o,vertexFormat:s,_drawNearPlane:l});var c=n===i._frustumType?i._frustum:void 0;return i._frustum=r.clone(c),i._frustumType=n,i._origin=Cartesian3.clone(a,i._origin),i._orientation=Quaternion.clone(o,i._orientation),i._vertexFormat=VertexFormat.clone(s,i._vertexFormat),i._drawNearPlane=l,i};var scratchRotationMatrix=new Matrix3,scratchViewMatrix=new Matrix4,scratchInverseMatrix=new Matrix4,scratchXDirection=new Cartesian3,scratchYDirection=new Cartesian3,scratchZDirection=new Cartesian3,scratchNegativeX=new Cartesian3,scratchNegativeY=new Cartesian3,scratchNegativeZ=new Cartesian3,frustumSplits=new Array(3),frustumCornersNDC=new Array(4);frustumCornersNDC[0]=new Cartesian4(-1,-1,1,1),frustumCornersNDC[1]=new Cartesian4(1,-1,1,1),frustumCornersNDC[2]=new Cartesian4(1,1,1,1),frustumCornersNDC[3]=new Cartesian4(-1,1,1,1);for(var scratchFrustumCorners=new Array(4),i$1=0;i$1<4;++i$1)scratchFrustumCorners[i$1]=new Cartesian4;FrustumGeometry._computeNearFarPlanes=function(e,t,i,r,n,a,o,s){var l=Matrix3.fromQuaternion(t,scratchRotationMatrix),c=defaultValue(a,scratchXDirection),u=defaultValue(o,scratchYDirection),d=defaultValue(s,scratchZDirection);c=Matrix3.getColumn(l,0,c),u=Matrix3.getColumn(l,1,u),d=Matrix3.getColumn(l,2,d),Cartesian3.normalize(c,c),Cartesian3.normalize(u,u),Cartesian3.normalize(d,d),Cartesian3.negate(c,c);var h,p,m=Matrix4.computeView(e,d,u,c,scratchViewMatrix);if(i===PERSPECTIVE){var f=r.projectionMatrix,g=Matrix4.multiply(f,m,scratchInverseMatrix);p=Matrix4.inverse(g,scratchInverseMatrix)}else h=Matrix4.inverseTransformation(m,scratchInverseMatrix);defined(p)?(frustumSplits[0]=r.near,frustumSplits[1]=r.far):(frustumSplits[0]=0,frustumSplits[1]=r.near,frustumSplits[2]=r.far);for(var _=0;_<2;++_)for(var y=0;y<4;++y){var v=Cartesian4.clone(frustumCornersNDC[y],scratchFrustumCorners[y]);if(defined(p)){var C=1/(v=Matrix4.multiplyByVector(p,v,v)).w;Cartesian3.multiplyByScalar(v,C,v),Cartesian3.subtract(v,e,v),Cartesian3.normalize(v,v);var S=Cartesian3.dot(d,v);Cartesian3.multiplyByScalar(v,frustumSplits[_]/S,v),Cartesian3.add(v,e,v)}else{defined(r._offCenterFrustum)&&(r=r._offCenterFrustum);var T=frustumSplits[_],x=frustumSplits[_+1];v.x=.5*(v.x*(r.right-r.left)+r.left+r.right),v.y=.5*(v.y*(r.top-r.bottom)+r.bottom+r.top),v.z=.5*(v.z*(T-x)-T-x),v.w=1,Matrix4.multiplyByVector(h,v,v)}n[12*_+3*y]=v.x,n[12*_+3*y+1]=v.y,n[12*_+3*y+2]=v.z}},FrustumGeometry.createGeometry=function(e){var t=e._frustumType,i=e._frustum,r=e._origin,n=e._orientation,a=e._drawNearPlane,o=e._vertexFormat,s=a?6:5,l=new Float64Array(72);FrustumGeometry._computeNearFarPlanes(r,n,t,i,l);var c=24;l[c]=l[12],l[c+1]=l[13],l[c+2]=l[14],l[c+3]=l[0],l[c+4]=l[1],l[c+5]=l[2],l[c+6]=l[9],l[c+7]=l[10],l[c+8]=l[11],l[c+9]=l[21],l[c+10]=l[22],l[c+11]=l[23],l[c+=12]=l[15],l[c+1]=l[16],l[c+2]=l[17],l[c+3]=l[3],l[c+4]=l[4],l[c+5]=l[5],l[c+6]=l[0],l[c+7]=l[1],l[c+8]=l[2],l[c+9]=l[12],l[c+10]=l[13],l[c+11]=l[14],l[c+=12]=l[3],l[c+1]=l[4],l[c+2]=l[5],l[c+3]=l[15],l[c+4]=l[16],l[c+5]=l[17],l[c+6]=l[18],l[c+7]=l[19],l[c+8]=l[20],l[c+9]=l[6],l[c+10]=l[7],l[c+11]=l[8],l[c+=12]=l[6],l[c+1]=l[7],l[c+2]=l[8],l[c+3]=l[18],l[c+4]=l[19],l[c+5]=l[20],l[c+6]=l[21],l[c+7]=l[22],l[c+8]=l[23],l[c+9]=l[9],l[c+10]=l[10],l[c+11]=l[11],a||(l=l.subarray(12));var u=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})});if(defined(o.normal)||defined(o.tangent)||defined(o.bitangent)||defined(o.st)){var d=defined(o.normal)?new Float32Array(12*s):void 0,h=defined(o.tangent)?new Float32Array(12*s):void 0,p=defined(o.bitangent)?new Float32Array(12*s):void 0,m=defined(o.st)?new Float32Array(8*s):void 0,f=scratchXDirection,g=scratchYDirection,_=scratchZDirection,y=Cartesian3.negate(f,scratchNegativeX),v=Cartesian3.negate(g,scratchNegativeY),C=Cartesian3.negate(_,scratchNegativeZ);c=0,a&&(getAttributes(c,d,h,p,m,C,f,g),c+=12),getAttributes(c,d,h,p,m,_,y,g),getAttributes(c+=12,d,h,p,m,y,C,g),getAttributes(c+=12,d,h,p,m,v,C,y),getAttributes(c+=12,d,h,p,m,f,_,g),getAttributes(c+=12,d,h,p,m,g,_,y),defined(d)&&(u.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),defined(h)&&(u.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),defined(p)&&(u.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),defined(m)&&(u.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:m}))}for(var S=new Uint16Array(6*s),T=0;T<s;++T){var x=6*T,b=4*T;S[x]=b,S[1+x]=1+b,S[2+x]=2+b,S[3+x]=b,S[4+x]=2+b,S[5+x]=3+b}return new Geometry({attributes:u,indices:S,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromVertices(l)})};var PERSPECTIVE$1=0,ORTHOGRAPHIC$1=1;function FrustumOutlineGeometry(e){var t,i,r=e.frustum,n=e.orientation,a=e.origin,o=defaultValue(e._drawNearPlane,!0);r instanceof PerspectiveFrustum?(t=PERSPECTIVE$1,i=PerspectiveFrustum.packedLength):r instanceof OrthographicFrustum&&(t=ORTHOGRAPHIC$1,i=OrthographicFrustum.packedLength),this._frustumType=t,this._frustum=r.clone(),this._origin=Cartesian3.clone(a),this._orientation=Quaternion.clone(n),this._drawNearPlane=o,this._workerName="createFrustumOutlineGeometry",this.packedLength=2+i+Cartesian3.packedLength+Quaternion.packedLength}FrustumOutlineGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._frustumType,n=e._frustum;return(t[i++]=r)===PERSPECTIVE$1?(PerspectiveFrustum.pack(n,t,i),i+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(n,t,i),i+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,i),i+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,i),t[i+=Quaternion.packedLength]=e._drawNearPlane?1:0,t};var scratchPackPerspective$1=new PerspectiveFrustum,scratchPackOrthographic$1=new OrthographicFrustum,scratchPackQuaternion$1=new Quaternion,scratchPackorigin$1=new Cartesian3;FrustumOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r,n=e[t++];n===PERSPECTIVE$1?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective$1),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic$1),t+=OrthographicFrustum.packedLength);var a=Cartesian3.unpack(e,t,scratchPackorigin$1);t+=Cartesian3.packedLength;var o=Quaternion.unpack(e,t,scratchPackQuaternion$1),s=1===e[t+=Quaternion.packedLength];if(!defined(i))return new FrustumOutlineGeometry({frustum:r,origin:a,orientation:o,_drawNearPlane:s});var l=n===i._frustumType?i._frustum:void 0;return i._frustum=r.clone(l),i._frustumType=n,i._origin=Cartesian3.clone(a,i._origin),i._orientation=Quaternion.clone(o,i._orientation),i._drawNearPlane=s,i},FrustumOutlineGeometry.createGeometry=function(e){var t=e._frustumType,i=e._frustum,r=e._origin,n=e._orientation,a=e._drawNearPlane,o=new Float64Array(24);FrustumGeometry._computeNearFarPlanes(r,n,t,i,o);for(var s,l,c=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:o})}),u=a?2:1,d=new Uint16Array(8*(1+u)),h=a?0:1;h<2;++h)l=4*h,d[s=a?8*h:0]=l,d[s+1]=l+1,d[s+2]=l+1,d[s+3]=l+2,d[s+4]=l+2,d[s+5]=l+3,d[s+6]=l+3,d[s+7]=l;for(h=0;h<2;++h)l=4*h,d[s=8*(u+h)]=l,d[s+1]=l+4,d[s+2]=l+1,d[s+3]=l+5,d[s+4]=l+2,d[s+5]=l+6,d[s+6]=l+3,d[s+7]=l+7;return new Geometry({attributes:c,indices:d,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromVertices(o)})};var GeocodeType={SEARCH:0,AUTOCOMPLETE:1},GeocodeType$1=freezeObject$1(GeocodeType);function GeocoderService(){}function GeometryInstanceAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.value=e.value}GeocoderService.prototype.geocode=DeveloperError.throwInstantiationError;var tmp$1={};!function(global,undefined$1){var BGb,CGb,DGb;BGb={1:[function(e,t,i){t.exports=function(e,t){for(var i=[],r=2;r<arguments.length;)i.push(arguments[r++]);var a=!0;return new Promise(function(r,n){i.push(function(e){if(a)if(a=!1,e)n(e);else{for(var t=[],i=1;i<arguments.length;)t.push(arguments[i++]);r.apply(null,t)}});try{e.apply(t||this,i)}catch(e){a&&(a=!1,n(e))}})}},{}],2:[function(e,t,i){var r=i;r.length=function(e){var t=e.length;if(!t)return 0;for(var i=0;1<--t%4&&"="===e.charAt(t);)++i;return Math.ceil(3*e.length)/4-i};for(var l=new Array(64),c=new Array(123),n=0;n<64;)c[l[n]=n<26?n+65:n<52?n+71:n<62?n-4:n-59|43]=n++;r.encode=function(e,t,i){for(var r,n=[],a=0,o=0;t<i;){var s=e[t++];switch(o){case 0:n[a++]=l[s>>2],r=(3&s)<<4,o=1;break;case 1:n[a++]=l[r|s>>4],r=(15&s)<<2,o=2;break;case 2:n[a++]=l[r|s>>6],n[a++]=l[63&s],o=0}}return o&&(n[a++]=l[r],n[a]=61,1===o&&(n[a+1]=61)),String.fromCharCode.apply(String,n)};var u="invalid encoding";r.decode=function(e,t,i){for(var r,n=i,a=0,o=0;o<e.length;){var s=e.charCodeAt(o++);if(61===s&&1<a)break;if((s=c[s])===undefined$1)throw Error(u);switch(a){case 0:r=s,a=1;break;case 1:t[i++]=r<<2|(48&s)>>4,r=s,a=2;break;case 2:t[i++]=(15&r)<<4|(60&s)>>2,r=s,a=3;break;case 3:t[i++]=(3&r)<<6|s,a=0}}if(1===a)throw Error(u);return i-n},r.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)}},{}],3:[function(e,t,i){function r(){this._listeners={}}(t.exports=r).prototype.on=function(e,t,i){return(this._listeners[e]||(this._listeners[e]=[])).push({fn:t,ctx:i||this}),this},r.prototype.off=function(e,t){if(e===undefined$1)this._listeners={};else if(t===undefined$1)this._listeners[e]=[];else for(var i=this._listeners[e],r=0;r<i.length;)i[r].fn===t?i.splice(r,1):++r;return this},r.prototype.emit=function(e){var t=this._listeners[e];if(t){for(var i=[],r=1;r<arguments.length;)i.push(arguments[r++]);for(r=0;r<t.length;)t[r].fn.apply(t[r++].ctx,i)}return this}},{}],4:[function(require,module,exports){function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(e){}return null}module.exports=inquire},{}],5:[function(e,t,i){t.exports=function(i,r,e){var n=e||8192,a=n>>>1,o=null,s=n;return function(e){if(e<1||a<e)return i(e);n<s+e&&(o=i(n),s=0);var t=r.call(o,s,s+=e);return 7&s&&(s=1+(7|s)),t}}},{}],6:[function(e,t,i){var r=i;r.length=function(e){for(var t=0,i=0,r=0;r<e.length;++r)(i=e.charCodeAt(r))<128?t+=1:i<2048?t+=2:55296==(64512&i)&&56320==(64512&e.charCodeAt(r+1))?(++r,t+=4):t+=3;return t},r.read=function(e,t,i){if(i-t<1)return"";for(var r,n=null,a=[],o=0;t<i;)(r=e[t++])<128?a[o++]=r:191<r&&r<224?a[o++]=(31&r)<<6|63&e[t++]:239<r&&r<365?(r=((7&r)<<18|(63&e[t++])<<12|(63&e[t++])<<6|63&e[t++])-65536,a[o++]=55296+(r>>10),a[o++]=56320+(1023&r)):a[o++]=(15&r)<<12|(63&e[t++])<<6|63&e[t++],8191<o&&((n=n||[]).push(String.fromCharCode.apply(String,a)),o=0);return n?(o&&n.push(String.fromCharCode.apply(String,a.slice(0,o))),n.join("")):String.fromCharCode.apply(String,a.slice(0,o))},r.write=function(e,t,i){for(var r,n,a=i,o=0;o<e.length;++o)(r=e.charCodeAt(o))<128?t[i++]=r:(r<2048?t[i++]=r>>6|192:(55296==(64512&r)&&56320==(64512&(n=e.charCodeAt(o+1)))?(r=65536+((1023&r)<<10)+(1023&n),++o,t[i++]=r>>18|240,t[i++]=r>>12&63|128):t[i++]=r>>12|224,t[i++]=r>>6&63|128),t[i++]=63&r|128);return i-a}},{}],7:[function(e,t,i){var r=i;function n(){r.Reader._configure(r.BufferReader),r.util._configure()}r.build="minimal",r.roots={},r.Writer=e(14),r.BufferWriter=e(15),r.Reader=e(8),r.BufferReader=e(9),r.util=e(13),r.rpc=e(10),r.configure=n,r.Writer._configure(r.BufferWriter),n()},{10:10,13:13,14:14,15:15,8:8,9:9}],8:[function(e,t,i){t.exports=l;var r,n=e(13),a=n.LongBits,o=n.utf8;function s(e,t){return RangeError("index out of range: "+e.pos+" + "+(t||1)+" > "+e.len)}function l(e){this.buf=e,this.pos=0,this.len=e.length}var c,u="undefined"!=typeof Uint8Array?function(e){if(e instanceof Uint8Array||Array.isArray(e))return new l(e);throw Error("illegal buffer")}:function(e){if(Array.isArray(e))return new l(e);throw Error("illegal buffer")};function d(){var e=new a(0,0),t=0;if(!(4<this.len-this.pos)){for(;t<3;++t){if(this.pos>=this.len)throw s(this);if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e}return e.lo=(e.lo|(127&this.buf[this.pos++])<<7*t)>>>0,e}for(;t<4;++t)if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e;if(e.lo=(e.lo|(127&this.buf[this.pos])<<28)>>>0,e.hi=(e.hi|(127&this.buf[this.pos])>>4)>>>0,this.buf[this.pos++]<128)return e;if(t=0,4<this.len-this.pos){for(;t<5;++t)if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}else for(;t<5;++t){if(this.pos>=this.len)throw s(this);if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}throw Error("invalid varint encoding")}function h(e,t){return(e[t-4]|e[t-3]<<8|e[t-2]<<16|e[t-1]<<24)>>>0}function p(){if(this.pos+8>this.len)throw s(this,8);return new a(h(this.buf,this.pos+=4),h(this.buf,this.pos+=4))}l.create=n.Buffer?function(e){return(l.create=function(e){return n.Buffer.isBuffer(e)?new r(e):u(e)})(e)}:u,l.prototype._slice=n.Array.prototype.subarray||n.Array.prototype.slice,l.prototype.uint32=(c=4294967295,function(){if(c=(127&this.buf[this.pos])>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<7)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<14)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<21)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(15&this.buf[this.pos])<<28)>>>0,this.buf[this.pos++]<128)return c;if((this.pos+=5)>this.len)throw this.pos=this.len,s(this,10);return c}),l.prototype.int32=function(){return 0|this.uint32()},l.prototype.sint32=function(){var e=this.uint32();return e>>>1^-(1&e)|0},l.prototype.bool=function(){return 0!==this.uint32()},l.prototype.fixed32=function(){if(this.pos+4>this.len)throw s(this,4);return h(this.buf,this.pos+=4)},l.prototype.sfixed32=function(){if(this.pos+4>this.len)throw s(this,4);return 0|h(this.buf,this.pos+=4)};var m,f,g="undefined"!=typeof Float32Array?(m=new Float32Array(1),f=new Uint8Array(m.buffer),m[0]=-0,f[3]?function(e,t){return f[0]=e[t],f[1]=e[t+1],f[2]=e[t+2],f[3]=e[t+3],m[0]}:function(e,t){return f[0]=e[t+3],f[1]=e[t+2],f[2]=e[t+1],f[3]=e[t],m[0]}):function(e,t){var i=h(e,t+4),r=2*(i>>31)+1,n=i>>>23&255,a=8388607&i;return 255==n?a?NaN:1/0*r:0==n?1401298464324817e-60*r*a:r*Math.pow(2,n-150)*(8388608+a)};l.prototype.float=function(){if(this.pos+4>this.len)throw s(this,4);var e=g(this.buf,this.pos);return this.pos+=4,e};var _,y,v="undefined"!=typeof Float64Array?(_=new Float64Array(1),y=new Uint8Array(_.buffer),_[0]=-0,y[7]?function(e,t){return y[0]=e[t],y[1]=e[t+1],y[2]=e[t+2],y[3]=e[t+3],y[4]=e[t+4],y[5]=e[t+5],y[6]=e[t+6],y[7]=e[t+7],_[0]}:function(e,t){return y[0]=e[t+7],y[1]=e[t+6],y[2]=e[t+5],y[3]=e[t+4],y[4]=e[t+3],y[5]=e[t+2],y[6]=e[t+1],y[7]=e[t],_[0]}):function(e,t){var i=h(e,t+4),r=h(e,t+8),n=2*(r>>31)+1,a=r>>>20&2047,o=4294967296*(1048575&r)+i;return 2047==a?o?NaN:1/0*n:0==a?5e-324*n*o:n*Math.pow(2,a-1075)*(o+4503599627370496)};l.prototype.double=function(){if(this.pos+8>this.len)throw s(this,4);var e=v(this.buf,this.pos);return this.pos+=8,e},l.prototype.bytes=function(){var e=this.uint32(),t=this.pos,i=this.pos+e;if(i>this.len)throw s(this,e);return this.pos+=e,t===i?new this.buf.constructor(0):this._slice.call(this.buf,t,i)},l.prototype.string=function(){var e=this.bytes();return o.read(e,0,e.length)},l.prototype.skip=function(e){if("number"==typeof e){if(this.pos+e>this.len)throw s(this,e);this.pos+=e}else do{if(this.pos>=this.len)throw s(this)}while(128&this.buf[this.pos++]);return this},l.prototype.skipType=function(e){switch(e){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;;){if(4==(e=7&this.uint32()))break;this.skipType(e)}break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+e+" at offset "+this.pos)}return this},l._configure=function(e){r=e;var t=n.Long?"toLong":"toNumber";n.merge(l.prototype,{int64:function(){return d.call(this)[t](!1)},uint64:function(){return d.call(this)[t](!0)},sint64:function(){return d.call(this).zzDecode()[t](!1)},fixed64:function(){return p.call(this)[t](!0)},sfixed64:function(){return p.call(this)[t](!1)}})}},{13:13}],9:[function(e,t,i){t.exports=a;var r=e(8);(a.prototype=Object.create(r.prototype)).constructor=a;var n=e(13);function a(e){r.call(this,e)}n.Buffer&&(a.prototype._slice=n.Buffer.prototype.slice),a.prototype.string=function(){var e=this.uint32();return this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+e,this.len))}},{13:13,8:8}],10:[function(e,t,i){i.Service=e(11)},{11:11}],11:[function(e,t,i){t.exports=r;var s=e(13);function r(e,t,i){if("function"!=typeof e)throw TypeError("rpcImpl must be a function");s.EventEmitter.call(this),this.rpcImpl=e,this.requestDelimited=Boolean(t),this.responseDelimited=Boolean(i)}((r.prototype=Object.create(s.EventEmitter.prototype)).constructor=r).prototype.rpcCall=function e(i,t,r,n,a){if(!n)throw TypeError("request must be specified");var o=this;if(!a)return s.asPromise(e,o,i,t,r,n);if(!o.rpcImpl)return setTimeout(function(){a(Error("already ended"))},0),undefined$1;try{return o.rpcImpl(i,t[o.requestDelimited?"encodeDelimited":"encode"](n).finish(),function(e,t){if(e)return o.emit("error",e,i),a(e);if(null===t)return o.end(!0),undefined$1;if(!(t instanceof r))try{t=r[o.responseDelimited?"decodeDelimited":"decode"](t)}catch(e){return o.emit("error",e,i),a(e)}return o.emit("data",t,i),a(null,t)})}catch(e){return o.emit("error",e,i),setTimeout(function(){a(e)},0),undefined$1}},r.prototype.end=function(e){return this.rpcImpl&&(e||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}},{13:13}],12:[function(e,t,i){t.exports=n;var r=e(13);function n(e,t){this.lo=e>>>0,this.hi=t>>>0}var a=n.zero=new n(0,0);a.toNumber=function(){return 0},a.zzEncode=a.zzDecode=function(){return this},a.length=function(){return 1};var o=n.zeroHash="\0\0\0\0\0\0\0\0";n.fromNumber=function(e){if(0===e)return a;var t=e<0;t&&(e=-e);var i=e>>>0,r=(e-i)/4294967296>>>0;return t&&(r=~r>>>0,i=~i>>>0,4294967295<++i&&(i=0,4294967295<++r&&(r=0))),new n(i,r)},n.from=function(e){if("number"==typeof e)return n.fromNumber(e);if(r.isString(e)){if(!r.Long)return n.fromNumber(parseInt(e,10));e=r.Long.fromString(e)}return e.low||e.high?new n(e.low>>>0,e.high>>>0):a},n.prototype.toNumber=function(e){if(!e&&this.hi>>>31){var t=1+~this.lo>>>0,i=~this.hi>>>0;return t||(i=i+1>>>0),-(t+4294967296*i)}return this.lo+4294967296*this.hi},n.prototype.toLong=function(e){return r.Long?new r.Long(0|this.lo,0|this.hi,Boolean(e)):{low:0|this.lo,high:0|this.hi,unsigned:Boolean(e)}};var s=String.prototype.charCodeAt;n.fromHash=function(e){return e===o?a:new n((s.call(e,0)|s.call(e,1)<<8|s.call(e,2)<<16|s.call(e,3)<<24)>>>0,(s.call(e,4)|s.call(e,5)<<8|s.call(e,6)<<16|s.call(e,7)<<24)>>>0)},n.prototype.toHash=function(){return String.fromCharCode(255&this.lo,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,255&this.hi,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)},n.prototype.zzEncode=function(){var e=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^e)>>>0,this.lo=(this.lo<<1^e)>>>0,this},n.prototype.zzDecode=function(){var e=-(1&this.lo);return this.lo=((this.lo>>>1|this.hi<<31)^e)>>>0,this.hi=(this.hi>>>1^e)>>>0,this},n.prototype.length=function(){var e=this.lo,t=(this.lo>>>28|this.hi<<4)>>>0,i=this.hi>>>24;return 0==i?0==t?e<16384?e<128?1:2:e<2097152?3:4:t<16384?t<128?5:6:t<2097152?7:8:i<128?9:10}},{13:13}],13:[function(e,t,i){var r=i;function n(e,t,i){for(var r=Object.keys(t),n=0;n<r.length;++n)e[r[n]]!==undefined$1&&i||(e[r[n]]=t[r[n]]);return e}function a(e){function i(e,t){if(!(this instanceof i))return new i(e,t);Object.defineProperty(this,"message",{get:function(){return e}}),Error.captureStackTrace?Error.captureStackTrace(this,i):Object.defineProperty(this,"stack",{value:(new Error).stack||""}),t&&n(this,t)}return(i.prototype=Object.create(Error.prototype)).constructor=i,Object.defineProperty(i.prototype,"name",{get:function(){return e}}),i.prototype.toString=function(){return this.name+": "+this.message},i}r.asPromise=e(1),r.base64=e(2),r.EventEmitter=e(3),r.inquire=e(4),r.utf8=e(6),r.pool=e(5),r.LongBits=e(12),r.emptyArray=Object.freeze?Object.freeze([]):[],r.emptyObject=Object.freeze?Object.freeze({}):{},r.isNode=Boolean(global.process&&global.process.versions&&global.process.versions.node),r.isInteger=Number.isInteger||function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},r.isString=function(e){return"string"==typeof e||e instanceof String},r.isObject=function(e){return e&&"object"==typeof e},r.Buffer=function(){try{var e=r.inquire("buffer").Buffer;return e.prototype.utf8Write?e:null}catch(e){return null}}(),r._Buffer_from=null,r._Buffer_allocUnsafe=null,r.newBuffer=function(e){return"number"==typeof e?r.Buffer?r._Buffer_allocUnsafe(e):new r.Array(e):r.Buffer?r._Buffer_from(e):"undefined"==typeof Uint8Array?e:new Uint8Array(e)},r.Array="undefined"!=typeof Uint8Array?Uint8Array:Array,r.Long=global.dcodeIO&&global.dcodeIO.Long||r.inquire("long"),r.key2Re=/^true|false|0|1$/,r.key32Re=/^-?(?:0|[1-9][0-9]*)$/,r.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/,r.longToHash=function(e){return e?r.LongBits.from(e).toHash():r.LongBits.zeroHash},r.longFromHash=function(e,t){var i=r.LongBits.fromHash(e);return r.Long?r.Long.fromBits(i.lo,i.hi,t):i.toNumber(Boolean(t))},r.merge=n,r.lcFirst=function(e){return e.charAt(0).toLowerCase()+e.substring(1)},r.newError=a,r.ProtocolError=a("ProtocolError"),r.oneOfGetter=function(e){for(var i={},t=0;t<e.length;++t)i[e[t]]=1;return function(){for(var e=Object.keys(this),t=e.length-1;-1<t;--t)if(1===i[e[t]]&&this[e[t]]!==undefined$1&&null!==this[e[t]])return e[t]}},r.oneOfSetter=function(i){return function(e){for(var t=0;t<i.length;++t)i[t]!==e&&delete this[i[t]]}},r.lazyResolve=function(e,t){for(var i=0;i<t.length;++i)for(var r=Object.keys(t[i]),n=0;n<r.length;++n){for(var a=t[i][r[n]].split("."),o=e;a.length;)o=o[a.shift()];t[i][r[n]]=o}},r.toJSONOptions={longs:String,enums:String,bytes:String},r._configure=function(){var i=r.Buffer;i?(r._Buffer_from=i.from!==Uint8Array.from&&i.from||function(e,t){return new i(e,t)},r._Buffer_allocUnsafe=i.allocUnsafe||function(e){return new i(e)}):r._Buffer_from=r._Buffer_allocUnsafe=null}},{1:1,12:12,2:2,3:3,4:4,5:5,6:6}],14:[function(e,t,i){t.exports=d;var r,n=e(13),a=n.LongBits,o=n.base64,s=n.utf8;function l(e,t,i){this.fn=e,this.len=t,this.next=undefined$1,this.val=i}function c(){}function u(e){this.head=e.head,this.tail=e.tail,this.len=e.len,this.next=e.states}function d(){this.len=0,this.head=new l(c,0,0),this.tail=this.head,this.states=null}function h(e,t,i){t[i]=255&e}function p(e,t){this.len=e,this.next=undefined$1,this.val=t}function m(e,t,i){for(;e.hi;)t[i++]=127&e.lo|128,e.lo=(e.lo>>>7|e.hi<<25)>>>0,e.hi>>>=7;for(;127<e.lo;)t[i++]=127&e.lo|128,e.lo=e.lo>>>7;t[i++]=e.lo}function f(e,t,i){t[i++]=255&e,t[i++]=e>>>8&255,t[i++]=e>>>16&255,t[i]=e>>>24}d.create=n.Buffer?function(){return(d.create=function(){return new r})()}:function(){return new d},d.alloc=function(e){return new n.Array(e)},n.Array!==Array&&(d.alloc=n.pool(d.alloc,n.Array.prototype.subarray)),d.prototype.push=function(e,t,i){return this.tail=this.tail.next=new l(e,t,i),this.len+=t,this},(p.prototype=Object.create(l.prototype)).fn=function(e,t,i){for(;127<e;)t[i++]=127&e|128,e>>>=7;t[i]=e},d.prototype.uint32=function(e){return this.len+=(this.tail=this.tail.next=new p((e>>>=0)<128?1:e<16384?2:e<2097152?3:e<268435456?4:5,e)).len,this},d.prototype.int32=function(e){return e<0?this.push(m,10,a.fromNumber(e)):this.uint32(e)},d.prototype.sint32=function(e){return this.uint32((e<<1^e>>31)>>>0)},d.prototype.int64=d.prototype.uint64=function(e){var t=a.from(e);return this.push(m,t.length(),t)},d.prototype.sint64=function(e){var t=a.from(e).zzEncode();return this.push(m,t.length(),t)},d.prototype.bool=function(e){return this.push(h,1,e?1:0)},d.prototype.sfixed32=d.prototype.fixed32=function(e){return this.push(f,4,e>>>0)},d.prototype.sfixed64=d.prototype.fixed64=function(e){var t=a.from(e);return this.push(f,4,t.lo).push(f,4,t.hi)};var g,_,y="undefined"!=typeof Float32Array?(g=new Float32Array(1),_=new Uint8Array(g.buffer),g[0]=-0,_[3]?function(e,t,i){g[0]=e,t[i++]=_[0],t[i++]=_[1],t[i++]=_[2],t[i]=_[3]}:function(e,t,i){g[0]=e,t[i++]=_[3],t[i++]=_[2],t[i++]=_[1],t[i]=_[0]}):function(e,t,i){var r=e<0?1:0;if(r&&(e=-e),0===e)f(0<1/e?0:2147483648,t,i);else if(isNaN(e))f(2147483647,t,i);else if(34028234663852886e22<e)f((r<<31|2139095040)>>>0,t,i);else if(e<11754943508222875e-54)f((r<<31|Math.round(e/1401298464324817e-60))>>>0,t,i);else{var n=Math.floor(Math.log(e)/Math.LN2);f((r<<31|n+127<<23|8388607&Math.round(e*Math.pow(2,-n)*8388608))>>>0,t,i)}};d.prototype.float=function(e){return this.push(y,4,e)};var v,C,S="undefined"!=typeof Float64Array?(v=new Float64Array(1),C=new Uint8Array(v.buffer),v[0]=-0,C[7]?function(e,t,i){v[0]=e,t[i++]=C[0],t[i++]=C[1],t[i++]=C[2],t[i++]=C[3],t[i++]=C[4],t[i++]=C[5],t[i++]=C[6],t[i]=C[7]}:function(e,t,i){v[0]=e,t[i++]=C[7],t[i++]=C[6],t[i++]=C[5],t[i++]=C[4],t[i++]=C[3],t[i++]=C[2],t[i++]=C[1],t[i]=C[0]}):function(e,t,i){var r=e<0?1:0;if(r&&(e=-e),0===e)f(0,t,i),f(0<1/e?0:2147483648,t,i+4);else if(isNaN(e))f(4294967295,t,i),f(2147483647,t,i+4);else if(17976931348623157e292<e)f(0,t,i),f((r<<31|2146435072)>>>0,t,i+4);else{var n;if(e<22250738585072014e-324)f((n=e/5e-324)>>>0,t,i),f((r<<31|n/4294967296)>>>0,t,i+4);else{var a=Math.floor(Math.log(e)/Math.LN2);1024===a&&(a=1023),f(4503599627370496*(n=e*Math.pow(2,-a))>>>0,t,i),f((r<<31|a+1023<<20|1048576*n&1048575)>>>0,t,i+4)}}};d.prototype.double=function(e){return this.push(S,8,e)};var T=n.Array.prototype.set?function(e,t,i){t.set(e,i)}:function(e,t,i){for(var r=0;r<e.length;++r)t[i+r]=e[r]};d.prototype.bytes=function(e){var t=e.length>>>0;if(!t)return this.push(h,1,0);if(n.isString(e)){var i=d.alloc(t=o.length(e));o.decode(e,i,0),e=i}return this.uint32(t).push(T,t,e)},d.prototype.string=function(e){var t=s.length(e);return t?this.uint32(t).push(s.write,t,e):this.push(h,1,0)},d.prototype.fork=function(){return this.states=new u(this),this.head=this.tail=new l(c,0,0),this.len=0,this},d.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new l(c,0,0),this.len=0),this},d.prototype.ldelim=function(){var e=this.head,t=this.tail,i=this.len;return this.reset().uint32(i),i&&(this.tail.next=e.next,this.tail=t,this.len+=i),this},d.prototype.finish=function(){for(var e=this.head.next,t=this.constructor.alloc(this.len),i=0;e;)e.fn(e.val,t,i),i+=e.len,e=e.next;return t},d._configure=function(e){r=e}},{13:13}],15:[function(e,t,i){t.exports=o;var r=e(14);(o.prototype=Object.create(r.prototype)).constructor=o;var n=e(13),a=n.Buffer;function o(){r.call(this)}o.alloc=function(e){return(o.alloc=n._Buffer_allocUnsafe)(e)};var s=a&&a.prototype instanceof Uint8Array&&"set"===a.prototype.set.name?function(e,t,i){t.set(e,i)}:function(e,t,i){if(e.copy)e.copy(t,i,0,e.length);else for(var r=0;r<e.length;)t[i++]=e[r++]};function l(e,t,i){e.length<40?n.utf8.write(e,t,i):t.utf8Write(e,i)}o.prototype.bytes=function(e){n.isString(e)&&(e=n._Buffer_from(e,"base64"));var t=e.length>>>0;return this.uint32(t),t&&this.push(s,t,e),this},o.prototype.string=function(e){var t=a.byteLength(e);return this.uint32(t),t&&this.push(l,t,e),this}},{13:13,14:14}]},CGb={},DGb=[7],global.protobuf=function e(t){var i=CGb[t];return i||BGb[t][0].call(i=CGb[t]={exports:{}},e,i,i.exports),i.exports}(DGb[0])}(tmp$1);var protobuf=tmp$1.protobuf;function isBitSet(e,t){return 0!=(e&t)}var childrenBitmasks=[1,2,4,8],anyChildBitmask=15,cacheFlagBitmask=16,imageBitmask=64,terrainBitmask=128;function GoogleEarthEnterpriseTileInformation(e,t,i,r,n,a){this._bits=e,this.cnodeVersion=t,this.imageryVersion=i,this.terrainVersion=r,this.imageryProvider=n,this.terrainProvider=a,this.ancestorHasTerrain=!1,this.terrainState=void 0}function stringToBuffer(e){for(var t=e.length,i=new ArrayBuffer(t),r=new Uint8Array(i),n=0;n<t;++n)r[n]=e.charCodeAt(n);return i}GoogleEarthEnterpriseTileInformation.clone=function(e,t){return defined(t)?(t._bits=e._bits,t.cnodeVersion=e.cnodeVersion,t.imageryVersion=e.imageryVersion,t.terrainVersion=e.terrainVersion,t.imageryProvider=e.imageryProvider,t.terrainProvider=e.terrainProvider):t=new GoogleEarthEnterpriseTileInformation(e._bits,e.cnodeVersion,e.imageryVersion,e.terrainVersion,e.imageryProvider,e.terrainProvider),t.ancestorHasTerrain=e.ancestorHasTerrain,t.terrainState=e.terrainState,t},GoogleEarthEnterpriseTileInformation.prototype.setParent=function(e){this.ancestorHasTerrain=e.ancestorHasTerrain||this.hasTerrain()},GoogleEarthEnterpriseTileInformation.prototype.hasSubtree=function(){return isBitSet(this._bits,cacheFlagBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasImagery=function(){return isBitSet(this._bits,imageBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasTerrain=function(){return isBitSet(this._bits,terrainBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChildren=function(){return isBitSet(this._bits,anyChildBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChild=function(e){return isBitSet(this._bits,childrenBitmasks[e])},GoogleEarthEnterpriseTileInformation.prototype.getChildBitmask=function(){return this._bits&anyChildBitmask};var defaultKey=stringToBuffer('Eô½\vyâjE",ÍqøIFgQ\0B%Æèa,f)\bÆ4Üjb%y\nwmiÖðk¡½NuàA[ß@V\fÙ»r|3SîOlÔq°{ÀEVZ­wUe\v3*¬l5Å0sø3>mF8J´Ýð.ÝuÚDt"úa"\f3"So¯9D\v9Ù9L¹¿«\\P_"uxéqh;ÁÄð<VqH\'UfYNeu£aF}a?A\0×´4MÎF°Õ¸\'{Ü+»Mg0ÈÑö\\Pú[/Fn5/\'C.ë\n\f^¥se4ål.jC\'c#U©?q{gC}:¯ÍâTUýKÆâ/(íË\\Æ-f§;/*"N°k.Ý\r}}GºC²²+>Mª>}æÎIÆæx\fa1-¤O¥~q ì\r1èN\v\0nPh}=\b\r¦n£h$[kó#ó¶s³\r\v@ÀØQ]ú".jßI\0¹ wUÆïj¿{GLîÜÜF©­S+S4ÿYä8è1N¹XFkË-#p\x005"Ï1²&/çÃu-6,rt°#G·ÓÑ&7râ\0DÏÚ3-Þ`i#i*|ÍKQ\rT9w.)ê¦P¢joP\\>TûïP[\vEm(w7ÛJfJo åpâ¹q~\fmI-zþrÇòY0»]såÉ êxì ðB|G`°½&·q¶ÇÑ3=Ó«îcÈ+S D\\qÆÌD2O<ÊÀ)=RÓaX©}e´ÜÏ\rô=ñ\b©BÚ#\tØ¿^PIøMÀËGLO÷{+ØÅ1;µoÜl\rÑÛ?âéÚ_ÔâFaZÞUÏ¤\0¾ýÎgñJiæ HØ]~®q N®ÀV©<rçvì)IÖ]-ãÛ6©;fjÕ¶=P^R¹KÇsWxÉô.YoÐKW>\'\'Ç`Û;íSD>?mw¢\në?R¨ÆU^1I7ôÅ&-©¿\'TÚÃj å*x°Öprªh½÷_H±~ÀXL?fù>áeÀp§Ï8i¯ðVldI\'­xtOÂÞV9\0Úw\vË-û5Oõ\bQ`Á\nZGM&30xÚÀFGâ[y`In7gS\n>éìF9²ñ4\rÆSuná\fYÙÞ){II¥wy¾IV.6ç\v:»Ob{ÒM1/½8{¨O!áìFpv})"x\nÝ\\ÚÞQÏðüYRe|3ßóHÚ»*uÛ`²Ôüíì5¨ÿ(1-ÈÜF|["');function GoogleEarthEnterpriseMetadata(e){var t=e;"string"==typeof t||t instanceof Resource||(t=e.url);var i=Resource.createIfNeeded(t);i.appendForwardSlash(),this._resource=i,this.imageryPresent=!0,this.protoImagery=void 0,this.terrainPresent=!0,this.negativeAltitudeExponentBias=32,this.negativeAltitudeThreshold=CesiumMath.EPSILON12,this.providers={},this.key=void 0,this._quadPacketVersion=1,this._tileInfo={},this._subtreePromises={};var r=this;this._readyPromise=requestDbRoot(this).then(function(){return r.getQuadTreePacket("",r._quadPacketVersion)}).then(function(){return!0}).otherwise(function(e){var t="An error occurred while accessing "+getMetadataResource(r,"",1).url+".";return when.reject(new RuntimeError(t))})}defineProperties$1(GoogleEarthEnterpriseMetadata.prototype,{url:{get:function(){return this._resource.url}},proxy:{get:function(){return this._resource.proxy}},resource:{get:function(){return this._resource}},readyPromise:{get:function(){return this._readyPromise}}}),GoogleEarthEnterpriseMetadata.tileXYToQuadKey=function(e,t,i){for(var r="",n=i;0<=n;--n){var a=1<<n,o=0;isBitSet(t,a)?isBitSet(e,a)&&(o|=1):(o|=2,isBitSet(e,a)||(o|=1)),r+=o}return r},GoogleEarthEnterpriseMetadata.quadKeyToTileXY=function(e){for(var t=0,i=0,r=e.length-1,n=r;0<=n;--n){var a=1<<n,o=+e[r-n];isBitSet(o,2)?isBitSet(o,1)||(t|=a):(i|=a,isBitSet(o,1)&&(t|=a))}return{x:t,y:i,level:r}},GoogleEarthEnterpriseMetadata.prototype.isValid=function(e){var t=this.getTileInformationFromQuadKey(e);if(defined(t))return null!==t;for(var i,r=!0,n=e;1<n.length;){if(i=n.substring(n.length-1),n=n.substring(0,n.length-1),defined(t=this.getTileInformationFromQuadKey(n))){t.hasSubtree()||t.hasChild(parseInt(i))||(r=!1);break}if(null===t){r=!1;break}}return r};var taskProcessor$1=new TaskProcessor("decodeGoogleEarthEnterprisePacket",Number.POSITIVE_INFINITY),dbrootParser,dbrootParserPromise;function populateSubtree(e,t,i){var r,n=e._tileInfo,a=t,o=n[a];if(defined(o)&&(!o.hasSubtree()||o.hasChildren()))return o;for(;void 0===o&&1<a.length;)o=n[a=a.substring(0,a.length-1)];var s=e._subtreePromises,l=s[a];return defined(l)?l.then(function(){return r=new Request({throttle:i.throttle,throttleByServer:i.throttleByServer,type:i.type,priorityFunction:i.priorityFunction}),populateSubtree(e,t,r)}):defined(o)&&o.hasSubtree()?defined(l=e.getQuadTreePacket(a,o.cnodeVersion,i))?(s[a]=l).then(function(){return r=new Request({throttle:i.throttle,throttleByServer:i.throttleByServer,type:i.type,priorityFunction:i.priorityFunction}),populateSubtree(e,t,r)}).always(function(){delete s[a]}):void 0:when.reject(new RuntimeError("Couldn't load metadata for tile "+t))}function getMetadataResource(e,t,i,r){return e._resource.getDerivedResource({url:"flatfile?q2-0"+t+"-q."+i.toString(),request:r})}function requestDbRoot(c){var e=c._resource.getDerivedResource({url:"dbRoot.v5",queryParameters:{output:"proto"}});if(!defined(dbrootParserPromise)){var t=buildModuleUrl("ThirdParty/google-earth-dbroot-parser.js"),i=window.cesiumGoogleEarthDbRootParser;dbrootParserPromise=loadAndExecuteScript(t).then(function(){dbrootParser=window.cesiumGoogleEarthDbRootParser(protobuf),defined(i)?window.cesiumGoogleEarthDbRootParser=i:delete window.cesiumGoogleEarthDbRootParser})}return dbrootParserPromise.then(function(){return e.fetchArrayBuffer()}).then(function(e){var t=dbrootParser.EncryptedDbRootProto.decode(new Uint8Array(e)),i=t.encryptionData,r=i.byteOffset,n=r+i.byteLength,a=c.key=i.buffer.slice(r,n);n=(r=(i=t.dbrootData).byteOffset)+i.byteLength;var o=i.buffer.slice(r,n);return taskProcessor$1.scheduleTask({buffer:o,type:"DbRoot",key:a},[o])}).then(function(e){var t=dbrootParser.DbRootProto.decode(new Uint8Array(e.buffer));if(c.imageryPresent=defaultValue(t.imageryPresent,c.imageryPresent),c.protoImagery=t.protoImagery,c.terrainPresent=defaultValue(t.terrainPresent,c.terrainPresent),defined(t.endSnippet)&&defined(t.endSnippet.model)){var i=t.endSnippet.model;c.negativeAltitudeExponentBias=defaultValue(i.negativeAltitudeExponentBias,c.negativeAltitudeExponentBias),c.negativeAltitudeThreshold=defaultValue(i.compressedNegativeAltitudeThreshold,c.negativeAltitudeThreshold)}defined(t.databaseVersion)&&(c._quadPacketVersion=defaultValue(t.databaseVersion.quadtreeVersion,c._quadPacketVersion));for(var r=c.providers,n=defaultValue(t.providerInfo,[]),a=n.length,o=0;o<a;++o){var s=n[o],l=s.copyrightString;defined(l)&&(r[s.providerId]=new Credit(l.value))}}).otherwise(function(){console.log("Failed to retrieve "+e.url+". Using defaults."),c.key=defaultKey})}function GoogleEarthEnterpriseTerrainData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._buffer=e.buffer,this._credits=e.credits,this._negativeAltitudeExponentBias=e.negativeAltitudeExponentBias,this._negativeElevationThreshold=e.negativeElevationThreshold;var t=defaultValue(e.childTileMask,15),i=3&t;i|=4&t?8:0,i|=8&t?4:0,this._childTileMask=i,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._skirtHeight=void 0,this._bufferType=this._buffer.constructor,this._mesh=void 0,this._minimumHeight=void 0,this._maximumHeight=void 0,this._vertexCountWithoutSkirts=void 0,this._skirtIndex=void 0}GoogleEarthEnterpriseMetadata.prototype.getQuadTreePacket=function(d,e,t){e=defaultValue(e,1);var i=getMetadataResource(this,d=defaultValue(d,""),e,t).fetchArrayBuffer();if(defined(i)){var h=this._tileInfo,r=this.key;return i.then(function(e){return taskProcessor$1.scheduleTask({buffer:e,quadKey:d,type:"Metadata",key:r},[e]).then(function(e){var t,i=-1;if(""!==d){i=d.length+1;var r=e[d];(t=h[d])._bits|=r._bits,delete e[d]}var n=Object.keys(e);n.sort(function(e,t){return e.length-t.length});for(var a=n.length,o=0;o<a;++o){var s=n[o];if(null!==e[s]){var l=GoogleEarthEnterpriseTileInformation.clone(e[s]),c=s.length;if(c===i)l.setParent(t);else if(1<c){var u=h[s.substring(0,s.length-1)];l.setParent(u)}h[s]=l}else h[s]=null}})})}},GoogleEarthEnterpriseMetadata.prototype.populateSubtree=function(e,t,i,r){return populateSubtree(this,GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),r)},GoogleEarthEnterpriseMetadata.prototype.getTileInformation=function(e,t,i){var r=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i);return this._tileInfo[r]},GoogleEarthEnterpriseMetadata.prototype.getTileInformationFromQuadKey=function(e){return this._tileInfo[e]},defineProperties$1(GoogleEarthEnterpriseTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){}}});var taskProcessor$2=new TaskProcessor("createVerticesFromGoogleEarthEnterpriseBuffer"),nativeRectangleScratch=new Rectangle,rectangleScratch$1=new Rectangle;GoogleEarthEnterpriseTerrainData.prototype.createMesh=function(e,t,i,r,n){var a=e.ellipsoid;e.tileXYToNativeRectangle(t,i,r,nativeRectangleScratch),e.tileXYToRectangle(t,i,r,rectangleScratch$1),n=defaultValue(n,1);var o=a.cartographicToCartesian(Rectangle.center(rectangleScratch$1)),s=40075.16/(1<<r);this._skirtHeight=Math.min(8*s,1e3);var l=taskProcessor$2.scheduleTask({buffer:this._buffer,nativeRectangle:nativeRectangleScratch,rectangle:rectangleScratch$1,relativeToCenter:o,ellipsoid:a,skirtHeight:this._skirtHeight,exaggeration:n,includeWebMercatorT:!0,negativeAltitudeExponentBias:this._negativeAltitudeExponentBias,negativeElevationThreshold:this._negativeElevationThreshold});if(defined(l)){var c=this;return l.then(function(e){return c._mesh=new TerrainMesh(o,new Float32Array(e.vertices),new Uint16Array(e.indices),e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),n,e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),c._vertexCountWithoutSkirts=e.vertexCountWithoutSkirts,c._skirtIndex=e.skirtIndex,c._minimumHeight=e.minimumHeight,c._maximumHeight=e.maximumHeight,c._buffer=void 0,c._mesh})}},GoogleEarthEnterpriseTerrainData.prototype.interpolateHeight=function(e,t,i){var r=CesiumMath.clamp((t-e.west)/e.width,0,1),n=CesiumMath.clamp((i-e.south)/e.height,0,1);return defined(this._mesh)?interpolateMeshHeight$2(this,r,n):interpolateHeight$2(this,r,n,e)};var upsampleTaskProcessor$1=new TaskProcessor("upsampleQuantizedTerrainMesh");GoogleEarthEnterpriseTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(this._mesh)){var l=2*t!==n,c=2*i===a,u=e.ellipsoid,d=e.tileXYToRectangle(n,a,o),h=upsampleTaskProcessor$1.scheduleTask({vertices:s.vertices,vertexCountWithoutSkirts:this._vertexCountWithoutSkirts,indices:s.indices,skirtIndex:this._skirtIndex,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:l,isNorthChild:c,childRectangle:d,ellipsoid:u,exaggeration:s.exaggeration});if(defined(h)){var p=this;return h.then(function(e){var t=new Uint16Array(e.vertices),i=IndexDatatype$1.createTypedArray(t.length/3,e.indices),r=p._skirtHeight;return new QuantizedMeshTerrainData({quantizedVertices:t,indices:i,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:r,southSkirtHeight:r,eastSkirtHeight:r,northSkirtHeight:r,childTileMask:0,createdByUpsampling:!0,credits:p._credits})})}}},GoogleEarthEnterpriseTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},GoogleEarthEnterpriseTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var texCoordScratch0$1=new Cartesian2,texCoordScratch1$1=new Cartesian2,texCoordScratch2$1=new Cartesian2,barycentricCoordinateScratch$1=new Cartesian3;function interpolateMeshHeight$2(e,t,i){for(var r=e._mesh,n=r.vertices,a=r.encoding,o=r.indices,s=0,l=o.length;s<l;s+=3){var c=o[s],u=o[s+1],d=o[s+2],h=a.decodeTextureCoordinates(n,c,texCoordScratch0$1),p=a.decodeTextureCoordinates(n,u,texCoordScratch1$1),m=a.decodeTextureCoordinates(n,d,texCoordScratch2$1),f=Intersections2D.computeBarycentricCoordinates(t,i,h.x,h.y,p.x,p.y,m.x,m.y,barycentricCoordinateScratch$1);if(-1e-15<=f.x&&-1e-15<=f.y&&-1e-15<=f.z){var g=a.decodeHeight(n,c),_=a.decodeHeight(n,u),y=a.decodeHeight(n,d);return f.x*g+f.y*_+f.z*y}}}var sizeOfUint16=Uint16Array.BYTES_PER_ELEMENT,sizeOfUint32=Uint32Array.BYTES_PER_ELEMENT,sizeOfInt32=Int32Array.BYTES_PER_ELEMENT,sizeOfFloat=Float32Array.BYTES_PER_ELEMENT,sizeOfDouble=Float64Array.BYTES_PER_ELEMENT;function interpolateHeight$2(e,t,i,r){var n=e._buffer,a=0,o=0,s=0;.5<i?(.5<t?(a=2,o=.5):a=3,s=.5):.5<t&&(a=1,o=.5);for(var l=new DataView(n),c=0,u=0;u<a;++u)c+=l.getUint32(c,!0),c+=sizeOfUint32;c+=sizeOfUint32,c+=2*sizeOfDouble;var d=CesiumMath.toRadians(180*l.getFloat64(c,!0));c+=sizeOfDouble;var h=CesiumMath.toRadians(180*l.getFloat64(c,!0));c+=sizeOfDouble;var p=r.width/d/2,m=r.height/h/2,f=l.getInt32(c,!0);c+=sizeOfInt32;var g=3*l.getInt32(c,!0);c+=sizeOfInt32,c+=sizeOfInt32;var _,y=new Array(f),v=new Array(f),C=new Array(f);for(_=0;_<f;++_)y[_]=o+l.getUint8(c++)*p,v[_]=s+l.getUint8(c++)*m,C[_]=6371010*l.getFloat32(c,!0),c+=sizeOfFloat;var S=new Array(g);for(_=0;_<g;++_)S[_]=l.getUint16(c,!0),c+=sizeOfUint16;for(_=0;_<g;_+=3){var T=S[_],x=S[_+1],b=S[_+2],E=y[T],P=y[x],A=y[b],w=v[T],D=v[x],M=v[b],I=Intersections2D.computeBarycentricCoordinates(t,i,E,w,P,D,A,M,barycentricCoordinateScratch$1);if(-1e-15<=I.x&&-1e-15<=I.y&&-1e-15<=I.z)return I.x*C[T]+I.y*C[x]+I.z*C[b]}}var TerrainState={UNKNOWN:0,NONE:1,SELF:2,PARENT:3},julianDateScratch$1=new JulianDate;function TerrainCache(){this._terrainCache={},this._lastTidy=JulianDate.now()}function GoogleEarthEnterpriseTerrainProvider(e){var i;if(defined((e=defaultValue(e,defaultValue.EMPTY_OBJECT)).metadata))i=e.metadata;else{var t=Resource.createIfNeeded(e.url);i=new GoogleEarthEnterpriseMetadata(t)}this._metadata=i,this._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:2,rectangle:new Rectangle(-CesiumMath.PI,-CesiumMath.PI,CesiumMath.PI,CesiumMath.PI),ellipsoid:e.ellipsoid});var r=e.credit;"string"==typeof r&&(r=new Credit(r)),this._credit=r,this._levelZeroMaximumGeometricError=40075.16,this._terrainCache=new TerrainCache,this._terrainPromises={},this._terrainRequests={},this._errorEvent=new Event,this._ready=!1;var n,a=this;this._readyPromise=i.readyPromise.then(function(e){if(i.terrainPresent)return TileProviderError.handleSuccess(n),a._ready=e;var t=new RuntimeError("The server "+i.url+" doesn't have terrain");return n=TileProviderError.handleError(n,a,a._errorEvent,t.message,void 0,void 0,void 0,t),when.reject(t)}).otherwise(function(e){return n=TileProviderError.handleError(n,a,a._errorEvent,e.message,void 0,void 0,void 0,e),when.reject(e)})}TerrainCache.prototype.add=function(e,t){this._terrainCache[e]={buffer:t,timestamp:JulianDate.now()}},TerrainCache.prototype.get=function(e){var t=this._terrainCache[e];if(defined(t))return delete this._terrainCache[e],t.buffer},TerrainCache.prototype.tidy=function(){if(JulianDate.now(julianDateScratch$1),10<JulianDate.secondsDifference(julianDateScratch$1,this._lastTidy)){for(var e=this._terrainCache,t=Object.keys(e),i=t.length,r=0;r<i;++r){var n=t[r],a=e[n];10<JulianDate.secondsDifference(julianDateScratch$1,a.timestamp)&&delete e[n]}JulianDate.clone(julianDateScratch$1,this._lastTidy)}},defineProperties$1(GoogleEarthEnterpriseTerrainProvider.prototype,{url:{get:function(){return this._metadata.url}},proxy:{get:function(){return this._metadata.proxy}},tilingScheme:{get:function(){return this._tilingScheme}},errorEvent:{get:function(){return this._errorEvent}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},credit:{get:function(){return this._credit}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}});var taskProcessor$3=new TaskProcessor("decodeGoogleEarthEnterprisePacket",Number.POSITIVE_INFINITY);function computeChildMask(e,t,i){var r=t.getChildBitmask();if(t.terrainState===TerrainState.PARENT)for(var n=r=0;n<4;++n){var a=i.getTileInformationFromQuadKey(e+n.toString());defined(a)&&a.hasTerrain()&&(r|=1<<n)}return r}function buildTerrainResource(e,t,i,r){return i=defined(i)&&0<i?i:1,e._metadata.resource.getDerivedResource({url:"flatfile?f1c-0"+t+"-t."+i.toString(),request:r})}GoogleEarthEnterpriseTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),s=this._terrainCache,l=this._metadata,a=l.getTileInformationFromQuadKey(n);if(!defined(a))return when.reject(new RuntimeError("Terrain tile doesn't exist"));var o=a.terrainState;defined(o)||(o=a.terrainState=TerrainState.UNKNOWN);var c,u=s.get(n);if(defined(u)){var d=l.providers[a.terrainProvider];return when.resolve(new GoogleEarthEnterpriseTerrainData({buffer:u,childTileMask:computeChildMask(n,a,l),credits:defined(d)?[d]:void 0,negativeAltitudeExponentBias:l.negativeAltitudeExponentBias,negativeElevationThreshold:l.negativeAltitudeThreshold}))}if(s.tidy(),!a.ancestorHasTerrain)return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}));if(o===TerrainState.NONE)return when.reject(new RuntimeError("Terrain tile doesn't exist"));var h=n,p=-1;switch(o){case TerrainState.SELF:p=a.terrainVersion;break;case TerrainState.PARENT:h=h.substring(0,h.length-1),p=(c=l.getTileInformationFromQuadKey(h)).terrainVersion;break;case TerrainState.UNKNOWN:a.hasTerrain()?p=a.terrainVersion:(h=h.substring(0,h.length-1),defined(c=l.getTileInformationFromQuadKey(h))&&c.hasTerrain()&&(p=c.terrainVersion))}if(p<0)return when.reject(new RuntimeError("Terrain tile doesn't exist"));var m,f,g=this._terrainPromises,_=this._terrainRequests;if(defined(g[h]))m=g[h],f=_[h];else{var y=buildTerrainResource(this,h,p,f=r).fetchArrayBuffer();if(!defined(y))return;m=y.then(function(e){return defined(e)?taskProcessor$3.scheduleTask({buffer:e,type:"Terrain",key:l.key},[e]).then(function(e){var t=l.getTileInformationFromQuadKey(h);t.terrainState=TerrainState.SELF,s.add(h,e[0]);for(var i=t.terrainProvider,r=e.length-1,n=0;n<r;++n){var a=h+n.toString(),o=l.getTileInformationFromQuadKey(a);defined(o)&&(s.add(a,e[n+1]),o.terrainState=TerrainState.PARENT,0===o.terrainProvider&&(o.terrainProvider=i))}}):when.reject(new RuntimeError("Failed to load terrain."))}),g[h]=m,_[h]=f,m=m.always(function(){delete g[h],delete _[h]})}return m.then(function(){var e=s.get(n);if(defined(e)){var t=l.providers[a.terrainProvider];return new GoogleEarthEnterpriseTerrainData({buffer:e,childTileMask:computeChildMask(n,a,l),credits:defined(t)?[t]:void 0,negativeAltitudeExponentBias:l.negativeAltitudeExponentBias,negativeElevationThreshold:l.negativeAltitudeThreshold})}return when.reject(new RuntimeError("Failed to load terrain."))}).otherwise(function(e){return f.state===RequestState$1.CANCELLED?r.state=f.state:a.terrainState=TerrainState.NONE,when.reject(e)})},GoogleEarthEnterpriseTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},GoogleEarthEnterpriseTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){var r=this._metadata,n=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),a=r.getTileInformation(e,t,i);if(null===a)return!1;if(defined(a)){if(!a.ancestorHasTerrain)return!0;var o=a.terrainState;if(o===TerrainState.NONE)return!1;if(!(defined(o)&&o!==TerrainState.UNKNOWN||(a.terrainState=TerrainState.UNKNOWN,a.hasTerrain()))){n=n.substring(0,n.length-1);var s=r.getTileInformationFromQuadKey(n);if(!defined(s)||!s.hasTerrain())return!1}return!0}if(r.isValid(n)){var l=new Request({throttle:!0,throttleByServer:!0,type:RequestType$1.TERRAIN});r.populateSubtree(e,t,i,l)}return!1},GoogleEarthEnterpriseTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var PROJECTIONS=[GeographicProjection,WebMercatorProjection],PROJECTION_COUNT=PROJECTIONS.length,MITER_BREAK_SMALL=Math.cos(CesiumMath.toRadians(30)),MITER_BREAK_LARGE=Math.cos(CesiumMath.toRadians(150)),WALL_INITIAL_MIN_HEIGHT=0,WALL_INITIAL_MAX_HEIGHT=1e3;function GroundPolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions;this.width=defaultValue(e.width,1),this._positions=t,this.granularity=defaultValue(e.granularity,9999),this.loop=defaultValue(e.loop,!1),this.arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._ellipsoid=Ellipsoid.WGS84,this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}defineProperties$1(GroundPolylineGeometry.prototype,{packedLength:{get:function(){return 1+3*this._positions.length+1+1+1+Ellipsoid.packedLength+1+1}}}),GroundPolylineGeometry.setProjectionAndEllipsoid=function(e,t){for(var i=0,r=0;r<PROJECTION_COUNT;r++)if(t instanceof PROJECTIONS[r]){i=r;break}e._projectionIndex=i,e._ellipsoid=t.ellipsoid};var cart3Scratch1=new Cartesian3,cart3Scratch2=new Cartesian3,cart3Scratch3=new Cartesian3;function computeRightNormal(e,t,i,r,n){var a=getPosition(r,e,0,cart3Scratch1),o=getPosition(r,e,i,cart3Scratch2),s=getPosition(r,t,0,cart3Scratch3),l=direction(o,a,cart3Scratch2),c=direction(s,a,cart3Scratch3);return Cartesian3.cross(c,l,n),Cartesian3.normalize(n,n)}var interpolatedCartographicScratch=new Cartographic,interpolatedBottomScratch=new Cartesian3,interpolatedTopScratch=new Cartesian3,interpolatedNormalScratch=new Cartesian3;function interpolateSegment(e,t,i,r,n,a,o,s,l,c,u){if(0!==n){var d;a===ArcType$1.GEODESIC?d=new EllipsoidGeodesic(e,t,o):a===ArcType$1.RHUMB&&(d=new EllipsoidRhumbLine(e,t,o));var h=d.surfaceDistance;if(!(h<n))for(var p=computeRightNormal(e,t,r,o,interpolatedNormalScratch),m=Math.ceil(h/n),f=h/m,g=f,_=m-1,y=s.length,v=0;v<_;v++){var C=d.interpolateUsingSurfaceDistance(g,interpolatedCartographicScratch),S=getPosition(o,C,i,interpolatedBottomScratch),T=getPosition(o,C,r,interpolatedTopScratch);Cartesian3.pack(p,s,y),Cartesian3.pack(S,l,y),Cartesian3.pack(T,c,y),u.push(C.latitude),u.push(C.longitude),y+=3,g+=f}}}var heightlessCartographicScratch=new Cartographic;function getPosition(e,t,i,r){return Cartographic.clone(t,heightlessCartographicScratch),heightlessCartographicScratch.height=i,Cartographic.toCartesian(heightlessCartographicScratch,e,r)}function direction(e,t,i){return Cartesian3.subtract(e,t,i),Cartesian3.normalize(i,i),i}function tangentDirection(e,t,i,r){return r=direction(e,t,r),r=Cartesian3.cross(r,i,r),r=Cartesian3.normalize(r,r),r=Cartesian3.cross(i,r,r)}GroundPolylineGeometry.pack=function(e,t,i){var r=defaultValue(i,0),n=e._positions,a=n.length;t[r++]=a;for(var o=0;o<a;++o){var s=n[o];Cartesian3.pack(s,t,r),r+=3}return t[r++]=e.granularity,t[r++]=e.loop?1:0,t[r++]=e.arcType,Ellipsoid.pack(e._ellipsoid,t,r),r+=Ellipsoid.packedLength,t[r++]=e._projectionIndex,t[r++]=e._scene3DOnly?1:0,t},GroundPolylineGeometry.unpack=function(e,t,i){for(var r=defaultValue(t,0),n=e[r++],a=new Array(n),o=0;o<n;o++)a[o]=Cartesian3.unpack(e,r),r+=3;var s=e[r++],l=1===e[r++],c=e[r++],u=Ellipsoid.unpack(e,r);r+=Ellipsoid.packedLength;var d=e[r++],h=1===e[r++];return defined(i)||(i=new GroundPolylineGeometry({positions:a})),i._positions=a,i.granularity=s,i.loop=l,i.arcType=c,i._ellipsoid=u,i._projectionIndex=d,i._scene3DOnly=h,i};var toPreviousScratch=new Cartesian3,toNextScratch=new Cartesian3,forwardScratch=new Cartesian3,vertexUpScratch=new Cartesian3,cosine90=0,cosine180=-1;function computeVertexMiterNormal(e,t,i,r,n){var a=direction(i,t,vertexUpScratch),o=tangentDirection(e,t,a,toPreviousScratch),s=tangentDirection(r,t,a,toNextScratch);if(CesiumMath.equalsEpsilon(Cartesian3.dot(o,s),cosine180,CesiumMath.EPSILON5))return n=Cartesian3.cross(a,o,n),n=Cartesian3.normalize(n,n);n=Cartesian3.add(s,o,n),n=Cartesian3.normalize(n,n);var l=Cartesian3.cross(a,n,forwardScratch);return Cartesian3.dot(s,l)<cosine90&&(n=Cartesian3.negate(n,n)),n}var XZ_PLANE=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),previousBottomScratch=new Cartesian3,vertexBottomScratch=new Cartesian3,vertexTopScratch=new Cartesian3,nextBottomScratch=new Cartesian3,vertexNormalScratch=new Cartesian3,intersectionScratch=new Cartesian3,cartographicScratch0=new Cartographic,cartographicScratch1=new Cartographic,cartographicIntersectionScratch=new Cartographic;GroundPolylineGeometry.createGeometry=function(e){var t,i,r,n,a,o,s=!e._scene3DOnly,l=e.loop,c=e._ellipsoid,u=e.granularity,d=e.arcType,h=new PROJECTIONS[e._projectionIndex](c),p=WALL_INITIAL_MIN_HEIGHT,m=WALL_INITIAL_MAX_HEIGHT,f=e._positions,g=f.length;2===g&&(l=!1);var _,y,v,C=new EllipsoidRhumbLine(void 0,void 0,c),S=[f[0]];for(i=0;i<g-1;i++)r=f[i],n=f[i+1],!defined(_=IntersectionTests.lineSegmentPlane(r,n,XZ_PLANE,intersectionScratch))||Cartesian3.equalsEpsilon(_,r,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(_,n,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?S.push(Cartesian3.clone(_)):e.arcType===ArcType$1.RHUMB&&(v=c.cartesianToCartographic(_,cartographicScratch0).longitude,a=c.cartesianToCartographic(r,cartographicScratch0),o=c.cartesianToCartographic(n,cartographicScratch1),C.setEndPoints(a,o),y=C.findIntersectionWithLongitude(v,cartographicIntersectionScratch),!defined(_=c.cartographicToCartesian(y,intersectionScratch))||Cartesian3.equalsEpsilon(_,r,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(_,n,CesiumMath.EPSILON7)||S.push(Cartesian3.clone(_)))),S.push(n);l&&(r=f[g-1],n=f[0],!defined(_=IntersectionTests.lineSegmentPlane(r,n,XZ_PLANE,intersectionScratch))||Cartesian3.equalsEpsilon(_,r,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(_,n,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?S.push(Cartesian3.clone(_)):e.arcType===ArcType$1.RHUMB&&(v=c.cartesianToCartographic(_,cartographicScratch0).longitude,a=c.cartesianToCartographic(r,cartographicScratch0),o=c.cartesianToCartographic(n,cartographicScratch1),C.setEndPoints(a,o),y=C.findIntersectionWithLongitude(v,cartographicIntersectionScratch),!defined(_=c.cartographicToCartesian(y,intersectionScratch))||Cartesian3.equalsEpsilon(_,r,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(_,n,CesiumMath.EPSILON7)||S.push(Cartesian3.clone(_)))));var T=S.length,x=new Array(T);for(i=0;i<T;i++){var b=Cartographic.fromCartesian(S[i],c);b.height=0,x[i]=b}if(!((T=(x=arrayRemoveDuplicates(x,Cartographic.equalsEpsilon)).length)<2)){var E=[],P=[],A=[],w=[],D=previousBottomScratch,M=vertexBottomScratch,I=vertexTopScratch,R=nextBottomScratch,O=vertexNormalScratch,L=x[0],F=x[1];for(D=getPosition(c,x[T-1],p,D),R=getPosition(c,F,p,R),M=getPosition(c,L,p,M),I=getPosition(c,L,m,I),O=l?computeVertexMiterNormal(D,M,I,R,O):computeRightNormal(L,F,m,c,O),Cartesian3.pack(O,P,0),Cartesian3.pack(M,A,0),Cartesian3.pack(I,w,0),E.push(L.latitude),E.push(L.longitude),interpolateSegment(L,F,p,m,u,d,c,P,A,w,E),i=1;i<T-1;++i){D=Cartesian3.clone(M,D),M=Cartesian3.clone(R,M);var N=x[i];getPosition(c,N,m,I),getPosition(c,x[i+1],p,R),computeVertexMiterNormal(D,M,I,R,O),t=P.length,Cartesian3.pack(O,P,t),Cartesian3.pack(M,A,t),Cartesian3.pack(I,w,t),E.push(N.latitude),E.push(N.longitude),interpolateSegment(x[i],x[i+1],p,m,u,d,c,P,A,w,E)}var V=x[T-1],B=x[T-2];if(M=getPosition(c,V,p,M),I=getPosition(c,V,m,I),l){var k=x[0];O=computeVertexMiterNormal(D=getPosition(c,B,p,D),M,I,R=getPosition(c,k,p,R),O)}else O=computeRightNormal(B,V,m,c,O);if(t=P.length,Cartesian3.pack(O,P,t),Cartesian3.pack(M,A,t),Cartesian3.pack(I,w,t),E.push(V.latitude),E.push(V.longitude),l){for(interpolateSegment(V,L,p,m,u,d,c,P,A,w,E),t=P.length,i=0;i<3;++i)P[t+i]=P[i],A[t+i]=A[i],w[t+i]=w[i];E.push(L.latitude),E.push(L.longitude)}return generateGeometryAttributes(l,h,A,w,P,E,s)}};var lineDirectionScratch=new Cartesian3,matrix3Scratch=new Matrix3,quaternionScratch$2=new Quaternion;function breakMiter(e,t,i,r){var n=direction(i,t,lineDirectionScratch),a=Cartesian3.dot(n,e);if(MITER_BREAK_SMALL<a||a<MITER_BREAK_LARGE){var o=direction(r,i,vertexUpScratch),s=a<MITER_BREAK_LARGE?CesiumMath.PI_OVER_TWO:-CesiumMath.PI_OVER_TWO,l=Quaternion.fromAxisAngle(o,s,quaternionScratch$2),c=Matrix3.fromQuaternion(l,matrix3Scratch);return Matrix3.multiplyByVector(c,e,e),!0}return!1}var endPosCartographicScratch=new Cartographic,normalStartpointScratch=new Cartesian3,normalEndpointScratch=new Cartesian3;function projectNormal(e,t,i,r,n){var a=Cartographic.toCartesian(t,e._ellipsoid,normalStartpointScratch),o=Cartesian3.add(a,i,normalEndpointScratch),s=!1,l=e._ellipsoid,c=l.cartesianToCartographic(o,endPosCartographicScratch);Math.abs(t.longitude-c.longitude)>CesiumMath.PI_OVER_TWO&&(s=!0,o=Cartesian3.subtract(a,i,normalEndpointScratch),c=l.cartesianToCartographic(o,endPosCartographicScratch)),c.height=0;var u=e.project(c,n);return(n=Cartesian3.subtract(u,r,n)).z=0,n=Cartesian3.normalize(n,n),s&&Cartesian3.negate(n,n),n}var adjustHeightNormalScratch=new Cartesian3,adjustHeightOffsetScratch=new Cartesian3;function adjustHeights(e,t,i,r,n,a){var o=Cartesian3.subtract(t,e,adjustHeightNormalScratch);Cartesian3.normalize(o,o);var s=i-WALL_INITIAL_MIN_HEIGHT,l=Cartesian3.multiplyByScalar(o,s,adjustHeightOffsetScratch);Cartesian3.add(e,l,n);var c=r-WALL_INITIAL_MAX_HEIGHT;l=Cartesian3.multiplyByScalar(o,c,adjustHeightOffsetScratch),Cartesian3.add(t,l,a)}var nudgeDirectionScratch=new Cartesian3;function nudgeXZ(e,t){var i=Plane.getPointDistance(XZ_PLANE,e),r=Plane.getPointDistance(XZ_PLANE,t),n=nudgeDirectionScratch;CesiumMath.equalsEpsilon(i,0,CesiumMath.EPSILON2)?(n=direction(t,e,n),Cartesian3.multiplyByScalar(n,CesiumMath.EPSILON2,n),Cartesian3.add(e,n,e)):CesiumMath.equalsEpsilon(r,0,CesiumMath.EPSILON2)&&(n=direction(e,t,n),Cartesian3.multiplyByScalar(n,CesiumMath.EPSILON2,n),Cartesian3.add(t,n,t))}function nudgeCartographic(e,t){var i=Math.abs(e.longitude),r=Math.abs(t.longitude);if(CesiumMath.equalsEpsilon(i,CesiumMath.PI,CesiumMath.EPSILON11)){var n=CesiumMath.sign(t.longitude);return e.longitude=n*(i-CesiumMath.EPSILON11),1}if(CesiumMath.equalsEpsilon(r,CesiumMath.PI,CesiumMath.EPSILON11)){var a=CesiumMath.sign(e.longitude);return t.longitude=a*(r-CesiumMath.EPSILON11),2}return 0}var startCartographicScratch=new Cartographic,endCartographicScratch=new Cartographic,segmentStartTopScratch=new Cartesian3,segmentEndTopScratch=new Cartesian3,segmentStartBottomScratch=new Cartesian3,segmentEndBottomScratch=new Cartesian3,segmentStartNormalScratch=new Cartesian3,segmentEndNormalScratch=new Cartesian3,getHeightCartographics=[startCartographicScratch,endCartographicScratch],getHeightRectangleScratch=new Rectangle,adjustHeightStartTopScratch=new Cartesian3,adjustHeightEndTopScratch=new Cartesian3,adjustHeightStartBottomScratch=new Cartesian3,adjustHeightEndBottomScratch=new Cartesian3,segmentStart2DScratch=new Cartesian3,segmentEnd2DScratch=new Cartesian3,segmentStartNormal2DScratch=new Cartesian3,segmentEndNormal2DScratch=new Cartesian3,offsetScratch$1=new Cartesian3,startUpScratch=new Cartesian3,endUpScratch=new Cartesian3,rightScratch$1=new Cartesian3,startPlaneNormalScratch=new Cartesian3,endPlaneNormalScratch=new Cartesian3,encodeScratch=new EncodedCartesian3,encodeScratch2D=new EncodedCartesian3,forwardOffset2DScratch=new Cartesian3,right2DScratch=new Cartesian3,normalNudgeScratch=new Cartesian3,scratchBoundingSpheres=[new BoundingSphere,new BoundingSphere],REFERENCE_INDICES=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],REFERENCE_INDICES_LENGTH=REFERENCE_INDICES.length;function generateGeometryAttributes(e,t,i,r,n,a,o){var s,l,c,u,d,h,p=t._ellipsoid,m=i.length/3-1,f=8*m,g=4*f,_=36*m,y=65535<f?new Uint32Array(_):new Uint16Array(_),v=new Float64Array(3*f),C=new Float32Array(g),S=new Float32Array(g),T=new Float32Array(g),x=new Float32Array(g),b=new Float32Array(g);o&&(c=new Float32Array(g),u=new Float32Array(g),d=new Float32Array(g),h=new Float32Array(2*f));var E=a.length/2,P=0,A=startCartographicScratch;A.height=0;var w=endCartographicScratch;w.height=0;var D=segmentStartTopScratch,M=segmentEndTopScratch;if(o)for(l=0,s=1;s<E;s++)A.latitude=a[l],A.longitude=a[l+1],w.latitude=a[l+2],w.longitude=a[l+3],D=t.project(A,D),M=t.project(w,M),P+=Cartesian3.distance(D,M),l+=2;var I=r.length/3;M=Cartesian3.unpack(r,0,M);var R,O=0;for(l=3,s=1;s<I;s++)D=Cartesian3.clone(M,D),M=Cartesian3.unpack(r,l,M),O+=Cartesian3.distance(D,M),l+=3;var L=0,F=0,N=0,V=0,B=!(l=3),k=Cartesian3.unpack(i,0,segmentEndBottomScratch),$=Cartesian3.unpack(r,0,segmentEndTopScratch),z=Cartesian3.unpack(n,0,segmentEndNormalScratch);e&&breakMiter(z,Cartesian3.unpack(i,i.length-6,segmentStartBottomScratch),k,$)&&(z=Cartesian3.negate(z,z));var U=0,G=0,H=0;for(s=0;s<m;s++){var W,q,j,Y,X=Cartesian3.clone(k,segmentStartBottomScratch),Q=Cartesian3.clone($,segmentStartTopScratch),J=Cartesian3.clone(z,segmentStartNormalScratch);if(B&&(J=Cartesian3.negate(J,J)),k=Cartesian3.unpack(i,l,segmentEndBottomScratch),$=Cartesian3.unpack(r,l,segmentEndTopScratch),B=breakMiter(z=Cartesian3.unpack(n,l,segmentEndNormalScratch),X,k,$),A.latitude=a[L],A.longitude=a[L+1],w.latitude=a[L+2],w.longitude=a[L+3],o){var Z=nudgeCartographic(A,w);W=t.project(A,segmentStart2DScratch);var K=direction(q=t.project(w,segmentEnd2DScratch),W,forwardOffset2DScratch);K.y=Math.abs(K.y),j=segmentStartNormal2DScratch,Y=segmentEndNormal2DScratch,0===Z||Cartesian3.dot(K,Cartesian3.UNIT_Y)>MITER_BREAK_SMALL?(j=projectNormal(t,A,J,W,segmentStartNormal2DScratch),Y=projectNormal(t,w,z,q,segmentEndNormal2DScratch)):1===Z?(Y=projectNormal(t,w,z,q,segmentEndNormal2DScratch),j.x=0,j.y=CesiumMath.sign(A.longitude-Math.abs(w.longitude)),j.z=0):(j=projectNormal(t,A,J,W,segmentStartNormal2DScratch),Y.x=0,Y.y=CesiumMath.sign(A.longitude-w.longitude),Y.z=0)}var ee=Cartesian3.distance(Q,$),te=EncodedCartesian3.fromCartesian(X,encodeScratch),ie=Cartesian3.subtract(k,X,offsetScratch$1),re=Cartesian3.normalize(ie,rightScratch$1),ne=Cartesian3.subtract(Q,X,startUpScratch);ne=Cartesian3.normalize(ne,ne);var ae=Cartesian3.cross(re,ne,rightScratch$1);ae=Cartesian3.normalize(ae,ae);var oe=Cartesian3.cross(ne,J,startPlaneNormalScratch);oe=Cartesian3.normalize(oe,oe);var se=Cartesian3.subtract($,k,endUpScratch);se=Cartesian3.normalize(se,se);var le=Cartesian3.cross(z,se,endPlaneNormalScratch);le=Cartesian3.normalize(le,le);var ce,ue,de,he=ee/O,pe=U/O,me=0,fe=0,ge=0;if(o){me=Cartesian3.distance(W,q),ce=EncodedCartesian3.fromCartesian(W,encodeScratch2D),ue=Cartesian3.subtract(q,W,forwardOffset2DScratch);var _e=(de=Cartesian3.normalize(ue,right2DScratch)).x;de.x=de.y,de.y=-_e,fe=me/P,ge=G/P}for(R=0;R<8;R++){var ye=V+4*R,ve=F+2*R,Ce=ye+3,Se=R<4?1:-1,Te=2===R||3===R||6===R||7===R?1:-1;Cartesian3.pack(te.high,C,ye),C[Ce]=ie.x,Cartesian3.pack(te.low,S,ye),S[Ce]=ie.y,Cartesian3.pack(oe,T,ye),T[Ce]=ie.z,Cartesian3.pack(le,x,ye),x[Ce]=he*Se,Cartesian3.pack(ae,b,ye);var xe=pe*Te;0===xe&&Te<0&&(xe=9),b[Ce]=xe,o&&(c[ye]=ce.high.x,c[ye+1]=ce.high.y,c[ye+2]=ce.low.x,c[ye+3]=ce.low.y,d[ye]=-j.y,d[ye+1]=j.x,d[ye+2]=Y.y,d[ye+3]=-Y.x,u[ye]=ue.x,u[ye+1]=ue.y,u[ye+2]=de.x,u[ye+3]=de.y,h[ve]=fe*Se,0===(xe=ge*Te)&&Te<0&&(xe=9),h[ve+1]=xe)}var be=adjustHeightStartBottomScratch,Ee=adjustHeightEndBottomScratch,Pe=adjustHeightStartTopScratch,Ae=adjustHeightEndTopScratch,we=Rectangle.fromCartographicArray(getHeightCartographics,getHeightRectangleScratch),De=ApproximateTerrainHeights.getMinimumMaximumHeights(we,p),Me=De.minimumTerrainHeight,Ie=De.maximumTerrainHeight;H+=Me,H+=Ie,adjustHeights(X,Q,Me,Ie,be,Pe),adjustHeights(k,$,Me,Ie,Ee,Ae);var Re=Cartesian3.multiplyByScalar(ae,CesiumMath.EPSILON5,normalNudgeScratch);Cartesian3.add(be,Re,be),Cartesian3.add(Ee,Re,Ee),Cartesian3.add(Pe,Re,Pe),Cartesian3.add(Ae,Re,Ae),nudgeXZ(be,Ee),nudgeXZ(Pe,Ae),Cartesian3.pack(be,v,N),Cartesian3.pack(Ee,v,N+3),Cartesian3.pack(Ae,v,N+6),Cartesian3.pack(Pe,v,N+9),Re=Cartesian3.multiplyByScalar(ae,-2*CesiumMath.EPSILON5,normalNudgeScratch),Cartesian3.add(be,Re,be),Cartesian3.add(Ee,Re,Ee),Cartesian3.add(Pe,Re,Pe),Cartesian3.add(Ae,Re,Ae),nudgeXZ(be,Ee),nudgeXZ(Pe,Ae),Cartesian3.pack(be,v,N+12),Cartesian3.pack(Ee,v,N+15),Cartesian3.pack(Ae,v,N+18),Cartesian3.pack(Pe,v,N+21),L+=2,l+=3,F+=16,N+=24,V+=32,U+=ee,G+=me}var Oe=l=0;for(s=0;s<m;s++){for(R=0;R<REFERENCE_INDICES_LENGTH;R++)y[l+R]=REFERENCE_INDICES[R]+Oe;Oe+=8,l+=REFERENCE_INDICES_LENGTH}var Le=scratchBoundingSpheres;BoundingSphere.fromVertices(i,Cartesian3.ZERO,3,Le[0]),BoundingSphere.fromVertices(r,Cartesian3.ZERO,3,Le[1]);var Fe=BoundingSphere.fromBoundingSpheres(Le);Fe.radius+=H/(2*m);var Ne={position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,normalize:!1,values:v}),startHiAndForwardOffsetX:getVec4GeometryAttribute(C),startLoAndForwardOffsetY:getVec4GeometryAttribute(S),startNormalAndForwardOffsetZ:getVec4GeometryAttribute(T),endNormalAndTextureCoordinateNormalizationX:getVec4GeometryAttribute(x),rightNormalAndTextureCoordinateNormalizationY:getVec4GeometryAttribute(b)};return o&&(Ne.startHiLo2D=getVec4GeometryAttribute(c),Ne.offsetAndRight2D=getVec4GeometryAttribute(u),Ne.startEndNormals2D=getVec4GeometryAttribute(d),Ne.texcoordNormalization2D=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,normalize:!1,values:h})),new Geometry({attributes:Ne,indices:y,boundingSphere:Fe})}function getVec4GeometryAttribute(e){return new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:4,normalize:!1,values:e})}function HeadingPitchRange(e,t,i){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.range=defaultValue(i,0)}GroundPolylineGeometry._projectNormal=projectNormal,HeadingPitchRange.clone=function(e,t){if(defined(e))return defined(t)||(t=new HeadingPitchRange),t.heading=e.heading,t.pitch=e.pitch,t.range=e.range,t};var factorial=CesiumMath.factorial;function calculateCoefficientTerm(e,t,i,r,n,a){var o,s,l,c=0;if(0<r){for(s=0;s<n;s++){for(o=!1,l=0;l<a.length&&!o;l++)s===a[l]&&(o=!0);o||(a.push(s),c+=calculateCoefficientTerm(e,t,i,r-1,n,a),a.splice(a.length-1,1))}return c}for(c=1,s=0;s<n;s++){for(o=!1,l=0;l<a.length&&!o;l++)s===a[l]&&(o=!0);o||(c*=e-i[t[s]])}return c}var HermitePolynomialApproximation={type:"Hermite",getRequiredDataPoints:function(e,t){return t=defaultValue(t,0),Math.max(Math.floor((e+1)/(t+1)),2)},interpolateOrderZero:function(e,t,i,r,n){var a,o,s,l,c;defined(n)||(n=new Array(r));var u=t.length,d=new Array(r);for(a=0;a<r;a++){n[a]=0;var h=new Array(u);for(d[a]=h,o=0;o<u;o++)h[o]=[]}var p=u,m=new Array(p);for(a=0;a<p;a++)m[a]=a;var f=u-1;for(l=0;l<r;l++){for(o=0;o<p;o++)c=m[o]*r+l,d[l][0].push(i[c]);for(a=1;a<p;a++){var g=!1;for(o=0;o<p-a;o++){var _,y=t[m[o]],v=t[m[o+a]];v-y<=0?(_=i[c=m[o]*r+r*a+l],d[l][a].push(_/factorial(a))):(_=d[l][a-1][o+1]-d[l][a-1][o],d[l][a].push(_/(v-y))),g=g||0!==_}g||(f=a-1)}}for(s=0;s<=0;s++)for(a=s;a<=f;a++){var C=calculateCoefficientTerm(e,m,t,s,a,[]);for(l=0;l<r;l++){var S=d[l][a][0];n[l+s*r]+=S*C}}return n}},arrayScratch$1=[];function fillCoefficientList(e,t,i,r,n,a){for(var o,s,l=-1,c=t.length,u=c*(c+1)/2,d=0;d<n;d++){var h=Math.floor(d*u);for(o=0;o<c;o++)s=t[o]*n*(a+1)+d,e[h+o]=r[s];for(var p=1;p<c;p++){var m=0,f=Math.floor(p*(1-p)/2)+c*p,g=!1;for(o=0;o<c-p;o++){var _,y,v=i[t[o]],C=i[t[o+p]];if(C-v<=0)y=(_=r[s=t[o]*n*(a+1)+n*p+d])/CesiumMath.factorial(p),e[h+f+m]=y,m++;else{var S=Math.floor((p-1)*(2-p)/2)+c*(p-1);y=(_=e[h+S+o+1]-e[h+S+o])/(C-v),e[h+f+m]=y,m++}g=g||0!==_}g&&(l=Math.max(l,p))}}return l}function IauOrientationParameters(e,t,i,r){this.rightAscension=e,this.declination=t,this.rotation=i,this.rotationRate=r}HermitePolynomialApproximation.interpolate=function(e,t,i,r,n,a,o){var s=r*(a+1);defined(o)||(o=new Array(s));for(var l=0;l<s;l++)o[l]=0;var c,u=t.length,d=new Array(u*(n+1));for(c=0;c<u;c++)for(var h=0;h<n+1;h++)d[c*(n+1)+h]=c;for(var p=d.length,m=arrayScratch$1,f=fillCoefficientList(m,d,t,i,r,n),g=[],_=p*(p+1)/2,y=Math.min(f,a),v=0;v<=y;v++)for(c=v;c<=f;c++){g.length=0;for(var C=calculateCoefficientTerm(e,d,t,v,c,g),S=Math.floor(c*(1-c)/2)+p*c,T=0;T<r;T++){var x=m[Math.floor(T*_)+S];o[T+v*r]+=x*C}}return o};var Iau2000Orientation={},TdtMinusTai=32.184,J2000d=2451545,c1=-.0529921,c2=-.1059842,c3$1=13.0120009,c4=13.3407154,c5=.9856003,c6=26.4057084,c7=13.064993,c8=.3287146,c9=1.7484877,c10=-.1589763,c11=.0036096,c12=.1643573,c13=12.9590088,dateTT=new JulianDate;function IauOrientationAxes(e){defined(e)&&"function"==typeof e||(e=Iau2000Orientation.ComputeMoon),this._computeFunction=e}Iau2000Orientation.ComputeMoon=function(e,t){defined(e)||(e=JulianDate.now()),dateTT=JulianDate.addSeconds(e,TdtMinusTai,dateTT);var i=JulianDate.totalDays(dateTT)-J2000d,r=i/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,n=(125.045+c1*i)*CesiumMath.RADIANS_PER_DEGREE,a=(250.089+c2*i)*CesiumMath.RADIANS_PER_DEGREE,o=(260.008+c3$1*i)*CesiumMath.RADIANS_PER_DEGREE,s=(176.625+c4*i)*CesiumMath.RADIANS_PER_DEGREE,l=(357.529+c5*i)*CesiumMath.RADIANS_PER_DEGREE,c=(311.589+c6*i)*CesiumMath.RADIANS_PER_DEGREE,u=(134.963+c7*i)*CesiumMath.RADIANS_PER_DEGREE,d=(276.617+c8*i)*CesiumMath.RADIANS_PER_DEGREE,h=(34.226+c9*i)*CesiumMath.RADIANS_PER_DEGREE,p=(15.134+c10*i)*CesiumMath.RADIANS_PER_DEGREE,m=(119.743+c11*i)*CesiumMath.RADIANS_PER_DEGREE,f=(239.961+c12*i)*CesiumMath.RADIANS_PER_DEGREE,g=(25.053+c13*i)*CesiumMath.RADIANS_PER_DEGREE,_=Math.sin(n),y=Math.sin(a),v=Math.sin(o),C=Math.sin(s),S=Math.sin(l),T=Math.sin(c),x=Math.sin(u),b=Math.sin(d),E=Math.sin(h),P=Math.sin(p),A=Math.sin(m),w=Math.sin(f),D=Math.sin(g),M=Math.cos(n),I=Math.cos(a),R=Math.cos(o),O=Math.cos(s),L=Math.cos(l),F=Math.cos(c),N=Math.cos(u),V=Math.cos(d),B=Math.cos(h),k=Math.cos(p),$=Math.cos(m),z=Math.cos(f),U=Math.cos(g),G=(269.9949+.0031*r-3.8787*_-.1204*y+.07*v-.0172*C+.0072*T-.0052*P+.0043*D)*CesiumMath.RADIANS_PER_DEGREE,H=(66.5392+.013*r+1.5419*M+.0239*I-.0278*R+.0068*O-.0029*F+9e-4*N+8e-4*k-9e-4*U)*CesiumMath.RADIANS_PER_DEGREE,W=(38.3213+13.17635815*i-14e-13*i*i+3.561*_+.1208*y-.0642*v+.0158*C+.0252*S-.0066*T-.0047*x-.0046*b+.0028*E+.0052*P+.004*A+.0019*w-.0044*D)*CesiumMath.RADIANS_PER_DEGREE,q=(13.17635815-2*i*14e-13+3.561*M*c1+.1208*I*c2-.0642*R*c3$1+.0158*O*c4+.0252*L*c5-.0066*F*c6-.0047*N*c7-.0046*V*c8+.0028*B*c9+.0052*k*c10+.004*$*c11+.0019*z*c12-.0044*U*c13)/86400*CesiumMath.RADIANS_PER_DEGREE;return defined(t)||(t=new IauOrientationParameters),t.rightAscension=G,t.declination=H,t.rotation=W,t.rotationRate=q,t};var xAxisScratch=new Cartesian3,yAxisScratch=new Cartesian3,zAxisScratch=new Cartesian3;function computeRotationMatrix(e,t,i){var r=xAxisScratch;r.x=Math.cos(e+CesiumMath.PI_OVER_TWO),r.y=Math.sin(e+CesiumMath.PI_OVER_TWO),r.z=0;var n=Math.cos(t),a=zAxisScratch;a.x=n*Math.cos(e),a.y=n*Math.sin(e),a.z=Math.sin(t);var o=Cartesian3.cross(a,r,yAxisScratch);return defined(i)||(i=new Matrix3),i[0]=r.x,i[1]=o.x,i[2]=a.x,i[3]=r.y,i[4]=o.y,i[5]=a.y,i[6]=r.z,i[7]=o.z,i[8]=a.z,i}var rotMtxScratch=new Matrix3,quatScratch=new Quaternion;IauOrientationAxes.prototype.evaluate=function(e,t){defined(e)||(e=JulianDate.now());var i=this._computeFunction(e),r=computeRotationMatrix(i.rightAscension,i.declination,t),n=CesiumMath.zeroToTwoPi(i.rotation),a=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,n,quatScratch),o=Matrix3.fromQuaternion(Quaternion.conjugate(a,a),rotMtxScratch);return Matrix3.multiply(o,r,r)};var InterpolationAlgorithm={},defaultTokenCredit;InterpolationAlgorithm.type=void 0,InterpolationAlgorithm.getRequiredDataPoints=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolateOrderZero=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolate=DeveloperError.throwInstantiationError;var defaultAccessToken="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiJlYmY1OGY2NS1kODVmLTQxNTUtOWY5YS00ODE1Y2E1ZjFkZTQiLCJpZCI6MjU5LCJzY29wZXMiOlsiYXNyIiwiZ2MiXSwiaWF0IjoxNTcyNjI4NjQ5fQ.CYr8wbSJnOsWz4x2ufDHVe7CGvWzEWl4HzcOcceaNCE",Ion={};function PeliasGeocoderService(e){this._url=Resource.createIfNeeded(e),this._url.appendForwardSlash()}function IonGeocoderService(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.accessToken,Ion.defaultAccessToken),i=Resource.createIfNeeded(defaultValue(e.server,Ion.defaultServer));i.appendForwardSlash();var r=Ion.getDefaultTokenCredit(t);defined(r)&&e.scene.frameState.creditDisplay.addDefaultCredit(Credit.clone(r));var n=i.getDerivedResource({url:"v1/geocode"});defined(t)&&n.appendQueryParameters({access_token:t}),this._accessToken=t,this._server=i,this._pelias=new PeliasGeocoderService(n)}function IonResource(e,t){var i,r=e.externalType,n=defined(r);if(n){if("3DTILES"!==r&&"STK_TERRAIN_SERVER"!==r)throw new RuntimeError("Ion.createResource does not support external imagery assets; use IonImageryProvider instead.");i={url:e.options.url}}else i={url:e.url,retryAttempts:1,retryCallback:retryCallback};Resource.call(this,i),this._ionEndpoint=e,this._ionEndpointDomain=n?void 0:new URI(e.url).authority,this._ionEndpointResource=t,this._ionRoot=void 0,this._pendingPromise=void 0,this._credits=void 0,this._isExternal=n}function retryCallback(t,e){var i=defaultValue(t._ionRoot,t),r=i._ionEndpointResource;return defined(e)&&(401===e.statusCode||e.target instanceof Image)?(defined(i._pendingPromise)||(i._pendingPromise=r.fetchJson().then(function(e){return i._ionEndpoint=e}).always(function(e){return i._pendingPromise=void 0,e})),i._pendingPromise.then(function(e){return t._ionEndpoint=e,!0})):when.resolve(!1)}function TimeInterval(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.start=defined(e.start)?JulianDate.clone(e.start):new JulianDate,this.stop=defined(e.stop)?JulianDate.clone(e.stop):new JulianDate,this.data=e.data,this.isStartIncluded=defaultValue(e.isStartIncluded,!0),this.isStopIncluded=defaultValue(e.isStopIncluded,!0)}Ion.defaultAccessToken=defaultAccessToken,Ion.defaultServer=new Resource({url:"https://api.cesium.com/"}),Ion.getDefaultTokenCredit=function(e){if(e===defaultAccessToken){if(!defined(defaultTokenCredit)){defaultTokenCredit=new Credit('<b>             This application is using Cesium\'s default ion access token. Please assign <i>Cesium.Ion.defaultAccessToken</i>             with an access token from your ion account before making any Cesium API calls.             You can sign up for a free ion account at <a href="https://cesium.com">https://cesium.com</a>.</b>',!0)}return defaultTokenCredit}},defineProperties$1(PeliasGeocoderService.prototype,{url:{get:function(){return this._url}}}),PeliasGeocoderService.prototype.geocode=function(e,t){return this._url.getDerivedResource({url:t===GeocodeType$1.AUTOCOMPLETE?"autocomplete":"search",queryParameters:{text:e}}).fetchJson().then(function(e){return e.features.map(function(e){var t,i=e.bbox;if(defined(i))t=Rectangle.fromDegrees(i[0],i[1],i[2],i[3]);else{var r=e.geometry.coordinates[0],n=e.geometry.coordinates[1];t=Cartesian3.fromDegrees(r,n)}return{displayName:e.properties.label,destination:t}})})},IonGeocoderService.prototype.geocode=function(e,t){return this._pelias.geocode(e,t)},defined(Object.create)&&(IonResource.prototype=Object.create(Resource.prototype),IonResource.prototype.constructor=IonResource),IonResource.fromAssetId=function(e,t){var i=IonResource._createEndpointResource(e,t);return i.fetchJson().then(function(e){return new IonResource(e,i)})},defineProperties$1(IonResource.prototype,{credits:{get:function(){return defined(this._ionRoot)?this._ionRoot.credits:(defined(this._credits)||(this._credits=IonResource.getCreditsFromEndpoint(this._ionEndpoint,this._ionEndpointResource)),this._credits)}}}),IonResource.getCreditsFromEndpoint=function(e,t){var i=e.attributions.map(Credit.getIonCredit),r=Ion.getDefaultTokenCredit(t.queryParameters.access_token);return defined(r)&&i.push(Credit.clone(r)),i},IonResource.prototype.clone=function(e){var t=defaultValue(this._ionRoot,this);return defined(e)||(e=new IonResource(t._ionEndpoint,t._ionEndpointResource)),(e=Resource.prototype.clone.call(this,e))._ionRoot=t,e._isExternal=this._isExternal,e},IonResource.prototype.fetchImage=function(e){if(!this._isExternal){var t=e;e={preferBlob:!0},defined(t)&&(e.flipY=t.flipY,e.preferImageBitmap=t.preferImageBitmap)}return Resource.prototype.fetchImage.call(this,e)},IonResource.prototype._makeRequest=function(e){if(this._isExternal||new URI(this.url).authority!==this._ionEndpointDomain)return Resource.prototype._makeRequest.call(this,e);var t="*/*;access_token="+this._ionEndpoint.accessToken,i=t,r=this.headers;return defined(r)&&defined(r.Accept)&&(i=r.Accept+","+t),defined(e.headers)?defined(e.headers.Accept)?e.headers.Accept=e.headers.Accept+","+t:e.headers.Accept=i:e.headers={Accept:i},Resource.prototype._makeRequest.call(this,e)},IonResource._createEndpointResource=function(e,t){t=defaultValue(t,defaultValue.EMPTY_OBJECT);var i=defaultValue(t.server,Ion.defaultServer),r=defaultValue(t.accessToken,Ion.defaultAccessToken);i=Resource.createIfNeeded(i);var n={url:"v1/assets/"+e+"/endpoint"};return defined(r)&&(n.queryParameters={access_token:r}),i.getDerivedResource(n)},defineProperties$1(TimeInterval.prototype,{isEmpty:{get:function(){var e=JulianDate.compare(this.stop,this.start);return e<0||0===e&&(!this.isStartIncluded||!this.isStopIncluded)}}});var scratchInterval={start:void 0,stop:void 0,isStartIncluded:void 0,isStopIncluded:void 0,data:void 0};TimeInterval.fromIso8601=function(e,t){var i=e.iso8601.split("/");if(2!==i.length)throw new DeveloperError("options.iso8601 is an invalid ISO 8601 interval.");var r=JulianDate.fromIso8601(i[0]),n=JulianDate.fromIso8601(i[1]),a=defaultValue(e.isStartIncluded,!0),o=defaultValue(e.isStopIncluded,!0),s=e.data;return defined(t)?(t.start=r,t.stop=n,t.isStartIncluded=a,t.isStopIncluded=o,t.data=s,t):(scratchInterval.start=r,scratchInterval.stop=n,scratchInterval.isStartIncluded=a,scratchInterval.isStopIncluded=o,scratchInterval.data=s,new TimeInterval(scratchInterval))},TimeInterval.toIso8601=function(e,t){return JulianDate.toIso8601(e.start,t)+"/"+JulianDate.toIso8601(e.stop,t)},TimeInterval.clone=function(e,t){if(defined(e))return defined(t)?(t.start=e.start,t.stop=e.stop,t.isStartIncluded=e.isStartIncluded,t.isStopIncluded=e.isStopIncluded,t.data=e.data,t):new TimeInterval(e)},TimeInterval.equals=function(e,t,i){return e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equals(e.start,t.start)&&JulianDate.equals(e.stop,t.stop)&&(e.data===t.data||defined(i)&&i(e.data,t.data)))},TimeInterval.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equalsEpsilon(e.start,t.start,i)&&JulianDate.equalsEpsilon(e.stop,t.stop,i)&&(e.data===t.data||defined(r)&&r(e.data,t.data)))},TimeInterval.intersect=function(e,t,i,r){if(!defined(t))return TimeInterval.clone(TimeInterval.EMPTY,i);var n=e.start,a=e.stop,o=t.start,s=t.stop,l=JulianDate.greaterThanOrEquals(o,n)&&JulianDate.greaterThanOrEquals(a,o),c=!l&&JulianDate.lessThanOrEquals(o,n)&&JulianDate.lessThanOrEquals(n,s);if(!l&&!c)return TimeInterval.clone(TimeInterval.EMPTY,i);var u=e.isStartIncluded,d=e.isStopIncluded,h=t.isStartIncluded,p=t.isStopIncluded,m=JulianDate.lessThan(a,s);return i.start=l?o:n,i.isStartIncluded=u&&h||!JulianDate.equals(o,n)&&(l&&h||c&&u),i.stop=m?a:s,i.isStopIncluded=m?d:d&&p||!JulianDate.equals(s,a)&&p,i.data=defined(r)?r(e.data,t.data):e.data,i},TimeInterval.contains=function(e,t){if(e.isEmpty)return!1;var i=JulianDate.compare(e.start,t);if(0===i)return e.isStartIncluded;var r=JulianDate.compare(t,e.stop);return 0===r?e.isStopIncluded:i<0&&r<0},TimeInterval.prototype.clone=function(e){return TimeInterval.clone(this,e)},TimeInterval.prototype.equals=function(e,t){return TimeInterval.equals(this,e,t)},TimeInterval.prototype.equalsEpsilon=function(e,t,i){return TimeInterval.equalsEpsilon(this,e,t,i)},TimeInterval.prototype.toString=function(){return TimeInterval.toIso8601(this)},TimeInterval.EMPTY=freezeObject$1(new TimeInterval({start:new JulianDate,stop:new JulianDate,isStartIncluded:!1,isStopIncluded:!1}));var MINIMUM_VALUE=freezeObject$1(JulianDate.fromIso8601("0000-01-01T00:00:00Z")),MAXIMUM_VALUE=freezeObject$1(JulianDate.fromIso8601("9999-12-31T24:00:00Z")),MAXIMUM_INTERVAL=freezeObject$1(new TimeInterval({start:MINIMUM_VALUE,stop:MAXIMUM_VALUE})),Iso8601={MINIMUM_VALUE:MINIMUM_VALUE,MAXIMUM_VALUE:MAXIMUM_VALUE,MAXIMUM_INTERVAL:MAXIMUM_INTERVAL},KeyboardEventModifier={SHIFT:0,CTRL:1,ALT:2},KeyboardEventModifier$1=freezeObject$1(KeyboardEventModifier),LagrangePolynomialApproximation={type:"Lagrange",getRequiredDataPoints:function(e){return Math.max(e+1,2)},interpolateOrderZero:function(e,t,i,r,n){var a,o;defined(n)||(n=new Array(r));var s=t.length;for(a=0;a<r;a++)n[a]=0;for(a=0;a<s;a++){var l=1;for(o=0;o<s;o++)if(o!==a){var c=t[a]-t[o];l*=(e-t[o])/c}for(o=0;o<r;o++)n[o]+=l*i[a*r+o]}return n}},LinearApproximation={type:"Linear"};function ManagedArray(e){e=defaultValue(e,0),this._array=new Array(e),this._length=e}function MapProjection(){DeveloperError.throwInstantiationError()}LinearApproximation.getRequiredDataPoints=function(e){return 2},LinearApproximation.interpolateOrderZero=function(e,t,i,r,n){var a,o,s;defined(n)||(n=new Array(r));var l=t[0],c=t[1];for(a=0;a<r;a++)o=i[a],s=i[a+r],n[a]=((s-o)*e+c*o-l*s)/(c-l);return n},defineProperties$1(ManagedArray.prototype,{length:{get:function(){return this._length},set:function(e){(this._length=e)>this._array.length&&(this._array.length=e)}},values:{get:function(){return this._array}}}),ManagedArray.prototype.get=function(e){return this._array[e]},ManagedArray.prototype.set=function(e,t){e>=this.length&&(this.length=e+1),this._array[e]=t},ManagedArray.prototype.peek=function(){return this._array[this._length-1]},ManagedArray.prototype.push=function(e){var t=this.length++;this._array[t]=e},ManagedArray.prototype.pop=function(){return this._array[--this.length]},ManagedArray.prototype.reserve=function(e){e>this._array.length&&(this._array.length=e)},ManagedArray.prototype.resize=function(e){this.length=e},ManagedArray.prototype.trim=function(e){e=defaultValue(e,this.length),this._array.length=e},defineProperties$1(MapProjection.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError}}),MapProjection.prototype.project=DeveloperError.throwInstantiationError,MapProjection.prototype.unproject=DeveloperError.throwInstantiationError;var MapboxApi={defaultAccessToken:void 0},printedMapboxWarning=!1,errorCredit,errorString="<b>This application is using Cesium's default Mapbox access token.  Please create a new access token for the application as soon as possible and prior to deployment by visiting <a href=https://www.mapbox.com/account/apps/>https://www.mapbox.com/account/apps/</a>, and provide your token to Cesium by setting the Cesium.MapboxApi.defaultAccessToken property before constructing the CesiumWidget or any other object that uses the Mapbox API.</b>";function NearFarScalar(e,t,i,r){this.near=defaultValue(e,0),this.nearValue=defaultValue(t,0),this.far=defaultValue(i,1),this.farValue=defaultValue(r,0)}MapboxApi.getAccessToken=function(e){return defined(e)?e:defined(MapboxApi.defaultAccessToken)?MapboxApi.defaultAccessToken:(printedMapboxWarning||(console.log(errorString),printedMapboxWarning=!0),"pk.eyJ1IjoiYW5hbHl0aWNhbGdyYXBoaWNzIiwiYSI6ImNpd204Zm4wejAwNzYyeW5uNjYyZmFwdWEifQ.7i-VIZZWX8pd1bTfxIVj9g")},MapboxApi.getErrorCredit=function(e){if(!defined(e)&&!defined(MapboxApi.defaultAccessToken))return defined(errorCredit)||(errorCredit=new Credit(errorString,!0)),errorCredit},NearFarScalar.clone=function(e,t){if(defined(e))return defined(t)?(t.near=e.near,t.nearValue=e.nearValue,t.far=e.far,t.farValue=e.farValue,t):new NearFarScalar(e.near,e.nearValue,e.far,e.farValue)},NearFarScalar.packedLength=4,NearFarScalar.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.near,t[i++]=e.nearValue,t[i++]=e.far,t[i]=e.farValue,t},NearFarScalar.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new NearFarScalar),i.near=e[t++],i.nearValue=e[t++],i.far=e[t++],i.farValue=e[t],i},NearFarScalar.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.nearValue===t.nearValue&&e.far===t.far&&e.farValue===t.farValue},NearFarScalar.prototype.clone=function(e){return NearFarScalar.clone(this,e)},NearFarScalar.prototype.equals=function(e){return NearFarScalar.equals(this,e)};var Visibility={NONE:-1,PARTIAL:0,FULL:1},Visibility$1=freezeObject$1(Visibility);function Occluder(e,t){this._occluderPosition=Cartesian3.clone(e.center),this._occluderRadius=e.radius,this._horizonDistance=0,this._horizonPlaneNormal=void 0,this._horizonPlanePosition=void 0,this._cameraPosition=void 0,this.cameraPosition=t}var scratchCartesian3$7=new Cartesian3;defineProperties$1(Occluder.prototype,{position:{get:function(){return this._occluderPosition}},radius:{get:function(){return this._occluderRadius}},cameraPosition:{set:function(e){e=Cartesian3.clone(e,this._cameraPosition);var t,i,r,n=Cartesian3.subtract(this._occluderPosition,e,scratchCartesian3$7),a=Cartesian3.magnitudeSquared(n),o=this._occluderRadius*this._occluderRadius;if(o<a){t=Math.sqrt(a-o),a=1/Math.sqrt(a),i=Cartesian3.multiplyByScalar(n,a,scratchCartesian3$7);var s=t*t*a;r=Cartesian3.add(e,Cartesian3.multiplyByScalar(i,s,scratchCartesian3$7),scratchCartesian3$7)}else t=Number.MAX_VALUE;this._horizonDistance=t,this._horizonPlaneNormal=i,this._horizonPlanePosition=r,this._cameraPosition=e}}}),Occluder.fromBoundingSphere=function(e,t,i){return defined(i)?(Cartesian3.clone(e.center,i._occluderPosition),i._occluderRadius=e.radius,i.cameraPosition=t,i):new Occluder(e,t)};var tempVecScratch=new Cartesian3;Occluder.prototype.isPointVisible=function(e){if(this._horizonDistance!==Number.MAX_VALUE){var t=Cartesian3.subtract(e,this._occluderPosition,tempVecScratch),i=this._occluderRadius;if(0<(i=Cartesian3.magnitudeSquared(t)-i*i))return i=Math.sqrt(i)+this._horizonDistance,t=Cartesian3.subtract(e,this._cameraPosition,t),i*i>Cartesian3.magnitudeSquared(t)}return!1};var occludeePositionScratch=new Cartesian3;Occluder.prototype.isBoundingSphereVisible=function(e){var t=Cartesian3.clone(e.center,occludeePositionScratch),i=e.radius;if(this._horizonDistance===Number.MAX_VALUE)return!1;var r=Cartesian3.subtract(t,this._occluderPosition,tempVecScratch),n=this._occluderRadius-i;if(n=Cartesian3.magnitudeSquared(r)-n*n,i<this._occluderRadius)return 0<n&&(n=Math.sqrt(n)+this._horizonDistance,r=Cartesian3.subtract(t,this._cameraPosition,r),n*n+i*i>Cartesian3.magnitudeSquared(r));if(0<n){r=Cartesian3.subtract(t,this._cameraPosition,r);var a=Cartesian3.magnitudeSquared(r),o=this._occluderRadius*this._occluderRadius,s=i*i;return(this._horizonDistance*this._horizonDistance+o)*s>a*o||a<(n=Math.sqrt(n)+this._horizonDistance)*n+s}return!0};var tempScratch$1=new Cartesian3;Occluder.prototype.computeVisibility=function(e){var t=Cartesian3.clone(e.center),i=e.radius;if(i>this._occluderRadius)return Visibility$1.FULL;if(this._horizonDistance!==Number.MAX_VALUE){var r=Cartesian3.subtract(t,this._occluderPosition,tempScratch$1),n=this._occluderRadius-i,a=Cartesian3.magnitudeSquared(r);if(0<(n=a-n*n)){n=Math.sqrt(n)+this._horizonDistance,r=Cartesian3.subtract(t,this._cameraPosition,r);var o=Cartesian3.magnitudeSquared(r);return n*n+i*i<o?Visibility$1.NONE:0<(n=a-(n=this._occluderRadius+i)*n)?o<(n=Math.sqrt(n)+this._horizonDistance)*n+i*i?Visibility$1.FULL:Visibility$1.PARTIAL:(r=Cartesian3.subtract(t,this._horizonPlanePosition,r),Cartesian3.dot(r,this._horizonPlaneNormal)>-i?Visibility$1.PARTIAL:Visibility$1.FULL)}}return Visibility$1.NONE};var occludeePointScratch=new Cartesian3;Occluder.computeOccludeePoint=function(e,t,i){var r=Cartesian3.clone(t),n=Cartesian3.clone(e.center),a=e.radius,o=i.length,s=Cartesian3.normalize(Cartesian3.subtract(r,n,occludeePointScratch),occludeePointScratch),l=-Cartesian3.dot(s,n),c=Occluder._anyRotationVector(n,s,l),u=Occluder._horizonToPlaneNormalDotProduct(e,s,l,c,i[0]);if(u){for(var d,h=1;h<o;++h){if(!(d=Occluder._horizonToPlaneNormalDotProduct(e,s,l,c,i[h])))return;d<u&&(u=d)}if(!(u<.0017453283658983088)){var p=a/u;return Cartesian3.add(n,Cartesian3.multiplyByScalar(s,p,occludeePointScratch),occludeePointScratch)}}};var computeOccludeePointFromRectangleScratch=[];Occluder.computeOccludeePointFromRectangle=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=Rectangle.subsample(e,t,0,computeOccludeePointFromRectangleScratch),r=BoundingSphere.fromPoints(i),n=Cartesian3.ZERO;if(!Cartesian3.equals(n,r.center))return Occluder.computeOccludeePoint(new BoundingSphere(n,t.minimumRadius),r.center,i)};var tempVec0Scratch=new Cartesian3;Occluder._anyRotationVector=function(e,t,i){var r=Cartesian3.abs(t,tempVec0Scratch),n=r.x>r.y?0:1;(0===n&&r.z>r.x||1===n&&r.z>r.y)&&(n=2);var a,o=new Cartesian3;a=0===n?(r.x=e.x,r.y=e.y+1,r.z=e.z+1,Cartesian3.UNIT_X):1===n?(r.x=e.x+1,r.y=e.y,r.z=e.z+1,Cartesian3.UNIT_Y):(r.x=e.x+1,r.y=e.y+1,r.z=e.z,Cartesian3.UNIT_Z);var s=(Cartesian3.dot(t,r)+i)/-Cartesian3.dot(t,a);return Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(r,Cartesian3.multiplyByScalar(a,s,o),r),e,r),r)};var posDirectionScratch=new Cartesian3;Occluder._rotationVector=function(e,t,i,r,n){var a=Cartesian3.subtract(r,e,posDirectionScratch);if(a=Cartesian3.normalize(a,a),Cartesian3.dot(t,a)<.9999999847691291){var o=Cartesian3.cross(t,a,a);if(Cartesian3.magnitude(o)>CesiumMath.EPSILON13)return Cartesian3.normalize(o,new Cartesian3)}return n};var posScratch1=new Cartesian3,occluerPosScratch=new Cartesian3,posScratch2=new Cartesian3,horizonPlanePosScratch=new Cartesian3;function OffsetGeometryInstanceAttribute(e,t,i){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),this.value=new Float32Array([e,t,i])}function OpenCageGeocoderService(e,t,i){(e=Resource.createIfNeeded(e)).appendForwardSlash(),e.setQueryParameters({key:t}),this._url=e,this._params=defaultValue(i,{})}Occluder._horizonToPlaneNormalDotProduct=function(e,t,i,r,n){var a=Cartesian3.clone(n,posScratch1),o=Cartesian3.clone(e.center,occluerPosScratch),s=e.radius,l=Cartesian3.subtract(o,a,posScratch2),c=Cartesian3.magnitudeSquared(l),u=s*s;if(c<u)return!1;var d=c-u,h=Math.sqrt(d),p=h*(1/Math.sqrt(c))*h;l=Cartesian3.normalize(l,l);var m=Cartesian3.add(a,Cartesian3.multiplyByScalar(l,p,horizonPlanePosScratch),horizonPlanePosScratch),f=Math.sqrt(d-p*p),g=this._rotationVector(o,t,i,a,r),_=Cartesian3.fromElements(g.x*g.x*l.x+(g.x*g.y-g.z)*l.y+(g.x*g.z+g.y)*l.z,(g.x*g.y+g.z)*l.x+g.y*g.y*l.y+(g.y*g.z-g.x)*l.z,(g.x*g.z-g.y)*l.x+(g.y*g.z+g.x)*l.y+g.z*g.z*l.z,posScratch1);_=Cartesian3.normalize(_,_);var y=Cartesian3.multiplyByScalar(_,f,posScratch1);g=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(m,y,posScratch2),o,posScratch2),posScratch2);var v=Cartesian3.dot(t,g);g=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.subtract(m,y,g),o,g),g);var C=Cartesian3.dot(t,g);return v<C?v:C},defineProperties$1(OffsetGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 3}},normalize:{get:function(){return!1}}}),OffsetGeometryInstanceAttribute.fromCartesian3=function(e){return new OffsetGeometryInstanceAttribute(e.x,e.y,e.z)},OffsetGeometryInstanceAttribute.toValue=function(e,t){return defined(t)||(t=new Float32Array([e.x,e.y,e.z])),t[0]=e.x,t[1]=e.y,t[2]=e.z,t},defineProperties$1(OpenCageGeocoderService.prototype,{url:{get:function(){return this._url}},params:{get:function(){return this._params}}}),OpenCageGeocoderService.prototype.geocode=function(e){return this._url.getDerivedResource({url:"json",queryParameters:combine(this._params,{q:e})}).fetchJson().then(function(e){return e.results.map(function(e){var t,i=e.bounds;if(defined(i))t=Rectangle.fromDegrees(i.southwest.lng,i.southwest.lat,i.northeast.lng,i.northeast.lat);else{var r=e.geometry.lat,n=e.geometry.lng;t=Cartesian3.fromDegrees(r,n)}return{displayName:e.formatted,destination:t}})})};var Packable={packedLength:void 0,pack:DeveloperError.throwInstantiationError,unpack:DeveloperError.throwInstantiationError},PackableForInterpolation={packedInterpolationLength:void 0,convertPackedArrayForInterpolation:DeveloperError.throwInstantiationError,unpackInterpolationResult:DeveloperError.throwInstantiationError},getCSSValue=function(e,t){return document.defaultView.getComputedStyle(e,null).getPropertyValue(t)},measureText=function(e,t,i,r){var n=e.measureText(t),a=getCSSValue(e.canvas,"font-family"),o=getCSSValue(e.canvas,"font-size").replace("px",""),s=getCSSValue(e.canvas,"font-style"),l=getCSSValue(e.canvas,"font-weight"),c=!/\S/.test(t);n.fontsize=o;var u=document.createElement("div");u.style.position="absolute",u.style.opacity=0,u.style.font=s+" "+l+" "+o+"px "+a,u.innerHTML=t+"<br/>"+t,document.body.appendChild(u),n.leading=1.2*o;var d=getCSSValue(u,"height");if(2*o<=(d=d.replace("px",""))&&(n.leading=d/2|0),document.body.removeChild(u),c)n.ascent=0,n.descent=0,n.bounds={minx:0,maxx:n.width,miny:0,maxy:0},n.height=0;else{var h=document.createElement("canvas");h.width=n.width+100,h.height=3*o,h.style.opacity=1,h.style.fontFamily=a,h.style.fontSize=o,h.style.fontStyle=s,h.style.fontWeight=l;var p=h.getContext("2d");p.font=s+" "+l+" "+o+"px "+a;var m=h.width,f=h.height,g=f/2;p.fillStyle="white",p.fillRect(-1,-1,m+2,f+2),i&&(p.strokeStyle="black",p.lineWidth=e.lineWidth,p.strokeText(t,50,g)),r&&(p.fillStyle="black",p.fillText(t,50,g));for(var _=p.getImageData(0,0,m,f).data,y=0,v=4*m,C=_.length;++y<C&&255===_[y];);var S=y/v|0;for(y=C-1;0<--y&&255===_[y];);var T=y/v|0;for(y=0;y<C&&255===_[y];)C<=(y+=v)&&(y=y-C+4);var x=y%v/4|0,b=1;for(y=C-3;0<=y&&255===_[y];)(y-=v)<0&&(y=C-3-4*b++);var E=y%v/4+1|0;n.ascent=g-S,n.descent=T-g,n.bounds={minx:x-50,maxx:E-50,miny:0,maxy:T-S},n.height=T-S+1}return n},imageSmoothingEnabledName;function writeTextToCanvas(e,t){if(""!==e){t=defaultValue(t,defaultValue.EMPTY_OBJECT);var i=defaultValue(t.font,"10px sans-serif"),r=defaultValue(t.stroke,!1),n=defaultValue(t.fill,!0),a=defaultValue(t.strokeWidth,1),o=defaultValue(t.backgroundColor,Color.TRANSPARENT),s=defaultValue(t.padding,0),l=2*s,c=document.createElement("canvas");c.width=1,c.height=1,c.style.font=i;var u=c.getContext("2d");defined(imageSmoothingEnabledName)||(defined(u.imageSmoothingEnabled)?imageSmoothingEnabledName="imageSmoothingEnabled":defined(u.mozImageSmoothingEnabled)?imageSmoothingEnabledName="mozImageSmoothingEnabled":defined(u.webkitImageSmoothingEnabled)?imageSmoothingEnabledName="webkitImageSmoothingEnabled":defined(u.msImageSmoothingEnabled)&&(imageSmoothingEnabledName="msImageSmoothingEnabled")),u.font=i,u.lineJoin="round",u.lineWidth=a,u[imageSmoothingEnabledName]=!1,u.textBaseline=defaultValue(t.textBaseline,"bottom"),c.style.visibility="hidden",document.body.appendChild(c);var d=measureText(u,e,r,n);c.dimensions=d,document.body.removeChild(c),c.style.visibility="";var h=-d.bounds.minx,p=Math.ceil(d.width)+h+l,m=d.height+l,f=m-(m-d.ascent+s)+l;if(c.width=p,c.height=m,u.font=i,u.lineJoin="round",u.lineWidth=a,u[imageSmoothingEnabledName]=!1,o!==Color.TRANSPARENT&&(u.fillStyle=o.toCssColorString(),u.fillRect(0,0,c.width,c.height)),r){var g=defaultValue(t.strokeColor,Color.BLACK);u.strokeStyle=g.toCssColorString(),u.strokeText(e,h+s,f)}if(n){var _=defaultValue(t.fillColor,Color.WHITE);u.fillStyle=_.toCssColorString(),u.fillText(e,h+s,f)}return c}}function PinBuilder(){this._cache={}}PinBuilder.prototype.fromColor=function(e,t){return createPin(void 0,void 0,e,t,this._cache)},PinBuilder.prototype.fromUrl=function(e,t,i){return createPin(e,void 0,t,i,this._cache)},PinBuilder.prototype.fromMakiIconId=function(e,t,i){return createPin(buildModuleUrl("Assets/Textures/maki/"+encodeURIComponent(e)+".png"),void 0,t,i,this._cache)},PinBuilder.prototype.fromText=function(e,t,i){return createPin(void 0,e,t,i,this._cache)};var colorScratch=new Color;function drawPin(e,t,i){e.save(),e.scale(i/24,i/24),e.fillStyle=t.toCssColorString(),e.strokeStyle=t.brighten(.6,colorScratch).toCssColorString(),e.lineWidth=.846,e.beginPath(),e.moveTo(6.72,.422),e.lineTo(17.28,.422),e.bezierCurveTo(18.553,.422,19.577,1.758,19.577,3.415),e.lineTo(19.577,10.973),e.bezierCurveTo(19.577,12.63,18.553,13.966,17.282,13.966),e.lineTo(14.386,14.008),e.lineTo(11.826,23.578),e.lineTo(9.614,14.008),e.lineTo(6.719,13.965),e.bezierCurveTo(5.446,13.983,4.422,12.629,4.422,10.972),e.lineTo(4.422,3.416),e.bezierCurveTo(4.423,1.76,5.447,.423,6.718,.423),e.closePath(),e.fill(),e.stroke(),e.restore()}function drawIcon(e,t,i){var r=i/2.5,n=r,a=r;t.width>t.height?a=r*(t.height/t.width):t.width<t.height&&(n=r*(t.width/t.height));var o=Math.round((i-n)/2),s=Math.round(7/24*i-a/2);e.globalCompositeOperation="destination-out",e.drawImage(t,o-1,s,n,a),e.drawImage(t,o,s-1,n,a),e.drawImage(t,o+1,s,n,a),e.drawImage(t,o,s+1,n,a),e.globalCompositeOperation="destination-over",e.fillStyle=Color.BLACK.toCssColorString(),e.fillRect(o-1,s-1,n+2,a+2),e.globalCompositeOperation="destination-out",e.drawImage(t,o,s,n,a),e.globalCompositeOperation="destination-over",e.fillStyle=Color.WHITE.toCssColorString(),e.fillRect(o-1,s-2,n+2,a+2)}var stringifyScratch=new Array(4);function createPin(e,t,i,r,n){stringifyScratch[0]=e,stringifyScratch[1]=t,stringifyScratch[2]=i,stringifyScratch[3]=r;var a=JSON.stringify(stringifyScratch),o=n[a];if(defined(o))return o;var s=document.createElement("canvas");s.width=r,s.height=r;var l=s.getContext("2d");if(drawPin(l,i,r),defined(e)){var c=Resource.createIfNeeded(e).fetchImage().then(function(e){return drawIcon(l,e,r),n[a]=s});return n[a]=c}if(defined(t)){var u=writeTextToCanvas(t,{font:"bold "+r+"px sans-serif"});drawIcon(l,u,r)}return n[a]=s}var PixelDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES,UNSIGNED_INT_24_8:WebGLConstants$1.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:WebGLConstants$1.UNSIGNED_SHORT_5_6_5,isPacked:function(e){return e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5},sizeInBytes:function(e){switch(e){case PixelDatatype.UNSIGNED_BYTE:return 1;case PixelDatatype.UNSIGNED_SHORT:case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:case PixelDatatype.UNSIGNED_SHORT_5_6_5:case PixelDatatype.HALF_FLOAT:return 2;case PixelDatatype.UNSIGNED_INT:case PixelDatatype.FLOAT:case PixelDatatype.UNSIGNED_INT_24_8:return 4}},validate:function(e){return e===PixelDatatype.UNSIGNED_BYTE||e===PixelDatatype.UNSIGNED_SHORT||e===PixelDatatype.UNSIGNED_INT||e===PixelDatatype.FLOAT||e===PixelDatatype.HALF_FLOAT||e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5}},PixelDatatype$1=freezeObject$1(PixelDatatype),PixelFormat={DEPTH_COMPONENT:WebGLConstants$1.DEPTH_COMPONENT,DEPTH_STENCIL:WebGLConstants$1.DEPTH_STENCIL,ALPHA:WebGLConstants$1.ALPHA,RGB:WebGLConstants$1.RGB,RGBA:WebGLConstants$1.RGBA,LUMINANCE:WebGLConstants$1.LUMINANCE,LUMINANCE_ALPHA:WebGLConstants$1.LUMINANCE_ALPHA,RGB_DXT1:WebGLConstants$1.COMPRESSED_RGB_S3TC_DXT1_EXT,RGBA_DXT1:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT1_EXT,RGBA_DXT3:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT3_EXT,RGBA_DXT5:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT5_EXT,RGB_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,RGB_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,RGBA_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,RGBA_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,RGB_ETC1:WebGLConstants$1.COMPRESSED_RGB_ETC1_WEBGL,componentsLength:function(e){switch(e){case PixelFormat.RGB:return 3;case PixelFormat.RGBA:return 4;case PixelFormat.LUMINANCE_ALPHA:return 2;case PixelFormat.ALPHA:case PixelFormat.LUMINANCE:default:return 1}},validate:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL||e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA||e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGB_ETC1},isColorFormat:function(e){return e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL},isCompressedFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGB_ETC1},isDXTFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5},isPVRTCFormat:function(e){return e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1},isETC1Format:function(e){return e===PixelFormat.RGB_ETC1},compressedTextureSizeInBytes:function(e,t,i){switch(e){case PixelFormat.RGB_DXT1:case PixelFormat.RGBA_DXT1:case PixelFormat.RGB_ETC1:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*8;case PixelFormat.RGBA_DXT3:case PixelFormat.RGBA_DXT5:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*16;case PixelFormat.RGB_PVRTC_4BPPV1:case PixelFormat.RGBA_PVRTC_4BPPV1:return Math.floor((Math.max(t,8)*Math.max(i,8)*4+7)/8);case PixelFormat.RGB_PVRTC_2BPPV1:case PixelFormat.RGBA_PVRTC_2BPPV1:return Math.floor((Math.max(t,16)*Math.max(i,8)*2+7)/8);default:return 0}},textureSizeInBytes:function(e,t,i,r){var n=PixelFormat.componentsLength(e);return PixelDatatype$1.isPacked(t)&&(n=1),n*PixelDatatype$1.sizeInBytes(t)*i*r},alignmentInBytes:function(e,t,i){var r=PixelFormat.textureSizeInBytes(e,t,i,1)%4;return 0==r?4:2==r?2:1},createTypedArray:function(e,t,i,r){var n=PixelDatatype$1.sizeInBytes(t);return new(n===Uint8Array.BYTES_PER_ELEMENT?Uint8Array:n===Uint16Array.BYTES_PER_ELEMENT?Uint16Array:n===Float32Array.BYTES_PER_ELEMENT&&t===PixelDatatype$1.FLOAT?Float32Array:Uint32Array)(PixelFormat.componentsLength(e)*i*r)},flipY:function(e,t,i,r,n){if(1===n)return e;for(var a=PixelFormat.createTypedArray(t,i,r,n),o=PixelFormat.componentsLength(t),s=r*o,l=0;l<n;++l)for(var c=l*n*o,u=(n-l-1)*n*o,d=0;d<s;++d)a[u+d]=e[c+d];return a}},PixelFormat$1=freezeObject$1(PixelFormat);function PlaneGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=t,this._workerName="createPlaneGeometry"}PlaneGeometry.packedLength=VertexFormat.packedLength,PlaneGeometry.pack=function(e,t,i){return i=defaultValue(i,0),VertexFormat.pack(e._vertexFormat,t,i),t};var scratchVertexFormat$7=new VertexFormat,scratchOptions$e={vertexFormat:scratchVertexFormat$7};PlaneGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=VertexFormat.unpack(e,t,scratchVertexFormat$7);return defined(i)?(i._vertexFormat=VertexFormat.clone(r,i._vertexFormat),i):new PlaneGeometry(scratchOptions$e)};var min=new Cartesian3(-.5,-.5,0),max=new Cartesian3(.5,.5,0);function PlaneOutlineGeometry(){this._workerName="createPlaneOutlineGeometry"}PlaneGeometry.createGeometry=function(e){var t,i,r=e._vertexFormat,n=new GeometryAttributes;if(r.position){if((i=new Float64Array(12))[0]=min.x,i[1]=min.y,i[2]=0,i[3]=max.x,i[4]=min.y,i[5]=0,i[6]=max.x,i[7]=max.y,i[8]=0,i[9]=min.x,i[10]=max.y,i[11]=0,n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i}),r.normal){var a=new Float32Array(12);a[0]=0,a[1]=0,a[2]=1,a[3]=0,a[4]=0,a[5]=1,a[6]=0,a[7]=0,a[8]=1,a[9]=0,a[10]=0,a[11]=1,n.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:a})}if(r.st){var o=new Float32Array(8);o[0]=0,o[1]=0,o[2]=1,o[3]=0,o[4]=1,o[5]=1,o[6]=0,o[7]=1,n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:o})}if(r.tangent){var s=new Float32Array(12);s[0]=1,s[1]=0,s[2]=0,s[3]=1,s[4]=0,s[5]=0,s[6]=1,s[7]=0,s[8]=0,s[9]=1,s[10]=0,s[11]=0,n.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:s})}if(r.bitangent){var l=new Float32Array(12);l[0]=0,l[1]=1,l[2]=0,l[3]=0,l[4]=1,l[5]=0,l[6]=0,l[7]=1,l[8]=0,l[9]=0,l[10]=1,l[11]=0,n.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:l})}(t=new Uint16Array(6))[0]=0,t[1]=1,t[2]=2,t[3]=0,t[4]=2,t[5]=3}return new Geometry({attributes:n,indices:t,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})},PlaneOutlineGeometry.packedLength=0,PlaneOutlineGeometry.pack=function(e,t){return t},PlaneOutlineGeometry.unpack=function(e,t,i){return defined(i)?i:new PlaneOutlineGeometry};var min$1=new Cartesian3(-.5,-.5,0),max$1=new Cartesian3(.5,.5,0);PlaneOutlineGeometry.createGeometry=function(){var e=new GeometryAttributes,t=new Uint16Array(8),i=new Float64Array(12);return i[0]=min$1.x,i[1]=min$1.y,i[2]=min$1.z,i[3]=max$1.x,i[4]=min$1.y,i[5]=min$1.z,i[6]=max$1.x,i[7]=max$1.y,i[8]=min$1.z,i[9]=min$1.x,i[10]=max$1.y,i[11]=min$1.z,e.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i}),t[0]=0,t[1]=1,t[2]=1,t[3]=2,t[4]=2,t[5]=3,t[6]=3,t[7]=0,new Geometry({attributes:e,indices:t,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})};var scratchCarto1=new Cartographic,scratchCarto2=new Cartographic;function adjustPosHeightsForNormal(e,t,i,r){var n=r.cartesianToCartographic(e,scratchCarto1).height,a=r.cartesianToCartographic(t,scratchCarto2);a.height=n,r.cartographicToCartesian(a,t);var o=r.cartesianToCartographic(i,scratchCarto2);o.height=n-100,r.cartographicToCartesian(o,i)}var scratchBoundingRectangle=new BoundingRectangle,scratchPosition$3=new Cartesian3,scratchNormal$5=new Cartesian3,scratchTangent$3=new Cartesian3,scratchBitangent$3=new Cartesian3,p1Scratch$2=new Cartesian3,p2Scratch$2=new Cartesian3,scratchPerPosNormal=new Cartesian3,scratchPerPosTangent=new Cartesian3,scratchPerPosBitangent=new Cartesian3,appendTextureCoordinatesOrigin=new Cartesian2,appendTextureCoordinatesCartesian2=new Cartesian2,appendTextureCoordinatesCartesian3=new Cartesian3,appendTextureCoordinatesQuaternion=new Quaternion,appendTextureCoordinatesMatrix3=new Matrix3,tangentMatrixScratch$1=new Matrix3;function computeAttributes(e){var t=e.vertexFormat,i=e.geometry,r=e.shadowVolume,n=i.attributes.position.values,a=n.length,o=e.wall,s=e.top||o,l=e.bottom||o;if(t.st||t.normal||t.tangent||t.bitangent||r){var c=e.boundingRectangle,u=e.tangentPlane,d=e.ellipsoid,h=e.stRotation,p=e.perPositionHeight,m=appendTextureCoordinatesOrigin;m.x=c.x,m.y=c.y;var f,g=t.st?new Float32Array(a/3*2):void 0;t.normal&&(f=p&&s&&!o?i.attributes.normal.values:new Float32Array(a));var _=t.tangent?new Float32Array(a):void 0,y=t.bitangent?new Float32Array(a):void 0,v=r?new Float32Array(a):void 0,C=0,S=0,T=scratchNormal$5,x=scratchTangent$3,b=scratchBitangent$3,E=!0,P=appendTextureCoordinatesMatrix3,A=tangentMatrixScratch$1;if(0!==h){var w=Quaternion.fromAxisAngle(u._plane.normal,h,appendTextureCoordinatesQuaternion);P=Matrix3.fromQuaternion(w,P),w=Quaternion.fromAxisAngle(u._plane.normal,-h,appendTextureCoordinatesQuaternion),A=Matrix3.fromQuaternion(w,A)}else P=Matrix3.clone(Matrix3.IDENTITY,P),A=Matrix3.clone(Matrix3.IDENTITY,A);var D=0,M=0;s&&l&&(D=a/2,M=a/3,a/=2);for(var I=0;I<a;I+=3){var R=Cartesian3.fromArray(n,I,appendTextureCoordinatesCartesian3);if(t.st){var O=Matrix3.multiplyByVector(P,R,scratchPosition$3);O=d.scaleToGeodeticSurface(O,O);var L=u.projectPointOntoPlane(O,appendTextureCoordinatesCartesian2);Cartesian2.subtract(L,m,L);var F=CesiumMath.clamp(L.x/c.width,0,1),N=CesiumMath.clamp(L.y/c.height,0,1);l&&(g[C+M]=F,g[C+1+M]=N),s&&(g[C]=F,g[C+1]=N),C+=2}if(t.normal||t.tangent||t.bitangent||r){var V=S+1,B=S+2;if(o){if(I+3<a){var k=Cartesian3.fromArray(n,I+3,p1Scratch$2);if(E){var $=Cartesian3.fromArray(n,I+a,p2Scratch$2);p&&adjustPosHeightsForNormal(R,k,$,d),Cartesian3.subtract(k,R,k),Cartesian3.subtract($,R,$),T=Cartesian3.normalize(Cartesian3.cross($,k,T),T),E=!1}Cartesian3.equalsEpsilon(k,R,CesiumMath.EPSILON10)&&(E=!0)}(t.tangent||t.bitangent)&&(b=d.geodeticSurfaceNormal(R,b),t.tangent&&(x=Cartesian3.normalize(Cartesian3.cross(b,T,x),x)))}else T=d.geodeticSurfaceNormal(R,T),(t.tangent||t.bitangent)&&(p&&(scratchPerPosNormal=Cartesian3.fromArray(f,S,scratchPerPosNormal),scratchPerPosTangent=Cartesian3.cross(Cartesian3.UNIT_Z,scratchPerPosNormal,scratchPerPosTangent),scratchPerPosTangent=Cartesian3.normalize(Matrix3.multiplyByVector(A,scratchPerPosTangent,scratchPerPosTangent),scratchPerPosTangent),t.bitangent&&(scratchPerPosBitangent=Cartesian3.normalize(Cartesian3.cross(scratchPerPosNormal,scratchPerPosTangent,scratchPerPosBitangent),scratchPerPosBitangent))),x=Cartesian3.cross(Cartesian3.UNIT_Z,T,x),x=Cartesian3.normalize(Matrix3.multiplyByVector(A,x,x),x),t.bitangent&&(b=Cartesian3.normalize(Cartesian3.cross(T,x,b),b)));t.normal&&(e.wall?(f[S+D]=T.x,f[V+D]=T.y,f[B+D]=T.z):l&&(f[S+D]=-T.x,f[V+D]=-T.y,f[B+D]=-T.z),(s&&!p||o)&&(f[S]=T.x,f[V]=T.y,f[B]=T.z)),r&&(o&&(T=d.geodeticSurfaceNormal(R,T)),v[S+D]=-T.x,v[V+D]=-T.y,v[B+D]=-T.z),t.tangent&&(e.wall?(_[S+D]=x.x,_[V+D]=x.y,_[B+D]=x.z):l&&(_[S+D]=-x.x,_[V+D]=-x.y,_[B+D]=-x.z),s&&(p?(_[S]=scratchPerPosTangent.x,_[V]=scratchPerPosTangent.y,_[B]=scratchPerPosTangent.z):(_[S]=x.x,_[V]=x.y,_[B]=x.z))),t.bitangent&&(l&&(y[S+D]=b.x,y[V+D]=b.y,y[B+D]=b.z),s&&(p?(y[S]=scratchPerPosBitangent.x,y[V]=scratchPerPosBitangent.y,y[B]=scratchPerPosBitangent.z):(y[S]=b.x,y[V]=b.y,y[B]=b.z))),S+=3}}t.st&&(i.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:g})),t.normal&&(i.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),t.tangent&&(i.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),t.bitangent&&(i.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})),r&&(i.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:v}))}if(e.extrude&&defined(e.offsetAttribute)){var z=n.length/3,U=new Uint8Array(z);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)s&&l||o?U=arrayFill(U,1,0,z/2):s&&(U=arrayFill(U,1));else U=arrayFill(U,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);i.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:U})}return i}var startCartographicScratch$1=new Cartographic,endCartographicScratch$1=new Cartographic,idlCross={westOverIDL:0,eastOverIDL:0},ellipsoidGeodesic$1=new EllipsoidGeodesic;function computeRectangle$2(e,t,i,r,n){if(n=defaultValue(n,new Rectangle),!defined(e)||e.length<3)return n.west=0,n.north=0,n.south=0,n.east=0,n;if(i===ArcType$1.RHUMB)return Rectangle.fromCartesianArray(e,t,n);ellipsoidGeodesic$1.ellipsoid.equals(t)||(ellipsoidGeodesic$1=new EllipsoidGeodesic(void 0,void 0,t)),n.west=Number.POSITIVE_INFINITY,n.east=Number.NEGATIVE_INFINITY,n.south=Number.POSITIVE_INFINITY,n.north=Number.NEGATIVE_INFINITY,idlCross.westOverIDL=Number.POSITIVE_INFINITY,idlCross.eastOverIDL=Number.NEGATIVE_INFINITY;for(var a,o=1/CesiumMath.chordLength(r,t.maximumRadius),s=e.length,l=t.cartesianToCartographic(e[0],endCartographicScratch$1),c=startCartographicScratch$1,u=1;u<s;u++)a=c,c=l,l=t.cartesianToCartographic(e[u],a),ellipsoidGeodesic$1.setEndPoints(c,l),interpolateAndGrowRectangle(ellipsoidGeodesic$1,o,n,idlCross);return a=c,c=l,l=t.cartesianToCartographic(e[0],a),ellipsoidGeodesic$1.setEndPoints(c,l),interpolateAndGrowRectangle(ellipsoidGeodesic$1,o,n,idlCross),n.east-n.west>idlCross.eastOverIDL-idlCross.westOverIDL&&(n.west=idlCross.westOverIDL,n.east=idlCross.eastOverIDL,n.east>CesiumMath.PI&&(n.east=n.east-CesiumMath.TWO_PI),n.west>CesiumMath.PI&&(n.west=n.west-CesiumMath.TWO_PI)),n}var interpolatedCartographicScratch$1=new Cartographic;function interpolateAndGrowRectangle(e,t,i,r){for(var n=e.surfaceDistance,a=Math.ceil(n*t),o=0<a?n/(a-1):Number.POSITIVE_INFINITY,s=0,l=0;l<a;l++){var c=e.interpolateUsingSurfaceDistance(s,interpolatedCartographicScratch$1);s+=o;var u=c.longitude,d=c.latitude;i.west=Math.min(i.west,u),i.east=Math.max(i.east,u),i.south=Math.min(i.south,d),i.north=Math.max(i.north,d);var h=0<=u?u:u+CesiumMath.TWO_PI;r.westOverIDL=Math.min(r.westOverIDL,h),r.eastOverIDL=Math.max(r.eastOverIDL,h)}}var createGeometryFromPositionsExtrudedPositions=[];function createGeometryFromPositionsExtruded(e,t,i,r,n,a,o,s,l){var c,u={walls:[]};if(a||o){var d,h,p=PolygonGeometryLibrary.createGeometryFromPositions(e,t,i,n,s,l),m=p.attributes.position.values,f=p.indices;if(a&&o){var g=m.concat(m);d=g.length/3,(h=IndexDatatype$1.createTypedArray(d,2*f.length)).set(f);var _=f.length,y=d/2;for(c=0;c<_;c+=3){var v=h[c]+y,C=h[c+1]+y,S=h[c+2]+y;h[c+_]=S,h[c+1+_]=C,h[c+2+_]=v}if(p.attributes.position.values=g,n&&s.normal){var T=p.attributes.normal.values;p.attributes.normal.values=new Float32Array(g.length),p.attributes.normal.values.set(T)}p.indices=h}else if(o){for(d=m.length/3,h=IndexDatatype$1.createTypedArray(d,f.length),c=0;c<f.length;c+=3)h[c]=f[c+2],h[c+1]=f[c+1],h[c+2]=f[c];p.indices=h}u.topAndBottom=new GeometryInstance({geometry:p})}var x=r.outerRing,b=EllipsoidTangentPlane.fromPoints(x,e),E=b.projectPointsOntoPlane(x,createGeometryFromPositionsExtrudedPositions),P=PolygonPipeline.computeWindingOrder2D(E);P===WindingOrder$1.CLOCKWISE&&(x=x.slice().reverse());var A=PolygonGeometryLibrary.computeWallGeometry(x,e,i,n,l);u.walls.push(new GeometryInstance({geometry:A}));var w=r.holes;for(c=0;c<w.length;c++){var D=w[c];E=(b=EllipsoidTangentPlane.fromPoints(D,e)).projectPointsOntoPlane(D,createGeometryFromPositionsExtrudedPositions),(P=PolygonPipeline.computeWindingOrder2D(E))===WindingOrder$1.COUNTER_CLOCKWISE&&(D=D.slice().reverse()),A=PolygonGeometryLibrary.computeWallGeometry(D,e,i,n,l),u.walls.push(new GeometryInstance({geometry:A}))}return u}function PolygonGeometry(e){var t=e.polygonHierarchy,i=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.stRotation,0),o=defaultValue(e.perPositionHeight,!1),s=o&&defined(e.extrudedHeight),l=defaultValue(e.height,0),c=defaultValue(e.extrudedHeight,l);if(!s){var u=Math.max(l,c);c=Math.min(l,c),l=u}this._vertexFormat=VertexFormat.clone(i),this._ellipsoid=Ellipsoid.clone(r),this._granularity=n,this._stRotation=a,this._height=l,this._extrudedHeight=c,this._closeTop=defaultValue(e.closeTop,!0),this._closeBottom=defaultValue(e.closeBottom,!0),this._polygonHierarchy=t,this._perPositionHeight=o,this._perPositionHeightExtrude=s,this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createPolygonGeometry",this._offsetAttribute=e.offsetAttribute,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0,this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+Ellipsoid.packedLength+VertexFormat.packedLength+12}PolygonGeometry.fromPositions=function(e){return new PolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,closeTop:e.closeTop,closeBottom:e.closeBottom,offsetAttribute:e.offsetAttribute,arcType:e.arcType})},PolygonGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._stRotation,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._closeTop?1:0,t[i++]=e._closeBottom?1:0,t[i++]=e._shadowVolume?1:0,t[i++]=defaultValue(e._offsetAttribute,-1),t[i++]=e._arcType,t[i]=e.packedLength,t};var scratchEllipsoid$5=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$8=new VertexFormat,dummyOptions={polygonHierarchy:{}};function textureCoordinateRotationPoints$1(e){var t=-e._stRotation;if(0==t)return[0,0,0,1,1,0];var i=e._ellipsoid,r=e._polygonHierarchy.positions,n=e.rectangle;return Geometry._textureCoordinateRotationPoints(r,t,i,n)}function PolygonHierarchy(e,t){this.positions=defined(e)?e:[],this.holes=defined(t)?t:[]}PolygonGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$5);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$8);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=1===e[t++],d=1===e[t++],h=1===e[t++],p=1===e[t++],m=1===e[t++],f=e[t++],g=e[t++],_=e[t];return defined(i)||(i=new PolygonGeometry(dummyOptions)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._height=o,i._extrudedHeight=s,i._granularity=l,i._stRotation=c,i._perPositionHeightExtrude=u,i._perPositionHeight=d,i._closeTop=h,i._closeBottom=p,i._shadowVolume=m,i._offsetAttribute=-1===f?void 0:f,i._arcType=g,i.packedLength=_,i},PolygonGeometry.computeRectangle=function(e,t){var i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.arcType,ArcType$1.GEODESIC),n=e.polygonHierarchy,a=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle$2(n.positions,a,r,i,t)},PolygonGeometry.createGeometry=function(e){var t=e._vertexFormat,i=e._ellipsoid,r=e._granularity,n=e._stRotation,a=e._polygonHierarchy,o=e._perPositionHeight,s=e._closeTop,l=e._closeBottom,c=e._arcType,u=a.positions;if(!(u.length<3)){var d=EllipsoidTangentPlane.fromPoints(u,i),h=PolygonGeometryLibrary.polygonsFromHierarchy(a,d.projectPointsOntoPlane.bind(d),!o,i),p=h.hierarchy,m=h.polygons;if(0!==p.length){u=p[0].outerRing;var f,g=PolygonGeometryLibrary.computeBoundingRectangle(d.plane.normal,d.projectPointOntoPlane.bind(d),u,n,scratchBoundingRectangle),_=[],y=e._height,v=e._extrudedHeight,C={perPositionHeight:o,vertexFormat:t,geometry:void 0,tangentPlane:d,boundingRectangle:g,ellipsoid:i,stRotation:n,bottom:!1,top:!0,wall:!1,extrude:!1,arcType:c};if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(y,v,0,CesiumMath.EPSILON2))for(C.extrude=!0,C.top=s,C.bottom=l,C.shadowVolume=e._shadowVolume,C.offsetAttribute=e._offsetAttribute,f=0;f<m.length;f++){var S,T=createGeometryFromPositionsExtruded(i,m[f],r,p[f],o,s,l,t,c);s&&l?(S=T.topAndBottom,C.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(S.geometry,y,v,i,o)):s?((S=T.topAndBottom).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(S.geometry.attributes.position.values,y,i,!o),C.geometry=S.geometry):l&&((S=T.topAndBottom).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(S.geometry.attributes.position.values,v,i,!0),C.geometry=S.geometry),(s||l)&&(C.wall=!1,S.geometry=computeAttributes(C),_.push(S));var x=T.walls;C.wall=!0;for(var b=0;b<x.length;b++){var E=x[b];C.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(E.geometry,y,v,i,o),E.geometry=computeAttributes(C),_.push(E)}}else for(f=0;f<m.length;f++){var P=new GeometryInstance({geometry:PolygonGeometryLibrary.createGeometryFromPositions(i,m[f],r,o,t,c)});if(P.geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(P.geometry.attributes.position.values,y,i,!o),C.geometry=P.geometry,P.geometry=computeAttributes(C),defined(e._offsetAttribute)){var A=P.geometry.attributes.position.values.length,w=new Uint8Array(A/3);arrayFill(w,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),P.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:w})}_.push(P)}var D=GeometryPipeline.combineInstances(_)[0];D.attributes.position.values=new Float64Array(D.attributes.position.values),D.indices=IndexDatatype$1.createTypedArray(D.attributes.position.values.length/3,D.indices);var M=D.attributes,I=BoundingSphere.fromVertices(M.position.values);return t.position||delete M.position,new Geometry({attributes:M,indices:D.indices,primitiveType:D.primitiveType,boundingSphere:I,offsetAttribute:e._offsetAttribute})}}},PolygonGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,a=t(r,n),o=i(r,n);return new PolygonGeometry({polygonHierarchy:e._polygonHierarchy,ellipsoid:n,stRotation:e._stRotation,granularity:r,perPositionHeight:!1,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0,arcType:e._arcType})},defineProperties$1(PolygonGeometry.prototype,{rectangle:{get:function(){if(!defined(this._rectangle)){var e=this._polygonHierarchy.positions;this._rectangle=computeRectangle$2(e,this._ellipsoid,this._arcType,this._granularity)}return this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$1(this)),this._textureCoordinateRotationPoints}}});var createGeometryFromPositionsPositions=[],createGeometryFromPositionsSubdivided=[];function createGeometryFromPositions$1(e,t,i,r,n){var a,o,s=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);PolygonPipeline.computeWindingOrder2D(s)===WindingOrder$1.CLOCKWISE&&(s.reverse(),t=t.slice().reverse());var l=t.length,c=0;if(r)for(a=new Float64Array(2*l*3),o=0;o<l;o++){var u=t[o],d=t[(o+1)%l];a[c++]=u.x,a[c++]=u.y,a[c++]=u.z,a[c++]=d.x,a[c++]=d.y,a[c++]=d.z}else{var h=0;if(n===ArcType$1.GEODESIC)for(o=0;o<l;o++)h+=PolygonGeometryLibrary.subdivideLineCount(t[o],t[(o+1)%l],i);else if(n===ArcType$1.RHUMB)for(o=0;o<l;o++)h+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[o],t[(o+1)%l],i);for(a=new Float64Array(3*h),o=0;o<l;o++){var p;n===ArcType$1.GEODESIC?p=PolygonGeometryLibrary.subdivideLine(t[o],t[(o+1)%l],i,createGeometryFromPositionsSubdivided):n===ArcType$1.RHUMB&&(p=PolygonGeometryLibrary.subdivideRhumbLine(e,t[o],t[(o+1)%l],i,createGeometryFromPositionsSubdivided));for(var m=p.length,f=0;f<m;++f)a[c++]=p[f]}}var g=2*(l=a.length/3),_=IndexDatatype$1.createTypedArray(l,g);for(o=c=0;o<l-1;o++)_[c++]=o,_[c++]=o+1;return _[c++]=l-1,_[c++]=0,new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:_,primitiveType:PrimitiveType$1.LINES})})}function createGeometryFromPositionsExtruded$1(e,t,i,r,n){var a,o,s=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);PolygonPipeline.computeWindingOrder2D(s)===WindingOrder$1.CLOCKWISE&&(s.reverse(),t=t.slice().reverse());var l=t.length,c=new Array(l),u=0;if(r)for(a=new Float64Array(2*l*3*2),o=0;o<l;++o){c[o]=u/3;var d=t[o],h=t[(o+1)%l];a[u++]=d.x,a[u++]=d.y,a[u++]=d.z,a[u++]=h.x,a[u++]=h.y,a[u++]=h.z}else{var p=0;if(n===ArcType$1.GEODESIC)for(o=0;o<l;o++)p+=PolygonGeometryLibrary.subdivideLineCount(t[o],t[(o+1)%l],i);else if(n===ArcType$1.RHUMB)for(o=0;o<l;o++)p+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[o],t[(o+1)%l],i);for(a=new Float64Array(3*p*2),o=0;o<l;++o){var m;c[o]=u/3,n===ArcType$1.GEODESIC?m=PolygonGeometryLibrary.subdivideLine(t[o],t[(o+1)%l],i,createGeometryFromPositionsSubdivided):n===ArcType$1.RHUMB&&(m=PolygonGeometryLibrary.subdivideRhumbLine(e,t[o],t[(o+1)%l],i,createGeometryFromPositionsSubdivided));for(var f=m.length,g=0;g<f;++g)a[u++]=m[g]}}l=a.length/6;var _=c.length,y=2*(2*l+_),v=IndexDatatype$1.createTypedArray(l+_,y);for(o=u=0;o<l;++o)v[u++]=o,v[u++]=(o+1)%l,v[u++]=o+l,v[u++]=(o+1)%l+l;for(o=0;o<_;o++){var C=c[o];v[u++]=C,v[u++]=C+l}return new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:v,primitiveType:PrimitiveType$1.LINES})})}function PolygonOutlineGeometry(e){var t=e.polygonHierarchy,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),n=defaultValue(e.perPositionHeight,!1),a=n&&defined(e.extrudedHeight),o=defaultValue(e.arcType,ArcType$1.GEODESIC),s=defaultValue(e.height,0),l=defaultValue(e.extrudedHeight,s);if(!a){var c=Math.max(s,l);l=Math.min(s,l),s=c}this._ellipsoid=Ellipsoid.clone(i),this._granularity=r,this._height=s,this._extrudedHeight=l,this._arcType=o,this._polygonHierarchy=t,this._perPositionHeight=n,this._perPositionHeightExtrude=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+Ellipsoid.packedLength+8}PolygonOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._arcType,t[i++]=defaultValue(e._offsetAttribute,-1),t[i]=e.packedLength,t};var scratchEllipsoid$6=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),dummyOptions$1={polygonHierarchy:{}};PolygonOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$6);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=1===e[t++],c=1===e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)||(i=new PolygonOutlineGeometry(dummyOptions$1)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._height=a,i._extrudedHeight=o,i._granularity=s,i._perPositionHeight=c,i._perPositionHeightExtrude=l,i._arcType=u,i._offsetAttribute=-1===d?void 0:d,i.packedLength=h,i},PolygonOutlineGeometry.fromPositions=function(e){return new PolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,arcType:e.arcType,offsetAttribute:e.offsetAttribute})},PolygonOutlineGeometry.createGeometry=function(e){var t=e._ellipsoid,i=e._granularity,r=e._polygonHierarchy,n=e._perPositionHeight,a=e._arcType,o=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(r,!n,t);if(0!==o.length){var s,l,c=[],u=CesiumMath.chordLength(i,t.maximumRadius),d=e._height,h=e._extrudedHeight;if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(d,h,0,CesiumMath.EPSILON2))for(l=0;l<o.length;l++){if((s=createGeometryFromPositionsExtruded$1(t,o[l],u,n,a)).geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(s.geometry,d,h,t,n),defined(e._offsetAttribute)){var p=s.geometry.attributes.position.values.length/3,m=new Uint8Array(p);m=e._offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(m,1,0,p/2):arrayFill(m,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),s.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:m})}c.push(s)}else for(l=0;l<o.length;l++){if((s=createGeometryFromPositions$1(t,o[l],u,n,a)).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(s.geometry.attributes.position.values,d,t,!n),defined(e._offsetAttribute)){var f=s.geometry.attributes.position.values.length,g=new Uint8Array(f/3);arrayFill(g,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),s.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:g})}c.push(s)}var _=GeometryPipeline.combineInstances(c)[0],y=BoundingSphere.fromVertices(_.attributes.position.values);return new Geometry({attributes:_.attributes,indices:_.indices,primitiveType:_.primitiveType,boundingSphere:y,offsetAttribute:e._offsetAttribute})}};var scratchInterpolateColorsArray=[];function interpolateColors(e,t,i,r,n){var a,o=scratchInterpolateColorsArray;o.length=n;var s=i.red,l=i.green,c=i.blue,u=i.alpha,d=r.red,h=r.green,p=r.blue,m=r.alpha;if(Color.equals(i,r)){for(a=0;a<n;a++)o[a]=Color.clone(i);return o}var f=(d-s)/n,g=(h-l)/n,_=(p-c)/n,y=(m-u)/n;for(a=0;a<n;a++)o[a]=new Color(s+a*f,l+a*g,c+a*_,u+a*y);return o}function PolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.colors,r=defaultValue(e.width,1),n=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=i,this._width=r,this._colorsPerVertex=n,this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createPolylineGeometry";var a=1+t.length*Cartesian3.packedLength;a+=defined(i)?1+i.length*Color.packedLength:1,this.packedLength=a+Ellipsoid.packedLength+VertexFormat.packedLength+4}PolylineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._colors;for(a=defined(o)?o.length:0,t[i++]=a,r=0;r<a;++r,i+=Color.packedLength)Color.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._width,t[i++]=e._colorsPerVertex?1:0,t[i++]=e._arcType,t[i]=e._granularity,t};var scratchEllipsoid$7=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$9=new VertexFormat,scratchOptions$f={positions:void 0,colors:void 0,ellipsoid:scratchEllipsoid$7,vertexFormat:scratchVertexFormat$9,width:void 0,colorsPerVertex:void 0,arcType:void 0,granularity:void 0};PolylineGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n=e[t++],a=new Array(n);for(r=0;r<n;++r,t+=Cartesian3.packedLength)a[r]=Cartesian3.unpack(e,t);var o=0<(n=e[t++])?new Array(n):void 0;for(r=0;r<n;++r,t+=Color.packedLength)o[r]=Color.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$7);t+=Ellipsoid.packedLength;var l=VertexFormat.unpack(e,t,scratchVertexFormat$9);t+=VertexFormat.packedLength;var c=e[t++],u=1===e[t++],d=e[t++],h=e[t];return defined(i)?(i._positions=a,i._colors=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._vertexFormat=VertexFormat.clone(l,i._vertexFormat),i._width=c,i._colorsPerVertex=u,i._arcType=d,i._granularity=h,i):(scratchOptions$f.positions=a,scratchOptions$f.colors=o,scratchOptions$f.width=c,scratchOptions$f.colorsPerVertex=u,scratchOptions$f.arcType=d,scratchOptions$f.granularity=h,new PolylineGeometry(scratchOptions$f))};var scratchCartesian3$8=new Cartesian3,scratchPosition$4=new Cartesian3,scratchPrevPosition=new Cartesian3,scratchNextPosition=new Cartesian3;function computeAttributes$1(e,t,i,r){var n=new GeometryAttributes;r.position&&(n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e}));var a,o,s,l,c,u,d=t.length,h=e.length/3,p=(h-2*d)/(2*d),m=PolygonPipeline.triangulate(t),f=(p-1)*d*6+2*m.length,g=IndexDatatype$1.createTypedArray(h,f),_=2*d,y=0;for(a=0;a<p-1;a++){for(o=0;o<d-1;o++)u=(s=2*o+a*d*2)+_,c=(l=s+1)+_,g[y++]=l,g[y++]=s,g[y++]=c,g[y++]=c,g[y++]=s,g[y++]=u;c=(l=(s=2*d-2+a*d*2)+1)+_,u=s+_,g[y++]=l,g[y++]=s,g[y++]=c,g[y++]=c,g[y++]=s,g[y++]=u}if(r.st||r.tangent||r.bitangent){var v,C,S=new Float32Array(2*h),T=1/(p-1),x=1/i.height,b=i.height/2,E=0;for(a=0;a<p;a++){for(v=a*T,C=x*(t[0].y+b),S[E++]=v,S[E++]=C,o=1;o<d;o++)C=x*(t[o].y+b),S[E++]=v,S[E++]=C,S[E++]=v,S[E++]=C;C=x*(t[0].y+b),S[E++]=v,S[E++]=C}for(o=0;o<d;o++)v=0,C=x*(t[o].y+b),S[E++]=v,S[E++]=C;for(o=0;o<d;o++)v=(p-1)*T,C=x*(t[o].y+b),S[E++]=v,S[E++]=C;n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:new Float32Array(S)})}var P=h-2*d;for(a=0;a<m.length;a+=3){var A=m[a]+P,w=m[a+1]+P,D=m[a+2]+P;g[y++]=A,g[y++]=w,g[y++]=D,g[y++]=D+d,g[y++]=w+d,g[y++]=A+d}var M=new Geometry({attributes:n,indices:g,boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.TRIANGLES});if(r.normal&&(M=GeometryPipeline.computeNormal(M)),r.tangent||r.bitangent){try{M=GeometryPipeline.computeTangentAndBitangent(M)}catch(e){oneTimeWarning("polyline-volume-tangent-bitangent","Unable to compute tangents and bitangents for polyline volume geometry")}r.tangent||(M.attributes.tangent=void 0),r.bitangent||(M.attributes.bitangent=void 0),r.st||(M.attributes.st=void 0)}return M}function PolylineVolumeGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,i=e.shapePositions;this._positions=t,this._shape=i,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";var r=1+t.length*Cartesian3.packedLength;r+=1+i.length*Cartesian2.packedLength,this.packedLength=r+Ellipsoid.packedLength+VertexFormat.packedLength+2}PolylineGeometry.createGeometry=function(e){var t,i,r,n=e._width,a=e._vertexFormat,o=e._colors,s=e._colorsPerVertex,l=e._arcType,c=e._granularity,u=e._ellipsoid,d=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),h=d.length;if(!(h<2||n<=0)){if(l===ArcType$1.GEODESIC||l===ArcType$1.RHUMB){var p,m;m=l===ArcType$1.GEODESIC?(p=CesiumMath.chordLength(c,u.maximumRadius),PolylinePipeline.numberOfPoints):(p=c,PolylinePipeline.numberOfPointsRhumbLine);var f=PolylinePipeline.extractHeights(d,u);if(defined(o)){var g=1;for(t=0;t<h-1;++t)g+=m(d[t],d[t+1],p);var _=new Array(g),y=0;for(t=0;t<h-1;++t){var v=d[t],C=d[t+1],S=o[t],T=m(v,C,p);if(s&&t<g){var x=interpolateColors(v,C,S,o[t+1],T),b=x.length;for(i=0;i<b;++i)_[y++]=x[i]}else for(i=0;i<T;++i)_[y++]=Color.clone(S)}_[y]=Color.clone(o[o.length-1]),o=_,scratchInterpolateColorsArray.length=0}d=l===ArcType$1.GEODESIC?PolylinePipeline.generateCartesianArc({positions:d,minDistance:p,ellipsoid:u,height:f}):PolylinePipeline.generateCartesianRhumbArc({positions:d,granularity:p,ellipsoid:u,height:f})}var E,P=4*(h=d.length)-4,A=new Float64Array(3*P),w=new Float64Array(3*P),D=new Float64Array(3*P),M=new Float32Array(2*P),I=a.st?new Float32Array(2*P):void 0,R=defined(o)?new Uint8Array(4*P):void 0,O=0,L=0,F=0,N=0;for(i=0;i<h;++i){var V,B;0===i?(E=scratchCartesian3$8,Cartesian3.subtract(d[0],d[1],E),Cartesian3.add(d[0],E,E)):E=d[i-1],Cartesian3.clone(E,scratchPrevPosition),Cartesian3.clone(d[i],scratchPosition$4),i===h-1?(E=scratchCartesian3$8,Cartesian3.subtract(d[h-1],d[h-2],E),Cartesian3.add(d[h-1],E,E)):E=d[i+1],Cartesian3.clone(E,scratchNextPosition),defined(R)&&(V=0===i||s?o[i]:o[i-1],i!==h-1&&(B=o[i]));var k=i===h-1?2:4;for(r=0===i?2:0;r<k;++r){Cartesian3.pack(scratchPosition$4,A,O),Cartesian3.pack(scratchPrevPosition,w,O),Cartesian3.pack(scratchNextPosition,D,O),O+=3;var $=r-2<0?-1:1;if(M[L++]=r%2*2-1,M[L++]=$*n,a.st&&(I[F++]=i/(h-1),I[F++]=Math.max(M[L-2],0)),defined(R)){var z=r<2?V:B;R[N++]=Color.floatToByte(z.red),R[N++]=Color.floatToByte(z.green),R[N++]=Color.floatToByte(z.blue),R[N++]=Color.floatToByte(z.alpha)}}}var U=new GeometryAttributes;U.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:A}),U.prevPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:w}),U.nextPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:D}),U.expandAndWidth=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:M}),a.st&&(U.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:I})),defined(R)&&(U.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:R,normalize:!0}));var G=IndexDatatype$1.createTypedArray(P,6*h-6),H=0,W=0,q=h-1;for(i=0;i<q;++i)G[W++]=H,G[W++]=H+2,G[W++]=H+1,G[W++]=H+1,G[W++]=H+2,G[W++]=H+3,H+=4;return new Geometry({attributes:U,indices:G,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromPoints(d),geometryType:GeometryType$1.POLYLINES})}},PolylineVolumeGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._shape;for(a=o.length,t[i++]=a,r=0;r<a;++r,i+=Cartesian2.packedLength)Cartesian2.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._cornerType,t[i]=e._granularity,t};var scratchEllipsoid$8=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$a=new VertexFormat,scratchOptions$g={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$8,vertexFormat:scratchVertexFormat$a,cornerType:void 0,granularity:void 0};PolylineVolumeGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n=e[t++],a=new Array(n);for(r=0;r<n;++r,t+=Cartesian3.packedLength)a[r]=Cartesian3.unpack(e,t);n=e[t++];var o=new Array(n);for(r=0;r<n;++r,t+=Cartesian2.packedLength)o[r]=Cartesian2.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$8);t+=Ellipsoid.packedLength;var l=VertexFormat.unpack(e,t,scratchVertexFormat$a);t+=VertexFormat.packedLength;var c=e[t++],u=e[t];return defined(i)?(i._positions=a,i._shape=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._vertexFormat=VertexFormat.clone(l,i._vertexFormat),i._cornerType=c,i._granularity=u,i):(scratchOptions$g.polylinePositions=a,scratchOptions$g.shapePositions=o,scratchOptions$g.cornerType=c,scratchOptions$g.granularity=u,new PolylineVolumeGeometry(scratchOptions$g))};var brScratch=new BoundingRectangle;function computeAttributes$2(e,t){var i=new GeometryAttributes;i.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e});var r,n,a=t.length,o=i.position.values.length/3,s=e.length/3/a,l=IndexDatatype$1.createTypedArray(o,2*a*(1+s)),c=0,u=(r=0)*a;for(n=0;n<a-1;n++)l[c++]=n+u,l[c++]=n+u+1;for(l[c++]=a-1+u,l[c++]=u,u=(r=s-1)*a,n=0;n<a-1;n++)l[c++]=n+u,l[c++]=n+u+1;for(l[c++]=a-1+u,l[c++]=u,r=0;r<s-1;r++){var d=a*r,h=d+a;for(n=0;n<a;n++)l[c++]=n+d,l[c++]=n+h}return new Geometry({attributes:i,indices:IndexDatatype$1.createTypedArray(o,l),boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.LINES})}function PolylineVolumeOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,i=e.shapePositions;this._positions=t,this._shape=i,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";var r=1+t.length*Cartesian3.packedLength;r+=1+i.length*Cartesian2.packedLength,this.packedLength=r+Ellipsoid.packedLength+2}PolylineVolumeGeometry.createGeometry=function(e){var t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),i=e._shape;if(i=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(i),!(t.length<2||i.length<3)){PolygonPipeline.computeWindingOrder2D(i)===WindingOrder$1.CLOCKWISE&&i.reverse();var r=BoundingRectangle.fromPoints(i,brScratch);return computeAttributes$1(PolylineVolumeGeometryLibrary.computePositions(t,i,r,e,!0),i,r,e._vertexFormat)}},PolylineVolumeOutlineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._shape;for(a=o.length,t[i++]=a,r=0;r<a;++r,i+=Cartesian2.packedLength)Cartesian2.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._cornerType,t[i]=e._granularity,t};var scratchEllipsoid$9=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$h={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$9,height:void 0,cornerType:void 0,granularity:void 0};PolylineVolumeOutlineGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n=e[t++],a=new Array(n);for(r=0;r<n;++r,t+=Cartesian3.packedLength)a[r]=Cartesian3.unpack(e,t);n=e[t++];var o=new Array(n);for(r=0;r<n;++r,t+=Cartesian2.packedLength)o[r]=Cartesian2.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$9);t+=Ellipsoid.packedLength;var l=e[t++],c=e[t];return defined(i)?(i._positions=a,i._shape=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._cornerType=l,i._granularity=c,i):(scratchOptions$h.polylinePositions=a,scratchOptions$h.shapePositions=o,scratchOptions$h.cornerType=l,scratchOptions$h.granularity=c,new PolylineVolumeOutlineGeometry(scratchOptions$h))};var brScratch$1=new BoundingRectangle;function createEvaluateFunction$1(o){var s=o.points,l=o.times;return function(e,t){defined(t)||(t=new Quaternion);var i=o._lastTimeIndex=o.findTimeInterval(e,o._lastTimeIndex),r=(e-l[i])/(l[i+1]-l[i]),n=s[i],a=s[i+1];return Quaternion.fastSlerp(n,a,r,t)}}function QuaternionSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times;this._times=i,this._points=t,this._evaluateFunction=createEvaluateFunction$1(this),this._lastTimeIndex=0}function quickselect(e,t,i,r,n){quickselectStep(e,t,i||0,r||e.length-1,n||defaultCompare)}function quickselectStep(e,t,i,r,n){for(;i<r;){if(600<r-i){var a=r-i+1,o=t-i+1,s=Math.log(a),l=.5*Math.exp(2*s/3),c=.5*Math.sqrt(s*l*(a-l)/a)*(o-a/2<0?-1:1);quickselectStep(e,t,Math.max(i,Math.floor(t-o*l/a+c)),Math.min(r,Math.floor(t+(a-o)*l/a+c)),n)}var u=e[t],d=i,h=r;for(swap$1(e,i,t),0<n(e[r],u)&&swap$1(e,i,r);d<h;){for(swap$1(e,d,h),d++,h--;n(e[d],u)<0;)d++;for(;0<n(e[h],u);)h--}0===n(e[i],u)?swap$1(e,i,h):swap$1(e,++h,r),h<=t&&(i=h+1),t<=h&&(r=h-1)}}function swap$1(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function defaultCompare(e,t){return e<t?-1:t<e?1:0}function rbush(e,t){if(!(this instanceof rbush))return new rbush(e,t);this._maxEntries=Math.max(4,e||9),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),t&&this._initFormat(t),this.clear()}function findItem(e,t,i){if(!i)return t.indexOf(e);for(var r=0;r<t.length;r++)if(i(e,t[r]))return r;return-1}function calcBBox(e,t){distBBox(e,0,e.children.length,t,e)}function distBBox(e,t,i,r,n){(n=n||createNode(null)).minX=1/0,n.minY=1/0,n.maxX=-1/0,n.maxY=-1/0;for(var a,o=t;o<i;o++)a=e.children[o],extend(n,e.leaf?r(a):a);return n}function extend(e,t){return e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),e}function compareNodeMinX(e,t){return e.minX-t.minX}function compareNodeMinY(e,t){return e.minY-t.minY}function bboxArea(e){return(e.maxX-e.minX)*(e.maxY-e.minY)}function bboxMargin(e){return e.maxX-e.minX+(e.maxY-e.minY)}function enlargedArea(e,t){return(Math.max(t.maxX,e.maxX)-Math.min(t.minX,e.minX))*(Math.max(t.maxY,e.maxY)-Math.min(t.minY,e.minY))}function intersectionArea(e,t){var i=Math.max(e.minX,t.minX),r=Math.max(e.minY,t.minY),n=Math.min(e.maxX,t.maxX),a=Math.min(e.maxY,t.maxY);return Math.max(0,n-i)*Math.max(0,a-r)}function contains(e,t){return e.minX<=t.minX&&e.minY<=t.minY&&t.maxX<=e.maxX&&t.maxY<=e.maxY}function intersects$1(e,t){return t.minX<=e.maxX&&t.minY<=e.maxY&&t.maxX>=e.minX&&t.maxY>=e.minY}function createNode(e){return{children:e,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function multiSelect(e,t,i,r,n){for(var a,o=[t,i];o.length;)(i=o.pop())-(t=o.pop())<=r||(quickselect(e,a=t+Math.ceil((i-t)/r/2)*r,t,i,n),o.push(t,a,a,i))}function RectangleCollisionChecker(){this._tree=rbush()}function RectangleWithId(){this.minX=0,this.minY=0,this.maxX=0,this.maxY=0,this.id=""}function idCompare(e,t){return e.id===t.id}PolylineVolumeOutlineGeometry.createGeometry=function(e){var t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),i=e._shape;if(i=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(i),!(t.length<2||i.length<3)){PolygonPipeline.computeWindingOrder2D(i)===WindingOrder$1.CLOCKWISE&&i.reverse();var r=BoundingRectangle.fromPoints(i,brScratch$1);return computeAttributes$2(PolylineVolumeGeometryLibrary.computePositions(t,i,r,e,!1),i)}},defineProperties$1(QuaternionSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),QuaternionSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,QuaternionSpline.prototype.wrapTime=Spline.prototype.wrapTime,QuaternionSpline.prototype.clampTime=Spline.prototype.clampTime,QuaternionSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},rbush.prototype={all:function(){return this._all(this.data,[])},search:function(e){var t=this.data,i=[],r=this.toBBox;if(!intersects$1(e,t))return i;for(var n,a,o,s,l=[];t;){for(n=0,a=t.children.length;n<a;n++)o=t.children[n],intersects$1(e,s=t.leaf?r(o):o)&&(t.leaf?i.push(o):contains(e,s)?this._all(o,i):l.push(o));t=l.pop()}return i},collides:function(e){var t=this.data,i=this.toBBox;if(!intersects$1(e,t))return!1;for(var r,n,a,o,s=[];t;){for(r=0,n=t.children.length;r<n;r++)if(a=t.children[r],intersects$1(e,o=t.leaf?i(a):a)){if(t.leaf||contains(e,o))return!0;s.push(a)}t=s.pop()}return!1},load:function(e){if(!e||!e.length)return this;if(e.length<this._minEntries){for(var t=0,i=e.length;t<i;t++)this.insert(e[t]);return this}var r=this._build(e.slice(),0,e.length-1,0);if(this.data.children.length)if(this.data.height===r.height)this._splitRoot(this.data,r);else{if(this.data.height<r.height){var n=this.data;this.data=r,r=n}this._insert(r,this.data.height-r.height-1,!0)}else this.data=r;return this},insert:function(e){return e&&this._insert(e,this.data.height-1),this},clear:function(){return this.data=createNode([]),this},remove:function(e,t){if(!e)return this;for(var i,r,n,a,o=this.data,s=this.toBBox(e),l=[],c=[];o||l.length;){if(o||(o=l.pop(),r=l[l.length-1],i=c.pop(),a=!0),o.leaf&&-1!==(n=findItem(e,o.children,t)))return o.children.splice(n,1),l.push(o),this._condense(l),this;a||o.leaf||!contains(o,s)?r?(i++,o=r.children[i],a=!1):o=null:(l.push(o),c.push(i),i=0,o=(r=o).children[0])}return this},toBBox:function(e){return e},compareMinX:compareNodeMinX,compareMinY:compareNodeMinY,toJSON:function(){return this.data},fromJSON:function(e){return this.data=e,this},_all:function(e,t){for(var i=[];e;)e.leaf?t.push.apply(t,e.children):i.push.apply(i,e.children),e=i.pop();return t},_build:function(e,t,i,r){var n,a=i-t+1,o=this._maxEntries;if(a<=o)return calcBBox(n=createNode(e.slice(t,i+1)),this.toBBox),n;r||(r=Math.ceil(Math.log(a)/Math.log(o)),o=Math.ceil(a/Math.pow(o,r-1))),(n=createNode([])).leaf=!1,n.height=r;var s,l,c,u,d=Math.ceil(a/o),h=d*Math.ceil(Math.sqrt(o));for(multiSelect(e,t,i,h,this.compareMinX),s=t;s<=i;s+=h)for(multiSelect(e,s,c=Math.min(s+h-1,i),d,this.compareMinY),l=s;l<=c;l+=d)u=Math.min(l+d-1,c),n.children.push(this._build(e,l,u,r-1));return calcBBox(n,this.toBBox),n},_chooseSubtree:function(e,t,i,r){for(var n,a,o,s,l,c,u,d;r.push(t),!t.leaf&&r.length-1!==i;){for(u=d=1/0,n=0,a=t.children.length;n<a;n++)l=bboxArea(o=t.children[n]),(c=enlargedArea(e,o)-l)<d?(d=c,u=l<u?l:u,s=o):c===d&&l<u&&(u=l,s=o);t=s||t.children[0]}return t},_insert:function(e,t,i){var r=this.toBBox,n=i?e:r(e),a=[],o=this._chooseSubtree(n,this.data,t,a);for(o.children.push(e),extend(o,n);0<=t&&a[t].children.length>this._maxEntries;)this._split(a,t),t--;this._adjustParentBBoxes(n,a,t)},_split:function(e,t){var i=e[t],r=i.children.length,n=this._minEntries;this._chooseSplitAxis(i,n,r);var a=this._chooseSplitIndex(i,n,r),o=createNode(i.children.splice(a,i.children.length-a));o.height=i.height,o.leaf=i.leaf,calcBBox(i,this.toBBox),calcBBox(o,this.toBBox),t?e[t-1].children.push(o):this._splitRoot(i,o)},_splitRoot:function(e,t){this.data=createNode([e,t]),this.data.height=e.height+1,this.data.leaf=!1,calcBBox(this.data,this.toBBox)},_chooseSplitIndex:function(e,t,i){var r,n,a,o,s,l,c,u;for(l=c=1/0,r=t;r<=i-t;r++)o=intersectionArea(n=distBBox(e,0,r,this.toBBox),a=distBBox(e,r,i,this.toBBox)),s=bboxArea(n)+bboxArea(a),o<l?(l=o,u=r,c=s<c?s:c):o===l&&s<c&&(c=s,u=r);return u},_chooseSplitAxis:function(e,t,i){var r=e.leaf?this.compareMinX:compareNodeMinX,n=e.leaf?this.compareMinY:compareNodeMinY;this._allDistMargin(e,t,i,r)<this._allDistMargin(e,t,i,n)&&e.children.sort(r)},_allDistMargin:function(e,t,i,r){e.children.sort(r);var n,a,o=this.toBBox,s=distBBox(e,0,t,o),l=distBBox(e,i-t,i,o),c=bboxMargin(s)+bboxMargin(l);for(n=t;n<i-t;n++)a=e.children[n],extend(s,e.leaf?o(a):a),c+=bboxMargin(s);for(n=i-t-1;t<=n;n--)a=e.children[n],extend(l,e.leaf?o(a):a),c+=bboxMargin(l);return c},_adjustParentBBoxes:function(e,t,i){for(var r=i;0<=r;r--)extend(t[r],e)},_condense:function(e){for(var t,i=e.length-1;0<=i;i--)0===e[i].children.length?0<i?(t=e[i-1].children).splice(t.indexOf(e[i]),1):this.clear():calcBBox(e[i],this.toBBox)},_initFormat:function(e){var t=["return a"," - b",";"];this.compareMinX=new Function("a","b",t.join(e[0])),this.compareMinY=new Function("a","b",t.join(e[1])),this.toBBox=new Function("a","return {minX: a"+e[0]+", minY: a"+e[1]+", maxX: a"+e[2]+", maxY: a"+e[3]+"};")}},RectangleWithId.fromRectangleAndId=function(e,t,i){return i.minX=t.west,i.minY=t.south,i.maxX=t.east,i.maxY=t.north,i.id=e,i},RectangleCollisionChecker.prototype.insert=function(e,t){var i=RectangleWithId.fromRectangleAndId(e,t,new RectangleWithId);this._tree.insert(i)};var removalScratch=new RectangleWithId;RectangleCollisionChecker.prototype.remove=function(e,t){var i=RectangleWithId.fromRectangleAndId(e,t,removalScratch);this._tree.remove(i,idCompare)};var collisionScratch=new RectangleWithId;RectangleCollisionChecker.prototype.collides=function(e){var t=RectangleWithId.fromRectangleAndId("",e,collisionScratch);return this._tree.collides(t)};var cos$2=Math.cos,sin$2=Math.sin,sqrt=Math.sqrt,RectangleGeometryLibrary={computePosition:function(e,t,i,r,n,a,o){var s=t.radiiSquared,l=e.nwCorner,c=e.boundingRectangle,u=l.latitude-e.granYCos*r+n*e.granXSin,d=cos$2(u),h=sin$2(u),p=s.z*h,m=l.longitude+r*e.granYSin+n*e.granXCos,f=d*cos$2(m),g=d*sin$2(m),_=s.x*f,y=s.y*g,v=sqrt(_*f+y*g+p*h);if(a.x=_/v,a.y=y/v,a.z=p/v,i){var C=e.stNwCorner;defined(C)?(u=C.latitude-e.stGranYCos*r+n*e.stGranXSin,m=C.longitude+r*e.stGranYSin+n*e.stGranXCos,o.x=(m-e.stWest)*e.lonScalar,o.y=(u-e.stSouth)*e.latScalar):(o.x=(m-c.west)*e.lonScalar,o.y=(u-c.south)*e.latScalar)}}},rotationMatrixScratch=new Matrix2,nwCartesian=new Cartesian3,centerScratch$2=new Cartographic,centerCartesian=new Cartesian3,proj=new GeographicProjection;function getRotationOptions(e,t,i,r,n,a,o){var s=Math.cos(t),l=r*s,c=i*s,u=Math.sin(t),d=r*u,h=i*u;nwCartesian=proj.project(e,nwCartesian),nwCartesian=Cartesian3.subtract(nwCartesian,centerCartesian,nwCartesian);var p=Matrix2.fromRotation(t,rotationMatrixScratch);nwCartesian=Matrix2.multiplyByVector(p,nwCartesian,nwCartesian),nwCartesian=Cartesian3.add(nwCartesian,centerCartesian,nwCartesian),a-=1,o-=1;var m=(e=proj.unproject(nwCartesian,e)).latitude,f=m+a*h,g=m-l*o,_=m-l*o+a*h,y=Math.max(m,f,g,_),v=Math.min(m,f,g,_),C=e.longitude,S=C+a*c,T=C+o*d,x=C+o*d+a*c;return{north:y,south:v,east:Math.max(C,S,T,x),west:Math.min(C,S,T,x),granYCos:l,granYSin:d,granXCos:c,granXSin:h,nwCorner:e}}RectangleGeometryLibrary.computeOptions=function(e,t,i,r,n,a,o){var s,l,c,u,d,h=e.east,p=e.west,m=e.north,f=e.south,g=!1,_=!1;m===CesiumMath.PI_OVER_TWO&&(g=!0),f===-CesiumMath.PI_OVER_TWO&&(_=!0);var y=m-f;c=(d=h<p?CesiumMath.TWO_PI-p+h:h-p)/((s=Math.ceil(d/t)+1)-1),u=y/((l=Math.ceil(y/t)+1)-1);var v=Rectangle.northwest(e,a),C=Rectangle.center(e,centerScratch$2);0===i&&0===r||(C.longitude<v.longitude&&(C.longitude+=CesiumMath.TWO_PI),centerCartesian=proj.project(C,centerCartesian));var S=u,T=c,x=Rectangle.clone(e,n),b={granYCos:S,granYSin:0,granXCos:T,granXSin:0,nwCorner:v,boundingRectangle:x,width:s,height:l,northCap:g,southCap:_};if(0!==i){var E=getRotationOptions(v,i,c,u,C,s,l);m=E.north,f=E.south,h=E.east,p=E.west,b.granYCos=E.granYCos,b.granYSin=E.granYSin,b.granXCos=E.granXCos,b.granXSin=E.granXSin,x.north=m,x.south=f,x.east=h,x.west=p}if(0!==r){i-=r;var P=Rectangle.northwest(x,o),A=getRotationOptions(P,i,c,u,C,s,l);b.stGranYCos=A.granYCos,b.stGranXCos=A.granXCos,b.stGranYSin=A.granYSin,b.stGranXSin=A.granXSin,b.stNwCorner=P,b.stWest=A.west,b.stSouth=A.south}return b};var positionScratch$2=new Cartesian3,normalScratch$3=new Cartesian3,tangentScratch$1=new Cartesian3,bitangentScratch$1=new Cartesian3,rectangleScratch$2=new Rectangle,stScratch$1=new Cartesian2,bottomBoundingSphere$2=new BoundingSphere,topBoundingSphere$2=new BoundingSphere;function createAttributes(e,t){var i=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.TRIANGLES});return i.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(i.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(i.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.bitangent&&(i.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.bitangents})),i}function calculateAttributes(e,t,i,r){var n=e.length,a=t.normal?new Float32Array(n):void 0,o=t.tangent?new Float32Array(n):void 0,s=t.bitangent?new Float32Array(n):void 0,l=0,c=bitangentScratch$1,u=tangentScratch$1,d=normalScratch$3;if(t.normal||t.tangent||t.bitangent)for(var h=0;h<n;h+=3){var p=Cartesian3.fromArray(e,h,positionScratch$2),m=l+1,f=l+2;d=i.geodeticSurfaceNormal(p,d),(t.tangent||t.bitangent)&&(Cartesian3.cross(Cartesian3.UNIT_Z,d,u),Matrix3.multiplyByVector(r,u,u),Cartesian3.normalize(u,u),t.bitangent&&Cartesian3.normalize(Cartesian3.cross(d,u,c),c)),t.normal&&(a[l]=d.x,a[m]=d.y,a[f]=d.z),t.tangent&&(o[l]=u.x,o[m]=u.y,o[f]=u.z),t.bitangent&&(s[l]=c.x,s[m]=c.y,s[f]=c.z),l+=3}return createAttributes(t,{positions:e,normals:a,tangents:o,bitangents:s})}var v1Scratch=new Cartesian3,v2Scratch=new Cartesian3;function calculateAttributesWall(e,t,i){var r=e.length,n=t.normal?new Float32Array(r):void 0,a=t.tangent?new Float32Array(r):void 0,o=t.bitangent?new Float32Array(r):void 0,s=0,l=0,c=0,u=!0,d=bitangentScratch$1,h=tangentScratch$1,p=normalScratch$3;if(t.normal||t.tangent||t.bitangent)for(var m=0;m<r;m+=6){var f=Cartesian3.fromArray(e,m,positionScratch$2),g=Cartesian3.fromArray(e,(m+6)%r,v1Scratch);if(u){var _=Cartesian3.fromArray(e,(m+3)%r,v2Scratch);Cartesian3.subtract(g,f,g),Cartesian3.subtract(_,f,_),p=Cartesian3.normalize(Cartesian3.cross(_,g,p),p),u=!1}Cartesian3.equalsEpsilon(g,f,CesiumMath.EPSILON10)&&(u=!0),(t.tangent||t.bitangent)&&(d=i.geodeticSurfaceNormal(f,d),t.tangent&&(h=Cartesian3.normalize(Cartesian3.cross(d,p,h),h))),t.normal&&(n[s++]=p.x,n[s++]=p.y,n[s++]=p.z,n[s++]=p.x,n[s++]=p.y,n[s++]=p.z),t.tangent&&(a[l++]=h.x,a[l++]=h.y,a[l++]=h.z,a[l++]=h.x,a[l++]=h.y,a[l++]=h.z),t.bitangent&&(o[c++]=d.x,o[c++]=d.y,o[c++]=d.z,o[c++]=d.x,o[c++]=d.y,o[c++]=d.z)}return createAttributes(t,{positions:e,normals:n,tangents:a,bitangents:o})}function constructRectangle(e,t){var i=e._vertexFormat,r=e._ellipsoid,n=t.height,a=t.width,o=t.northCap,s=t.southCap,l=0,c=n,u=n,d=0;o&&(u-=l=1,d+=1),s&&(c-=1,u-=1,d+=1),d+=a*u;for(var h=i.position?new Float64Array(3*d):void 0,p=i.st?new Float32Array(2*d):void 0,m=0,f=0,g=positionScratch$2,_=stScratch$1,y=Number.MAX_VALUE,v=Number.MAX_VALUE,C=-Number.MAX_VALUE,S=-Number.MAX_VALUE,T=l;T<c;++T)for(var x=0;x<a;++x)RectangleGeometryLibrary.computePosition(t,r,i.st,T,x,g,_),h[m++]=g.x,h[m++]=g.y,h[m++]=g.z,i.st&&(p[f++]=_.x,p[f++]=_.y,y=Math.min(y,_.x),v=Math.min(v,_.y),C=Math.max(C,_.x),S=Math.max(S,_.y));if(o&&(RectangleGeometryLibrary.computePosition(t,r,i.st,0,0,g,_),h[m++]=g.x,h[m++]=g.y,h[m++]=g.z,i.st&&(p[f++]=_.x,p[f++]=_.y,y=_.x,v=_.y,C=_.x,S=_.y)),s&&(RectangleGeometryLibrary.computePosition(t,r,i.st,n-1,0,g,_),h[m++]=g.x,h[m++]=g.y,h[m]=g.z,i.st&&(p[f++]=_.x,p[f]=_.y,y=Math.min(y,_.x),v=Math.min(v,_.y),C=Math.max(C,_.x),S=Math.max(S,_.y))),i.st&&(y<0||v<0||1<C||1<S))for(var b=0;b<p.length;b+=2)p[b]=(p[b]-y)/(C-y),p[b+1]=(p[b+1]-v)/(S-v);var E=calculateAttributes(h,i,r,t.tangentRotationMatrix),P=6*(a-1)*(u-1);o&&(P+=3*(a-1)),s&&(P+=3*(a-1));var A,w=IndexDatatype$1.createTypedArray(d,P),D=0,M=0;for(A=0;A<u-1;++A){for(var I=0;I<a-1;++I){var R=D,O=R+a,L=O+1,F=R+1;w[M++]=R,w[M++]=O,w[M++]=F,w[M++]=F,w[M++]=O,w[M++]=L,++D}++D}if(o||s){var N,V,B=d-1,k=d-1;if(o&&s&&(B=d-2),D=0,o)for(A=0;A<a-1;A++)V=(N=D)+1,w[M++]=B,w[M++]=N,w[M++]=V,++D;if(s)for(D=(u-1)*a,A=0;A<a-1;A++)V=(N=D)+1,w[M++]=N,w[M++]=k,w[M++]=V,++D}return E.indices=w,i.st&&(E.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:p})),E}function addWallPositions$1(e,t,i,r,n){return e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i+2],e[t++]=n[i],e[t++]=n[i+1],e[t]=n[i+2],e}function addWallTextureCoordinates(e,t,i,r){return e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i],e[t]=r[i+1],e}var scratchVertexFormat$b=new VertexFormat;function constructExtrudedRectangle(e,t){var i,r=e._shadowVolume,n=e._offsetAttribute,a=e._vertexFormat,o=e._extrudedHeight,s=e._surfaceHeight,l=e._ellipsoid,c=t.height,u=t.width;if(r){var d=VertexFormat.clone(a,scratchVertexFormat$b);d.normal=!0,e._vertexFormat=d}var h=constructRectangle(e,t);r&&(e._vertexFormat=a);var p=PolygonPipeline.scaleToGeodeticHeight(h.attributes.position.values,s,l,!1),m=(p=new Float64Array(p)).length,f=2*m,g=new Float64Array(f);g.set(p);var _=PolygonPipeline.scaleToGeodeticHeight(h.attributes.position.values,o,l);g.set(_,m),h.attributes.position.values=g;var y,v,C=a.normal?new Float32Array(f):void 0,S=a.tangent?new Float32Array(f):void 0,T=a.bitangent?new Float32Array(f):void 0,x=a.st?new Float32Array(f/3*2):void 0;if(a.normal){for(v=h.attributes.normal.values,C.set(v),i=0;i<m;i++)v[i]=-v[i];C.set(v,m),h.attributes.normal.values=C}if(r){v=h.attributes.normal.values,a.normal||(h.attributes.normal=void 0);var b=new Float32Array(f);for(i=0;i<m;i++)v[i]=-v[i];b.set(v,m),h.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:b})}var E=defined(n);if(E){var P=m/3*2,A=new Uint8Array(P);A=n===GeometryOffsetAttribute$1.TOP?arrayFill(A,1,0,P/2):arrayFill(A,n===GeometryOffsetAttribute$1.NONE?0:1),h.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:A})}if(a.tangent){var w=h.attributes.tangent.values;for(S.set(w),i=0;i<m;i++)w[i]=-w[i];S.set(w,m),h.attributes.tangent.values=S}if(a.bitangent){var D=h.attributes.bitangent.values;T.set(D),T.set(D,m),h.attributes.bitangent.values=T}a.st&&(y=h.attributes.st.values,x.set(y),x.set(y,m/3*2),h.attributes.st.values=x);var M=h.indices,I=M.length,R=m/3,O=IndexDatatype$1.createTypedArray(f/3,2*I);for(O.set(M),i=0;i<I;i+=3)O[i+I]=M[i+2]+R,O[i+1+I]=M[i+1]+R,O[i+2+I]=M[i]+R;h.indices=O;var L=t.northCap,F=t.southCap,N=c,V=2,B=0,k=4,$=4;L&&(V-=1,N-=1,B+=1,k-=2,$-=1),F&&(V-=1,N-=1,B+=1,k-=2,$-=1);var z=2*((B+=V*u+2*N-k)+$),U=new Float64Array(3*z),G=r?new Float32Array(3*z):void 0,H=E?new Uint8Array(z):void 0,W=a.st?new Float32Array(2*z):void 0,q=n===GeometryOffsetAttribute$1.TOP;E&&!q&&(H=arrayFill(H,n===GeometryOffsetAttribute$1.ALL?1:0));var j,Y=0,X=0,Q=0,J=0,Z=u*N;for(i=0;i<Z;i+=u)U=addWallPositions$1(U,Y,j=3*i,p,_),Y+=6,a.st&&(W=addWallTextureCoordinates(W,X,2*i,y),X+=4),r&&(Q+=3,G[Q++]=v[j],G[Q++]=v[j+1],G[Q++]=v[j+2]),q&&(H[J++]=1,J+=1);if(F){var K=L?1+Z:Z;for(j=3*K,i=0;i<2;i++)U=addWallPositions$1(U,Y,j,p,_),Y+=6,a.st&&(W=addWallTextureCoordinates(W,X,2*K,y),X+=4),r&&(Q+=3,G[Q++]=v[j],G[Q++]=v[j+1],G[Q++]=v[j+2]),q&&(H[J++]=1,J+=1)}else for(i=Z-u;i<Z;i++)U=addWallPositions$1(U,Y,j=3*i,p,_),Y+=6,a.st&&(W=addWallTextureCoordinates(W,X,2*i,y),X+=4),r&&(Q+=3,G[Q++]=v[j],G[Q++]=v[j+1],G[Q++]=v[j+2]),q&&(H[J++]=1,J+=1);for(i=Z-1;0<i;i-=u)U=addWallPositions$1(U,Y,j=3*i,p,_),Y+=6,a.st&&(W=addWallTextureCoordinates(W,X,2*i,y),X+=4),r&&(Q+=3,G[Q++]=v[j],G[Q++]=v[j+1],G[Q++]=v[j+2]),q&&(H[J++]=1,J+=1);if(L){var ee=Z;for(j=3*ee,i=0;i<2;i++)U=addWallPositions$1(U,Y,j,p,_),Y+=6,a.st&&(W=addWallTextureCoordinates(W,X,2*ee,y),X+=4),r&&(Q+=3,G[Q++]=v[j],G[Q++]=v[j+1],G[Q++]=v[j+2]),q&&(H[J++]=1,J+=1)}else for(i=u-1;0<=i;i--)U=addWallPositions$1(U,Y,j=3*i,p,_),Y+=6,a.st&&(W=addWallTextureCoordinates(W,X,2*i,y),X+=4),r&&(Q+=3,G[Q++]=v[j],G[Q++]=v[j+1],G[Q++]=v[j+2]),q&&(H[J++]=1,J+=1);var te=calculateAttributesWall(U,a,l);a.st&&(te.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:W})),r&&(te.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:G})),E&&(te.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:H}));var ie,re,ne,ae,oe=IndexDatatype$1.createTypedArray(z,6*B);m=U.length/3;var se=0;for(i=0;i<m-1;i+=2){ae=((ie=i)+2)%m;var le=Cartesian3.fromArray(U,3*ie,v1Scratch),ce=Cartesian3.fromArray(U,3*ae,v2Scratch);Cartesian3.equalsEpsilon(le,ce,CesiumMath.EPSILON10)||(ne=(2+(re=(ie+1)%m))%m,oe[se++]=ie,oe[se++]=re,oe[se++]=ae,oe[se++]=ae,oe[se++]=re,oe[se++]=ne)}return te.indices=oe,(te=GeometryPipeline.combineInstances([new GeometryInstance({geometry:h}),new GeometryInstance({geometry:te})]))[0]}var scratchRectanglePoints=[new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3],nwScratch=new Cartographic,stNwScratch=new Cartographic;function computeRectangle$3(e,t,i,r,n){if(0===i)return Rectangle.clone(e,n);var a=RectangleGeometryLibrary.computeOptions(e,t,i,0,rectangleScratch$2,nwScratch),o=a.height,s=a.width,l=scratchRectanglePoints;return RectangleGeometryLibrary.computePosition(a,r,!1,0,0,l[0]),RectangleGeometryLibrary.computePosition(a,r,!1,0,s-1,l[1]),RectangleGeometryLibrary.computePosition(a,r,!1,o-1,0,l[2]),RectangleGeometryLibrary.computePosition(a,r,!1,o-1,s-1,l[3]),Rectangle.fromCartesianArray(l,r,n)}function RectangleGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.height,0),r=defaultValue(e.extrudedHeight,i);this._rectangle=Rectangle.clone(t),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._surfaceHeight=Math.max(i,r),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._extrudedHeight=Math.min(i,r),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createRectangleGeometry",this._offsetAttribute=e.offsetAttribute,this._rotatedRectangle=void 0,this._textureCoordinateRotationPoints=void 0}RectangleGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7,RectangleGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Rectangle.pack(e._rectangle,t,i),i+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._extrudedHeight,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRectangle=new Rectangle,scratchEllipsoid$a=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$i={rectangle:scratchRectangle,ellipsoid:scratchEllipsoid$a,vertexFormat:scratchVertexFormat$b,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};RectangleGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Rectangle.unpack(e,t,scratchRectangle);t+=Rectangle.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$a);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$b);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=1===e[t++],h=e[t];return defined(i)?(i._rectangle=Rectangle.clone(r,i._rectangle),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._granularity=o,i._surfaceHeight=s,i._rotation=l,i._stRotation=c,i._extrudedHeight=u,i._shadowVolume=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$i.granularity=o,scratchOptions$i.height=s,scratchOptions$i.rotation=l,scratchOptions$i.stRotation=c,scratchOptions$i.extrudedHeight=u,scratchOptions$i.shadowVolume=d,scratchOptions$i.offsetAttribute=-1===h?void 0:h,new RectangleGeometry(scratchOptions$i))},RectangleGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,r=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),n=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle$3(i,r,defaultValue(e.rotation,0),n,t)};var tangentRotationMatrixScratch=new Matrix3,quaternionScratch$3=new Quaternion,centerScratch$3=new Cartographic;RectangleGeometry.createGeometry=function(e){if(!CesiumMath.equalsEpsilon(e._rectangle.north,e._rectangle.south,CesiumMath.EPSILON10)&&!CesiumMath.equalsEpsilon(e._rectangle.east,e._rectangle.west,CesiumMath.EPSILON10)){var t=e._rectangle,i=e._ellipsoid,r=e._rotation,n=e._stRotation,a=e._vertexFormat,o=RectangleGeometryLibrary.computeOptions(t,e._granularity,r,n,rectangleScratch$2,nwScratch,stNwScratch),s=tangentRotationMatrixScratch;if(0!==n||0!==r){var l=Rectangle.center(t,centerScratch$3),c=i.geodeticSurfaceNormalCartographic(l,v1Scratch);Quaternion.fromAxisAngle(c,-n,quaternionScratch$3),Matrix3.fromQuaternion(quaternionScratch$3,s)}else Matrix3.clone(Matrix3.IDENTITY,s);var u,d,h=e._surfaceHeight,p=e._extrudedHeight,m=!CesiumMath.equalsEpsilon(h,p,0,CesiumMath.EPSILON2);if(o.lonScalar=1/e._rectangle.width,o.latScalar=1/e._rectangle.height,o.tangentRotationMatrix=s,t=e._rectangle,m){u=constructExtrudedRectangle(e,o);var f=BoundingSphere.fromRectangle3D(t,i,h,topBoundingSphere$2),g=BoundingSphere.fromRectangle3D(t,i,p,bottomBoundingSphere$2);d=BoundingSphere.union(f,g)}else{if((u=constructRectangle(e,o)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,h,i,!1),defined(e._offsetAttribute)){var _=u.attributes.position.values.length,y=new Uint8Array(_/3);arrayFill(y,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),u.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:y})}d=BoundingSphere.fromRectangle3D(t,i,h)}return a.position||delete u.attributes.position,new Geometry({attributes:u.attributes,indices:u.indices,primitiveType:u.primitiveType,boundingSphere:d,offsetAttribute:e._offsetAttribute})}},RectangleGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,a=t(r,n),o=i(r,n);return new RectangleGeometry({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:n,stRotation:e._stRotation,granularity:r,extrudedHeight:o,height:a,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})};var unrotatedTextureRectangleScratch=new Rectangle,points2DScratch$1=[new Cartesian2,new Cartesian2,new Cartesian2],rotation2DScratch$1=new Matrix2,rectangleCenterScratch$1=new Cartographic;function textureCoordinateRotationPoints$2(e){if(0===e._stRotation)return[0,0,0,1,1,0];var t=Rectangle.clone(e._rectangle,unrotatedTextureRectangleScratch),i=e._granularity,r=e._ellipsoid,n=computeRectangle$3(t,i,e._rotation-e._stRotation,r,unrotatedTextureRectangleScratch),a=points2DScratch$1;a[0].x=n.west,a[0].y=n.south,a[1].x=n.west,a[1].y=n.north,a[2].x=n.east,a[2].y=n.south;for(var o=e.rectangle,s=Matrix2.fromRotation(e._stRotation,rotation2DScratch$1),l=Rectangle.center(o,rectangleCenterScratch$1),c=0;c<3;++c){var u=a[c];u.x-=l.longitude,u.y-=l.latitude,Matrix2.multiplyByVector(s,u,u),u.x+=l.longitude,u.y+=l.latitude,u.x=(u.x-o.west)/o.width,u.y=(u.y-o.south)/o.height}var d=a[0],h=a[1],p=a[2],m=new Array(6);return Cartesian2.pack(d,m),Cartesian2.pack(h,m,2),Cartesian2.pack(p,m,4),m}defineProperties$1(RectangleGeometry.prototype,{rectangle:{get:function(){return defined(this._rotatedRectangle)||(this._rotatedRectangle=computeRectangle$3(this._rectangle,this._granularity,this._rotation,this._ellipsoid)),this._rotatedRectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$2(this)),this._textureCoordinateRotationPoints}}});var bottomBoundingSphere$3=new BoundingSphere,topBoundingSphere$3=new BoundingSphere,positionScratch$3=new Cartesian3,rectangleScratch$3=new Rectangle;function constructRectangle$1(e,t){var i=e._ellipsoid,r=t.height,n=t.width,a=t.northCap,o=t.southCap,s=r,l=2,c=0,u=4;a&&(l-=1,s-=1,c+=1,u-=2),o&&(l-=1,s-=1,c+=1,u-=2),c+=l*n+2*s-u;var d,h=new Float64Array(3*c),p=0,m=0,f=positionScratch$3;if(a)RectangleGeometryLibrary.computePosition(t,i,!1,m,0,f),h[p++]=f.x,h[p++]=f.y,h[p++]=f.z;else for(d=0;d<n;d++)RectangleGeometryLibrary.computePosition(t,i,!1,m,d,f),h[p++]=f.x,h[p++]=f.y,h[p++]=f.z;for(d=n-1,m=1;m<r;m++)RectangleGeometryLibrary.computePosition(t,i,!1,m,d,f),h[p++]=f.x,h[p++]=f.y,h[p++]=f.z;if(m=r-1,!o)for(d=n-2;0<=d;d--)RectangleGeometryLibrary.computePosition(t,i,!1,m,d,f),h[p++]=f.x,h[p++]=f.y,h[p++]=f.z;for(d=0,m=r-2;0<m;m--)RectangleGeometryLibrary.computePosition(t,i,!1,m,d,f),h[p++]=f.x,h[p++]=f.y,h[p++]=f.z;for(var g=h.length/3*2,_=IndexDatatype$1.createTypedArray(h.length/3,g),y=0,v=0;v<h.length/3-1;v++)_[y++]=v,_[y++]=v+1;_[y++]=h.length/3-1,_[y++]=0;var C=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.LINES});return C.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:h}),C.indices=_,C}function constructExtrudedRectangle$1(e,t){var i=e._surfaceHeight,r=e._extrudedHeight,n=e._ellipsoid,a=r,o=i,s=constructRectangle$1(e,t),l=t.height,c=t.width,u=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,o,n,!1),d=u.length,h=new Float64Array(2*d);h.set(u);var p=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,a,n);h.set(p,d),s.attributes.position.values=h;var m=t.northCap,f=t.southCap,g=4;m&&(g-=1),f&&(g-=1);var _=2*(h.length/3+g),y=IndexDatatype$1.createTypedArray(h.length/3,_);d=h.length/6;for(var v,C=0,S=0;S<d-1;S++)y[C++]=S,y[C++]=S+1,y[C++]=S+d,y[C++]=S+d+1;if(y[C++]=d-1,y[C++]=0,y[C++]=d+d-1,y[C++]=d,y[C++]=0,y[C++]=d,m)v=l-1;else{var T=c-1;y[C++]=T,y[C++]=T+d,v=c+l-2}if(y[C++]=v,y[C++]=v+d,!f){var x=c+v-1;y[C++]=x,y[C]=x+d}return s.indices=y,s}function RectangleOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.rotation,0),a=defaultValue(e.height,0),o=defaultValue(e.extrudedHeight,a);this._rectangle=Rectangle.clone(t),this._granularity=i,this._ellipsoid=r,this._surfaceHeight=Math.max(a,o),this._rotation=n,this._extrudedHeight=Math.min(a,o),this._offsetAttribute=e.offsetAttribute,this._workerName="createRectangleOutlineGeometry"}RectangleOutlineGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+5,RectangleOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Rectangle.pack(e._rectangle,t,i),i+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._extrudedHeight,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRectangle$1=new Rectangle,scratchEllipsoid$b=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$j={rectangle:scratchRectangle$1,ellipsoid:scratchEllipsoid$b,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0,offsetAttribute:void 0};RectangleOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Rectangle.unpack(e,t,scratchRectangle$1);t+=Rectangle.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$b);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t];return defined(i)?(i._rectangle=Rectangle.clone(r,i._rectangle),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._surfaceHeight=o,i._rotation=s,i._extrudedHeight=l,i._offsetAttribute=-1===c?void 0:c,i):(scratchOptions$j.granularity=a,scratchOptions$j.height=o,scratchOptions$j.rotation=s,scratchOptions$j.extrudedHeight=l,scratchOptions$j.offsetAttribute=-1===c?void 0:c,new RectangleOutlineGeometry(scratchOptions$j))};var nwScratch$1=new Cartographic;RectangleOutlineGeometry.createGeometry=function(e){var t,i,r=e._rectangle,n=e._ellipsoid,a=RectangleGeometryLibrary.computeOptions(r,e._granularity,e._rotation,0,rectangleScratch$3,nwScratch$1);if(!CesiumMath.equalsEpsilon(r.north,r.south,CesiumMath.EPSILON10)&&!CesiumMath.equalsEpsilon(r.east,r.west,CesiumMath.EPSILON10)){var o=e._surfaceHeight,s=e._extrudedHeight;if(!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2)){if(t=constructExtrudedRectangle$1(e,a),defined(e._offsetAttribute)){var l=t.attributes.position.values.length/3,c=new Uint8Array(l);c=e._offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(c,1,0,l/2):arrayFill(c,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),t.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})}var u=BoundingSphere.fromRectangle3D(r,n,o,topBoundingSphere$3),d=BoundingSphere.fromRectangle3D(r,n,s,bottomBoundingSphere$3);i=BoundingSphere.union(u,d)}else{if((t=constructRectangle$1(e,a)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(t.attributes.position.values,o,n,!1),defined(e._offsetAttribute)){var h=t.attributes.position.values.length,p=new Uint8Array(h/3);arrayFill(p,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),t.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:p})}i=BoundingSphere.fromRectangle3D(r,n,o)}return new Geometry({attributes:t.attributes,indices:t.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:i,offsetAttribute:e._offsetAttribute})}};var ReferenceFrame={FIXED:0,INERTIAL:1},ReferenceFrame$1=freezeObject$1(ReferenceFrame),ScreenSpaceEventType={LEFT_DOWN:0,LEFT_UP:1,LEFT_CLICK:2,LEFT_DOUBLE_CLICK:3,RIGHT_DOWN:5,RIGHT_UP:6,RIGHT_CLICK:7,MIDDLE_DOWN:10,MIDDLE_UP:11,MIDDLE_CLICK:12,MOUSE_MOVE:15,WHEEL:16,PINCH_START:17,PINCH_END:18,PINCH_MOVE:19},ScreenSpaceEventType$1=freezeObject$1(ScreenSpaceEventType);function getPosition$1(e,t,i){var r=e._element;if(r===document)return i.x=t.clientX,i.y=t.clientY,i;var n=r.getBoundingClientRect();return i.x=t.clientX-n.left,i.y=t.clientY-n.top,i}function getInputEventKey(e,t){var i=e;return defined(t)&&(i+="+"+t),i}function getModifier(e){return e.shiftKey?KeyboardEventModifier$1.SHIFT:e.ctrlKey?KeyboardEventModifier$1.CTRL:e.altKey?KeyboardEventModifier$1.ALT:void 0}var MouseButton={LEFT:0,MIDDLE:1,RIGHT:2};function registerListener(t,e,i,r){function n(e){r(t,e)}i.addEventListener(e,n,!1),t._removalFunctions.push(function(){i.removeEventListener(e,n,!1)})}function registerListeners(e){var t=e._element,i=defined(t.disableRootEvents)?t:document;FeatureDetection.supportsPointerEvents()?(registerListener(e,"pointerdown",t,handlePointerDown),registerListener(e,"pointerup",t,handlePointerUp),registerListener(e,"pointermove",t,handlePointerMove),registerListener(e,"pointercancel",t,handlePointerUp)):(registerListener(e,"mousedown",t,handleMouseDown),registerListener(e,"mouseup",i,handleMouseUp),registerListener(e,"mousemove",i,handleMouseMove),registerListener(e,"touchstart",t,handleTouchStart),registerListener(e,"touchend",i,handleTouchEnd),registerListener(e,"touchmove",i,handleTouchMove),registerListener(e,"touchcancel",i,handleTouchEnd)),registerListener(e,"dblclick",t,handleDblClick),registerListener(e,"onwheel"in t?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll",t,handleWheel)}function unregisterListeners(e){for(var t=e._removalFunctions,i=0;i<t.length;++i)t[i]()}var mouseDownEvent={position:new Cartesian2};function gotTouchEvent(e){e._lastSeenTouchEvent=getTimestamp$1()}function canProcessMouseEvent(e){return getTimestamp$1()-e._lastSeenTouchEvent>ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds}function checkPixelTolerance(e,t,i){var r=e.x-t.x,n=e.y-t.y;return Math.sqrt(r*r+n*n)<i}function handleMouseDown(e,t){if(canProcessMouseEvent(e)){var i,r=t.button;if(e._buttonDown[r]=!0,r===MouseButton.LEFT)i=ScreenSpaceEventType$1.LEFT_DOWN;else if(r===MouseButton.MIDDLE)i=ScreenSpaceEventType$1.MIDDLE_DOWN;else{if(r!==MouseButton.RIGHT)return;i=ScreenSpaceEventType$1.RIGHT_DOWN}var n=getPosition$1(e,t,e._primaryPosition);Cartesian2.clone(n,e._primaryStartPosition),Cartesian2.clone(n,e._primaryPreviousPosition);var a=getModifier(t),o=e.getInputAction(i,a);defined(o)&&(Cartesian2.clone(n,mouseDownEvent.position),o(mouseDownEvent),t.preventDefault())}}var mouseUpEvent={position:new Cartesian2},mouseClickEvent={position:new Cartesian2};function cancelMouseEvent(e,t,i,r){var n=getModifier(r),a=e.getInputAction(t,n),o=e.getInputAction(i,n);if(defined(a)||defined(o)){var s=getPosition$1(e,r,e._primaryPosition);if(defined(a)&&(Cartesian2.clone(s,mouseUpEvent.position),a(mouseUpEvent)),defined(o))checkPixelTolerance(e._primaryStartPosition,s,e._clickPixelTolerance)&&(Cartesian2.clone(s,mouseClickEvent.position),o(mouseClickEvent))}}function handleMouseUp(e,t){if(canProcessMouseEvent(e)){var i=t.button;i!==MouseButton.LEFT&&i!==MouseButton.MIDDLE&&i!==MouseButton.RIGHT||(e._buttonDown[MouseButton.LEFT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.LEFT_UP,ScreenSpaceEventType$1.LEFT_CLICK,t),e._buttonDown[MouseButton.LEFT]=!1),e._buttonDown[MouseButton.MIDDLE]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.MIDDLE_UP,ScreenSpaceEventType$1.MIDDLE_CLICK,t),e._buttonDown[MouseButton.MIDDLE]=!1),e._buttonDown[MouseButton.RIGHT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.RIGHT_UP,ScreenSpaceEventType$1.RIGHT_CLICK,t),e._buttonDown[MouseButton.RIGHT]=!1))}}var mouseMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2};function handleMouseMove(e,t){if(canProcessMouseEvent(e)){var i=getModifier(t),r=getPosition$1(e,t,e._primaryPosition),n=e._primaryPreviousPosition,a=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,i);defined(a)&&(Cartesian2.clone(n,mouseMoveEvent.startPosition),Cartesian2.clone(r,mouseMoveEvent.endPosition),a(mouseMoveEvent)),Cartesian2.clone(r,n),(e._buttonDown[MouseButton.LEFT]||e._buttonDown[MouseButton.MIDDLE]||e._buttonDown[MouseButton.RIGHT])&&t.preventDefault()}}var mouseDblClickEvent={position:new Cartesian2};function handleDblClick(e,t){var i;if(t.button===MouseButton.LEFT){i=ScreenSpaceEventType$1.LEFT_DOUBLE_CLICK;var r=getModifier(t),n=e.getInputAction(i,r);defined(n)&&(getPosition$1(e,t,mouseDblClickEvent.position),n(mouseDblClickEvent))}}function handleWheel(e,t){var i;if(defined(t.deltaY)){var r=t.deltaMode;i=r===t.DOM_DELTA_PIXEL?-t.deltaY:r===t.DOM_DELTA_LINE?40*-t.deltaY:120*-t.deltaY}else i=0<t.detail?-120*t.detail:t.wheelDelta;if(defined(i)){var n=getModifier(t),a=e.getInputAction(ScreenSpaceEventType$1.WHEEL,n);defined(a)&&(a(i),t.preventDefault())}}function handleTouchStart(e,t){gotTouchEvent(e);var i,r,n,a=t.changedTouches,o=a.length,s=e._positions;for(i=0;i<o;++i)n=(r=a[i]).identifier,s.set(n,getPosition$1(e,r,new Cartesian2));fireTouchEvents(e,t);var l=e._previousPositions;for(i=0;i<o;++i)n=(r=a[i]).identifier,l.set(n,Cartesian2.clone(s.get(n)))}function handleTouchEnd(e,t){gotTouchEvent(e);var i,r,n=t.changedTouches,a=n.length,o=e._positions;for(i=0;i<a;++i)r=n[i].identifier,o.remove(r);fireTouchEvents(e,t);var s=e._previousPositions;for(i=0;i<a;++i)r=n[i].identifier,s.remove(r)}var touchStartEvent={position:new Cartesian2},touch2StartEvent={position1:new Cartesian2,position2:new Cartesian2},touchEndEvent={position:new Cartesian2},touchClickEvent={position:new Cartesian2},touchHoldEvent={position:new Cartesian2};function fireTouchEvents(e,t){var i,r,n=getModifier(t),a=e._positions,o=a.length,s=e._isPinching;if(1!==o&&e._buttonDown[MouseButton.LEFT]){if(e._buttonDown[MouseButton.LEFT]=!1,defined(e._touchHoldTimer)&&(clearTimeout(e._touchHoldTimer),e._touchHoldTimer=void 0),defined(i=e.getInputAction(ScreenSpaceEventType$1.LEFT_UP,n))&&(Cartesian2.clone(e._primaryPosition,touchEndEvent.position),i(touchEndEvent)),0===o&&!e._isTouchHolding)if(defined(r=e.getInputAction(ScreenSpaceEventType$1.LEFT_CLICK,n)))checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._clickPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchClickEvent.position),r(touchClickEvent));e._isTouchHolding=!1}if(0===o&&s&&(e._isPinching=!1,defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_END,n))&&i()),1===o&&!s){var l=a.values[0];Cartesian2.clone(l,e._primaryPosition),Cartesian2.clone(l,e._primaryStartPosition),Cartesian2.clone(l,e._primaryPreviousPosition),e._buttonDown[MouseButton.LEFT]=!0,defined(i=e.getInputAction(ScreenSpaceEventType$1.LEFT_DOWN,n))&&(Cartesian2.clone(l,touchStartEvent.position),i(touchStartEvent)),e._touchHoldTimer=setTimeout(function(){e.isDestroyed()||(e._touchHoldTimer=void 0,e._isTouchHolding=!0,!defined(r=e.getInputAction(ScreenSpaceEventType$1.RIGHT_CLICK,n))||checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._holdPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchHoldEvent.position),r(touchHoldEvent)))},ScreenSpaceEventHandler.touchHoldDelayMilliseconds),t.preventDefault()}2!==o||s||(e._isPinching=!0,defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_START,n))&&(Cartesian2.clone(a.values[0],touch2StartEvent.position1),Cartesian2.clone(a.values[1],touch2StartEvent.position2),i(touch2StartEvent),t.preventDefault()))}function handleTouchMove(e,t){gotTouchEvent(e);var i,r,n,a=t.changedTouches,o=a.length,s=e._positions;for(i=0;i<o;++i){n=(r=a[i]).identifier;var l=s.get(n);defined(l)&&getPosition$1(e,r,l)}fireTouchMoveEvents(e,t);var c=e._previousPositions;for(i=0;i<o;++i)n=(r=a[i]).identifier,Cartesian2.clone(s.get(n),c.get(n))}var touchMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2},touchPinchMovementEvent={distance:{startPosition:new Cartesian2,endPosition:new Cartesian2},angleAndHeight:{startPosition:new Cartesian2,endPosition:new Cartesian2}};function fireTouchMoveEvents(e,t){var i,r=getModifier(t),n=e._positions,a=e._previousPositions,o=n.length;if(1===o&&e._buttonDown[MouseButton.LEFT]){var s=n.values[0];Cartesian2.clone(s,e._primaryPosition);var l=e._primaryPreviousPosition;defined(i=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,r))&&(Cartesian2.clone(l,touchMoveEvent.startPosition),Cartesian2.clone(s,touchMoveEvent.endPosition),i(touchMoveEvent)),Cartesian2.clone(s,l),t.preventDefault()}else if(2===o&&e._isPinching&&defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_MOVE,r))){var c=n.values[0],u=n.values[1],d=a.values[0],h=a.values[1],p=u.x-c.x,m=u.y-c.y,f=.25*Math.sqrt(p*p+m*m),g=h.x-d.x,_=h.y-d.y,y=.25*Math.sqrt(g*g+_*_),v=.125*(u.y+c.y),C=.125*(h.y+d.y),S=Math.atan2(m,p),T=Math.atan2(_,g);Cartesian2.fromElements(0,y,touchPinchMovementEvent.distance.startPosition),Cartesian2.fromElements(0,f,touchPinchMovementEvent.distance.endPosition),Cartesian2.fromElements(T,C,touchPinchMovementEvent.angleAndHeight.startPosition),Cartesian2.fromElements(S,v,touchPinchMovementEvent.angleAndHeight.endPosition),i(touchPinchMovementEvent)}}function handlePointerDown(e,t){if(t.target.setPointerCapture(t.pointerId),"touch"===t.pointerType){var i=e._positions,r=t.pointerId;i.set(r,getPosition$1(e,t,new Cartesian2)),fireTouchEvents(e,t),e._previousPositions.set(r,Cartesian2.clone(i.get(r)))}else handleMouseDown(e,t)}function handlePointerUp(e,t){if("touch"===t.pointerType){var i=e._positions,r=t.pointerId;i.remove(r),fireTouchEvents(e,t),e._previousPositions.remove(r)}else handleMouseUp(e,t)}function handlePointerMove(e,t){if("touch"===t.pointerType){var i=e._positions,r=t.pointerId,n=i.get(r);if(!defined(n))return;getPosition$1(e,t,n),fireTouchMoveEvents(e,t);var a=e._previousPositions;Cartesian2.clone(i.get(r),a.get(r))}else handleMouseMove(e,t)}function ScreenSpaceEventHandler(e){this._inputEvents={},this._buttonDown={LEFT:!1,MIDDLE:!1,RIGHT:!1},this._isPinching=!1,this._isTouchHolding=!1,this._lastSeenTouchEvent=-ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds,this._primaryStartPosition=new Cartesian2,this._primaryPosition=new Cartesian2,this._primaryPreviousPosition=new Cartesian2,this._positions=new AssociativeArray,this._previousPositions=new AssociativeArray,this._removalFunctions=[],this._touchHoldTimer=void 0,this._clickPixelTolerance=5,this._holdPixelTolerance=25,this._element=defaultValue(e,document),registerListeners(this)}function ShowGeometryInstanceAttribute(e){e=defaultValue(e,!0),this.value=ShowGeometryInstanceAttribute.toValue(e)}ScreenSpaceEventHandler.prototype.setInputAction=function(e,t,i){var r=getInputEventKey(t,i);this._inputEvents[r]=e},ScreenSpaceEventHandler.prototype.getInputAction=function(e,t){var i=getInputEventKey(e,t);return this._inputEvents[i]},ScreenSpaceEventHandler.prototype.removeInputAction=function(e,t){var i=getInputEventKey(e,t);delete this._inputEvents[i]},ScreenSpaceEventHandler.prototype.isDestroyed=function(){return!1},ScreenSpaceEventHandler.prototype.destroy=function(){return unregisterListeners(this),destroyObject(this)},ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds=800,ScreenSpaceEventHandler.touchHoldDelayMilliseconds=1500,defineProperties$1(ShowGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!1}}}),ShowGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e,t):new Uint8Array([e])};var Simon1994PlanetaryPositions={};function computeTdbMinusTtSpice(e){var t=6.239996+.0172019696544*e;return.001657*Math.sin(t+.01671*Math.sin(t))}var TdtMinusTai$1=32.184,J2000d$1=2451545;function taiToTdb(e,t){t=JulianDate.addSeconds(e,TdtMinusTai$1,t);var i=JulianDate.totalDays(t)-J2000d$1;return t=JulianDate.addSeconds(t,computeTdbMinusTtSpice(i),t)}var epoch=new JulianDate(2451545,0,TimeStandard$1.TAI),MetersPerKilometer=1e3,RadiansPerDegree=CesiumMath.RADIANS_PER_DEGREE,RadiansPerArcSecond=CesiumMath.RADIANS_PER_ARCSECOND,MetersPerAstronomicalUnit=14959787e4,perifocalToEquatorial=new Matrix3;function elementsToCartesian(e,t,i,r,n,a,o){i<0&&(i=-i,n+=CesiumMath.PI);var s=e*(1-t),l=r-n,c=n,u=meanAnomalyToTrueAnomaly(a-r,t);perifocalToCartesianMatrix(l,i,c,perifocalToEquatorial);var d=s*(1+t),h=Math.cos(u),p=Math.sin(u),m=d/(1+t*h);return defined(o)?(o.x=m*h,o.y=m*p,o.z=0):o=new Cartesian3(m*h,m*p,0),Matrix3.multiplyByVector(perifocalToEquatorial,o,o)}function meanAnomalyToTrueAnomaly(e,t){return eccentricAnomalyToTrueAnomaly(meanAnomalyToEccentricAnomaly(e,t),t)}var maxIterationCount=50,keplerEqConvergence=CesiumMath.EPSILON8;function meanAnomalyToEccentricAnomaly(e,t){var i,r=Math.floor(e/CesiumMath.TWO_PI),n=(e-=r*CesiumMath.TWO_PI)+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),a=Number.MAX_VALUE;for(i=0;i<maxIterationCount&&Math.abs(a-n)>keplerEqConvergence;++i){n=(a=n)-(a-t*Math.sin(a)-e)/(1-t*Math.cos(a))}return a=n+r*CesiumMath.TWO_PI}function eccentricAnomalyToTrueAnomaly(e,t){var i=Math.floor(e/CesiumMath.TWO_PI);e-=i*CesiumMath.TWO_PI;var r=Math.cos(e)-t,n=Math.sin(e)*Math.sqrt(1-t*t),a=Math.atan2(n,r);return a=CesiumMath.zeroToTwoPi(a),e<0&&(a-=CesiumMath.TWO_PI),a+=i*CesiumMath.TWO_PI}function perifocalToCartesianMatrix(e,t,i,r){var n=Math.cos(e),a=Math.sin(e),o=Math.cos(t),s=Math.sin(t),l=Math.cos(i),c=Math.sin(i);return defined(r)?(r[0]=l*n-c*a*o,r[1]=c*n+l*a*o,r[2]=a*s,r[3]=-l*a-c*n*o,r[4]=-c*a+l*n*o,r[5]=n*s,r[6]=c*s,r[7]=-l*s,r[8]=o):r=new Matrix3(l*n-c*a*o,-l*a-c*n*o,c*s,c*n+l*a*o,-c*a+l*n*o,-l*s,a*s,n*s,o),r}var semiMajorAxis0=1.0000010178*MetersPerAstronomicalUnit,meanLongitude0=100.46645683*RadiansPerDegree,meanLongitude1=1295977422.83429*RadiansPerArcSecond,p1u=16002,p2u=21863,p3u=32004,p4u=10931,p5u=14529,p6u=16368,p7u=15318,p8u=32794,Ca1=64e-7*MetersPerAstronomicalUnit,Ca2=-152e-7*MetersPerAstronomicalUnit,Ca3=62e-7*MetersPerAstronomicalUnit,Ca4=-8e-7*MetersPerAstronomicalUnit,Ca5=32e-7*MetersPerAstronomicalUnit,Ca6=-41e-7*MetersPerAstronomicalUnit,Ca7=19e-7*MetersPerAstronomicalUnit,Ca8=-11e-7*MetersPerAstronomicalUnit,Sa1=1e-7*-150*MetersPerAstronomicalUnit,Sa2=-46e-7*MetersPerAstronomicalUnit,Sa3=68*1e-7*MetersPerAstronomicalUnit,Sa4=54e-7*MetersPerAstronomicalUnit,Sa5=14e-7*MetersPerAstronomicalUnit,Sa6=24e-7*MetersPerAstronomicalUnit,Sa7=-28e-7*MetersPerAstronomicalUnit,Sa8=22e-7*MetersPerAstronomicalUnit,q1u=10,q2u=16002,q3u=21863,q4u=10931,q5u=1473,q6u=32004,q7u=4387,q8u=73,Cl1=-325e-7,Cl2=-322e-7,Cl3=1e-7*-79,Cl4=232*1e-7,Cl5=1e-7*-52,Cl6=97e-7,Cl7=55e-7,Cl8=-41e-7,Sl1=-105e-7,Sl2=-137e-7,Sl3=258e-7,Sl4=35e-7,Sl5=1e-7*-116,Sl6=-88e-7,Sl7=-112e-7,Sl8=-8e-6,scratchDate=new JulianDate(0,0,TimeStandard$1.TAI);function computeSimonEarthMoonBarycenter(e,t){taiToTdb(e,scratchDate);var i=(scratchDate.dayNumber-epoch.dayNumber+(scratchDate.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/(10*TimeConstants$1.DAYS_PER_JULIAN_CENTURY),r=.3595362*i,n=semiMajorAxis0+Ca1*Math.cos(p1u*r)+Sa1*Math.sin(p1u*r)+Ca2*Math.cos(p2u*r)+Sa2*Math.sin(p2u*r)+Ca3*Math.cos(p3u*r)+Sa3*Math.sin(p3u*r)+Ca4*Math.cos(p4u*r)+Sa4*Math.sin(p4u*r)+Ca5*Math.cos(p5u*r)+Sa5*Math.sin(p5u*r)+Ca6*Math.cos(p6u*r)+Sa6*Math.sin(p6u*r)+Ca7*Math.cos(p7u*r)+Sa7*Math.sin(p7u*r)+Ca8*Math.cos(p8u*r)+Sa8*Math.sin(p8u*r),a=meanLongitude0+meanLongitude1*i+Cl1*Math.cos(q1u*r)+Sl1*Math.sin(q1u*r)+Cl2*Math.cos(q2u*r)+Sl2*Math.sin(q2u*r)+Cl3*Math.cos(q3u*r)+Sl3*Math.sin(q3u*r)+Cl4*Math.cos(q4u*r)+Sl4*Math.sin(q4u*r)+Cl5*Math.cos(q5u*r)+Sl5*Math.sin(q5u*r)+Cl6*Math.cos(q6u*r)+Sl6*Math.sin(q6u*r)+Cl7*Math.cos(q7u*r)+Sl7*Math.sin(q7u*r)+Cl8*Math.cos(q8u*r)+Sl8*Math.sin(q8u*r);return elementsToCartesian(n,.0167086342-.0004203654*i,469.97289*RadiansPerArcSecond*i,102.93734808*RadiansPerDegree+11612.3529*RadiansPerArcSecond*i,174.87317577*RadiansPerDegree-8679.27034*RadiansPerArcSecond*i,a,t)}function computeSimonMoon(e,t){taiToTdb(e,scratchDate);var i=(scratchDate.dayNumber-epoch.dayNumber+(scratchDate.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,r=i*i,n=r*i,a=n*i,o=383397.7725+.004*i,s=.055545526-16e-9*i,l=5.15668983*RadiansPerDegree,c=-8e-5*i+.02966*r-42e-6*n-13e-8*a,u=83.35324312*RadiansPerDegree,d=14643420.2669*i-38.2702*r-.045047*n+21301e-8*a,h=125.04455501*RadiansPerDegree,p=-6967919.3631*i+6.3602*r+.007625*n-3586e-8*a,m=218.31664563*RadiansPerDegree,f=1732559343.4847*i-6.391*r+.006588*n-3169e-8*a,g=297.85019547*RadiansPerDegree+RadiansPerArcSecond*(1602961601.209*i-6.3706*r+.006593*n-3169e-8*a),_=134.96340251*RadiansPerDegree+RadiansPerArcSecond*(1717915923.2178*i+31.8792*r+.051635*n-2447e-7*a),y=357.52910918*RadiansPerDegree+RadiansPerArcSecond*(129596581.0481*i-.5532*r+136e-6*n-1149e-8*a),v=310.17137918*RadiansPerDegree-RadiansPerArcSecond*(6967051.436*i+6.2068*r+.007618*n-3219e-8*a),C=2*g,S=4*g,T=6*g,x=2*_,b=3*_,E=4*_,P=2*(93.27209062*RadiansPerDegree+RadiansPerArcSecond*(1739527262.8478*i-12.7512*r-.001037*n+417e-8*a));o+=3400.4*Math.cos(C)-635.6*Math.cos(C-_)-235.6*Math.cos(_)+218.1*Math.cos(C-y)+181*Math.cos(C+_),s+=.014216*Math.cos(C-_)+.008551*Math.cos(C-x)-.001383*Math.cos(_)+.001356*Math.cos(C+_)-.001147*Math.cos(S-b)-914e-6*Math.cos(S-x)+869e-6*Math.cos(C-y-_)-627e-6*Math.cos(C)-394e-6*Math.cos(S-E)+282e-6*Math.cos(C-y-x)-279e-6*Math.cos(g-_)-236e-6*Math.cos(x)+231e-6*Math.cos(S)+229e-6*Math.cos(T-E)-201e-6*Math.cos(x-P),c+=486.26*Math.cos(C-P)-40.13*Math.cos(C)+37.51*Math.cos(P)+25.73*Math.cos(x-P)+19.97*Math.cos(C-y-P),d+=-55609*Math.sin(C-_)-34711*Math.sin(C-x)-9792*Math.sin(_)+9385*Math.sin(S-b)+7505*Math.sin(S-x)+5318*Math.sin(C+_)+3484*Math.sin(S-E)-3417*Math.sin(C-y-_)-2530*Math.sin(T-E)-2376*Math.sin(C)-2075*Math.sin(C-b)-1883*Math.sin(x)-1736*Math.sin(T-5*_)+1626*Math.sin(y)-1370*Math.sin(T-b),p+=-5392*Math.sin(C-P)-540*Math.sin(y)-441*Math.sin(C)+423*Math.sin(P)-288*Math.sin(x-P),f+=-3332.9*Math.sin(C)+1197.4*Math.sin(C-_)-662.5*Math.sin(y)+396.3*Math.sin(_)-218*Math.sin(C-y);var A=2*v,w=3*v;c+=46.997*Math.cos(v)*i-.614*Math.cos(C-P+v)*i+.614*Math.cos(C-P-v)*i-.0297*Math.cos(A)*r-.0335*Math.cos(v)*r+.0012*Math.cos(C-P+A)*r-16e-5*Math.cos(v)*n+4e-5*Math.cos(w)*n+4e-5*Math.cos(A)*n;var D=2.116*Math.sin(v)*i-.111*Math.sin(C-P-v)*i-.0015*Math.sin(v)*r;return d+=D,f+=D,p+=-520.77*Math.sin(v)*i+13.66*Math.sin(C-P+v)*i+1.12*Math.sin(C-v)*i-1.06*Math.sin(P-v)*i+.66*Math.sin(A)*r+.371*Math.sin(v)*r-.035*Math.sin(C-P+A)*r-.015*Math.sin(C-P+v)*r+.0014*Math.sin(v)*n-.0011*Math.sin(w)*n-9e-4*Math.sin(A)*n,elementsToCartesian(o*=MetersPerKilometer,s,l+c*RadiansPerArcSecond,u+d*RadiansPerArcSecond,h+p*RadiansPerArcSecond,m+f*RadiansPerArcSecond,t)}var moonEarthMassRatio=.012300034,factor=moonEarthMassRatio/(moonEarthMassRatio+1)*-1;function computeSimonEarth(e,t){return t=computeSimonMoon(e,t),Cartesian3.multiplyByScalar(t,factor,t)}var axesTransformation=new Matrix3(1.0000000000000002,5619723173785822e-31,4690511510146299e-34,-5154129427414611e-31,.9174820620691819,-.39777715593191376,-223970096136568e-30,.39777715593191376,.9174820620691819),translation$1=new Cartesian3;function interpolateColors$1(e,t,i,r,n,a,o){var s,l=PolylinePipeline.numberOfPoints(e,t,n),c=i.red,u=i.green,d=i.blue,h=i.alpha,p=r.red,m=r.green,f=r.blue,g=r.alpha;if(Color.equals(i,r)){for(s=0;s<l;s++)a[o++]=Color.floatToByte(c),a[o++]=Color.floatToByte(u),a[o++]=Color.floatToByte(d),a[o++]=Color.floatToByte(h);return o}var _=(p-c)/l,y=(m-u)/l,v=(f-d)/l,C=(g-h)/l,S=o;for(s=0;s<l;s++)a[S++]=Color.floatToByte(c+s*_),a[S++]=Color.floatToByte(u+s*y),a[S++]=Color.floatToByte(d+s*v),a[S++]=Color.floatToByte(h+s*C);return S}function SimplePolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.colors,r=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=i,this._colorsPerVertex=r,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._workerName="createSimplePolylineGeometry";var n=1+t.length*Cartesian3.packedLength;n+=defined(i)?1+i.length*Color.packedLength:1,this.packedLength=n+Ellipsoid.packedLength+3}Simon1994PlanetaryPositions.computeSunPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),defined(t)||(t=new Cartesian3),translation$1=computeSimonEarthMoonBarycenter(e,translation$1),t=Cartesian3.negate(translation$1,t),computeSimonEarth(e,translation$1),Cartesian3.subtract(t,translation$1,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},Simon1994PlanetaryPositions.computeMoonPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),t=computeSimonMoon(e,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},SimplePolylineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._colors;for(a=defined(o)?o.length:0,t[i++]=a,r=0;r<a;++r,i+=Color.packedLength)Color.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._colorsPerVertex?1:0,t[i++]=e._arcType,t[i]=e._granularity,t},SimplePolylineGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n=e[t++],a=new Array(n);for(r=0;r<n;++r,t+=Cartesian3.packedLength)a[r]=Cartesian3.unpack(e,t);var o=0<(n=e[t++])?new Array(n):void 0;for(r=0;r<n;++r,t+=Color.packedLength)o[r]=Color.unpack(e,t);var s=Ellipsoid.unpack(e,t);t+=Ellipsoid.packedLength;var l=1===e[t++],c=e[t++],u=e[t];return defined(i)?(i._positions=a,i._colors=o,i._ellipsoid=s,i._colorsPerVertex=l,i._arcType=c,i._granularity=u,i):new SimplePolylineGeometry({positions:a,colors:o,ellipsoid:s,colorsPerVertex:l,arcType:c,granularity:u})};var scratchArray1=new Array(2),scratchArray2=new Array(2),generateArcOptionsScratch={positions:scratchArray1,height:scratchArray2,ellipsoid:void 0,minDistance:void 0,granularity:void 0};function SphereGeometry(e){var t=defaultValue(e.radius,1),i={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,vertexFormat:e.vertexFormat};this._ellipsoidGeometry=new EllipsoidGeometry(i),this._workerName="createSphereGeometry"}SimplePolylineGeometry.createGeometry=function(e){var t,i,r,n,a,o=e._positions,s=e._colors,l=e._colorsPerVertex,c=e._arcType,u=e._granularity,d=e._ellipsoid,h=CesiumMath.chordLength(u,d.maximumRadius),p=defined(s)&&!l,m=o.length,f=0;if(c===ArcType$1.GEODESIC||c===ArcType$1.RHUMB){var g,_,y;y=c===ArcType$1.GEODESIC?(g=CesiumMath.chordLength(u,d.maximumRadius),_=PolylinePipeline.numberOfPoints,PolylinePipeline.generateArc):(g=u,_=PolylinePipeline.numberOfPointsRhumbLine,PolylinePipeline.generateRhumbArc);var v=PolylinePipeline.extractHeights(o,d),C=generateArcOptionsScratch;if(c===ArcType$1.GEODESIC?C.minDistance=h:C.granularity=u,C.ellipsoid=d,p){var S=0;for(t=0;t<m-1;t++)S+=_(o[t],o[t+1],g)+1;i=new Float64Array(3*S),n=new Uint8Array(4*S),C.positions=scratchArray1,C.height=scratchArray2;var T=0;for(t=0;t<m-1;++t){scratchArray1[0]=o[t],scratchArray1[1]=o[t+1],scratchArray2[0]=v[t],scratchArray2[1]=v[t+1];var x=y(C);if(defined(s)){var b=x.length/3;a=s[t];for(var E=0;E<b;++E)n[T++]=Color.floatToByte(a.red),n[T++]=Color.floatToByte(a.green),n[T++]=Color.floatToByte(a.blue),n[T++]=Color.floatToByte(a.alpha)}i.set(x,f),f+=x.length}}else if(C.positions=o,C.height=v,i=new Float64Array(y(C)),defined(s)){for(n=new Uint8Array(i.length/3*4),t=0;t<m-1;++t){f=interpolateColors$1(o[t],o[t+1],s[t],s[t+1],h,n,f)}var P=s[m-1];n[f++]=Color.floatToByte(P.red),n[f++]=Color.floatToByte(P.green),n[f++]=Color.floatToByte(P.blue),n[f++]=Color.floatToByte(P.alpha)}}else{r=p?2*m-2:m,i=new Float64Array(3*r),n=defined(s)?new Uint8Array(4*r):void 0;var A=0,w=0;for(t=0;t<m;++t){var D=o[t];if(p&&0<t&&(Cartesian3.pack(D,i,A),A+=3,a=s[t-1],n[w++]=Color.floatToByte(a.red),n[w++]=Color.floatToByte(a.green),n[w++]=Color.floatToByte(a.blue),n[w++]=Color.floatToByte(a.alpha)),p&&t===m-1)break;Cartesian3.pack(D,i,A),A+=3,defined(s)&&(a=s[t],n[w++]=Color.floatToByte(a.red),n[w++]=Color.floatToByte(a.green),n[w++]=Color.floatToByte(a.blue),n[w++]=Color.floatToByte(a.alpha))}}var M=new GeometryAttributes;M.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i}),defined(s)&&(M.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:n,normalize:!0}));var I=2*((r=i.length/3)-1),R=IndexDatatype$1.createTypedArray(r,I),O=0;for(t=0;t<r-1;++t)R[O++]=t,R[O++]=t+1;return new Geometry({attributes:M,indices:R,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromPoints(o)})},SphereGeometry.packedLength=EllipsoidGeometry.packedLength,SphereGeometry.pack=function(e,t,i){return EllipsoidGeometry.pack(e._ellipsoidGeometry,t,i)};var scratchEllipsoidGeometry=new EllipsoidGeometry,scratchOptions$k={radius:void 0,radii:new Cartesian3,vertexFormat:new VertexFormat,stackPartitions:void 0,slicePartitions:void 0};function SphereOutlineGeometry(e){var t=defaultValue(e.radius,1),i={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,subdivisions:e.subdivisions};this._ellipsoidGeometry=new EllipsoidOutlineGeometry(i),this._workerName="createSphereOutlineGeometry"}SphereGeometry.unpack=function(e,t,i){var r=EllipsoidGeometry.unpack(e,t,scratchEllipsoidGeometry);return scratchOptions$k.vertexFormat=VertexFormat.clone(r._vertexFormat,scratchOptions$k.vertexFormat),scratchOptions$k.stackPartitions=r._stackPartitions,scratchOptions$k.slicePartitions=r._slicePartitions,defined(i)?(Cartesian3.clone(r._radii,scratchOptions$k.radii),i._ellipsoidGeometry=new EllipsoidGeometry(scratchOptions$k),i):(scratchOptions$k.radius=r._radii.x,new SphereGeometry(scratchOptions$k))},SphereGeometry.createGeometry=function(e){return EllipsoidGeometry.createGeometry(e._ellipsoidGeometry)},SphereOutlineGeometry.packedLength=EllipsoidOutlineGeometry.packedLength,SphereOutlineGeometry.pack=function(e,t,i){return EllipsoidOutlineGeometry.pack(e._ellipsoidGeometry,t,i)};var scratchEllipsoidGeometry$1=new EllipsoidOutlineGeometry,scratchOptions$l={radius:void 0,radii:new Cartesian3,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};function Spherical(e,t,i){this.clock=defaultValue(e,0),this.cone=defaultValue(t,0),this.magnitude=defaultValue(i,1)}function TerrainData(){DeveloperError.throwInstantiationError()}SphereOutlineGeometry.unpack=function(e,t,i){var r=EllipsoidOutlineGeometry.unpack(e,t,scratchEllipsoidGeometry$1);return scratchOptions$l.stackPartitions=r._stackPartitions,scratchOptions$l.slicePartitions=r._slicePartitions,scratchOptions$l.subdivisions=r._subdivisions,defined(i)?(Cartesian3.clone(r._radii,scratchOptions$l.radii),i._ellipsoidGeometry=new EllipsoidOutlineGeometry(scratchOptions$l),i):(scratchOptions$l.radius=r._radii.x,new SphereOutlineGeometry(scratchOptions$l))},SphereOutlineGeometry.createGeometry=function(e){return EllipsoidOutlineGeometry.createGeometry(e._ellipsoidGeometry)},Spherical.fromCartesian3=function(e,t){var i=e.x,r=e.y,n=e.z,a=i*i+r*r;return defined(t)||(t=new Spherical),t.clock=Math.atan2(r,i),t.cone=Math.atan2(Math.sqrt(a),n),t.magnitude=Math.sqrt(a+n*n),t},Spherical.clone=function(e,t){if(defined(e))return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=e.magnitude,t):new Spherical(e.clock,e.cone,e.magnitude)},Spherical.normalize=function(e,t){return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=1,t):new Spherical(e.clock,e.cone,1)},Spherical.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.clock===t.clock&&e.cone===t.cone&&e.magnitude===t.magnitude},Spherical.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.clock-t.clock)<=i&&Math.abs(e.cone-t.cone)<=i&&Math.abs(e.magnitude-t.magnitude)<=i},Spherical.prototype.equals=function(e){return Spherical.equals(this,e)},Spherical.prototype.clone=function(e){return Spherical.clone(this,e)},Spherical.prototype.equalsEpsilon=function(e,t){return Spherical.equalsEpsilon(this,e,t)},Spherical.prototype.toString=function(){return"("+this.clock+", "+this.cone+", "+this.magnitude+")"},defineProperties$1(TerrainData.prototype,{credits:{get:DeveloperError.throwInstantiationError},waterMask:{get:DeveloperError.throwInstantiationError}}),TerrainData.prototype.interpolateHeight=DeveloperError.throwInstantiationError,TerrainData.prototype.isChildAvailable=DeveloperError.throwInstantiationError,TerrainData.prototype.createMesh=DeveloperError.throwInstantiationError,TerrainData.prototype.upsample=DeveloperError.throwInstantiationError,TerrainData.prototype.wasCreatedByUpsampling=DeveloperError.throwInstantiationError;var TileEdge={WEST:0,NORTH:1,EAST:2,SOUTH:3,NORTHWEST:4,NORTHEAST:5,SOUTHWEST:6,SOUTHEAST:7};function TilingScheme(e){}function compareIntervalStartTimes(e,t){return JulianDate.compare(e.start,t.start)}function TimeIntervalCollection(e){if(this._intervals=[],this._changedEvent=new Event,defined(e))for(var t=e.length,i=0;i<t;i++)this.addInterval(e[i])}defineProperties$1(TilingScheme.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError},rectangle:{get:DeveloperError.throwInstantiationError},projection:{get:DeveloperError.throwInstantiationError}}),TilingScheme.prototype.getNumberOfXTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.getNumberOfYTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.rectangleToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.positionToTileXY=DeveloperError.throwInstantiationError,defineProperties$1(TimeIntervalCollection.prototype,{changedEvent:{get:function(){return this._changedEvent}},start:{get:function(){var e=this._intervals;return 0===e.length?void 0:e[0].start}},isStartIncluded:{get:function(){var e=this._intervals;return 0!==e.length&&e[0].isStartIncluded}},stop:{get:function(){var e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop}},isStopIncluded:{get:function(){var e=this._intervals,t=e.length;return 0!==t&&e[t-1].isStopIncluded}},length:{get:function(){return this._intervals.length}},isEmpty:{get:function(){return 0===this._intervals.length}}}),TimeIntervalCollection.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof TimeIntervalCollection))return!1;var i=this._intervals,r=e._intervals,n=i.length;if(n!==r.length)return!1;for(var a=0;a<n;a++)if(!TimeInterval.equals(i[a],r[a],t))return!1;return!0},TimeIntervalCollection.prototype.get=function(e){return this._intervals[e]},TimeIntervalCollection.prototype.removeAll=function(){0<this._intervals.length&&(this._intervals.length=0,this._changedEvent.raiseEvent(this))},TimeIntervalCollection.prototype.findIntervalContainingDate=function(e){var t=this.indexOf(e);return 0<=t?this._intervals[t]:void 0},TimeIntervalCollection.prototype.findDataForIntervalContainingDate=function(e){var t=this.indexOf(e);return 0<=t?this._intervals[t].data:void 0},TimeIntervalCollection.prototype.contains=function(e){return 0<=this.indexOf(e)};var indexOfScratch=new TimeInterval;TimeIntervalCollection.prototype.indexOf=function(e){var t=this._intervals;indexOfScratch.start=e,indexOfScratch.stop=e;var i=binarySearch(t,indexOfScratch,compareIntervalStartTimes);return 0<=i?t[i].isStartIncluded?i:0<i&&t[i-1].stop.equals(e)&&t[i-1].isStopIncluded?i-1:~i:0<(i=~i)&&i-1<t.length&&TimeInterval.contains(t[i-1],e)?i-1:~i},TimeIntervalCollection.prototype.findInterval=function(e){for(var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).start,i=e.stop,r=e.isStartIncluded,n=e.isStopIncluded,a=this._intervals,o=0,s=a.length;o<s;o++){var l=a[o];if((!defined(t)||l.start.equals(t))&&(!defined(i)||l.stop.equals(i))&&(!defined(r)||l.isStartIncluded===r)&&(!defined(n)||l.isStopIncluded===n))return a[o]}},TimeIntervalCollection.prototype.addInterval=function(e,t){if(!e.isEmpty){var i=this._intervals;if(0===i.length||JulianDate.greaterThan(e.start,i[i.length-1].stop))return i.push(e),void this._changedEvent.raiseEvent(this);var r,n=binarySearch(i,e,compareIntervalStartTimes);for(n<0?n=~n:0<n&&e.isStartIncluded&&i[n-1].isStartIncluded&&i[n-1].start.equals(e.start)?--n:n<i.length&&!e.isStartIncluded&&i[n].isStartIncluded&&i[n].start.equals(e.start)&&++n,0<n&&(0<(r=JulianDate.compare(i[n-1].stop,e.start))||0===r&&(i[n-1].isStopIncluded||e.isStartIncluded))&&((defined(t)?t(i[n-1].data,e.data):i[n-1].data===e.data)?(e=JulianDate.greaterThan(e.stop,i[n-1].stop)?new TimeInterval({start:i[n-1].start,stop:e.stop,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:e.isStopIncluded,data:e.data}):new TimeInterval({start:i[n-1].start,stop:i[n-1].stop,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:i[n-1].isStopIncluded||e.stop.equals(i[n-1].stop)&&e.isStopIncluded,data:e.data}),i.splice(n-1,1),--n):((0<(r=JulianDate.compare(i[n-1].stop,e.stop))||0===r&&i[n-1].isStopIncluded&&!e.isStopIncluded)&&i.splice(n,0,new TimeInterval({start:e.stop,stop:i[n-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:i[n-1].isStopIncluded,data:i[n-1].data})),i[n-1]=new TimeInterval({start:i[n-1].start,stop:e.start,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:i[n-1].data})));n<i.length&&(0<(r=JulianDate.compare(e.stop,i[n].start))||0===r&&(e.isStopIncluded||i[n].isStartIncluded));)if(defined(t)?t(i[n].data,e.data):i[n].data===e.data)e=new TimeInterval({start:e.start,stop:JulianDate.greaterThan(i[n].stop,e.stop)?i[n].stop:e.stop,isStartIncluded:e.isStartIncluded,isStopIncluded:JulianDate.greaterThan(i[n].stop,e.stop)?i[n].isStopIncluded:e.isStopIncluded,data:e.data}),i.splice(n,1);else{if(i[n]=new TimeInterval({start:e.stop,stop:i[n].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:i[n].isStopIncluded,data:i[n].data}),!i[n].isEmpty)break;i.splice(n,1)}i.splice(n,0,e),this._changedEvent.raiseEvent(this)}},TimeIntervalCollection.prototype.removeInterval=function(e){if(e.isEmpty)return!1;var t=this._intervals,i=binarySearch(t,e,compareIntervalStartTimes);i<0&&(i=~i);var r=!1;for(0<i&&(JulianDate.greaterThan(t[i-1].stop,e.start)||t[i-1].stop.equals(e.start)&&t[i-1].isStopIncluded&&e.isStartIncluded)&&(r=!0,(JulianDate.greaterThan(t[i-1].stop,e.stop)||t[i-1].isStopIncluded&&!e.isStopIncluded&&t[i-1].stop.equals(e.stop))&&t.splice(i,0,new TimeInterval({start:e.stop,stop:t[i-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[i-1].isStopIncluded,data:t[i-1].data})),t[i-1]=new TimeInterval({start:t[i-1].start,stop:e.start,isStartIncluded:t[i-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:t[i-1].data})),i<t.length&&!e.isStartIncluded&&t[i].isStartIncluded&&e.start.equals(t[i].start)&&(r=!0,t.splice(i,0,new TimeInterval({start:t[i].start,stop:t[i].start,isStartIncluded:!0,isStopIncluded:!0,data:t[i].data})),++i);i<t.length&&JulianDate.greaterThan(e.stop,t[i].stop);)r=!0,t.splice(i,1);return i<t.length&&e.stop.equals(t[i].stop)&&(r=!0,!e.isStopIncluded&&t[i].isStopIncluded?i+1<t.length&&t[i+1].start.equals(e.stop)&&t[i].data===t[i+1].data?(t.splice(i,1),t[i]=new TimeInterval({start:t[i].start,stop:t[i].stop,isStartIncluded:!0,isStopIncluded:t[i].isStopIncluded,data:t[i].data})):t[i]=new TimeInterval({start:e.stop,stop:e.stop,isStartIncluded:!0,isStopIncluded:!0,data:t[i].data}):t.splice(i,1)),i<t.length&&(JulianDate.greaterThan(e.stop,t[i].start)||e.stop.equals(t[i].start)&&e.isStopIncluded&&t[i].isStartIncluded)&&(r=!0,t[i]=new TimeInterval({start:e.stop,stop:t[i].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[i].isStopIncluded,data:t[i].data})),r&&this._changedEvent.raiseEvent(this),r},TimeIntervalCollection.prototype.intersect=function(e,t,i){for(var r=new TimeIntervalCollection,n=0,a=0,o=this._intervals,s=e._intervals;n<o.length&&a<s.length;){var l=o[n],c=s[a];if(JulianDate.lessThan(l.stop,c.start))++n;else if(JulianDate.lessThan(c.stop,l.start))++a;else{if(defined(i)||defined(t)&&t(l.data,c.data)||!defined(t)&&c.data===l.data){var u=TimeInterval.intersect(l,c,new TimeInterval,i);u.isEmpty||r.addInterval(u,t)}JulianDate.lessThan(l.stop,c.stop)||l.stop.equals(c.stop)&&!l.isStopIncluded&&c.isStopIncluded?++n:++a}}return r},TimeIntervalCollection.fromJulianDateArray=function(e,t){defined(t)||(t=new TimeIntervalCollection);var i,r=e.julianDates,n=r.length,a=e.dataCallback,o=defaultValue(e.isStartIncluded,!0),s=defaultValue(e.isStopIncluded,!0),l=defaultValue(e.leadingInterval,!1),c=defaultValue(e.trailingInterval,!1),u=0;l&&(++u,(i=new TimeInterval({start:Iso8601.MINIMUM_VALUE,stop:r[0],isStartIncluded:!0,isStopIncluded:!o})).data=defined(a)?a(i,t.length):t.length,t.addInterval(i));for(var d=0;d<n-1;++d){var h=r[d],p=r[d+1];(i=new TimeInterval({start:h,stop:p,isStartIncluded:t.length!==u||o,isStopIncluded:d===n-2&&s})).data=defined(a)?a(i,t.length):t.length,t.addInterval(i),h=p}return c&&((i=new TimeInterval({start:r[n-1],stop:Iso8601.MAXIMUM_VALUE,isStartIncluded:!s,isStopIncluded:!0})).data=defined(a)?a(i,t.length):t.length,t.addInterval(i)),t};var scratchGregorianDate=new GregorianDate,monthLengths=[0,31,28,31,30,31,30,31,31,30,31,30,31];function addToDate(e,t,i){defined(i)||(i=new JulianDate),JulianDate.toGregorianDate(e,scratchGregorianDate);var r=scratchGregorianDate.millisecond+t.millisecond,n=scratchGregorianDate.second+t.second,a=scratchGregorianDate.minute+t.minute,o=scratchGregorianDate.hour+t.hour,s=scratchGregorianDate.day+t.day,l=scratchGregorianDate.month+t.month,c=scratchGregorianDate.year+t.year;for(1e3<=r&&(n+=Math.floor(r/1e3),r%=1e3),60<=n&&(a+=Math.floor(n/60),n%=60),60<=a&&(o+=Math.floor(a/60),a%=60),24<=o&&(s+=Math.floor(o/24),o%=24),monthLengths[2]=isLeapYear(c)?29:28;s>monthLengths[l]||13<=l;)s>monthLengths[l]&&(s-=monthLengths[l],++l),13<=l&&(--l,c+=Math.floor(l/12),l%=12,++l),monthLengths[2]=isLeapYear(c)?29:28;return scratchGregorianDate.millisecond=r,scratchGregorianDate.second=n,scratchGregorianDate.minute=a,scratchGregorianDate.hour=o,scratchGregorianDate.day=s,scratchGregorianDate.month=l,scratchGregorianDate.year=c,JulianDate.fromGregorianDate(scratchGregorianDate,i)}var scratchJulianDate=new JulianDate,durationRegex=/P(?:([\d.,]+)Y)?(?:([\d.,]+)M)?(?:([\d.,]+)W)?(?:([\d.,]+)D)?(?:T(?:([\d.,]+)H)?(?:([\d.,]+)M)?(?:([\d.,]+)S)?)?/;function parseDuration(e,t){if(!defined(e)||0===e.length)return!1;if(t.year=0,t.month=0,t.day=0,t.hour=0,t.minute=0,t.second=0,"P"===e[t.millisecond=0]){var i=e.match(durationRegex);if(!defined(i))return!1;if(defined(i[1])&&(t.year=Number(i[1].replace(",","."))),defined(i[2])&&(t.month=Number(i[2].replace(",","."))),defined(i[3])&&(t.day=7*Number(i[3].replace(",","."))),defined(i[4])&&(t.day+=Number(i[4].replace(",","."))),defined(i[5])&&(t.hour=Number(i[5].replace(",","."))),defined(i[6])&&(t.minute=Number(i[6].replace(",","."))),defined(i[7])){var r=Number(i[7].replace(",","."));t.second=Math.floor(r),t.millisecond=r%1*1e3}}else"Z"!==e[e.length-1]&&(e+="Z"),JulianDate.toGregorianDate(JulianDate.fromIso8601(e,scratchJulianDate),t);return t.year||t.month||t.day||t.hour||t.minute||t.second||t.millisecond}var scratchDuration=new GregorianDate;TimeIntervalCollection.fromIso8601=function(e,t){var i=e.iso8601.split("/"),r=JulianDate.fromIso8601(i[0]),n=JulianDate.fromIso8601(i[1]),a=[];if(parseDuration(i[2],scratchDuration)){var o=JulianDate.clone(r);for(a.push(o);JulianDate.compare(o,n)<0;){o=addToDate(o,scratchDuration),JulianDate.compare(n,o)<=0&&JulianDate.clone(n,o),a.push(o)}}else a.push(r,n);return TimeIntervalCollection.fromJulianDateArray({julianDates:a,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DateArray=function(e,t){return TimeIntervalCollection.fromJulianDateArray({julianDates:e.iso8601Dates.map(function(e){return JulianDate.fromIso8601(e)}),isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DurationArray=function(e,t){for(var i,r,n=e.epoch,a=e.iso8601Durations,o=defaultValue(e.relativeToPrevious,!1),s=[],l=a.length,c=0;c<l;++c)!parseDuration(a[c],scratchDuration)&&0!==c||(i=o&&defined(r)?addToDate(r,scratchDuration):addToDate(n,scratchDuration),s.push(i),r=i);return TimeIntervalCollection.fromJulianDateArray({julianDates:s,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)};var defaultScale=new Cartesian3(1,1,1),defaultTranslation=Cartesian3.ZERO,defaultRotation=Quaternion.IDENTITY,TranslationRotationScale=function(e,t,i){this.translation=Cartesian3.clone(defaultValue(e,defaultTranslation)),this.rotation=Quaternion.clone(defaultValue(t,defaultRotation)),this.scale=Cartesian3.clone(defaultValue(i,defaultScale))};TranslationRotationScale.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this.translation,e.translation)&&Quaternion.equals(this.rotation,e.rotation)&&Cartesian3.equals(this.scale,e.scale)};var context2DsByWidthAndHeight={};function getImagePixels(e,t,i){defined(t)||(t=e.width),defined(i)||(i=e.height);var r=context2DsByWidthAndHeight[t];defined(r)||(r={},context2DsByWidthAndHeight[t]=r);var n=r[i];if(!defined(n)){var a=document.createElement("canvas");a.width=t,a.height=i,(n=a.getContext("2d")).globalCompositeOperation="copy",r[i]=n}return n.drawImage(e,0,0,t,i),n.getImageData(0,0,t,i).data}function DataRectangle(e,t){this.rectangle=e,this.maxLevel=t}function VRTheWorldTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=Resource.createIfNeeded(e.url);this._resource=t,this._errorEvent=new Event,this._ready=!1,this._readyPromise=when.defer(),this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0,lowestEncodedHeight:0,highestEncodedHeight:16777215};var i=e.credit;"string"==typeof i&&(i=new Credit(i)),this._credit=i,this._tilingScheme=void 0,this._rectangles=[];var r,d=this,h=defaultValue(e.ellipsoid,Ellipsoid.WGS84);function n(e){var t=e.getElementsByTagName("SRS")[0].textContent;if("EPSG:4326"===t){d._tilingScheme=new GeographicTilingScheme({ellipsoid:h});var i=e.getElementsByTagName("TileFormat")[0];d._heightmapWidth=parseInt(i.getAttribute("width"),10),d._heightmapHeight=parseInt(i.getAttribute("height"),10),d._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(h,Math.min(d._heightmapWidth,d._heightmapHeight),d._tilingScheme.getNumberOfXTilesAtLevel(0));for(var r=e.getElementsByTagName("DataExtent"),n=0;n<r.length;++n){var a=r[n],o=CesiumMath.toRadians(parseFloat(a.getAttribute("minx"))),s=CesiumMath.toRadians(parseFloat(a.getAttribute("miny"))),l=CesiumMath.toRadians(parseFloat(a.getAttribute("maxx"))),c=CesiumMath.toRadians(parseFloat(a.getAttribute("maxy"))),u=parseInt(a.getAttribute("maxlevel"),10);d._rectangles.push(new DataRectangle(new Rectangle(o,s,l,c),u))}d._ready=!0,d._readyPromise.resolve(!0)}else p("SRS "+t+" is not supported.")}function p(e){var t=defaultValue(e,"An error occurred while accessing "+d._resource.url+".");r=TileProviderError.handleError(r,d,d._errorEvent,t,void 0,void 0,void 0,a)}function a(){when(d._resource.fetchXML(),n,p)}a()}defineProperties$1(VRTheWorldTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),VRTheWorldTerrainProvider.prototype.requestTileGeometry=function(t,i,r,e){var n=this._tilingScheme.getNumberOfYTilesAtLevel(r),a=this._resource.getDerivedResource({url:r+"/"+t+"/"+(n-i-1)+".tif",queryParameters:{cesium:!0},request:e}).fetchImage({preferImageBitmap:!0});if(defined(a)){var o=this;return when(a).then(function(e){return new HeightmapTerrainData({buffer:getImagePixels(e),width:o._heightmapWidth,height:o._heightmapHeight,childTileMask:getChildMask(o,t,i,r),structure:o._terrainDataStructure})})}},VRTheWorldTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)};var rectangleScratch$4=new Rectangle;function getChildMask(e,t,i,r){for(var n=e._tilingScheme,a=e._rectangles,o=n.tileXYToRectangle(t,i,r),s=0,l=0;l<a.length&&15!==s;++l){var c=a[l];if(!(c.maxLevel<=r)){var u=c.rectangle;defined(Rectangle.intersection(u,o,rectangleScratch$4))&&(isTileInRectangle(n,u,2*t,2*i,r+1)&&(s|=4),isTileInRectangle(n,u,2*t+1,2*i,r+1)&&(s|=8),isTileInRectangle(n,u,2*t,2*i+1,r+1)&&(s|=1),isTileInRectangle(n,u,2*t+1,2*i+1,r+1)&&(s|=2))}}return s}function isTileInRectangle(e,t,i,r,n){var a=e.tileXYToRectangle(i,r,n);return defined(Rectangle.intersection(a,t,rectangleScratch$4))}function VideoSynchronizer(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._clock=void 0,this._element=void 0,this._clockSubscription=void 0,this._seekFunction=void 0,this._lastPlaybackRate=void 0,this.clock=e.clock,this.element=e.element,this.epoch=defaultValue(e.epoch,Iso8601.MINIMUM_VALUE),this.tolerance=defaultValue(e.tolerance,1),this._seeking=!1,this._seekFunction=void 0,this._firstTickAfterSeek=!1}function createSeekFunction(e){return function(){e._seeking=!1,e._firstTickAfterSeek=!0}}VRTheWorldTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},VRTheWorldTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){},defineProperties$1(VideoSynchronizer.prototype,{clock:{get:function(){return this._clock},set:function(e){var t=this._clock;t!==e&&(defined(t)&&(this._clockSubscription(),this._clockSubscription=void 0),defined(e)&&(this._clockSubscription=e.onTick.addEventListener(VideoSynchronizer.prototype._onTick,this)),this._clock=e)}},element:{get:function(){return this._element},set:function(e){var t=this._element;t!==e&&(defined(t)&&t.removeEventListener("seeked",this._seekFunction,!1),defined(e)&&(this._seeking=!1,this._seekFunction=createSeekFunction(this),e.addEventListener("seeked",this._seekFunction,!1)),this._element=e,this._seeking=!1,this._firstTickAfterSeek=!1)}}}),VideoSynchronizer.prototype.destroy=function(){return this.element=void 0,this.clock=void 0,destroyObject(this)},VideoSynchronizer.prototype.isDestroyed=function(){return!1},VideoSynchronizer.prototype._trySetPlaybackRate=function(e){if(this._lastPlaybackRate!==e.multiplier){var t=this._element;try{t.playbackRate=e.multiplier}catch(e){t.playbackRate=0}this._lastPlaybackRate=e.multiplier}},VideoSynchronizer.prototype._onTick=function(e){var t=this._element;if(defined(t)&&!(t.readyState<2)){var i=t.paused,r=e.shouldAnimate;if(r===i&&(r?t.play():t.pause()),this._seeking||this._firstTickAfterSeek)this._firstTickAfterSeek=!1;else{this._trySetPlaybackRate(e);var n,a=e.currentTime,o=defaultValue(this.epoch,Iso8601.MINIMUM_VALUE),s=JulianDate.secondsDifference(a,o),l=t.duration,c=t.currentTime;n=t.loop?((s%=l)<0&&(s=l-s),s):l<s?l:s<0?0:s;var u=r?defaultValue(this.tolerance,1):.001;Math.abs(n-c)>u&&(this._seeking=!0,t.currentTime=n)}}};var WallGeometryLibrary={};function latLonEquals(e,t){return CesiumMath.equalsEpsilon(e.latitude,t.latitude,CesiumMath.EPSILON14)&&CesiumMath.equalsEpsilon(e.longitude,t.longitude,CesiumMath.EPSILON14)}var scratchCartographic1$2=new Cartographic,scratchCartographic2$1=new Cartographic;function removeDuplicates(e,t,i,r){var n=t.length;if(!(n<2)){var a=defined(r),o=defined(i),s=!0,l=new Array(n),c=new Array(n),u=new Array(n),d=t[0];l[0]=d;var h=e.cartesianToCartographic(d,scratchCartographic1$2);o&&(h.height=i[0]),s=s&&h.height<=0,c[0]=h.height,u[0]=a?r[0]:0;for(var p=1,m=1;m<n;++m){var f=t[m],g=e.cartesianToCartographic(f,scratchCartographic2$1);o&&(g.height=i[m]),s=s&&g.height<=0,latLonEquals(h,g)?h.height<g.height&&(c[p-1]=g.height):(l[p]=f,c[p]=g.height,u[p]=a?r[m]:0,Cartographic.clone(g,h),++p)}if(!(s||p<2))return l.length=p,c.length=p,u.length=p,{positions:l,topHeights:c,bottomHeights:u}}}var positionsArrayScratch=new Array(2),heightsArrayScratch=new Array(2),generateArcOptionsScratch$1={positions:void 0,height:void 0,granularity:void 0,ellipsoid:void 0};WallGeometryLibrary.computePositions=function(e,t,i,r,n,a){var o=removeDuplicates(e,t,i,r);if(defined(o)){if(t=o.positions,i=o.topHeights,r=o.bottomHeights,3<=t.length){var s=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t);PolygonPipeline.computeWindingOrder2D(s)===WindingOrder$1.CLOCKWISE&&(t.reverse(),i.reverse(),r.reverse())}var l,c,u=t.length,d=u-2,h=CesiumMath.chordLength(n,e.maximumRadius),p=generateArcOptionsScratch$1;if(p.minDistance=h,p.ellipsoid=e,a){var m,f=0;for(m=0;m<u-1;m++)f+=PolylinePipeline.numberOfPoints(t[m],t[m+1],h)+1;l=new Float64Array(3*f),c=new Float64Array(3*f);var g=positionsArrayScratch,_=heightsArrayScratch;p.positions=g,p.height=_;var y=0;for(m=0;m<u-1;m++){g[0]=t[m],g[1]=t[m+1],_[0]=i[m],_[1]=i[m+1];var v=PolylinePipeline.generateArc(p);l.set(v,y),_[0]=r[m],_[1]=r[m+1],c.set(PolylinePipeline.generateArc(p),y),y+=v.length}}else p.positions=t,p.height=i,l=new Float64Array(PolylinePipeline.generateArc(p)),p.height=r,c=new Float64Array(PolylinePipeline.generateArc(p));return{bottomPositions:c,topPositions:l,numCorners:d}}};var scratchCartesian3Position1=new Cartesian3,scratchCartesian3Position2=new Cartesian3,scratchCartesian3Position3=new Cartesian3,scratchCartesian3Position4=new Cartesian3,scratchCartesian3Position5=new Cartesian3,scratchBitangent$4=new Cartesian3,scratchTangent$4=new Cartesian3,scratchNormal$6=new Cartesian3;function WallGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.maximumHeights,r=e.minimumHeights,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=r,this._maximumHeights=i,this._vertexFormat=VertexFormat.clone(n),this._granularity=a,this._ellipsoid=Ellipsoid.clone(o),this._workerName="createWallGeometry";var s=1+t.length*Cartesian3.packedLength+2;defined(r)&&(s+=r.length),defined(i)&&(s+=i.length),this.packedLength=s+Ellipsoid.packedLength+VertexFormat.packedLength+1}WallGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._minimumHeights;if(a=defined(o)?o.length:0,t[i++]=a,defined(o))for(r=0;r<a;++r)t[i++]=o[r];var s=e._maximumHeights;if(a=defined(s)?s.length:0,t[i++]=a,defined(s))for(r=0;r<a;++r)t[i++]=s[r];return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),t[i+=VertexFormat.packedLength]=e._granularity,t};var scratchEllipsoid$c=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$c=new VertexFormat,scratchOptions$m={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$c,vertexFormat:scratchVertexFormat$c,granularity:void 0};WallGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n,a,o=e[t++],s=new Array(o);for(r=0;r<o;++r,t+=Cartesian3.packedLength)s[r]=Cartesian3.unpack(e,t);if(0<(o=e[t++]))for(n=new Array(o),r=0;r<o;++r)n[r]=e[t++];if(0<(o=e[t++]))for(a=new Array(o),r=0;r<o;++r)a[r]=e[t++];var l=Ellipsoid.unpack(e,t,scratchEllipsoid$c);t+=Ellipsoid.packedLength;var c=VertexFormat.unpack(e,t,scratchVertexFormat$c),u=e[t+=VertexFormat.packedLength];return defined(i)?(i._positions=s,i._minimumHeights=n,i._maximumHeights=a,i._ellipsoid=Ellipsoid.clone(l,i._ellipsoid),i._vertexFormat=VertexFormat.clone(c,i._vertexFormat),i._granularity=u,i):(scratchOptions$m.positions=s,scratchOptions$m.minimumHeights=n,scratchOptions$m.maximumHeights=a,scratchOptions$m.granularity=u,new WallGeometry(scratchOptions$m))},WallGeometry.fromConstantHeights=function(e){var t,i,r=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.minimumHeight,a=e.maximumHeight,o=defined(n),s=defined(a);if(o||s){var l=r.length;t=o?new Array(l):void 0,i=s?new Array(l):void 0;for(var c=0;c<l;++c)o&&(t[c]=n),s&&(i[c]=a)}return new WallGeometry({positions:r,maximumHeights:i,minimumHeights:t,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat})},WallGeometry.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,r=e._maximumHeights,n=e._vertexFormat,a=e._granularity,o=e._ellipsoid,s=WallGeometryLibrary.computePositions(o,t,r,i,a,!0);if(defined(s)){var l,c=s.bottomPositions,u=s.topPositions,d=s.numCorners,h=u.length,p=2*h,m=n.position?new Float64Array(p):void 0,f=n.normal?new Float32Array(p):void 0,g=n.tangent?new Float32Array(p):void 0,_=n.bitangent?new Float32Array(p):void 0,y=n.st?new Float32Array(p/3*2):void 0,v=0,C=0,S=0,T=0,x=0,b=scratchNormal$6,E=scratchTangent$4,P=scratchBitangent$4,A=!0,w=0,D=1/((h/=3)-t.length+1);for(l=0;l<h;++l){var M=3*l,I=Cartesian3.fromArray(u,M,scratchCartesian3Position1),R=Cartesian3.fromArray(c,M,scratchCartesian3Position2);if(n.position&&(m[v++]=R.x,m[v++]=R.y,m[v++]=R.z,m[v++]=I.x,m[v++]=I.y,m[v++]=I.z),n.st&&(y[x++]=w,y[x++]=0,y[x++]=w,y[x++]=1),n.normal||n.tangent||n.bitangent){var O,L=Cartesian3.clone(Cartesian3.ZERO,scratchCartesian3Position5),F=o.scaleToGeodeticSurface(Cartesian3.fromArray(u,M,scratchCartesian3Position2),scratchCartesian3Position2);if(l+1<h&&(O=o.scaleToGeodeticSurface(Cartesian3.fromArray(u,3+M,scratchCartesian3Position3),scratchCartesian3Position3),L=Cartesian3.fromArray(u,3+M,scratchCartesian3Position5)),A){var N=Cartesian3.subtract(L,I,scratchCartesian3Position4),V=Cartesian3.subtract(F,I,scratchCartesian3Position1);b=Cartesian3.normalize(Cartesian3.cross(V,N,b),b),A=!1}Cartesian3.equalsEpsilon(O,F,CesiumMath.EPSILON10)?A=!0:(w+=D,n.tangent&&(E=Cartesian3.normalize(Cartesian3.subtract(O,F,E),E)),n.bitangent&&(P=Cartesian3.normalize(Cartesian3.cross(b,E,P),P))),n.normal&&(f[C++]=b.x,f[C++]=b.y,f[C++]=b.z,f[C++]=b.x,f[C++]=b.y,f[C++]=b.z),n.tangent&&(g[T++]=E.x,g[T++]=E.y,g[T++]=E.z,g[T++]=E.x,g[T++]=E.y,g[T++]=E.z),n.bitangent&&(_[S++]=P.x,_[S++]=P.y,_[S++]=P.z,_[S++]=P.x,_[S++]=P.y,_[S++]=P.z)}}var B=new GeometryAttributes;n.position&&(B.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:m})),n.normal&&(B.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),n.tangent&&(B.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:g})),n.bitangent&&(B.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),n.st&&(B.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:y}));var k=p/3;p-=6*(d+1);var $=IndexDatatype$1.createTypedArray(k,p),z=0;for(l=0;l<k-2;l+=2){var U=l,G=l+2,H=Cartesian3.fromArray(m,3*U,scratchCartesian3Position1),W=Cartesian3.fromArray(m,3*G,scratchCartesian3Position2);if(!Cartesian3.equalsEpsilon(H,W,CesiumMath.EPSILON10)){var q=l+1,j=l+3;$[z++]=q,$[z++]=U,$[z++]=j,$[z++]=j,$[z++]=U,$[z++]=G}}return new Geometry({attributes:B,indices:$,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere.fromVertices(m)})}};var scratchCartesian3Position1$1=new Cartesian3,scratchCartesian3Position2$1=new Cartesian3;function WallOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.maximumHeights,r=e.minimumHeights,n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=r,this._maximumHeights=i,this._granularity=n,this._ellipsoid=Ellipsoid.clone(a),this._workerName="createWallOutlineGeometry";var o=1+t.length*Cartesian3.packedLength+2;defined(r)&&(o+=r.length),defined(i)&&(o+=i.length),this.packedLength=o+Ellipsoid.packedLength+1}WallOutlineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._minimumHeights;if(a=defined(o)?o.length:0,t[i++]=a,defined(o))for(r=0;r<a;++r)t[i++]=o[r];var s=e._maximumHeights;if(a=defined(s)?s.length:0,t[i++]=a,defined(s))for(r=0;r<a;++r)t[i++]=s[r];return Ellipsoid.pack(e._ellipsoid,t,i),t[i+=Ellipsoid.packedLength]=e._granularity,t};var scratchEllipsoid$d=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$n={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$d,granularity:void 0},implementation$1;function WeightSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).weights,i=e.times;this._times=i,this._weights=t,this._count=t.length/i.length,this._lastTimeIndex=0}function arraySlice(e,t,i){if("function"==typeof e.slice)return e.slice(t,i);for(var r=Array.prototype.slice.call(e,t,i),n=FeatureDetection.typedArrayTypes,a=n.length,o=0;o<a;++o)if(e instanceof n[o]){r=new n[o](r);break}return r}function cancelAnimationFramePolyfill(e){implementation$1(e)}function createGuid(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)})}function createWorldTerrain(e){return e=defaultValue(e,defaultValue.EMPTY_OBJECT),new CesiumTerrainProvider({url:IonResource.fromAssetId(1),requestVertexNormals:defaultValue(e.requestVertexNormals,!1),requestWaterMask:defaultValue(e.requestWaterMask,!1)})}WallOutlineGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n,a,o=e[t++],s=new Array(o);for(r=0;r<o;++r,t+=Cartesian3.packedLength)s[r]=Cartesian3.unpack(e,t);if(0<(o=e[t++]))for(n=new Array(o),r=0;r<o;++r)n[r]=e[t++];if(0<(o=e[t++]))for(a=new Array(o),r=0;r<o;++r)a[r]=e[t++];var l=Ellipsoid.unpack(e,t,scratchEllipsoid$d),c=e[t+=Ellipsoid.packedLength];return defined(i)?(i._positions=s,i._minimumHeights=n,i._maximumHeights=a,i._ellipsoid=Ellipsoid.clone(l,i._ellipsoid),i._granularity=c,i):(scratchOptions$n.positions=s,scratchOptions$n.minimumHeights=n,scratchOptions$n.maximumHeights=a,scratchOptions$n.granularity=c,new WallOutlineGeometry(scratchOptions$n))},WallOutlineGeometry.fromConstantHeights=function(e){var t,i,r=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.minimumHeight,a=e.maximumHeight,o=defined(n),s=defined(a);if(o||s){var l=r.length;t=o?new Array(l):void 0,i=s?new Array(l):void 0;for(var c=0;c<l;++c)o&&(t[c]=n),s&&(i[c]=a)}return new WallOutlineGeometry({positions:r,maximumHeights:i,minimumHeights:t,ellipsoid:e.ellipsoid})},WallOutlineGeometry.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,r=e._maximumHeights,n=e._granularity,a=e._ellipsoid,o=WallGeometryLibrary.computePositions(a,t,r,i,n,!1);if(defined(o)){var s,l=o.bottomPositions,c=o.topPositions,u=c.length,d=2*u,h=new Float64Array(d),p=0;for(u/=3,s=0;s<u;++s){var m=3*s,f=Cartesian3.fromArray(c,m,scratchCartesian3Position1$1),g=Cartesian3.fromArray(l,m,scratchCartesian3Position2$1);h[p++]=g.x,h[p++]=g.y,h[p++]=g.z,h[p++]=f.x,h[p++]=f.y,h[p++]=f.z}var _=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:h})}),y=d/3;d=2*y-4+y;var v=IndexDatatype$1.createTypedArray(y,d),C=0;for(s=0;s<y-2;s+=2){var S=s,T=s+2,x=Cartesian3.fromArray(h,3*S,scratchCartesian3Position1$1),b=Cartesian3.fromArray(h,3*T,scratchCartesian3Position2$1);if(!Cartesian3.equalsEpsilon(x,b,CesiumMath.EPSILON10)){var E=s+1,P=s+3;v[C++]=E,v[C++]=S,v[C++]=E,v[C++]=P,v[C++]=S,v[C++]=T}}return v[C++]=y-2,v[C++]=y-1,new Geometry({attributes:_,indices:v,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere.fromVertices(h)})}},defineProperties$1(WeightSpline.prototype,{times:{get:function(){return this._times}},weights:{get:function(){return this._weights}}}),WeightSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,WeightSpline.prototype.wrapTime=Spline.prototype.wrapTime,WeightSpline.prototype.clampTime=Spline.prototype.clampTime,WeightSpline.prototype.evaluate=function(e,t){var i=this.weights,r=this.times,n=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),a=(e-r[n])/(r[n+1]-r[n]);defined(t)||(t=new Array(this._count));for(var o=0;o<this._count;o++){var s=n*this._count+o;t[o]=i[s]*(1-a)+i[s+this._count]*a}return t},"undefined"!=typeof cancelAnimationFrame&&(implementation$1=cancelAnimationFrame),function(){if(!defined(implementation$1)&&"undefined"!=typeof window)for(var e=["webkit","moz","ms","o"],t=0,i=e.length;t<i&&!defined(implementation$1);)defined(implementation$1=window[e[t]+"CancelAnimationFrame"])||(implementation$1=window[e[t]+"CancelRequestAnimationFrame"]),++t;defined(implementation$1)||(implementation$1=clearTimeout)}();var compressedMagic=1953029805,compressedMagicSwap=2917034100;function decodeGoogleEarthEnterpriseData(e,t){if(decodeGoogleEarthEnterpriseData.passThroughDataForTesting)return t;var i=e.byteLength;if(0===i||i%4!=0)throw new RuntimeError("The length of key must be greater than 0 and a multiple of 4.");var r=new DataView(t),n=r.getUint32(0,!0);if(n===compressedMagic||n===compressedMagicSwap)return t;for(var a,o=new DataView(e),s=0,l=t.byteLength,c=l-l%8,u=i,d=8;s<c;)for(a=d=(d+8)%24;s<c&&a<u;)r.setUint32(s,r.getUint32(s,!0)^o.getUint32(a,!0),!0),r.setUint32(s+4,r.getUint32(s+4,!0)^o.getUint32(a+4,!0),!0),s+=8,a+=24;if(s<l)for(u<=a&&(a=d=(d+8)%24);s<l;)r.setUint8(s,r.getUint8(s)^o.getUint8(a)),s++,a++}function getFilenameFromUri(e){var t=new URI(e);t.normalize();var i=t.path,r=i.lastIndexOf("/");return-1!==r&&(i=i.substr(r+1)),i}function getMagic(e,t){return getStringFromTypedArray(e,t=defaultValue(t,0),Math.min(4,e.length))}decodeGoogleEarthEnterpriseData.passThroughDataForTesting=!1;var transcodeTaskProcessor=new TaskProcessor("transcodeCRNToDXT",Number.POSITIVE_INFINITY);function loadCRN(e){var t;e instanceof ArrayBuffer||ArrayBuffer.isView(e)?t=when.resolve(e):t=Resource.createIfNeeded(e).fetchArrayBuffer();if(defined(t))return t.then(function(e){if(defined(e)){var t=[];return e instanceof ArrayBuffer?t.push(e):(0===e.byteOffset&&e.byteLength===e.buffer.byteLength||(e=e.slice(0,e.length)),t.push(e.buffer)),transcodeTaskProcessor.scheduleTask(e,t)}}).then(function(e){return CompressedTextureBuffer.clone(e)})}function loadImageFromTypedArray(e){var t,i=e.uint8Array,r=e.format,n=e.request,a=defaultValue(e.flipY,!1),o=new Blob([i],{type:r});return Resource.supportsImageBitmapOptions().then(function(e){return e?when(Resource.createImageBitmapFromBlob(o,{flipY:a,premultiplyAlpha:!1})):new Resource({url:t=window.URL.createObjectURL(o),request:n}).fetchImage({flipY:a})}).then(function(e){return defined(t)&&window.URL.revokeObjectURL(t),e}).otherwise(function(e){return defined(t)&&window.URL.revokeObjectURL(t),when.reject(e)})}function loadKTX(e){var t;e instanceof ArrayBuffer||ArrayBuffer.isView(e)?t=when.resolve(e):t=Resource.createIfNeeded(e).fetchArrayBuffer();if(defined(t))return t.then(function(e){if(defined(e))return parseKTX(e)})}var fileIdentifier=[171,75,84,88,32,49,49,187,13,10,26,10],endiannessTest=67305985,faceOrder=["positiveX","negativeX","positiveY","negativeY","positiveZ","negativeZ"],sizeOfUint32$1=4;function parseKTX(e){var t,i,r,n=new Uint8Array(e),a=!0;for(t=0;t<fileIdentifier.length;++t)if(fileIdentifier[t]!==n[t]){a=!1;break}if(!a)throw new RuntimeError("Invalid KTX file.");r=defined(e.buffer)?(i=new DataView(e.buffer),e.byteOffset):(i=new DataView(e),0),r+=12;var o=i.getUint32(r,!0);if(r+=sizeOfUint32$1,o!==endiannessTest)throw new RuntimeError("File is the wrong endianness.");var s=i.getUint32(r,!0);r+=sizeOfUint32$1;var l=i.getUint32(r,!0);r+=sizeOfUint32$1;var c=i.getUint32(r,!0);r+=sizeOfUint32$1;var u=i.getUint32(r,!0);r+=sizeOfUint32$1;var d=i.getUint32(r,!0);r+=sizeOfUint32$1;var h=i.getUint32(r,!0);r+=sizeOfUint32$1;var p=i.getUint32(r,!0);r+=sizeOfUint32$1;var m=i.getUint32(r,!0);r+=sizeOfUint32$1;var f=i.getUint32(r,!0);r+=sizeOfUint32$1;var g=i.getUint32(r,!0);r+=sizeOfUint32$1;var _=i.getUint32(r,!0);r+=sizeOfUint32$1;var y=i.getUint32(r,!0);r+=sizeOfUint32$1,r+=y;var v,C=i.getUint32(r,!0);if(r+=sizeOfUint32$1,v=defined(e.buffer)?new Uint8Array(e.buffer,r,C):new Uint8Array(e,r,C),u===WebGLConstants$1.RGB8?u=PixelFormat$1.RGB:u===WebGLConstants$1.RGBA8&&(u=PixelFormat$1.RGBA),!PixelFormat$1.validate(u))throw new RuntimeError("glInternalFormat is not a valid format.");if(PixelFormat$1.isCompressedFormat(u)){if(0!==s)throw new RuntimeError("glType must be zero when the texture is compressed.");if(1!==l)throw new RuntimeError("The type size for compressed textures must be 1.");if(0!==c)throw new RuntimeError("glFormat must be zero when the texture is compressed.")}else{if(s!==WebGLConstants$1.UNSIGNED_BYTE)throw new RuntimeError("Only unsigned byte buffers are supported.");if(d!==c)throw new RuntimeError("The base internal format must be the same as the format for uncompressed textures.")}if(0!==m)throw new RuntimeError("3D textures are unsupported.");if(0!==f)throw new RuntimeError("Texture arrays are unsupported.");var S=v.byteOffset,T=new Array(_);for(t=0;t<_;++t){for(var x=T[t]={},b=0;b<g;++b){var E=h>>t,P=p>>t,A=PixelFormat$1.isCompressedFormat(u)?PixelFormat$1.compressedTextureSizeInBytes(u,E,P):PixelFormat$1.textureSizeInBytes(u,s,E,P),w=new Uint8Array(v.buffer,S,A);x[faceOrder[b]]=new CompressedTextureBuffer(u,E,P,w),S+=A}S+=3-(S+3)%4+4}var D=T;if(1===g)for(t=0;t<_;++t)D[t]=D[t][faceOrder[0]];return 1===_&&(D=D[0]),D}var leftScratchArray=[],rightScratchArray=[];function merge(e,t,i,r,n,a){var o,s,l=n-r+1,c=a-n,u=leftScratchArray,d=rightScratchArray;for(o=0;o<l;++o)u[o]=e[r+o];for(s=0;s<c;++s)d[s]=e[n+s+1];s=o=0;for(var h=r;h<=a;++h){var p=u[o],m=d[s];o<l&&(c<=s||t(p,m,i)<=0)?(e[h]=p,++o):s<c&&(e[h]=m,++s)}}function sort(e,t,i,r,n){if(!(n<=r)){var a=Math.floor(.5*(r+n));sort(e,t,i,r,a),sort(e,t,i,a+1,n),merge(e,t,i,r,a,n)}}function mergeSort(e,t,i){var r=e.length,n=Math.ceil(.5*r);leftScratchArray.length=n,rightScratchArray.length=n,sort(e,t,i,0,r-1),leftScratchArray.length=0,rightScratchArray.length=0}var coords=new Cartesian3,implementation$2;function pointInsideTriangle(e,t,i,r){return barycentricCoordinates(e,t,i,r,coords),0<coords.x&&0<coords.y&&0<coords.z}function requestAnimationFramePolyFill(e){return implementation$2(e)}function sampleTerrain(e,t,i){return e.readyPromise.then(function(){return doSampling(e,t,i)})}function doSampling(e,t,i){var r,n=e.tilingScheme,a=[],o={};for(r=0;r<i.length;++r){var s=n.positionToTileXY(i[r],t),l=s.toString();if(!o.hasOwnProperty(l)){var c={x:s.x,y:s.y,level:t,tilingScheme:n,terrainProvider:e,positions:[]};o[l]=c,a.push(c)}o[l].positions.push(i[r])}var u=[];for(r=0;r<a.length;++r){var d=a[r],h=d.terrainProvider.requestTileGeometry(d.x,d.y,d.level).then(createInterpolateFunction(d)).otherwise(createMarkFailedFunction(d));u.push(h)}return when.all(u,function(){return i})}function createInterpolateFunction(e){var r=e.positions,n=e.tilingScheme.tileXYToRectangle(e.x,e.y,e.level);return function(e){for(var t=0;t<r.length;++t){var i=r[t];i.height=e.interpolateHeight(n,i.longitude,i.latitude)}}}function createMarkFailedFunction(e){var t=e.positions;return function(){for(var e=0;e<t.length;++e){t[e].height=void 0}}}"undefined"!=typeof requestAnimationFrame&&(implementation$2=requestAnimationFrame),function(){if(!defined(implementation$2)&&"undefined"!=typeof window)for(var e=["webkit","moz","ms","o"],t=0,i=e.length;t<i&&!defined(implementation$2);)implementation$2=window[e[t]+"RequestAnimationFrame"],++t;if(!defined(implementation$2)){var r=0;implementation$2=function(e){var t=getTimestamp$1(),i=Math.max(1e3/60-(t-r),0);return r=t+i,setTimeout(function(){e(r)},i)}}}();var scratchCartesian2$7=new Cartesian2;function sampleTerrainMostDetailed(c,u){return c.readyPromise.then(function(){for(var e=[],r=[],n=c.availability,t=[],i=0;i<u.length;++i){var a=u[i],o=n.computeMaximumLevelAtPosition(a);if(0===(r[i]=o)){c.tilingScheme.positionToTileXY(a,1,scratchCartesian2$7);var s=c.loadTileDataAvailability(scratchCartesian2$7.x,scratchCartesian2$7.y,1);defined(s)&&t.push(s)}var l=e[o];defined(l)||(e[o]=l=[]),l.push(a)}return when.all(t).then(function(){return when.all(e.map(function(e,t){if(defined(e))return sampleTerrain(c,t,e)}))}).then(function(){for(var e=[],t=0;t<u.length;++t){var i=u[t];n.computeMaximumLevelAtPosition(i)!==r[t]&&e.push(i)}if(0<e.length)return sampleTerrainMostDetailed(c,e)}).then(function(){return u})})}function subdivideArray(e,t){for(var i=[],r=e.length,n=0;n<r;){var a=Math.ceil((r-n)/t--);i.push(e.slice(n,n+a)),n+=a}return i}function webGLConstantToGlslType(e){switch(e){case WebGLConstants$1.FLOAT:return"float";case WebGLConstants$1.FLOAT_VEC2:return"vec2";case WebGLConstants$1.FLOAT_VEC3:return"vec3";case WebGLConstants$1.FLOAT_VEC4:return"vec4";case WebGLConstants$1.FLOAT_MAT2:return"mat2";case WebGLConstants$1.FLOAT_MAT3:return"mat3";case WebGLConstants$1.FLOAT_MAT4:return"mat4";case WebGLConstants$1.SAMPLER_2D:return"sampler2D";case WebGLConstants$1.BOOL:return"bool"}}function wrapFunction(e,t,i){return function(){i.apply(e,arguments),t.apply(e,arguments)}}function ConstantProperty(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new Event,this.setValue(e)}function createProperty(r,n,a,e,o){return{configurable:e,get:function(){return this[n]},set:function(e){var t=this[n],i=this[a];defined(i)&&(i(),this[a]=void 0),!(void 0!==e)||defined(e)&&defined(e.getValue)||!defined(o)||(e=o(e)),t!==e&&(this[n]=e,this._definitionChanged.raiseEvent(this,r,e,t)),defined(e)&&defined(e.definitionChanged)&&(this[a]=e.definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this,r,e,e)},this))}}}function createConstantProperty(e){return new ConstantProperty(e)}function createPropertyDescriptor(e,t,i){return createProperty(e,"_"+e.toString(),"_"+e.toString()+"Subscription",defaultValue(t,!1),defaultValue(i,createConstantProperty))}function BillboardGraphics(e){this._definitionChanged=new Event,this._show=void 0,this._showSubscription=void 0,this._image=void 0,this._imageSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._heightReference=void 0,this._heightReferenceSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._alignedAxis=void 0,this._alignedAxisSubscription=void 0,this._sizeInMeters=void 0,this._sizeInMetersSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._imageSubRegion=void 0,this._imageSubRegionSubscription=void 0,this._distanceDisplayCondition=void 0,this._distanceDisplayConditionSubscription=void 0,this._disableDepthTestDistance=void 0,this._disableDepthTestDistanceSubscription=void 0,this.merge(defaultValue(e,defaultValue.EMPTY_OBJECT))}defineProperties$1(ConstantProperty.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}}),ConstantProperty.prototype.getValue=function(e,t){return this._hasClone?this._value.clone(t):this._value},ConstantProperty.prototype.setValue=function(e){var t=this._value;if(t!==e){var i=defined(e),r=i&&"function"==typeof e.clone,n=i&&"function"==typeof e.equals;(!n||!e.equals(t))&&(this._hasClone=r,this._hasEquals=n,this._value=r?e.clone(this._value):e,this._definitionChanged.raiseEvent(this))}},ConstantProperty.prototype.equals=function(e){return this===e||e instanceof ConstantProperty&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))},ConstantProperty.prototype.valueOf=function(){return this._value},ConstantProperty.prototype.toString=function(){return String(this._value)},defineProperties$1(BillboardGraphics.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:createPropertyDescriptor("show"),image:createPropertyDescriptor("image"),scale:createPropertyDescriptor("scale"),pixelOffset:createPropertyDescriptor("pixelOffset"),eyeOffset:createPropertyDescriptor("eyeOffset"),horizontalOrigin:createPropertyDescriptor("horizontalOrigin"),verticalOrigin:createPropertyDescriptor("verticalOrigin"),heightReference:createPropertyDescriptor("heightReference"),color:createPropertyDescriptor("color"),rotation:createPropertyDescriptor("rotation"),alignedAxis:createPropertyDescriptor("alignedAxis"),sizeInMeters:createPropertyDescriptor("sizeInMeters"),width:createPropertyDescriptor("width"),height:createPropertyDescriptor("height"),scaleByDistance:createPropertyDescriptor("scaleByDistance"),translucencyByDistance:createPropertyDescriptor("translucencyByDistance"),pixelOffsetScaleByDistance:createPropertyDescriptor("pixelOffsetScaleByDistance"),imageSubRegion:createPropertyDescriptor("imageSubRegion"),distanceDisplayCondition:createPropertyDescriptor("distanceDisplayCondition"),disableDepthTestDistance:createPropertyDescriptor("disableDepthTestDistance")}),BillboardGraphics.prototype.clone=function(e){return defined(e)?(e.show=this._show,e.image=this._image,e.scale=this._scale,e.pixelOffset=this._pixelOffset,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.verticalOrigin=this._verticalOrigin,e.heightReference=this._heightReference,e.color=this._color,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.sizeInMeters=this._sizeInMeters,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e.imageSubRegion=this._imageSubRegion,e.distanceDisplayCondition=this._distanceDisplayCondition,e.disableDepthTestDistance=this._disableDepthTestDistance,e):new BillboardGraphics(this)},BillboardGraphics.prototype.merge=function(e){this.show=defaultValue(this._show,e.show),this.image=defaultValue(this._image,e.image),this.scale=defaultValue(this._scale,e.scale),this.pixelOffset=defaultValue(this._pixelOffset,e.pixelOffset),this.eyeOffset=defaultValue(this._eyeOffset,e.eyeOffset),this.horizontalOrigin=defaultValue(this._horizontalOrigin,e.horizontalOrigin),this.verticalOrigin=defaultValue(this._verticalOrigin,e.verticalOrigin),this.heightReference=defaultValue(this._heightReference,e.heightReference),this.color=defaultValue(this._color,e.color),this.rotation=defaultValue(this._rotation,e.rotation),this.alignedAxis=defaultValue(this._alignedAxis,e.alignedAxis),this.sizeInMeters=defaultValue(this._sizeInMeters,e.sizeInMeters),this.width=defaultValue(this._width,e.width),this.height=defaultValue(this._height,e.height),this.scaleByDistance=defaultValue(this._scaleByDistance,e.scaleByDistance),this.translucencyByDistance=defaultValue(this._translucencyByDistance,e.translucencyByDistance),this.pixelOffsetScaleByDistance=defaultValue(this._pixelOffsetScaleByDistance,e.pixelOffsetScaleByDistance),this.imageSubRegion=defaultValue(this._imageSubRegion,e.imageSubRegion),this.distanceDisplayCondition=defaultValue(this._distanceDisplayCondition,e.distanceDisplayCondition),this.disableDepthTestDistance=defaultValue(this._disableDepthTestDistance,e.disableDepthTestDistance)};var HeightReference={NONE:0,CLAMP_TO_GROUND:1,RELATIVE_TO_GROUND:2},HeightReference$1=freezeObject$1(HeightReference),HorizontalOrigin={CENTER:0,LEFT:1,RIGHT:-1},HorizontalOrigin$1=freezeObject$1(HorizontalOrigin),VerticalOrigin={CENTER:0,BOTTOM:1,BASELINE:2,TOP:-1},VerticalOrigin$1=freezeObject$1(VerticalOrigin),BoundingSphereState={DONE:0,PENDING:1,FAILED:2},BoundingSphereState$1=freezeObject$1(BoundingSphereState);function Property(){DeveloperError.throwInstantiationError()}defineProperties$1(Property.prototype,{isConstant:{get:DeveloperError.throwInstantiationError},definitionChanged:{get:DeveloperError.throwInstantiationError}}),Property.prototype.getValue=DeveloperError.throwInstantiationError,Property.prototype.equals=DeveloperError.throwInstantiationError,Property.equals=function(e,t){return e===t||defined(e)&&e.equals(t)},Property.arrayEquals=function(e,t){if(e===t)return!0;if(!defined(e)||!defined(t)||e.length!==t.length)return!1;for(var i=e.length,r=0;r<i;r++)if(!Property.equals(e[r],t[r]))return!1;return!0},Property.isConstant=function(e){return!defined(e)||e.isConstant},Property.getValueOrUndefined=function(e,t,i){return defined(e)?e.getValue(t,i):void 0},Property.getValueOrDefault=function(e,t,i,r){return defined(e)?defaultValue(e.getValue(t,r),i):i},Property.getValueOrClonedDefault=function(e,t,i,r){var n;return defined(e)&&(n=e.getValue(t,r)),defined(n)||(n=i.clone(n)),n};var defaultColor=Color.WHITE,defaultEyeOffset=Cartesian3.ZERO,defaultHeightReference=HeightReference$1.NONE,defaultPixelOffset=Cartesian2.ZERO,defaultScale$1=1,defaultRotation$1=0,defaultAlignedAxis=Cartesian3.ZERO,defaultHorizontalOrigin=HorizontalOrigin$1.CENTER,defaultVerticalOrigin=VerticalOrigin$1.CENTER,defaultSizeInMeters=!1,positionScratch$4=new Cartesian3,colorScratch$1=new Color,eyeOffsetScratch=new Cartesian3,pixelOffsetScratch=new Cartesian2,scaleByDistanceScratch=new NearFarScalar,translucencyByDistanceScratch=new NearFarScalar,pixelOffsetScaleByDistanceScratch=new NearFarScalar,boundingRectangleScratch=new BoundingRectangle,distanceDisplayConditionScratch=new DistanceDisplayCondition;function EntityData(e){this.entity=e,this.billboard=void 0,this.textureValue=void 0}function BillboardVisualizer(e,t){t.collectionChanged.addEventListener(BillboardVisualizer.prototype._onCollectionChanged,this),this._cluster=e,this._entityCollection=t,this._items=new AssociativeArray,this._onCollectionChanged(t,t.values,[],[])}function returnPrimitive(e,t,i){defined(e)&&(e.billboard=void 0,i.removeBillboard(t))}BillboardVisualizer.prototype.update=function(e){for(var t=this._items.values,i=this._cluster,r=0,n=t.length;r<n;r++){var a,o,s=t[r],l=s.entity,c=l._billboard,u=s.billboard,d=l.isShowing&&l.isAvailable(e)&&Property.getValueOrDefault(c._show,e,!0);if(d&&(o=Property.getValueOrUndefined(l._position,e,positionScratch$4),a=Property.getValueOrUndefined(c._image,e),d=defined(o)&&defined(a)),d){Property.isConstant(l._position)||(i._clusterDirty=!0),defined(u)||((u=i.getBillboard(l)).id=l,u.image=void 0,s.billboard=u),u.show=d,defined(u.image)&&s.textureValue===a||(u.image=a,s.textureValue=a),u.position=o,u.color=Property.getValueOrDefault(c._color,e,defaultColor,colorScratch$1),u.eyeOffset=Property.getValueOrDefault(c._eyeOffset,e,defaultEyeOffset,eyeOffsetScratch),u.heightReference=Property.getValueOrDefault(c._heightReference,e,defaultHeightReference),u.pixelOffset=Property.getValueOrDefault(c._pixelOffset,e,defaultPixelOffset,pixelOffsetScratch),u.scale=Property.getValueOrDefault(c._scale,e,defaultScale$1),u.rotation=Property.getValueOrDefault(c._rotation,e,defaultRotation$1),u.alignedAxis=Property.getValueOrDefault(c._alignedAxis,e,defaultAlignedAxis),u.horizontalOrigin=Property.getValueOrDefault(c._horizontalOrigin,e,defaultHorizontalOrigin),u.verticalOrigin=Property.getValueOrDefault(c._verticalOrigin,e,defaultVerticalOrigin),u.width=Property.getValueOrUndefined(c._width,e),u.height=Property.getValueOrUndefined(c._height,e),u.scaleByDistance=Property.getValueOrUndefined(c._scaleByDistance,e,scaleByDistanceScratch),u.translucencyByDistance=Property.getValueOrUndefined(c._translucencyByDistance,e,translucencyByDistanceScratch),u.pixelOffsetScaleByDistance=Property.getValueOrUndefined(c._pixelOffsetScaleByDistance,e,pixelOffsetScaleByDistanceScratch),u.sizeInMeters=Property.getValueOrDefault(c._sizeInMeters,e,defaultSizeInMeters),u.distanceDisplayCondition=Property.getValueOrUndefined(c._distanceDisplayCondition,e,distanceDisplayConditionScratch),u.disableDepthTestDistance=Property.getValueOrUndefined(c._disableDepthTestDistance,e);var h=Property.getValueOrUndefined(c._imageSubRegion,e,boundingRectangleScratch);defined(h)&&u.setImageSubRegion(u._imageId,h)}else returnPrimitive(s,l,i)}return!0},BillboardVisualizer.prototype.getBoundingSphere=function(e,t){var i=this._items.get(e.id);if(!defined(i)||!defined(i.billboard))return BoundingSphereState$1.FAILED;var r=i.billboard;if(r.heightReference===HeightReference$1.NONE)t.center=Cartesian3.clone(r.position,t.center);else{if(!defined(r._clampedPosition))return BoundingSphereState$1.PENDING;t.center=Cartesian3.clone(r._clampedPosition,t.center)}return t.radius=0,BoundingSphereState$1.DONE},BillboardVisualizer.prototype.isDestroyed=function(){return!1},BillboardVisualizer.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(BillboardVisualizer.prototype._onCollectionChanged,this);for(var e=this._entityCollection.values,t=0;t<e.length;t++)this._cluster.removeBillboard(e[t]);return destroyObject(this)},BillboardVisualizer.prototype._onCollectionChanged=function(e,t,i,r){var n,a,o=this._items,s=this._cluster;for(n=t.length-1;-1<n;n--)defined((a=t[n])._billboard)&&defined(a._position)&&o.set(a.id,new EntityData(a));for(n=r.length-1;-1<n;n--)defined((a=r[n])._billboard)&&defined(a._position)?o.contains(a.id)||o.set(a.id,new EntityData(a)):(returnPrimitive(o.get(a.id),a,s),o.remove(a.id));for(n=i.length-1;-1<n;n--)a=i[n],returnPrimitive(o.get(a.id),a,s),o.remove(a.id)};var AllMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nmat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_bitangentEC);\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = tangentToEyeMatrix;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n",AllMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 bitangent;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_tangentEC = czm_normal * tangent;\nv_bitangentEC = czm_normal * bitangent;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BasicMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n",BasicMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",TexturedMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n",TexturedMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BlendEquation={ADD:WebGLConstants$1.FUNC_ADD,SUBTRACT:WebGLConstants$1.FUNC_SUBTRACT,REVERSE_SUBTRACT:WebGLConstants$1.FUNC_REVERSE_SUBTRACT,MIN:WebGLConstants$1.MIN,MAX:WebGLConstants$1.MAX},BlendEquation$1=freezeObject$1(BlendEquation),BlendFunction={ZERO:WebGLConstants$1.ZERO,ONE:WebGLConstants$1.ONE,SOURCE_COLOR:WebGLConstants$1.SRC_COLOR,ONE_MINUS_SOURCE_COLOR:WebGLConstants$1.ONE_MINUS_SRC_COLOR,DESTINATION_COLOR:WebGLConstants$1.DST_COLOR,ONE_MINUS_DESTINATION_COLOR:WebGLConstants$1.ONE_MINUS_DST_COLOR,SOURCE_ALPHA:WebGLConstants$1.SRC_ALPHA,ONE_MINUS_SOURCE_ALPHA:WebGLConstants$1.ONE_MINUS_SRC_ALPHA,DESTINATION_ALPHA:WebGLConstants$1.DST_ALPHA,ONE_MINUS_DESTINATION_ALPHA:WebGLConstants$1.ONE_MINUS_DST_ALPHA,CONSTANT_COLOR:WebGLConstants$1.CONSTANT_COLOR,ONE_MINUS_CONSTANT_COLOR:WebGLConstants$1.ONE_MINUS_CONSTANT_COLOR,CONSTANT_ALPHA:WebGLConstants$1.CONSTANT_ALPHA,ONE_MINUS_CONSTANT_ALPHA:WebGLConstants$1.ONE_MINUS_CONSTANT_ALPHA,SOURCE_ALPHA_SATURATE:WebGLConstants$1.SRC_ALPHA_SATURATE},BlendFunction$1=freezeObject$1(BlendFunction),BlendingState={DISABLED:freezeObject$1({enabled:!1}),ALPHA_BLEND:freezeObject$1({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:freezeObject$1({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.ONE,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:freezeObject$1({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE,functionDestinationAlpha:BlendFunction$1.ONE})},BlendingState$1=freezeObject$1(BlendingState),CullFace={FRONT:WebGLConstants$1.FRONT,BACK:WebGLConstants$1.BACK,FRONT_AND_BACK:WebGLConstants$1.FRONT_AND_BACK},CullFace$1=freezeObject$1(CullFace);function Appearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.material=e.material,this.translucent=defaultValue(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=defaultValue(e.closed,!1)}defineProperties$1(Appearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}}),Appearance.prototype.getFragmentShaderSource=function(){var e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),defined(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join("\n")},Appearance.prototype.isTranslucent=function(){return defined(this.material)&&this.material.isTranslucent()||!defined(this.material)&&this.translucent},Appearance.prototype.getRenderState=function(){var e=this.isTranslucent(),t=clone(this.renderState,!1);return e?(t.depthMask=!1,t.blending=BlendingState$1.ALPHA_BLEND):t.depthMask=!0,t},Appearance.getDefaultRenderState=function(e,t,i){var r={depthTest:{enabled:!0}};return e&&(r.depthMask=!1,r.blending=BlendingState$1.ALPHA_BLEND),t&&(r.cull={enabled:!0,face:CullFace$1.BACK}),defined(i)&&(r=combine(i,r,!0)),r};var ContextLimits={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_highpFloatSupported:!1,_highpIntSupported:!1};function CubeMapFace(e,t,i,r,n,a,o,s,l,c){this._gl=e,this._texture=t,this._textureTarget=i,this._targetFace=r,this._pixelFormat=n,this._pixelDatatype=a,this._size=o,this._preMultiplyAlpha=s,this._flipY=l,this._initialized=c}defineProperties$1(ContextLimits,{maximumCombinedTextureImageUnits:{get:function(){return ContextLimits._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return ContextLimits._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return ContextLimits._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return ContextLimits._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return ContextLimits._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return ContextLimits._maximumTextureSize}},maximumVaryingVectors:{get:function(){return ContextLimits._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return ContextLimits._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return ContextLimits._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return ContextLimits._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return ContextLimits._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return ContextLimits._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){return ContextLimits._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return ContextLimits._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return ContextLimits._maximumViewportWidth}},maximumViewportHeight:{get:function(){return ContextLimits._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return ContextLimits._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return ContextLimits._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return ContextLimits._maximumColorAttachments}},highpFloatSupported:{get:function(){return ContextLimits._highpFloatSupported}},highpIntSupported:{get:function(){return ContextLimits._highpIntSupported}}}),defineProperties$1(CubeMapFace.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}}),CubeMapFace.prototype.copyFrom=function(e,t,i){t=defaultValue(t,0),i=defaultValue(i,0);var r=this._gl,n=this._textureTarget,a=this._targetFace;r.activeTexture(r.TEXTURE0),r.bindTexture(n,this._texture);var o=e.width,s=e.height,l=e.arrayBufferView,c=this._size,u=this._pixelFormat,d=this._pixelDatatype,h=this._preMultiplyAlpha,p=this._flipY,m=4;defined(l)&&(m=PixelFormat$1.alignmentInBytes(u,d,o)),r.pixelStorei(r.UNPACK_ALIGNMENT,m);var f=!1;if(!this._initialized){if(0===t&&0===i&&o===c&&s===c)defined(l)?(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),p&&(l=PixelFormat$1.flipY(l,u,d,c,c)),r.texImage2D(a,0,u,c,c,0,u,d,l)):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,h),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,p),r.texImage2D(a,0,u,u,d,e)),f=!0;else{r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1);var g=PixelFormat$1.createTypedArray(u,d,c,c);r.texImage2D(a,0,u,c,c,0,u,d,g)}this._initialized=!0}f||(defined(l)?(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),p&&(l=PixelFormat$1.flipY(l,u,d,o,s)),r.texSubImage2D(a,0,t,i,o,s,u,d,l)):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,h),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,p),r.texSubImage2D(a,0,t,i,u,d,e))),r.bindTexture(n,null)},CubeMapFace.prototype.copyFromFramebuffer=function(e,t,i,r,n,a){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),n=defaultValue(n,this._size),a=defaultValue(a,this._size);var o=this._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.copyTexSubImage2D(this._targetFace,0,e,t,i,r,n,a),o.bindTexture(s,null),this._initialized=!0};var MipmapHint={DONT_CARE:WebGLConstants$1.DONT_CARE,FASTEST:WebGLConstants$1.FASTEST,NICEST:WebGLConstants$1.NICEST,validate:function(e){return e===MipmapHint.DONT_CARE||e===MipmapHint.FASTEST||e===MipmapHint.NICEST}},MipmapHint$1=freezeObject$1(MipmapHint),TextureMagnificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,validate:function(e){return e===TextureMagnificationFilter.NEAREST||e===TextureMagnificationFilter.LINEAR}},TextureMagnificationFilter$1=freezeObject$1(TextureMagnificationFilter),TextureMinificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,NEAREST_MIPMAP_NEAREST:WebGLConstants$1.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:WebGLConstants$1.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:WebGLConstants$1.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:WebGLConstants$1.LINEAR_MIPMAP_LINEAR,validate:function(e){return e===TextureMinificationFilter.NEAREST||e===TextureMinificationFilter.LINEAR||e===TextureMinificationFilter.NEAREST_MIPMAP_NEAREST||e===TextureMinificationFilter.LINEAR_MIPMAP_NEAREST||e===TextureMinificationFilter.NEAREST_MIPMAP_LINEAR||e===TextureMinificationFilter.LINEAR_MIPMAP_LINEAR}},TextureMinificationFilter$1=freezeObject$1(TextureMinificationFilter),TextureWrap={CLAMP_TO_EDGE:WebGLConstants$1.CLAMP_TO_EDGE,REPEAT:WebGLConstants$1.REPEAT,MIRRORED_REPEAT:WebGLConstants$1.MIRRORED_REPEAT,validate:function(e){return e===TextureWrap.CLAMP_TO_EDGE||e===TextureWrap.REPEAT||e===TextureWrap.MIRRORED_REPEAT}},TextureWrap$1=freezeObject$1(TextureWrap);function Sampler(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.wrapS,TextureWrap$1.CLAMP_TO_EDGE),i=defaultValue(e.wrapT,TextureWrap$1.CLAMP_TO_EDGE),r=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),n=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),a=defined(e.maximumAnisotropy)?e.maximumAnisotropy:1;this._wrapS=t,this._wrapT=i,this._minificationFilter=r,this._magnificationFilter=n,this._maximumAnisotropy=a}function CubeMap(e){var o,t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=e.source;if(defined(i)){var r=[i.positiveX,i.negativeX,i.positiveY,i.negativeY,i.positiveZ,i.negativeZ];o=r[0].width,r[0].height}else o=e.width,e.height;var s=o,l=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),c=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),n=6*PixelFormat$1.textureSizeInBytes(l,c,s,s),a=e.preMultiplyAlpha||l===PixelFormat$1.RGB||l===PixelFormat$1.LUMINANCE,u=defaultValue(e.flipY,!0),d=t._gl,h=d.TEXTURE_CUBE_MAP,p=d.createTexture();function m(e,t,i,r){var n=t.arrayBufferView;defined(n)||(n=t.bufferView);var a=4;defined(n)&&(a=PixelFormat$1.alignmentInBytes(l,c,o)),d.pixelStorei(d.UNPACK_ALIGNMENT,a),defined(n)?(d.pixelStorei(d.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),d.pixelStorei(d.UNPACK_FLIP_Y_WEBGL,!1),r&&(n=PixelFormat$1.flipY(n,l,c,s,s)),d.texImage2D(e,0,l,s,s,0,l,c,n)):(d.pixelStorei(d.UNPACK_PREMULTIPLY_ALPHA_WEBGL,i),d.pixelStorei(d.UNPACK_FLIP_Y_WEBGL,r),d.texImage2D(e,0,l,l,c,t))}d.activeTexture(d.TEXTURE0),d.bindTexture(h,p),defined(i)?(m(d.TEXTURE_CUBE_MAP_POSITIVE_X,i.positiveX,a,u),m(d.TEXTURE_CUBE_MAP_NEGATIVE_X,i.negativeX,a,u),m(d.TEXTURE_CUBE_MAP_POSITIVE_Y,i.positiveY,a,u),m(d.TEXTURE_CUBE_MAP_NEGATIVE_Y,i.negativeY,a,u),m(d.TEXTURE_CUBE_MAP_POSITIVE_Z,i.positiveZ,a,u),m(d.TEXTURE_CUBE_MAP_NEGATIVE_Z,i.negativeZ,a,u)):(d.texImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_X,0,l,s,s,0,l,c,null),d.texImage2D(d.TEXTURE_CUBE_MAP_NEGATIVE_X,0,l,s,s,0,l,c,null),d.texImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_Y,0,l,s,s,0,l,c,null),d.texImage2D(d.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,l,s,s,0,l,c,null),d.texImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_Z,0,l,s,s,0,l,c,null),d.texImage2D(d.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,l,s,s,0,l,c,null)),d.bindTexture(h,null),this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=h,this._texture=p,this._pixelFormat=l,this._pixelDatatype=c,this._size=s,this._hasMipmap=!1,this._sizeInBytes=n,this._preMultiplyAlpha=a,this._flipY=u,this._sampler=void 0;var f=defined(i);this._positiveX=new CubeMapFace(d,p,h,d.TEXTURE_CUBE_MAP_POSITIVE_X,l,c,s,a,u,f),this._negativeX=new CubeMapFace(d,p,h,d.TEXTURE_CUBE_MAP_NEGATIVE_X,l,c,s,a,u,f),this._positiveY=new CubeMapFace(d,p,h,d.TEXTURE_CUBE_MAP_POSITIVE_Y,l,c,s,a,u,f),this._negativeY=new CubeMapFace(d,p,h,d.TEXTURE_CUBE_MAP_NEGATIVE_Y,l,c,s,a,u,f),this._positiveZ=new CubeMapFace(d,p,h,d.TEXTURE_CUBE_MAP_POSITIVE_Z,l,c,s,a,u,f),this._negativeZ=new CubeMapFace(d,p,h,d.TEXTURE_CUBE_MAP_NEGATIVE_Z,l,c,s,a,u,f),this.sampler=defined(e.sampler)?e.sampler:new Sampler}function Texture(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=e.width,r=e.height,n=e.source;defined(n)&&(defined(i)||(i=defaultValue(n.videoWidth,n.width)),defined(r)||(r=defaultValue(n.videoHeight,n.height)));var a=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),o=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),s=a,l=PixelFormat$1.isCompressedFormat(s);if(t.webgl2)if(a===PixelFormat$1.DEPTH_STENCIL?s=WebGLConstants$1.DEPTH24_STENCIL8:a===PixelFormat$1.DEPTH_COMPONENT&&(o===PixelDatatype$1.UNSIGNED_SHORT?s=WebGLConstants$1.DEPTH_COMPONENT16:o===PixelDatatype$1.UNSIGNED_INT&&(s=WebGLConstants$1.DEPTH_COMPONENT24)),o===PixelDatatype$1.FLOAT)switch(a){case PixelFormat$1.RGBA:s=WebGLConstants$1.RGBA32F;break;case PixelFormat$1.RGB:s=WebGLConstants$1.RGB32F;break;case PixelFormat$1.RG:s=WebGLConstants$1.RG32F;break;case PixelFormat$1.R:s=WebGLConstants$1.R32F}else if(o===PixelDatatype$1.HALF_FLOAT)switch(a){case PixelFormat$1.RGBA:s=WebGLConstants$1.RGBA16F;break;case PixelFormat$1.RGB:s=WebGLConstants$1.RGB16F;break;case PixelFormat$1.RG:s=WebGLConstants$1.RG16F;break;case PixelFormat$1.R:s=WebGLConstants$1.R16F}var c=e.preMultiplyAlpha||a===PixelFormat$1.RGB||a===PixelFormat$1.LUMINANCE,u=defaultValue(e.flipY,!0),d=!0,h=t._gl,p=h.TEXTURE_2D,m=h.createTexture();h.activeTexture(h.TEXTURE0),h.bindTexture(p,m);var f,g=4;if(defined(n)&&defined(n.arrayBufferView)&&!l&&(g=PixelFormat$1.alignmentInBytes(a,o,i)),h.pixelStorei(h.UNPACK_ALIGNMENT,g),defined(n))if(defined(n.arrayBufferView)){h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,!1);var _=n.arrayBufferView;l?h.compressedTexImage2D(p,0,s,i,r,0,_):(u&&(_=PixelFormat$1.flipY(_,a,o,i,r)),h.texImage2D(p,0,s,i,r,0,a,o,_))}else defined(n.framebuffer)?(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,!1),n.framebuffer!==t.defaultFramebuffer&&n.framebuffer._bind(),h.copyTexImage2D(p,0,s,n.xOffset,n.yOffset,i,r,0),n.framebuffer!==t.defaultFramebuffer&&n.framebuffer._unBind()):(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,c),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,u),h.texImage2D(p,0,s,a,o,n));else h.texImage2D(p,0,s,i,r,0,a,o,null),d=!1;h.bindTexture(p,null),f=l?PixelFormat$1.compressedTextureSizeInBytes(a,i,r):PixelFormat$1.textureSizeInBytes(a,o,i,r),this._id=createGuid(),this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=p,this._texture=m,this._pixelFormat=a,this._pixelDatatype=o,this._width=i,this._height=r,this._dimensions=new Cartesian2(i,r),this._hasMipmap=!1,this._sizeInBytes=f,this._preMultiplyAlpha=c,this._flipY=u,this._initialized=d,this._sampler=void 0,this.sampler=defined(e.sampler)?e.sampler:new Sampler}defineProperties$1(Sampler.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}}),Sampler.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._wrapS===t._wrapS&&e._wrapT===t._wrapT&&e._minificationFilter===t._minificationFilter&&e._magnificationFilter===t._magnificationFilter&&e._maximumAnisotropy===t._maximumAnisotropy},defineProperties$1(CubeMap.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,r=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR,n=this._context,a=this._pixelDatatype;(a===PixelDatatype$1.FLOAT&&!n.textureFloatLinear||a===PixelDatatype$1.HALF_FLOAT&&!n.textureHalfFloatLinear)&&(t=r?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST);var o=n._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.texParameteri(s,o.TEXTURE_MIN_FILTER,t),o.texParameteri(s,o.TEXTURE_MAG_FILTER,i),o.texParameteri(s,o.TEXTURE_WRAP_S,e.wrapS),o.texParameteri(s,o.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&o.texParameteri(s,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),o.bindTexture(s,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}}),CubeMap.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;var t=this._context._gl,i=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(i,this._texture),t.generateMipmap(i),t.bindTexture(i,null)},CubeMap.prototype.isDestroyed=function(){return!1},CubeMap.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),this._positiveX=destroyObject(this._positiveX),this._negativeX=destroyObject(this._negativeX),this._positiveY=destroyObject(this._positiveY),this._negativeY=destroyObject(this._negativeY),this._positiveZ=destroyObject(this._positiveZ),this._negativeZ=destroyObject(this._negativeZ),destroyObject(this)},Texture.create=function(e){return new Texture(e)},Texture.fromFramebuffer=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=t._gl,r=defaultValue(e.pixelFormat,PixelFormat$1.RGB),n=defaultValue(e.framebufferXOffset,0),a=defaultValue(e.framebufferYOffset,0),o=defaultValue(e.width,i.drawingBufferWidth),s=defaultValue(e.height,i.drawingBufferHeight),l=e.framebuffer;return new Texture({context:t,width:o,height:s,pixelFormat:r,source:{framebuffer:defined(l)?l:t.defaultFramebuffer,xOffset:n,yOffset:a,width:o,height:s}})},defineProperties$1(Texture.prototype,{id:{get:function(){return this._id}},sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,r=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR,n=this._context,a=this._pixelDatatype;(a===PixelDatatype$1.FLOAT&&!n.textureFloatLinear||a===PixelDatatype$1.HALF_FLOAT&&!n.textureHalfFloatLinear)&&(t=r?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST);var o=n._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.texParameteri(s,o.TEXTURE_MIN_FILTER,t),o.texParameteri(s,o.TEXTURE_MAG_FILTER,i),o.texParameteri(s,o.TEXTURE_WRAP_S,e.wrapS),o.texParameteri(s,o.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&o.texParameteri(s,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),o.bindTexture(s,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},_target:{get:function(){return this._textureTarget}}}),Texture.prototype.copyFrom=function(e,t,i){t=defaultValue(t,0),i=defaultValue(i,0);var r=this._context._gl,n=this._textureTarget;r.activeTexture(r.TEXTURE0),r.bindTexture(n,this._texture);var a=e.width,o=e.height,s=e.arrayBufferView,l=this._width,c=this._height,u=this._pixelFormat,d=this._pixelDatatype,h=this._preMultiplyAlpha,p=this._flipY,m=4;defined(s)&&(m=PixelFormat$1.alignmentInBytes(u,d,a)),r.pixelStorei(r.UNPACK_ALIGNMENT,m);var f=!1;if(!this._initialized){if(0===t&&0===i&&a===l&&o===c)defined(s)?(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),p&&(s=PixelFormat$1.flipY(s,u,d,l,c)),r.texImage2D(n,0,u,l,c,0,u,d,s)):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,h),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,p),r.texImage2D(n,0,u,u,d,e)),f=!0;else{r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1);var g=PixelFormat$1.createTypedArray(u,d,l,c);r.texImage2D(n,0,u,l,c,0,u,d,g)}this._initialized=!0}f||(defined(s)?(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),p&&(s=PixelFormat$1.flipY(s,u,d,a,o)),r.texSubImage2D(n,0,t,i,a,o,u,d,s)):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,h),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,p),r.texSubImage2D(n,0,t,i,u,d,e))),r.bindTexture(n,null)},Texture.prototype.copyFromFramebuffer=function(e,t,i,r,n,a){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),n=defaultValue(n,this._width),a=defaultValue(a,this._height);var o=this._context._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.copyTexSubImage2D(s,0,e,t,i,r,n,a),o.bindTexture(s,null),this._initialized=!0},Texture.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;var t=this._context._gl,i=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(i,this._texture),t.generateMipmap(i),t.bindTexture(i,null)},Texture.prototype.isDestroyed=function(){return!1},Texture.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),destroyObject(this)};var AspectRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.aspect / (2.0 * czm_pi), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",BumpMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 centerPixel = fract(repeat * st);\nfloat centerBump = texture2D(image, centerPixel).channel;\nfloat imageWidth = float(imageDimensions.x);\nvec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\nfloat rightBump = texture2D(image, rightPixel).channel;\nfloat imageHeight = float(imageDimensions.y);\nvec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\nfloat topBump = texture2D(image, leftPixel).channel;\nvec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nmaterial.diffuse = vec3(0.01);\nreturn material;\n}\n",CheckerboardMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);\nfloat scaledWidth = fract(repeat.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(repeat.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value = min(scaledWidth, scaledHeight);\nvec4 currentColor = mix(lightColor, darkColor, b);\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",DotMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));\nvec4 color = mix(lightColor, darkColor, b);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationContourMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float spacing;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat distanceToContour = mod(materialInput.height, spacing);\n#ifdef GL_OES_standard_derivatives\nfloat dxc = abs(dFdx(materialInput.height));\nfloat dyc = abs(dFdy(materialInput.height));\nfloat dF = max(dxc, dyc) * czm_pixelRatio * width;\nfloat alpha = (distanceToContour < dF) ? 1.0 : 0.0;\n#else\nfloat alpha = (distanceToContour < (czm_pixelRatio * width)) ? 1.0 : 0.0;\n#endif\nvec4 outColor = czm_gammaCorrect(vec4(color.rgb, alpha));\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",ElevationRampMaterial="uniform sampler2D image;\nuniform float minimumHeight;\nuniform float maximumHeight;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat scaledHeight = clamp((materialInput.height - minimumHeight) / (maximumHeight - minimumHeight), 0.0, 1.0);\nvec4 rampColor = texture2D(image, vec2(scaledHeight, 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",FadeMaterial="uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\nfloat getTime(float t, float coord)\n{\nfloat scalar = 1.0 / maximumDistance;\nfloat q  = distance(t, coord) * scalar;\nif (repeat)\n{\nfloat r = distance(t, coord + 1.0) * scalar;\nfloat s = distance(t, coord - 1.0) * scalar;\nq = min(min(r, s), q);\n}\nreturn clamp(q, 0.0, 1.0);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat s = getTime(time.x, st.s) * fadeDirection.s;\nfloat t = getTime(time.y, st.t) * fadeDirection.t;\nfloat u = length(vec2(s, t));\nvec4 color = mix(fadeInColor, fadeOutColor, u);\ncolor = czm_gammaCorrect(color);\nmaterial.emission = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",GridMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nuniform vec2 lineOffset;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat scaledWidth = fract(lineCount.s * st.s - lineOffset.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(lineCount.t * st.t - lineOffset.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value;\n#ifdef GL_OES_standard_derivatives\nconst float fuzz = 1.2;\nvec2 thickness = (lineThickness * czm_pixelRatio) - 1.0;\nvec2 dx = abs(dFdx(st));\nvec2 dy = abs(dFdy(st));\nvec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\nvalue = min(\nsmoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\nsmoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\nconst float fuzz = 0.05;\nvec2 range = 0.5 - (lineThickness * 0.05);\nvalue = min(\n1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\nfloat dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));\nfloat sRim = smoothstep(0.8, 1.0, dRim);\nvalue *= (1.0 - sRim);\nvec4 halfColor;\nhalfColor.rgb = color.rgb * 0.5;\nhalfColor.a = color.a * (1.0 - ((1.0 - cellAlpha) * value));\nhalfColor = czm_gammaCorrect(halfColor);\nmaterial.diffuse = halfColor.rgb;\nmaterial.emission = halfColor.rgb;\nmaterial.alpha = halfColor.a;\nreturn material;\n}\n",NormalMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\nvec3 normalTangentSpace = textureValue.channels;\nnormalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\nnormalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\nnormalTangentSpace = normalize(normalTangentSpace);\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nreturn material;\n}\n",PolylineArrowMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nvarying float v_width;\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\nfloat slope = (p0.y - p1.y) / (p0.x - p1.x);\nreturn slope * (x - p0.x) + p0.y;\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\n#ifdef GL_OES_standard_derivatives\nfloat base = 1.0 - abs(fwidth(st.s)) * 10.0 * czm_pixelRatio;\n#else\nfloat base = 0.975;\n#endif\nvec2 center = vec2(1.0, 0.5);\nfloat ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\nfloat ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\nfloat halfWidth = 0.15;\nfloat s = step(0.5 - halfWidth, st.t);\ns *= 1.0 - step(0.5 + halfWidth, st.t);\ns *= 1.0 - step(base, st.s);\nfloat t = step(base, materialInput.st.s);\nt *= 1.0 - step(ptOnUpperLine, st.t);\nt *= step(ptOnLowerLine, st.t);\nfloat dist;\nif (st.s < base)\n{\nfloat d1 = abs(st.t - (0.5 - halfWidth));\nfloat d2 = abs(st.t - (0.5 + halfWidth));\ndist = min(d1, d2);\n}\nelse\n{\nfloat d1 = czm_infinity;\nif (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n{\nd1 = abs(st.s - base);\n}\nfloat d2 = abs(st.t - ptOnUpperLine);\nfloat d3 = abs(st.t - ptOnLowerLine);\ndist = min(min(d1, d2), d3);\n}\nvec4 outsideColor = vec4(0.0);\nvec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\nvec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",PolylineDashMaterial="uniform vec4 color;\nuniform vec4 gapColor;\nuniform float dashLength;\nuniform float dashPattern;\nvarying float v_polylineAngle;\nconst float maskLength = 16.0;\nmat2 rotate(float rad) {\nfloat c = cos(rad);\nfloat s = sin(rad);\nreturn mat2(\nc, s,\n-s, c\n);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 pos = rotate(v_polylineAngle) * gl_FragCoord.xy;\nfloat dashPosition = fract(pos.x / (dashLength * czm_pixelRatio));\nfloat maskIndex = floor(dashPosition * maskLength);\nfloat maskTest = floor(dashPattern / pow(2.0, maskIndex));\nvec4 fragColor = (mod(maskTest, 2.0) < 1.0) ? gapColor : color;\nif (fragColor.a < 0.005) {\ndiscard;\n}\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineGlowMaterial="uniform vec4 color;\nuniform float glowPower;\nuniform float taperPower;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);\nif (taperPower <= 0.99999) {\nglow *= min(1.0, taperPower / (0.5 - st.s * 0.5) - (taperPower / 0.5));\n}\nvec4 fragColor;\nfragColor.rgb = max(vec3(glow - 1.0 + color.rgb), color.rgb);\nfragColor.a = clamp(0.0, 1.0, glow) * color.a;\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineOutlineMaterial="uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\nfloat b = step(0.5 - halfInteriorWidth, st.t);\nb *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\nfloat d1 = abs(st.t - (0.5 - halfInteriorWidth));\nfloat d2 = abs(st.t - (0.5 + halfInteriorWidth));\nfloat dist = min(d1, d2);\nvec4 currentColor = mix(outlineColor, color, b);\nvec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",RimLightingMaterial="uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat s = smoothstep(1.0 - width, 1.0, d);\nvec4 outColor = czm_gammaCorrect(color);\nvec4 outRimColor = czm_gammaCorrect(rimColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.emission = outRimColor.rgb * s;\nmaterial.alpha = mix(outColor.a, outRimColor.a, s);\nreturn material;\n}\n",SlopeRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.slope / (czm_pi / 2.0), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",StripeMaterial="uniform vec4 evenColor;\nuniform vec4 oddColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\nfloat value = fract((coord - offset) * (repeat * 0.5));\nfloat dist = min(value, min(abs(value - 0.5), 1.0 - value));\nvec4 currentColor = mix(evenColor, oddColor, step(0.5, value));\nvec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",WaterMaterial="uniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat time = czm_frameNumber * animationSpeed;\nfloat fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\nfloat specularMapValue = texture2D(specularMap, materialInput.st).r;\nvec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\nnormalTangentSpace.xy /= fade;\nnormalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\nnormalTangentSpace = normalize(normalTangentSpace);\nfloat tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\nmaterial.alpha = specularMapValue;\nmaterial.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\nmaterial.diffuse += (0.1 * tsPerturbationRatio);\nmaterial.diffuse = material.diffuse;\nmaterial.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\nmaterial.specular = specularIntensity;\nmaterial.shininess = 10.0;\nreturn material;\n}\n";function Material(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],this._defaultTexture=void 0,initializeMaterial(e,this),defineProperties$1(this,{type:{value:this.type,writable:!1}}),defined(Material._uniformList[this.type])||(Material._uniformList[this.type]=Object.keys(this._uniforms))}function initializeMaterial(e,t){var i;e=defaultValue(e,defaultValue.EMPTY_OBJECT),t._strict=defaultValue(e.strict,!1),t._count=defaultValue(e.count,0),t._template=clone(defaultValue(e.fabric,defaultValue.EMPTY_OBJECT)),t._template.uniforms=clone(defaultValue(t._template.uniforms,defaultValue.EMPTY_OBJECT)),t._template.materials=clone(defaultValue(t._template.materials,defaultValue.EMPTY_OBJECT)),t.type=defined(t._template.type)?t._template.type:createGuid(),t.shaderSource="",t.materials={},t.uniforms={},t._uniforms={},t._translucentFunctions=[];var r=Material._materialCache.getMaterial(t.type);if(defined(r)){var n=clone(r.fabric,!0);t._template=combine(t._template,n,!0),i=r.translucent}checkForTemplateErrors(t),defined(r)||Material._materialCache.addMaterial(t.type,t),createMethodDefinition(t),createUniforms(t),createSubMaterials(t);var a=0===t._translucentFunctions.length||void 0;if(i=defaultValue(i,a),defined(i=defaultValue(e.translucent,i)))if("function"==typeof i){t._translucentFunctions.push(function(){return i(t)})}else t._translucentFunctions.push(i)}function checkForValidProperties(e,t,i,r){if(defined(e))for(var n in e)if(e.hasOwnProperty(n)){var a=-1!==t.indexOf(n);(r&&!a||!r&&a)&&i(n,t)}}function invalidNameError(e,t){}function duplicateNameError(e,t){}Material._uniformList={},Material.fromType=function(e,t){var i=new Material({fabric:{type:e}});if(defined(t))for(var r in t)t.hasOwnProperty(r)&&(i.uniforms[r]=t[r]);return i},Material.prototype.isTranslucent=function(){if(defined(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;for(var e=!0,t=this._translucentFunctions,i=t.length,r=0;r<i;++r){var n=t[r];if(!(e="function"==typeof n?e&&n():e&&n))break}return e},Material.prototype.update=function(e){var t,i,r=this._loadedImages,n=r.length;for(t=0;t<n;++t){var a=r[t];i=a.id;var o,s=a.image;o=defined(s.internalFormat)?new Texture({context:e,pixelFormat:s.internalFormat,width:s.width,height:s.height,source:{arrayBufferView:s.bufferView}}):new Texture({context:e,source:s}),this._textures[i]=o;var l=i+"Dimensions";if(this.uniforms.hasOwnProperty(l)){var c=this.uniforms[l];c.x=o._width,c.y=o._height}}r.length=0;var u=this._loadedCubeMaps;for(n=u.length,t=0;t<n;++t){var d=u[t];i=d.id;var h=d.images,p=new CubeMap({context:e,source:{positiveX:h[0],negativeX:h[1],positiveY:h[2],negativeY:h[3],positiveZ:h[4],negativeZ:h[5]}});this._textures[i]=p}u.length=0;var m=this._updateFunctions;for(n=m.length,t=0;t<n;++t)m[t](this,e);var f=this.materials;for(var g in f)f.hasOwnProperty(g)&&f[g].update(e)},Material.prototype.isDestroyed=function(){return!1},Material.prototype.destroy=function(){var e=this._textures;for(var t in e)if(e.hasOwnProperty(t)){var i=e[t];i!==this._defaultTexture&&i.destroy()}var r=this.materials;for(var n in r)r.hasOwnProperty(n)&&r[n].destroy();return destroyObject(this)};var templateProperties=["type","materials","uniforms","components","source"],componentProperties=["diffuse","specular","shininess","normal","emission","alpha"];function checkForTemplateErrors(e){var t=e._template,i=t.uniforms,r=t.materials,n=t.components;checkForValidProperties(t,templateProperties,invalidNameError,!0),checkForValidProperties(n,componentProperties,invalidNameError,!0);var a=[];for(var o in r)r.hasOwnProperty(o)&&a.push(o);checkForValidProperties(i,a,duplicateNameError,!1)}function isMaterialFused(e,t){var i=t._template.materials;for(var r in i)if(i.hasOwnProperty(r)&&-1<e.indexOf(r))return!0;return!1}function createMethodDefinition(e){var t=e._template.components,i=e._template.source;if(defined(i))e.shaderSource+=i+"\n";else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",defined(t)){var r=0<Object.keys(e._template.materials).length;for(var n in t)if(t.hasOwnProperty(n))if("diffuse"===n||"emission"===n){var a=r&&isMaterialFused(t[n],e)?t[n]:"czm_gammaCorrect("+t[n]+")";e.shaderSource+="material."+n+" = "+a+"; \n"}else e.shaderSource+="alpha"===n?"material.alpha = "+t.alpha+"; \n":"material."+n+" = "+t[n]+";\n"}e.shaderSource+="return material;\n}\n"}}var matrixMap={mat2:Matrix2,mat3:Matrix3,mat4:Matrix4},ktxRegex=/\.ktx$/i,crnRegex=/\.crn$/i;function createTexture2DUpdateFunction(d){var h;return function(t,e){var i=t.uniforms,r=i[d],n=h!==r;h=r;var a,o,s=t._textures[d];if(r instanceof HTMLVideoElement)if(2<=r.readyState){if(n&&defined(s)&&(s!==e.defaultTexture&&s.destroy(),s=void 0),!defined(s)||s===e.defaultTexture)return s=new Texture({context:e,source:r}),void(t._textures[d]=s);s.copyFrom(r)}else defined(s)||(t._textures[d]=e.defaultTexture);else{if(r instanceof Texture&&r!==s){t._texturePaths[d]=void 0;var l=t._textures[d];return l!==t._defaultTexture&&l.destroy(),t._textures[d]=r,a=d+"Dimensions",void(i.hasOwnProperty(a)&&((o=i[a]).x=r._width,o.y=r._height))}if(defined(s)||(t._texturePaths[d]=void 0,defined(t._defaultTexture)||(t._defaultTexture=e.defaultTexture),s=t._textures[d]=t._defaultTexture,a=d+"Dimensions",i.hasOwnProperty(a)&&((o=i[a]).x=s._width,o.y=s._height)),r!==Material.DefaultImageId){var c=r instanceof Resource;if(!defined(t._texturePaths[d])||c&&r.url!==t._texturePaths[d].url||!c&&r!==t._texturePaths[d]){if("string"==typeof r||c){var u=c?r:Resource.createIfNeeded(r);when(ktxRegex.test(u.url)?loadKTX(u):crnRegex.test(u.url)?loadCRN(u):u.fetchImage(),function(e){t._loadedImages.push({id:d,image:e})})}else(r instanceof HTMLCanvasElement||r instanceof HTMLImageElement)&&t._loadedImages.push({id:d,image:r});t._texturePaths[d]=r}}}}}function createCubeMapUpdateFunction(o){return function(t,e){var i=t.uniforms[o];if(i instanceof CubeMap){var r=t._textures[o];return r!==t._defaultTexture&&r.destroy(),t._texturePaths[o]=void 0,void(t._textures[o]=i)}if(defined(t._textures[o])||(t._texturePaths[o]=void 0,t._textures[o]=e.defaultCubeMap),i!==Material.DefaultCubeMapId){var n=i.positiveX+i.negativeX+i.positiveY+i.negativeY+i.positiveZ+i.negativeZ;if(n!==t._texturePaths[o]){var a=[Resource.createIfNeeded(i.positiveX).fetchImage(),Resource.createIfNeeded(i.negativeX).fetchImage(),Resource.createIfNeeded(i.positiveY).fetchImage(),Resource.createIfNeeded(i.negativeY).fetchImage(),Resource.createIfNeeded(i.positiveZ).fetchImage(),Resource.createIfNeeded(i.negativeZ).fetchImage()];when.all(a).then(function(e){t._loadedCubeMaps.push({id:o,images:e})}),t._texturePaths[o]=n}}}}function createUniforms(e){var t=e._template.uniforms;for(var i in t)t.hasOwnProperty(i)&&createUniform(e,i)}function createUniform(e,t){e._strict;var i=e._template.uniforms,r=i[t],n=getUniformType(r);if("channels"===n)replaceToken(e,t,r,!1);else{if("sampler2D"===n){var a=t+"Dimensions";0<getNumberOfTokens(e,a)&&(i[a]={type:"ivec3",x:1,y:1},createUniform(e,a))}if(!new RegExp("uniform\\s+"+n+"\\s+"+t+"\\s*;").test(e.shaderSource)){var o="uniform "+n+" "+t+";";e.shaderSource=o+e.shaderSource}var s=t+"_"+e._count++;if(replaceToken(e,t,s),e.uniforms[t]=r,"sampler2D"===n)e._uniforms[s]=function(){return e._textures[t]},e._updateFunctions.push(createTexture2DUpdateFunction(t));else if("samplerCube"===n)e._uniforms[s]=function(){return e._textures[t]},e._updateFunctions.push(createCubeMapUpdateFunction(t));else if(-1!==n.indexOf("mat")){var l=new matrixMap[n];e._uniforms[s]=function(){return matrixMap[n].fromColumnMajorArray(e.uniforms[t],l)}}else e._uniforms[s]=function(){return e.uniforms[t]}}}function getUniformType(e){var t=e.type;if(!defined(t)){var i=typeof e;if("number"==i)t="float";else if("boolean"==i)t="bool";else if("string"==i||e instanceof Resource||e instanceof HTMLCanvasElement||e instanceof HTMLImageElement)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===Material.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"==i)if(isArray$1(e))4!==e.length&&9!==e.length&&16!==e.length||(t="mat"+Math.sqrt(e.length));else{var r=0;for(var n in e)e.hasOwnProperty(n)&&(r+=1);2<=r&&r<=4?t="vec"+r:6===r&&(t="samplerCube")}}return t}function createSubMaterials(e){var t=e._strict,i=e._template.materials;for(var r in i)if(i.hasOwnProperty(r)){var n=new Material({strict:t,fabric:i[r],count:e._count});e._count=n._count,e._uniforms=combine(e._uniforms,n._uniforms,!0),e.materials[r]=n,e._translucentFunctions=e._translucentFunctions.concat(n._translucentFunctions);var a="czm_getMaterial",o=a+"_"+e._count++;replaceToken(n,a,o),e.shaderSource=n.shaderSource+e.shaderSource;replaceToken(e,r,o+"(materialInput)")}}function replaceToken(e,t,r,i){i=defaultValue(i,!0);var n=0,a=new RegExp("([\\w"+(i?".":"")+"])?"+t+"([\\w])?","g");return e.shaderSource=e.shaderSource.replace(a,function(e,t,i){return t||i?e:(n+=1,r)}),n}function getNumberOfTokens(e,t,i){return replaceToken(e,t,t,i)}function MaterialAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.translucent,!0),i=defaultValue(e.closed,!1),r=defaultValue(e.materialSupport,MaterialAppearance.MaterialSupport.TEXTURED);this.material=defined(e.material)?e.material:Material.fromType(Material.ColorType),this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,r.vertexShaderSource),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,r.fragmentShaderSource),this._renderState=Appearance.getDefaultRenderState(t,i,e.renderState),this._closed=i,this._materialSupport=r,this._vertexFormat=r.vertexFormat,this._flat=defaultValue(e.flat,!1),this._faceForward=defaultValue(e.faceForward,!i)}Material._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},Material.DefaultImageId="czm_defaultImage",Material.DefaultCubeMapId="czm_defaultCubeMap",Material.ColorType="Color",Material._materialCache.addMaterial(Material.ColorType,{fabric:{type:Material.ColorType,uniforms:{color:new Color(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material.ImageType="Image",Material._materialCache.addMaterial(Material.ImageType,{fabric:{type:Material.ImageType,uniforms:{image:Material.DefaultImageId,repeat:new Cartesian2(1,1),color:new Color(1,1,1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb * color.rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a * color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material.DiffuseMapType="DiffuseMap",Material._materialCache.addMaterial(Material.DiffuseMapType,{fabric:{type:Material.DiffuseMapType,uniforms:{image:Material.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material.AlphaMapType="AlphaMap",Material._materialCache.addMaterial(Material.AlphaMapType,{fabric:{type:Material.AlphaMapType,uniforms:{image:Material.DefaultImageId,channel:"a",repeat:new Cartesian2(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),Material.SpecularMapType="SpecularMap",Material._materialCache.addMaterial(Material.SpecularMapType,{fabric:{type:Material.SpecularMapType,uniforms:{image:Material.DefaultImageId,channel:"r",repeat:new Cartesian2(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),Material.EmissionMapType="EmissionMap",Material._materialCache.addMaterial(Material.EmissionMapType,{fabric:{type:Material.EmissionMapType,uniforms:{image:Material.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material.BumpMapType="BumpMap",Material._materialCache.addMaterial(Material.BumpMapType,{fabric:{type:Material.BumpMapType,uniforms:{image:Material.DefaultImageId,channel:"r",strength:.8,repeat:new Cartesian2(1,1)},source:BumpMapMaterial},translucent:!1}),Material.NormalMapType="NormalMap",Material._materialCache.addMaterial(Material.NormalMapType,{fabric:{type:Material.NormalMapType,uniforms:{image:Material.DefaultImageId,channels:"rgb",strength:.8,repeat:new Cartesian2(1,1)},source:NormalMapMaterial},translucent:!1}),Material.GridType="Grid",Material._materialCache.addMaterial(Material.GridType,{fabric:{type:Material.GridType,uniforms:{color:new Color(0,1,0,1),cellAlpha:.1,lineCount:new Cartesian2(8,8),lineThickness:new Cartesian2(1,1),lineOffset:new Cartesian2(0,0)},source:GridMaterial},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.cellAlpha<1}}),Material.StripeType="Stripe",Material._materialCache.addMaterial(Material.StripeType,{fabric:{type:Material.StripeType,uniforms:{horizontal:!0,evenColor:new Color(1,1,1,.5),oddColor:new Color(0,0,1,.5),offset:0,repeat:5},source:StripeMaterial},translucent:function(e){var t=e.uniforms;return t.evenColor.alpha<1||t.oddColor.alpha<1}}),Material.CheckerboardType="Checkerboard",Material._materialCache.addMaterial(Material.CheckerboardType,{fabric:{type:Material.CheckerboardType,uniforms:{lightColor:new Color(1,1,1,.5),darkColor:new Color(0,0,0,.5),repeat:new Cartesian2(5,5)},source:CheckerboardMaterial},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<1}}),Material.DotType="Dot",Material._materialCache.addMaterial(Material.DotType,{fabric:{type:Material.DotType,uniforms:{lightColor:new Color(1,1,0,.75),darkColor:new Color(0,1,1,.75),repeat:new Cartesian2(5,5)},source:DotMaterial},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<1}}),Material.WaterType="Water",Material._materialCache.addMaterial(Material.WaterType,{fabric:{type:Material.WaterType,uniforms:{baseWaterColor:new Color(.2,.3,.6,1),blendColor:new Color(0,1,.699,1),specularMap:Material.DefaultImageId,normalMap:Material.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:WaterMaterial},translucent:function(e){var t=e.uniforms;return t.baseWaterColor.alpha<1||t.blendColor.alpha<1}}),Material.RimLightingType="RimLighting",Material._materialCache.addMaterial(Material.RimLightingType,{fabric:{type:Material.RimLightingType,uniforms:{color:new Color(1,0,0,.7),rimColor:new Color(1,1,1,.4),width:.3},source:RimLightingMaterial},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.rimColor.alpha<1}}),Material.FadeType="Fade",Material._materialCache.addMaterial(Material.FadeType,{fabric:{type:Material.FadeType,uniforms:{fadeInColor:new Color(1,0,0,1),fadeOutColor:new Color(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new Cartesian2(.5,.5)},source:FadeMaterial},translucent:function(e){var t=e.uniforms;return t.fadeInColor.alpha<1||t.fadeOutColor.alpha<1}}),Material.PolylineArrowType="PolylineArrow",Material._materialCache.addMaterial(Material.PolylineArrowType,{fabric:{type:Material.PolylineArrowType,uniforms:{color:new Color(1,1,1,1)},source:PolylineArrowMaterial},translucent:!0}),Material.PolylineDashType="PolylineDash",Material._materialCache.addMaterial(Material.PolylineDashType,{fabric:{type:Material.PolylineDashType,uniforms:{color:new Color(1,0,1,1),gapColor:new Color(0,0,0,0),dashLength:16,dashPattern:255},source:PolylineDashMaterial},translucent:!0}),Material.PolylineGlowType="PolylineGlow",Material._materialCache.addMaterial(Material.PolylineGlowType,{fabric:{type:Material.PolylineGlowType,uniforms:{color:new Color(0,.5,1,1),glowPower:.25,taperPower:1},source:PolylineGlowMaterial},translucent:!0}),Material.PolylineOutlineType="PolylineOutline",Material._materialCache.addMaterial(Material.PolylineOutlineType,{fabric:{type:Material.PolylineOutlineType,uniforms:{color:new Color(1,1,1,1),outlineColor:new Color(1,0,0,1),outlineWidth:1},source:PolylineOutlineMaterial},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.outlineColor.alpha<1}}),Material.ElevationContourType="ElevationContour",Material._materialCache.addMaterial(Material.ElevationContourType,{fabric:{type:Material.ElevationContourType,uniforms:{spacing:100,color:new Color(1,0,0,1),width:1},source:ElevationContourMaterial},translucent:!1}),Material.ElevationRampType="ElevationRamp",Material._materialCache.addMaterial(Material.ElevationRampType,{fabric:{type:Material.ElevationRampType,uniforms:{image:Material.DefaultImageId,minimumHeight:0,maximumHeight:1e4},source:ElevationRampMaterial},translucent:!1}),Material.SlopeRampMaterialType="SlopeRamp",Material._materialCache.addMaterial(Material.SlopeRampMaterialType,{fabric:{type:Material.SlopeRampMaterialType,uniforms:{image:Material.DefaultImageId},source:SlopeRampMaterial},translucent:!1}),Material.AspectRampMaterialType="AspectRamp",Material._materialCache.addMaterial(Material.AspectRampMaterialType,{fabric:{type:Material.AspectRampMaterialType,uniforms:{image:Material.DefaultImageId},source:AspectRampMaterial},translucent:!1}),defineProperties$1(MaterialAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},materialSupport:{get:function(){return this._materialSupport}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),MaterialAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,MaterialAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,MaterialAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,MaterialAppearance.MaterialSupport={BASIC:freezeObject$1({vertexFormat:VertexFormat.POSITION_AND_NORMAL,vertexShaderSource:BasicMaterialAppearanceVS,fragmentShaderSource:BasicMaterialAppearanceFS}),TEXTURED:freezeObject$1({vertexFormat:VertexFormat.POSITION_NORMAL_AND_ST,vertexShaderSource:TexturedMaterialAppearanceVS,fragmentShaderSource:TexturedMaterialAppearanceFS}),ALL:freezeObject$1({vertexFormat:VertexFormat.ALL,vertexShaderSource:AllMaterialAppearanceVS,fragmentShaderSource:AllMaterialAppearanceFS})};var PerInstanceColorAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nvec4 color = czm_gammaCorrect(v_color);\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getDefaultMaterial(materialInput);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n}\n",PerInstanceColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",PerInstanceFlatColorAppearanceFS="varying vec4 v_color;\nvoid main()\n{\ngl_FragColor = czm_gammaCorrect(v_color);\n}\n",PerInstanceFlatColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\nattribute float batchId;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n";function PerInstanceColorAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.translucent,!0),i=defaultValue(e.closed,!1),r=defaultValue(e.flat,!1),n=r?PerInstanceFlatColorAppearanceVS:PerInstanceColorAppearanceVS,a=r?PerInstanceFlatColorAppearanceFS:PerInstanceColorAppearanceFS,o=r?PerInstanceColorAppearance.FLAT_VERTEX_FORMAT:PerInstanceColorAppearance.VERTEX_FORMAT;this.material=void 0,this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,n),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,a),this._renderState=Appearance.getDefaultRenderState(t,i,e.renderState),this._closed=i,this._vertexFormat=o,this._flat=r,this._faceForward=defaultValue(e.faceForward,!i)}function ColorMaterialProperty(e){this._definitionChanged=new Event,this._color=void 0,this._colorSubscription=void 0,this.color=e}function DrawCommand(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._boundingVolume=e.boundingVolume,this._orientedBoundingBox=e.orientedBoundingBox,this._cull=defaultValue(e.cull,!0),this._occlude=defaultValue(e.occlude,!0),this._modelMatrix=e.modelMatrix,this._primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this._vertexArray=e.vertexArray,this._count=e.count,this._offset=defaultValue(e.offset,0),this._instanceCount=defaultValue(e.instanceCount,0),this._shaderProgram=e.shaderProgram,this._uniformMap=e.uniformMap,this._renderState=e.renderState,this._framebuffer=e.framebuffer,this._pass=e.pass,this._executeInClosestFrustum=defaultValue(e.executeInClosestFrustum,!1),this._owner=e.owner,this._debugShowBoundingVolume=defaultValue(e.debugShowBoundingVolume,!1),this._debugOverlappingFrustums=0,this._castShadows=defaultValue(e.castShadows,!1),this._receiveShadows=defaultValue(e.receiveShadows,!1),this._pickId=e.pickId,this._pickOnly=defaultValue(e.pickOnly,!1),this.dirty=!0,this.lastDirtyTime=0,this.derivedCommands={}}defineProperties$1(PerInstanceColorAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),PerInstanceColorAppearance.VERTEX_FORMAT=VertexFormat.POSITION_AND_NORMAL,PerInstanceColorAppearance.FLAT_VERTEX_FORMAT=VertexFormat.POSITION_ONLY,PerInstanceColorAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,PerInstanceColorAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,PerInstanceColorAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,defineProperties$1(ColorMaterialProperty.prototype,{isConstant:{get:function(){return Property.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:createPropertyDescriptor("color")}),ColorMaterialProperty.prototype.getType=function(e){return"Color"},ColorMaterialProperty.prototype.getValue=function(e,t){return defined(t)||(t={}),t.color=Property.getValueOrClonedDefault(this._color,e,Color.WHITE,t.color),t},ColorMaterialProperty.prototype.equals=function(e){return this===e||e instanceof ColorMaterialProperty&&Property.equals(this._color,e._color)},defineProperties$1(DrawCommand.prototype,{boundingVolume:{get:function(){return this._boundingVolume},set:function(e){this._boundingVolume!==e&&(this._boundingVolume=e,this.dirty=!0)}},orientedBoundingBox:{get:function(){return this._orientedBoundingBox},set:function(e){this._orientedBoundingBox!==e&&(this._orientedBoundingBox=e,this.dirty=!0)}},cull:{get:function(){return this._cull},set:function(e){this._cull!==e&&(this._cull=e,this.dirty=!0)}},occlude:{get:function(){return this._occlude},set:function(e){this._occlude!==e&&(this._occlude=e,this.dirty=!0)}},modelMatrix:{get:function(){return this._modelMatrix},set:function(e){this._modelMatrix!==e&&(this._modelMatrix=e,this.dirty=!0)}},primitiveType:{get:function(){return this._primitiveType},set:function(e){this._primitiveType!==e&&(this._primitiveType=e,this.dirty=!0)}},vertexArray:{get:function(){return this._vertexArray},set:function(e){this._vertexArray!==e&&(this._vertexArray=e,this.dirty=!0)}},count:{get:function(){return this._count},set:function(e){this._count!==e&&(this._count=e,this.dirty=!0)}},offset:{get:function(){return this._offset},set:function(e){this._offset!==e&&(this._offset=e,this.dirty=!0)}},instanceCount:{get:function(){return this._instanceCount},set:function(e){this._instanceCount!==e&&(this._instanceCount=e,this.dirty=!0)}},shaderProgram:{get:function(){return this._shaderProgram},set:function(e){this._shaderProgram!==e&&(this._shaderProgram=e,this.dirty=!0)}},castShadows:{get:function(){return this._castShadows},set:function(e){this._castShadows!==e&&(this._castShadows=e,this.dirty=!0)}},receiveShadows:{get:function(){return this._receiveShadows},set:function(e){this._receiveShadows!==e&&(this._receiveShadows=e,this.dirty=!0)}},uniformMap:{get:function(){return this._uniformMap},set:function(e){this._uniformMap!==e&&(this._uniformMap=e,this.dirty=!0)}},renderState:{get:function(){return this._renderState},set:function(e){this._renderState!==e&&(this._renderState=e,this.dirty=!0)}},framebuffer:{get:function(){return this._framebuffer},set:function(e){this._framebuffer!==e&&(this._framebuffer=e,this.dirty=!0)}},pass:{get:function(){return this._pass},set:function(e){this._pass!==e&&(this._pass=e,this.dirty=!0)}},executeInClosestFrustum:{get:function(){return this._executeInClosestFrustum},set:function(e){this._executeInClosestFrustum!==e&&(this._executeInClosestFrustum=e,this.dirty=!0)}},owner:{get:function(){return this._owner},set:function(e){this._owner!==e&&(this._owner=e,this.dirty=!0)}},debugShowBoundingVolume:{get:function(){return this._debugShowBoundingVolume},set:function(e){this._debugShowBoundingVolume!==e&&(this._debugShowBoundingVolume=e,this.dirty=!0)}},debugOverlappingFrustums:{get:function(){return this._debugOverlappingFrustums},set:function(e){this._debugOverlappingFrustums!==e&&(this._debugOverlappingFrustums=e,this.dirty=!0)}},pickId:{get:function(){return this._pickId},set:function(e){this._pickId!==e&&(this._pickId=e,this.dirty=!0)}},pickOnly:{get:function(){return this._pickOnly},set:function(e){this._pickOnly!==e&&(this._pickOnly=e,this.dirty=!0)}}}),DrawCommand.shallowClone=function(e,t){if(defined(e))return defined(t)||(t=new DrawCommand),t._boundingVolume=e._boundingVolume,t._orientedBoundingBox=e._orientedBoundingBox,t._cull=e._cull,t._occlude=e._occlude,t._modelMatrix=e._modelMatrix,t._primitiveType=e._primitiveType,t._vertexArray=e._vertexArray,t._count=e._count,t._offset=e._offset,t._instanceCount=e._instanceCount,t._shaderProgram=e._shaderProgram,t._uniformMap=e._uniformMap,t._renderState=e._renderState,t._framebuffer=e._framebuffer,t._pass=e._pass,t._executeInClosestFrustum=e._executeInClosestFrustum,t._owner=e._owner,t._debugShowBoundingVolume=e._debugShowBoundingVolume,t._debugOverlappingFrustums=e._debugOverlappingFrustums,t._castShadows=e._castShadows,t._receiveShadows=e._receiveShadows,t._pickId=e._pickId,t._pickOnly=e._pickOnly,t.dirty=!0,t.lastDirtyTime=0,t},DrawCommand.prototype.execute=function(e,t){e.draw(this,t)};var Pass={ENVIRONMENT:0,COMPUTE:1,GLOBE:2,TERRAIN_CLASSIFICATION:3,CESIUM_3D_TILE:4,CESIUM_3D_TILE_CLASSIFICATION:5,CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW:6,OPAQUE:7,TRANSLUCENT:8,OVERLAY:9,NUMBER_OF_PASSES:10},Pass$1=freezeObject$1(Pass);function freezeRenderState(e){if("object"!=typeof e||null===e)return e;for(var t,i=Object.keys(e),r=0;r<i.length;r++)t=i[r],e.hasOwnProperty(t)&&"_applyFunctions"!==t&&(e[t]=freezeRenderState(e[t]));return freezeObject$1(e)}function RenderState(e){var t=defaultValue(e,defaultValue.EMPTY_OBJECT),i=defaultValue(t.cull,defaultValue.EMPTY_OBJECT),r=defaultValue(t.polygonOffset,defaultValue.EMPTY_OBJECT),n=defaultValue(t.scissorTest,defaultValue.EMPTY_OBJECT),a=defaultValue(n.rectangle,defaultValue.EMPTY_OBJECT),o=defaultValue(t.depthRange,defaultValue.EMPTY_OBJECT),s=defaultValue(t.depthTest,defaultValue.EMPTY_OBJECT),l=defaultValue(t.colorMask,defaultValue.EMPTY_OBJECT),c=defaultValue(t.blending,defaultValue.EMPTY_OBJECT),u=defaultValue(c.color,defaultValue.EMPTY_OBJECT),d=defaultValue(t.stencilTest,defaultValue.EMPTY_OBJECT),h=defaultValue(d.frontOperation,defaultValue.EMPTY_OBJECT),p=defaultValue(d.backOperation,defaultValue.EMPTY_OBJECT),m=defaultValue(t.sampleCoverage,defaultValue.EMPTY_OBJECT),f=t.viewport;this.frontFace=defaultValue(t.frontFace,WindingOrder$1.COUNTER_CLOCKWISE),this.cull={enabled:defaultValue(i.enabled,!1),face:defaultValue(i.face,WebGLConstants$1.BACK)},this.lineWidth=defaultValue(t.lineWidth,1),this.polygonOffset={enabled:defaultValue(r.enabled,!1),factor:defaultValue(r.factor,0),units:defaultValue(r.units,0)},this.scissorTest={enabled:defaultValue(n.enabled,!1),rectangle:BoundingRectangle.clone(a)},this.depthRange={near:defaultValue(o.near,0),far:defaultValue(o.far,1)},this.depthTest={enabled:defaultValue(s.enabled,!1),func:defaultValue(s.func,WebGLConstants$1.LESS)},this.colorMask={red:defaultValue(l.red,!0),green:defaultValue(l.green,!0),blue:defaultValue(l.blue,!0),alpha:defaultValue(l.alpha,!0)},this.depthMask=defaultValue(t.depthMask,!0),this.stencilMask=defaultValue(t.stencilMask,-1),this.blending={enabled:defaultValue(c.enabled,!1),color:new Color(defaultValue(u.red,0),defaultValue(u.green,0),defaultValue(u.blue,0),defaultValue(u.alpha,0)),equationRgb:defaultValue(c.equationRgb,WebGLConstants$1.FUNC_ADD),equationAlpha:defaultValue(c.equationAlpha,WebGLConstants$1.FUNC_ADD),functionSourceRgb:defaultValue(c.functionSourceRgb,WebGLConstants$1.ONE),functionSourceAlpha:defaultValue(c.functionSourceAlpha,WebGLConstants$1.ONE),functionDestinationRgb:defaultValue(c.functionDestinationRgb,WebGLConstants$1.ZERO),functionDestinationAlpha:defaultValue(c.functionDestinationAlpha,WebGLConstants$1.ZERO)},this.stencilTest={enabled:defaultValue(d.enabled,!1),frontFunction:defaultValue(d.frontFunction,WebGLConstants$1.ALWAYS),backFunction:defaultValue(d.backFunction,WebGLConstants$1.ALWAYS),reference:defaultValue(d.reference,0),mask:defaultValue(d.mask,-1),frontOperation:{fail:defaultValue(h.fail,WebGLConstants$1.KEEP),zFail:defaultValue(h.zFail,WebGLConstants$1.KEEP),zPass:defaultValue(h.zPass,WebGLConstants$1.KEEP)},backOperation:{fail:defaultValue(p.fail,WebGLConstants$1.KEEP),zFail:defaultValue(p.zFail,WebGLConstants$1.KEEP),zPass:defaultValue(p.zPass,WebGLConstants$1.KEEP)}},this.sampleCoverage={enabled:defaultValue(m.enabled,!1),value:defaultValue(m.value,1),invert:defaultValue(m.invert,!1)},this.viewport=defined(f)?new BoundingRectangle(f.x,f.y,f.width,f.height):void 0,this.id=0,this._applyFunctions=[]}var nextRenderStateId=0,renderStateCache={};function enableOrDisable(e,t,i){i?e.enable(t):e.disable(t)}function applyFrontFace(e,t){e.frontFace(t.frontFace)}function applyCull(e,t){var i=t.cull,r=i.enabled;enableOrDisable(e,e.CULL_FACE,r),r&&e.cullFace(i.face)}function applyLineWidth(e,t){e.lineWidth(t.lineWidth)}function applyPolygonOffset(e,t){var i=t.polygonOffset,r=i.enabled;enableOrDisable(e,e.POLYGON_OFFSET_FILL,r),r&&e.polygonOffset(i.factor,i.units)}function applyScissorTest(e,t,i){var r=t.scissorTest,n=defined(i.scissorTest)?i.scissorTest.enabled:r.enabled;if(enableOrDisable(e,e.SCISSOR_TEST,n),n){var a=defined(i.scissorTest)?i.scissorTest.rectangle:r.rectangle;e.scissor(a.x,a.y,a.width,a.height)}}function applyDepthRange(e,t){var i=t.depthRange;e.depthRange(i.near,i.far)}function applyDepthTest(e,t){var i=t.depthTest,r=i.enabled;enableOrDisable(e,e.DEPTH_TEST,r),r&&e.depthFunc(i.func)}function applyColorMask(e,t){var i=t.colorMask;e.colorMask(i.red,i.green,i.blue,i.alpha)}function applyDepthMask(e,t){e.depthMask(t.depthMask)}function applyStencilMask(e,t){e.stencilMask(t.stencilMask)}function applyBlendingColor(e,t){e.blendColor(t.red,t.green,t.blue,t.alpha)}function applyBlending(e,t,i){var r=t.blending,n=defined(i.blendingEnabled)?i.blendingEnabled:r.enabled;enableOrDisable(e,e.BLEND,n),n&&(applyBlendingColor(e,r.color),e.blendEquationSeparate(r.equationRgb,r.equationAlpha),e.blendFuncSeparate(r.functionSourceRgb,r.functionDestinationRgb,r.functionSourceAlpha,r.functionDestinationAlpha))}function applyStencilTest(e,t){var i=t.stencilTest,r=i.enabled;if(enableOrDisable(e,e.STENCIL_TEST,r),r){var n=i.frontFunction,a=i.backFunction,o=i.reference,s=i.mask;e.stencilFunc(n,o,s),e.stencilFuncSeparate(e.BACK,a,o,s),e.stencilFuncSeparate(e.FRONT,n,o,s);var l=i.frontOperation,c=l.fail,u=l.zFail,d=l.zPass;e.stencilOpSeparate(e.FRONT,c,u,d);var h=i.backOperation,p=h.fail,m=h.zFail,f=h.zPass;e.stencilOpSeparate(e.BACK,p,m,f)}}function applySampleCoverage(e,t){var i=t.sampleCoverage,r=i.enabled;enableOrDisable(e,e.SAMPLE_COVERAGE,r),r&&e.sampleCoverage(i.value,i.invert)}RenderState.fromCache=function(e){var t=JSON.stringify(e),i=renderStateCache[t];if(defined(i))return++i.referenceCount,i.state;var r=new RenderState(e),n=JSON.stringify(r);return defined(i=renderStateCache[n])||(r.id=nextRenderStateId++,i={referenceCount:0,state:r},renderStateCache[n]=i),++i.referenceCount,renderStateCache[t]={referenceCount:1,state:i.state},i.state},RenderState.removeFromCache=function(e){var t=new RenderState(e),i=JSON.stringify(t),r=renderStateCache[i],n=JSON.stringify(e),a=renderStateCache[n];defined(a)&&(--a.referenceCount,0===a.referenceCount&&(delete renderStateCache[n],defined(r)&&--r.referenceCount)),defined(r)&&0===r.referenceCount&&delete renderStateCache[i]},RenderState.getCache=function(){return renderStateCache},RenderState.clearCache=function(){renderStateCache={}};var scratchViewport=new BoundingRectangle;function applyViewport(e,t,i){var r=defaultValue(t.viewport,i.viewport);defined(r)||((r=scratchViewport).width=i.context.drawingBufferWidth,r.height=i.context.drawingBufferHeight),i.context.uniformState.viewport=r,e.viewport(r.x,r.y,r.width,r.height)}function createFuncs(e,t){var i=[];return e.frontFace!==t.frontFace&&i.push(applyFrontFace),e.cull.enabled===t.cull.enabled&&e.cull.face===t.cull.face||i.push(applyCull),e.lineWidth!==t.lineWidth&&i.push(applyLineWidth),e.polygonOffset.enabled===t.polygonOffset.enabled&&e.polygonOffset.factor===t.polygonOffset.factor&&e.polygonOffset.units===t.polygonOffset.units||i.push(applyPolygonOffset),e.depthRange.near===t.depthRange.near&&e.depthRange.far===t.depthRange.far||i.push(applyDepthRange),e.depthTest.enabled===t.depthTest.enabled&&e.depthTest.func===t.depthTest.func||i.push(applyDepthTest),e.colorMask.red===t.colorMask.red&&e.colorMask.green===t.colorMask.green&&e.colorMask.blue===t.colorMask.blue&&e.colorMask.alpha===t.colorMask.alpha||i.push(applyColorMask),e.depthMask!==t.depthMask&&i.push(applyDepthMask),e.stencilMask!==t.stencilMask&&i.push(applyStencilMask),e.stencilTest.enabled===t.stencilTest.enabled&&e.stencilTest.frontFunction===t.stencilTest.frontFunction&&e.stencilTest.backFunction===t.stencilTest.backFunction&&e.stencilTest.reference===t.stencilTest.reference&&e.stencilTest.mask===t.stencilTest.mask&&e.stencilTest.frontOperation.fail===t.stencilTest.frontOperation.fail&&e.stencilTest.frontOperation.zFail===t.stencilTest.frontOperation.zFail&&e.stencilTest.backOperation.fail===t.stencilTest.backOperation.fail&&e.stencilTest.backOperation.zFail===t.stencilTest.backOperation.zFail&&e.stencilTest.backOperation.zPass===t.stencilTest.backOperation.zPass||i.push(applyStencilTest),e.sampleCoverage.enabled===t.sampleCoverage.enabled&&e.sampleCoverage.value===t.sampleCoverage.value&&e.sampleCoverage.invert===t.sampleCoverage.invert||i.push(applySampleCoverage),i}RenderState.apply=function(e,t,i){applyFrontFace(e,t),applyCull(e,t),applyLineWidth(e,t),applyPolygonOffset(e,t),applyDepthRange(e,t),applyDepthTest(e,t),applyColorMask(e,t),applyDepthMask(e,t),applyStencilMask(e,t),applyStencilTest(e,t),applySampleCoverage(e,t),applyScissorTest(e,t,i),applyBlending(e,t,i),applyViewport(e,t,i)},RenderState.partialApply=function(e,t,i,r,n,a){if(t!==i){var o=i._applyFunctions[t.id];defined(o)||(o=createFuncs(t,i),i._applyFunctions[t.id]=o);for(var s=o.length,l=0;l<s;++l)o[l](e,i)}(defined(r.scissorTest)?r.scissorTest:t.scissorTest)===(defined(n.scissorTest)?n.scissorTest:i.scissorTest)&&!a||applyScissorTest(e,i,n);var c=defined(r.blendingEnabled)?r.blendingEnabled:t.blending.enabled,u=defined(n.blendingEnabled)?n.blendingEnabled:i.blending.enabled;(c!==u||u&&t.blending!==i.blending)&&applyBlending(e,i,n),t===i&&r===n&&r.context===n.context||applyViewport(e,i,n)},RenderState.getState=function(e){return{frontFace:e.frontFace,cull:{enabled:e.cull.enabled,face:e.cull.face},lineWidth:e.lineWidth,polygonOffset:{enabled:e.polygonOffset.enabled,factor:e.polygonOffset.factor,units:e.polygonOffset.units},scissorTest:{enabled:e.scissorTest.enabled,rectangle:BoundingRectangle.clone(e.scissorTest.rectangle)},depthRange:{near:e.depthRange.near,far:e.depthRange.far},depthTest:{enabled:e.depthTest.enabled,func:e.depthTest.func},colorMask:{red:e.colorMask.red,green:e.colorMask.green,blue:e.colorMask.blue,alpha:e.colorMask.alpha},depthMask:e.depthMask,stencilMask:e.stencilMask,blending:{enabled:e.blending.enabled,color:Color.clone(e.blending.color),equationRgb:e.blending.equationRgb,equationAlpha:e.blending.equationAlpha,functionSourceRgb:e.blending.functionSourceRgb,functionSourceAlpha:e.blending.functionSourceAlpha,functionDestinationRgb:e.blending.functionDestinationRgb,functionDestinationAlpha:e.blending.functionDestinationAlpha},stencilTest:{enabled:e.stencilTest.enabled,frontFunction:e.stencilTest.frontFunction,backFunction:e.stencilTest.backFunction,reference:e.stencilTest.reference,mask:e.stencilTest.mask,frontOperation:{fail:e.stencilTest.frontOperation.fail,zFail:e.stencilTest.frontOperation.zFail,zPass:e.stencilTest.frontOperation.zPass},backOperation:{fail:e.stencilTest.backOperation.fail,zFail:e.stencilTest.backOperation.zFail,zPass:e.stencilTest.backOperation.zPass}},sampleCoverage:{enabled:e.sampleCoverage.enabled,value:e.sampleCoverage.value,invert:e.sampleCoverage.invert},viewport:defined(e.viewport)?BoundingRectangle.clone(e.viewport):void 0}};var viewerPositionWCScratch=new Cartesian3;function AutomaticUniform(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue}var datatypeToGlsl={};datatypeToGlsl[WebGLConstants$1.FLOAT]="float",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC2]="vec2",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC3]="vec3",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC4]="vec4",datatypeToGlsl[WebGLConstants$1.INT]="int",datatypeToGlsl[WebGLConstants$1.INT_VEC2]="ivec2",datatypeToGlsl[WebGLConstants$1.INT_VEC3]="ivec3",datatypeToGlsl[WebGLConstants$1.INT_VEC4]="ivec4",datatypeToGlsl[WebGLConstants$1.BOOL]="bool",datatypeToGlsl[WebGLConstants$1.BOOL_VEC2]="bvec2",datatypeToGlsl[WebGLConstants$1.BOOL_VEC3]="bvec3",datatypeToGlsl[WebGLConstants$1.BOOL_VEC4]="bvec4",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT2]="mat2",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT3]="mat3",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT4]="mat4",datatypeToGlsl[WebGLConstants$1.SAMPLER_2D]="sampler2D",datatypeToGlsl[WebGLConstants$1.SAMPLER_CUBE]="samplerCube",AutomaticUniform.prototype.getDeclaration=function(e){var t="uniform "+datatypeToGlsl[this._datatype]+" "+e,i=this._size;return t+=1===i?";":"["+i.toString()+"];"};var AutomaticUniforms={czm_viewport:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_viewportOrthographic:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_globeDepthTexture:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.globeDepthTexture}}),czm_model:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_infiniteProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_orthographicIn3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.orthographicIn3D?1:0}}),czm_normal:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight2D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_entireFrustum:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_frustumPlanes:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.frustumPlanes}}),czm_log2FarDistance:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.log2FarDistance}}),czm_log2FarPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.log2FarPlusOne}}),czm_log2NearDistance:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.log2NearDistance}}),czm_sunPositionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_encodedCameraPositionMCHigh:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCLow}}),czm_viewerPositionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return Matrix4.getTranslation(e.inverseView,viewerPositionWCScratch)}}),czm_frameNumber:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.frameNumber}}),czm_morphTime:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.morphTime}}),czm_sceneMode:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.mode}}),czm_pass:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.pass}}),czm_backgroundColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.backgroundColor}}),czm_brdfLut:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.brdfLut}}),czm_environmentMap:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_CUBE,getValue:function(e){return e.environmentMap}}),czm_specularEnvironmentMaps:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.specularEnvironmentMaps}}),czm_specularEnvironmentMapSize:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.specularEnvironmentMapsDimensions}}),czm_specularEnvironmentMapsMaximumLOD:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.specularEnvironmentMapsMaximumLOD}}),czm_sphericalHarmonicCoefficients:new AutomaticUniform({size:9,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sphericalHarmonicCoefficients}}),czm_temeToPseudoFixed:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.temeToPseudoFixedMatrix}}),czm_pixelRatio:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.pixelRatio}}),czm_fogDensity:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.fogDensity}}),czm_imagerySplitPosition:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.imagerySplitPosition}}),czm_geometricToleranceOverMeter:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.geometricToleranceOverMeter}}),czm_minimumDisableDepthTestDistance:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.minimumDisableDepthTestDistance}}),czm_invertClassificationColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.invertClassificationColor}}),czm_gamma:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.gamma}}),czm_sunColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunColor}})};function createUniform$1(e,t,i,r){switch(t.type){case e.FLOAT:return new UniformFloat(e,t,i,r);case e.FLOAT_VEC2:return new UniformFloatVec2(e,t,i,r);case e.FLOAT_VEC3:return new UniformFloatVec3(e,t,i,r);case e.FLOAT_VEC4:return new UniformFloatVec4(e,t,i,r);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new UniformSampler(e,t,i,r);case e.INT:case e.BOOL:return new UniformInt(e,t,i,r);case e.INT_VEC2:case e.BOOL_VEC2:return new UniformIntVec2(e,t,i,r);case e.INT_VEC3:case e.BOOL_VEC3:return new UniformIntVec3(e,t,i,r);case e.INT_VEC4:case e.BOOL_VEC4:return new UniformIntVec4(e,t,i,r);case e.FLOAT_MAT2:return new UniformMat2(e,t,i,r);case e.FLOAT_MAT3:return new UniformMat3(e,t,i,r);case e.FLOAT_MAT4:return new UniformMat4(e,t,i,r);default:throw new RuntimeError("Unrecognized uniform type: "+t.type+' for uniform "'+i+'".')}}function UniformFloat(e,t,i,r){this.name=i,this.value=void 0,this._value=0,this._gl=e,this._location=r}function UniformFloatVec2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian2,this._gl=e,this._location=r}function UniformFloatVec3(e,t,i,r){this.name=i,this.value=void 0,this._value=void 0,this._gl=e,this._location=r}function UniformFloatVec4(e,t,i,r){this.name=i,this.value=void 0,this._value=void 0,this._gl=e,this._location=r}function UniformSampler(e,t,i,r){this.name=i,this.value=void 0,this._gl=e,this._location=r,this.textureUnitIndex=void 0}function UniformInt(e,t,i,r){this.name=i,this.value=void 0,this._value=0,this._gl=e,this._location=r}function UniformIntVec2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian2,this._gl=e,this._location=r}function UniformIntVec3(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian3,this._gl=e,this._location=r}function UniformIntVec4(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian4,this._gl=e,this._location=r}UniformFloat.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1f(this._location,this.value))},UniformFloatVec2.prototype.set=function(){var e=this.value;Cartesian2.equals(e,this._value)||(Cartesian2.clone(e,this._value),this._gl.uniform2f(this._location,e.x,e.y))},UniformFloatVec3.prototype.set=function(){var e=this.value;defined(e.red)?Color.equals(e,this._value)||(this._value=Color.clone(e,this._value),this._gl.uniform3f(this._location,e.red,e.green,e.blue)):defined(e.x)&&(Cartesian3.equals(e,this._value)||(this._value=Cartesian3.clone(e,this._value),this._gl.uniform3f(this._location,e.x,e.y,e.z)))},UniformFloatVec4.prototype.set=function(){var e=this.value;defined(e.red)?Color.equals(e,this._value)||(this._value=Color.clone(e,this._value),this._gl.uniform4f(this._location,e.red,e.green,e.blue,e.alpha)):defined(e.x)&&(Cartesian4.equals(e,this._value)||(this._value=Cartesian4.clone(e,this._value),this._gl.uniform4f(this._location,e.x,e.y,e.z,e.w)))},UniformSampler.prototype.set=function(){var e=this._gl;e.activeTexture(e.TEXTURE0+this.textureUnitIndex);var t=this.value;e.bindTexture(t._target,t._texture)},UniformSampler.prototype._setSampler=function(e){return this.textureUnitIndex=e,this._gl.uniform1i(this._location,e),e+1},UniformInt.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1i(this._location,this.value))},UniformIntVec2.prototype.set=function(){var e=this.value;Cartesian2.equals(e,this._value)||(Cartesian2.clone(e,this._value),this._gl.uniform2i(this._location,e.x,e.y))},UniformIntVec3.prototype.set=function(){var e=this.value;Cartesian3.equals(e,this._value)||(Cartesian3.clone(e,this._value),this._gl.uniform3i(this._location,e.x,e.y,e.z))},UniformIntVec4.prototype.set=function(){var e=this.value;Cartesian4.equals(e,this._value)||(Cartesian4.clone(e,this._value),this._gl.uniform4i(this._location,e.x,e.y,e.z,e.w))};var scratchUniformArray=new Float32Array(4);function UniformMat2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix2,this._gl=e,this._location=r}UniformMat2.prototype.set=function(){if(!Matrix2.equalsArray(this.value,this._value,0)){Matrix2.clone(this.value,this._value);var e=Matrix2.toArray(this.value,scratchUniformArray);this._gl.uniformMatrix2fv(this._location,!1,e)}};var scratchMat3Array=new Float32Array(9);function UniformMat3(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix3,this._gl=e,this._location=r}UniformMat3.prototype.set=function(){if(!Matrix3.equalsArray(this.value,this._value,0)){Matrix3.clone(this.value,this._value);var e=Matrix3.toArray(this.value,scratchMat3Array);this._gl.uniformMatrix3fv(this._location,!1,e)}};var scratchMat4Array=new Float32Array(16);function UniformMat4(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix4,this._gl=e,this._location=r}function createUniformArray(e,t,i,r){switch(t.type){case e.FLOAT:return new UniformArrayFloat(e,t,i,r);case e.FLOAT_VEC2:return new UniformArrayFloatVec2(e,t,i,r);case e.FLOAT_VEC3:return new UniformArrayFloatVec3(e,t,i,r);case e.FLOAT_VEC4:return new UniformArrayFloatVec4(e,t,i,r);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new UniformArraySampler(e,t,i,r);case e.INT:case e.BOOL:return new UniformArrayInt(e,t,i,r);case e.INT_VEC2:case e.BOOL_VEC2:return new UniformArrayIntVec2(e,t,i,r);case e.INT_VEC3:case e.BOOL_VEC3:return new UniformArrayIntVec3(e,t,i,r);case e.INT_VEC4:case e.BOOL_VEC4:return new UniformArrayIntVec4(e,t,i,r);case e.FLOAT_MAT2:return new UniformArrayMat2(e,t,i,r);case e.FLOAT_MAT3:return new UniformArrayMat3(e,t,i,r);case e.FLOAT_MAT4:return new UniformArrayMat4(e,t,i,r);default:throw new RuntimeError("Unrecognized uniform type: "+t.type+' for uniform "'+i+'".')}}function UniformArrayFloat(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(n),this._gl=e,this._location=r[0]}function UniformArrayFloatVec2(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(2*n),this._gl=e,this._location=r[0]}function UniformArrayFloatVec3(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(3*n),this._gl=e,this._location=r[0]}function UniformArrayFloatVec4(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(4*n),this._gl=e,this._location=r[0]}function UniformArraySampler(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(n),this._gl=e,this._locations=r,this.textureUnitIndex=void 0}function UniformArrayInt(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Int32Array(n),this._gl=e,this._location=r[0]}function UniformArrayIntVec2(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Int32Array(2*n),this._gl=e,this._location=r[0]}function UniformArrayIntVec3(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Int32Array(3*n),this._gl=e,this._location=r[0]}function UniformArrayIntVec4(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Int32Array(4*n),this._gl=e,this._location=r[0]}function UniformArrayMat2(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(4*n),this._gl=e,this._location=r[0]}function UniformArrayMat3(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(9*n),this._gl=e,this._location=r[0]}function UniformArrayMat4(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(16*n),this._gl=e,this._location=r[0]}UniformMat4.prototype.set=function(){if(!Matrix4.equalsArray(this.value,this._value,0)){Matrix4.clone(this.value,this._value);var e=Matrix4.toArray(this.value,scratchMat4Array);this._gl.uniformMatrix4fv(this._location,!1,e)}},UniformArrayFloat.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0;n<t;++n){var a=e[n];a!==i[n]&&(i[n]=a,r=!0)}r&&this._gl.uniform1fv(this._location,i)},UniformArrayFloatVec2.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Cartesian2.equalsArray(o,i,n)||(Cartesian2.pack(o,i,n),r=!0),n+=2}r&&this._gl.uniform2fv(this._location,i)},UniformArrayFloatVec3.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];defined(o.red)?o.red===i[n]&&o.green===i[n+1]&&o.blue===i[n+2]||(i[n]=o.red,i[n+1]=o.green,i[n+2]=o.blue,r=!0):defined(o.x)&&(Cartesian3.equalsArray(o,i,n)||(Cartesian3.pack(o,i,n),r=!0)),n+=3}r&&this._gl.uniform3fv(this._location,i)},UniformArrayFloatVec4.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];defined(o.red)?Color.equalsArray(o,i,n)||(Color.pack(o,i,n),r=!0):defined(o.x)&&(Cartesian4.equalsArray(o,i,n)||(Cartesian4.pack(o,i,n),r=!0)),n+=4}r&&this._gl.uniform4fv(this._location,i)},UniformArraySampler.prototype.set=function(){for(var e=this._gl,t=e.TEXTURE0+this.textureUnitIndex,i=this.value,r=i.length,n=0;n<r;++n){var a=i[n];e.activeTexture(t+n),e.bindTexture(a._target,a._texture)}},UniformArraySampler.prototype._setSampler=function(e){this.textureUnitIndex=e;for(var t=this._locations,i=t.length,r=0;r<i;++r){var n=e+r;this._gl.uniform1i(t[r],n)}return e+i},UniformArrayInt.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0;n<t;++n){var a=e[n];a!==i[n]&&(i[n]=a,r=!0)}r&&this._gl.uniform1iv(this._location,i)},UniformArrayIntVec2.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Cartesian2.equalsArray(o,i,n)||(Cartesian2.pack(o,i,n),r=!0),n+=2}r&&this._gl.uniform2iv(this._location,i)},UniformArrayIntVec3.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Cartesian3.equalsArray(o,i,n)||(Cartesian3.pack(o,i,n),r=!0),n+=3}r&&this._gl.uniform3iv(this._location,i)},UniformArrayIntVec4.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Cartesian4.equalsArray(o,i,n)||(Cartesian4.pack(o,i,n),r=!0),n+=4}r&&this._gl.uniform4iv(this._location,i)},UniformArrayMat2.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Matrix2.equalsArray(o,i,n)||(Matrix2.pack(o,i,n),r=!0),n+=4}r&&this._gl.uniformMatrix2fv(this._location,!1,i)},UniformArrayMat3.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Matrix3.equalsArray(o,i,n)||(Matrix3.pack(o,i,n),r=!0),n+=9}r&&this._gl.uniformMatrix3fv(this._location,!1,i)},UniformArrayMat4.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Matrix4.equalsArray(o,i,n)||(Matrix4.pack(o,i,n),r=!0),n+=16}r&&this._gl.uniformMatrix4fv(this._location,!1,i)};var nextShaderProgramId=0;function ShaderProgram(e){var t=handleUniformPrecisionMismatches(e.vertexShaderText,e.fragmentShaderText);this._gl=e.gl,this._logShaderCompilation=e.logShaderCompilation,this._debugShaders=e.debugShaders,this._attributeLocations=e.attributeLocations,this._program=void 0,this._numberOfVertexAttributes=void 0,this._vertexAttributes=void 0,this._uniformsByName=void 0,this._uniforms=void 0,this._automaticUniforms=void 0,this._manualUniforms=void 0,this._duplicateUniformNames=t.duplicateUniformNames,this._cachedShader=void 0,this.maximumTextureUnitIndex=void 0,this._vertexShaderSource=e.vertexShaderSource,this._vertexShaderText=e.vertexShaderText,this._fragmentShaderSource=e.fragmentShaderSource,this._fragmentShaderText=t.fragmentShaderText,this.id=nextShaderProgramId++}function extractUniforms(e){var t=[],i=e.match(/uniform.*?(?![^{]*})(?=[=\[;])/g);if(defined(i))for(var r=i.length,n=0;n<r;n++){var a=i[n].trim(),o=a.slice(a.lastIndexOf(" ")+1);t.push(o)}return t}function handleUniformPrecisionMismatches(e,t){var i={};if(!ContextLimits.highpFloatSupported||!ContextLimits.highpIntSupported){var r,n,a,o,s=extractUniforms(e),l=extractUniforms(t),c=s.length,u=l.length;for(r=0;r<c;r++)for(n=0;n<u;n++)if(s[r]===l[n]){o="czm_mediump_"+(a=s[r]);var d=new RegExp(a+"\\b","g");t=t.replace(d,o),i[o]=a}}return{fragmentShaderText:t,duplicateUniformNames:i}}ShaderProgram.fromCache=function(e){return(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context.shaderCache.getShaderProgram(e)},ShaderProgram.replaceCache=function(e){return(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context.shaderCache.replaceShaderProgram(e)},defineProperties$1(ShaderProgram.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},vertexAttributes:{get:function(){return initialize$1(this),this._vertexAttributes}},numberOfVertexAttributes:{get:function(){return initialize$1(this),this._numberOfVertexAttributes}},allUniforms:{get:function(){return initialize$1(this),this._uniformsByName}}});var consolePrefix="[Cesium WebGL] ";function createAndLinkProgram(e,t){var i=t._vertexShaderText,r=t._fragmentShaderText,n=e.createShader(e.VERTEX_SHADER);e.shaderSource(n,i),e.compileShader(n);var a=e.createShader(e.FRAGMENT_SHADER);e.shaderSource(a,r),e.compileShader(a);var o=e.createProgram();e.attachShader(o,n),e.attachShader(o,a),e.deleteShader(n),e.deleteShader(a);var s,l=t._attributeLocations;if(defined(l))for(var c in l)l.hasOwnProperty(c)&&e.bindAttribLocation(o,l[c],c);if(e.linkProgram(o),!e.getProgramParameter(o,e.LINK_STATUS)){var u=t._debugShaders;if(!e.getShaderParameter(a,e.COMPILE_STATUS)){if(s=e.getShaderInfoLog(a),console.error(consolePrefix+"Fragment shader compile log: "+s),defined(u)){var d=u.getTranslatedShaderSource(a);""!==d?console.error(consolePrefix+"Translated fragment shader source:\n"+d):console.error(consolePrefix+"Fragment shader translation failed.")}throw e.deleteProgram(o),new RuntimeError("Fragment shader failed to compile.  Compile log: "+s)}if(e.getShaderParameter(n,e.COMPILE_STATUS))throw s=e.getProgramInfoLog(o),console.error(consolePrefix+"Shader program link log: "+s),defined(u)&&(console.error(consolePrefix+"Translated vertex shader source:\n"+u.getTranslatedShaderSource(n)),console.error(consolePrefix+"Translated fragment shader source:\n"+u.getTranslatedShaderSource(a))),e.deleteProgram(o),new RuntimeError("Program failed to link.  Link log: "+s);if(s=e.getShaderInfoLog(n),console.error(consolePrefix+"Vertex shader compile log: "+s),defined(u)){var h=u.getTranslatedShaderSource(n);""!==h?console.error(consolePrefix+"Translated vertex shader source:\n"+h):console.error(consolePrefix+"Vertex shader translation failed.")}throw e.deleteProgram(o),new RuntimeError("Vertex shader failed to compile.  Compile log: "+s)}var p=t._logShaderCompilation;return p&&defined(s=e.getShaderInfoLog(n))&&0<s.length&&console.log(consolePrefix+"Vertex shader compile log: "+s),p&&defined(s=e.getShaderInfoLog(a))&&0<s.length&&console.log(consolePrefix+"Fragment shader compile log: "+s),p&&defined(s=e.getProgramInfoLog(o))&&0<s.length&&console.log(consolePrefix+"Shader program link log: "+s),o}function findVertexAttributes(e,t,i){for(var r={},n=0;n<i;++n){var a=e.getActiveAttrib(t,n),o=e.getAttribLocation(t,a.name);r[a.name]={name:a.name,type:a.type,index:o}}return r}function findUniforms(e,t){for(var i={},r=[],n=[],a=e.getProgramParameter(t,e.ACTIVE_UNIFORMS),o=0;o<a;++o){var s=e.getActiveUniform(t,o),l=-1!==s.name.indexOf("[0]",s.name.length-"[0]".length)?s.name.slice(0,s.name.length-3):s.name;if(0!==l.indexOf("gl_"))if(s.name.indexOf("[")<0){var c=e.getUniformLocation(t,l);if(null!==c){var u=createUniform$1(e,s,l,c);i[l]=u,r.push(u),u._setSampler&&n.push(u)}}else{var d,h,p,m,f=l.indexOf("[");if(0<=f){if(!defined(d=i[l.slice(0,f)]))continue;(h=d._locations).length<=1&&(p=d.value,null!==(m=e.getUniformLocation(t,l))&&(h.push(m),p.push(e.getUniform(t,m))))}else{h=[];for(var g=0;g<s.size;++g)null!==(m=e.getUniformLocation(t,l+"["+g+"]"))&&h.push(m);d=createUniformArray(e,s,l,h),i[l]=d,r.push(d),d._setSampler&&n.push(d)}}}return{uniformsByName:i,uniforms:r,samplerUniforms:n}}function partitionUniforms(e,t){var i=[],r=[];for(var n in t)if(t.hasOwnProperty(n)){var a=t[n],o=n,s=e._duplicateUniformNames[o];defined(s)&&(o=a.name=s);var l=AutomaticUniforms[o];defined(l)?i.push({uniform:a,automaticUniform:l}):r.push(a)}return{automaticUniforms:i,manualUniforms:r}}function setSamplerUniforms(e,t,i){e.useProgram(t);for(var r=0,n=i.length,a=0;a<n;++a)r=i[a]._setSampler(r);return e.useProgram(null),r}function initialize$1(e){if(!defined(e._program)){var t=e._gl,i=createAndLinkProgram(t,e,e._debugShaders),r=t.getProgramParameter(i,t.ACTIVE_ATTRIBUTES),n=findUniforms(t,i),a=partitionUniforms(e,n.uniformsByName);e._program=i,e._numberOfVertexAttributes=r,e._vertexAttributes=findVertexAttributes(t,i,r),e._uniformsByName=n.uniformsByName,e._uniforms=n.uniforms,e._automaticUniforms=a.automaticUniforms,e._manualUniforms=a.manualUniforms,e.maximumTextureUnitIndex=setSamplerUniforms(t,i,n.samplerUniforms)}}function modernizeShader(e,t){var i=/#define OUTPUT_DECLARATION/,r=e.split("\n");if(/#version 300 es/g.test(e))return e;var n,a,o=-1;for(n=0;n<r.length;++n)if(a=r[n],i.test(a)){o=n;break}if(-1===o)throw new DeveloperError("Could not find a #define OUTPUT_DECLARATION!");var s=[];for(n=0;n<10;n++){var l="gl_FragData\\["+n+"\\]",c="czm_out"+n;new RegExp(l,"g").test(e)&&(setAdd(c,s),replaceInSourceString(l,c,r),r.splice(o,0,"layout(location = "+n+") out vec4 "+c+";"),o+=1)}var u="czm_fragColor";findInSource("gl_FragColor",r)&&(setAdd(u,s),replaceInSourceString("gl_FragColor",u,r),r.splice(o,0,"layout(location = 0) out vec4 czm_fragColor;"),o+=1);var d=getVariablePreprocessorBranch(s,r),h={};for(n=0;n<r.length;n++)for(var p in a=r[n],d){if(d.hasOwnProperty(p))new RegExp("(layout)[^]+(out)[^]+("+p+")[^]+","g").test(a)&&(h[a]=p)}for(var m in h)if(h.hasOwnProperty(m)){var f,g=h[m],_=r.indexOf(m),y=d[g],v=y.length;for(f=0;f<v;f++)r.splice(_,0,y[f]);for(_+=v+1,f=v-1;0<=f;f--)r.splice(_,0,"#endif //"+y[f])}var C="#version 300 es",S=!1;for(n=0;n<r.length;n++)/#version/.test(r[n])&&(r[n]=C,S=!0);return S||r.splice(0,0,C),removeExtension("EXT_draw_buffers",r),removeExtension("EXT_frag_depth",r),replaceInSourceString("texture2D","texture",r),replaceInSourceString("texture3D","texture",r),replaceInSourceString("textureCube","texture",r),replaceInSourceString("gl_FragDepthEXT","gl_FragDepth",r),t?replaceInSourceString("varying","in",r):(replaceInSourceString("attribute","in",r),replaceInSourceString("varying","out",r)),compileSource(r)}function replaceInSourceString(e,t,i){for(var r=new RegExp("(^|[^\\w])("+e+")($|[^\\w])","g"),n=i.length,a=0;a<n;++a){var o=i[a];i[a]=o.replace(r,"$1"+t+"$3")}}function replaceInSourceRegex(e,t,i){for(var r=i.length,n=0;n<r;++n){var a=i[n];i[n]=a.replace(e,t)}}function findInSource(e,t){for(var i=new RegExp("(^|[^\\w])("+e+")($|[^\\w])","g"),r=t.length,n=0;n<r;++n){var a=t[n];if(i.test(a))return!0}return!1}function compileSource(e){for(var t="",i=e.length,r=0;r<i;++r)t+=e[r]+"\n";return t}function setAdd(e,t){-1===t.indexOf(e)&&t.push(e)}function getVariablePreprocessorBranch(e,t){for(var i={},r=e.length,n=[],a=0;a<t.length;++a){var o=t[a],s=/(#ifdef|#if)/g.test(o),l=/#else/g.test(o),c=/#endif/g.test(o);if(s)n.push(o);else if(l){var u=n[n.length-1].replace("ifdef","ifndef");/if/g.test(u)&&(u=u.replace(/(#if\s+)(\S*)([^]*)/,"$1!($2)$3")),n.pop(),n.push(u)}else if(c)n.pop();else if(!/layout/g.test(o))for(var d=0;d<r;++d){var h=e[d];-1!==o.indexOf(h)&&(defined(i[h])?i[h]=i[h].filter(function(e){return 0<=n.indexOf(e)}):i[h]=n.slice())}}return i}function removeExtension(e,t){replaceInSourceRegex(new RegExp("#extension\\s+GL_"+e+"\\s+:\\s+[a-zA-Z0-9]+\\s*$","g"),"",t)}ShaderProgram.prototype._bind=function(){initialize$1(this),this._gl.useProgram(this._program)},ShaderProgram.prototype._setUniforms=function(e,t,i){var r,n;if(defined(e)){var a=this._manualUniforms;for(r=a.length,n=0;n<r;++n){var o=a[n];o.value=e[o.name]()}}var s=this._automaticUniforms;for(r=s.length,n=0;n<r;++n){var l=s[n];l.uniform.value=l.automaticUniform.getValue(t)}var c=this._uniforms;for(r=c.length,n=0;n<r;++n)c[n].set();if(i){var u=this._gl,d=this._program;u.validateProgram(d)}},ShaderProgram.prototype.isDestroyed=function(){return!1},ShaderProgram.prototype.destroy=function(){this._cachedShader.cache.releaseShaderProgram(this)},ShaderProgram.prototype.finalDestroy=function(){return this._gl.deleteProgram(this._program),destroyObject(this)};var czm_degreesPerRadian="const float czm_degreesPerRadian = 57.29577951308232;\n",czm_depthRange="const czm_depthRangeStruct czm_depthRange = czm_depthRangeStruct(0.0, 1.0);\n",czm_ellipsoidInverseRadii="const vec3 czm_ellipsoidInverseRadii = vec3(1.0 / 6378137.0, 1.0 / 6378137.0, 1.0 / 6356752.314245);\n",czm_ellipsoidRadii="const vec3 czm_ellipsoidRadii = vec3(6378137.0, 6378137.0, 6356752.314245);\n",czm_epsilon1="const float czm_epsilon1 = 0.1;\n",czm_epsilon2="const float czm_epsilon2 = 0.01;\n",czm_epsilon3="const float czm_epsilon3 = 0.001;\n",czm_epsilon4="const float czm_epsilon4 = 0.0001;\n",czm_epsilon5="const float czm_epsilon5 = 0.00001;\n",czm_epsilon6="const float czm_epsilon6 = 0.000001;\n",czm_epsilon7="const float czm_epsilon7 = 0.0000001;\n",czm_infinity="const float czm_infinity = 5906376272000.0;\n",czm_oneOverPi="const float czm_oneOverPi = 0.3183098861837907;\n",czm_oneOverTwoPi="const float czm_oneOverTwoPi = 0.15915494309189535;\n",czm_passCesium3DTile="const float czm_passCesium3DTile = 4.0;\n",czm_passCesium3DTileClassification="const float czm_passCesium3DTileClassification = 5.0;\n",czm_passCesium3DTileClassificationIgnoreShow="const float czm_passCesium3DTileClassificationIgnoreShow = 6.0;\n",czm_passClassification="const float czm_passClassification = 7.0;\n",czm_passCompute="const float czm_passCompute = 1.0;\n",czm_passEnvironment="const float czm_passEnvironment = 0.0;\n",czm_passGlobe="const float czm_passGlobe = 2.0;\n",czm_passOpaque="const float czm_passOpaque = 7.0;\n",czm_passOverlay="const float czm_passOverlay = 9.0;\n",czm_passTerrainClassification="const float czm_passTerrainClassification = 3.0;\n",czm_passTranslucent="const float czm_passTranslucent = 8.0;\n",czm_pi="const float czm_pi = 3.141592653589793;\n",czm_piOverFour="const float czm_piOverFour = 0.7853981633974483;\n",czm_piOverSix="const float czm_piOverSix = 0.5235987755982988;\n",czm_piOverThree="const float czm_piOverThree = 1.0471975511965976;\n",czm_piOverTwo="const float czm_piOverTwo = 1.5707963267948966;\n",czm_radiansPerDegree="const float czm_radiansPerDegree = 0.017453292519943295;\n",czm_sceneMode2D="const float czm_sceneMode2D = 2.0;\n",czm_sceneMode3D="const float czm_sceneMode3D = 3.0;\n",czm_sceneModeColumbusView="const float czm_sceneModeColumbusView = 1.0;\n",czm_sceneModeMorphing="const float czm_sceneModeMorphing = 0.0;\n",czm_solarRadius="const float czm_solarRadius = 695500000.0;\n",czm_threePiOver2="const float czm_threePiOver2 = 4.71238898038469;\n",czm_twoPi="const float czm_twoPi = 6.283185307179586;\n",czm_webMercatorMaxLatitude="const float czm_webMercatorMaxLatitude = 1.4844222297453324;\n",czm_depthRangeStruct="struct czm_depthRangeStruct\n{\nfloat near;\nfloat far;\n};\n",czm_material="struct czm_material\n{\nvec3 diffuse;\nfloat specular;\nfloat shininess;\nvec3 normal;\nvec3 emission;\nfloat alpha;\n};\n",czm_materialInput="struct czm_materialInput\n{\nfloat s;\nvec2 st;\nvec3 str;\nvec3 normalEC;\nmat3 tangentToEyeMatrix;\nvec3 positionToEyeEC;\nfloat height;\nfloat slope;\nfloat aspect;\n};\n",czm_ray="struct czm_ray\n{\nvec3 origin;\nvec3 direction;\n};\n",czm_raySegment="struct czm_raySegment\n{\nfloat start;\nfloat stop;\n};\nconst czm_raySegment czm_emptyRaySegment = czm_raySegment(-czm_infinity, -czm_infinity);\nconst czm_raySegment czm_fullRaySegment = czm_raySegment(0.0, czm_infinity);\n",czm_shadowParameters="struct czm_shadowParameters\n{\n#ifdef USE_CUBE_MAP_SHADOW\nvec3 texCoords;\n#else\nvec2 texCoords;\n#endif\nfloat depthBias;\nfloat depth;\nfloat nDotL;\nvec2 texelStepSize;\nfloat normalShadingSmooth;\nfloat darkness;\n};\n",czm_HSBToRGB="const vec4 K_HSB2RGB = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 czm_HSBToRGB(vec3 hsb)\n{\nvec3 p = abs(fract(hsb.xxx + K_HSB2RGB.xyz) * 6.0 - K_HSB2RGB.www);\nreturn hsb.z * mix(K_HSB2RGB.xxx, clamp(p - K_HSB2RGB.xxx, 0.0, 1.0), hsb.y);\n}\n",czm_HSLToRGB="vec3 hueToRGB(float hue)\n{\nfloat r = abs(hue * 6.0 - 3.0) - 1.0;\nfloat g = 2.0 - abs(hue * 6.0 - 2.0);\nfloat b = 2.0 - abs(hue * 6.0 - 4.0);\nreturn clamp(vec3(r, g, b), 0.0, 1.0);\n}\nvec3 czm_HSLToRGB(vec3 hsl)\n{\nvec3 rgb = hueToRGB(hsl.x);\nfloat c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;\nreturn (rgb - 0.5) * c + hsl.z;\n}\n",czm_RGBToHSB="const vec4 K_RGB2HSB = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec3 czm_RGBToHSB(vec3 rgb)\n{\nvec4 p = mix(vec4(rgb.bg, K_RGB2HSB.wz), vec4(rgb.gb, K_RGB2HSB.xy), step(rgb.b, rgb.g));\nvec4 q = mix(vec4(p.xyw, rgb.r), vec4(rgb.r, p.yzx), step(p.x, rgb.r));\nfloat d = q.x - min(q.w, q.y);\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + czm_epsilon7)), d / (q.x + czm_epsilon7), q.x);\n}\n",czm_RGBToHSL="vec3 RGBtoHCV(vec3 rgb)\n{\nvec4 p = (rgb.g < rgb.b) ? vec4(rgb.bg, -1.0, 2.0 / 3.0) : vec4(rgb.gb, 0.0, -1.0 / 3.0);\nvec4 q = (rgb.r < p.x) ? vec4(p.xyw, rgb.r) : vec4(rgb.r, p.yzx);\nfloat c = q.x - min(q.w, q.y);\nfloat h = abs((q.w - q.y) / (6.0 * c + czm_epsilon7) + q.z);\nreturn vec3(h, c, q.x);\n}\nvec3 czm_RGBToHSL(vec3 rgb)\n{\nvec3 hcv = RGBtoHCV(rgb);\nfloat l = hcv.z - hcv.y * 0.5;\nfloat s = hcv.y / (1.0 - abs(l * 2.0 - 1.0) + czm_epsilon7);\nreturn vec3(hcv.x, s, l);\n}\n",czm_RGBToXYZ="vec3 czm_RGBToXYZ(vec3 rgb)\n{\nconst mat3 RGB2XYZ = mat3(0.4124, 0.2126, 0.0193,\n0.3576, 0.7152, 0.1192,\n0.1805, 0.0722, 0.9505);\nvec3 xyz = RGB2XYZ * rgb;\nvec3 Yxy;\nYxy.r = xyz.g;\nfloat temp = dot(vec3(1.0), xyz);\nYxy.gb = xyz.rg / temp;\nreturn Yxy;\n}\n",czm_XYZToRGB="vec3 czm_XYZToRGB(vec3 Yxy)\n{\nconst mat3 XYZ2RGB = mat3( 3.2405, -0.9693,  0.0556,\n-1.5371,  1.8760, -0.2040,\n-0.4985,  0.0416,  1.0572);\nvec3 xyz;\nxyz.r = Yxy.r * Yxy.g / Yxy.b;\nxyz.g = Yxy.r;\nxyz.b = Yxy.r * (1.0 - Yxy.g - Yxy.b) / Yxy.b;\nreturn XYZ2RGB * xyz;\n}\n",czm_acesTonemapping="vec3 czm_acesTonemapping(vec3 color) {\nfloat g = 0.985;\nfloat a = 0.065;\nfloat b = 0.0001;\nfloat c = 0.433;\nfloat d = 0.238;\ncolor = (color * (color + a) - b) / (color * (g * color + c) + d);\ncolor = clamp(color, 0.0, 1.0);\nreturn color;\n}\n",czm_alphaWeight="float czm_alphaWeight(float a)\n{\nfloat z = (gl_FragCoord.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nreturn pow(a + 0.01, 4.0) + max(1e-2, min(3.0 * 1e3, 0.003 / (1e-5 + pow(abs(z) / 200.0, 4.0))));\n}\n",czm_antialias="vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor)\n{\nfloat val1 = clamp(dist / fuzzFactor, 0.0, 1.0);\nfloat val2 = clamp((dist - 0.5) / fuzzFactor, 0.0, 1.0);\nval1 = val1 * (1.0 - val2);\nval1 = val1 * val1 * (3.0 - (2.0 * val1));\nval1 = pow(val1, 0.5);\nvec4 midColor = (color1 + color2) * 0.5;\nreturn mix(midColor, currentColor, val1);\n}\nvec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist)\n{\nreturn czm_antialias(color1, color2, currentColor, dist, 0.1);\n}\n",czm_approximateSphericalCoordinates="vec2 czm_approximateSphericalCoordinates(vec3 normal) {\nfloat latitudeApproximation = czm_fastApproximateAtan(sqrt(normal.x * normal.x + normal.y * normal.y), normal.z);\nfloat longitudeApproximation = czm_fastApproximateAtan(normal.x, normal.y);\nreturn vec2(latitudeApproximation, longitudeApproximation);\n}\n",czm_branchFreeTernary="float czm_branchFreeTernary(bool comparison, float a, float b) {\nfloat useA = float(comparison);\nreturn a * useA + b * (1.0 - useA);\n}\nvec2 czm_branchFreeTernary(bool comparison, vec2 a, vec2 b) {\nfloat useA = float(comparison);\nreturn a * useA + b * (1.0 - useA);\n}\nvec3 czm_branchFreeTernary(bool comparison, vec3 a, vec3 b) {\nfloat useA = float(comparison);\nreturn a * useA + b * (1.0 - useA);\n}\nvec4 czm_branchFreeTernary(bool comparison, vec4 a, vec4 b) {\nfloat useA = float(comparison);\nreturn a * useA + b * (1.0 - useA);\n}\n",czm_cascadeColor="vec4 czm_cascadeColor(vec4 weights)\n{\nreturn vec4(1.0, 0.0, 0.0, 1.0) * weights.x +\nvec4(0.0, 1.0, 0.0, 1.0) * weights.y +\nvec4(0.0, 0.0, 1.0, 1.0) * weights.z +\nvec4(1.0, 0.0, 1.0, 1.0) * weights.w;\n}\n",czm_cascadeDistance="uniform vec4 shadowMap_cascadeDistances;\nfloat czm_cascadeDistance(vec4 weights)\n{\nreturn dot(shadowMap_cascadeDistances, weights);\n}\n",czm_cascadeMatrix="uniform mat4 shadowMap_cascadeMatrices[4];\nmat4 czm_cascadeMatrix(vec4 weights)\n{\nreturn shadowMap_cascadeMatrices[0] * weights.x +\nshadowMap_cascadeMatrices[1] * weights.y +\nshadowMap_cascadeMatrices[2] * weights.z +\nshadowMap_cascadeMatrices[3] * weights.w;\n}\n",czm_cascadeWeights="uniform vec4 shadowMap_cascadeSplits[2];\nvec4 czm_cascadeWeights(float depthEye)\n{\nvec4 near = step(shadowMap_cascadeSplits[0], vec4(depthEye));\nvec4 far = step(depthEye, shadowMap_cascadeSplits[1]);\nreturn near * far;\n}\n",czm_columbusViewMorph="vec4 czm_columbusViewMorph(vec4 position2D, vec4 position3D, float time)\n{\nvec3 p = mix(position2D.xyz, position3D.xyz, time);\nreturn vec4(p, 1.0);\n}\n",czm_computePosition="vec4 czm_computePosition();\n",czm_cosineAndSine="vec2 cordic(float angle)\n{\nvec2 vector = vec2(6.0725293500888267e-1, 0.0);\nfloat sense = (angle < 0.0) ? -1.0 : 1.0;\nmat2 rotation = mat2(1.0, sense, -sense, 1.0);\nvector = rotation * vector;\nangle -= sense * 7.8539816339744828e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfloat factor = sense * 5.0e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.6364760900080609e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.5e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.4497866312686414e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.25e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.2435499454676144e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 6.25e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 6.2418809995957350e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.125e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.1239833430268277e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.5625e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.5623728620476831e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 7.8125e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 7.8123410601011111e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.90625e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.9062301319669718e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.953125e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.9531225164788188e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 9.765625e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 9.7656218955931946e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 4.8828125e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.8828121119489829e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.44140625e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.4414062014936177e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.220703125e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.2207031189367021e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 6.103515625e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 6.1035156174208773e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.0517578125e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.0517578115526096e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.52587890625e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.5258789061315762e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 7.62939453125e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 7.6293945311019700e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.814697265625e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.8146972656064961e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.9073486328125e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.9073486328101870e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 9.5367431640625e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 9.5367431640596084e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 4.76837158203125e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.7683715820308884e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.384185791015625e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.3841857910155797e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.1920928955078125e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nreturn vector;\n}\nvec2 czm_cosineAndSine(float angle)\n{\nif (angle < -czm_piOverTwo || angle > czm_piOverTwo)\n{\nif (angle < 0.0)\n{\nreturn -cordic(angle + czm_pi);\n}\nelse\n{\nreturn -cordic(angle - czm_pi);\n}\n}\nelse\n{\nreturn cordic(angle);\n}\n}\n",czm_decompressTextureCoordinates="vec2 czm_decompressTextureCoordinates(float encoded)\n{\nfloat temp = encoded / 4096.0;\nfloat xZeroTo4095 = floor(temp);\nfloat stx = xZeroTo4095 / 4095.0;\nfloat sty = (encoded - xZeroTo4095 * 4096.0) / 4095.0;\nreturn vec2(stx, sty);\n}\n",czm_depthClampFarPlane="#ifndef LOG_DEPTH\nvarying float v_WindowZ;\n#endif\nvec4 czm_depthClampFarPlane(vec4 coords)\n{\n#ifndef LOG_DEPTH\nv_WindowZ = (0.5 * (coords.z / coords.w) + 0.5) * coords.w;\ncoords.z = min(coords.z, coords.w);\n#endif\nreturn coords;\n}\n",czm_eastNorthUpToEyeCoordinates="mat3 czm_eastNorthUpToEyeCoordinates(vec3 positionMC, vec3 normalEC)\n{\nvec3 tangentMC = normalize(vec3(-positionMC.y, positionMC.x, 0.0));\nvec3 tangentEC = normalize(czm_normal3D * tangentMC);\nvec3 bitangentEC = normalize(cross(normalEC, tangentEC));\nreturn mat3(\ntangentEC.x,   tangentEC.y,   tangentEC.z,\nbitangentEC.x, bitangentEC.y, bitangentEC.z,\nnormalEC.x,    normalEC.y,    normalEC.z);\n}\n",czm_ellipsoidContainsPoint="bool czm_ellipsoidContainsPoint(vec3 ellipsoid_inverseRadii, vec3 point)\n{\nvec3 scaled = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(point, 1.0)).xyz;\nreturn (dot(scaled, scaled) <= 1.0);\n}\n",czm_ellipsoidWgs84TextureCoordinates="vec2 czm_ellipsoidWgs84TextureCoordinates(vec3 normal)\n{\nreturn vec2(atan(normal.y, normal.x) * czm_oneOverTwoPi + 0.5, asin(normal.z) * czm_oneOverPi + 0.5);\n}\n",czm_equalsEpsilon="bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec4(epsilon)));\n}\nbool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec3(epsilon)));\n}\nbool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec2(epsilon)));\n}\nbool czm_equalsEpsilon(float left, float right, float epsilon) {\nreturn (abs(left - right) <= epsilon);\n}\n",czm_eyeOffset="vec4 czm_eyeOffset(vec4 positionEC, vec3 eyeOffset)\n{\nvec4 p = positionEC;\nvec4 zEyeOffset = normalize(p) * eyeOffset.z;\np.xy += eyeOffset.xy + zEyeOffset.xy;\np.z += zEyeOffset.z;\nreturn p;\n}\n",czm_eyeToWindowCoordinates="vec4 czm_eyeToWindowCoordinates(vec4 positionEC)\n{\nvec4 q = czm_projection * positionEC;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n",czm_fastApproximateAtan="float czm_fastApproximateAtan(float x) {\nreturn x * (-0.1784 * x - 0.0663 * x * x + 1.0301);\n}\nfloat czm_fastApproximateAtan(float x, float y) {\nfloat t = abs(x);\nfloat opposite = abs(y);\nfloat adjacent = max(t, opposite);\nopposite = min(t, opposite);\nt = czm_fastApproximateAtan(opposite / adjacent);\nt = czm_branchFreeTernary(abs(y) > abs(x), czm_piOverTwo - t, t);\nt = czm_branchFreeTernary(x < 0.0, czm_pi - t, t);\nt = czm_branchFreeTernary(y < 0.0, -t, t);\nreturn t;\n}\n",czm_fog="vec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor)\n{\nfloat scalar = distanceToCamera * czm_fogDensity;\nfloat fog = 1.0 - exp(-(scalar * scalar));\nreturn mix(color, fogColor, fog);\n}\nvec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor, float fogModifierConstant)\n{\nfloat scalar = distanceToCamera * czm_fogDensity;\nfloat fog = 1.0 - exp(-((fogModifierConstant * scalar + fogModifierConstant) * (scalar * (1.0 + fogModifierConstant))));\nreturn mix(color, fogColor, fog);\n}\n",czm_gammaCorrect="vec3 czm_gammaCorrect(vec3 color) {\n#ifdef HDR\ncolor = pow(color, vec3(czm_gamma));\n#endif\nreturn color;\n}\nvec4 czm_gammaCorrect(vec4 color) {\n#ifdef HDR\ncolor.rgb = pow(color.rgb, vec3(czm_gamma));\n#endif\nreturn color;\n}\n",czm_geodeticSurfaceNormal="vec3 czm_geodeticSurfaceNormal(vec3 positionOnEllipsoid, vec3 ellipsoidCenter, vec3 oneOverEllipsoidRadiiSquared)\n{\nreturn normalize((positionOnEllipsoid - ellipsoidCenter) * oneOverEllipsoidRadiiSquared);\n}\n",czm_getDefaultMaterial="czm_material czm_getDefaultMaterial(czm_materialInput materialInput)\n{\nczm_material material;\nmaterial.diffuse = vec3(0.0);\nmaterial.specular = 0.0;\nmaterial.shininess = 1.0;\nmaterial.normal = materialInput.normalEC;\nmaterial.emission = vec3(0.0);\nmaterial.alpha = 1.0;\nreturn material;\n}\n",czm_getLambertDiffuse="float czm_getLambertDiffuse(vec3 lightDirectionEC, vec3 normalEC)\n{\nreturn max(dot(lightDirectionEC, normalEC), 0.0);\n}\n",czm_getSpecular="float czm_getSpecular(vec3 lightDirectionEC, vec3 toEyeEC, vec3 normalEC, float shininess)\n{\nvec3 toReflectedLight = reflect(-lightDirectionEC, normalEC);\nfloat specular = max(dot(toReflectedLight, toEyeEC), 0.0);\nreturn pow(specular, max(shininess, czm_epsilon2));\n}\n",czm_getWaterNoise="vec4 czm_getWaterNoise(sampler2D normalMap, vec2 uv, float time, float angleInRadians)\n{\nfloat cosAngle = cos(angleInRadians);\nfloat sinAngle = sin(angleInRadians);\nvec2 s0 = vec2(1.0/17.0, 0.0);\nvec2 s1 = vec2(-1.0/29.0, 0.0);\nvec2 s2 = vec2(1.0/101.0, 1.0/59.0);\nvec2 s3 = vec2(-1.0/109.0, -1.0/57.0);\ns0 = vec2((cosAngle * s0.x) - (sinAngle * s0.y), (sinAngle * s0.x) + (cosAngle * s0.y));\ns1 = vec2((cosAngle * s1.x) - (sinAngle * s1.y), (sinAngle * s1.x) + (cosAngle * s1.y));\ns2 = vec2((cosAngle * s2.x) - (sinAngle * s2.y), (sinAngle * s2.x) + (cosAngle * s2.y));\ns3 = vec2((cosAngle * s3.x) - (sinAngle * s3.y), (sinAngle * s3.x) + (cosAngle * s3.y));\nvec2 uv0 = (uv/103.0) + (time * s0);\nvec2 uv1 = uv/107.0 + (time * s1) + vec2(0.23);\nvec2 uv2 = uv/vec2(897.0, 983.0) + (time * s2) + vec2(0.51);\nvec2 uv3 = uv/vec2(991.0, 877.0) + (time * s3) + vec2(0.71);\nuv0 = fract(uv0);\nuv1 = fract(uv1);\nuv2 = fract(uv2);\nuv3 = fract(uv3);\nvec4 noise = (texture2D(normalMap, uv0)) +\n(texture2D(normalMap, uv1)) +\n(texture2D(normalMap, uv2)) +\n(texture2D(normalMap, uv3));\nreturn ((noise / 4.0) - 0.5) * 2.0;\n}\n",czm_hue="vec3 czm_hue(vec3 rgb, float adjustment)\n{\nconst mat3 toYIQ = mat3(0.299,     0.587,     0.114,\n0.595716, -0.274453, -0.321263,\n0.211456, -0.522591,  0.311135);\nconst mat3 toRGB = mat3(1.0,  0.9563,  0.6210,\n1.0, -0.2721, -0.6474,\n1.0, -1.107,   1.7046);\nvec3 yiq = toYIQ * rgb;\nfloat hue = atan(yiq.z, yiq.y) + adjustment;\nfloat chroma = sqrt(yiq.z * yiq.z + yiq.y * yiq.y);\nvec3 color = vec3(yiq.x, chroma * cos(hue), chroma * sin(hue));\nreturn toRGB * color;\n}\n",czm_inverseGamma="vec3 czm_inverseGamma(vec3 color) {\nreturn pow(color, vec3(1.0 / czm_gamma));\n}\n",czm_isEmpty="bool czm_isEmpty(czm_raySegment interval)\n{\nreturn (interval.stop < 0.0);\n}\n",czm_isFull="bool czm_isFull(czm_raySegment interval)\n{\nreturn (interval.start == 0.0 && interval.stop == czm_infinity);\n}\n",czm_latitudeToWebMercatorFraction="float czm_latitudeToWebMercatorFraction(float latitude, float southMercatorY, float oneOverMercatorHeight)\n{\nfloat sinLatitude = sin(latitude);\nfloat mercatorY = 0.5 * log((1.0 + sinLatitude) / (1.0 - sinLatitude));\nreturn (mercatorY - southMercatorY) * oneOverMercatorHeight;\n}\n",czm_lineDistance="float czm_lineDistance(vec2 point1, vec2 point2, vec2 point) {\nreturn abs((point2.y - point1.y) * point.x - (point2.x - point1.x) * point.y + point2.x * point1.y - point2.y * point1.x) / distance(point2, point1);\n}\n",czm_luminance="float czm_luminance(vec3 rgb)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nreturn dot(rgb, W);\n}\n",czm_metersPerPixel="float czm_metersPerPixel(vec4 positionEC, float pixelRatio)\n{\nfloat width = czm_viewport.z;\nfloat height = czm_viewport.w;\nfloat pixelWidth;\nfloat pixelHeight;\nfloat top = czm_frustumPlanes.x;\nfloat bottom = czm_frustumPlanes.y;\nfloat left = czm_frustumPlanes.z;\nfloat right = czm_frustumPlanes.w;\nif (czm_sceneMode == czm_sceneMode2D || czm_orthographicIn3D == 1.0)\n{\nfloat frustumWidth = right - left;\nfloat frustumHeight = top - bottom;\npixelWidth = frustumWidth / width;\npixelHeight = frustumHeight / height;\n}\nelse\n{\nfloat distanceToPixel = -positionEC.z;\nfloat inverseNear = 1.0 / czm_currentFrustum.x;\nfloat tanTheta = top * inverseNear;\npixelHeight = 2.0 * distanceToPixel * tanTheta / height;\ntanTheta = right * inverseNear;\npixelWidth = 2.0 * distanceToPixel * tanTheta / width;\n}\nreturn max(pixelWidth, pixelHeight) * pixelRatio;\n}\nfloat czm_metersPerPixel(vec4 positionEC)\n{\nreturn czm_metersPerPixel(positionEC, czm_pixelRatio);\n}\n",czm_modelToWindowCoordinates="vec4 czm_modelToWindowCoordinates(vec4 position)\n{\nvec4 q = czm_modelViewProjection * position;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n",czm_multiplyWithColorBalance="vec3 czm_multiplyWithColorBalance(vec3 left, vec3 right)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 target = left * right;\nfloat leftLuminance = dot(left, W);\nfloat rightLuminance = dot(right, W);\nfloat targetLuminance = dot(target, W);\nreturn ((leftLuminance + rightLuminance) / (2.0 * targetLuminance)) * target;\n}\n",czm_nearFarScalar="float czm_nearFarScalar(vec4 nearFarScalar, float cameraDistSq)\n{\nfloat valueAtMin = nearFarScalar.y;\nfloat valueAtMax = nearFarScalar.w;\nfloat nearDistanceSq = nearFarScalar.x * nearFarScalar.x;\nfloat farDistanceSq = nearFarScalar.z * nearFarScalar.z;\nfloat t = (cameraDistSq - nearDistanceSq) / (farDistanceSq - nearDistanceSq);\nt = pow(clamp(t, 0.0, 1.0), 0.2);\nreturn mix(valueAtMin, valueAtMax, t);\n}\n",czm_octDecode="vec3 czm_octDecode(vec2 encoded, float range)\n{\nif (encoded.x == 0.0 && encoded.y == 0.0) {\nreturn vec3(0.0, 0.0, 0.0);\n}\nencoded = encoded / range * 2.0 - 1.0;\nvec3 v = vec3(encoded.x, encoded.y, 1.0 - abs(encoded.x) - abs(encoded.y));\nif (v.z < 0.0)\n{\nv.xy = (1.0 - abs(v.yx)) * czm_signNotZero(v.xy);\n}\nreturn normalize(v);\n}\nvec3 czm_octDecode(vec2 encoded)\n{\nreturn czm_octDecode(encoded, 255.0);\n}\nvec3 czm_octDecode(float encoded)\n{\nfloat temp = encoded / 256.0;\nfloat x = floor(temp);\nfloat y = (temp - x) * 256.0;\nreturn czm_octDecode(vec2(x, y));\n}\nvoid czm_octDecode(vec2 encoded, out vec3 vector1, out vec3 vector2, out vec3 vector3)\n{\nfloat temp = encoded.x / 65536.0;\nfloat x = floor(temp);\nfloat encodedFloat1 = (temp - x) * 65536.0;\ntemp = encoded.y / 65536.0;\nfloat y = floor(temp);\nfloat encodedFloat2 = (temp - y) * 65536.0;\nvector1 = czm_octDecode(encodedFloat1);\nvector2 = czm_octDecode(encodedFloat2);\nvector3 = czm_octDecode(vec2(x, y));\n}\n",czm_packDepth="vec4 czm_packDepth(float depth)\n{\nvec4 enc = vec4(1.0, 255.0, 65025.0, 16581375.0) * depth;\nenc = fract(enc);\nenc -= enc.yzww * vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0, 0.0);\nreturn enc;\n}\n",czm_phong="float czm_private_getLambertDiffuseOfMaterial(vec3 lightDirectionEC, czm_material material)\n{\nreturn czm_getLambertDiffuse(lightDirectionEC, material.normal);\n}\nfloat czm_private_getSpecularOfMaterial(vec3 lightDirectionEC, vec3 toEyeEC, czm_material material)\n{\nreturn czm_getSpecular(lightDirectionEC, toEyeEC, material.normal, material.shininess);\n}\nvec4 czm_phong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 0.0, 1.0), material);\nif (czm_sceneMode == czm_sceneMode3D) {\ndiffuse += czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 1.0, 0.0), material);\n}\nfloat specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material) + czm_private_getSpecularOfMaterial(czm_moonDirectionEC, toEye, material);\nvec3 materialDiffuse = material.diffuse * 0.5;\nvec3 ambient = materialDiffuse;\nvec3 color = ambient + material.emission;\ncolor += materialDiffuse * diffuse;\ncolor += material.specular * specular;\n#ifdef HDR\nfloat sunDiffuse = czm_private_getLambertDiffuseOfMaterial(czm_sunDirectionEC, material);\ncolor += materialDiffuse * sunDiffuse * czm_sunColor;\n#endif\nreturn vec4(color, material.alpha);\n}\nvec4 czm_private_phong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(czm_sunDirectionEC, material);\nfloat specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material);\nvec3 ambient = vec3(0.0);\nvec3 color = ambient + material.emission;\ncolor += material.diffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\n",czm_planeDistance="float czm_planeDistance(vec4 plane, vec3 point) {\nreturn (dot(plane.xyz, point) + plane.w);\n}\nfloat czm_planeDistance(vec3 planeNormal, float planeDistance, vec3 point) {\nreturn (dot(planeNormal, point) + planeDistance);\n}\n",czm_pointAlongRay="vec3 czm_pointAlongRay(czm_ray ray, float time)\n{\nreturn ray.origin + (time * ray.direction);\n}\n",czm_rayEllipsoidIntersectionInterval="czm_raySegment czm_rayEllipsoidIntersectionInterval(czm_ray ray, vec3 ellipsoid_center, vec3 ellipsoid_inverseRadii)\n{\nvec3 q = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ray.origin, 1.0)).xyz;\nvec3 w = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ray.direction, 0.0)).xyz;\nq = q - ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ellipsoid_center, 1.0)).xyz;\nfloat q2 = dot(q, q);\nfloat qw = dot(q, w);\nif (q2 > 1.0)\n{\nif (qw >= 0.0)\n{\nreturn czm_emptyRaySegment;\n}\nelse\n{\nfloat qw2 = qw * qw;\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nif (qw2 < product)\n{\nreturn czm_emptyRaySegment;\n}\nelse if (qw2 > product)\n{\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nfloat root0 = temp / w2;\nfloat root1 = difference / temp;\nif (root0 < root1)\n{\nczm_raySegment i = czm_raySegment(root0, root1);\nreturn i;\n}\nelse\n{\nczm_raySegment i = czm_raySegment(root1, root0);\nreturn i;\n}\n}\nelse\n{\nfloat root = sqrt(difference / w2);\nczm_raySegment i = czm_raySegment(root, root);\nreturn i;\n}\n}\n}\nelse if (q2 < 1.0)\n{\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nczm_raySegment i = czm_raySegment(0.0, temp / w2);\nreturn i;\n}\nelse\n{\nif (qw < 0.0)\n{\nfloat w2 = dot(w, w);\nczm_raySegment i = czm_raySegment(0.0, -qw / w2);\nreturn i;\n}\nelse\n{\nreturn czm_emptyRaySegment;\n}\n}\n}\n",czm_readDepth="float czm_readDepth(sampler2D depthTexture, vec2 texCoords)\n{\nreturn czm_reverseLogDepth(texture2D(depthTexture, texCoords).r);\n}\n",czm_reverseLogDepth="float czm_reverseLogDepth(float logZ)\n{\n#ifdef LOG_DEPTH\nfloat near = czm_currentFrustum.x;\nfloat far = czm_currentFrustum.y;\nlogZ = pow(2.0, logZ * czm_log2FarPlusOne) - 1.0;\nlogZ = far * (1.0 - near / logZ) / (far - near);\n#endif\nreturn logZ;\n}\n",czm_sampleOctahedralProjection="vec3 czm_sampleOctahedralProjectionWithFiltering(sampler2D projectedMap, vec2 textureSize, vec3 direction, float lod)\n{\ndirection /= dot(vec3(1.0), abs(direction));\nvec2 rev = abs(direction.zx) - vec2(1.0);\nvec2 neg = vec2(direction.x < 0.0 ? rev.x : -rev.x,\ndirection.z < 0.0 ? rev.y : -rev.y);\nvec2 uv = direction.y < 0.0 ? neg : direction.xz;\nvec2 coord = 0.5 * uv + vec2(0.5);\nvec2 pixel = 1.0 / textureSize;\nif (lod > 0.0)\n{\nfloat scale = 1.0 / pow(2.0, lod);\nfloat offset = ((textureSize.y + 1.0) / textureSize.x);\ncoord.x *= offset;\ncoord *= scale;\ncoord.x += offset + pixel.x;\ncoord.y += (1.0 - (1.0 / pow(2.0, lod - 1.0))) + pixel.y * (lod - 1.0) * 2.0;\n}\nelse\n{\ncoord.x *= (textureSize.y / textureSize.x);\n}\n#ifndef OES_texture_float_linear\nvec3 color1 = texture2D(projectedMap, coord + vec2(0.0, pixel.y)).rgb;\nvec3 color2 = texture2D(projectedMap, coord + vec2(pixel.x, 0.0)).rgb;\nvec3 color3 = texture2D(projectedMap, coord + pixel).rgb;\nvec3 color4 = texture2D(projectedMap, coord).rgb;\nvec2 texturePosition = coord * textureSize;\nfloat fu = fract(texturePosition.x);\nfloat fv = fract(texturePosition.y);\nvec3 average1 = mix(color4, color2, fu);\nvec3 average2 = mix(color1, color3, fu);\nvec3 color = mix(average1, average2, fv);\n#else\nvec3 color = texture2D(projectedMap, coord).rgb;\n#endif\nreturn color;\n}\nvec3 czm_sampleOctahedralProjection(sampler2D projectedMap, vec2 textureSize, vec3 direction, float lod, float maxLod) {\nfloat currentLod = floor(lod + 0.5);\nfloat nextLod = min(currentLod + 1.0, maxLod);\nvec3 colorCurrentLod = czm_sampleOctahedralProjectionWithFiltering(projectedMap, textureSize, direction, currentLod);\nvec3 colorNextLod = czm_sampleOctahedralProjectionWithFiltering(projectedMap, textureSize, direction, nextLod);\nreturn mix(colorNextLod, colorCurrentLod, nextLod - lod);\n}\n",czm_saturation="vec3 czm_saturation(vec3 rgb, float adjustment)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 intensity = vec3(dot(rgb, W));\nreturn mix(intensity, rgb, adjustment);\n}\n",czm_shadowDepthCompare="float czm_sampleShadowMap(samplerCube shadowMap, vec3 d)\n{\nreturn czm_unpackDepth(textureCube(shadowMap, d));\n}\nfloat czm_sampleShadowMap(sampler2D shadowMap, vec2 uv)\n{\n#ifdef USE_SHADOW_DEPTH_TEXTURE\nreturn texture2D(shadowMap, uv).r;\n#else\nreturn czm_unpackDepth(texture2D(shadowMap, uv));\n#endif\n}\nfloat czm_shadowDepthCompare(samplerCube shadowMap, vec3 uv, float depth)\n{\nreturn step(depth, czm_sampleShadowMap(shadowMap, uv));\n}\nfloat czm_shadowDepthCompare(sampler2D shadowMap, vec2 uv, float depth)\n{\nreturn step(depth, czm_sampleShadowMap(shadowMap, uv));\n}\n",czm_shadowVisibility="float czm_private_shadowVisibility(float visibility, float nDotL, float normalShadingSmooth, float darkness)\n{\n#ifdef USE_NORMAL_SHADING\n#ifdef USE_NORMAL_SHADING_SMOOTH\nfloat strength = clamp(nDotL / normalShadingSmooth, 0.0, 1.0);\n#else\nfloat strength = step(0.0, nDotL);\n#endif\nvisibility *= strength;\n#endif\nvisibility = max(visibility, darkness);\nreturn visibility;\n}\n#ifdef USE_CUBE_MAP_SHADOW\nfloat czm_shadowVisibility(samplerCube shadowMap, czm_shadowParameters shadowParameters)\n{\nfloat depthBias = shadowParameters.depthBias;\nfloat depth = shadowParameters.depth;\nfloat nDotL = shadowParameters.nDotL;\nfloat normalShadingSmooth = shadowParameters.normalShadingSmooth;\nfloat darkness = shadowParameters.darkness;\nvec3 uvw = shadowParameters.texCoords;\ndepth -= depthBias;\nfloat visibility = czm_shadowDepthCompare(shadowMap, uvw, depth);\nreturn czm_private_shadowVisibility(visibility, nDotL, normalShadingSmooth, darkness);\n}\n#else\nfloat czm_shadowVisibility(sampler2D shadowMap, czm_shadowParameters shadowParameters)\n{\nfloat depthBias = shadowParameters.depthBias;\nfloat depth = shadowParameters.depth;\nfloat nDotL = shadowParameters.nDotL;\nfloat normalShadingSmooth = shadowParameters.normalShadingSmooth;\nfloat darkness = shadowParameters.darkness;\nvec2 uv = shadowParameters.texCoords;\ndepth -= depthBias;\n#ifdef USE_SOFT_SHADOWS\nvec2 texelStepSize = shadowParameters.texelStepSize;\nfloat radius = 1.0;\nfloat dx0 = -texelStepSize.x * radius;\nfloat dy0 = -texelStepSize.y * radius;\nfloat dx1 = texelStepSize.x * radius;\nfloat dy1 = texelStepSize.y * radius;\nfloat visibility = (\nczm_shadowDepthCompare(shadowMap, uv, depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx0, dy0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(0.0, dy0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx1, dy0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx0, 0.0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx1, 0.0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx0, dy1), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(0.0, dy1), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx1, dy1), depth)\n) * (1.0 / 9.0);\n#else\nfloat visibility = czm_shadowDepthCompare(shadowMap, uv, depth);\n#endif\nreturn czm_private_shadowVisibility(visibility, nDotL, normalShadingSmooth, darkness);\n}\n#endif\n",czm_signNotZero="float czm_signNotZero(float value)\n{\nreturn value >= 0.0 ? 1.0 : -1.0;\n}\nvec2 czm_signNotZero(vec2 value)\n{\nreturn vec2(czm_signNotZero(value.x), czm_signNotZero(value.y));\n}\nvec3 czm_signNotZero(vec3 value)\n{\nreturn vec3(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z));\n}\nvec4 czm_signNotZero(vec4 value)\n{\nreturn vec4(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z), czm_signNotZero(value.w));\n}\n",czm_sphericalHarmonics="vec3 czm_sphericalHarmonics(vec3 normal, vec3 coefficients[9])\n{\nconst float c1 = 0.429043;\nconst float c2 = 0.511664;\nconst float c3 = 0.743125;\nconst float c4 = 0.886227;\nconst float c5 = 0.247708;\nvec3 L00 = coefficients[0];\nvec3 L1_1 = coefficients[1];\nvec3 L10 = coefficients[2];\nvec3 L11 = coefficients[3];\nvec3 L2_2 = coefficients[4];\nvec3 L2_1 = coefficients[5];\nvec3 L20 = coefficients[6];\nvec3 L21 = coefficients[7];\nvec3 L22 = coefficients[8];\nfloat x = normal.x;\nfloat y = normal.y;\nfloat z = normal.z;\nreturn c1 * L22 * (x * x - y * y) + c3 * L20 * z * z + c4 * L00 - c5 * L20 +\n2.0 * c1 * (L2_2 * x * y + L21 * x * z + L2_1 * y * z) +\n2.0 * c2 * (L11 * x + L1_1 * y + L10 * z);\n}\n",czm_tangentToEyeSpaceMatrix="mat3 czm_tangentToEyeSpaceMatrix(vec3 normalEC, vec3 tangentEC, vec3 bitangentEC)\n{\nvec3 normal = normalize(normalEC);\nvec3 tangent = normalize(tangentEC);\nvec3 bitangent = normalize(bitangentEC);\nreturn mat3(tangent.x  , tangent.y  , tangent.z,\nbitangent.x, bitangent.y, bitangent.z,\nnormal.x   , normal.y   , normal.z);\n}\n",czm_transformPlane="vec4 czm_transformPlane(vec4 clippingPlane, mat4 transform) {\nvec3 transformedDirection = normalize((transform * vec4(clippingPlane.xyz, 0.0)).xyz);\nvec3 transformedPosition = (transform * vec4(clippingPlane.xyz * -clippingPlane.w, 1.0)).xyz;\nvec4 transformedPlane;\ntransformedPlane.xyz = transformedDirection;\ntransformedPlane.w = -dot(transformedDirection, transformedPosition);\nreturn transformedPlane;\n}\n",czm_translateRelativeToEye="vec4 czm_translateRelativeToEye(vec3 high, vec3 low)\n{\nvec3 highDifference = high - czm_encodedCameraPositionMCHigh;\nvec3 lowDifference = low - czm_encodedCameraPositionMCLow;\nreturn vec4(highDifference + lowDifference, 1.0);\n}\n",czm_translucentPhong="vec4 czm_translucentPhong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_getLambertDiffuse(vec3(0.0, 0.0, 1.0), material.normal);\nif (czm_sceneMode == czm_sceneMode3D) {\ndiffuse += czm_getLambertDiffuse(vec3(0.0, 1.0, 0.0), material.normal);\n}\ndiffuse = clamp(diffuse, 0.0, 1.0);\nfloat specular = czm_getSpecular(czm_sunDirectionEC, toEye, material.normal, material.shininess);\nspecular += czm_getSpecular(czm_moonDirectionEC, toEye, material.normal, material.shininess);\nvec3 materialDiffuse = material.diffuse * 0.5;\nvec3 ambient = materialDiffuse;\nvec3 color = ambient + material.emission;\ncolor += materialDiffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\n",czm_transpose="mat2 czm_transpose(mat2 matrix)\n{\nreturn mat2(\nmatrix[0][0], matrix[1][0],\nmatrix[0][1], matrix[1][1]);\n}\nmat3 czm_transpose(mat3 matrix)\n{\nreturn mat3(\nmatrix[0][0], matrix[1][0], matrix[2][0],\nmatrix[0][1], matrix[1][1], matrix[2][1],\nmatrix[0][2], matrix[1][2], matrix[2][2]);\n}\nmat4 czm_transpose(mat4 matrix)\n{\nreturn mat4(\nmatrix[0][0], matrix[1][0], matrix[2][0], matrix[3][0],\nmatrix[0][1], matrix[1][1], matrix[2][1], matrix[3][1],\nmatrix[0][2], matrix[1][2], matrix[2][2], matrix[3][2],\nmatrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]);\n}\n",czm_unpackDepth="float czm_unpackDepth(vec4 packedDepth)\n{\nreturn dot(packedDepth, vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0));\n}\n",czm_unpackFloat="#define SHIFT_RIGHT_8 0.00390625 //1.0 / 256.0\n#define SHIFT_RIGHT_16 0.00001525878 //1.0 / 65536.0\n#define SHIFT_RIGHT_24 5.960464477539063e-8//1.0 / 16777216.0\n#define BIAS 38.0\nfloat czm_unpackFloat(vec4 packedFloat)\n{\npackedFloat *= 255.0;\nfloat temp = packedFloat.w / 2.0;\nfloat exponent = floor(temp);\nfloat sign = (temp - exponent) * 2.0;\nexponent = exponent - float(BIAS);\nsign = sign * 2.0 - 1.0;\nsign = -sign;\nfloat unpacked = sign * packedFloat.x * float(SHIFT_RIGHT_8);\nunpacked += sign * packedFloat.y * float(SHIFT_RIGHT_16);\nunpacked += sign * packedFloat.z * float(SHIFT_RIGHT_24);\nreturn unpacked * pow(10.0, exponent);\n}\n",czm_vertexLogDepth="#ifdef LOG_DEPTH\nvarying float v_logZ;\n#ifdef SHADOW_MAP\nvarying vec3 v_logPositionEC;\n#endif\n#endif\nvoid czm_updatePositionDepth() {\n#if defined(LOG_DEPTH) && !defined(DISABLE_GL_POSITION_LOG_DEPTH)\nvec3 logPositionEC = (czm_inverseProjection * gl_Position).xyz;\n#ifdef SHADOW_MAP\nv_logPositionEC = logPositionEC;\n#endif\n#ifdef ENABLE_GL_POSITION_LOG_DEPTH_AT_HEIGHT\nif (length(logPositionEC) < 2.0e6)\n{\nreturn;\n}\n#endif\ngl_Position.z = log2(max(1e-6, 1.0 + gl_Position.w)) * czm_log2FarDistance - 1.0;\ngl_Position.z *= gl_Position.w;\n#endif\n}\nvoid czm_vertexLogDepth()\n{\n#ifdef LOG_DEPTH\nv_logZ = 1.0 + gl_Position.w;\nczm_updatePositionDepth();\n#endif\n}\nvoid czm_vertexLogDepth(vec4 clipCoords)\n{\n#ifdef LOG_DEPTH\nv_logZ = 1.0 + clipCoords.w;\nczm_updatePositionDepth();\n#endif\n}\n",czm_windowToEyeCoordinates="vec4 czm_windowToEyeCoordinates(vec4 fragmentCoordinate)\n{\nfloat x = 2.0 * (fragmentCoordinate.x - czm_viewport.x) / czm_viewport.z - 1.0;\nfloat y = 2.0 * (fragmentCoordinate.y - czm_viewport.y) / czm_viewport.w - 1.0;\nfloat z = (fragmentCoordinate.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nvec4 q = vec4(x, y, z, 1.0);\nq /= fragmentCoordinate.w;\nif (!(czm_inverseProjection == mat4(0.0)))\n{\nq = czm_inverseProjection * q;\n}\nelse\n{\nfloat top = czm_frustumPlanes.x;\nfloat bottom = czm_frustumPlanes.y;\nfloat left = czm_frustumPlanes.z;\nfloat right = czm_frustumPlanes.w;\nfloat near = czm_currentFrustum.x;\nfloat far = czm_currentFrustum.y;\nq.x = (q.x * (right - left) + left + right) * 0.5;\nq.y = (q.y * (top - bottom) + bottom + top) * 0.5;\nq.z = (q.z * (near - far) - near - far) * 0.5;\nq.w = 1.0;\n}\nreturn q;\n}\nvec4 czm_windowToEyeCoordinates(vec2 fragmentCoordinateXY, float depthOrLogDepth)\n{\n#ifdef LOG_DEPTH\nfloat near = czm_currentFrustum.x;\nfloat far = czm_currentFrustum.y;\nfloat unscaledDepth = pow(2.0, depthOrLogDepth * czm_log2FarPlusOne) - 1.0;\nvec4 windowCoord = vec4(fragmentCoordinateXY, far * (1.0 - near / unscaledDepth) / (far - near), 1.0);\nvec4 eyeCoordinate = czm_windowToEyeCoordinates(windowCoord);\neyeCoordinate.w = 1.0 / unscaledDepth;\n#else\nvec4 windowCoord = vec4(fragmentCoordinateXY, depthOrLogDepth, 1.0);\nvec4 eyeCoordinate = czm_windowToEyeCoordinates(windowCoord);\n#endif\nreturn eyeCoordinate;\n}\n",czm_writeDepthClampedToFarPlane="#ifndef LOG_DEPTH\nvarying float v_WindowZ;\n#endif\nvoid czm_writeDepthClampedToFarPlane()\n{\n#if defined(GL_EXT_frag_depth) && !defined(LOG_DEPTH)\ngl_FragDepthEXT = min(v_WindowZ * gl_FragCoord.w, 1.0);\n#endif\n}\n",czm_writeLogDepth="#ifdef LOG_DEPTH\nvarying float v_logZ;\n#endif\nvoid czm_writeLogDepth(float logZ)\n{\n#if defined(GL_EXT_frag_depth) && defined(LOG_DEPTH) && !defined(DISABLE_LOG_DEPTH_FRAGMENT_WRITE)\nfloat halfLogFarDistance = czm_log2FarDistance * 0.5;\nfloat depth = log2(logZ);\nif (depth < czm_log2NearDistance) {\ndiscard;\n}\ngl_FragDepthEXT = depth * halfLogFarDistance;\n#endif\n}\nvoid czm_writeLogDepth() {\n#ifdef LOG_DEPTH\nczm_writeLogDepth(v_logZ);\n#endif\n}\n",CzmBuiltins={czm_degreesPerRadian:czm_degreesPerRadian,czm_depthRange:czm_depthRange,czm_ellipsoidInverseRadii:czm_ellipsoidInverseRadii,czm_ellipsoidRadii:czm_ellipsoidRadii,czm_epsilon1:czm_epsilon1,czm_epsilon2:czm_epsilon2,czm_epsilon3:czm_epsilon3,czm_epsilon4:czm_epsilon4,czm_epsilon5:czm_epsilon5,czm_epsilon6:czm_epsilon6,czm_epsilon7:czm_epsilon7,czm_infinity:czm_infinity,czm_oneOverPi:czm_oneOverPi,czm_oneOverTwoPi:czm_oneOverTwoPi,czm_passCesium3DTile:czm_passCesium3DTile,czm_passCesium3DTileClassification:czm_passCesium3DTileClassification,czm_passCesium3DTileClassificationIgnoreShow:czm_passCesium3DTileClassificationIgnoreShow,czm_passClassification:czm_passClassification,czm_passCompute:czm_passCompute,czm_passEnvironment:czm_passEnvironment,czm_passGlobe:czm_passGlobe,czm_passOpaque:czm_passOpaque,czm_passOverlay:czm_passOverlay,czm_passTerrainClassification:czm_passTerrainClassification,czm_passTranslucent:czm_passTranslucent,czm_pi:czm_pi,czm_piOverFour:czm_piOverFour,czm_piOverSix:czm_piOverSix,czm_piOverThree:czm_piOverThree,czm_piOverTwo:czm_piOverTwo,czm_radiansPerDegree:czm_radiansPerDegree,czm_sceneMode2D:czm_sceneMode2D,czm_sceneMode3D:czm_sceneMode3D,czm_sceneModeColumbusView:czm_sceneModeColumbusView,czm_sceneModeMorphing:czm_sceneModeMorphing,czm_solarRadius:czm_solarRadius,czm_threePiOver2:czm_threePiOver2,czm_twoPi:czm_twoPi,czm_webMercatorMaxLatitude:czm_webMercatorMaxLatitude,czm_depthRangeStruct:czm_depthRangeStruct,czm_material:czm_material,czm_materialInput:czm_materialInput,czm_ray:czm_ray,czm_raySegment:czm_raySegment,czm_shadowParameters:czm_shadowParameters,czm_HSBToRGB:czm_HSBToRGB,czm_HSLToRGB:czm_HSLToRGB,czm_RGBToHSB:czm_RGBToHSB,czm_RGBToHSL:czm_RGBToHSL,czm_RGBToXYZ:czm_RGBToXYZ,czm_XYZToRGB:czm_XYZToRGB,czm_acesTonemapping:czm_acesTonemapping,czm_alphaWeight:czm_alphaWeight,czm_antialias:czm_antialias,czm_approximateSphericalCoordinates:czm_approximateSphericalCoordinates,czm_branchFreeTernary:czm_branchFreeTernary,czm_cascadeColor:czm_cascadeColor,czm_cascadeDistance:czm_cascadeDistance,czm_cascadeMatrix:czm_cascadeMatrix,czm_cascadeWeights:czm_cascadeWeights,czm_columbusViewMorph:czm_columbusViewMorph,czm_computePosition:czm_computePosition,czm_cosineAndSine:czm_cosineAndSine,czm_decompressTextureCoordinates:czm_decompressTextureCoordinates,czm_depthClampFarPlane:czm_depthClampFarPlane,czm_eastNorthUpToEyeCoordinates:czm_eastNorthUpToEyeCoordinates,czm_ellipsoidContainsPoint:czm_ellipsoidContainsPoint,czm_ellipsoidWgs84TextureCoordinates:czm_ellipsoidWgs84TextureCoordinates,czm_equalsEpsilon:czm_equalsEpsilon,czm_eyeOffset:czm_eyeOffset,czm_eyeToWindowCoordinates:czm_eyeToWindowCoordinates,czm_fastApproximateAtan:czm_fastApproximateAtan,czm_fog:czm_fog,czm_gammaCorrect:czm_gammaCorrect,czm_geodeticSurfaceNormal:czm_geodeticSurfaceNormal,czm_getDefaultMaterial:czm_getDefaultMaterial,czm_getLambertDiffuse:czm_getLambertDiffuse,czm_getSpecular:czm_getSpecular,czm_getWaterNoise:czm_getWaterNoise,czm_hue:czm_hue,czm_inverseGamma:czm_inverseGamma,czm_isEmpty:czm_isEmpty,czm_isFull:czm_isFull,czm_latitudeToWebMercatorFraction:czm_latitudeToWebMercatorFraction,czm_lineDistance:czm_lineDistance,czm_luminance:czm_luminance,czm_metersPerPixel:czm_metersPerPixel,czm_modelToWindowCoordinates:czm_modelToWindowCoordinates,czm_multiplyWithColorBalance:czm_multiplyWithColorBalance,czm_nearFarScalar:czm_nearFarScalar,czm_octDecode:czm_octDecode,czm_packDepth:czm_packDepth,czm_phong:czm_phong,czm_planeDistance:czm_planeDistance,czm_pointAlongRay:czm_pointAlongRay,czm_rayEllipsoidIntersectionInterval:czm_rayEllipsoidIntersectionInterval,czm_readDepth:czm_readDepth,czm_reverseLogDepth:czm_reverseLogDepth,czm_sampleOctahedralProjection:czm_sampleOctahedralProjection,czm_saturation:czm_saturation,czm_shadowDepthCompare:czm_shadowDepthCompare,czm_shadowVisibility:czm_shadowVisibility,czm_signNotZero:czm_signNotZero,czm_sphericalHarmonics:czm_sphericalHarmonics,czm_tangentToEyeSpaceMatrix:czm_tangentToEyeSpaceMatrix,czm_transformPlane:czm_transformPlane,czm_translateRelativeToEye:czm_translateRelativeToEye,czm_translucentPhong:czm_translucentPhong,czm_transpose:czm_transpose,czm_unpackDepth:czm_unpackDepth,czm_unpackFloat:czm_unpackFloat,czm_vertexLogDepth:czm_vertexLogDepth,czm_windowToEyeCoordinates:czm_windowToEyeCoordinates,czm_writeDepthClampedToFarPlane:czm_writeDepthClampedToFarPlane,czm_writeLogDepth:czm_writeLogDepth};function removeComments(e){return(e=e.replace(/\/\/.*/g,"")).replace(/\/\*\*[\s\S]*?\*\//gm,function(e){for(var t=e.match(/\n/gm).length,i="",r=0;r<t;++r)i+="\n";return i})}function getDependencyNode(e,t,i){for(var r,n=0;n<i.length;++n)i[n].name===e&&(r=i[n]);return defined(r)||(r={name:e,glslSource:t=removeComments(t),dependsOn:[],requiredBy:[],evaluated:!1},i.push(r)),r}function generateDependencies(i,r){if(!i.evaluated){i.evaluated=!0;var n=i.glslSource.match(/\bczm_[a-zA-Z0-9_]*/g);defined(n)&&null!==n&&(n=n.filter(function(e,t){return n.indexOf(e)===t})).forEach(function(e){if(e!==i.name&&ShaderSource._czmBuiltinsAndUniforms.hasOwnProperty(e)){var t=getDependencyNode(e,ShaderSource._czmBuiltinsAndUniforms[e],r);i.dependsOn.push(t),t.requiredBy.push(i),generateDependencies(t,r)}})}}function sortDependencies(e){for(var t=[],i=[];0<e.length;){var r=e.pop();i.push(r),0===r.requiredBy.length&&t.push(r)}for(;0<t.length;){var n=t.shift();e.push(n);for(var a=0;a<n.dependsOn.length;++a){var o=n.dependsOn[a],s=o.requiredBy.indexOf(n);o.requiredBy.splice(s,1),0===o.requiredBy.length&&t.push(o)}}for(var l=0;l<i.length;++l)i[l].requiredBy.length}function getBuiltinsAndAutomaticUniforms(e){var t=[],i=getDependencyNode("main",e,t);generateDependencies(i,t),sortDependencies(t);for(var r="",n=t.length-1;0<=n;--n)r=r+t[n].glslSource+"\n";return r.replace(i.glslSource,"")}function combineShader(e,t,i){var r,n,a,o="",s=e.sources;if(defined(s))for(r=0,n=s.length;r<n;++r)o+="\n#line 0\n"+s[r];o=(o=removeComments(o)).replace(/#version\s+(.*?)\n/gm,function(e,t){return a=t,"\n"});var l=[];o=(o=o.replace(/#extension.*\n/gm,function(e){return l.push(e),"\n"})).replace(/precision\s(lowp|mediump|highp)\s(float|int);/,"");var c=e.pickColorQualifier;defined(c)&&(o=ShaderSource.createPickFragmentShaderSource(o,c));var u="";defined(a)&&(u="#version "+a+"\n");var d=l.length;for(r=0;r<d;r++)u+=l[r];t&&(u+="#ifdef GL_FRAGMENT_PRECISION_HIGH\n    precision highp float;\n#else\n    precision mediump float;\n#endif\n\n");var h=e.defines;if(defined(h))for(r=0,n=h.length;r<n;++r){var p=h[r];0!==p.length&&(u+="#define "+p+"\n")}return i.webgl2&&(u+="#define OUTPUT_DECLARATION\n\n"),i.textureFloatLinear&&(u+="#define OES_texture_float_linear\n\n"),e.includeBuiltIns&&(u+=getBuiltinsAndAutomaticUniforms(o)),u+="\n#line 0\n",u+=o,i.webgl2&&(u=modernizeShader(u,t)),u}function ShaderSource(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).pickColorQualifier;this.defines=defined(e.defines)?e.defines.slice(0):[],this.sources=defined(e.sources)?e.sources.slice(0):[],this.pickColorQualifier=t,this.includeBuiltIns=defaultValue(e.includeBuiltIns,!0)}for(var builtinName in ShaderSource.prototype.clone=function(){return new ShaderSource({sources:this.sources,defines:this.defines,pickColorQualifier:this.pickColorQualifier,includeBuiltIns:this.includeBuiltIns})},ShaderSource.replaceMain=function(e,t){return t="void "+t+"()",e.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,t)},ShaderSource.prototype.createCombinedVertexShader=function(e){return combineShader(this,!1,e)},ShaderSource.prototype.createCombinedFragmentShader=function(e){return combineShader(this,!0,e)},ShaderSource._czmBuiltinsAndUniforms={},CzmBuiltins)CzmBuiltins.hasOwnProperty(builtinName)&&(ShaderSource._czmBuiltinsAndUniforms[builtinName]=CzmBuiltins[builtinName]);for(var uniformName in AutomaticUniforms)if(AutomaticUniforms.hasOwnProperty(uniformName)){var uniform=AutomaticUniforms[uniformName];"function"==typeof uniform.getDeclaration&&(ShaderSource._czmBuiltinsAndUniforms[uniformName]=uniform.getDeclaration(uniformName))}ShaderSource.createPickVertexShaderSource=function(e){return ShaderSource.replaceMain(e,"czm_old_main")+"\nattribute vec4 pickColor; \nvarying vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    czm_pickColor = pickColor; \n}"},ShaderSource.createPickFragmentShaderSource=function(e,t){return ShaderSource.replaceMain(e,"czm_old_main")+"\n"+(t+" vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    if (gl_FragColor.a == 0.0) { \n       discard; \n    } \n    gl_FragColor = czm_pickColor; \n}")},ShaderSource.findVarying=function(e,t){for(var i=e.sources,r=t.length,n=0;n<r;++n)for(var a=t[n],o=i.length,s=0;s<o;++s)if(-1!==i[s].indexOf(a))return a};var normalVaryingNames=["v_normalEC","v_normal"];ShaderSource.findNormalVarying=function(e){return ShaderSource.findVarying(e,normalVaryingNames)};var positionVaryingNames=["v_positionEC"];ShaderSource.findPositionVarying=function(e){return ShaderSource.findVarying(e,positionVaryingNames)};var ShadowVolumeAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute float batchId;\n#ifdef EXTRUDED_GEOMETRY\nattribute vec3 extrudeDirection;\nuniform float u_globeMinimumAltitude;\n#endif // EXTRUDED_GEOMETRY\n#ifdef PER_INSTANCE_COLOR\nvarying vec4 v_color;\n#endif // PER_INSTANCE_COLOR\n#ifdef TEXTURE_COORDINATES\n#ifdef SPHERICAL\nvarying vec4 v_sphericalExtents;\n#else // SPHERICAL\nvarying vec2 v_inversePlaneExtents;\nvarying vec4 v_westPlane;\nvarying vec4 v_southPlane;\n#endif // SPHERICAL\nvarying vec3 v_uvMinAndSphericalLongitudeRotation;\nvarying vec3 v_uMaxAndInverseDistance;\nvarying vec3 v_vMaxAndInverseDistance;\n#endif // TEXTURE_COORDINATES\n#if defined(TEXTURE_COORDINATES) && !defined(SPHERICAL) && defined(UINT8_PACKING)\nvec4 clampAndMagnitude(vec4 sd)\n{\nvec4 d = sd;\nd.x = czm_branchFreeTernary(sd.x < 128.0, d.x, (255.0 - sd.x));\nd.x = floor(0.5 + d.x);\nd.y = floor(0.5 + d.y);\nd.z = floor(0.5 + d.z);\nd.w = floor(0.5 + d.w);\nreturn d;\n}\nfloat unpackLowLessThan100k(vec4 sd)\n{\nvec4 d = clampAndMagnitude(sd);\nreturn (1000.0 * d.x + 10.0 * d.y + 0.1 * d.z + 0.001 * d.w) * czm_branchFreeTernary(sd.x < 128.0, 1.0, -1.0);\n}\nvec3 southwest_LOW(vec4 x, vec4 y, vec4 z)\n{\nvec3 value;\nvalue.x = unpackLowLessThan100k(x);\nvalue.y = unpackLowLessThan100k(y);\nvalue.z = unpackLowLessThan100k(z);\nreturn value;\n}\nfloat unpackHighMagLessThan100Million(vec4 sd)\n{\nvec4 d = clampAndMagnitude(sd);\nreturn (1000000.0 * d.x + 10000.0 * d.y + 100.0 * d.z + d.w) * czm_branchFreeTernary(sd.x < 128.0, 1.0, -1.0);\n}\nvec3 southwest_HIGH(vec4 x, vec4 y, vec4 z)\n{\nvec3 value;\nvalue.x = unpackHighMagLessThan100Million(x);\nvalue.y = unpackHighMagLessThan100Million(y);\nvalue.z = unpackHighMagLessThan100Million(z);\nreturn value;\n}\n#ifdef COLUMBUS_VIEW_2D\nvec4 unpackPlanes2D_HIGH(vec4 x, vec4 y, vec4 z, vec4 w)\n{\nvec4 value;\nvalue.x = unpackHighMagLessThan100Million(x);\nvalue.y = unpackHighMagLessThan100Million(y);\nvalue.z = unpackHighMagLessThan100Million(z);\nvalue.w = unpackHighMagLessThan100Million(w);\nreturn value;\n}\nvec4 unpackPlanes2D_LOW(vec4 x, vec4 y, vec4 z, vec4 w)\n{\nvec4 value;\nvalue.x = unpackLowLessThan100k(x);\nvalue.y = unpackLowLessThan100k(y);\nvalue.z = unpackLowLessThan100k(z);\nvalue.w = unpackLowLessThan100k(w);\nreturn value;\n}\n#else\nfloat unpackLowLessThan1000k(vec4 sd)\n{\nvec4 d = clampAndMagnitude(sd);\nreturn (10000.0 * d.x + 100.0 * d.y + d.z + 0.01 * d.w) * czm_branchFreeTernary(sd.x < 128.0, 1.0, -1.0);\n}\nvec3 unpackExtent(vec4 x, vec4 y, vec4 z)\n{\nvec3 value;\nvalue.x = unpackLowLessThan1000k(x);\nvalue.y = unpackLowLessThan1000k(y);\nvalue.z = unpackLowLessThan1000k(z);\nreturn value;\n}\n#endif\n#endif\nvoid main()\n{\nvec4 position = czm_computePosition();\n#ifdef EXTRUDED_GEOMETRY\nfloat delta = min(u_globeMinimumAltitude, czm_geometricToleranceOverMeter * length(position.xyz));\ndelta *= czm_sceneMode == czm_sceneMode3D ? 1.0 : 0.0;\nposition = position + vec4(extrudeDirection * delta, 0.0);\n#endif\n#ifdef TEXTURE_COORDINATES\n#ifdef SPHERICAL\nv_sphericalExtents = czm_batchTable_sphericalExtents(batchId);\nv_uvMinAndSphericalLongitudeRotation.z = czm_batchTable_longitudeRotation(batchId);\n#else // SPHERICAL\n#ifdef COLUMBUS_VIEW_2D\n#ifdef UINT8_PACKING\nvec4 planes2D_high = unpackPlanes2D_HIGH(czm_batchTable_planes2D_HIGH_x(batchId),\nczm_batchTable_planes2D_HIGH_y(batchId),\nczm_batchTable_planes2D_HIGH_z(batchId),\nczm_batchTable_planes2D_HIGH_w(batchId));\nvec4 planes2D_low = unpackPlanes2D_LOW(czm_batchTable_planes2D_LOW_x(batchId),\nczm_batchTable_planes2D_LOW_y(batchId),\nczm_batchTable_planes2D_LOW_z(batchId),\nczm_batchTable_planes2D_LOW_w(batchId));\n#else // UINT8_PACKING\nvec4 planes2D_high = czm_batchTable_planes2D_HIGH(batchId);\nvec4 planes2D_low = czm_batchTable_planes2D_LOW(batchId);\n#endif // UINT8_PACKING\nvec2 idlSplitNewPlaneHiLow = vec2(EAST_MOST_X_HIGH - (WEST_MOST_X_HIGH - planes2D_high.w), EAST_MOST_X_LOW - (WEST_MOST_X_LOW - planes2D_low.w));\nbool idlSplit = planes2D_high.x > planes2D_high.w && position3DLow.y > 0.0;\nplanes2D_high.w = czm_branchFreeTernary(idlSplit, idlSplitNewPlaneHiLow.x, planes2D_high.w);\nplanes2D_low.w = czm_branchFreeTernary(idlSplit, idlSplitNewPlaneHiLow.y, planes2D_low.w);\nidlSplit = planes2D_high.x > planes2D_high.w && position3DLow.y < 0.0;\nidlSplitNewPlaneHiLow = vec2(WEST_MOST_X_HIGH - (EAST_MOST_X_HIGH - planes2D_high.x), WEST_MOST_X_LOW - (EAST_MOST_X_LOW - planes2D_low.x));\nplanes2D_high.x = czm_branchFreeTernary(idlSplit, idlSplitNewPlaneHiLow.x, planes2D_high.x);\nplanes2D_low.x = czm_branchFreeTernary(idlSplit, idlSplitNewPlaneHiLow.y, planes2D_low.x);\nvec3 southWestCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(vec3(0.0, planes2D_high.xy), vec3(0.0, planes2D_low.xy))).xyz;\nvec3 northWestCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(vec3(0.0, planes2D_high.x, planes2D_high.z), vec3(0.0, planes2D_low.x, planes2D_low.z))).xyz;\nvec3 southEastCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(vec3(0.0, planes2D_high.w, planes2D_high.y), vec3(0.0, planes2D_low.w, planes2D_low.y))).xyz;\n#else // COLUMBUS_VIEW_2D\n#ifdef UINT8_PACKING\nvec3 low = southwest_LOW(czm_batchTable_southWest_LOW_x(batchId), czm_batchTable_southWest_LOW_y(batchId), czm_batchTable_southWest_LOW_z(batchId));\nvec3 high = southwest_HIGH(czm_batchTable_southWest_HIGH_x(batchId), czm_batchTable_southWest_HIGH_y(batchId), czm_batchTable_southWest_HIGH_z(batchId));\nvec3 southWestCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(high, low)).xyz;\nvec3 northWestCorner = czm_normal * unpackExtent(\nczm_batchTable_northward_x(batchId),\nczm_batchTable_northward_y(batchId),\nczm_batchTable_northward_z(batchId)) + southWestCorner;\nvec3 southEastCorner = czm_normal * unpackExtent(\nczm_batchTable_eastward_x(batchId),\nczm_batchTable_eastward_y(batchId),\nczm_batchTable_eastward_z(batchId)) + southWestCorner;\n#else // UINT8_PACKING\nvec3 southWestCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(czm_batchTable_southWest_HIGH(batchId), czm_batchTable_southWest_LOW(batchId))).xyz;\nvec3 northWestCorner = czm_normal * czm_batchTable_northward(batchId) + southWestCorner;\nvec3 southEastCorner = czm_normal * czm_batchTable_eastward(batchId) + southWestCorner;\n#endif // UINT8_PACKING\n#endif // COLUMBUS_VIEW_2D\nvec3 eastWard = southEastCorner - southWestCorner;\nfloat eastExtent = length(eastWard);\neastWard /= eastExtent;\nvec3 northWard = northWestCorner - southWestCorner;\nfloat northExtent = length(northWard);\nnorthWard /= northExtent;\nv_westPlane = vec4(eastWard, -dot(eastWard, southWestCorner));\nv_southPlane = vec4(northWard, -dot(northWard, southWestCorner));\nv_inversePlaneExtents = vec2(1.0 / eastExtent, 1.0 / northExtent);\n#endif // SPHERICAL\nvec4 uvMinAndExtents = czm_batchTable_uvMinAndExtents(batchId);\nvec4 uMaxVmax = czm_batchTable_uMaxVmax(batchId);\nv_uMaxAndInverseDistance = vec3(uMaxVmax.xy, uvMinAndExtents.z);\nv_vMaxAndInverseDistance = vec3(uMaxVmax.zw, uvMinAndExtents.w);\nv_uvMinAndSphericalLongitudeRotation.xy = uvMinAndExtents.xy;\n#endif // TEXTURE_COORDINATES\n#ifdef PER_INSTANCE_COLOR\nv_color = czm_batchTable_color(batchId);\n#endif\ngl_Position = czm_depthClampFarPlane(czm_modelViewProjectionRelativeToEye * position);\n}\n",ShadowVolumeFS="#ifdef GL_EXT_frag_depth\n#extension GL_EXT_frag_depth : enable\n#endif\n#ifdef VECTOR_TILE\nuniform vec4 u_highlightColor;\n#endif\nvoid main(void)\n{\n#ifdef VECTOR_TILE\ngl_FragColor = czm_gammaCorrect(u_highlightColor);\n#else\ngl_FragColor = vec4(1.0);\n#endif\nczm_writeDepthClampedToFarPlane();\n}\n",ClassificationType={TERRAIN:0,CESIUM_3D_TILE:1,BOTH:2,NUMBER_OF_CLASSIFICATION_TYPES:3},ClassificationType$1=freezeObject$1(ClassificationType),DepthFunction={NEVER:WebGLConstants$1.NEVER,LESS:WebGLConstants$1.LESS,EQUAL:WebGLConstants$1.EQUAL,LESS_OR_EQUAL:WebGLConstants$1.LEQUAL,GREATER:WebGLConstants$1.GREATER,NOT_EQUAL:WebGLConstants$1.NOTEQUAL,GREATER_OR_EQUAL:WebGLConstants$1.GEQUAL,ALWAYS:WebGLConstants$1.ALWAYS},DepthFunction$1=freezeObject$1(DepthFunction),BufferUsage={STREAM_DRAW:WebGLConstants$1.STREAM_DRAW,STATIC_DRAW:WebGLConstants$1.STATIC_DRAW,DYNAMIC_DRAW:WebGLConstants$1.DYNAMIC_DRAW,validate:function(e){return e===BufferUsage.STREAM_DRAW||e===BufferUsage.STATIC_DRAW||e===BufferUsage.DYNAMIC_DRAW}},BufferUsage$1=freezeObject$1(BufferUsage);function Buffer$1(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context._gl,i=e.bufferTarget,r=e.typedArray,n=e.sizeInBytes,a=e.usage,o=defined(r);o&&(n=r.byteLength);var s=t.createBuffer();t.bindBuffer(i,s),t.bufferData(i,o?r:n,a),t.bindBuffer(i,null),this._gl=t,this._webgl2=e.context._webgl2,this._bufferTarget=i,this._sizeInBytes=n,this._usage=a,this._buffer=s,this.vertexArrayDestroyable=!0}function addAttribute(e,t,i,r){var n=defined(t.vertexBuffer),a=defined(t.value),o=t.value?t.value.length:t.componentsPerAttribute,s={index:defaultValue(t.index,i),enabled:defaultValue(t.enabled,!0),vertexBuffer:t.vertexBuffer,value:a?t.value.slice(0):void 0,componentsPerAttribute:o,componentDatatype:defaultValue(t.componentDatatype,ComponentDatatype$1.FLOAT),normalize:defaultValue(t.normalize,!1),offsetInBytes:defaultValue(t.offsetInBytes,0),strideInBytes:defaultValue(t.strideInBytes,0),instanceDivisor:defaultValue(t.instanceDivisor,0)};if(n)s.vertexAttrib=function(e){var t=this.index;e.bindBuffer(e.ARRAY_BUFFER,this.vertexBuffer._getBuffer()),e.vertexAttribPointer(t,this.componentsPerAttribute,this.componentDatatype,this.normalize,this.strideInBytes,this.offsetInBytes),e.enableVertexAttribArray(t),0<this.instanceDivisor&&(r.glVertexAttribDivisor(t,this.instanceDivisor),r._vertexAttribDivisors[t]=this.instanceDivisor,r._previousDrawInstanced=!0)},s.disableVertexAttribArray=function(e){e.disableVertexAttribArray(this.index),0<this.instanceDivisor&&r.glVertexAttribDivisor(i,0)};else{switch(s.componentsPerAttribute){case 1:s.vertexAttrib=function(e){e.vertexAttrib1fv(this.index,this.value)};break;case 2:s.vertexAttrib=function(e){e.vertexAttrib2fv(this.index,this.value)};break;case 3:s.vertexAttrib=function(e){e.vertexAttrib3fv(this.index,this.value)};break;case 4:s.vertexAttrib=function(e){e.vertexAttrib4fv(this.index,this.value)}}s.disableVertexAttribArray=function(e){}}e.push(s)}function bind(e,t,i){for(var r=0;r<t.length;++r){var n=t[r];n.enabled&&n.vertexAttrib(e)}defined(i)&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,i._getBuffer())}function VertexArray(e){var t,i,r=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,n=r._gl,a=e.attributes,o=e.indexBuffer,s=[],l=1,c=!1,u=!1,d=a.length;for(t=0;t<d;++t)addAttribute(s,a[t],t,r);for(d=s.length,t=0;t<d;++t){var h=s[t];if(defined(h.vertexBuffer)&&0===h.instanceDivisor){var p=h.strideInBytes||h.componentsPerAttribute*ComponentDatatype$1.getSizeInBytes(h.componentDatatype);l=h.vertexBuffer.sizeInBytes/p;break}}for(t=0;t<d;++t)0<s[t].instanceDivisor&&(c=!0),defined(s[t].value)&&(u=!0);r.vertexArrayObject&&(i=r.glCreateVertexArray(),r.glBindVertexArray(i),bind(n,s,o),r.glBindVertexArray(null)),this._numberOfVertices=l,this._hasInstancedAttributes=c,this._hasConstantAttributes=u,this._context=r,this._gl=n,this._vao=i,this._attributes=s,this._indexBuffer=o}function computeNumberOfVertices(e){return e.values.length/e.componentsPerAttribute}function computeAttributeSizeInBytes(e){return ComponentDatatype$1.getSizeInBytes(e.componentDatatype)*e.componentsPerAttribute}function interleaveAttributes(i){var e,t,r,n,a=[];for(t in i)i.hasOwnProperty(t)&&defined(i[t])&&defined(i[t].values)&&(a.push(t),i[t].componentDatatype===ComponentDatatype$1.DOUBLE&&(i[t].componentDatatype=ComponentDatatype$1.FLOAT,i[t].values=ComponentDatatype$1.createTypedArray(ComponentDatatype$1.FLOAT,i[t].values)));var o=a.length;if(0<o)for(n=computeNumberOfVertices(i[a[0]]),e=1;e<o;++e){var s=computeNumberOfVertices(i[a[e]]);if(s!==n)throw new RuntimeError("Each attribute list must have the same number of vertices.  Attribute "+a[e]+" has a different number of vertices ("+s.toString()+") than attribute "+a[0]+" ("+n.toString()+").")}a.sort(function(e,t){return ComponentDatatype$1.getSizeInBytes(i[t].componentDatatype)-ComponentDatatype$1.getSizeInBytes(i[e].componentDatatype)});var l=0,c={};for(e=0;e<o;++e)t=a[e],r=i[t],c[t]=l,l+=computeAttributeSizeInBytes(r);if(0<l){var u=ComponentDatatype$1.getSizeInBytes(i[a[0]].componentDatatype),d=l%u;0!=d&&(l+=u-d);var h=new ArrayBuffer(n*l),p={};for(e=0;e<o;++e){t=a[e];var m=ComponentDatatype$1.getSizeInBytes(i[t].componentDatatype);p[t]={pointer:ComponentDatatype$1.createTypedArray(i[t].componentDatatype,h),index:c[t]/m,strideInComponentType:l/m}}for(e=0;e<n;++e)for(var f=0;f<o;++f){t=a[f];for(var g=(r=i[t]).values,_=p[t],y=_.pointer,v=r.componentsPerAttribute,C=0;C<v;++C)y[_.index+C]=g[e*v+C];_.index+=_.strideInComponentType}return{buffer:h,offsetsInBytes:c,vertexSizeInBytes:l}}}function setVertexAttribDivisor(e){var t=e._context,i=e._hasInstancedAttributes;if(i||t._previousDrawInstanced){t._previousDrawInstanced=i;var r,n=t._vertexAttribDivisors,a=e._attributes,o=ContextLimits.maximumVertexAttributes;if(i){var s=a.length;for(r=0;r<s;++r){var l=a[r];if(l.enabled){var c=l.instanceDivisor,u=l.index;c!==n[u]&&(t.glVertexAttribDivisor(u,c),n[u]=c)}}}else for(r=0;r<o;++r)0<n[r]&&(t.glVertexAttribDivisor(r,0),n[r]=0)}}function setConstantAttributes(e,t){for(var i=e._attributes,r=i.length,n=0;n<r;++n){var a=i[n];a.enabled&&defined(a.value)&&a.vertexAttrib(t)}}function BatchTable(e,t,i){if(this._attributes=t,this._numberOfInstances=i,0!==t.length){var r=getDatatype(t),n=e.floatingPointTexture,a=r===PixelDatatype$1.FLOAT&&!n,o=createOffsets(t,a),s=getStride(o,t,a),l=Math.floor(ContextLimits.maximumTextureSize/s),c=Math.min(i,l),u=s*c,d=Math.ceil(i/c),h=1/u,p=.5*h,m=1/d,f=.5*m;this._textureDimensions=new Cartesian2(u,d),this._textureStep=new Cartesian4(h,p,m,f),this._pixelDatatype=a?PixelDatatype$1.UNSIGNED_BYTE:r,this._packFloats=a,this._offsets=o,this._stride=s,this._texture=void 0;var g=4*u*d;this._batchValues=r!==PixelDatatype$1.FLOAT||a?new Uint8Array(g):new Float32Array(g),this._batchValuesDirty=!1}}function getDatatype(e){for(var t=!1,i=e.length,r=0;r<i;++r)if(e[r].componentDatatype!==ComponentDatatype$1.UNSIGNED_BYTE){t=!0;break}return t?PixelDatatype$1.FLOAT:PixelDatatype$1.UNSIGNED_BYTE}function getAttributeType(e,t){var i=e[t].componentsPerAttribute;return 2===i?Cartesian2:3===i?Cartesian3:4===i?Cartesian4:Number}function createOffsets(e,t){for(var i=new Array(e.length),r=0,n=e.length,a=0;a<n;++a){var o=e[a].componentDatatype;i[a]=r,o!==ComponentDatatype$1.UNSIGNED_BYTE&&t?r+=4:++r}return i}function getStride(e,t,i){var r=e.length,n=e[r-1];return t[r-1].componentDatatype!==ComponentDatatype$1.UNSIGNED_BYTE&&i?n+4:n+1}Buffer$1.createVertexBuffer=function(e){return new Buffer$1({context:e.context,bufferTarget:WebGLConstants$1.ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage})},Buffer$1.createIndexBuffer=function(e){var t=e.context,i=e.indexDatatype,r=IndexDatatype$1.getSizeInBytes(i),n=new Buffer$1({context:t,bufferTarget:WebGLConstants$1.ELEMENT_ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage}),a=n.sizeInBytes/r;return defineProperties$1(n,{indexDatatype:{get:function(){return i}},bytesPerIndex:{get:function(){return r}},numberOfIndices:{get:function(){return a}}}),n},defineProperties$1(Buffer$1.prototype,{sizeInBytes:{get:function(){return this._sizeInBytes}},usage:{get:function(){return this._usage}}}),Buffer$1.prototype._getBuffer=function(){return this._buffer},Buffer$1.prototype.copyFromArrayView=function(e,t){t=defaultValue(t,0);var i=this._gl,r=this._bufferTarget;i.bindBuffer(r,this._buffer),i.bufferSubData(r,t,e),i.bindBuffer(r,null)},Buffer$1.prototype.copyFromBuffer=function(e,t,i,r){var n=WebGLConstants$1.COPY_READ_BUFFER,a=WebGLConstants$1.COPY_WRITE_BUFFER,o=this._gl;o.bindBuffer(a,this._buffer),o.bindBuffer(n,e._buffer),o.copyBufferSubData(n,a,t,i,r),o.bindBuffer(a,null),o.bindBuffer(n,null)},Buffer$1.prototype.getBufferData=function(e,t,i,r){t=defaultValue(t,0),i=defaultValue(i,0);var n=this._gl,a=WebGLConstants$1.COPY_READ_BUFFER;n.bindBuffer(a,this._buffer),n.getBufferSubData(a,t,e,i,r),n.bindBuffer(a,null)},Buffer$1.prototype.isDestroyed=function(){return!1},Buffer$1.prototype.destroy=function(){return this._gl.deleteBuffer(this._buffer),destroyObject(this)},VertexArray.fromGeometry=function(e){var t,i,r,n,a=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,o=defaultValue(e.geometry,defaultValue.EMPTY_OBJECT),s=defaultValue(e.bufferUsage,BufferUsage$1.DYNAMIC_DRAW),l=defaultValue(e.attributeLocations,defaultValue.EMPTY_OBJECT),c=defaultValue(e.interleave,!1),u=e.vertexArrayAttributes,d=defined(u)?u:[],h=o.attributes;if(c){var p=interleaveAttributes(h);if(defined(p)){r=Buffer$1.createVertexBuffer({context:a,typedArray:p.buffer,usage:s});var m=p.offsetsInBytes,f=p.vertexSizeInBytes;for(t in h)h.hasOwnProperty(t)&&defined(h[t])&&(defined((i=h[t]).values)?d.push({index:l[t],vertexBuffer:r,componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,offsetInBytes:m[t],strideInBytes:f}):d.push({index:l[t],value:i.value,componentDatatype:i.componentDatatype,normalize:i.normalize}))}}else for(t in h)if(h.hasOwnProperty(t)&&defined(h[t])){var g=(i=h[t]).componentDatatype;g===ComponentDatatype$1.DOUBLE&&(g=ComponentDatatype$1.FLOAT),r=void 0,defined(i.values)&&(r=Buffer$1.createVertexBuffer({context:a,typedArray:ComponentDatatype$1.createTypedArray(g,i.values),usage:s})),d.push({index:l[t],vertexBuffer:r,value:i.value,componentDatatype:g,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize})}var _=o.indices;return defined(_)&&(n=Geometry.computeNumberOfVertices(o)>=CesiumMath.SIXTY_FOUR_KILOBYTES&&a.elementIndexUint?Buffer$1.createIndexBuffer({context:a,typedArray:new Uint32Array(_),usage:s,indexDatatype:IndexDatatype$1.UNSIGNED_INT}):Buffer$1.createIndexBuffer({context:a,typedArray:new 