/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;

class FieldCapabilitiesNodeResponse
extends ActionResponse
implements Writeable {
    private final List<FieldCapabilitiesIndexResponse> indexResponses;
    private final Map<ShardId, Exception> failures;
    private final Set<ShardId> unmatchedShardIds;

    FieldCapabilitiesNodeResponse(List<FieldCapabilitiesIndexResponse> indexResponses, Map<ShardId, Exception> failures, Set<ShardId> unmatchedShardIds) {
        this.indexResponses = Objects.requireNonNull(indexResponses);
        this.failures = Objects.requireNonNull(failures);
        this.unmatchedShardIds = Objects.requireNonNull(unmatchedShardIds);
    }

    FieldCapabilitiesNodeResponse(StreamInput in) throws IOException {
        super(in);
        IndexFieldCapabilities.Deduplicator fieldDeduplicator = new IndexFieldCapabilities.Deduplicator();
        this.indexResponses = in.readList(is -> new FieldCapabilitiesIndexResponse(is, fieldDeduplicator));
        this.failures = in.readMap(ShardId::new, StreamInput::readException);
        this.unmatchedShardIds = in.readSet(ShardId::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.indexResponses);
        out.writeMap(this.failures, (o, v) -> v.writeTo(o), StreamOutput::writeException);
        out.writeCollection(this.unmatchedShardIds);
    }

    public Map<ShardId, Exception> getFailures() {
        return this.failures;
    }

    public List<FieldCapabilitiesIndexResponse> getIndexResponses() {
        return this.indexResponses;
    }

    public Set<ShardId> getUnmatchedShardIds() {
        return this.unmatchedShardIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesNodeResponse that = (FieldCapabilitiesNodeResponse)o;
        return Objects.equals(this.indexResponses, that.indexResponses) && Objects.equals(this.failures, that.failures) && this.unmatchedShardIds.equals(that.unmatchedShardIds);
    }

    public int hashCode() {
        return Objects.hash(this.indexResponses, this.failures, this.unmatchedShardIds);
    }
}

