/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.session.infinispan.QueryManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;

public class RemoteQueryManager
implements QueryManager {
    private RemoteCache<String, SessionData> _cache;
    private QueryFactory _factory;

    public RemoteQueryManager(RemoteCache<String, SessionData> cache) {
        this._cache = cache;
        this._factory = Search.getQueryFactory(this._cache);
    }

    public Set<String> queryExpiredSessions(long time) {
        Query expiredQuery = this._factory.create("select id from org_eclipse_jetty_session_infinispan.InfinispanSessionData where expiry <= :expiry and expiry > 0");
        expiredQuery.setParameter("expiry", (Object)time);
        QueryResult result = expiredQuery.execute();
        List list = result.list();
        Set<String> ids = list.stream().map(a -> (String)a[0]).collect(Collectors.toSet());
        return ids;
    }

    public Set<String> queryExpiredSessions() {
        return this.queryExpiredSessions(System.currentTimeMillis());
    }
}

