/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.fao.geonet.repository.PathSpec;
import org.springframework.data.jpa.domain.Specification;

public class BatchUpdateQuery<T> {
    private final Class<T> _entityClass;
    private final EntityManager _entityManager;
    private final List<PathSpec<T, ?>> _paths = new ArrayList();
    private final List<Object> _values = new ArrayList<Object>();
    private Specification<T> _specification;

    <V> BatchUpdateQuery(@Nonnull Class<T> entityClass, @Nonnull EntityManager entityManager, @Nonnull PathSpec<T, V> pathSpec, @Nullable V newValue) {
        this._entityClass = entityClass;
        this._entityManager = entityManager;
        this._paths.add(pathSpec);
        this._values.add(newValue);
    }

    public <V> BatchUpdateQuery<T> add(@Nonnull PathSpec<T, V> pathSpec, @Nullable V newValue) {
        this._paths.add(pathSpec);
        this._values.add(newValue);
        return this;
    }

    public int execute() {
        int updated = 0;
        this._entityManager.flush();
        this._entityManager.clear();
        for (int i = 0; i < this._paths.size(); ++i) {
            CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
            CriteriaUpdate update = cb.createCriteriaUpdate(this._entityClass);
            Root root = update.from(this._entityClass);
            Path<?> path = this._paths.get(i).getPath(root);
            Object value = this._values.get(i);
            update.set(path, value);
            if (this._specification != null) {
                update.where((Expression)this._specification.toPredicate(root, null, cb));
            }
            updated = Math.max(updated, this._entityManager.createQuery(update).executeUpdate());
        }
        this._entityManager.flush();
        this._entityManager.clear();
        return updated;
    }

    public BatchUpdateQuery<T> setSpecification(@Nonnull Specification<T> specification) {
        this._specification = specification;
        return this;
    }
}

