/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;

public enum SettingDataType {
    STRING{

        @Override
        public boolean validate(String value) {
            return true;
        }
    }
    ,
    INT{

        @Override
        public boolean validate(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
    ,
    BOOLEAN{

        @Override
        public boolean validate(String value) {
            try {
                Boolean.parseBoolean(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
    ,
    JSON{

        @Override
        public boolean validate(String json) {
            try {
                JsonParser parser = new ObjectMapper().getJsonFactory().createJsonParser(json);
                while (parser.nextToken() != null) {
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    };


    public abstract boolean validate(String var1);
}

