/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.LongCollection;
import bak.pcj.adapter.CollectionToLongCollectionAdapter;
import bak.pcj.adapter.SetToIntSetAdapter;
import bak.pcj.map.AbstractIntKeyLongMap;
import bak.pcj.map.IntKeyLongMap;
import bak.pcj.map.IntKeyLongMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.IntSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToIntKeyLongMapAdapter
extends AbstractIntKeyLongMap
implements IntKeyLongMap {
    protected Map map;
    protected Long lastValue;

    public MapToIntKeyLongMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToIntKeyLongMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(int key) {
        this.lastValue = (Long)this.map.get(new Integer(key));
        return this.lastValue != null;
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(new Long(value));
    }

    public IntKeyLongMapIterator entries() {
        return new IntKeyLongMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToIntKeyLongMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public int getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Integer)this.lastEntry.getKey();
            }

            public long getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Long)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public long get(int key) {
        Long value = (Long)this.map.get(new Integer(key));
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public IntSet keySet() {
        return new SetToIntSetAdapter(this.map.keySet());
    }

    public long lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public long put(int key, long value) {
        Long oldValue = this.map.put(new Integer(key), new Long(value));
        return oldValue == null ? MapDefaults.defaultLong() : oldValue;
    }

    public long remove(int key) {
        Long value = (Long)this.map.remove(new Integer(key));
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public int size() {
        return this.map.size();
    }

    public LongCollection values() {
        return new CollectionToLongCollectionAdapter(this.map.values());
    }

    public long tget(int key) {
        Long value = (Long)this.map.get(new Integer(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isIntKeyLongAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

