/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactWriter;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintOp1;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.validation.ValidationProc;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.util.FmtUtils;

public class ShNode
extends ConstraintOp1 {
    public ShNode(Shape other) {
        super(other);
    }

    @Override
    public Node getComponent() {
        return SHACL.NodeConstraintComponent;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Graph data, Node node) {
        ValidationContext vCxt2 = ValidationContext.create(vCxt);
        ValidationProc.execValidateShape(vCxt2, data, this.other, node);
        boolean innerConforms = vCxt2.generateReport().conforms();
        if (innerConforms) {
            return null;
        }
        String msg = this.toString() + " at focusNode " + ShLib.displayStr(node);
        return new ReportItem(msg, node);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        if (this.other.getShapeNode().isURI()) {
            out.print("@");
            nodeFmt.format((AWriter)out, this.other.getShapeNode());
            return;
        }
        out.print("{ ");
        out.incIndent();
        out.println();
        CompactWriter.output(out, nodeFmt, this.other);
        out.decIndent();
        out.println(" }");
    }

    public String toString() {
        return "Node[" + FmtUtils.stringForNode((Node)this.other.getShapeNode()) + "]";
    }
}

